/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.MonthClose;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.clear.ClearBillGenerateFacade;
import kd.fi.fa.business.depretask.DepreStatusEnum2;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.periodclose.PeriodAutoCloseSingleHandler;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizCtrServiceUtils;
import kd.fi.fa.business.utils.FaBizCtrSource;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;

public class MonthCloseCenterOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MonthCloseCenterOpPlugin.class);
    private Date beginDate;
    private DynamicObject assetBook;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("depreuse");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.beginDate = new Date();
        DynamicObject fakeAssetBook = this.getFakeAssetBook(e);
        try {
            long orgID = (Long)fakeAssetBook.getDynamicObject("org").getPkValue();
            long typeID = fakeAssetBook.get("depreuse") instanceof DynamicObject ? (Long)fakeAssetBook.getDynamicObject("depreuse").getPkValue() : Long.parseLong(fakeAssetBook.get("depreuse").toString());
            QFilter org = new QFilter("org", "=", (Object)orgID);
            QFilter type = new QFilter("depreuse", "=", (Object)typeID);
            this.assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id", (QFilter[])new QFilter[]{org, type});
            long bookID = this.assetBook.getLong("id");
            this.assetBook = BusinessDataServiceHelper.loadSingle((Object)bookID, (String)"fa_assetbook");
            String closeCacheKey = this.getCloseCacheKey();
            Map result = new PeriodAutoCloseSingleHandler((AbstractOperationServicePlugIn)this).forCenter(this.assetBook, closeCacheKey);
            if (result.containsKey(Exception.class)) {
                Exception ex = this.getValue(Exception.class, result);
                this.operationResult.setMessage(Fa.fetchStackTrace((Exception)ex));
                throw ex;
            }
            Boolean success = this.getValue(Boolean.class, result);
            this.operationResult.setSuccess(success.booleanValue());
            if (!success.booleanValue()) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setPkValue((Object)bookID);
                errorInfo.setMessage("");
                errorInfo.setErrorLevel(ErrorLevel.Error.name());
                this.operationResult.addErrorInfo(errorInfo);
            }
        }
        catch (Exception ex) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(ex.getMessage());
            errorInfo.setErrorLevel(ErrorLevel.Error.name());
            this.operationResult.addErrorInfo(errorInfo);
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    DynamicObject getFakeAssetBook(BeginOperationTransactionArgs e) {
        DynamicObject fakeAssetBook = e.getDataEntities()[0];
        return fakeAssetBook;
    }

    private String getCloseCacheKey() {
        String closeCacheKey = null;
        if (this.operateOption.containsVariable("closeCacheKey")) {
            closeCacheKey = this.operateOption.getVariableValue("closeCacheKey");
        }
        return closeCacheKey;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DepreStatusEnum2 status = DepreStatusEnum2.SUC;
        String message = ResManager.loadKDString((String)"\u6210\u529f", (String)"MonthCloseCenterOpPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        if (this.operationResult.getMessage() != null) {
            message = this.operationResult.getMessage();
            this.operationResult.setMessage(null);
            status = DepreStatusEnum2.FAI;
        }
        String prams = "MonthCloseCenterOpPlugin -> " + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7: %1$s, \u6298\u65e7\u7528\u9014\uff1a%2$s, \u671f\u95f4\uff1a%3$s", (String)"MonthCloseCenterOpPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), this.assetBook.getString(Fa.dot((String[])new String[]{"org", "id"})), this.assetBook.getString(Fa.dot((String[])new String[]{"depreuse", "id"})), this.assetBook.getString(Fa.dot((String[])new String[]{"curperiod", "id"})));
        FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo(this.assetBook.getString(Fa.dot((String[])new String[]{"org", "name"})), this.assetBook.getString(Fa.dot((String[])new String[]{"depreuse", "name"})), this.assetBook.getString("name"), this.assetBook.getString(Fa.dot((String[])new String[]{"curperiod", "name"})), Integer.valueOf(0), "fa_periodclosebill", prams, FaOperationOpTypeEnum.PERIODCLOSE);
        if (status.getValue().equals(DepreStatusEnum2.SUC.getValue())) {
            FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertPo, (FaOperationStatusEnum)FaOperationStatusEnum.SUCCESS, null);
        } else {
            FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertPo, (FaOperationStatusEnum)FaOperationStatusEnum.FAILED, (String)message);
        }
        if (this.assetBook.getBoolean("ismainbook")) {
            this.assetBookCloseUpdateLeaseInit();
        }
        if (this.operationResult.isSuccess()) {
            if (TX.inTX()) {
                TX.addCommitListener((CommitListener)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.genClearBill();
            }
        }
    }

    private void genClearBill() {
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"curperiod.begindate begindate, curperiod.enddate enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", this.assetBook.getPkValue())});
        if (book != null) {
            boolean genClearBillByApplyDate = FaBillParamUtils.getBooleanValue(null, null, null, (String)"genclearbill_datetype");
            String cmpDataKey = "auditdate";
            if (genClearBillByApplyDate) {
                cmpDataKey = "cleardate";
            }
            String selectFields = Fa.comma((String[])new String[]{"id", "billno", Fa.dot((String[])new String[]{"clrapplybill_entry", "realcard"}), Fa.dot((String[])new String[]{"clrapplybill_entry", "realcard", "masterid"}), "isgenclearbill"});
            Date begindate = book.getDate("begindate");
            Date enddate = book.getDate("enddate");
            QFilter qFilter = new QFilter(cmpDataKey, ">=", (Object)begindate);
            qFilter.and(cmpDataKey, "<=", (Object)enddate).and("billstatus", "=", (Object)BillStatus.C).and("isgenclearbill", "=", (Object)Boolean.FALSE).and("org", "=", (Object)this.assetBook.getLong(Fa.id((String)"org")));
            Map map = BusinessDataServiceHelper.loadFromCache((String)"fa_clearapplybill", (String)selectFields, (QFilter[])qFilter.toArray());
            ArrayList<DynamicObject> clrApplyBills = new ArrayList<DynamicObject>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                DynamicObject clearApplyBill = (DynamicObject)entry.getValue();
                if (clearApplyBill == null) continue;
                ArrayList<FaBizCtrSource> fromSourceList = new ArrayList<FaBizCtrSource>(1);
                fromSourceList.add(new FaBizCtrSource(Long.valueOf(clearApplyBill.getLong("id")), "fa_clearapplybill"));
                ClearBillGenerateFacade facade = new ClearBillGenerateFacade();
                TXHandle h = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        FaBizCtrServiceUtils.updateOneBillBizCtrForBill((DynamicObject)clearApplyBill, (String)"clrapplybill_entry", (String)"realcard", fromSourceList, (Long)0L, (String)"NOENTITYNAME");
                        facade.generateClearBillByApply(clearApplyBill.get("id"));
                        clearApplyBill.set("isgenclearbill", (Object)Boolean.TRUE);
                        clrApplyBills.add(clearApplyBill);
                    }
                    catch (Exception e) {
                        logger.error(String.format("\u6e05\u7406\u5355\u53f7\u4e3a\uff1a%s\u7684\u6e05\u7406\u7533\u8bf7\u5355\u751f\u6210\u6e05\u7406\u5355\u5931\u8d25\uff1a", clearApplyBill.getString("billno")) + ThrowableHelper.toString((Throwable)e));
                        h.markRollback();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
            if (!clrApplyBills.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])clrApplyBills.toArray(new DynamicObject[0]));
            }
        }
    }

    private void assetBookCloseUpdateLeaseInit() {
        DynamicObject assetBookCurPeriod;
        long dbCurPeriodId;
        Object assetBookId = this.assetBook.getPkValue();
        long currentPeriodId = this.assetBook.getLong(Fa.id((String)"curperiod"));
        if (currentPeriodId < (dbCurPeriodId = (assetBookCurPeriod = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"curperiod", (QFilter[])new QFilter[]{new QFilter("id", "in", assetBookId)})).getLong("curperiod"))) {
            long leaseInitCurPeriodId;
            long orgId = this.assetBook.getLong(Fa.id((String)"org"));
            DynamicObject leaseInit = BusinessDataServiceHelper.loadSingle((String)"fa_lease_init", (String)Fa.comma((String[])new String[]{"id", "curperiod"}), (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
            if (leaseInit != null && dbCurPeriodId > (leaseInitCurPeriodId = leaseInit.getLong(Fa.id((String)"curperiod")))) {
                leaseInit.set(Fa.id((String)"curperiod"), (Object)dbCurPeriodId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{leaseInit});
            }
        }
    }

    private <T> T getValue(Class<T> clazz, Map<Class<?>, Object> result) {
        return clazz.cast(result.get(clazz));
    }

    static /* synthetic */ void access$000(MonthCloseCenterOpPlugin x0) {
        x0.genClearBill();
    }
}

