/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.depretask.DepreSplitSumUtils;
import kd.fi.fa.business.utils.FaCardBotpUtil;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaFinCardOperationPlugin;
import kd.fi.fa.opplugin.assetcard.AbstractAssetCardOp;

public class FaAssetCardUnAuditOp
extends AbstractAssetCardOp {
    protected Function<FinCardValidator, Map<Integer, List<String>>> getFinValidateFunc() {
        return FinCardValidator::validateFinCardForUnAudit;
    }

    protected void handleFinCardsByBook(DynamicObject[] assetCards, DynamicObject[] finCards) {
        long assetBookId = finCards[0].getLong(Fa.id((String)"assetbook"));
        ArrayList<DynamicObject> unAuditFinCards = new ArrayList<DynamicObject>(finCards.length);
        HashSet<Long> unAuditFinIds = new HashSet<Long>();
        for (DynamicObject assetCard : assetCards) {
            DynamicObjectCollection assetCardFins = assetCard.getDynamicObjectCollection("finentry");
            for (DynamicObject entry : assetCardFins) {
                DynamicObject finCard = entry.getDynamicObject("originalfincard");
                long finAssetBookId = finCard.getLong(Fa.id((String)"assetbook"));
                if (finAssetBookId != assetBookId) continue;
                unAuditFinCards.add(finCard);
                unAuditFinIds.add(finCard.getLong("id"));
            }
        }
        HashMap<Long, Long> oriFinId2RealIdMap = new HashMap<Long, Long>(unAuditFinCards.size());
        for (DynamicObject finCard : unAuditFinCards) {
            finCard.set("billstatus", (Object)BillStatus.A.name());
            boolean originalData = finCard.getBoolean("originaldata");
            if (!originalData) continue;
            finCard.set("realcard", (Object)finCard.getLong("realcardmasterid"));
            oriFinId2RealIdMap.put(finCard.getLong("id"), finCard.getLong("realcardmasterid"));
        }
        SaveServiceHelper.save((DynamicObject[])unAuditFinCards.toArray(new DynamicObject[0]));
        FaFinCardOperationPlugin.unaudit(unAuditFinCards);
        FaCardBotpUtil.assetOriFinCardBotpHandler4UnAudit(oriFinId2RealIdMap);
        DepreSplitSumUtils.deleteIntelliWhitelist((Object[])unAuditFinIds.toArray(new Long[0]), (String)"fa_card_fin");
    }
}

