/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.changebill;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.operate.FaChangeCmd;
import kd.fi.fa.common.util.Fa;

public class FaChangeBillGenVoucherOp
extends AbstractOperationServicePlugIn {
    private static final String QUERY_BOOK_FIELD = Fa.comma((String[])new String[]{"id", "periodtype", "basecurrency", "curperiod", "startperiod", "depresystem", "status", "org", "enable", "depreuse"});

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("changedate");
        fieldKeys.add("realentry");
        fieldKeys.add("realcard");
        fieldKeys.add("finentry");
        fieldKeys.add("bf_fin_info");
        fieldKeys.add("af_fin_info");
        fieldKeys.add("depreuse");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void generateFinInfo(DynamicObject changeBill, DynamicObject book, List<DynamicObject> updateData) {
        Long orgId = changeBill.getDynamicObject("org").getLong("id");
        Long assetBookId = book.getLong("id");
        Long curPeriodId = book.getLong("curperiod");
        DynamicObjectCollection realEntry = changeBill.getDynamicObjectCollection("realentry");
        Set numbers = realEntry.stream().map(v -> v.getDynamicObject("realcard").getString("number")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("assetbook", "=", (Object)assetBookId), new QFilter("number", "in", numbers), new QFilter("bizperiod", "<=", (Object)curPeriodId)};
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"id", "number", "bizperiod", "originaldata"}), (QFilter[])filters, (String)"bizperiod DESC");
        HashMap<String, Integer> numberAndCount = new HashMap<String, Integer>(finCards.size());
        HashMap<String, Object> numberToFinCardId = new HashMap<String, Object>(finCards.size());
        for (DynamicObject finCard : finCards) {
            String number;
            Integer step;
            Boolean originalData = finCard.getBoolean("originaldata");
            if (originalData.booleanValue() || (step = (Integer)numberAndCount.get(number = finCard.getString("number"))) != null && step != 1) continue;
            numberToFinCardId.put(number, finCard.get("id"));
            Long bizPeriodId = finCard.getLong("bizperiod");
            step = bizPeriodId.longValue() == curPeriodId.longValue() ? Integer.valueOf(step == null ? 1 : 2) : Integer.valueOf(2);
            numberAndCount.put(number, step);
        }
        Long depreUseId = book.getLong("depreuse");
        FaChangeCmd changeCmd = new FaChangeCmd(changeBill.getPkValue());
        for (DynamicObject real : realEntry) {
            DynamicObject realCard = real.getDynamicObject("realcard");
            String number = realCard.getString("number");
            Object finCardId = numberToFinCardId.get(number);
            DynamicObject finCardSnapshot = changeCmd.createFinCardSnapshot(finCardId);
            DynamicObjectCollection finEntry = real.getDynamicObjectCollection("finentry");
            for (DynamicObject fin : finEntry) {
                Long depreUseId2Fin = fin.getDynamicObject("depreuse").getLong("id");
                if (depreUseId2Fin.longValue() != depreUseId.longValue()) continue;
                fin.set("bf_fin_info", (Object)finCardSnapshot);
                fin.set("af_fin_info", (Object)finCardSnapshot);
            }
        }
        updateData.add(changeBill);
    }

    private boolean checkBfFinInfo(DynamicObject changeBill, Long depreuseId) {
        DynamicObjectCollection realEntry = changeBill.getDynamicObjectCollection("realentry");
        for (DynamicObject real : realEntry) {
            DynamicObjectCollection finEntry = real.getDynamicObjectCollection("finentry");
            for (DynamicObject fin : finEntry) {
                DynamicObject bfFinInfo;
                Long depreUseId2Fin = fin.getDynamicObject("depreuse").getLong("id");
                if (depreUseId2Fin.longValue() != depreuseId.longValue() || (bfFinInfo = fin.getDynamicObject("bf_fin_info")) != null) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkUnGeneratedFinInPeriod(DynamicObject changeBill, Long depreUseId) {
        Long changBillId = changeBill.getLong("id");
        QFilter[] filters = new QFilter[]{new QFilter("changebillid", "=", (Object)changBillId), new QFilter("isgenfin", "=", (Object)Boolean.FALSE), new QFilter("isdeleted", "=", (Object)Boolean.FALSE), new QFilter("depreuse", "=", (Object)depreUseId)};
        boolean allUnGenFin = QueryServiceHelper.exists((String)"fa_future_chg_fin_rel", (QFilter[])filters);
        return allUnGenFin;
    }

    static /* synthetic */ String access$000() {
        return QUERY_BOOK_FIELD;
    }

    static /* synthetic */ boolean access$100(FaChangeBillGenVoucherOp x0, DynamicObject x1, Long x2) {
        return x0.checkBfFinInfo(x1, x2);
    }

    static /* synthetic */ boolean access$200(FaChangeBillGenVoucherOp x0, DynamicObject x1, Long x2) {
        return x0.checkUnGeneratedFinInPeriod(x1, x2);
    }

    static /* synthetic */ void access$300(FaChangeBillGenVoucherOp x0, DynamicObject x1, DynamicObject x2, List x3) {
        x0.generateFinInfo(x1, x2, x3);
    }
}

