/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.card;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.report.FaRptSortQueryService;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.common.util.Fa;

public class AssetCardQueryServiceHelper {
    private static final String KEY_DEPRE_FORECAST_QUERY_MAX = "depre.forecast.query.max";
    private static final int DEFAULT_QUERY_MAX = 100000;

    public static DataSet queryRptDataSet(String algoKey, Set<String> otherRealFields, List<QFilter> finCardFilters) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_card_fin", (String)AssetCardQueryServiceHelper.getCurSelectedFieds(otherRealFields), (QFilter[])finCardFilters.toArray(new QFilter[0]), null);
    }

    public static DataSet queryFinDataSet4DepreForecast(String algoKey, ReportQueryParam queryParam, boolean isPageQuery) {
        QFilter periodFilter;
        FilterInfo filterInfo = queryParam.getFilter();
        long orgId = filterInfo.getLong("q_org");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        long depreuseId = filterInfo.getLong("depreuse");
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"basecurrency", "curperiod"}), (QFilter[])new QFilter[]{orgFilter, new QFilter("depreuse", "=", (Object)depreuseId)});
        Object curPeriodId = book.get("curperiod");
        DynamicObject predictEndPeriod = filterInfo.getDynamicObject("q_period");
        String exp = "(%s <= ? and %s > ?) or (%s > ? and %s <= ? and %s = %s)";
        exp = String.format(exp, "bizperiod", "endperiod", "bizperiod", Fa.dot((String[])new String[]{"fa_card_fin", "finaccountdate"}), "bizperiod", "period");
        QFilter filter = periodFilter = QFilter.of((String)exp, (Object[])new Object[]{curPeriodId, curPeriodId, curPeriodId, predictEndPeriod.getDate("enddate")});
        QFilter commFilter = filterInfo.getCommFilter("fa_card_real");
        if (commFilter != null) {
            QFilter isBackFilter = new QFilter("isbak", "=", (Object)false);
            DataSet realCardDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_card_real", (String)"masterid", (QFilter[])new QFilter[]{commFilter, orgFilter, isBackFilter}, null);
            HashSet<Long> realMasterIds = new HashSet<Long>(16);
            for (Row row : realCardDataSet) {
                realMasterIds.add(row.getLong("masterid"));
            }
            if (realMasterIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u9884\u6d4b\u6761\u4ef6\u7684\u5361\u7247", (String)"AssetCardQueryServiceHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            filter = filter.and("realcardmasterid", "in", realMasterIds);
        }
        QFilter apiFilter = filterInfo.getCommFilter("apiQueryFilter");
        QFilter notOriginalDataFilter = new QFilter("originaldata", "=", (Object)false);
        QFilter[] filters = new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("clearperiod", "=", (Object)0L).or("clearperiod", ">=", curPeriodId), new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId), new QFilter("depremethod.type", "!=", (Object)"5"), filter, apiFilter, notOriginalDataFilter};
        String selectFields = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"realcard", "id"}) + " realcard", "id fincard", "number number", "assetcat.number assetcat.number", "basecurrency currency"});
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_card_fin", (String)selectFields, (QFilter[])filters, (String)"period");
        if (!dataSet.hasNext()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u9884\u6d4b\u6761\u4ef6\u7684\u5361\u7247", (String)"AssetCardQueryServiceHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        FaRptSortQueryService batchAndSortService = new FaRptSortQueryService("fa_rpt_depre_forecast", queryParam, "q_org", "q_period", null);
        dataSet = dataSet.orderBy(batchAndSortService.getUsedDetailBatchOrderString(true));
        if (isPageQuery) {
            Integer limit = FaBillParamUtils.getIntegerValue(null, null, (String)"fa_rpt_depre_forecast", (String)KEY_DEPRE_FORECAST_QUERY_MAX);
            if (limit == null) {
                limit = 100000;
            }
            return dataSet.limit(0, limit.intValue());
        }
        return dataSet;
    }

    public static DataSet queryDepreForecastDataSet(String algoKey, ReportQueryParam queryParam, List<String> otherRealFields, boolean onlyLastPeriod) {
        Map customParam;
        Object ignoreUseStatusObj;
        FilterInfo filterInfo = queryParam.getFilter();
        long orgId = filterInfo.getLong("q_org");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        long depreuseId = filterInfo.getLong("depreuse");
        DynamicObject book = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"basecurrency", "curperiod"}), (QFilter[])new QFilter[]{orgFilter, new QFilter("depreuse", "=", (Object)depreuseId)});
        Object curPeriodId = book.get("curperiod");
        DynamicObject predictStartPeriod = filterInfo.getDynamicObject("q_startperiod");
        DynamicObject predictEndPeriod = filterInfo.getDynamicObject("q_period");
        String exp = "(%s <= ? and %s > ?) or (%s > ? and %s <= ? and %s = %s)";
        exp = String.format(exp, "bizperiod", "endperiod", "bizperiod", "realcard.realaccountdate", "bizperiod", "period");
        QFilter periodFilter = QFilter.of((String)exp, (Object[])new Object[]{curPeriodId, curPeriodId, curPeriodId, predictEndPeriod.getDate("enddate")});
        QFilter commFilter = filterInfo.getCommFilter("fa_card_real");
        QFilter filter = periodFilter;
        if (commFilter != null) {
            QFilter isBackFilter = new QFilter("isbak", "=", (Object)false);
            DataSet realCardDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_card_real", (String)"masterid", (QFilter[])new QFilter[]{commFilter, orgFilter, isBackFilter}, null);
            HashSet<Long> realMasterIds = new HashSet<Long>(16);
            for (Row row : realCardDataSet) {
                realMasterIds.add(row.getLong("masterid"));
            }
            if (realMasterIds.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u9884\u6d4b\u6761\u4ef6\u7684\u5361\u7247", (String)"AssetCardQueryServiceHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            filter = filter.and("realcardmasterid", "in", realMasterIds);
        }
        QFilter apiFilter = filterInfo.getCommFilter("apiQueryFilter");
        QFilter[] filters = new QFilter[]{new QFilter("billstatus", "=", (Object)"C"), new QFilter("clearperiod", "=", (Object)0L).or("clearperiod", ">=", curPeriodId), new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreuseId), new QFilter("depremethod.type", "!=", (Object)"5"), filter, apiFilter};
        String selectFields = Fa.comma((String[])new String[]{Fa.dot((String[])new String[]{"realcard", "id"}) + " realcard", "id fincard", "number number", "bizperiod", "originalval", "accumdepre", "basecurrency currency", "period"});
        if (!otherRealFields.isEmpty()) {
            selectFields = selectFields + "," + Fa.join(otherRealFields, (String)",");
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_card_fin", (String)selectFields, (QFilter[])filters, null);
        HashSet<String> finCardNumSet = null;
        if (commFilter != null || apiFilter != null) {
            DataSet finCardIdDataSet = dataSet.copy();
            finCardNumSet = new HashSet<String>();
            for (Row row : finCardIdDataSet) {
                finCardNumSet.add(row.getString("number"));
            }
            finCardIdDataSet.close();
            if (finCardNumSet.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u9884\u6d4b\u6761\u4ef6\u7684\u5361\u7247", (String)"AssetCardQueryServiceHelper_0", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        HashMap<String, Map> orgPredictResult = new HashMap<String, Map>();
        if (predictStartPeriod.getLong("id") < Long.parseLong(curPeriodId.toString())) {
            long queryPeriodId = predictStartPeriod.getLong("id");
            while (queryPeriodId < Long.parseLong(curPeriodId.toString())) {
                Map hisDepredData = FaDepreUtil.depreHisCardHandle((Long)orgId, (Long)depreuseId, (Long)queryPeriodId, finCardNumSet);
                orgPredictResult.put(orgId + "_" + depreuseId + "_" + queryPeriodId, hisDepredData);
                DynamicObject nextPeriod = FaBizUtils.queryNeighborPeriod(queryPeriodId, 1);
                if (nextPeriod == null) continue;
                queryPeriodId = nextPeriod.getLong("id");
            }
        }
        boolean ignoreUseStatus = (ignoreUseStatusObj = (customParam = queryParam.getCustomParam()).get("ignoreUseStatus")) == null ? false : (Boolean)ignoreUseStatusObj;
        DailyDepreImpl dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "fa_rpt_depre_forecast");
        DailyDepreImpl.DeprePredictParam predictParam = new DailyDepreImpl.DeprePredictParam((Object)orgId, Long.valueOf(depreuseId), predictEndPeriod, true, true, finCardNumSet);
        predictParam.setIgnoreUseStatus(ignoreUseStatus);
        Map predictResult = dailyDepreImpl.predictPeriodDepe(predictParam);
        if (predictResult != null && predictResult.size() > 0) {
            orgPredictResult.putAll(predictResult);
        }
        StringBuilder keycurperiodSb = new StringBuilder();
        keycurperiodSb.append(orgId).append("_").append(depreuseId).append("_").append(predictStartPeriod.getPkValue());
        String key_curperiod = keycurperiodSb.toString();
        StringBuilder keyPreperiodSb = new StringBuilder();
        keyPreperiodSb.append(orgId).append("_").append(depreuseId).append("_").append(predictEndPeriod.getLong("id"));
        Map predictCurPeriodResultValue = (Map)orgPredictResult.get(key_curperiod);
        if (predictCurPeriodResultValue == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4[%s]\u9884\u6d4b\u6570\u636e\u4e3a\u7a7a", (String)"AssetCardQueryServiceHelper_1", (String)"fi-fa-business", (Object[])new Object[0]), predictStartPeriod.getString("number")));
        }
        Collection predictCurPeriodResult = predictCurPeriodResultValue.values();
        HashMap<String, BigDecimal> curPeriodPreDepreMap = new HashMap<String, BigDecimal>(16);
        for (Map curPredictRs : predictCurPeriodResult) {
            BigDecimal monthdepre = (BigDecimal)curPredictRs.get("monthdepre");
            BigDecimal accumdepre = (BigDecimal)curPredictRs.get("accumdepre");
            BigDecimal predictBeginDepre = accumdepre.subtract(monthdepre);
            curPeriodPreDepreMap.put((String)curPredictRs.get("number"), predictBeginDepre);
        }
        Algo algo = Algo.create((String)algoKey);
        Field[] fields = new Field[]{new Field("periodnumber", (DataType)DataType.LongType), new Field("number", (DataType)DataType.StringType), new Field("predictOriginalval", (DataType)DataType.BigDecimalType), new Field("predictDepre", (DataType)DataType.BigDecimalType), new Field("predictAccumDepre", (DataType)DataType.BigDecimalType), new Field("predictNetWorth", (DataType)DataType.BigDecimalType), new Field("predictdecval", (DataType)DataType.BigDecimalType), new Field("predictNetAmount", (DataType)DataType.BigDecimalType), new Field("preaddupyeardepre", (DataType)DataType.BigDecimalType), new Field("preusingamount", (DataType)DataType.BigDecimalType), new Field("predepredamount", (DataType)DataType.BigDecimalType), new Field("preresidualval", (DataType)DataType.BigDecimalType), new Field("preremainderamount", (DataType)DataType.BigDecimalType), new Field("monthdepre", (DataType)DataType.BigDecimalType)};
        DataSetBuilder builder = algo.createDataSetBuilder(new RowMeta(fields));
        orgPredictResult.forEach((k, v) -> {
            if (v == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4[%s]\u9884\u6d4b\u6570\u636e\u4e3a\u7a7a", (String)"AssetCardQueryServiceHelper_1", (String)"fi-fa-business", (Object[])new Object[0]), predictEndPeriod.getString("name")));
            }
            long periodId = Long.parseLong(k.substring(k.lastIndexOf("_") + 1));
            if (onlyLastPeriod && periodId != predictEndPeriod.getLong("id")) {
                return;
            }
            AssetCardQueryServiceHelper.transData2DataSet(builder, fields.length, periodId, v, curPeriodPreDepreMap);
        });
        DataSet sumDataSet = builder.build();
        ArrayList<String> lst = new ArrayList<String>(8 + otherRealFields.size());
        lst.add("periodnumber");
        lst.add("predictDepre");
        lst.add("monthdepre");
        lst.add("predictOriginalval");
        lst.add("predictAccumDepre");
        lst.add("predictNetWorth");
        lst.add("predictdecval");
        lst.add("predictNetAmount");
        lst.add("realcard");
        lst.add("number");
        lst.add("fincard");
        lst.add("preaddupyeardepre");
        lst.add("preusingamount");
        lst.add("predepredamount");
        lst.add("preresidualval");
        lst.add("preremainderamount");
        lst.add("currency");
        lst.addAll(otherRealFields);
        sumDataSet = dataSet.leftJoin(sumDataSet).on("number", "number").select(lst.toArray(new String[0])).finish().filter("predictdepre != null and predictdepre != 0");
        if (onlyLastPeriod) {
            lst.remove("predictDepre");
            DataSetBuilder predictBuilder = Algo.create((String)algoKey).createDataSetBuilder(new RowMeta(new Field[]{new Field("periodId", (DataType)DataType.LongType), new Field("number", (DataType)DataType.StringType), new Field("predictAmount", (DataType)DataType.BigDecimalType)}));
            orgPredictResult.forEach((k, v) -> {
                long periodId = Long.parseLong(k.substring(k.lastIndexOf("_") + 1));
                if (periodId < predictStartPeriod.getLong("id")) {
                    return;
                }
                for (Map.Entry cardPredictMap : v.entrySet()) {
                    String number = (String)cardPredictMap.getKey();
                    Map data = (Map)cardPredictMap.getValue();
                    Object curmonthdepre = data.get("monthdepre");
                    predictBuilder.append(new Object[]{periodId, number, curmonthdepre});
                }
            });
            DataSet predictDataSet = predictBuilder.build();
            predictDataSet = predictDataSet.groupBy(new String[]{"number"}).sum("predictAmount").finish();
            sumDataSet = sumDataSet.leftJoin(predictDataSet).on("number", "number").select(lst.toArray(new String[0]), new String[]{"predictAmount predictDepre"}).finish().filter("predictDepre != null and predictDepre != 0").orderBy(new String[]{"periodnumber"});
            return sumDataSet;
        }
        return sumDataSet.filter("predictdepre != null and predictdepre != 0 and periodnumber >=" + predictStartPeriod.getLong("id")).orderBy(new String[]{"periodnumber"});
    }

    public static void transData2DataSet(DataSetBuilder builder, int fieldLength, long periodId, Map<String, Map<String, Object>> predictResultValue, Map<String, BigDecimal> curPeriodPreDepreMap) {
        Collection<Map<String, Object>> predictResult = predictResultValue.values();
        if (!predictResult.isEmpty()) {
            for (Map<String, Object> predictRs : predictResult) {
                Object[] row = new Object[fieldLength];
                String number = (String)predictRs.get("number");
                BigDecimal accumdepre = (BigDecimal)predictRs.get("accumdepre");
                BigDecimal accumdepreBegin = curPeriodPreDepreMap.get(number);
                if (accumdepreBegin == null) {
                    accumdepreBegin = BigDecimal.ZERO;
                }
                BigDecimal preUsingAmount = (BigDecimal)predictRs.get("preusingamount");
                BigDecimal preDepredAmount = (BigDecimal)predictRs.get("depredamount");
                BigDecimal preRemainderAmount = preUsingAmount.subtract(preDepredAmount);
                BigDecimal monthdepre = (BigDecimal)predictRs.get("monthdepre");
                int offset = 1;
                row[0] = periodId;
                row[offset] = number;
                row[1 + offset] = predictRs.get("originalval");
                row[2 + offset] = accumdepre.subtract(accumdepreBegin);
                row[3 + offset] = accumdepre;
                row[4 + offset] = predictRs.get("networth");
                row[5 + offset] = predictRs.get("decval");
                row[6 + offset] = predictRs.get("netamount");
                row[7 + offset] = predictRs.get("addupyeardepre");
                row[8 + offset] = preUsingAmount;
                row[9 + offset] = preDepredAmount;
                row[10 + offset] = predictRs.get("preresidualval");
                row[11 + offset] = preRemainderAmount;
                row[12 + offset] = monthdepre;
                builder.append(row);
            }
        }
    }

    private static String getCurSelectedFieds(Set<String> otherRealFields) {
        HashSet<String> result = new HashSet<String>(10);
        result.add("id");
        result.add("number");
        if (otherRealFields != null) {
            result.addAll(otherRealFields);
        }
        return String.join((CharSequence)",", result);
    }
}

