/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.clear.convertor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.clear.convertor.AbstractBill2ClearBillConvertor;
import kd.fi.fa.business.clear.convertor.IClearBillConvertor;
import kd.fi.fa.business.clear.data.ClearBillData;
import kd.fi.fa.business.clear.data.ClearBillDetailData;
import kd.fi.fa.business.clear.data.ClearBillHeadData;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.DateUtil;

public class ApplyClearBill2ClearBillConvertor
extends AbstractBill2ClearBillConvertor
implements IClearBillConvertor {
    protected void setHeadData(DynamicObject bill, ClearBillData data) {
        Date clearDate;
        data.setSrcEntityName("fa_clearapplybill");
        ClearBillHeadData headData = new ClearBillHeadData();
        headData.setBillNo(bill.getString("billno"));
        headData.setReason(bill.getString("reason"));
        headData.setOrgID(this.pk(bill.getDynamicObject("org")));
        headData.setChangeModeID(this.pk(bill.getDynamicObject("changemode")));
        headData.setSourceBillID(bill.getPkValue());
        headData.setBillStatus(BillStatus.A);
        headData.setClearSource(FaClearSourceEnum.APPLY);
        headData.setCreatorId(bill.getLong("creator_id"));
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)headData.getOrgID());
        if (mainBook != null) {
            boolean genClearBillByApplyDate = FaBillParamUtils.getBooleanValue(null, null, null, (String)"genclearbill_datetype");
            Date begindate = (Date)mainBook.get("begindate");
            clearDate = bill.getDate("auditdate");
            if (genClearBillByApplyDate) {
                clearDate = bill.getDate("cleardate");
            }
            if (clearDate.before(begindate)) {
                clearDate = begindate;
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u3002", (String)"ApplyClearBill2ClearBillConvertor_0", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        headData.setClearPeriod(Long.valueOf(mainBook.getLong("curperiod")));
        clearDate = DateUtil.stripTime((Date)clearDate);
        headData.setClearDate(clearDate);
        headData.setCreateTime(Calendar.getInstance().getTime());
        data.setHeadData(headData);
    }

    protected void setDetailData(DynamicObject bill, ClearBillData data) {
        ClearBillHeadData headData;
        Date auditDate;
        HashMap<? extends Object, ? extends List<ClearBillDetailData>> detailDataMap = new HashMap<Object, List<ClearBillDetailData>>(16);
        DynamicObjectCollection entries = (DynamicObjectCollection)bill.get("clrapplybill_entry");
        Set realCardPKSet = entries.stream().map(v -> this.pk(v.getDynamicObject("realcard"))).collect(Collectors.toSet());
        DynamicObject[] finCards = this.queryFinCards(realCardPKSet);
        if (finCards == null || finCards.length == 0) {
            return;
        }
        Date clearDate = bill.getDate("cleardate");
        Date bizDate = clearDate.after(auditDate = (headData = data.getHeadData()).getClearDate()) ? auditDate : clearDate;
        Map<Object, List<DynamicObject>> group = Stream.of(finCards).collect(Collectors.groupingBy(v -> v.get("assetbook_id")));
        Set<Map.Entry<Object, List<DynamicObject>>> entrySet = group.entrySet();
        for (Map.Entry<Object, List<DynamicObject>> entry : entrySet) {
            detailDataMap.putAll(this.setDetailDataByBook(entry.getKey(), entry.getValue(), entries));
        }
        for (List clearBillDetailDataList : detailDataMap.values()) {
            clearBillDetailDataList.forEach(v -> v.setBizDate(bizDate));
        }
        data.setDetailDataMap(detailDataMap);
    }

    private Map<? extends Object, ? extends List<ClearBillDetailData>> setDetailDataByBook(Object bookPk, List<DynamicObject> finCards, DynamicObjectCollection entries) {
        HashMap detailDataMap = new HashMap(16);
        for (DynamicObject finCard : finCards) {
            ClearBillDetailData detailData = new ClearBillDetailData();
            detailData.setOriginalVal(finCard.getBigDecimal("originalval"));
            detailData.setAddupDepre(finCard.getBigDecimal("accumdepre"));
            detailData.setDecVal(finCard.getBigDecimal("decval"));
            detailData.setNetAmount(finCard.getBigDecimal("netamount"));
            detailData.setPreresidualval(finCard.getBigDecimal("preresidualval"));
            detailData.setBaseCurrencyID(this.pk(finCard.getDynamicObject(FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"}))));
            detailData.setFinCardID(finCard.getPkValue());
            Object realCardID = this.pk(finCard.getDynamicObject("realcard"));
            detailData.setRealCardID(realCardID);
            Optional<DynamicObject> findFirst = entries.stream().filter(v -> this.pk(v.getDynamicObject("realcard")).equals(realCardID)).findFirst();
            if (!findFirst.isPresent()) continue;
            DynamicObject entry = findFirst.get();
            detailData.setClearQty(entry.getBigDecimal("clearqty"));
            if (null != entry.getDataEntityType().getProperties().get((Object)"clearincome")) {
                detailData.setClearIncome(entry.getBigDecimal("clearincome"));
            } else {
                detailData.setClearIncome(BigDecimal.ZERO);
            }
            if (null != entry.getDataEntityType().getProperties().get((Object)"clearfare")) {
                detailData.setClearFare(entry.getBigDecimal("clearfare"));
            } else {
                detailData.setClearFare(BigDecimal.ZERO);
            }
            detailData.setDepreuseID(this.pk(finCard.getDynamicObject("depreuse")));
            detailData.setMeasureunit(entry.get("measureunit"));
            if (detailDataMap.containsKey(bookPk)) {
                ((List)detailDataMap.get(bookPk)).add(detailData);
                continue;
            }
            ArrayList<ClearBillDetailData> detailDetailList = new ArrayList<ClearBillDetailData>(16);
            detailDetailList.add(detailData);
            detailDataMap.put(bookPk, detailDetailList);
        }
        return detailDataMap;
    }
}

