/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.DepreTimeEnum;
import kd.fi.fa.business.FaCopyFinCardDao.FaCopyFinCardService;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.depreciation.ClearValue;
import kd.fi.fa.business.depreciation.DayDepreCard;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreCard;
import kd.fi.fa.business.depreciation.DepreLogger;
import kd.fi.fa.business.depreciation.DepreLogger4Analyze;
import kd.fi.fa.business.depreciation.FaBizInfoPool;
import kd.fi.fa.business.depreciation.ObjectPool;
import kd.fi.fa.business.depreciation.PeriodGroup;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.po.FaCardBusCtrDetailPo;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaAssetCardFinEntryOriginalFinUtils;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.common.util.Tuple;

public class DepreBook {
    private static final Log logger = LogFactory.getLog(DepreBook.class);
    private final DynamicObject org;
    private final DynamicObject book;
    private final DynamicObject depreUse;
    private List<Tuple<String, DynamicObject>> assetPolicyCache;
    private DynamicObject curPeriod;
    private final DynamicObject enablePeriod;
    private PeriodGroup periodGroup;
    private BigDecimal yearPeriodCount;
    private FaBizInfoPool bizInfoPool;
    public final int precision;
    public final int calcPrecision;
    public final ObjectPool<Object> objPool = new ObjectPool();
    private DepreLogger depreLogger = new DepreLogger();
    private boolean analyzeMode;
    private Date depreEndDate;
    private Date beginDate;
    private final Map<Object, Date> dispatchOutFinDateCache = new HashMap<Object, Date>();
    private Map<Long, DynamicObject> predictPrefinCardMap = new HashMap<Long, DynamicObject>();
    private Map<String, BigDecimal> cardtoworkloadMap = new HashMap<String, BigDecimal>();
    private static final String selectwkProperties = "org,depreuse,realcard,period,workload";
    private static final Log fileLogger = LogFactory.getLog(DepreBook.class);
    private Set<Long> noEnterWkRealSet = new HashSet<Long>(8);
    private boolean clearPreDepre = false;
    private Map<Long, Date> realMasterId2ClearBizdate = new HashMap<Long, Date>(1);
    private boolean clearValueDepre = false;
    private Long clearValuePeriodId = 0L;
    private static final List<BizStatusEnum> startDepreBizStatusList = new ArrayList<BizStatusEnum>(2);
    private List<Object> lessQualsCurPeriodidsInThisYear = new ArrayList<Object>(1);
    private Long startPeriodId = 0L;
    private boolean hasValueDepreIsNetamountLargePreresidualval = false;
    private Map<Long, String> depreMethodId2TypeMap = new HashMap<Long, String>(10);
    private boolean ignoreUseStatus;

    public DepreBook(DynamicObject book) {
        DynamicObject currentPeriod = book.getDynamicObject("curperiod");
        this.book = book;
        this.org = book.getDynamicObject("org");
        this.depreUse = book.getDynamicObject("depreUse");
        this.enablePeriod = book.getDynamicObject("startperiod");
        this.precision = this.book.getInt("basecurrency.amtprecision");
        this.calcPrecision = this.precision + 3;
        this.depreEndDate = Fa.getDFDate((Date)currentPeriod.getDate("enddate"));
        this.beginDate = new Date();
        this.init(currentPeriod);
        this.initWorkLoadBaseData();
        this.initDepreMethod();
    }

    public DepreBook(DynamicObject book, DynamicObject predictPeroid, Map<Long, DynamicObject> predictPrefinCardMap) {
        DynamicObject currentPeriod = predictPeroid;
        this.predictPrefinCardMap = predictPrefinCardMap;
        this.book = book;
        this.org = book.getDynamicObject("org");
        this.depreUse = book.getDynamicObject("depreUse");
        this.enablePeriod = book.getDynamicObject("startperiod");
        this.precision = this.book.getInt("basecurrency.amtprecision");
        this.calcPrecision = this.precision + 3;
        this.depreEndDate = currentPeriod.getDate("enddate");
        this.init(currentPeriod);
        this.initWorkLoadBaseData();
        this.initDepreMethod();
    }

    public DepreBook(DynamicObject book, boolean clearValueDepre, Long clearValuePeriodId) {
        this.book = book;
        this.org = book.getDynamicObject("org");
        this.depreUse = book.getDynamicObject("depreUse");
        this.enablePeriod = book.getDynamicObject("startperiod");
        this.precision = this.book.getInt("basecurrency.amtprecision");
        this.calcPrecision = this.precision + 3;
        this.beginDate = new Date();
        this.clearValueDepre = clearValueDepre;
        this.clearValuePeriodId = clearValuePeriodId;
        this.initDepreMethod();
    }

    private void init(DynamicObject currentPeriod) {
        boolean enableFlag;
        this.assetPolicyCache = AssetPolicyUtil.getAssetPolicyInfoByBookId((Object)this.book.get("id"));
        this.curPeriod = currentPeriod;
        this.periodGroup = new PeriodGroup(this.book.get("periodtype_id"));
        this.yearPeriodCount = this.periodGroup.getYearPeriodCount();
        this.bizInfoPool = new FaBizInfoPool(this);
        this.readDispatchIn();
        if (this.curPeriod.getInt("periodnumber") != 1) {
            this.startPeriodId = this.book.getLong("startperiod.id");
            this.lessQualsCurPeriodidsInThisYear = FaPeriodUtils.getLessEqualsCuPeriods((DynamicObject)currentPeriod);
        }
        if (enableFlag = FaBillParamUtils.getBooleanValue(null, null, null, (String)"HAS_VALUE_DEPRE_IS_NETAMOUNT_LARGE_PRERESIDUALVAL")) {
            this.hasValueDepreIsNetamountLargePreresidualval = true;
        }
    }

    private void initWorkLoadBaseData() {
        Map changeDeptInfo = FaDepreUtil.getTraceChangeDeptInfo((DynamicObject)this.book);
        Date minAdjustDate = (Date)changeDeptInfo.get("minAjustDate");
        Set realCardIdList = (Set)changeDeptInfo.get("realCardIdSet");
        if (minAdjustDate != null) {
            DynamicObject[] workloadCurr;
            DynamicObject[] workloadHasHis;
            DynamicObject minPeriod = this.periodGroup.getPeriod(minAdjustDate, null);
            if (minPeriod == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u201c%s\u201d\u83b7\u53d6\u4f1a\u8ba1\u671f\u95f4\u4e3a\u7a7a\u3002", (String)"DepreBook_0", (String)"fi-fa-business", (Object[])new Object[0]), minAdjustDate));
            }
            QFilter[] filters = new QFilter[]{new QFilter("period", ">=", minPeriod.get("id")), new QFilter("org", "=", this.org.get("id")), new QFilter("depreuse", "=", this.depreUse.get("id")), new QFilter("billstatus", "=", (Object)BillStatus.C.name()), new QFilter("realcard", "in", (Object)realCardIdList)};
            for (DynamicObject workload : workloadHasHis = BusinessDataServiceHelper.load((String)"fa_workload", (String)selectwkProperties, (QFilter[])filters)) {
                String key = FaDepreUtil.getWorkLoadKey((DynamicObject)workload);
                this.cardtoworkloadMap.put(key, workload.getBigDecimal("workload"));
            }
            QFilter[] filters2 = new QFilter[]{new QFilter("period", "=", (Object)this.book.getLong("curperiod.id")), new QFilter("org", "=", this.org.get("id")), new QFilter("depreuse", "=", this.depreUse.get("id")), new QFilter("billstatus", "=", (Object)BillStatus.C.name()), new QFilter("realcard", "not in", (Object)realCardIdList)};
            for (DynamicObject workload : workloadCurr = BusinessDataServiceHelper.load((String)"fa_workload", (String)selectwkProperties, (QFilter[])filters2)) {
                String key = FaDepreUtil.getWorkLoadKey((DynamicObject)workload);
                this.cardtoworkloadMap.put(key, workload.getBigDecimal("workload"));
            }
        } else {
            DynamicObject[] workloadCurr;
            QFilter[] filters = new QFilter[]{new QFilter("period", "=", (Object)this.book.getLong("curperiod.id")), new QFilter("org", "=", this.org.get("id")), new QFilter("depreuse", "=", this.depreUse.get("id")), new QFilter("billstatus", "=", (Object)BillStatus.C.name())};
            for (DynamicObject workload : workloadCurr = BusinessDataServiceHelper.load((String)"fa_workload", (String)selectwkProperties, (QFilter[])filters)) {
                String key = FaDepreUtil.getWorkLoadKey((DynamicObject)workload);
                this.cardtoworkloadMap.put(key, workload.getBigDecimal("workload"));
            }
        }
    }

    private void initDepreMethod() {
        DynamicObjectCollection depreMethods = QueryServiceHelper.query((String)"fa_depremethod", (String)"id,type", null);
        for (DynamicObject depreMethod : depreMethods) {
            this.depreMethodId2TypeMap.put(depreMethod.getLong("id"), depreMethod.getString("type"));
        }
    }

    private void readDispatchIn() {
        String selectFields = Fa.dot((String[])new String[]{"dispatchentry", "realcard"});
        QFilter[] filters = new QFilter[]{new QFilter("inorg", "=", this.org.get("id")), new QFilter("dispatchdate", ">=", (Object)this.curPeriod.getDate("begindate")), new QFilter("dispatchdate", "<=", (Object)this.depreEndDate), new QFilter("billstatus", "=", (Object)"D")};
        DynamicObjectCollection dispatchBills = QueryServiceHelper.query((String)"fa_dispatch_in", (String)selectFields, (QFilter[])filters);
        Set srcRealIds = dispatchBills.stream().map(v -> v.get(Fa.dot((String[])new String[]{"dispatchentry", "realcard"}))).collect(Collectors.toSet());
        selectFields = Fa.comma((String[])new String[]{"realcard", "finaccountdate"});
        filters = new QFilter[]{new QFilter("endperiod", "=", (Object)99999999999L), new QFilter("realcard", "in", srcRealIds)};
        DynamicObjectCollection srcFincards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])filters);
        for (DynamicObject srcFinCard : srcFincards) {
            this.dispatchOutFinDateCache.put(srcFinCard.get("realcard"), srcFinCard.getDate("finaccountdate"));
        }
    }

    public Set isNeedRedepre(Set<Long> finCardIdSet) {
        List<DepreAlgoInter> cardBoxes = this.depreFinCards(finCardIdSet, false, false, false);
        return cardBoxes.stream().filter(v -> v.isNeedDepre()).map(v -> v.getFinCard().get("id")).collect(Collectors.toSet());
    }

    public Map<Object, BigDecimal> calcNetAmountWithoutDecval(Map<Object, Object> cardMap) {
        Set<Map.Entry<Object, Object>> entrySet = cardMap.entrySet();
        QFilter cardFilter = null;
        for (Map.Entry<Object, Object> entry : entrySet) {
            Object realCardMasterId = entry.getKey();
            Object periodId = entry.getValue();
            if (cardFilter == null) {
                cardFilter = new QFilter("realcard.masterid", "=", realCardMasterId).and("bizperiod.id", "=", periodId);
                continue;
            }
            cardFilter = cardFilter.or(new QFilter("realcard.masterid", "=", realCardMasterId).and("bizperiod.id", "=", periodId));
        }
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])new QFilter[]{new QFilter("depreuse", "=", this.depreUse.getPkValue()), cardFilter});
        Set<Long> finCardIdSet = finCards.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        List<DepreAlgoInter> depreCardLst = this.getDepreCardList(finCardIdSet);
        Map<Long, Date> realIdToDisptDateMap = this.updateRealCarIdToDisptDateMap(depreCardLst);
        HashMap<Object, BigDecimal> result = new HashMap<Object, BigDecimal>(depreCardLst.size());
        for (DepreAlgoInter depreCard : depreCardLst) {
            depreCard.setIgnoreDecVal(true);
            DynamicObject finCard = depreCard.getFinCard();
            DynamicObject realCard = finCard.getDynamicObject("realcard");
            Date dispatchDate = realIdToDisptDateMap.get(realCard.getLong("id"));
            if (dispatchDate != null) {
                depreCard.setDispatchDate(dispatchDate);
            }
            depreCard.depre();
            Object masterid = depreCard.getRealCard().get("masterid");
            result.put(masterid, depreCard.getFinCard().getBigDecimal("netamount"));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public List<Object[]> predictAccumDepre(Set<Long> finCardIdSet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<DepreAlgoInter> depreFinCardsAndRecordLog(String fromEntityName, Set<Long> finCardIdSet, boolean updateDB, boolean isAddCardLock, boolean clearPreDepre) {
        List<DepreAlgoInter> result = null;
        Long depreLogId = null;
        FaOperationOpTypeEnum opTypeEnum = updateDB ? FaOperationOpTypeEnum.IMMEDIATELY : FaOperationOpTypeEnum.PREDICTED;
        String logParams = String.format("orgId:%s; depreuseId:%s; depreFinIdSet:%s", this.org.getLong("id"), this.depreUse.getLong("id"), JSON.toJSONString(finCardIdSet));
        FaOperationLogInsertPo insertLogPo = new FaOperationLogInsertPo(this.org.getString("name"), this.depreUse.getString("name"), this.book.getString("name"), this.book.getDynamicObject("curperiod").getString("name"), Integer.valueOf(finCardIdSet.size()), fromEntityName, logParams, opTypeEnum);
        try {
            depreLogId = FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertLogPo);
            result = this.depreFinCards(finCardIdSet, updateDB, isAddCardLock, clearPreDepre);
            FaOperationLogUtils.updateOperationLog((Long)depreLogId, (FaOperationStatusEnum)FaOperationStatusEnum.SUCCESS, null);
            return result;
        }
        catch (Throwable e) {
            String errorMsg = ThrowableHelper.toString((Throwable)e);
            if (depreLogId != null) {
                FaOperationLogUtils.updateOperationLog((Long)depreLogId, (FaOperationStatusEnum)FaOperationStatusEnum.FAILED, (String)errorMsg);
            } else {
                FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertLogPo, (FaOperationStatusEnum)FaOperationStatusEnum.FAILED, (String)errorMsg);
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepreAlgoInter> depreFinCards(Set<Long> finCardIdSet, boolean updateDB, boolean isAddCardLock, boolean clearPreDepre) {
        TXHandle h;
        if (finCardIdSet.isEmpty()) {
            return new ArrayList<DepreAlgoInter>();
        }
        HashMap<Long, DynamicObject> prevFinCardMap = new HashMap<Long, DynamicObject>();
        FaCopyFinCardService copycard = new FaCopyFinCardService(Boolean.valueOf(true), Boolean.valueOf(true));
        HashMap<Object, Object> initOriginalCopyMap = new HashMap<Object, Object>(finCardIdSet.size());
        HashSet<Long> restartDepreSet2Zero = new HashSet<Long>(200);
        List<DepreAlgoInter> depreCardLst = this.getDepreCardList(finCardIdSet, prevFinCardMap, copycard, clearPreDepre, initOriginalCopyMap, restartDepreSet2Zero);
        HashSet<Long> realCardMasterIdSet = new HashSet<Long>(finCardIdSet.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DepreBook.depreFinCards", (String)"fa_card_fin", (String)"realcardmasterid", (QFilter[])new QFilter[]{new QFilter("id", "in", finCardIdSet)}, null);){
            for (Row row : dataSet) {
                realCardMasterIdSet.add(row.getLong("realcardmasterid"));
            }
        }
        String fields = String.join((CharSequence)",", "realcard", "date", "entityname");
        QFilter[] filters = new QFilter[]{new QFilter("assetbook", "=", this.book.getPkValue()), new QFilter("date", "<=", (Object)this.curPeriod.getDate("endDate")), new QFilter("realcard", "in", realCardMasterIdSet)};
        DynamicObjectCollection dynamicCards = QueryServiceHelper.query((String)"fa_card_dynamic", (String)fields, (QFilter[])filters);
        HashMap<Object, Date> dynamicMap = new HashMap<Object, Date>();
        HashSet<Long> dynRealCardIds = new HashSet<Long>(10);
        for (DynamicObject dynamicCard : dynamicCards) {
            Object realCardId = dynamicCard.get("realcard");
            Date date = dynamicCard.getDate("date");
            if (!dynamicMap.containsKey(realCardId) || ((Date)dynamicMap.get(realCardId)).compareTo(date) > 0) {
                dynamicMap.put(realCardId, date);
            }
            if (!"fa_card_fin".equalsIgnoreCase(dynamicCard.getString("entityname")) || dynRealCardIds.contains(realCardId)) continue;
            dynRealCardIds.add(Long.parseLong(realCardId.toString()));
        }
        Map<Long, Date> realIdToDisptDateMap = this.updateRealCarIdToDisptDateMap(depreCardLst);
        HashMap<Long, FaCardBusCtrDetailPo> masterId2detailMap = new HashMap<Long, FaCardBusCtrDetailPo>(depreCardLst.size(), 1.0f);
        FaCardBusCtrDetailPo cardBusCtrDetailPo = new FaCardBusCtrDetailPo();
        cardBusCtrDetailPo.setAssetBookId(Long.valueOf(this.book.getLong("id")));
        cardBusCtrDetailPo.setSourceEntityType("fa_depre");
        if (updateDB && isAddCardLock) {
            for (DepreAlgoInter depreAlgoInter : depreCardLst) {
                if (depreAlgoInter.getRealCard().getString("bizstatus").equals(BizStatusEnum.DELETE.name())) continue;
                masterId2detailMap.put(depreAlgoInter.getRealCard().getLong("masterid"), cardBusCtrDetailPo);
            }
            h = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    HashMap<String, Object> extParameterMap = new HashMap<String, Object>(2, 1.0f);
                    extParameterMap.put("orgId", this.org.get("id"));
                    extParameterMap.put("curPeriodEndDate", this.depreEndDate);
                    FaRealCardDaoFactory.getInstance().batchLockCard2Book(BizStatusEnum.READY, startDepreBizStatusList, masterId2detailMap, extParameterMap);
                    h.commit();
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable e) {
                Throwable throwable2 = e;
                throw e;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        try {
            ArrayList<DepreAlgoInter> noNeedDepreLst = new ArrayList<DepreAlgoInter>();
            ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(this.noEnterWkRealSet.size());
            ArrayList<DepreAlgoInter> noEnterWkDepreCardSet = new ArrayList<DepreAlgoInter>(this.noEnterWkRealSet.size());
            for (DepreAlgoInter depreCard : depreCardLst) {
                DynamicObject finCard;
                DynamicObject realCard;
                Date dispatchDate;
                if (dynamicMap.containsKey(depreCard.getRealCard().get("masterid"))) {
                    depreCard.setDynamicBeginDate((Date)dynamicMap.get(depreCard.getRealCard().get("masterid")));
                }
                if (dynRealCardIds.contains(depreCard.getRealCard().get("masterid"))) {
                    depreCard.setInitFromFinCard(true);
                }
                if ((dispatchDate = realIdToDisptDateMap.get((realCard = (finCard = depreCard.getFinCard()).getDynamicObject("realcard")).getLong("id"))) != null) {
                    depreCard.setDispatchDate(dispatchDate);
                }
                depreCard.depre();
                if (!depreCard.isNeedDepre()) {
                    noNeedDepreLst.add(depreCard);
                    Object object = depreCard.getRealCard().get("id");
                    DynamicObject finTemp = (DynamicObject)prevFinCardMap.remove(object);
                    if (this.noEnterWkRealSet.contains(object) && finTemp != null) {
                        arrayList.add(finTemp);
                        noEnterWkDepreCardSet.add(depreCard);
                    }
                }
                if (depreCard instanceof DayDepreCard) {
                    this.depreLogger.log("assetNumber4Day", (Object)depreCard);
                    continue;
                }
                this.depreLogger.log("assetNumber", (Object)depreCard);
            }
            StringBuilder alterSb = new StringBuilder();
            int num = 0;
            for (DepreAlgoInter depreCard : depreCardLst) {
                if (!StringUtils.isEmpty((CharSequence)depreCard.getAlterStr())) {
                    alterSb.append(depreCard.getAlterStr());
                    ++num;
                }
                if (num <= 99) continue;
            }
            if (alterSb.length() > 0) {
                throw new KDBizException(alterSb.toString());
            }
            if (updateDB) {
                Collection prevFinCardCol = prevFinCardMap.values();
                if (!prevFinCardCol.isEmpty()) {
                    DynamicObject[] array = new DynamicObject[prevFinCardCol.size()];
                    copycard.saveService(prevFinCardCol.stream().collect(Collectors.toList()).toArray(array));
                    HashMap initOriginalCopyMap4Save = new HashMap(finCardIdSet.size());
                    for (DynamicObject finCard : array) {
                        Object backId = finCard.getPkValue();
                        if (!initOriginalCopyMap.containsKey(backId)) continue;
                        initOriginalCopyMap4Save.put(backId, initOriginalCopyMap.get(backId));
                    }
                    if (!initOriginalCopyMap4Save.isEmpty()) {
                        FaAssetCardFinEntryOriginalFinUtils.updateOriginal4OriginalId(initOriginalCopyMap4Save);
                    }
                }
                depreCardLst.removeAll(noNeedDepreLst);
                if (!depreCardLst.isEmpty()) {
                    ArrayList<Object> tempDepreCardList = new ArrayList<DepreAlgoInter>(1999);
                    int i = 0;
                    for (DepreAlgoInter depreCard : depreCardLst) {
                        if (i == 1999) {
                            this.updateDB(tempDepreCardList);
                            tempDepreCardList = new ArrayList(1999);
                            i = 0;
                        }
                        tempDepreCardList.add(depreCard);
                        ++i;
                    }
                    if (tempDepreCardList.size() > 0) {
                        this.updateDB(tempDepreCardList);
                    }
                }
                if (restartDepreSet2Zero.size() > 0) {
                    this.updateDB4Restart(restartDepreSet2Zero);
                }
                if (!noNeedDepreLst.isEmpty()) {
                    this.updateNoNeedDepre(noNeedDepreLst);
                }
                if (arrayList.size() > 0) {
                    copycard.saveService(arrayList.toArray(new DynamicObject[arrayList.size()]));
                    this.updateDB4NoEnterWk(noEnterWkDepreCardSet);
                }
                if (this.getCurPeriod().getInt("periodnumber") != 1) {
                    HashSet<String> numbers = new HashSet<String>(depreCardLst.size(), 1.0f);
                    for (DepreAlgoInter depreAlgoInter : depreCardLst) {
                        numbers.add(depreAlgoInter.getCardNumber());
                    }
                    for (DepreAlgoInter depreAlgoInter : noNeedDepreLst) {
                        numbers.add(depreAlgoInter.getCardNumber());
                    }
                    FaDepreUtil.updateLessQualsCurPeriodYearDepre((Long)this.org.getLong("id"), (Long)this.depreUse.getLong("id"), (Long)this.startPeriodId, (Long)this.getCurPeriod().getLong("id"), numbers, this.lessQualsCurPeriodidsInThisYear);
                }
            }
            if (!updateDB) return depreCardLst;
            if (!isAddCardLock) return depreCardLst;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable6) {
                if (!updateDB) throw throwable6;
                if (!isAddCardLock) throw throwable6;
                try (TXHandle h2 = TX.requiresNew();){
                    try {
                        FaRealCardDaoFactory.getInstance().batchUnLockCard2Book(masterId2detailMap);
                        h2.commit();
                        throw throwable6;
                    }
                    catch (Throwable e2) {
                        h2.markRollback();
                        logger.error("\u6298\u65e7\u51fa\u73b0\u5f02\u5e38", e2);
                        throw throwable6;
                    }
                }
            }
        }
        h = TX.requiresNew();
        Throwable throwable = null;
        try {
            try {
                FaRealCardDaoFactory.getInstance().batchUnLockCard2Book(masterId2detailMap);
                h.commit();
                return depreCardLst;
            }
            catch (Throwable e) {
                h.markRollback();
                logger.error("\u6298\u65e7\u51fa\u73b0\u5f02\u5e38", e);
                return depreCardLst;
            }
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            throw throwable3;
        }
        finally {
            if (h != null) {
                if (throwable != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    public List<DepreAlgoInter> depreClearValue2Restartbill(Map<Long, ClearValue> realMasterId2ClrValueMap, List<DepreAlgoInter> depreCardLstPa) {
        List<DepreAlgoInter> depreCardLst = null;
        if (realMasterId2ClrValueMap != null && realMasterId2ClrValueMap.size() > 0) {
            depreCardLst = this.getDepreCardList4ClearRestart(realMasterId2ClrValueMap);
            String fields = String.join((CharSequence)",", "realcard", "date", "entityname");
            QFilter[] filters = new QFilter[]{new QFilter("assetbook", "=", this.book.getPkValue()), new QFilter("date", "<=", (Object)this.curPeriod.getDate("endDate")), new QFilter("realcard", "in", realMasterId2ClrValueMap.keySet())};
            DynamicObjectCollection dynamicCards = QueryServiceHelper.query((String)"fa_card_dynamic", (String)fields, (QFilter[])filters);
            HashMap<Object, Date> dynamicMap = new HashMap<Object, Date>();
            HashSet<Long> dynRealCardIds = new HashSet<Long>(10);
            for (DynamicObject dynamicCard : dynamicCards) {
                Object realCardId = dynamicCard.get("realcard");
                Date date = dynamicCard.getDate("date");
                if (!dynamicMap.containsKey(realCardId) || ((Date)dynamicMap.get(realCardId)).compareTo(date) > 0) {
                    dynamicMap.put(realCardId, date);
                }
                if (!"fa_card_fin".equalsIgnoreCase(dynamicCard.getString("entityname")) || dynRealCardIds.contains(realCardId)) continue;
                dynRealCardIds.add(Long.parseLong(realCardId.toString()));
            }
            for (DepreAlgoInter depreCard : depreCardLst) {
                if (dynamicMap.containsKey(depreCard.getRealCard().get("masterid"))) {
                    depreCard.setDynamicBeginDate((Date)dynamicMap.get(depreCard.getRealCard().get("masterid")));
                }
                if (!dynRealCardIds.contains(depreCard.getRealCard().get("masterid"))) continue;
                depreCard.setInitFromFinCard(true);
            }
        } else if (depreCardLstPa != null) {
            depreCardLst = depreCardLstPa;
            for (DepreAlgoInter depreCard : depreCardLst) {
                DynamicObject finCard = depreCard.getFinCard();
                finCard.set("monthdepre", (Object)BigDecimal.ZERO);
                finCard.set("addidepreamount", (Object)BigDecimal.ZERO);
            }
        } else {
            return new ArrayList<DepreAlgoInter>();
        }
        for (DepreAlgoInter depreCard : depreCardLst) {
            depreCard.depre();
            this.depreLogger.log("assetNumber", (Object)depreCard);
        }
        StringBuilder alterSb = new StringBuilder();
        int num = 0;
        for (DepreAlgoInter depreCard : depreCardLst) {
            if (!StringUtils.isEmpty((CharSequence)depreCard.getAlterStr())) {
                alterSb.append(depreCard.getAlterStr());
                ++num;
            }
            if (num <= 99) continue;
            break;
        }
        if (alterSb.length() > 0) {
            throw new KDBizException(alterSb.toString());
        }
        return depreCardLst;
    }

    private Map<Long, Date> updateRealCarIdToDisptDateMap(List<DepreAlgoInter> depreCardLst) {
        HashMap<Long, Date> realIdToDisptDateMap = new HashMap<Long, Date>(12);
        HashSet<Long> disptBillIds = new HashSet<Long>();
        HashMap<Long, Long> realCardIdTodisptBillId = new HashMap<Long, Long>();
        for (DepreAlgoInter depreCard : depreCardLst) {
            DynamicObject finCard = depreCard.getFinCard();
            DynamicObject realCard = finCard.getDynamicObject("realcard");
            String sourceflag = realCard.getString("sourceflag");
            Date finAccountDate = depreCard.getFinCard().getDate("finaccountDate");
            boolean fromDispatch = sourceflag.equals(SourceFlagEnum.DISPATCH.name()) && this.getPeriodGroup().dateCmpToPeriod(finAccountDate, this.getCurPeriod()) == 0;
            if (!fromDispatch) continue;
            Long srcbillid = realCard.getLong("srcbillid");
            disptBillIds.add(srcbillid);
            realCardIdTodisptBillId.put(realCard.getLong("id"), srcbillid);
        }
        String selectFields = Fa.comma((String[])new String[]{"id", "dispatchdate"});
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", disptBillIds)};
        HashMap<Long, Date> disptBillIdToDate = new HashMap<Long, Date>();
        DynamicObjectCollection dispatchBills = QueryServiceHelper.query((String)"fa_dispatch_in", (String)selectFields, (QFilter[])filters);
        for (DynamicObject dispatchBill : dispatchBills) {
            Long dispatchId = dispatchBill.getLong("id");
            Date dispatchDate = dispatchBill.getDate("dispatchdate");
            disptBillIdToDate.put(dispatchId, dispatchDate);
        }
        for (Map.Entry realIdTodisptIdEntry : realCardIdTodisptBillId.entrySet()) {
            Long realId = (Long)realIdTodisptIdEntry.getKey();
            Long disptId = (Long)realIdTodisptIdEntry.getValue();
            Date dispatchDate = (Date)disptBillIdToDate.get(disptId);
            realIdToDisptDateMap.put(realId, dispatchDate);
        }
        return realIdToDisptDateMap;
    }

    private void updateDB(List<DepreAlgoInter> depreCardLst) {
        String sql = "UPDATE T_FA_CARD_FIN SET FMONTHDEPRE=?,FDEPRERATE=?,FDEPREDAMOUNT=?,FADDIDEPREAMOUNT=?,FACCUMDEPRE=?,FADDUPYEARDEPRE=?,FNETWORTH=?,FNETAMOUNT=?,FISNEEDDEPRE=?,fbizperiodid=?,fmonthorigvalchg=?,fmonthdeprechg=?,fyearorigvalchg=?,fmonthaccumdeprechg=? WHERE FID=?";
        int cardSize = depreCardLst.size();
        ArrayList<Object[]> params = new ArrayList<Object[]>(cardSize);
        for (int i = 0; i < cardSize; ++i) {
            params.add(depreCardLst.get(i).getUpdateDBParam());
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, params);
    }

    private void updateDB4Restart(Set<Long> restartDepreSet2Zero) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("UPDATE T_FA_CARD_FIN SET frestartaddeddepre=0,frestartdepreamount=0 WHERE ", new Object[0]);
        sqlBuilder.appendIn("FID", restartDepreSet2Zero.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
    }

    private void updateDB4NoEnterWk(List<DepreAlgoInter> noEnterWkDepreCardSet) {
        String sql = "UPDATE T_FA_CARD_FIN SET FMONTHDEPRE=0,FDEPRERATE=0,FADDIDEPREAMOUNT=0,FISNEEDDEPRE=0,fbizperiodid=?,fmonthorigvalchg=0,fmonthdeprechg=0,fyearorigvalchg=0 WHERE FID=?";
        if (this.curPeriod.getInt("periodnumber") == 1) {
            sql = "UPDATE T_FA_CARD_FIN SET FMONTHDEPRE=0,FDEPRERATE=0,FADDIDEPREAMOUNT=0,FADDUPYEARDEPRE=0,FISNEEDDEPRE=0,fbizperiodid=?,fmonthorigvalchg=0,fmonthdeprechg=0,fyearorigvalchg=0 WHERE FID=?";
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(noEnterWkDepreCardSet.size());
        for (DepreAlgoInter noEnterWkDepreCard : noEnterWkDepreCardSet) {
            params.add(new Object[]{this.curPeriod.getLong("id"), noEnterWkDepreCard.getFinCard().get("id")});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, params);
    }

    private void updateNoNeedDepre(List<DepreAlgoInter> noNeedDepreLst) {
        String sql = "UPDATE T_FA_CARD_FIN SET FISNEEDDEPRE=? WHERE FID=?";
        int cardSize = noNeedDepreLst.size();
        ArrayList<Object[]> params = new ArrayList<Object[]>(cardSize);
        for (int i = 0; i < cardSize; ++i) {
            params.add(new Object[]{false, noNeedDepreLst.get(i).getFinCard().get("id")});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, params);
    }

    private List<DepreAlgoInter> getDepreCardList(Set<Long> finCardIdSet) {
        return this.getDepreCardList(finCardIdSet, new HashMap<Long, DynamicObject>(), new FaCopyFinCardService(Boolean.valueOf(true), Boolean.valueOf(true)), false, new HashMap<Object, Object>(), null);
    }

    private List<DepreAlgoInter> getDepreCardList(Set<Long> finCardIdSet, Map<Long, DynamicObject> prevFinCardMap, FaCopyFinCardService copycard, boolean clearPreDepre, Map<Object, Object> initOriginalCopyMap, Set<Long> restartDepreSet2Zero) {
        DynamicObjectType subType = this.getFinCardSubEntityType();
        ArrayList<DynamicObject> depreCardsList = new ArrayList<DynamicObject>();
        Set<Object> selectFromDBfinCardIdSet = new HashSet();
        if (this.predictPrefinCardMap != null && this.predictPrefinCardMap.size() > 0) {
            for (Long finCardId : finCardIdSet) {
                DynamicObject finCard = this.predictPrefinCardMap.get(finCardId);
                if (finCard != null) {
                    depreCardsList.add(finCard);
                    continue;
                }
                selectFromDBfinCardIdSet.add(finCardId);
            }
        } else {
            selectFromDBfinCardIdSet = finCardIdSet;
        }
        if (selectFromDBfinCardIdSet != null && selectFromDBfinCardIdSet.size() > 0) {
            DynamicObject[] fromDBfinCards = BusinessDataReader.load((Object[])selectFromDBfinCardIdSet.toArray(), (DynamicObjectType)subType, (Boolean)false);
            depreCardsList.addAll(Arrays.asList(fromDBfinCards));
        }
        long curPeriodId = this.curPeriod.getLong("id");
        long[] copyFinIds = DBServiceHelper.genLongIds((String)"t_fa_card_fin", (int)depreCardsList.size());
        int i = 0;
        for (DynamicObject dynamicObject : depreCardsList) {
            long bizPeriodId;
            if (dynamicObject.getLong("bizPeriod_id") >= curPeriodId) continue;
            DynamicObject prevFinCard = copycard.clone((IDataEntityType)subType, dynamicObject);
            prevFinCard.set("endperiod", (Object)this.curPeriod);
            prevFinCard.set("id", (Object)copyFinIds[i++]);
            prevFinCard.set("createtime", (Object)new Date());
            prevFinCardMap.put(dynamicObject.getLong("realcard_id"), prevFinCard);
            dynamicObject.set("monthdepre", (Object)BigDecimal.ZERO);
            dynamicObject.set("addidepreamount", (Object)BigDecimal.ZERO);
            if (restartDepreSet2Zero != null && (dynamicObject.getBigDecimal("restartaddeddepre").compareTo(BigDecimal.ZERO) != 0 || dynamicObject.getBigDecimal("restartdepreamount").compareTo(BigDecimal.ZERO) != 0)) {
                restartDepreSet2Zero.add(dynamicObject.getLong("id"));
            }
            dynamicObject.set("restartaddeddepre", (Object)BigDecimal.ZERO);
            dynamicObject.set("restartdepreamount", (Object)BigDecimal.ZERO);
            if (this.curPeriod.getInt("periodnumber") == 1) {
                dynamicObject.set("addupyeardepre", (Object)BigDecimal.ZERO);
            }
            if ((bizPeriodId = prevFinCard.getLong(Fa.id((String)"bizperiod"))) != 0L) continue;
            initOriginalCopyMap.put(prevFinCard.getPkValue(), dynamicObject.getPkValue());
        }
        HashSet<Long> realCardIdSet = new HashSet<Long>(depreCardsList.size());
        for (DynamicObject finCard : depreCardsList) {
            realCardIdSet.add(finCard.getLong("realcard_id"));
        }
        DynamicObjectType dynamicObjectType = (DynamicObjectType)this.objPool.get((Object)"fa_card_real", "fa_card_real_subType", this::getReadCardSubEntityType);
        DynamicObject[] realCards = BusinessDataReader.load((Object[])realCardIdSet.toArray(), (DynamicObjectType)dynamicObjectType, (Boolean)true);
        HashMap<Object, DynamicObject> realCardMap = new HashMap<Object, DynamicObject>(realCards.length);
        HashSet<Object> realcardMasterISet = new HashSet<Object>(realCards.length);
        for (DynamicObject realCard : realCards) {
            realCardMap.put(realCard.getPkValue(), realCard);
            realcardMasterISet.add(realCard.get("masterid"));
        }
        Map bizDataMap = this.getBizInfoPool().getBizData(realcardMasterISet);
        ArrayList<DepreAlgoInter> depreCardList = new ArrayList<DepreAlgoInter>(depreCardsList.size());
        for (DynamicObject finCard : depreCardsList) {
            Date bizDate;
            DynamicObject realCardDo = (DynamicObject)realCardMap.get(finCard.getLong("realcard_id"));
            if (realCardDo == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\u3002", (String)"DepreBook_1", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getString("number")));
            }
            finCard.set("realcard", (Object)realCardDo);
            Long depreMethodId = finCard.getLong("depremethod_id");
            String depreMethodType = this.depreMethodId2TypeMap.get(depreMethodId);
            Object card = null;
            card = depreMethodType != null && depreMethodType.equals("51") ? new DayDepreCard(finCard, this) : new DepreCard(finCard, this);
            card.setClearPreDepre(clearPreDepre);
            if (depreMethodType != null && depreMethodType.equals("51") && (bizDate = this.realMasterId2ClearBizdate.get(finCard.getLong("realcardmasterid"))) != null) {
                card.setClearPreBizDate(bizDate);
            }
            card.setIgnoreUseStatus(this.ignoreUseStatus);
            ArrayList bizInfoLst = null;
            if (bizDataMap != null) {
                bizInfoLst = (ArrayList)bizDataMap.get(finCard.get("realcard.masterid"));
            }
            if (bizInfoLst == null) {
                bizInfoLst = new ArrayList(16);
            }
            card.setBizInfoLst(bizInfoLst);
            depreCardList.add((DepreAlgoInter)card);
        }
        return depreCardList;
    }

    private List<DepreAlgoInter> getDepreCardList4ClearRestart(Map<Long, ClearValue> realMasterId2ClrValueMap) {
        DynamicObjectType subType = this.getFinCardSubEntityType();
        ArrayList<DynamicObject> depreCardsList = new ArrayList<DynamicObject>();
        long curPeriodId = this.curPeriod.getLong("id");
        if (realMasterId2ClrValueMap.size() > 0) {
            QFilter[] finFilters = new QFilter[]{new QFilter("realcardmasterid", "in", realMasterId2ClrValueMap.keySet()), new QFilter("bizperiod", "=", (Object)curPeriodId), new QFilter("originaldata", "=", (Object)Boolean.FALSE)};
            List finIdList = QueryServiceHelper.queryPrimaryKeys((String)"fa_card_fin", (QFilter[])finFilters, null, (int)100000);
            if (finIdList == null || finIdList.size() == 0) {
                return new ArrayList<DepreAlgoInter>(1);
            }
            DynamicObject[] fromDBfinCards = BusinessDataReader.load((Object[])finIdList.toArray(), (DynamicObjectType)subType, (Boolean)false);
            if (fromDBfinCards == null || fromDBfinCards.length == 0) {
                return new ArrayList<DepreAlgoInter>(1);
            }
            depreCardsList.addAll(Arrays.asList(fromDBfinCards));
        }
        HashSet<Long> realCardIdSet = new HashSet<Long>(depreCardsList.size());
        for (DynamicObject finCard : depreCardsList) {
            realCardIdSet.add(finCard.getLong("realcard_id"));
        }
        DynamicObjectType entityType = (DynamicObjectType)this.objPool.get((Object)"fa_card_real", "fa_card_real_subType", this::getReadCardSubEntityType);
        DynamicObject[] realCards = BusinessDataReader.load((Object[])realCardIdSet.toArray(), (DynamicObjectType)entityType, (Boolean)true);
        HashMap<Object, DynamicObject> realCardMap = new HashMap<Object, DynamicObject>(realCards.length);
        for (DynamicObject realCard : realCards) {
            realCardMap.put(realCard.getPkValue(), realCard);
        }
        ArrayList<DepreAlgoInter> depreCardList = new ArrayList<DepreAlgoInter>(depreCardsList.size());
        for (DynamicObject finCard : depreCardsList) {
            DynamicObject realCardDo = (DynamicObject)realCardMap.get(finCard.getLong("realcard_id"));
            if (realCardDo == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\u3002", (String)"DepreBook_1", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getString("number")));
            }
            finCard.set("realcard", (Object)realCardDo);
            Long realCardMasterId = finCard.getLong("realcardmasterid");
            ClearValue clearValue = realMasterId2ClrValueMap.get(realCardMasterId);
            if (clearValue == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247[%s]\u6ca1\u6709\u6e05\u7406\u53c2\u6570", (String)"DepreBook_7", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getString("number")));
            }
            finCard.set("originalval", (Object)clearValue.getClearAssetvalue());
            finCard.set("accumdepre", (Object)clearValue.getClearAddupdepre());
            finCard.set("decval", (Object)clearValue.getClearDecval());
            finCard.set("preresidualval", (Object)clearValue.getClearPreresidualval());
            Long assetCatId = realCardDo.getLong("assetcat_id");
            String number = realCardDo.getString("number");
            DynamicObject cate = this.getAssetCategory(assetCatId);
            if (cate == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u201c%s\u201d\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u522b\u4e3a\u7a7a\u3002", (String)"DepreCard_0", (String)"fi-fa-business", (Object[])new Object[0]), number));
            }
            DynamicObject policy = AssetPolicyUtil.getByAssetPolicyInfoAndCateLongNumber((String)cate.getString("longnumber"), this.getAssetPolicyCache());
            if (policy == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u201c%s\u201d\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u522b\u6ca1\u6709\u914d\u7f6e\u8d44\u4ea7\u653f\u7b56\u3002", (String)"DepreCard_1", (String)"fi-fa-business", (Object[])new Object[0]), number));
            }
            String depreTime1 = policy.getString("depreTime");
            if (kd.bos.util.StringUtils.isEmpty((String)depreTime1)) continue;
            DepreTimeEnum depreTime = DepreTimeEnum.valueOf((String)depreTime1);
            BigDecimal additinalDepreAmount = finCard.getBigDecimal("addidepreamount");
            BigDecimal depreAount = finCard.getBigDecimal("depredamount");
            if (DepreTimeEnum.NEW == depreTime) {
                finCard.set("depredamount", (Object)depreAount.subtract(additinalDepreAmount));
            }
            finCard.set("monthdepre", (Object)BigDecimal.ZERO);
            finCard.set("addidepreamount", (Object)BigDecimal.ZERO);
            DepreCard card = new DepreCard(finCard, this);
            card.setClearPreDepre(this.clearPreDepre);
            ArrayList bizInfoLst = new ArrayList(16);
            card.setBizInfoLst(bizInfoLst);
            depreCardList.add(card);
        }
        return depreCardList;
    }

    private DynamicObject getAssetCategory(Long assetCatId) {
        return (DynamicObject)this.objPool.get((Object)assetCatId, "fa_assetcategory", this::objToAssetCat);
    }

    private DynamicObject objToAssetCat(Object assetCategoryId) {
        DynamicObject assetCategoryObj = QueryServiceHelper.queryOne((String)"fa_assetcategory", (String)"id, longnumber", (QFilter[])new QFilter("id", "=", assetCategoryId).toArray());
        return assetCategoryObj;
    }

    private DynamicObjectType getFinCardSubEntityType() {
        return (DynamicObjectType)this.objPool.get((Object)"fa_card_fin", "fa_card_fin_subType", this::_getFinCardSubEntityType);
    }

    private DynamicObjectType _getFinCardSubEntityType(Object entityName) {
        Set selector = EntityMetadataCache.getDataEntityType((String)"fa_card_fin").getFields().keySet();
        return EntityMetadataCache.getSubDataEntityType((String)"fa_card_fin", selector);
    }

    private DynamicObjectType getReadCardSubEntityType(Object entityName) {
        HashSet<String> selector = new HashSet<String>();
        selector.add("id");
        selector.add("masterid");
        selector.add("assetcat");
        selector.add("usestatus");
        selector.add("headusedept");
        selector.add("realaccountdate");
        selector.add("sourceflag");
        selector.add("sourceentryid");
        selector.add("srcbillid");
        selector.add("bizstatus");
        selector.add("number");
        return EntityMetadataCache.getSubDataEntityType((String)"fa_card_real", selector);
    }

    private void print(String prefix, Object obj) {
        String TAB = "  ";
        if (obj instanceof Tuple) {
            Tuple tuple = (Tuple)obj;
            String msg = (String)tuple.item1;
            Object value = tuple.item2;
            if (value instanceof List) {
                fileLogger.info(String.format("%s%s", prefix, msg));
                this.print(prefix + TAB, value);
            } else {
                fileLogger.info(String.format("%s%s: %s", prefix, msg, value.toString()));
            }
        } else if (obj instanceof List) {
            List lst = (List)obj;
            for (Object value : lst) {
                this.print(prefix, value);
            }
        }
    }

    public DynamicObject getDepreUse() {
        return this.depreUse;
    }

    public PeriodGroup getPeriodGroup() {
        return this.periodGroup;
    }

    public DynamicObject getCurPeriod() {
        return this.curPeriod;
    }

    public DynamicObject getOrg() {
        return this.org;
    }

    public List<Tuple<String, DynamicObject>> getAssetPolicyCache() {
        return this.assetPolicyCache;
    }

    public DynamicObject getBook() {
        return this.book;
    }

    public boolean isAnalyzeMode() {
        return this.analyzeMode;
    }

    public void setAnalyzeMode() {
        this.depreLogger = new DepreLogger4Analyze(this);
        this.analyzeMode = true;
    }

    public DepreLogger getLogger() {
        return this.depreLogger;
    }

    public BigDecimal getYearPeriodCount() {
        return this.yearPeriodCount;
    }

    public DynamicObject getEnablePeriod() {
        return this.enablePeriod;
    }

    public FaBizInfoPool getBizInfoPool() {
        return this.bizInfoPool;
    }

    public Date getDepreEndDate() {
        return this.depreEndDate;
    }

    public void setDepreEndDate(Date depreEndDate) {
        this.depreEndDate = depreEndDate;
    }

    public Date getSrcFinAccountDate(Object srcRealCardId) {
        return this.dispatchOutFinDateCache.get(srcRealCardId);
    }

    public Map<String, BigDecimal> getCardtoworkloadMap() {
        return this.cardtoworkloadMap;
    }

    public void setCardtoworkloadMap(Map<String, BigDecimal> cardtoworkloadMap) {
        this.cardtoworkloadMap = cardtoworkloadMap;
    }

    public boolean isClearPreDepre() {
        return this.clearPreDepre;
    }

    public void setClearPreDepre(boolean clearPreDepre) {
        this.clearPreDepre = clearPreDepre;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Set<Long> getNoEnterWkRealSet() {
        return this.noEnterWkRealSet;
    }

    public void setNoEnterWkRealSet(Set<Long> noEnterWkRealSet) {
        this.noEnterWkRealSet = noEnterWkRealSet;
    }

    public boolean isHasValueDepreIsNetamountLargePreresidualval() {
        return this.hasValueDepreIsNetamountLargePreresidualval;
    }

    public boolean isClearValueDepre() {
        return this.clearValueDepre;
    }

    public void setClearValueDepre(boolean clearValueDepre) {
        this.clearValueDepre = clearValueDepre;
    }

    public Long getClearValuePeriodId() {
        return this.clearValuePeriodId;
    }

    public void setClearValuePeriodId(Long clearValuePeriodId) {
        this.clearValuePeriodId = clearValuePeriodId;
    }

    public boolean isIgnoreUseStatus() {
        return this.ignoreUseStatus;
    }

    public void setIgnoreUseStatus(boolean ignoreUseStatus) {
        this.ignoreUseStatus = ignoreUseStatus;
    }

    public void initCurPeriod(DynamicObject curPeriod) {
        this.curPeriod = curPeriod;
        this.depreEndDate = Fa.getDFDate((Date)curPeriod.getDate("enddate"));
        this.init(curPeriod);
    }

    public Map<Long, Date> getRealMasterId2ClearBizdate() {
        return this.realMasterId2ClearBizdate;
    }

    public void setRealMasterId2ClearBizdate(Map<Long, Date> realMasterId2ClearBizdate) {
        this.realMasterId2ClearBizdate = realMasterId2ClearBizdate;
    }

    static {
        startDepreBizStatusList.add(BizStatusEnum.READY);
    }
}

