/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.DepreTimeEnum;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.DepreLogger;
import kd.fi.fa.business.depreciation.DepreLogger4Analyze;
import kd.fi.fa.business.depreciation.DepreMethod;
import kd.fi.fa.business.depreciation.DepreSegment;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FinCardUtil;
import kd.fi.fa.business.depreciation.FormulaDepreMethod;
import kd.fi.fa.business.depreciation.Fraction;
import kd.fi.fa.business.depreciation.RateDepreMethod;
import kd.fi.fa.business.depreciation.SubtractDepreMethod;
import kd.fi.fa.business.depreciation.SystemDepreMethod;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.common.util.Fa;

public class DepreCard
implements DepreAlgoInter {
    private static final Log flogger = LogFactory.getLog(DepreCard.class);
    private DynamicObject policy = null;
    private DepreTimeEnum depreTime = null;
    private final DynamicObject finCard;
    private final boolean isInitCard;
    private boolean isInitFromFinCard;
    private boolean isNewCurPeriodWithAccum;
    private final String cardNumber;
    private final BigDecimal beforeOriginalVal;
    private final BigDecimal beforeDecVal;
    private final BigDecimal beforeMonthDepre;
    private final BigDecimal beforeDepredAmount;
    private boolean needDepre = true;
    private boolean needPredictData = true;
    private BigDecimal preUseYear;
    private BigDecimal periodNumber;
    private final DynamicObject realCard;
    private final DepreBook book;
    private List<FaBizInfo> bizInfoLst;
    private Date dynamicBeginDate = null;
    private Date dispatchDate = null;
    private boolean needQueryBak;
    private DynamicObject periodOfBak;
    private Object[] updateDBParam;
    private boolean ignoreDecVal;
    private boolean clearPreDepre = false;
    private BigDecimal predictDepre = BigDecimal.ZERO;
    private final DepreLogger logger;
    private String alterStr;
    private boolean ignoreUseStatus = false;

    public DepreCard(DynamicObject fincard, DepreBook book) {
        this.finCard = fincard;
        this.cardNumber = this.finCard.getString("number");
        this.isInitCard = this.finCard.getLong("period_id") == 0L;
        this.beforeOriginalVal = fincard.getBigDecimal("originalval");
        this.beforeDecVal = fincard.getBigDecimal("decval");
        this.beforeMonthDepre = fincard.getBigDecimal("monthdepre");
        this.beforeDepredAmount = fincard.getBigDecimal("depredamount");
        this.realCard = (DynamicObject)fincard.get("realcard");
        this.book = book;
        this.logger = book.isAnalyzeMode() ? new DepreLogger4Analyze(book) : new DepreLogger();
        this.logger.begin("reverseCurDepre");
        this.addValue(this.finCard, "accumDepre", "monthDepre", false);
        this.addValue(this.finCard, "accumDepre", "restartaddeddepre", true);
        this.addValue(this.finCard, "addupYearDepre", "monthDepre", false);
        this.addValue(this.finCard, "addupYearDepre", "restartaddeddepre", true);
        this.addValue(this.finCard, "depredAmount", "addidepreamount", false);
        this.addValue(this.finCard, "depredAmount", "restartdepreamount", true);
        this.logger.end();
        this.analyzeYearInfo();
    }

    private void analyzeYearInfo() {
        BigDecimal yearPeriodCount;
        BigDecimal preUsingAmount = this.finCard.getBigDecimal("preusingamount");
        this.preUseYear = preUsingAmount.compareTo(yearPeriodCount = this.book.getYearPeriodCount()) < 0 ? new BigDecimal(1) : new Fraction(preUsingAmount, yearPeriodCount).toBigDecimal(0, RoundingMode.UP);
    }

    private List<FaBizInfo> getAdjustPeriodBizInfos(DynamicObject beginPeriod, DynamicObject curPeriod) {
        if (this.bizInfoLst.isEmpty()) {
            return new ArrayList<FaBizInfo>(1);
        }
        for (FaBizInfo bizInfo : this.bizInfoLst) {
            if (bizInfo.getBillDatePeriodId() != null && bizInfo.getBillDatePeriodId() != 0L) continue;
            DynamicObject periodId = this.book.getPeriodGroup().getPeriod(bizInfo.billDate, this.cardNumber);
            bizInfo.setBillDatePeriodId(Long.valueOf(periodId.getLong("id")));
        }
        Long minAdjustPeriodId = this.getAdjustMinPeriodId4Recur(beginPeriod.getLong("id"), curPeriod.getLong("id"));
        ArrayList<FaBizInfo> list = new ArrayList<FaBizInfo>(16);
        for (FaBizInfo bizInfo : this.bizInfoLst) {
            if (minAdjustPeriodId > bizInfo.getBillDatePeriodId() || bizInfo.getBillDatePeriodId() > curPeriod.getLong("id")) continue;
            list.add(bizInfo);
        }
        return list;
    }

    private Long getAdjustMinPeriodId4Recur(Long beginPeriodId, Long endPeriodId) {
        boolean isTraceAdjust = false;
        Long minAdjustPeriodId = beginPeriodId;
        for (FaBizInfo bizInfo : this.bizInfoLst) {
            Long billDatePeriodId = bizInfo.getBillDatePeriodId();
            if (beginPeriodId > billDatePeriodId || billDatePeriodId > endPeriodId) continue;
            if (bizInfo.type == 2) {
                isTraceAdjust = true;
                break;
            }
            if (bizInfo.type != 1) continue;
            Long bizDatePeriodId = bizInfo.getBizDatePeriodId();
            if (bizDatePeriodId == null || bizDatePeriodId == 0L) {
                DynamicObject bizDatePeriod = this.book.getPeriodGroup().getPeriod(bizInfo.bizDate, this.cardNumber);
                bizDatePeriodId = bizDatePeriod.getLong("id");
                bizInfo.setBizDatePeriodId(bizDatePeriodId);
            }
            if (bizDatePeriodId >= minAdjustPeriodId) continue;
            minAdjustPeriodId = bizDatePeriodId;
        }
        if (isTraceAdjust) {
            return beginPeriodId;
        }
        if (minAdjustPeriodId.compareTo(beginPeriodId) == 0) {
            return beginPeriodId;
        }
        DynamicObject preBeginPeriod = this.book.getPeriodGroup().getPrevPeriod((Object)beginPeriodId);
        Long preBeginPeriodId = null;
        preBeginPeriodId = preBeginPeriod != null ? Long.valueOf(preBeginPeriod.getLong("id")) : beginPeriodId;
        return this.getAdjustMinPeriodId4Recur(minAdjustPeriodId, preBeginPeriodId);
    }

    /*
     * WARNING - void declaration
     */
    public void depre() {
        long bizPeriodId;
        void var14_20;
        DynamicObject cate;
        boolean hasTraceAdjust;
        Date _adjustDate;
        List<FaBizInfo> curPeriodBizInfoLst = this.getAdjustPeriodBizInfos(this.book.getCurPeriod(), this.book.getCurPeriod());
        Map<Boolean, List<FaBizInfo>> map = curPeriodBizInfoLst.stream().collect(Collectors.partitioningBy(v -> v.type == 2));
        List<Object> notTraceBizInfoLst = map.get(false).stream().filter(v -> v.type != 4).collect(Collectors.toList());
        List<FaBizInfo> traceBizInfoLst = map.get(true);
        Date adjustDate = this.book.getCurPeriod().getDate("endDate");
        Date finAccountDate = this.finCard.getDate("finaccountDate");
        boolean fromDispatch = "DISPATCH".equals(this.realCard.getString("sourceflag")) && this.book.getPeriodGroup().dateCmpToPeriod(finAccountDate, this.book.getCurPeriod()) == 0;
        boolean dispatchAtNew = false;
        if (fromDispatch) {
            adjustDate = finAccountDate;
            dispatchAtNew = true;
        }
        if (!traceBizInfoLst.isEmpty()) {
            adjustDate = this.realCard.getDate("realaccountdate");
        } else if (!this.isInitCard && this.finCard.getLong("period_id") == this.book.getCurPeriod().getLong("id") && this.isInitFromFinCard) {
            adjustDate = this.finCard.getDate("finaccountdate");
        } else if (!this.isInitCard && this.book.getPeriodGroup().cmdPeriodByDate(adjustDate, finAccountDate, null) == 0 && !fromDispatch) {
            adjustDate = this.realCard.getDate("realaccountdate");
        } else if (curPeriodBizInfoLst.size() > 0 && (_adjustDate = curPeriodBizInfoLst.stream().map(v -> v.bizDate).min(Date::compareTo).get()).compareTo(adjustDate) < 0) {
            adjustDate = _adjustDate;
        }
        Date _date = finAccountDate;
        if (!this.isInitFromFinCard()) {
            if (this.isInitCard || this.book.getPeriodGroup().cmdPeriodByDate(adjustDate, _date, this.cardNumber) > 0) {
                _date = adjustDate;
            } else if (this.book.getPeriodGroup().cmdPeriodByDate(adjustDate, _date, this.cardNumber) == 0) {
                if (!this.isNewCurPeriodWithAccum) {
                    adjustDate = this.realCard.getDate("realaccountdate");
                }
            } else if (!fromDispatch) {
                adjustDate = this.realCard.getDate("realaccountdate");
            }
        }
        if (this.book.getPeriodGroup().dateCmpToPeriod(_date, this.book.getCurPeriod()) < 0) {
            this.needQueryBak = true;
            this.periodOfBak = this.book.getPeriodGroup().getPeriod(_date, this.cardNumber);
            this.logger.log("queryBakCard", (Object)this.periodOfBak);
        }
        Date curPeriodBeginDate = this.book.getCurPeriod().getDate("beginDate");
        Date curPeriodEndDate = this.book.getCurPeriod().getDate("endDate");
        ArrayList<FaBizInfo> futureBizLst = new ArrayList<FaBizInfo>();
        for (FaBizInfo faBizInfo : notTraceBizInfoLst) {
            if (this.book.getPeriodGroup().dateCmpToPeriod(faBizInfo.billDate, this.book.getCurPeriod()) != 0 || faBizInfo.bizDate.compareTo(curPeriodEndDate) <= 0) continue;
            futureBizLst.add(faBizInfo);
        }
        if (!futureBizLst.isEmpty()) {
            this.logger.begin("reverseFutureBiz");
            futureBizLst.sort((v1, v2) -> v2.auditDate.compareTo(v1.auditDate));
            for (FaBizInfo faBizInfo : futureBizLst) {
                this.reverseCard(faBizInfo, this.finCard);
            }
            this.logger.end();
        }
        BigDecimal accumDepreBeforeDepre = this.finCard.getBigDecimal("accumDepre");
        BigDecimal bigDecimal = this.finCard.getBigDecimal("addupYearDepre");
        BigDecimal curPeriodBeginDepredAmount = this.finCard.getBigDecimal("depredAmount");
        BigDecimal restartaddeddepre = this.finCard.getBigDecimal("restartaddeddepre");
        BigDecimal restartdepreamount = this.finCard.getBigDecimal("restartdepreamount");
        this.logger.log("depreInfoBeforeRunDepre", new Object[]{accumDepreBeforeDepre, bigDecimal, curPeriodBeginDepredAmount});
        List<DynamicObject> periodLst = null;
        boolean isReversed = false;
        if (curPeriodBeginDate.compareTo(adjustDate) <= 0 && this.book.getPeriodGroup().cmdPeriodByDate(curPeriodBeginDate, this.book.getDepreEndDate(), this.cardNumber) == 0) {
            periodLst = new ArrayList<DynamicObject>();
            periodLst.add(this.book.getCurPeriod());
        } else {
            DynamicObject _period;
            if (this.needQueryBak) {
                this.reverseToDepreBeginCard();
                _period = this.periodOfBak;
                this.logger.begin("reverseBakDepre");
                this.addValue(this.finCard, "accumDepre", "monthDepre", false);
                this.addValue(this.finCard, "addupYearDepre", "monthDepre", false);
                this.addValue(this.finCard, "depredAmount", "addidepreamount", false);
                this.addValue(this.finCard, "accumDepre", "restartaddeddepre", true);
                this.addValue(this.finCard, "addupYearDepre", "restartaddeddepre", true);
                this.addValue(this.finCard, "depredAmount", "restartdepreamount", true);
                this.logger.end();
                notTraceBizInfoLst = this.analyzeNoTraceBizBill(adjustDate);
            } else {
                _period = this.book.getCurPeriod();
            }
            if (this.needQueryBak || this.book.getPeriodGroup().dateCmpToPeriod(adjustDate, this.book.getCurPeriod()) < 0) {
                isReversed = true;
                ArrayList<FaBizInfo> bakPeriodBizLst = new ArrayList<FaBizInfo>();
                for (FaBizInfo faBizInfo : notTraceBizInfoLst) {
                    boolean condi = this.book.getPeriodGroup().dateCmpToPeriod(faBizInfo.billDate, _period) == 0 && this.book.getPeriodGroup().dateCmpToPeriod(faBizInfo.bizDate, this.book.getCurPeriod()) <= 0;
                    if (!condi) continue;
                    bakPeriodBizLst.add(faBizInfo);
                }
                bakPeriodBizLst.sort((v1, v2) -> v2.auditDate.compareTo(v1.auditDate));
                if (!bakPeriodBizLst.isEmpty()) {
                    this.logger.begin("reverseAdjustBiz");
                    for (FaBizInfo faBizInfo : bakPeriodBizLst) {
                        this.reverseCard(faBizInfo, this.finCard);
                    }
                    this.logger.end();
                }
            }
            periodLst = this.book.getPeriodGroup().getPeriods(adjustDate, this.book.getDepreEndDate(), this.cardNumber);
        }
        HashSet<String> traceFields = new HashSet<String>();
        traceBizInfoLst = this.analyzeChangeTraceBizBill(adjustDate);
        boolean bl = hasTraceAdjust = !traceBizInfoLst.isEmpty();
        if (hasTraceAdjust) {
            this.logger.begin("traceAdjust");
            this.finCard.set("accumdepre", (Object)BigDecimal.ZERO);
            this.finCard.set("monthdepre", (Object)BigDecimal.ZERO);
            this.finCard.set("depredamount", (Object)BigDecimal.ZERO);
            this.finCard.set("addidepreamount", (Object)BigDecimal.ZERO);
            this.finCard.set("addupyeardepre", (Object)BigDecimal.ZERO);
            for (FaBizInfo faBizInfo : traceBizInfoLst) {
                if (faBizInfo.isRealCardField()) {
                    traceFields.add("0" + faBizInfo.getField());
                } else {
                    traceFields.add("1" + faBizInfo.getField());
                }
                this.updateCard(faBizInfo, this.finCard);
            }
            this.logger.end();
        }
        DynamicObject firstPeriod = (DynamicObject)periodLst.get(0);
        this.periodNumber = new BigDecimal(firstPeriod.getInt("periodnumber"));
        List list3 = curPeriodBizInfoLst.stream().filter(v -> v.isSplitCard()).collect(Collectors.toList());
        list3 = list3.stream().filter(v -> v.getBillDatePeriodId().longValue() != this.finCard.getLong(Fa.id((String)"period"))).collect(Collectors.toList());
        list3 = list3.stream().filter(v -> v.billDate.compareTo(firstPeriod.getDate("enddate")) > 0).collect(Collectors.toList());
        Fraction splitRate = list3.stream().map(v -> v.getSplitRate()).reduce(Fraction.ONE, Fraction::multiply);
        this.finCard.set("accumDepre", (Object)splitRate.multiply(this.finCard.getBigDecimal("accumDepre")).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP));
        this.finCard.set("originalval", (Object)splitRate.multiply(this.finCard.getBigDecimal("originalval")).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP));
        this.finCard.set("decval", (Object)splitRate.multiply(this.finCard.getBigDecimal("decval")).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP));
        this.finCard.set("preresidualval", (Object)splitRate.multiply(this.finCard.getBigDecimal("preresidualval")).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP));
        List<FaBizInfo> bizInfoLst = notTraceBizInfoLst.stream().filter(biz -> biz.getField() != null || !traceFields.contains((biz.isRealCardField() ? "0" : "1") + biz.getField())).collect(Collectors.toList());
        List<DepreSegment> depreSegmentLst = this.analyzeBizInfo(bizInfoLst, periodLst, adjustDate, fromDispatch, dispatchAtNew);
        if (this.ignoreDecVal) {
            this.finCard.set("decval", (Object)BigDecimal.ZERO);
        }
        if ((cate = this.getAssetCategory()) == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u201c%s\u201d\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u522b\u4e3a\u7a7a\u3002", (String)"DepreCard_0", (String)"fi-fa-business", (Object[])new Object[0]), this.finCard.getString("number")));
        }
        this.policy = AssetPolicyUtil.getByAssetPolicyInfoAndCateLongNumber((String)cate.getString("longnumber"), this.book.getAssetPolicyCache());
        if (this.policy == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u201c%s\u201d\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u522b\u6ca1\u6709\u914d\u7f6e\u8d44\u4ea7\u653f\u7b56\u3002", (String)"DepreCard_1", (String)"fi-fa-business", (Object[])new Object[0]), this.finCard.getString("number")));
        }
        if (this.policy.getBoolean("nodepre")) {
            this.logger.log("stopDepre", (Object)5);
            this.needDepre = false;
            this.needPredictData = false;
            return;
        }
        this.depreTime = DepreTimeEnum.valueOf((String)this.policy.getString("depreTime"));
        this.logger.log("depreTime", (Object)this.depreTime);
        this.logger.begin("beginDepreSegs");
        this.logger.log("beginDepreSegs", (Object)this.finCard);
        BigDecimal lastParticalAmount = BigDecimal.ZERO;
        BigDecimal curMonthDepre = BigDecimal.ZERO;
        int segSize = depreSegmentLst.size();
        int segEndIndex = segSize - 1;
        for (int segIndex = 0; segIndex < segSize; ++segIndex) {
            boolean hasLeftPeriodOrWorkload;
            BigDecimal leftValueToDepre;
            boolean hasValueToDepre;
            DepreMethod method;
            DepreSegment seg = depreSegmentLst.get(segIndex);
            boolean lastSeg = segIndex == segEndIndex;
            this.logger.begin(seg.getAlias());
            if (isReversed && !seg.bizLst.isEmpty()) {
                this.logger.begin("updateBiz");
                this.updateCard(seg, this.finCard);
                this.logger.end();
            }
            if (seg.isFirstSegOfAccountYear()) {
                this.finCard.set("addupYearDepre", (Object)BigDecimal.ZERO);
            }
            if ((method = (DepreMethod)this.book.objPool.get(this.finCard.get("depreMethod_id"), "fa_depreMethod", this::objToDepreMethod)).getDepretimeEffective()) {
                Long curPeriodid = this.book.getCurPeriod().getLong("id");
                if (this.book.isClearValueDepre()) {
                    if (this.book.getClearValuePeriodId().longValue() == curPeriodid.longValue() && DepreTimeEnum.CLEAR == this.depreTime) {
                        seg.setRate(BigDecimal.ZERO);
                    }
                } else if (DepreTimeEnum.NEW == this.depreTime && segIndex == segSize - 1) {
                    if (seg.isAllClear() || this.clearPreDepre) {
                        seg.setRate(seg.getRate().subtract(BigDecimal.ONE));
                    }
                } else if (DepreTimeEnum.CLEAR == this.depreTime && segIndex == 0) {
                    boolean fromDispatchInSeg;
                    boolean bl2 = fromDispatchInSeg = "DISPATCH".equals(this.realCard.getString("sourceflag")) && this.book.getPeriodGroup().dateCmpToPeriod(finAccountDate, seg.getBeginDate(), seg.getEndDate()) == 0;
                    if (hasTraceAdjust || !this.isInitCard && seg.isIncludeNew() && !this.isNewCurPeriodWithAccum || !this.isInitCard && seg.isIncludeNew() && this.isNewCurPeriodWithAccum && fromDispatchInSeg) {
                        seg.setRate(seg.getRate().subtract(BigDecimal.ONE));
                    }
                }
            }
            boolean bl3 = hasValueToDepre = (leftValueToDepre = FinCardUtil.getLeftAmount((DynamicObject)this.finCard)).compareTo(BigDecimal.ZERO) != 0;
            if (this.book.isHasValueDepreIsNetamountLargePreresidualval()) {
                hasValueToDepre = leftValueToDepre.compareTo(BigDecimal.ZERO) > 0;
            }
            String depreMethodType = method.getDepreMethodType();
            BigDecimal leftPeriodCountOrWorkload = FinCardUtil.getLeftPeriod((DynamicObject)this.finCard);
            boolean bl4 = hasLeftPeriodOrWorkload = leftPeriodCountOrWorkload.compareTo(BigDecimal.ZERO) > 0;
            if (!hasLeftPeriodOrWorkload) {
                this.logger.log("stopDepre", (Object)1);
            } else if (!hasValueToDepre) {
                this.logger.log("stopDepre", (Object)2);
            } else if (seg.getRate().compareTo(BigDecimal.ZERO) <= 0) {
                this.logger.log("stopDepre", (Object)3);
            } else if (!this.ignoreUseStatus && !this.canDepre(this.finCard)) {
                this.logger.log("stopDepre", (Object)4);
            } else {
                boolean workLoadDepre;
                BigDecimal segmentDepre = leftValueToDepre;
                BigDecimal depredPeriodCount = leftPeriodCountOrWorkload;
                BigDecimal depredWorkLoadCount = leftPeriodCountOrWorkload;
                if (leftPeriodCountOrWorkload.compareTo(seg.getRate()) > 0) {
                    boolean handleClear;
                    boolean bl5 = handleClear = seg.isHasPartClear() && this.depreAtClear();
                    if (handleClear) {
                        this.logger.begin("addPartClear");
                        this.handlePartClear(this.finCard, seg, true);
                        this.logger.end();
                    }
                    BigDecimal particleDepre = method.compute((DepreAlgoInter)this, seg);
                    if (handleClear) {
                        this.logger.begin("deductPartClear");
                        this.handlePartClear(this.finCard, seg, false);
                        this.logger.end();
                    }
                    if (lastSeg && this.book.getPeriodGroup().dateCmpToPeriod(seg.getEndDate(), this.book.getCurPeriod()) == 0) {
                        lastParticalAmount = particleDepre;
                    }
                    if (depreMethodType.equals("5")) {
                        depredWorkLoadCount = this.book.getCardtoworkloadMap().get(FaDepreUtil.getFinCardWorkLoadKey((DepreAlgoInter)this, (DepreSegment)seg));
                        if (depredWorkLoadCount == null) {
                            depredWorkLoadCount = BigDecimal.ZERO;
                        }
                    } else {
                        depredPeriodCount = seg.getRate();
                    }
                    segmentDepre = particleDepre.multiply(seg.getRate());
                    if (depreMethodType.equals("5")) {
                        if (depredWorkLoadCount.compareTo(leftPeriodCountOrWorkload) > 0 || leftValueToDepre.compareTo(BigDecimal.ZERO) > 0 && segmentDepre.compareTo(leftValueToDepre) > 0) {
                            depredWorkLoadCount = leftPeriodCountOrWorkload;
                            segmentDepre = leftValueToDepre;
                            this.logger.log("extractAllLeftValue", (Object)leftValueToDepre);
                        }
                    } else if (leftPeriodCountOrWorkload.compareTo(BigDecimal.ONE) == 0 || leftValueToDepre.compareTo(BigDecimal.ZERO) > 0 && segmentDepre.compareTo(leftValueToDepre) > 0) {
                        segmentDepre = leftValueToDepre;
                        this.logger.log("extractAllLeftValue", (Object)leftValueToDepre);
                    }
                }
                boolean noWorkLoadDepre = segmentDepre.compareTo(BigDecimal.ZERO) > 0 || !depreMethodType.equals("5");
                boolean bl6 = workLoadDepre = segmentDepre.compareTo(BigDecimal.ZERO) != 0 || depreMethodType.equals("5");
                if (noWorkLoadDepre || workLoadDepre) {
                    this.addValue(this.finCard, "accumDepre", segmentDepre);
                    this.addValue(this.finCard, "addupYearDepre", segmentDepre);
                    if (depreMethodType.equals("5")) {
                        this.addValue(this.finCard, "depredAmount", depredWorkLoadCount);
                    } else {
                        this.addValue(this.finCard, "depredAmount", depredPeriodCount);
                    }
                    if (lastSeg) {
                        curMonthDepre = segmentDepre;
                    }
                }
            }
            this.periodNumber = this.periodNumber.remainder(this.book.getYearPeriodCount()).add(BigDecimal.ONE);
            this.logger.end();
        }
        this.logger.end();
        BigDecimal accumDepre = this.finCard.getBigDecimal("accumDepre");
        BigDecimal depredAmount = this.finCard.getBigDecimal("depredAmount");
        accumDepre = this.setPrecision(accumDepre);
        BigDecimal monthDepre = accumDepre.subtract(accumDepreBeforeDepre);
        if (this.book.getCurPeriod().getInt("periodnumber") == 1) {
            BigDecimal bigDecimal2 = monthDepre;
        } else {
            BigDecimal bigDecimal3 = bigDecimal.add(monthDepre);
        }
        BigDecimal monthDepre_adjust = monthDepre.subtract(lastParticalAmount);
        BigDecimal addedDepreAmount = BigDecimal.ZERO;
        addedDepreAmount = depredAmount.subtract(curPeriodBeginDepredAmount);
        BigDecimal depreRate = BigDecimal.ZERO;
        if (this.finCard.getBigDecimal("originalval").compareTo(BigDecimal.ZERO) > 0) {
            depreRate = monthDepre.divide(this.finCard.getBigDecimal("originalval"), 4, RoundingMode.HALF_UP);
        }
        monthDepre = monthDepre.add(restartaddeddepre);
        addedDepreAmount = addedDepreAmount.add(restartdepreamount);
        monthDepre = this.setPrecision(monthDepre);
        accumDepre = this.setPrecision(accumDepre);
        monthDepre_adjust = this.setPrecision(monthDepre_adjust);
        BigDecimal bigDecimal4 = this.setPrecision((BigDecimal)var14_20);
        this.finCard.set("monthdepre", (Object)monthDepre);
        this.finCard.set("monthdeprerate", (Object)depreRate);
        this.finCard.set("depredamount", (Object)depredAmount);
        this.finCard.set("addidepreamount", (Object)addedDepreAmount);
        this.finCard.set("accumdepre", (Object)accumDepre);
        this.finCard.set("addupyeardepre", (Object)bigDecimal4);
        this.finCard.set("curmonthdepre", (Object)curMonthDepre);
        BigDecimal netWorth = this.beforeOriginalVal.subtract(accumDepre);
        BigDecimal netAmount = netWorth.subtract(this.beforeDecVal);
        this.finCard.set("networth", (Object)netWorth);
        this.finCard.set("netamount", (Object)netAmount);
        if (netWorth.compareTo(BigDecimal.ZERO) < 0) {
            this.alterStr = String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u201c%s\u201d\u51c0\u503c\u4e3a\u8d1f\u6570\u3002", (String)"DepreCard_2", (String)"fi-fa-business", (Object[])new Object[0]), this.cardNumber);
            return;
        }
        if (netAmount.compareTo(BigDecimal.ZERO) < 0) {
            this.alterStr = String.format(ResManager.loadKDString((String)"\u5361\u7247\uff08\u7f16\u7801\uff1a%s\uff09\u7684\u51c0\u989d\u4e3a\u8d1f\u6570\u3002", (String)"DepreCard_3", (String)"fi-fa-business", (Object[])new Object[0]), this.cardNumber);
            return;
        }
        if (accumDepre.compareTo(BigDecimal.ZERO) < 0) {
            this.alterStr = String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u201c%s\u201d\u7d2f\u8ba1\u6298\u65e7\u4e3a\u8d1f\u6570\u3002", (String)"DepreCard_4", (String)"fi-fa-business", (Object[])new Object[0]), this.cardNumber);
            return;
        }
        if (depredAmount.compareTo(this.beforeDepredAmount) == 0 && monthDepre.compareTo(this.beforeMonthDepre) == 0) {
            this.needDepre = false;
        }
        if (addedDepreAmount.compareTo(BigDecimal.ZERO) == 0 && monthDepre.compareTo(BigDecimal.ZERO) == 0) {
            this.needPredictData = false;
        }
        if ((bizPeriodId = this.finCard.getLong("bizperiod_id")) < this.book.getCurPeriod().getLong("id")) {
            bizPeriodId = this.book.getCurPeriod().getLong("id");
            this.finCard.set("bizPeriod", (Object)this.book.getCurPeriod());
            this.finCard.set("monthorigvalchg", (Object)BigDecimal.ZERO);
            this.finCard.set("monthdeprechg", (Object)BigDecimal.ZERO);
            if (this.book.getCurPeriod().getInt("periodnumber") == 1) {
                this.finCard.set("yearorigvalchg", (Object)BigDecimal.ZERO);
            }
            this.finCard.set("monthaccumdeprechg", (Object)BigDecimal.ZERO);
        }
        BigDecimal monthorigvalchg = this.finCard.getBigDecimal("monthorigvalchg");
        BigDecimal monthdeprechg = this.finCard.getBigDecimal("monthdeprechg");
        BigDecimal yearorigvalchg = this.finCard.getBigDecimal("yearorigvalchg");
        BigDecimal monthaccumdeprechg = this.finCard.getBigDecimal("monthaccumdeprechg");
        this.updateDBParam = new Object[]{monthDepre, depreRate, depredAmount, addedDepreAmount, accumDepre, bigDecimal4, netWorth, netAmount, false, bizPeriodId, monthorigvalchg, monthdeprechg, yearorigvalchg, monthaccumdeprechg, this.finCard.get("id")};
        this.logger.log("depreResult", new Object[]{this, accumDepreBeforeDepre, restartaddeddepre, restartdepreamount});
    }

    private boolean depreAtClear() {
        return DepreTimeEnum.CLEAR == this.depreTime;
    }

    private void updateCard(DepreSegment seg, DynamicObject finCard) {
        for (FaBizInfo biz : seg.bizLst) {
            this.logger.begin(biz.getAlias());
            this.updateCard(biz, finCard);
            this.logger.end();
        }
    }

    private void updateCard(FaBizInfo biz, DynamicObject finCard) {
        if (!biz.isAllClear()) {
            if (biz.isPartClear()) {
                this.handlePartClear(finCard, biz, false);
            } else if (biz.getNewValue() != null) {
                if (biz.isRealCardField()) {
                    DynamicObject realcard = finCard.getDynamicObject("realcard");
                    realcard.set(biz.getField(), biz.getNewValue());
                } else {
                    finCard.set(biz.getField(), biz.getNewValue());
                }
                this.logger.log("updateCard", new Object[]{biz, true});
            } else {
                this.addValue(finCard, biz.getField(), (BigDecimal)biz.getDiffValue());
            }
        }
    }

    private void handlePartClear(DynamicObject finCard, FaBizInfo biz, boolean add) {
        BigDecimal dir = BigDecimal.ONE;
        if (!add) {
            dir = dir.negate();
        }
        this.addValue(finCard, "accumDepre", biz.getPartClearAccumDepre().multiply(dir));
        this.addValue(finCard, "originalval", biz.getPartClearOriginalVal().multiply(dir));
        this.addValue(finCard, "decval", biz.getPartClearDecVal().multiply(dir));
        this.addValue(finCard, "preresidualval", biz.getPartClearResidualVal().multiply(dir));
    }

    private void handlePartClear(DynamicObject finCard, DepreSegment seg, boolean add) {
        seg.bizLst.stream().filter(v -> v.isPartClear()).forEach(v -> this.handlePartClear(finCard, (FaBizInfo)v, add));
    }

    private void reverseCard(FaBizInfo futureBiz, DynamicObject finCard) {
        this.logger.begin(futureBiz.getAlias());
        if (!futureBiz.isAllClear()) {
            if (futureBiz.isPartClear()) {
                this.handlePartClear(finCard, futureBiz, true);
                this.addValue(finCard, "addupYearDepre", futureBiz.getPartClearAccumDepre());
            } else if (futureBiz.getOldValue() != null) {
                if (futureBiz.isRealCardField()) {
                    DynamicObject realCard = finCard.getDynamicObject("realcard");
                    realCard.set(futureBiz.getField(), futureBiz.getOldValue());
                } else {
                    finCard.set(futureBiz.getField(), futureBiz.getOldValue());
                }
                this.logger.log("updateCard", new Object[]{futureBiz, false});
            } else {
                this.addValue(finCard, futureBiz.getField(), ((BigDecimal)futureBiz.getDiffValue()).negate());
            }
        }
        this.logger.end();
    }

    private DepreMethod objToDepreMethod(Object methodPk) {
        DynamicObject depremethodObj = BusinessDataServiceHelper.loadSingleFromCache((Object)methodPk, (String)"fa_depremethod");
        if (depremethodObj == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\u201c%s\u201d\u7684\u6298\u65e7\u65b9\u6cd5\u57fa\u7840\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DepreCard_5", (String)"fi-fa-business", (Object[])new Object[0]), this.cardNumber));
        }
        String type = depremethodObj.getString("type");
        boolean deductresidualval = depremethodObj.getBoolean("deductresidualval");
        switch (type) {
            case "7": {
                return new SystemDepreMethod(type, this.book);
            }
            case "5": {
                return new SystemDepreMethod(type, this.book);
            }
            case "4": {
                return new SystemDepreMethod(type, this.book);
            }
            case "6": {
                return new SystemDepreMethod(type, this.book);
            }
            case "1": {
                ArrayList<BigDecimal> depreRateData = new ArrayList<BigDecimal>();
                for (DynamicObject depreYear : depremethodObj.getDynamicObjectCollection("entry_year")) {
                    for (DynamicObject deprePeriod : depreYear.getDynamicObjectCollection("entry_period")) {
                        BigDecimal perioddeprerate = deprePeriod.getBigDecimal("perioddeprerate");
                        perioddeprerate = this.stripPercent(perioddeprerate);
                        depreRateData.add(perioddeprerate);
                    }
                }
                return new RateDepreMethod(depreRateData, deductresidualval, type, this.book);
            }
            case "2": {
                String formula = depremethodObj.getString("customformula");
                return new FormulaDepreMethod(formula, type, this.book);
            }
            case "3": {
                String base = depremethodObj.getString("base");
                BigDecimal times = this.stripPercent(depremethodObj.getBigDecimal("times"));
                return new SubtractDepreMethod(base, deductresidualval, times, type, this.book);
            }
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u6298\u65e7\u65b9\u6cd5\u3002", (String)"DepreCard_6", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    private BigDecimal stripPercent(BigDecimal perioddeprerate) {
        int precision = perioddeprerate.scale() + 2;
        perioddeprerate = perioddeprerate.divide(new BigDecimal("100"), precision, 4);
        return perioddeprerate;
    }

    private boolean canDepre(DynamicObject fincard) {
        DynamicObject useStatus = this.getUseStatus();
        boolean isDepre = useStatus.getBoolean("isDepre");
        return isDepre;
    }

    private BigDecimal setPrecision(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return amount.setScale(this.book.precision, RoundingMode.HALF_UP);
    }

    private List<DepreSegment> analyzeBizInfo(List<FaBizInfo> bizInfoLst, List<DynamicObject> periodLst, Date adjustDate, boolean fromDispatch, boolean dispatchAtNew) {
        LinkedList<DepreSegment> depreSegmentStack = new LinkedList<DepreSegment>();
        boolean dynamic = false;
        if (this.dynamicBeginDate != null && this.dynamicBeginDate.compareTo(adjustDate) <= 0) {
            dynamic = true;
        }
        int bizIndex = 0;
        for (DynamicObject period : periodLst) {
            DepreSegment seg = new DepreSegment();
            seg.setBeginDate(period.getDate("beginDate"));
            seg.setEndDate(period.getDate("endDate"));
            seg.setPeriodId((Long)period.get("id"));
            seg.setRate(BigDecimal.ONE);
            seg.setFirstSegOfAccountYear(period.getInt("periodnumber") == 1);
            boolean includeNew = false;
            if (!this.isInitCard && !fromDispatch) {
                includeNew = this.book.getPeriodGroup().cmdPeriodByDate(seg.getBeginDate(), this.finCard.getDate("finaccountdate"), this.cardNumber) <= 0;
            } else if (dispatchAtNew) {
                includeNew = true;
            }
            seg.setIncludeNew(includeNew);
            while (bizIndex < bizInfoLst.size()) {
                FaBizInfo biz = bizInfoLst.get(bizIndex);
                if (biz.bizDate.compareTo(seg.getEndDate()) > 0) break;
                seg.addBiz(biz);
                boolean bl = dynamic = dynamic || biz.type == 1;
                if (biz.isAllClear()) {
                    seg.setAllClear(Boolean.TRUE.booleanValue());
                    break;
                }
                if (biz.isPartClear()) {
                    seg.setHasPartClear();
                }
                ++bizIndex;
            }
            seg.setDynamic(dynamic);
            depreSegmentStack.add(seg);
            if (!seg.isAllClear()) continue;
            break;
        }
        return depreSegmentStack;
    }

    private void addValue(DynamicObject fincard, String field, BigDecimal diffValue) {
        this.logger.log("addValue", new Object[]{field, diffValue});
        BigDecimal value = fincard.getBigDecimal(field);
        value = value.add(diffValue);
        fincard.set(field, (Object)value);
    }

    private void addValue(DynamicObject fincard, String field, String field2, boolean add) {
        BigDecimal diffValue = fincard.getBigDecimal(field2);
        if (!add) {
            diffValue = diffValue.negate();
        }
        this.addValue(fincard, field, diffValue);
    }

    private List<FaBizInfo> analyzeNoTraceBizBill(Date adjustDate) {
        List<FaBizInfo> bizInfoLst = this.getNoTraceBizInfo(adjustDate);
        bizInfoLst.sort((v1, v2) -> v1.auditDate.compareTo(v2.auditDate));
        FaBizInfo clearAllBizInfo = null;
        HashMap<String, LinkedList<FaBizInfo>> field2BizList = new HashMap<String, LinkedList<FaBizInfo>>(16);
        LinkedList<FaBizInfo> notFieldBizList = new LinkedList<FaBizInfo>();
        for (FaBizInfo faBizInfo : bizInfoLst) {
            if (faBizInfo.isAllClear()) {
                clearAllBizInfo = faBizInfo;
                break;
            }
            if (faBizInfo.getField() == null || faBizInfo.getField().length() == 0) {
                notFieldBizList.add(faBizInfo);
                continue;
            }
            LinkedList<FaBizInfo> tempBizList = (LinkedList<FaBizInfo>)field2BizList.get(faBizInfo.getField());
            if (tempBizList == null) {
                tempBizList = new LinkedList<FaBizInfo>();
                field2BizList.put(faBizInfo.getField(), tempBizList);
            }
            tempBizList.add(faBizInfo);
            if (faBizInfo.getBizDatePeriodId() != null && faBizInfo.getBizDatePeriodId() != 0L) continue;
            DynamicObject periodId = this.book.getPeriodGroup().getPeriod(faBizInfo.bizDate, this.cardNumber);
            faBizInfo.setBizDatePeriodId(Long.valueOf(periodId.getLong("id")));
        }
        for (Map.Entry entry : field2BizList.entrySet()) {
            HashSet<FaBizInfo> loseBizInfoSet = new HashSet<FaBizInfo>(16);
            List tempBizList = (List)entry.getValue();
            for (int i = tempBizList.size() - 1; i >= 1; --i) {
                FaBizInfo faBizInfo = (FaBizInfo)tempBizList.get(i);
                for (int j = i - 1; j >= 0; --j) {
                    FaBizInfo prevFaBizInfo = (FaBizInfo)tempBizList.get(j);
                    if (loseBizInfoSet.contains(prevFaBizInfo) || prevFaBizInfo.getBizDatePeriodId() < faBizInfo.getBizDatePeriodId()) continue;
                    loseBizInfoSet.add(prevFaBizInfo);
                }
            }
            tempBizList.removeAll(loseBizInfoSet);
        }
        LinkedList<FaBizInfo> bizInfoLst2 = new LinkedList<FaBizInfo>();
        for (List list : field2BizList.values()) {
            bizInfoLst2.addAll(list);
        }
        bizInfoLst2.addAll(notFieldBizList);
        bizInfoLst2.sort((v1, v2) -> v1.bizDate.compareTo(v2.bizDate));
        if (clearAllBizInfo != null) {
            bizInfoLst2.add(clearAllBizInfo);
        }
        return bizInfoLst2;
    }

    private List<FaBizInfo> analyzeChangeTraceBizBill(Date adjustDate) {
        List<FaBizInfo> bizInfoLst = this.getTraceBizInfo(adjustDate);
        bizInfoLst.sort(new Comparator<FaBizInfo>(){

            @Override
            public int compare(FaBizInfo arg0, FaBizInfo arg1) {
                if (arg0.getField().equals(arg1.getField())) {
                    return arg0.auditDate.compareTo(arg1.auditDate);
                }
                return arg0.getField().compareTo(arg1.getField());
            }
        });
        ArrayList<FaBizInfo> bizInfoLstResult = new ArrayList<FaBizInfo>(bizInfoLst.size() * 8 / 10);
        for (int i = 0; i < bizInfoLst.size(); ++i) {
            FaBizInfo bizInfo = bizInfoLst.get(i);
            String field = bizInfo.getField();
            FaBizInfo nextBizInfo = null;
            String nextField = "";
            if (i + 1 < bizInfoLst.size()) {
                nextBizInfo = bizInfoLst.get(i + 1);
                nextField = nextBizInfo.getField();
            }
            if (field.equals(nextField)) continue;
            bizInfoLstResult.add(bizInfo);
        }
        return bizInfoLstResult;
    }

    private List<FaBizInfo> getNoTraceBizInfo(Date adjustDate) {
        return this.bizInfoLst.stream().filter(v -> v.type != 2 && v.type != 4 && v.bizDate.compareTo(adjustDate) >= 0).collect(Collectors.toList());
    }

    private List<FaBizInfo> getTraceBizInfo(Date adjustDate) {
        return this.bizInfoLst.stream().filter(v -> v.type == 2 && v.bizDate.compareTo(adjustDate) >= 0).collect(Collectors.toList());
    }

    public DepreBook getBook() {
        return this.book;
    }

    public DynamicObject getFinCard() {
        return this.finCard;
    }

    private DynamicObject getAssetCategory() {
        return (DynamicObject)this.book.objPool.get((Object)this.realCard.getLong("assetcat_id"), "fa_assetcategory", this::objToAssetCat);
    }

    private DynamicObject getUseStatus() {
        return (DynamicObject)this.book.objPool.get((Object)this.realCard.getLong("usestatus_id"), "fa_usestatus", this::objToUseStatus);
    }

    private DynamicObject objToAssetCat(Object assetCategoryId) {
        DynamicObject assetCategoryObj = QueryServiceHelper.queryOne((String)"fa_assetcategory", (String)"id, longnumber", (QFilter[])new QFilter("id", "=", assetCategoryId).toArray());
        return assetCategoryObj;
    }

    private DynamicObject objToUseStatus(Object useStatusId) {
        DynamicObject useStatusObj = QueryServiceHelper.queryOne((String)"fa_usestatus", (String)"id, isdepre", (QFilter[])new QFilter("id", "=", useStatusId).toArray());
        return useStatusObj;
    }

    public boolean isNeedQueryBak() {
        return this.needQueryBak;
    }

    public DynamicObject getPeriodOfBak() {
        return this.periodOfBak;
    }

    public boolean isNeedDepre() {
        return this.needDepre;
    }

    public DynamicObject getRealCard() {
        return this.realCard;
    }

    public Object[] getUpdateDBParam() {
        return this.updateDBParam;
    }

    public void setIgnoreDecVal(boolean ignoreDecVal) {
        this.ignoreDecVal = ignoreDecVal;
    }

    public void setClearPreDepre(boolean clearPreDepre) {
        this.clearPreDepre = clearPreDepre;
    }

    public boolean isClearPreDepre() {
        return this.clearPreDepre;
    }

    public DepreLogger getLogger() {
        return this.logger;
    }

    public void setDynamicBeginDate(Date dynamicBeginDate) {
        this.dynamicBeginDate = dynamicBeginDate;
    }

    public boolean isInitFromFinCard() {
        return this.isInitFromFinCard;
    }

    public void setInitFromFinCard(boolean initFromFinCard) {
        this.isNewCurPeriodWithAccum = initFromFinCard;
        this.isInitFromFinCard = initFromFinCard && this.finCard.getLong("period_id") == this.book.getCurPeriod().getLong("id");
    }

    public BigDecimal getPreUseYear() {
        return this.preUseYear;
    }

    public boolean isNeedPredictData() {
        return this.needPredictData;
    }

    public void setNeedPredictData(boolean needPredictData) {
        this.needPredictData = needPredictData;
    }

    public BigDecimal getUsedYear() {
        BigDecimal depredAmount = this.finCard.getBigDecimal("depredamount");
        BigDecimal yearPeriodCount = this.book.getYearPeriodCount();
        BigDecimal usedYear = new Fraction(depredAmount, yearPeriodCount).toBigDecimal(0, RoundingMode.DOWN);
        return usedYear;
    }

    private void reverseToDepreBeginCard() {
        String selectFields = Fa.comma((String[])new String[]{"originalval", "decval", "preresidualval", "preusingamount", "depremethod", "monthdepre", "accumdepre", "addupyeardepre", "depredamount", "addidepreamount", "restartaddeddepre", "restartdepreamount", "realcard.usestatus usestatus", "realcard.realaccountdate realaccountdate"});
        DynamicObject periodOfBak = this.getPeriodOfBak();
        Object periodOfBakId = periodOfBak.get("id");
        DynamicObject finCard = this.getFinCard();
        DynamicObject realCard = finCard.getDynamicObject("realcard");
        QFilter[] filters = new QFilter[]{new QFilter("realcard.masterid", "=", realCard.get("masterId")), new QFilter("depreuse", "=", this.book.getDepreUse().getPkValue()), new QFilter("bizperiod", "<=", periodOfBakId), new QFilter("endperiod", ">", periodOfBakId)};
        DynamicObject reverseData = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)selectFields, (QFilter[])filters);
        if (reverseData == null) {
            filters = new QFilter[]{new QFilter("realcard.masterid", "=", realCard.get("masterId")), new QFilter("depreuse", "=", this.book.getDepreUse().getPkValue())};
            reverseData = (DynamicObject)QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])filters, (String)"bizperiod asc", (int)1).get(0);
        }
        finCard.set("originalval", reverseData.get("originalval"));
        finCard.set("decval", reverseData.get("decval"));
        finCard.set("preresidualval", reverseData.get("preresidualval"));
        finCard.set("preusingamount", reverseData.get("preusingamount"));
        finCard.set("depremethod", reverseData.get("depremethod"));
        finCard.set("monthdepre", reverseData.get("monthdepre"));
        finCard.set("accumdepre", reverseData.get("accumdepre"));
        finCard.set("addupyeardepre", reverseData.get("addupyeardepre"));
        finCard.set("depredamount", reverseData.get("depredamount"));
        finCard.set("addidepreamount", reverseData.get("addidepreamount"));
        finCard.set("restartaddeddepre", reverseData.get("restartaddeddepre"));
        finCard.set("restartdepreamount", reverseData.get("restartdepreamount"));
        realCard.set("usestatus_id", reverseData.get("usestatus"));
        realCard.set("realaccountdate", reverseData.get("realaccountdate"));
    }

    public BigDecimal getPredictDepre() {
        return this.predictDepre;
    }

    public BigDecimal getPeriodNumber() {
        return this.periodNumber;
    }

    public Date getDispatchDate() {
        return this.dispatchDate;
    }

    public void setDispatchDate(Date dispatchDate) {
        this.dispatchDate = dispatchDate;
    }

    public String toString() {
        return "DepreCard [finCard=" + this.finCard + "]";
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getAlterStr() {
        return this.alterStr;
    }

    public void setBizInfoLst(List<FaBizInfo> bizInfoLst) {
        this.bizInfoLst = bizInfoLst;
    }

    public boolean isIgnoreUseStatus() {
        return this.ignoreUseStatus;
    }

    public void setIgnoreUseStatus(boolean ignoreUseStatus) {
        this.ignoreUseStatus = ignoreUseStatus;
    }
}

