/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.depreciation;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.fa.business.DepreTimeEnum;
import kd.fi.fa.business.depreciation.DayDepreCard;
import kd.fi.fa.business.depreciation.DepreAlgoInter;
import kd.fi.fa.business.depreciation.DepreBook;
import kd.fi.fa.business.depreciation.DepreCard;
import kd.fi.fa.business.depreciation.DepreLogger;
import kd.fi.fa.business.depreciation.DepreSegment;
import kd.fi.fa.business.depreciation.FaBizInfo;
import kd.fi.fa.business.depreciation.FinCardUtil;
import kd.fi.fa.business.depreciation.Fraction;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class DepreLogger4Analyze
extends DepreLogger {
    private final DepreBook book;
    private final Map<String, String> beginMsg = new HashMap<String, String>();
    private final Stack<List<Tuple<String, Object>>> stack;

    public DepreLogger4Analyze(DepreBook book) {
        this.beginMsg.put("reverseFutureBiz", ResManager.loadKDString((String)"\u5012\u7b97\u672a\u6765\u53d1\u751f\u7684\u4e1a\u52a1", (String)"DepreLogger4Analyze_0", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("reverseAdjustBiz", ResManager.loadKDString((String)"\u5012\u7b97\u5728\u8c03\u6574\u671f\u95f4\u5236\u5355\u7684\u4e1a\u52a1", (String)"DepreLogger4Analyze_1", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("reverseCurDepre", ResManager.loadKDString((String)"\u5012\u7b97\u672c\u671f\u5df2\u7ecf\u63d0\u7684\u6298\u65e7", (String)"DepreLogger4Analyze_2", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("reverseBakDepre", ResManager.loadKDString((String)"\u5012\u7b97\u5907\u4efd\u5361\u7247\u5df2\u7ecf\u63d0\u7684\u6298\u65e7", (String)"DepreLogger4Analyze_3", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("allClearNoReverse", ResManager.loadKDString((String)"\u5b8c\u5168\u6e05\u7406\uff0c\u65e0\u9700\u5012\u7b97", (String)"DepreLogger4Analyze_4", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("traceAdjust", ResManager.loadKDString((String)"\u8ffd\u6eaf\u8c03\u6574", (String)"DepreLogger4Analyze_5", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("beginDepreSegs", ResManager.loadKDString((String)"\u5206\u6bb5\u8ba1\u7b97", (String)"DepreLogger4Analyze_6", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("updateBiz", ResManager.loadKDString((String)"\u66f4\u65b0\u4e1a\u52a1", (String)"DepreLogger4Analyze_7", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("addPartClear", ResManager.loadKDString((String)"\u6e05\u7406\u8ba1\u63d0\uff0c\u8865\u52a0\u90e8\u5206\u6e05\u7406\u4ef7\u503c", (String)"DepreLogger4Analyze_8", (String)"fi-fa-business", (Object[])new Object[0]));
        this.beginMsg.put("deductPartClear", ResManager.loadKDString((String)"\u6e05\u7406\u8ba1\u63d0,\u8ba1\u7b97\u5b8c\u6bd5\u540e\uff0c\u91cd\u65b0\u51cf\u53bb\u90e8\u5206\u6e05\u7406\u4ef7\u503c", (String)"DepreLogger4Analyze_9", (String)"fi-fa-business", (Object[])new Object[0]));
        this.stack = new Stack();
        this.stack.push(new LinkedList());
        this.book = book;
    }

    private void _begin(String msg) {
        if (msg == null) {
            msg = "NULL";
        }
        LinkedList subLst = new LinkedList();
        this.stack.peek().add((Tuple<String, Object>)new Tuple((Object)msg, subLst));
        this.stack.push(subLst);
    }

    private void _log(String msg, Object value) {
        if (msg == null) {
            msg = "NULL";
        }
        this.stack.peek().add((Tuple<String, Object>)new Tuple((Object)msg, value));
    }

    private void _log(String msg, String fmt, Object ... value) {
        this._log(msg, String.format(fmt, value));
    }

    public void begin(String msg) {
        String msg2 = this.beginMsg.get(msg);
        if (msg2 == null) {
            msg2 = msg;
        }
        this._begin(msg2);
    }

    public void end() {
        this.stack.pop();
    }

    public List<Tuple<String, Object>> getResult() {
        return (List)this.stack.get(0);
    }

    public String toJson() {
        return this._toJson(this.stack.get(0));
    }

    public String _toJson(Object obj) {
        if (obj instanceof Tuple) {
            Tuple tuple = (Tuple)obj;
            String msg = (String)tuple.item1;
            Object value = tuple.item2;
            if (value instanceof List) {
                return String.format("\"%s\":%s", msg, this._toJson(value));
            }
            if (value instanceof String || value instanceof Boolean) {
                return String.format("\"%s\": \"%s\"", msg, value);
            }
            if (value instanceof Date) {
                return String.format("\"%s\": \"%s\"", msg, Fa.getTF().format((Date)value));
            }
            return String.format("\"%s\": \"%s\"", msg, value.toString());
        }
        List lst = (List)obj;
        StringBuilder buf = new StringBuilder("{");
        for (Object value : lst) {
            buf.append(this._toJson(value)).append(",");
        }
        String str = buf.length() > 1 ? buf.substring(0, buf.length() - 1) + "}" : buf.append("}").toString();
        return str;
    }

    public void log(String method, Object value) {
        try {
            Method m = ((Object)((Object)this)).getClass().getDeclaredMethod(method, value.getClass());
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void log(String method, Object ... value) {
        try {
            Method m = ((Object)((Object)this)).getClass().getDeclaredMethod(method, value.getClass());
            m.invoke((Object)this, new Object[]{value});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void depreTime(DepreTimeEnum depreTimeEnum) {
        this._log(ResManager.loadKDString((String)"\u8ba1\u63d0\u65f6\u70b9", (String)"DepreLogger4Analyze_10", (String)"fi-fa-business", (Object[])new Object[0]), depreTimeEnum.getName());
    }

    private void assetNumber(DepreCard depreCard) {
        this._log(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801: %s", (String)"DepreLogger4Analyze_11", (String)"fi-fa-business", (Object[])new Object[0]), depreCard.getFinCard().getString("number")), depreCard.getLogger().getResult());
    }

    private void assetNumber4Day(DayDepreCard depreCard) {
        this._log(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801: %s", (String)"DepreLogger4Analyze_11", (String)"fi-fa-business", (Object[])new Object[0]), depreCard.getFinCard().getString("number")), depreCard.getLogger().getResult());
    }

    private void queryBakCard(DynamicObject periodOfBak) {
        this._log(ResManager.loadKDString((String)"\u67e5\u8be2\u6b64\u671f\u95f4\u7684\u5907\u4efd\u5361\u7247", (String)"DepreLogger4Analyze_12", (String)"fi-fa-business", (Object[])new Object[0]), periodOfBak.getString("number"));
    }

    private void preDepre4Clean(Object ... args) {
        int i = 0;
        BigDecimal initAccumDepre = (BigDecimal)args[i++];
        BigDecimal clearRate = (BigDecimal)args[i++];
        BigDecimal monthDepre = (BigDecimal)args[i++];
        BigDecimal clrAccumDepre = (BigDecimal)args[i++];
        BigDecimal clrDepredAmount = (BigDecimal)args[i++];
        this._log(ResManager.loadKDString((String)"\u671f\u521d\u7d2f\u8ba1\u6298\u65e7", (String)"DepreLogger4Analyze_13", (String)"fi-fa-business", (Object[])new Object[0]), initAccumDepre);
        this._log(ResManager.loadKDString((String)"\u6e05\u7406\u6bd4\u7387", (String)"DepreLogger4Analyze_14", (String)"fi-fa-business", (Object[])new Object[0]), clearRate);
        this._log(ResManager.loadKDString((String)"\u6e05\u7406\u90e8\u5206\u4ef7\u503c\u8ba1\u63d0\u989d\u5ea6", (String)"DepreLogger4Analyze_15", (String)"fi-fa-business", (Object[])new Object[0]), monthDepre);
        this._log(ResManager.loadKDString((String)"\u6e05\u7406\u7d2f\u8ba1\u6298\u65e7", (String)"DepreLogger4Analyze_16", (String)"fi-fa-business", (Object[])new Object[0]), clrAccumDepre);
        this._log(ResManager.loadKDString((String)"\u6e05\u7406\u5df2\u6298\u65e7\u5bff\u547d", (String)"DepreLogger4Analyze_17", (String)"fi-fa-business", (Object[])new Object[0]), clrDepredAmount);
    }

    private void updateCard(Object ... args) {
        int i = 0;
        FaBizInfo biz = (FaBizInfo)args[i++];
        boolean forward = (Boolean)args[i++];
        if (biz.isRealCardField()) {
            this._log(ResManager.loadKDString((String)"\u503c\u66f4\u65b0", (String)"DepreLogger4Analyze_18", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 realcard.%1$s \u66f4\u65b0\u4e3a %2$s", (String)"DepreLogger4Analyze_19", (String)"fi-fa-business", (Object[])new Object[0]), biz.getField(), forward ? biz.getNewValue() : biz.getOldValue()));
        } else {
            this._log(ResManager.loadKDString((String)"\u503c\u66f4\u65b0", (String)"DepreLogger4Analyze_18", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 %1$s \u66f4\u65b0\u4e3a %2$s", (String)"DepreLogger4Analyze_20", (String)"fi-fa-business", (Object[])new Object[0]), biz.getField(), forward ? biz.getNewValue() : biz.getOldValue()));
        }
    }

    private void addValue(Object ... args) {
        int i = 0;
        String field = (String)args[i++];
        BigDecimal diffValue = (BigDecimal)args[i++];
        this._log(ResManager.loadKDString((String)"\u52a0\u6cd5\u66f4\u65b0", (String)"DepreLogger4Analyze_21", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5b57\u6bb5 %1$s \u589e\u52a0 %2$s", (String)"DepreLogger4Analyze_22", (String)"fi-fa-business", (Object[])new Object[0]), field, diffValue));
    }

    private void depreResult(Object ... args) {
        int i = 0;
        DepreAlgoInter depreCard = (DepreAlgoInter)args[i++];
        BigDecimal accumDepreBeforeDepre = (BigDecimal)args[i++];
        BigDecimal accumDepre = depreCard.getFinCard().getBigDecimal("accumdepre");
        BigDecimal monthDepre = depreCard.getFinCard().getBigDecimal("monthdepre");
        BigDecimal restartaddeddepre = (BigDecimal)args[i++];
        BigDecimal restartdepreamount = (BigDecimal)args[i++];
        this._log(ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7", (String)"DepreLogger4Analyze_23", (String)"fi-fa-business", (Object[])new Object[0]), accumDepre);
        this._log(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d", (String)"DepreLogger4Analyze_24", (String)"fi-fa-business", (Object[])new Object[0]), depreCard.getFinCard().getBigDecimal("depredamount"));
        this._log(ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7", (String)"DepreLogger4Analyze_25", (String)"fi-fa-business", (Object[])new Object[0]), depreCard.getFinCard().getBigDecimal("addupyeardepre"));
        this._log(ResManager.loadKDString((String)"\u91cd\u542f\u8865\u63d0\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_68", (String)"fi-fa-business", (Object[])new Object[0]), restartaddeddepre);
        this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_26", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7-\u8ba1\u63d0\u524d\u7684\u7d2f\u8ba1\u6298\u65e7+\u91cd\u542f\u8865\u63d0\u6298\u65e7\u989d=%1$s-%2$s+%3$s=%4$s", (String)"DepreLogger4Analyze_27", (String)"fi-fa-business", (Object[])new Object[0]), accumDepre, accumDepreBeforeDepre, restartaddeddepre, monthDepre));
        this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u7387", (String)"DepreLogger4Analyze_28", (String)"fi-fa-business", (Object[])new Object[0]), depreCard.getFinCard().getBigDecimal("monthdeprerate"));
        this._log(ResManager.loadKDString((String)"\u672c\u671f\u6298\u65e7\u5bff\u547d", (String)"DepreLogger4Analyze_31", (String)"fi-fa-business", (Object[])new Object[0]), depreCard.getFinCard().getBigDecimal("addidepreamount"));
        this._log(ResManager.loadKDString((String)"\u51c0\u503c", (String)"DepreLogger4Analyze_32", (String)"fi-fa-business", (Object[])new Object[0]), depreCard.getFinCard().getBigDecimal("networth"));
        this._log(ResManager.loadKDString((String)"\u51c0\u989d", (String)"DepreLogger4Analyze_33", (String)"fi-fa-business", (Object[])new Object[0]), depreCard.getFinCard().getBigDecimal("netamount"));
        if (!depreCard.isNeedDepre()) {
            this._log(ResManager.loadKDString((String)"\u8ba1\u7b97\u540e\u7684\u671f\u6298\u65e7\u989d\u548c\u5df2\u6298\u65e7\u5bff\u547d\u90fd\u548c\u8ba1\u7b97\u524d\u4e00\u6837\uff0c\u5224\u5b9a\u4e3a\u65e0\u9700\u6298\u65e7", (String)"DepreLogger4Analyze_34", (String)"fi-fa-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7565", (String)"DepreLogger4Analyze_35", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private void allClearNoReverse() {
        this._log(ResManager.loadKDString((String)"\u5b8c\u5168\u6e05\u7406\uff0c\u65e0\u9700\u5012\u7b97", (String)"DepreLogger4Analyze_4", (String)"fi-fa-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7565", (String)"DepreLogger4Analyze_35", (String)"fi-fa-business", (Object[])new Object[0]));
    }

    private void depreInfoBeforeRunDepre(Object ... args) {
        int i = 0;
        BigDecimal accumDepreBeforeDepre = (BigDecimal)args[i++];
        BigDecimal addupYearDepre = (BigDecimal)args[i++];
        BigDecimal curPeriodBeginDepredAmount = (BigDecimal)args[i++];
        this._log(ResManager.loadKDString((String)"\u8ba1\u63d0\u524d\u7d2f\u8ba1\u6298\u65e7", (String)"DepreLogger4Analyze_36", (String)"fi-fa-business", (Object[])new Object[0]), accumDepreBeforeDepre);
        this._log(ResManager.loadKDString((String)"\u8ba1\u63d0\u524d\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7", (String)"DepreLogger4Analyze_37", (String)"fi-fa-business", (Object[])new Object[0]), addupYearDepre);
        this._log(ResManager.loadKDString((String)"\u8ba1\u63d0\u524d\u5df2\u6298\u65e7\u5bff\u547d", (String)"DepreLogger4Analyze_38", (String)"fi-fa-business", (Object[])new Object[0]), curPeriodBeginDepredAmount);
    }

    private void beginDepreSegs(DynamicObject finCard) {
        this._log(ResManager.loadKDString((String)"\u5f00\u59cb\u7d2f\u8ba1\u6298\u65e7", (String)"DepreLogger4Analyze_39", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getBigDecimal("accumDepre"));
        this._log(ResManager.loadKDString((String)"\u5f00\u59cb\u5df2\u6298\u65e7\u5bff\u547d", (String)"DepreLogger4Analyze_40", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getBigDecimal("depredAmount"));
    }

    private void compute100(Object ... args) {
        int i = 0;
        boolean dynamic = (Boolean)args[i++];
        DynamicObject finCard = (DynamicObject)args[i++];
        BigDecimal result = (BigDecimal)args[i++];
        String expr = dynamic ? "(originalVal-accumDepre-decVal-preResidualVal)/(preUsingAmount-depredAmount)" : "(originalVal-preResidualVal)/preUsingAmount";
        this._log(ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b", (String)"DepreLogger4Analyze_41", (String)"fi-fa-business", (Object[])new Object[0]), this.convertExpress(expr, finCard, result, new Object[0]));
    }

    private void compute500(Object ... args) {
        this.compute100(args);
        int i = args.length;
        BigDecimal dayDepreAmt = (BigDecimal)args[i - 3];
        BigDecimal dayCount = (BigDecimal)args[i - 2];
        BigDecimal result = (BigDecimal)args[i - 1];
        this._log(ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b", (String)"DepreLogger4Analyze_41", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u6298\u65e7\u989d = \u6bcf\u65e5\u6298\u65e7\u989d*\u5929\u6570 = %1$s*%2$s = %3$s", (String)"DepreLogger4Analyze_69", (String)"fi-fa-business", (Object[])new Object[0]), dayDepreAmt, dayCount, result));
    }

    private String convertExpress(String expr, DynamicObject finCard, BigDecimal result, Object ... args) {
        DynamicObjectType type = finCard.getDynamicObjectType();
        String regex = "(\\w+|\\$\\d+)";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(expr);
        String aliasExpr = expr;
        String valueExpr = expr;
        boolean i = false;
        while (matcher.find()) {
            String propName = matcher.group();
            if (propName.startsWith("$")) continue;
            aliasExpr = aliasExpr.replace(propName, type.getProperty(propName).getDisplayName().getLocaleValue());
            valueExpr = valueExpr.replace(propName, finCard.get(propName).toString());
        }
        return aliasExpr + " = " + valueExpr + " = " + result;
    }

    private void stopDepre(Integer type) {
        String msg = ResManager.loadKDString((String)"\u505c\u6b62\u8ba1\u63d0", (String)"DepreLogger4Analyze_42", (String)"fi-fa-business", (Object[])new Object[0]);
        if (type == 1) {
            this._log(msg, ResManager.loadKDString((String)"\u6ca1\u6709\u5269\u4f59\u53ef\u63d0\u5bff\u547d", (String)"DepreLogger4Analyze_43", (String)"fi-fa-business", (Object[])new Object[0]));
        } else if (type == 2) {
            this._log(msg, ResManager.loadKDString((String)"\u6ca1\u6709\u5269\u4f59\u53ef\u63d0\u91d1\u989d", (String)"DepreLogger4Analyze_44", (String)"fi-fa-business", (Object[])new Object[0]));
        } else if (type == 3) {
            this._log(msg, ResManager.loadKDString((String)"\u5206\u6bb5\u6bd4\u7387\u4e3a0", (String)"DepreLogger4Analyze_45", (String)"fi-fa-business", (Object[])new Object[0]));
        } else if (type == 4) {
            this._log(msg, ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u4e3a\u4e0d\u63d0\u6298\u65e7", (String)"DepreLogger4Analyze_46", (String)"fi-fa-business", (Object[])new Object[0]));
        } else if (type == 5) {
            this._log(msg, ResManager.loadKDString((String)"\u8d44\u4ea7\u653f\u7b56\u8bbe\u7f6e\u4e3a\u4e0d\u63d0\u6298\u65e7", (String)"DepreLogger4Analyze_47", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private void extractAllLeftValue(BigDecimal leftValueToDepre) {
        this._log(ResManager.loadKDString((String)"\u5168\u90e8\u63d0\u53d6\u5269\u4f59\u4ef7\u503c", (String)"DepreLogger4Analyze_48", (String)"fi-fa-business", (Object[])new Object[0]), leftValueToDepre);
    }

    private void compute200(Object ... args) {
        int i = 0;
        DepreAlgoInter depreCard = (DepreAlgoInter)args[i++];
        DepreSegment seg = (DepreSegment)args[i++];
        BigDecimal preUseYear = depreCard.getPreUseYear();
        BigDecimal usedYear = depreCard.getUsedYear();
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal leftYear = preUseYear.subtract(usedYear);
        boolean lastTwoYear = leftYear.compareTo(Fa.TWO) < 0 || leftYear.compareTo(Fa.TWO) == 0 && FinCardUtil.getLeftPeriod((DynamicObject)finCard).add(depreCard.getPeriodNumber().subtract(BigDecimal.ONE)).compareTo(this.book.getYearPeriodCount().multiply(Fa.TWO)) <= 0;
        this._log(ResManager.loadKDString((String)"\u53cc\u500d\u4f59\u989d\u52a8\u6001\u7b97\u6cd5", (String)"DepreLogger4Analyze_49", (String)"fi-fa-business", (Object[])new Object[0]), seg.isDynamic());
        if (seg.isDynamic()) {
            if (lastTwoYear) {
                BigDecimal leftAmount = FinCardUtil.getLeftAmount((DynamicObject)finCard);
                BigDecimal monthDepre = leftAmount.divide(Fa.TWO.multiply(this.book.getYearPeriodCount()), this.book.calcPrecision, RoundingMode.HALF_UP);
                this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u989d\uff08\u6700\u540e\u4e24\u5e74\uff09", (String)"DepreLogger4Analyze_50", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"(\u8d44\u4ea7\u539f\u503c-\u7d2f\u8ba1\u6298\u65e7-\u51cf\u503c-\u9884\u8ba1\u51c0\u6b8b\u503c)/(2*\u5e74\u5ea6\u4f1a\u8ba1\u671f\u95f4\u6570) = (%1$s-%2$s-%3$s-%4$s)/(2*%5$s) = %6$s", (String)"DepreLogger4Analyze_51", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getBigDecimal("originalval"), finCard.getBigDecimal("accumdepre"), finCard.getBigDecimal("decval"), finCard.getBigDecimal("preresidualval"), this.book.getYearPeriodCount(), monthDepre));
            } else {
                Fraction yearDepreRate = new Fraction(Fa.TWO).divide(leftYear);
                this._log(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u7387", (String)"DepreLogger4Analyze_52", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"2/\u5269\u4f59\u4f7f\u7528\u5e74\u9650 = 2/%s", (String)"DepreLogger4Analyze_53", (String)"fi-fa-business", (Object[])new Object[0]), leftYear));
                BigDecimal leftAmount = FinCardUtil.getLeftAmount3((DynamicObject)finCard);
                Fraction yearDepre = yearDepreRate.multiply(leftAmount);
                this._log(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_54", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u7387\u00d7(\u8d44\u4ea7\u539f\u503c-\u7d2f\u8ba1\u6298\u65e7-\u51cf\u503c\u51c6\u5907) = %1$s*(%2$s-%3$s-%4$s)", (String)"DepreLogger4Analyze_55", (String)"fi-fa-business", (Object[])new Object[0]), yearDepreRate, finCard.getBigDecimal("originalval"), finCard.getBigDecimal("accumdepre"), finCard.getBigDecimal("decval")));
                BigDecimal monthDepre = yearDepre.divide(this.book.getYearPeriodCount()).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP);
                this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_26", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u989d/\u5e74\u5ea6\u4f1a\u8ba1\u671f\u95f4\u6570 = %1$s/%2$s = %3$s", (String)"DepreLogger4Analyze_56", (String)"fi-fa-business", (Object[])new Object[0]), yearDepre.toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP), this.book.getYearPeriodCount(), monthDepre));
            }
        } else if (lastTwoYear) {
            BigDecimal leftPeriod = FinCardUtil.getLeftPeriod((DynamicObject)finCard);
            BigDecimal monthDepre = finCard.getBigDecimal("originalval").subtract(finCard.getBigDecimal("accumdepre")).subtract(finCard.getBigDecimal("preresidualval")).divide(leftPeriod, this.book.calcPrecision, RoundingMode.HALF_UP);
            this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u989d\uff08\u6700\u540e\u4e24\u5e74\uff09", (String)"DepreLogger4Analyze_50", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"(\u8d44\u4ea7\u539f\u503c-\u7d2f\u8ba1\u6298\u65e7-\u9884\u8ba1\u51c0\u6b8b\u503c)/(\u5269\u4f59\u4f1a\u8ba1\u671f\u95f4\u6570) = (%1$s-%2$s-%3$s)/%4$s = %5$s", (String)"DepreLogger4Analyze_57", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getBigDecimal("originalval"), finCard.getBigDecimal("accumdepre"), finCard.getBigDecimal("preresidualval"), leftPeriod, monthDepre));
        } else {
            Fraction yearDepreRate = new Fraction(Fa.TWO).divide(preUseYear);
            this._log(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u7387", (String)"DepreLogger4Analyze_52", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"2/\u9884\u8ba1\u4f7f\u7528\u5e74\u9650 = 2/%s", (String)"DepreLogger4Analyze_58", (String)"fi-fa-business", (Object[])new Object[0]), preUseYear));
            BigDecimal leftAmount = FinCardUtil.getLeftAmount4((DynamicObject)finCard);
            Fraction yearDepre = new Fraction(leftAmount).multiply(yearDepreRate);
            this._log(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_54", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"(\u8d44\u4ea7\u539f\u503c-\u5f53\u5e74\u5e74\u521d\u7d2f\u8ba1\u6298\u65e7)\u00d7\u5e74\u6298\u65e7\u7387 = (%1$s-%2$s+%3$s)*%4$s", (String)"DepreLogger4Analyze_59", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getBigDecimal("originalval"), finCard.getBigDecimal("accumdepre"), finCard.getBigDecimal("addupyeardepre"), yearDepreRate));
            BigDecimal monthDepre = yearDepre.divide(this.book.getYearPeriodCount()).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP);
            this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_26", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u989d/\u5e74\u5ea6\u4f1a\u8ba1\u671f\u95f4\u6570 = %1$s/%2$s = %3$s", (String)"DepreLogger4Analyze_56", (String)"fi-fa-business", (Object[])new Object[0]), yearDepre.toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP), this.book.getYearPeriodCount(), monthDepre));
        }
    }

    private void compute300(Object ... args) {
        int i = 0;
        DepreAlgoInter depreCard = (DepreAlgoInter)args[i++];
        DepreSegment seg = (DepreSegment)args[i++];
        BigDecimal preUseYear = depreCard.getPreUseYear();
        BigDecimal usedYear = depreCard.getUsedYear();
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal yearPeriodCount = this.book.getYearPeriodCount();
        this._log(ResManager.loadKDString((String)"\u5e74\u6570\u603b\u548c\u52a8\u6001\u7b97\u6cd5", (String)"DepreLogger4Analyze_60", (String)"fi-fa-business", (Object[])new Object[0]), seg.isDynamic());
        if (seg.isDynamic()) {
            BigDecimal leftYear = preUseYear.subtract(usedYear);
            Fraction yearDepreRate = new Fraction(leftYear, new Fraction(leftYear.multiply(leftYear.add(BigDecimal.ONE)), Fa.TWO));
            this._log(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u7387", (String)"DepreLogger4Analyze_52", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"(\u9884\u8ba1\u4f7f\u7528\u5e74\u9650-\u5df2\u4f7f\u7528\u5e74\u9650\uff08\u5f53\u5e74\u5e74\u521d\uff09)/{\u5269\u4f59\u4f7f\u7528\u5e74\u9650*[\u5269\u4f59\u4f7f\u7528\u5e74\u9650+1]/2} = (%1$s-%2$s)/{%3$s*[%4$s+1]/2}", (String)"DepreLogger4Analyze_61", (String)"fi-fa-business", (Object[])new Object[0]), preUseYear, usedYear, leftYear, leftYear));
            BigDecimal leftAmount = FinCardUtil.getLeftAmount((DynamicObject)finCard);
            Fraction yearDepre = yearDepreRate.multiply(leftAmount);
            this._log(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_54", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u7387*(\u8d44\u4ea7\u539f\u503c-\u7d2f\u8ba1\u6298\u65e7-\u51cf\u503c\u51c6\u5907-\u9884\u8ba1\u51c0\u6b8b\u503c)   = %1$s*(%2$s-%3$s-%4$s-%5$s)", (String)"DepreLogger4Analyze_62", (String)"fi-fa-business", (Object[])new Object[0]), yearDepreRate, finCard.getBigDecimal("originalval"), finCard.getBigDecimal("accumdepre"), finCard.getBigDecimal("decval"), finCard.getBigDecimal("preresidualval")));
            BigDecimal monthDepre = yearDepre.divide(yearPeriodCount).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP);
            this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_26", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u989d/\u5e74\u5ea6\u4f1a\u8ba1\u671f\u95f4\u6570 = %1$s/%2$s = %3$s", (String)"DepreLogger4Analyze_56", (String)"fi-fa-business", (Object[])new Object[0]), yearDepre.toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP), this.book.getYearPeriodCount(), monthDepre));
        } else {
            BigDecimal leftAmount = FinCardUtil.getLeftAmount2((DynamicObject)finCard);
            Fraction yearDepreRate = new Fraction(preUseYear.subtract(usedYear), new Fraction(preUseYear.multiply(preUseYear.add(BigDecimal.ONE)), new BigDecimal(2)));
            this._log(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u7387", (String)"DepreLogger4Analyze_52", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"(\u9884\u8ba1\u4f7f\u7528\u5e74\u9650-\u5df2\u4f7f\u7528\u5e74\u9650)/{\u9884\u8ba1\u4f7f\u7528\u5e74\u9650*[\u9884\u8ba1\u4f7f\u7528\u5e74\u9650+1]/2} = (%1$s-%2$s)/{%3$s*[%4$s+1]/2}", (String)"DepreLogger4Analyze_63", (String)"fi-fa-business", (Object[])new Object[0]), preUseYear, usedYear, preUseYear, preUseYear));
            Fraction yearDepre = yearDepreRate.multiply(leftAmount);
            this._log(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_54", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u7387*(\u8d44\u4ea7\u539f\u503c-\u9884\u8ba1\u51c0\u6b8b\u503c) = %1$s*(%2$s-%3$s)", (String)"DepreLogger4Analyze_64", (String)"fi-fa-business", (Object[])new Object[0]), yearDepreRate, finCard.getBigDecimal("originalval"), finCard.getBigDecimal("preresidualval")));
            BigDecimal monthDepre = yearDepre.divide(yearPeriodCount).toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP);
            this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_26", (String)"fi-fa-business", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u989d/\u5e74\u5ea6\u4f1a\u8ba1\u671f\u95f4\u6570 = %1$s/%2$s = %3$s", (String)"DepreLogger4Analyze_56", (String)"fi-fa-business", (Object[])new Object[0]), yearDepre.toBigDecimal(this.book.calcPrecision, RoundingMode.HALF_UP), this.book.getYearPeriodCount(), monthDepre));
        }
    }

    private void rateDepreMethod(Object ... args) {
        int i = 0;
        List depreRateData = (List)args[i++];
        boolean deductresidualval = (Boolean)args[i++];
        DepreAlgoInter depreCard = (DepreAlgoInter)args[i++];
        BigDecimal monthDepre = (BigDecimal)args[i++];
        String log_formula = "";
        String log_calculate = "";
        DynamicObject finCard = depreCard.getFinCard();
        BigDecimal originalVal = finCard.getBigDecimal("originalval");
        BigDecimal preResidualVal = finCard.getBigDecimal("preresidualval");
        Integer depredAmount = finCard.getBigDecimal("depredamount").intValue();
        BigDecimal depreRate = (BigDecimal)depreRateData.get(depredAmount);
        log_formula = ResManager.loadKDString((String)"\u539f\u503c", (String)"DepreLogger4Analyze_65", (String)"fi-fa-business", (Object[])new Object[0]);
        log_calculate = originalVal.toString();
        if (deductresidualval) {
            originalVal = originalVal.subtract(preResidualVal);
            log_formula = ResManager.loadKDString((String)"(\u539f\u503c-\u6b8b\u503c)", (String)"DepreLogger4Analyze_66", (String)"fi-fa-business", (Object[])new Object[0]);
            log_calculate = String.format("(%s-%s)", originalVal, preResidualVal);
        }
        log_formula = String.format(ResManager.loadKDString((String)"%s*\u6298\u65e7\u7387", (String)"DepreLogger4Analyze_67", (String)"fi-fa-business", (Object[])new Object[0]), log_formula);
        log_calculate = log_calculate + "*" + depreRate.toString();
        this._log(ResManager.loadKDString((String)"\u671f\u6298\u65e7\u989d", (String)"DepreLogger4Analyze_26", (String)"fi-fa-business", (Object[])new Object[0]), String.format("%s = %s = %s", log_formula, log_calculate, monthDepre));
    }
}

