/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.periodclose;

import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class UnFinishedBizChecker {
    public final Object orgID;
    public final Object bookID;
    public final Object depreuseID;
    public final Object currentPeriodID;
    public final Date beginDate;
    public final Date endDate;
    public final boolean isMainBook;

    public UnFinishedBizChecker(Object orgID, Object bookID, Object depreuseID, Object currentPeriodID, Date beginDate, Date endDate) {
        this.orgID = orgID;
        this.bookID = bookID;
        this.depreuseID = depreuseID;
        this.currentPeriodID = currentPeriodID;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.isMainBook = QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("id", "=", bookID), new QFilter("ismainbook", "=", (Object)true)});
    }

    public UnFinishedBizChecker(Object orgID, Object bookID, Object depreuseID, Object currentPeriodID, Date beginDate, Date endDate, boolean isMainBook) {
        this.orgID = orgID;
        this.bookID = bookID;
        this.depreuseID = depreuseID;
        this.currentPeriodID = currentPeriodID;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.isMainBook = isMainBook;
    }

    public Tuple<Boolean, QFilter> checkFCard() {
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("depreuse", "=", this.depreuseID));
        filter.and(new QFilter("finaccountdate", ">=", (Object)this.beginDate));
        filter.and(new QFilter("finaccountdate", "<=", (Object)this.endDate));
        filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        filter.and(new QFilter("realcard.mergedcard", "=", (Object)false));
        boolean enableCurPeriodSplit = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)((Long)this.orgID));
        if (enableCurPeriodSplit) {
            filter.and(new QFilter("originaldata", "=", (Object)true));
        }
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkAssetCard() {
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("depreuse", "=", this.depreuseID));
        filter.and(new QFilter("finaccountdate", ">=", (Object)this.beginDate));
        filter.and(new QFilter("finaccountdate", "<=", (Object)this.endDate));
        filter.and(new QFilter("billstatus", "!=", (Object)"C"));
        filter.and(new QFilter("realcard.mergedcard", "=", (Object)true));
        QFilter jumpFilter = new QFilter("org", "=", this.orgID);
        jumpFilter.and(new QFilter("billstatus", "!=", (Object)"C"));
        jumpFilter.and(new QFilter("finentry.fincard.finaccountdate", ">=", (Object)this.beginDate));
        jumpFilter.and(new QFilter("finentry.fincard.finaccountdate", "<=", (Object)this.endDate));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])filter.toArray()), (Object)jumpFilter);
    }

    public Tuple<Boolean, QFilter> checkChange() {
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("changedate", ">=", (Object)this.beginDate));
        filter.and(new QFilter("changedate", "<=", (Object)this.endDate));
        filter.and(new QFilter("billstatus", "!=", (Object)BillStatus.C.name()));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_change_dept", (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkSplitCard() {
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("splitdate", ">=", (Object)this.beginDate));
        filter.and(new QFilter("splitdate", "<=", (Object)this.endDate));
        filter.and(new QFilter("billstatus", "!=", (Object)BillStatus.C.name()));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_assetsplitbill", (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkClear() {
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("cleardate", ">=", (Object)this.beginDate));
        filter.and(new QFilter("cleardate", "<=", (Object)this.endDate));
        filter.and(new QFilter("billstatus", "!=", (Object)BillStatus.C.name()));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_clearbill", (QFilter[])filter.toArray()), (Object)filter);
    }

    private Tuple<Boolean, QFilter> checkByDepreuseAndPeriod(String depreuseField, String periodField, String formnumber) {
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter(depreuseField, "=", this.depreuseID));
        filter.and(new QFilter(periodField, "=", this.currentPeriodID));
        filter.and(new QFilter("billstatus", "!=", (Object)BillStatus.C.name()));
        return new Tuple((Object)QueryServiceHelper.exists((String)formnumber, (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkDevalue() {
        return this.checkByDepreuseAndPeriod("depreuse", "devalueperiod", "fa_asset_devalue");
    }

    public Tuple<Boolean, QFilter> checkDepreAdjust() {
        return this.checkByDepreuseAndPeriod("depreuse", "period", "fa_depreadjustbill");
    }

    public Tuple<Boolean, QFilter> checkWorkLoad() {
        return this.checkByDepreuseAndPeriod("depreuse", "period", "fa_workload");
    }

    public Tuple<Boolean, QFilter> checkLeaseChangeBill() {
        if (!this.isMainBook) {
            return new Tuple((Object)false, (Object)QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("effectivedate", "<=", (Object)this.endDate));
        filter.and(new QFilter("billstatus", "!=", (Object)BillStatus.C.name()));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_lease_change_bill", (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkInitLeaseToRealCard() {
        String dispatchConfirmCardSql = "select a.fid from t_fa_card_real a inner join t_fa_clrbill b on a.fsrcbillid = b.fsourcebillid and b.fclearperiodid = ? and b.fclearsource = 'DISPATCH' where a.forgid = ? and a.fbillstatus != 'C'";
        DataSet confirmCards = DB.queryDataSet((String)"UnFinishedBizChecker#checkInitLeaseToRealCard#dispatch", (DBRoute)new DBRoute("fa"), (String)dispatchConfirmCardSql, (Object[])new Object[]{this.currentPeriodID, this.orgID});
        HashSet<Long> realCardIds = new HashSet<Long>(8);
        if (this.isMainBook) {
            DynamicObject leaseInit = FaUtils.loadLeaseInitByOrgId(Long.parseLong(this.orgID.toString()));
            Long startPeriodId = -1L;
            if (leaseInit != null) {
                startPeriodId = leaseInit.getLong(Fa.id((String)"startperiod"));
            }
            if (startPeriodId.equals(this.currentPeriodID)) {
                String initLeasePushCardSql = "select fid from t_fa_card_real where forgid = ? and fbillstatus != 'C' and fsourceflag = 'INITLEASECONTRACT'";
                DataSet leasePushCards = DB.queryDataSet((String)"UnFinishedBizChecker#checkInitLeaseToRealCard#lease", (DBRoute)new DBRoute("fa"), (String)initLeasePushCardSql, (Object[])new Object[]{this.orgID});
                while (leasePushCards.hasNext()) {
                    realCardIds.add(leasePushCards.next().getLong("fid"));
                }
            }
        }
        while (confirmCards.hasNext()) {
            realCardIds.add(confirmCards.next().getLong("fid"));
        }
        return new Tuple((Object)(!realCardIds.isEmpty() ? 1 : 0), (Object)new QFilter("id", "in", realCardIds));
    }

    public Tuple<Boolean, QFilter> checkInitLease() {
        if (!this.isMainBook) {
            return new Tuple((Object)false, (Object)QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("sysswitchdate", ">=", (Object)this.beginDate));
        filter.and(new QFilter("sysswitchdate", "<=", (Object)this.endDate));
        filter.and(new QFilter("status", "!=", (Object)BillStatus.C.name()));
        filter.and(new QFilter("isexempt", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("sourcetype", "=", (Object)"B"));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_lease_contract_init", (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkInitLeaseContractPush() {
        if (!this.isMainBook) {
            return new Tuple((Object)false, (Object)QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("sysswitchdate", ">=", (Object)this.beginDate));
        filter.and(new QFilter("sysswitchdate", "<=", (Object)this.endDate));
        filter.and(new QFilter("assetqtycreate", "=", (Object)1));
        filter.and(new QFilter("isexempt", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("sourcetype", "=", (Object)"B"));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_lease_contract_init", (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkMergeBill() {
        QFilter filter = new QFilter("org", "=", this.orgID);
        filter.and(new QFilter("mergedate", ">=", (Object)this.beginDate));
        filter.and(new QFilter("mergedate", "<=", (Object)this.endDate));
        filter.and(new QFilter("billstatus", "!=", (Object)BillStatus.C.name()));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_mergebill", (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkExitApplyNotGenClear() {
        QFilter filter = new QFilter("org", "=", this.orgID);
        boolean genClearBillByApplyDate = FaBillParamUtils.getBooleanValue(null, null, null, (String)"genclearbill_datetype");
        if (genClearBillByApplyDate) {
            filter.and(new QFilter("cleardate", ">=", (Object)this.beginDate));
            filter.and(new QFilter("cleardate", "<=", (Object)this.endDate));
        } else {
            filter.and(new QFilter("auditdate", ">=", (Object)this.beginDate));
            filter.and(new QFilter("auditdate", "<=", (Object)this.endDate));
        }
        filter.and(new QFilter("billstatus", "=", (Object)BillStatus.C));
        filter.and(new QFilter("isgenclearbill", "=", (Object)Boolean.FALSE));
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_clearapplybill", (QFilter[])filter.toArray()), (Object)filter);
    }

    public Tuple<Boolean, QFilter> checkRestartBill() {
        QFilter qFilter = new QFilter("org", "=", this.orgID);
        qFilter.and("billstatus", "!=", (Object)"C");
        qFilter.and("restartdate", ">=", (Object)this.beginDate);
        qFilter.and("restartdate", "<=", (Object)this.endDate);
        return new Tuple((Object)QueryServiceHelper.exists((String)"fa_restartrealbill", (QFilter[])qFilter.toArray()), (Object)qFilter);
    }
}

