/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.constants.FaRptMediateBill;

public class FaRptMediateUpgradeUtil {
    private static final DynamicObjectType rptMediateType = BusinessDataServiceHelper.newDynamicObject((String)"fa_rpt_mediate").getDynamicObjectType();

    public static void upgradeDataByOrg(Long periodId, Long depreuseId, Long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        FaRptMediateUpgradeUtil.upgradeDataByOrgs(periodId, depreuseId, orgIds);
    }

    public static void upgradeDataByOrgs(long periodId, Long depreuseid, List<Long> orgIds) {
        List<DynamicObject> result = FaRptMediateUpgradeUtil.getFinCards(periodId, depreuseid, orgIds);
        result.addAll(FaRptMediateUpgradeUtil.getMergeBills(periodId, depreuseid, orgIds));
        result.addAll(FaRptMediateUpgradeUtil.getSplitBills(periodId, depreuseid, orgIds));
        result.addAll(FaRptMediateUpgradeUtil.getClearBills(periodId, depreuseid, orgIds));
        result.addAll(FaRptMediateUpgradeUtil.getDecBills(periodId, depreuseid, orgIds));
        result.addAll(FaRptMediateUpgradeUtil.getChangeBills(periodId, depreuseid, orgIds));
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    private static List<DynamicObject> getFinCards(Long periodId, Long depreuseid, List<Long> orgIds) {
        QFilter qFilter = new QFilter("period", "=", (Object)periodId);
        qFilter.and("bizperiod", "=", (Object)periodId);
        qFilter.and("depreuse", "=", (Object)depreuseid);
        qFilter.and("realcard.sourceflag", "!=", (Object)"SPLIT");
        qFilter.and("realcard.sourceflag", "!=", (Object)"MERGE");
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("originaldata", "=", (Object)"0");
        if (orgIds != null && !orgIds.isEmpty()) {
            qFilter.and("org", "in", orgIds);
        }
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)FaRptMediateUpgradeUtil.getFinSelectFields(), (QFilter[])qFilter.toArray());
        FaRptMediateUpgradeUtil.removeExit(finCards);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(finCards.size());
        for (DynamicObject finCard : finCards) {
            DynamicObject rptMediate = new DynamicObject(rptMediateType);
            for (String rptField : FaRptMediateBill.rptMediateFields) {
                if (!finCard.containsProperty(rptField)) continue;
                rptMediate.set(rptField, finCard.get(rptField));
            }
            rptMediate.set("addupdepre", (Object)finCard.getBigDecimal("aft_addupdepre").subtract(finCard.getBigDecimal("bef_addupdepre")));
            rptMediate.set("decvalchg", (Object)finCard.getBigDecimal("aft_decvalchg").subtract(finCard.getBigDecimal("bef_decvalchg")));
            rptMediate.set("sourcetype", (Object)"fa_card_fin");
            rptMediate.set("changetype", (Object)"2");
            rptMediate.set("fincard", (Object)rptMediate.getLong("sourceid"));
            result.add(rptMediate);
        }
        return result;
    }

    private static String buildSelectFields(List<String> fields) {
        StringBuilder selectFields = new StringBuilder();
        for (String field : fields) {
            selectFields.append(field).append(",");
        }
        return selectFields.substring(0, selectFields.length() - 1);
    }

    private static String getFinSelectFields() {
        ArrayList<String> fields = new ArrayList<String>(17);
        fields.add("id sourceid");
        fields.add("billno sourcebillno");
        fields.add("org org");
        fields.add("realcard realcard");
        fields.add("realcard.sourceflag sourceflag");
        fields.add("realcard.assetcat assetcat");
        fields.add("realcard.originmethod changemode");
        fields.add("realcard.masterid masterid");
        fields.add("realcard.number assetnumber");
        fields.add("period period");
        fields.add("originalval originalvalchg");
        fields.add("accumdepre aft_addupdepre");
        fields.add("decval aft_decvalchg");
        fields.add("monthdepre bef_addupdepre");
        fields.add("monthdeprechg bef_decvalchg");
        fields.add("auditdate createdate");
        fields.add("finaccountdate accountingdate");
        fields.add("basecurrency currency");
        fields.add("depreuse depreuse");
        return FaRptMediateUpgradeUtil.buildSelectFields(fields);
    }

    private static List<DynamicObject> getSplitBills(Long periodId, Long depreuseid, List<Long> orgIds) {
        QFilter qFilter = new QFilter("splitperiod", "=", (Object)periodId);
        qFilter.and("assetsplitentry.subassetsplitentry.aft_depreuse", "=", (Object)depreuseid);
        qFilter.and("billstatus", "=", (Object)"C");
        if (orgIds != null && !orgIds.isEmpty()) {
            qFilter.and("org", "in", orgIds);
        }
        DynamicObjectCollection splitBills = QueryServiceHelper.query((String)"fa_assetsplitbill", (String)FaRptMediateUpgradeUtil.getSplitSelectFields(), (QFilter[])qFilter.toArray());
        FaRptMediateUpgradeUtil.removeExit(splitBills);
        ArrayList masterIds = new ArrayList(splitBills.size());
        splitBills.forEach(bill -> masterIds.add(bill.getLong("masterid")));
        QFilter qfilter = new QFilter("masterid", "in", masterIds).and("isbak", "=", (Object)"1");
        DynamicObjectCollection realcards = QueryServiceHelper.query((String)"fa_card_real", (String)"id,masterid", (QFilter[])qfilter.toArray(), (String)"id desc");
        HashMap masterid2idMap = new HashMap(realcards.size());
        realcards.forEach(card -> masterid2idMap.put(card.getLong("masterid"), card.getLong("id")));
        ArrayList<DynamicObject> resutl = new ArrayList<DynamicObject>(splitBills.size() * 2);
        for (DynamicObject bill2 : splitBills) {
            DynamicObject rptMedaite = new DynamicObject(rptMediateType);
            Long aftRealCardId = bill2.getLong("realcard");
            if (aftRealCardId != null && aftRealCardId.equals(bill2.getLong("bef_realcard"))) {
                for (String field : FaRptMediateBill.rptMediateFields) {
                    if (!bill2.containsProperty(field)) continue;
                    rptMedaite.set(field, bill2.get(field));
                }
                rptMedaite.set("originalvalchg", (Object)bill2.getBigDecimal("originalvalchg").subtract(bill2.getBigDecimal("bef_originalvalchg")));
                rptMedaite.set("addupdepre", (Object)bill2.getBigDecimal("addupdepre").subtract(bill2.getBigDecimal("bef_addupdepre")));
                rptMedaite.set("decvalchg", (Object)bill2.getBigDecimal("decvalchg").subtract(bill2.getBigDecimal("bef_decvalchg")));
                rptMedaite.set("changetype", (Object)"0");
            } else {
                for (String field : FaRptMediateBill.rptMediateFields) {
                    if (!bill2.containsProperty(field)) continue;
                    rptMedaite.set(field, bill2.get(field));
                }
                if (masterid2idMap.containsKey(rptMedaite.getLong("masterid"))) {
                    rptMedaite.set("realcard", masterid2idMap.get(rptMedaite.getLong("masterid")));
                }
                rptMedaite.set("changetype", (Object)"2");
            }
            rptMedaite.set("sourcetype", (Object)"fa_assetsplitbill");
            resutl.add(rptMedaite);
        }
        return resutl;
    }

    private static String getSplitSelectFields() {
        ArrayList<String> fields = new ArrayList<String>(20);
        fields.add("id sourceid");
        fields.add("billno sourcebillno");
        fields.add("org org");
        fields.add("splitperiod period");
        fields.add("auditdate createdate");
        fields.add("splitdate accountingdate");
        String befEntry = "assetsplitentry";
        fields.add(befEntry + "." + "realcard" + " bef_" + "realcard");
        fields.add(befEntry + "." + "bef_originalval" + " bef_" + "originalvalchg");
        fields.add(befEntry + "." + "bef_accumdepre" + " bef_" + "addupdepre");
        fields.add(befEntry + "." + "bef_decval" + " bef_" + "decvalchg");
        String aftEntry = befEntry + "." + "subassetsplitentry";
        String aftRealcard = aftEntry + "." + "aft_realcard";
        fields.add(aftRealcard + " " + "realcard");
        fields.add(aftRealcard + "." + "masterid" + " " + "masterid");
        fields.add(aftRealcard + "." + "sourceflag" + " " + "sourceflag");
        fields.add(aftEntry + "." + "aft_assetcat" + " " + "assetcat");
        fields.add(aftEntry + "." + "aft_cardnumber" + " " + "assetnumber");
        fields.add(aftEntry + "." + "aft_originalval" + " " + "originalvalchg");
        fields.add(aftEntry + "." + "aft_accumdepre" + " " + "addupdepre");
        fields.add(aftEntry + "." + "aft_decval" + " " + "decvalchg");
        fields.add(aftEntry + "." + "aft_basecurrency" + " " + "currency");
        fields.add(aftEntry + "." + "aft_depreuse" + " " + "depreuse");
        fields.add(aftEntry + "." + "aft_fincard" + " " + "fincard");
        return FaRptMediateUpgradeUtil.buildSelectFields(fields);
    }

    private static List<DynamicObject> getMergeBills(Long periodId, Long depreuseid, List<Long> orgIds) {
        QFilter qFilter = new QFilter("mergeperiod", "=", (Object)periodId);
        qFilter.and("inentryentity.indepreuse", "=", (Object)depreuseid);
        qFilter.and("billstatus", "=", (Object)"C");
        if (orgIds != null && !orgIds.isEmpty()) {
            qFilter.and("org", "in", orgIds);
        }
        DynamicObjectCollection mergeBills = QueryServiceHelper.query((String)"fa_mergebill", (String)FaRptMediateUpgradeUtil.getMergeSelectFields(), (QFilter[])qFilter.toArray());
        FaRptMediateUpgradeUtil.removeExit(mergeBills);
        HashSet<Long> inRealCardIds = new HashSet<Long>();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(mergeBills.size() * 2);
        for (DynamicObject bill : mergeBills) {
            Long inRealCardId = bill.getLong("in_realcard");
            if (inRealCardIds.add(inRealCardId)) {
                DynamicObject in_rptMediate = new DynamicObject(rptMediateType);
                for (String field : FaRptMediateBill.rptMediateFields) {
                    if (bill.containsProperty(field)) {
                        in_rptMediate.set(field, bill.get(field));
                        continue;
                    }
                    if (!bill.containsProperty("in_" + field)) continue;
                    in_rptMediate.set(field, bill.get("in_" + field));
                }
                in_rptMediate.set("sourcetype", (Object)"fa_mergebill");
                in_rptMediate.set("changetype", (Object)"2");
                in_rptMediate.set("changemode", (Object)0L);
                result.add(in_rptMediate);
            }
            DynamicObject out_rptMediate = new DynamicObject(rptMediateType);
            for (String field : FaRptMediateBill.rptMediateFields) {
                if (bill.containsProperty(field)) {
                    out_rptMediate.set(field, bill.get(field));
                    continue;
                }
                if (!bill.containsProperty("out_" + field)) continue;
                Object value = bill.get("out_" + field);
                if (value instanceof BigDecimal) {
                    out_rptMediate.set(field, (Object)((BigDecimal)value).multiply(BigDecimal.valueOf(-1L)));
                    continue;
                }
                out_rptMediate.set(field, value);
            }
            out_rptMediate.set("sourcetype", (Object)"fa_mergebill");
            out_rptMediate.set("changetype", (Object)"0");
            out_rptMediate.set("changemode", (Object)0L);
            result.add(out_rptMediate);
        }
        return result;
    }

    private static String getMergeSelectFields() {
        ArrayList<String> fields = new ArrayList<String>(26);
        fields.add("id sourceid");
        fields.add("billno sourcebillno");
        fields.add("org org");
        fields.add("mergeperiod period");
        fields.add("auditdate createdate");
        fields.add("mergedate accountingdate");
        String inEntry = "inentryentity";
        fields.add(inEntry + "." + "inbasecurrency" + " in_" + "currency");
        fields.add(inEntry + "." + "indepreuse" + " in_" + "depreuse");
        fields.add(inEntry + "." + "inrealcardbak" + " in_" + "realcard");
        fields.add(inEntry + "." + "inrealcardbak" + "." + "number" + " in_" + "assetnumber");
        fields.add(inEntry + "." + "inrealcardbak" + "." + "assetcat" + " in_" + "assetcat");
        fields.add(inEntry + "." + "inrealcardbak" + "." + "masterid" + " in_" + "masterid");
        fields.add(inEntry + "." + "inrealcardbak" + "." + "sourceflag" + " in_" + "sourceflag");
        fields.add(inEntry + "." + "inoriginalval" + " in_" + "originalvalchg");
        fields.add(inEntry + "." + "inaccumdepre" + " in_" + "addupdepre");
        fields.add(inEntry + "." + "indecval" + " in_" + "decvalchg");
        fields.add(inEntry + "." + "infincard" + " in_" + "fincard");
        String outEntry = inEntry + "." + "outentryentity";
        String outRealCard = outEntry + "." + "outrealcard";
        fields.add(outRealCard + " out_" + "realcard");
        fields.add(outRealCard + "." + "number" + " out_" + "assetnumber");
        fields.add(outRealCard + "." + "masterid" + " out_" + "masterid");
        fields.add(outRealCard + "." + "sourceflag" + " out_" + "sourceflag");
        fields.add(outRealCard + "." + "assetcat" + " out_" + "assetcat");
        fields.add(outEntry + "." + "outbasecurrency" + " out_" + "currency");
        fields.add(outEntry + "." + "outoriginalval" + " out_" + "originalvalchg");
        fields.add(outEntry + "." + "outaccumdepre" + " out_" + "addupdepre");
        fields.add(outEntry + "." + "outdecval" + " out_" + "decvalchg");
        fields.add(outEntry + "." + "outdepreuse" + " out_" + "depreuse");
        fields.add(outEntry + "." + "outfincard" + " out_" + "fincard");
        return FaRptMediateUpgradeUtil.buildSelectFields(fields);
    }

    private static List<DynamicObject> getClearBills(Long periodId, Long depreuseid, List<Long> orgIds) {
        QFilter qFilter = new QFilter("clearperiod", "=", (Object)periodId);
        qFilter.and("detail_entry.depreuse", "=", (Object)depreuseid);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("clearsource", "!=", (Object)"SPLIT");
        qFilter.and("clearsource", "!=", (Object)"MERGE");
        if (orgIds != null && !orgIds.isEmpty()) {
            qFilter.and("org", "in", orgIds);
        }
        DynamicObjectCollection clearBills = QueryServiceHelper.query((String)"fa_clearbill", (String)FaRptMediateUpgradeUtil.getClearSelectFields(), (QFilter[])qFilter.toArray());
        FaRptMediateUpgradeUtil.removeExit(clearBills);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(clearBills.size());
        for (DynamicObject bill : clearBills) {
            DynamicObject rptMediate = new DynamicObject(rptMediateType);
            for (String field : FaRptMediateBill.rptMediateFields) {
                if (!bill.containsProperty(field)) continue;
                if (bill.get(field) instanceof BigDecimal) {
                    rptMediate.set(field, (Object)bill.getBigDecimal(field).multiply(BigDecimal.valueOf(-1L)));
                    continue;
                }
                rptMediate.set(field, bill.get(field));
            }
            rptMediate.set("sourcetype", (Object)"fa_clearbill");
            rptMediate.set("changetype", (Object)"0");
            result.add(rptMediate);
        }
        return result;
    }

    private static String getClearSelectFields() {
        ArrayList<String> fields = new ArrayList<String>(17);
        fields.add("id sourceid");
        fields.add("billno sourcebillno");
        fields.add("org org");
        fields.add("cleardate accountingdate");
        fields.add("auditdate createdate");
        fields.add("changemode changemode");
        fields.add("clearperiod period");
        String entry = "detail_entry";
        String entryRealCard = entry + "." + "realcard";
        fields.add(entryRealCard + " " + "realcard");
        fields.add(entryRealCard + "." + "number" + " " + "assetnumber");
        fields.add(entryRealCard + "." + "assetcat" + " " + "assetcat");
        fields.add(entryRealCard + "." + "masterid" + " " + "masterid");
        fields.add(entryRealCard + "." + "sourceflag" + " " + "sourceflag");
        fields.add(entry + "." + "depreuse" + " " + "depreuse");
        fields.add(entry + "." + "basecurrency" + " " + "currency");
        fields.add(entry + "." + "assetvalue" + " " + "originalvalchg");
        fields.add(entry + "." + "addupdepre" + " " + "addupdepre");
        fields.add(entry + "." + "decval" + " " + "decvalchg");
        fields.add(entry + "." + "fincard" + " " + "fincard");
        return FaRptMediateUpgradeUtil.buildSelectFields(fields);
    }

    private static List<DynamicObject> getDecBills(Long periodId, Long depreuseid, List<Long> orgIds) {
        QFilter qFilter = new QFilter("devalueperiod", "=", (Object)periodId);
        qFilter.and("depreuse", "=", (Object)depreuseid);
        qFilter.and("billstatus", "=", (Object)"C");
        if (orgIds != null && !orgIds.isEmpty()) {
            qFilter.and("org", "in", orgIds);
        }
        DynamicObjectCollection decBills = QueryServiceHelper.query((String)"fa_asset_devalue", (String)FaRptMediateUpgradeUtil.getDecSelectFields(), (QFilter[])qFilter.toArray());
        FaRptMediateUpgradeUtil.removeExit(decBills);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(decBills.size());
        for (DynamicObject bill : decBills) {
            DynamicObject rptMediate = new DynamicObject(rptMediateType);
            for (String field : FaRptMediateBill.rptMediateFields) {
                if (!bill.containsProperty(field)) continue;
                rptMediate.set(field, bill.get(field));
            }
            rptMediate.set("sourcetype", (Object)"fa_asset_devalue");
            if (rptMediate.get("decvalchg") != null && rptMediate.getBigDecimal("decvalchg").compareTo(BigDecimal.ZERO) < 0) {
                rptMediate.set("changetype", (Object)"0");
            } else {
                rptMediate.set("changetype", (Object)"2");
            }
            result.add(rptMediate);
        }
        return result;
    }

    private static String getDecSelectFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id sourceid");
        fields.add("billno sourcebillno");
        fields.add("org org");
        fields.add("devalueperiod period");
        fields.add("depreuse depreuse");
        fields.add("auditdate createdate");
        fields.add("businessdate accountingdate");
        fields.add("currency currency");
        String entry = "changebillentry";
        String entryRealCard = entry + "." + "realcard";
        fields.add(entryRealCard + " " + "realcard");
        fields.add(entryRealCard + "." + "number" + " " + "assetnumber");
        fields.add(entryRealCard + "." + "sourceflag" + " " + "sourceflag");
        fields.add(entryRealCard + "." + "assetcat" + " " + "assetcat");
        fields.add(entryRealCard + "." + "masterid" + " " + "masterid");
        fields.add(entry + "." + "decval" + " " + "decvalchg");
        fields.add(entry + "." + "fincard" + " " + "fincard");
        return FaRptMediateUpgradeUtil.buildSelectFields(fields);
    }

    private static List<DynamicObject> getChangeBills(Long periodId, Long depreuseid, List<Long> orgIds) {
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter("id", "=", (Object)periodId).toArray());
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        if (orgIds != null && !orgIds.isEmpty()) {
            qFilter.and("org", "in", orgIds);
        }
        qFilter.and("realentry.finentry.depreuse", "=", (Object)depreuseid);
        qFilter.and("changedate", "<=", (Object)period.getDate("enddate"));
        qFilter.and("changedate", ">=", (Object)period.getDate("begindate"));
        DynamicObjectCollection changebills = QueryServiceHelper.query((String)"fa_change_dept", (String)FaRptMediateUpgradeUtil.getChangeSelectFields(), (QFilter[])qFilter.toArray());
        FaRptMediateUpgradeUtil.removeExit(changebills);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(changebills.size());
        for (DynamicObject bill : changebills) {
            if (!bill.get("bef_assetcat").equals(bill.get("aft_assetcat"))) {
                DynamicObject bef_rptmediate = new DynamicObject(rptMediateType);
                DynamicObject aft_rptmediate = new DynamicObject(rptMediateType);
                String[] stringArray = FaRptMediateBill.rptMediateFields;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String field = stringArray[i];
                    if (!bill.containsProperty(field)) continue;
                    bef_rptmediate.set(field, bill.get(field));
                    aft_rptmediate.set(field, bill.get(field));
                    if (!(bill.get(field) instanceof BigDecimal)) continue;
                    bef_rptmediate.set(field, (Object)bill.getBigDecimal(field).multiply(BigDecimal.valueOf(-1L)));
                }
                bef_rptmediate.set("assetcat", bill.get("bef_assetcat"));
                bef_rptmediate.set("realcard", bill.get("bef_realcard"));
                bef_rptmediate.set("sourcetype", (Object)"fa_change_assetcat");
                bef_rptmediate.set("period", (Object)periodId);
                bef_rptmediate.set("changetype", (Object)"0");
                aft_rptmediate.set("assetcat", bill.get("aft_assetcat"));
                aft_rptmediate.set("realcard", bill.get("aft_realcard"));
                aft_rptmediate.set("sourcetype", (Object)"fa_change_assetcat");
                aft_rptmediate.set("period", (Object)periodId);
                aft_rptmediate.set("changetype", (Object)"2");
                result.add(bef_rptmediate);
                result.add(aft_rptmediate);
                continue;
            }
            if (bill.get("bef_originalvalchg").equals(bill.get("aft_originalvalchg"))) continue;
            DynamicObject rptmediate = new DynamicObject(rptMediateType);
            for (String field : FaRptMediateBill.rptMediateFields) {
                if (!bill.containsProperty(field) || "addupdepre".equals(field) || "decvalchg".equals(field)) continue;
                rptmediate.set(field, bill.get(field));
            }
            rptmediate.set("sourcetype", (Object)"fa_change_value");
            rptmediate.set("realcard", bill.get("bef_realcard"));
            rptmediate.set("assetcat", bill.get("bef_assetcat"));
            rptmediate.set("period", (Object)periodId);
            rptmediate.set("originalvalchg", (Object)bill.getBigDecimal("aft_originalvalchg").subtract(bill.getBigDecimal("bef_originalvalchg")));
            if (rptmediate.getBigDecimal("originalvalchg").compareTo(BigDecimal.ZERO) > 0) {
                rptmediate.set("changetype", (Object)"2");
            } else {
                rptmediate.set("changetype", (Object)"0");
            }
            result.add(rptmediate);
        }
        return result;
    }

    private static String getChangeSelectFields() {
        ArrayList<String> fields = new ArrayList<String>(30);
        fields.add("id sourceid");
        fields.add("billno sourcebillno");
        fields.add("org org");
        fields.add("auditdate createdate");
        fields.add("changedate accountingdate");
        String realEntry = "realentry.";
        String befCard = realEntry + "realcard" + ".";
        String aftCard = realEntry + "aftrealcard" + ".";
        fields.add(realEntry + "realcard" + " bef_" + "realcard");
        fields.add(befCard + "assetcat" + " bef_" + "assetcat");
        fields.add(realEntry + "aftrealcard" + " aft_" + "realcard");
        fields.add(aftCard + "assetcat" + " aft_" + "assetcat");
        fields.add(befCard + "number" + " " + "assetnumber");
        fields.add(befCard + "sourceflag" + " " + "sourceflag");
        fields.add(befCard + "masterid" + " " + "masterid");
        String finEntry = "realentry.finentry.";
        String beffincard = finEntry + "bf_fin_info" + ".";
        String aftfincard = finEntry + "af_fin_info" + ".";
        fields.add(finEntry + "fincard" + " " + "fincard");
        fields.add(finEntry + "fincard" + "." + "originalval" + " " + "originalvalchg");
        fields.add(finEntry + "currency" + " " + "currency");
        fields.add(finEntry + "depreuse" + " " + "depreuse");
        fields.add(beffincard + "originalval" + " bef_" + "originalvalchg");
        fields.add(aftfincard + "originalval" + " aft_" + "originalvalchg");
        fields.add(beffincard + "accumdepre" + " " + "addupdepre");
        fields.add(beffincard + "decval" + " " + "decvalchg");
        return FaRptMediateUpgradeUtil.buildSelectFields(fields);
    }

    private static void removeExit(DynamicObjectCollection objs) {
        ArrayList<Long> ids = new ArrayList<Long>(objs.size());
        for (DynamicObject obj2 : objs) {
            ids.add(obj2.getLong("sourceid"));
        }
        DynamicObjectCollection exists = QueryServiceHelper.query((String)"fa_rpt_mediate", (String)"sourceid", (QFilter[])new QFilter("sourceid", "in", ids).toArray());
        if (exists != null && !exists.isEmpty()) {
            ArrayList<Long> existIds = new ArrayList<Long>(exists.size());
            for (DynamicObject exist : exists) {
                existIds.add(exist.getLong("sourceid"));
            }
            objs.removeIf(obj -> existIds.contains(obj.getLong("sourceid")));
        }
    }
}

