/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.business.validator;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.enums.assetpolicy.DevaluePolicy;
import kd.fi.fa.business.enums.lease.LeaseContractDepreTypeEnum;
import kd.fi.fa.business.lease.LeaseFutureBizChecker;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.CheckFaFinCardDataUtil;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaConstants;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaFinCardUtil;
import kd.fi.fa.business.utils.FaNewFinValidatorUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.business.validator.po.FinCardValidatorParam;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.Tuple;

public class FinCardValidator {
    private final List<FinCardValidatorParam> params;
    private final boolean isAssetCard;
    private final Map<Integer, List<String>> errorInfo;
    private Map<Object, DynamicObject> assetBookCache;
    private Map<Object, List<Tuple<String, DynamicObject>>> assetPolicyCache;
    private boolean validateSave = Boolean.TRUE;
    private boolean isAssetImportCard = Boolean.FALSE;
    private boolean isSubmit = Boolean.FALSE;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private final Map<Object, Date> enablePeriodMapCache = new HashMap<Object, Date>();

    private FinCardValidator(List<FinCardValidatorParam> validatorParams, boolean isAssetCard) {
        this.params = validatorParams;
        this.isAssetCard = isAssetCard;
        this.errorInfo = new HashMap<Integer, List<String>>(this.params.size());
    }

    public void setValidateSave(boolean validateSave) {
        this.validateSave = validateSave;
    }

    public static FinCardValidator getInstanceForSeparateCard(List<DynamicObject> finCards) {
        String selectFields = Fa.comma((String[])new String[]{"id", "sourceflag", "realaccountdate", "billstatus", "number", "org", "bizstatus", "srcbillid", "srcbillentityname", "initialcard", "mergedcard", "masterid"});
        finCards = finCards.stream().filter(Objects::nonNull).collect(Collectors.toList());
        Object[] realCardIds = finCards.stream().map(v -> v.getLong(Fa.id((String)"realcard"))).toArray();
        QFilter filter = new QFilter("id", "in", (Object)realCardIds);
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)selectFields, (QFilter[])filter.toArray());
        Map<Long, DynamicObject> realCardMap = realCards.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        ArrayList<FinCardValidatorParam> validatorParams = new ArrayList<FinCardValidatorParam>(finCards.size());
        for (DynamicObject dynamicObject : finCards) {
            long realCardId = dynamicObject.getLong(Fa.id((String)"realcard"));
            DynamicObject realCard = realCardMap.get(realCardId);
            validatorParams.add(new FinCardValidatorParam(realCard, dynamicObject));
        }
        return new FinCardValidator(validatorParams, false);
    }

    public static FinCardValidator getInstanceForAssetCard(List<FinCardValidatorParam> validatorParams) {
        return new FinCardValidator(validatorParams, true);
    }

    public Map<Integer, List<String>> validateFinCardForSave() {
        boolean isImport = false;
        boolean isSplitCard = false;
        Set<Long> hasOtherBookOrgIds = this.getHasOtherBookOrgIds();
        HashMap<String, Boolean> orgIdDepreUseIdPeriodId2haVoucher = new HashMap<String, Boolean>(16);
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(4);
        boolean isNotHaveErrorMsg = Boolean.TRUE;
        for (int i = 0; i < this.params.size(); ++i) {
            boolean hasVoucher;
            String chResult;
            DynamicObject finCard = this.params.get(i).getFinCard();
            DynamicObject realCard = this.params.get(i).getRealCard();
            if (SourceFlagEnum.SPLIT.name().equals(realCard.getString("sourceflag"))) {
                isSplitCard = true;
            }
            if (realCard.containsProperty("isimport") && (isImport = realCard.getBoolean("isimport"))) {
                this.isAssetImportCard = Boolean.TRUE;
            }
            if (finCard.containsProperty("isimport") && (isImport = finCard.getBoolean("isimport"))) {
                this.isAssetImportCard = Boolean.TRUE;
            }
            if ((chResult = FaNewFinValidatorUtils.checkFinAmountPrecision((DynamicObject)finCard, (this.isSubmit && !this.isAssetCard ? 1 : 0) != 0)) != null && chResult.length() > 0) {
                this.addErrMsg(i, chResult);
            }
            long orgId = finCard.getLong(Fa.id((String)"org"));
            if (this.isAssetCard) {
                if (hasOtherBookOrgIds.contains(orgId) && !SourceFlagEnum.SPLIT.name().equals(realCard.getString("sourceflag"))) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5b58\u5728\u8f85\u8d26\u7c3f\uff0c\u4e0d\u652f\u6301\u65b0\u589e\u8d44\u4ea7\u5361\u7247\u3002", (String)"FinCardValidator_0", (String)"fi-fa-business", (Object[])new Object[0]));
                }
            } else if (this.validateSave && realCard.getBoolean("initialcard")) {
                this.addErrMsg(i, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%s\u7684\u521d\u59cb\u5316\u5361\u7247\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"FinCardValidator_1", (String)"fi-fa-business", (Object[])new Object[0]), finCard.getString("number")));
            }
            String sourceFlag = realCard.getString("sourceflag");
            if (SourceFlagEnum.SPLIT.name().equals(sourceFlag)) continue;
            boolean enableSumMutilVoucher = false;
            if (orgId2SumMutilVou.get(orgId) != null) {
                enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
            } else {
                enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
            }
            if (SourceFlagEnum.INITIAL.name().equals(sourceFlag) && enableSumMutilVoucher) continue;
            Long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
            Long periodId = finCard.getLong(Fa.id((String)"period"));
            StringBuilder keyBd = new StringBuilder();
            keyBd.append(orgId).append("_").append(depreUseId).append("_").append(periodId);
            String key = keyBd.toString();
            if (orgIdDepreUseIdPeriodId2haVoucher.get(key) != null) {
                hasVoucher = (Boolean)orgIdDepreUseIdPeriodId2haVoucher.get(key);
            } else {
                hasVoucher = enableSumMutilVoucher ? FaDepreUtil.hasVoucher((Long)orgId, (Long)depreUseId, (Long)periodId, (boolean)false) : FaDepreUtil.hasVoucher((Long)orgId, (Long)depreUseId, (Long)periodId, (boolean)true);
                orgIdDepreUseIdPeriodId2haVoucher.put(key, hasVoucher);
            }
            if (hasVoucher && enableSumMutilVoucher) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinCardValidator_2", (String)"fi-fa-business", (Object[])new Object[0]));
                continue;
            }
            if (!hasVoucher) continue;
            this.addErrMsg(i, ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinCardValidator_75", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if (isImport || this.isAssetImportCard || isSplitCard) {
            this.validateFinCardForImportSave();
        }
        this.checkDepreMethod();
        return this.errorInfo;
    }

    public Map<Integer, List<String>> validateInitFinCardForDelete() {
        this.checkDepreSumHasVoucher4UnAudit();
        return this.errorInfo;
    }

    public Map<Integer, List<String>> validateFinCardForSubmit() {
        this.isSubmit = Boolean.TRUE;
        this.validateFinCardForSave();
        for (int i = 0; i < this.params.size(); ++i) {
            BigDecimal accumDepre;
            BigDecimal depredAmount;
            boolean mustInputSuccess;
            FinCardValidatorParam param = this.params.get(i);
            DynamicObject finCard = param.getFinCard();
            String billStatus = "";
            if (finCard.containsProperty("billstatus")) {
                billStatus = finCard.getString("billstatus");
            }
            if (!BillStatus.A.toString().equals(billStatus) && !this.isAssetCard) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u5361\u7247\u624d\u80fd\u63d0\u4ea4\u3002", (String)"FinCardValidator_4", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (!(mustInputSuccess = this.validateMustInput(i, param))) continue;
            this.checkDecValAndDepre(i, param);
            this.checkPreUsingAmount(i, param);
            DynamicObject realCard = this.params.get(i).getRealCard();
            this.checkDepreAmount(i, finCard, realCard);
            if (param.getRealCard().getBoolean("initialcard")) {
                this.checkInitBizPeriod(i, param);
                this.checkRealFinDate(i, param);
                Optional<String> checkResult = this.checkFutureBiz(param);
                if (checkResult.isPresent()) {
                    String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u64cd\u4f5c\uff1a%s\u3002", (String)"FinCardValidator_5", (String)"fi-fa-business", (Object[])new Object[0]), checkResult.get());
                    this.addErrMsg(i, msg);
                }
            } else {
                this.checkFinAccountDate(i, param);
            }
            if (BigDecimal.ZERO.compareTo(finCard.getBigDecimal("netamount")) > 0) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u51c0\u989d\u4e3a\u8d1f\u6570\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"FinCardValidator_6", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(finCard.getBigDecimal("networth")) > 0) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u51c0\u503c\u4e3a\u8d1f\u6570\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"FinCardValidator_7", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(depredAmount = finCard.getBigDecimal("depredamount")) > 0) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u671f\u95f4\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"FinCardValidator_8", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(accumDepre = finCard.getBigDecimal("accumdepre")) > 0) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"FinCardValidator_9", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(depredAmount) == 0 && BigDecimal.ZERO.compareTo(accumDepre) != 0 || BigDecimal.ZERO.compareTo(depredAmount) != 0 && BigDecimal.ZERO.compareTo(accumDepre) == 0) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u548c\u7d2f\u8ba1\u6298\u65e7\u5fc5\u987b\u540c\u65f6\u4e3a0\uff0c\u6216\u8005\u540c\u65f6\u5927\u4e8e0\u3002", (String)"FinCardValidator_10", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            BigDecimal preResidualVal = finCard.getBigDecimal("preresidualval");
            BigDecimal originalVal = finCard.getBigDecimal("originalval");
            BigDecimal netAmount = finCard.getBigDecimal("netamount");
            if (originalVal.compareTo(preResidualVal) < 0) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u9884\u8ba1\u51c0\u6b8b\u503c\u4e0d\u80fd\u5927\u4e8e\u8d44\u4ea7\u539f\u503c\u3002", (String)"FinCardValidator_11", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (BigDecimal.ZERO.compareTo(preResidualVal) <= 0) continue;
            this.addErrMsg(i, ResManager.loadKDString((String)"\u9884\u8ba1\u51c0\u6b8b\u503c\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"FinCardValidator_12", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        return this.errorInfo;
    }

    public Map<Integer, List<String>> validateFinCardForAudit() {
        this.checkDepreSumHasVoucher();
        this.checkIsOriginalData(false);
        return this.errorInfo;
    }

    public Map<Integer, List<String>> validateFinCardForUnAudit() {
        List indexList;
        this.checkIsOriginalData(true);
        for (int i = 0; i < this.params.size(); ++i) {
            FinCardValidatorParam param = this.params.get(i);
            DynamicObject finCard = param.getFinCard();
            String cardNum = finCard.getString("number");
            Long realCardMasterId = finCard.getLong("realcardmasterid");
            if (realCardMasterId == null || realCardMasterId == 0L) {
                this.addErrMsg(i, String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u7684[\u5361\u7247\u4e3b\u6570\u636eID]\u5b57\u6bb5\u672a\u6210\u529f\u5347\u7ea7\uff0c\u8bf7\u5347\u7ea7\u4e4b\u540e\u518d\u53cd\u5ba1\u6838\u3002", (String)"FinCardValidator_13", (String)"fi-fa-business", (Object[])new Object[0]), cardNum));
            }
            String billStatus = finCard.getString("billstatus");
            if (!BillStatus.C.name().equals(billStatus) && !this.isAssetCard) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u8d22\u52a1\u5361\u7247\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FinCardValidator_14", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            DynamicObject addNewPeriod = finCard.getDynamicObject("period");
            DynamicObject realCard = param.getRealCard();
            String string = realCard.getString("sourceflag");
            if (SourceFlagEnum.SPLIT.name().equals(string)) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u62c6\u5206\u751f\u6210\u7684\u8d22\u52a1\u5361\u7247\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FinCardValidator_15", (String)"fi-fa-business", (Object[])new Object[0]));
                continue;
            }
            if (addNewPeriod == null) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5361\u7247\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FinCardValidator_16", (String)"fi-fa-business", (Object[])new Object[0]));
            } else {
                long bookId = finCard.getLong(Fa.id((String)"assetbook"));
                Map<Object, DynamicObject> bookCache = this.getAssetBookCache();
                DynamicObject book = bookCache.get(bookId);
                long curPeriodId = book.getLong(Fa.id((String)"curperiod"));
                long addNewPeriodId = addNewPeriod.getLong("id");
                if (addNewPeriodId < curPeriodId) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4ee5\u524d\u65b0\u589e\u7684\u5361\u7247\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinCardValidator_17", (String)"fi-fa-business", (Object[])new Object[0]));
                }
            }
            String bizStatus = realCard.getString("bizstatus");
            if (!BizStatusEnum.TRANSFERING.name().equals(bizStatus) && !BizStatusEnum.DRAWBACKING.name().equals(bizStatus)) continue;
            this.addErrMsg(i, ResManager.loadKDString((String)"\u79fb\u4ea4\u4e2d\u6216\u8005\u9000\u5e93\u4e2d\u8d22\u52a1\u5361\u7247\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FinCardValidator_18", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        HashMap org2Params = new HashMap(2);
        HashMap realCardIndexMap = new HashMap(this.params.size());
        for (int i = 0; i < this.params.size(); ++i) {
            FinCardValidatorParam param = this.params.get(i);
            DynamicObject realCard = param.getRealCard();
            indexList = (ArrayList<Integer>)realCardIndexMap.get(realCard.getString("number"));
            if (indexList == null) {
                indexList = new ArrayList<Integer>(4);
                realCardIndexMap.put(realCard.getString("number"), indexList);
            }
            indexList.add(i);
            long orgId = realCard.get("org") instanceof DynamicObject ? realCard.getLong(Fa.id((String)"org")) : realCard.getLong("org");
            if (org2Params.containsKey(orgId)) {
                List list = (List)org2Params.get(orgId);
                list.add(param);
                continue;
            }
            ArrayList<FinCardValidatorParam> arrayList = new ArrayList<FinCardValidatorParam>();
            arrayList.add(param);
            org2Params.put(orgId, arrayList);
        }
        for (Map.Entry entry : org2Params.entrySet()) {
            Long orgId = (Long)entry.getKey();
            List paramList = (List)entry.getValue();
            Map<String, String> resultMap = this.checkFutureBiz(orgId, paramList);
            for (Map.Entry entry2 : resultMap.entrySet()) {
                String number = (String)entry2.getKey();
                String msgValue = (String)entry2.getValue();
                List indexList2 = (List)realCardIndexMap.get(number);
                if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)indexList2)) continue;
                for (Integer index : indexList2) {
                    String msg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u4e3a %1$s \u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5%2$s\u3002", (String)"FinCardValidator_19", (String)"fi-fa-business", (Object[])new Object[0]), number, msgValue);
                    this.addErrMsg(index, msg);
                }
            }
        }
        Set<String> numbers = this.existLeaseChangeBill(this.params);
        for (String number : numbers) {
            indexList = (List)realCardIndexMap.get(number);
            if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(indexList)) continue;
            for (Integer index : indexList) {
                this.addErrMsg(index, ResManager.loadKDString((String)"\u5361\u7247\u7684\u4e0a\u6e38\u79df\u8d41\u5408\u540c\u5b58\u5728\u79df\u8d41\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinCardValidator_20", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        this.checkFinCardHasVoucher();
        this.checkDepreSumHasVoucher4UnAudit();
        return this.errorInfo;
    }

    private boolean validateMustInput(int index, FinCardValidatorParam param) {
        Date finAccountDate;
        DynamicObject assetCat;
        DynamicObject depreUse;
        DynamicObject assetBook;
        boolean result = true;
        DynamicObject finCard = param.getFinCard();
        DynamicObject realCard = param.getRealCard();
        if (realCard == null) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d22\u52a1\u5361\u7247\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef\u3002", (String)"FinCardValidator_21", (String)"fi-fa-business", (Object[])new Object[0]));
            result = false;
        }
        if ((assetBook = finCard.getDynamicObject("assetbook")) == null) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d22\u52a1\u5361\u7247\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef\u3002", (String)"FinCardValidator_22", (String)"fi-fa-business", (Object[])new Object[0]));
            result = false;
        }
        if ((depreUse = finCard.getDynamicObject("depreuse")) == null) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d22\u52a1\u5361\u7247\u5bf9\u5e94\u7684\u6298\u65e7\u7528\u9014\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef\u3002", (String)"FinCardValidator_23", (String)"fi-fa-business", (Object[])new Object[0]));
            result = false;
        }
        if ((assetCat = finCard.containsProperty("realassetcat") ? finCard.getDynamicObject("realassetcat") : finCard.getDynamicObject("assetcat")) == null && this.isAssetCard && realCard != null) {
            assetCat = realCard.getDynamicObject("assetcat");
        }
        if (assetCat == null) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d22\u52a1\u5361\u7247\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u522b\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef\u3002", (String)"FinCardValidator_24", (String)"fi-fa-business", (Object[])new Object[0]));
            result = false;
        }
        if ((finAccountDate = finCard.getDate("finaccountdate")) == null) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinCardValidator_25", (String)"fi-fa-business", (Object[])new Object[0]));
            result = false;
        }
        DynamicObject depreMethod = finCard.getDynamicObject("depremethod");
        DynamicObject assetPolicy = this.getAssetPolicyCacheRow(index, param);
        if (assetPolicy != null && depreMethod == null && !assetPolicy.getBoolean("nodepre")) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinCardValidator_26", (String)"fi-fa-business", (Object[])new Object[0]));
            result = false;
        }
        Set<Object> depreMethodIds = FaUtils.getDepreMethodByType("5");
        DynamicObject workLoadUnitDynObj = finCard.getDynamicObject("workloadunit");
        boolean mustInputWorkLoadUnit = FaFinCardUtil.isMustInputWorkLoadUnit();
        IAppCache appCache = AppCache.get((String)"fa");
        Boolean mustInputWorkLoadUnitCache = (Boolean)appCache.get("mustInputWorkLoadUnit", Boolean.class);
        if (Objects.isNull(mustInputWorkLoadUnitCache)) {
            appCache.put("mustInputWorkLoadUnit", (Object)mustInputWorkLoadUnit);
        }
        if (mustInputWorkLoadUnit && Objects.nonNull(depreMethod) && depreMethodIds.contains(depreMethod.getPkValue()) && Objects.isNull(workLoadUnitDynObj)) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinCardValidator_27", (String)"fi-fa-business", (Object[])new Object[0]));
            result = Boolean.FALSE;
        }
        return result;
    }

    private void validateFinCardForImportSave() {
        HashSet<Long> orgIdSet = new HashSet<Long>(this.params.size());
        HashSet<Long> depreUseIdSet = new HashSet<Long>(this.params.size());
        HashSet<String> finNumbersSet = new HashSet<String>(this.params.size());
        for (FinCardValidatorParam param : this.params) {
            DynamicObject realCard = param.getRealCard();
            if (realCard.containsProperty("sourceflag") && SourceFlagEnum.SPLIT.name().equals(realCard.getString("sourceflag"))) continue;
            DynamicObject finCard = param.getFinCard();
            String number = finCard.getString("number");
            long orgId = finCard.getLong(Fa.id((String)"org"));
            orgIdSet.add(orgId);
            long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
            depreUseIdSet.add(depreUseId);
            finNumbersSet.add(number);
        }
        HashSet<String> existFinNumbers = new HashSet<String>(finNumbersSet.size());
        if (!finNumbersSet.isEmpty()) {
            QFilter[] finFilters = new QFilter[]{new QFilter("org", "in", orgIdSet), new QFilter("depreuse", "in", depreUseIdSet), new QFilter("number", "in", finNumbersSet)};
            String selectFinFields = Fa.comma((String[])new String[]{"assetbook", "number"});
            DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFinFields, (QFilter[])finFilters);
            for (DynamicObject finCard : finCards) {
                String bookIdStr = finCard.getString("assetbook");
                String number = finCard.getString("number");
                existFinNumbers.add(String.join((CharSequence)"_", bookIdStr, number));
            }
        }
        for (int i = 0; i < this.params.size(); ++i) {
            Object depredAmountObj;
            Object preUsingAmountObj;
            Object workLoadUnitObj;
            Object depreMethodObj;
            Set errorMsgSet;
            FinCardValidatorParam param = this.params.get(i);
            boolean mustInputSuccess = this.validateMustInput(i, param);
            if (!mustInputSuccess) continue;
            DynamicObject finCard = param.getFinCard();
            DynamicObject assetBook = finCard.getDynamicObject("assetbook");
            DynamicObject realCard = param.getRealCard();
            String realCardStates = realCard.getString("billstatus");
            if (!this.isAssetCard && !realCardStates.equals(BillStatus.C.name())) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u5bfc\u5165\u8d22\u52a1\u5361\u7247\u3002", (String)"FinCardValidator_28", (String)"fi-fa-business", (Object[])new Object[0]));
                continue;
            }
            if (!realCard.getBoolean("initialcard")) {
                this.checkFinAccountDate(i, param);
            }
            if (realCard.getBoolean("mergedcard") && !realCard.getBoolean("initialcard")) {
                BigDecimal depredAmount;
                BigDecimal yearVal;
                BigDecimal accumDepre = finCard.getBigDecimal("accumdepre");
                BigDecimal decval = finCard.getBigDecimal("decval");
                BigDecimal originalval = finCard.getBigDecimal("originalval");
                if (BigDecimal.ZERO.compareTo(accumDepre) > 0) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"FinCardValidator_9", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (originalval.compareTo(accumDepre) < 0) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u539f\u503c\u4e0d\u80fd\u5c0f\u4e8e\u7d2f\u8ba1\u6298\u65e7\u3002", (String)"FinCardValidator_29", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (accumDepre.compareTo(yearVal = finCard.getBigDecimal("addupyeardepre")) < 0) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u91d1\u989d\u3002", (String)"FinCardValidator_30", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (originalval.compareTo(accumDepre.add(decval)) < 0) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u539f\u503c\u4e0d\u80fd\u5c0f\u4e8e\u7d2f\u8ba1\u6298\u65e7\u4e0e\u51cf\u503c\u51c6\u5907\u4e4b\u548c\u3002", (String)"FinCardValidator_31", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if ((depredAmount = finCard.getBigDecimal("depredamount")).compareTo(BigDecimal.ZERO) == 0 && accumDepre.compareTo(BigDecimal.ZERO) != 0) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u548c\u7d2f\u8ba1\u6298\u65e7\u5e94\u540c\u65f6\u4e3a0\u6216\u540c\u65f6\u4e0d\u4e3a0\u3002", (String)"FinCardValidator_32", (String)"fi-fa-business", (Object[])new Object[0]));
                }
                if (depredAmount.compareTo(BigDecimal.ZERO) != 0 && accumDepre.compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u548c\u7d2f\u8ba1\u6298\u65e7\u5e94\u540c\u65f6\u4e3a0\u6216\u540c\u65f6\u4e0d\u4e3a0\u3002", (String)"FinCardValidator_32", (String)"fi-fa-business", (Object[])new Object[0]));
                }
            }
            if ((errorMsgSet = CheckFaFinCardDataUtil.checkPreUsingAmountAndDepredAmount((Object)(depreMethodObj = finCard.get("depremethod")), (Object)(workLoadUnitObj = finCard.get("workloadunit")), (Object)(preUsingAmountObj = finCard.get("preusingamount")), (Object)(depredAmountObj = finCard.get("depredamount")), null)).size() > 0) {
                for (String errorMsg : errorMsgSet) {
                    this.addErrMsg(i, errorMsg);
                }
            }
            this.checkDecValAndDepre(i, param);
            this.checkUpdateFinCard4LeaseContract(i, param);
            this.checkAssetbookStatus(i, param);
            boolean fromDatabase = finCard.getDataEntityState().getFromDatabase();
            if (fromDatabase) continue;
            String sourceFlag = realCard.getString("sourceflag");
            if (!sourceFlag.equals(SourceFlagEnum.IMPORT.name()) && !realCard.getBoolean("mergedcard")) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u53ea\u6709\u5bfc\u5165\u7684\u5b9e\u7269\u5361\u7247\u624d\u80fd\u5bfc\u5165\u8d22\u52a1\u5361\u7247\u3002", (String)"FinCardValidator_33", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            long bookId = assetBook.getLong("id");
            String number = finCard.getString("number");
            String finKey = String.join((CharSequence)"_", String.valueOf(bookId), number);
            if (!existFinNumbers.contains(finKey) || this.isAssetImportCard || finCard.getBoolean("isimport")) continue;
            this.addErrMsg(i, ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5bf9\u5e94\u8d44\u4ea7\u8d26\u7c3f\u7684\u8d22\u52a1\u5361\u7247\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u65b0\u589e\u3002", (String)"FinCardValidator_34", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private void checkFinAccountDate(int index, FinCardValidatorParam param) {
        DynamicObject realCard;
        Date realAccountDate;
        DynamicObject finCard = param.getFinCard();
        Date finAccountDate = finCard.getDate("finaccountdate");
        if (DateUtil.compareShortDate((Date)finAccountDate, (Date)(realAccountDate = (realCard = param.getRealCard()).getDate("realaccountdate"))) < 0) {
            this.addErrMsg(index, String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u4e0d\u80fd\u65e9\u4e8e\u5b9e\u7269\u542f\u7528\u65e5\u671f(%2$s)\u3002", (String)"FinCardValidator_41", (String)"fi-fa-business", (Object[])new Object[0]), DateUtil.formatToString((Date)finAccountDate), DateUtil.formatToString((Date)realAccountDate)));
        }
        long assetBookId = finCard.getLong(Fa.id((String)"assetbook"));
        Map<Object, DynamicObject> assetBookCache = this.getAssetBookCache();
        DynamicObject assetBook = assetBookCache.get(assetBookId);
        DynamicObject curPeriod = assetBook.getDynamicObject("curperiod");
        Date beginDate = curPeriod.getDate("begindate");
        String sourceFlag = realCard.getString("sourceflag");
        if (!SourceFlagEnum.SPLIT.name().equals(sourceFlag) && DateUtil.compareShortDate((Date)finAccountDate, (Date)beginDate) < 0) {
            this.addErrMsg(index, String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f(%2$s)\u3002", (String)"FinCardValidator_42", (String)"fi-fa-business", (Object[])new Object[0]), DateUtil.formatToString((Date)finAccountDate), DateUtil.formatToString((Date)beginDate)));
        }
        long orgId = finCard.getLong(Fa.id((String)"org"));
        if (SourceFlagEnum.LEASECONTRACT.name().equals(sourceFlag)) {
            DynamicObject leaseInit = FaUtils.loadLeaseInitByOrgId(orgId);
            Date startDate = leaseInit.getDate(Fa.dot((String[])new String[]{"startperiod", "begindate"}));
            if (DateUtil.compareShortDate((Date)finAccountDate, (Date)startDate) < 0) {
                this.addErrMsg(index, String.format(ResManager.loadKDString((String)"\u65b0\u589e\u5408\u540c\u4e0b\u63a8\u7684\u5361\u7247\uff0c\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u4e0d\u80fd\u65e9\u4e8e\u79df\u8d41\u521d\u59cb\u5316\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f(%2$s)\u3002", (String)"FinCardValidator_43", (String)"fi-fa-business", (Object[])new Object[0]), DateUtil.formatToString((Date)finAccountDate), DateUtil.formatToString((Date)startDate)));
            }
        } else if (SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag)) {
            Date endDate;
            DynamicObject leaseInit = FaUtils.loadLeaseInitByOrgId(orgId);
            Date startDate = leaseInit.getDate(Fa.dot((String[])new String[]{"startperiod", "begindate"}));
            if (DateUtil.compareShortDate((Date)finAccountDate, (Date)startDate) < 0) {
                this.addErrMsg(index, String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5408\u540c\u4e0b\u63a8\u7684\u5361\u7247\uff0c\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u4e0d\u80fd\u65e9\u4e8e\u79df\u8d41\u521d\u59cb\u5316\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f(%2$s)\u3002", (String)"FinCardValidator_44", (String)"fi-fa-business", (Object[])new Object[0]), DateUtil.formatToString((Date)finAccountDate), DateUtil.formatToString((Date)startDate)));
            }
            if (DateUtil.compareShortDate((Date)finAccountDate, (Date)(endDate = leaseInit.getDate(Fa.dot((String[])new String[]{"startperiod", "enddate"})))) > 0) {
                this.addErrMsg(index, String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5408\u540c\u4e0b\u63a8\u7684\u5361\u7247\uff0c\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u4e0d\u80fd\u665a\u4e8e\u79df\u8d41\u521d\u59cb\u5316\u542f\u7528\u671f\u95f4\u7684\u7ed3\u675f\u65e5\u671f(%2$s)\u3002", (String)"FinCardValidator_45", (String)"fi-fa-business", (Object[])new Object[0]), DateUtil.formatToString((Date)finAccountDate), DateUtil.formatToString((Date)endDate)));
            }
        }
    }

    private void checkDecValAndDepre(int index, FinCardValidatorParam param) {
        BigDecimal preResidualVal;
        DynamicObject assetPolicy;
        BigDecimal decVal;
        DynamicObject finCard = param.getFinCard();
        BigDecimal bigDecimal = decVal = finCard.getBigDecimal("decval") == null ? BigDecimal.ZERO : finCard.getBigDecimal("decval");
        if (BigDecimal.ZERO.compareTo(decVal) > 0) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u51cf\u503c\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"FinCardValidator_46", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((assetPolicy = this.getAssetPolicyCacheRow(index, param)) != null) {
            if (DevaluePolicy.NOT_DEVALUE.getValue().equals(assetPolicy.getString("decpolicy")) && BigDecimal.ZERO.compareTo(finCard.getBigDecimal("decval")) != 0) {
                this.addErrMsg(index, ResManager.loadKDString((String)"\u8d44\u4ea7\u653f\u7b56\u662f\u4e0d\u51cf\u503c\uff0c\u51cf\u503c\u51c6\u5907\u4e0d\u80fd\u6709\u503c\u3002", (String)"FinCardValidator_47", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (assetPolicy.getBoolean("nodepre") && BigDecimal.ZERO.compareTo(finCard.getBigDecimal("accumdepre")) != 0) {
                this.addErrMsg(index, ResManager.loadKDString((String)"\u8d44\u4ea7\u653f\u7b56\u662f\u4e0d\u6298\u65e7\uff0c\u7d2f\u8ba1\u6298\u65e7\u4e0d\u80fd\u6709\u503c\u3002", (String)"FinCardValidator_48", (String)"fi-fa-business", (Object[])new Object[0]));
            }
        }
        BigDecimal originalVal = finCard.getBigDecimal("originalval") == null ? BigDecimal.ZERO : finCard.getBigDecimal("originalval");
        BigDecimal accumDepre = finCard.getBigDecimal("accumdepre") == null ? BigDecimal.ZERO : finCard.getBigDecimal("accumdepre");
        BigDecimal bigDecimal2 = preResidualVal = finCard.getBigDecimal("preresidualval") == null ? BigDecimal.ZERO : finCard.getBigDecimal("preresidualval");
        if (originalVal.subtract(accumDepre).subtract(decVal).compareTo(preResidualVal) < 0) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u9884\u8ba1\u51c0\u6b8b\u503c\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u51c0\u989d\u3002", (String)"FinCardValidator_49", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private void checkAssetbookStatus(int index, FinCardValidatorParam param) {
        DynamicObject finCard = param.getFinCard();
        DynamicObject realCard = param.getRealCard();
        Map<Object, DynamicObject> bookCache = this.getAssetBookCache();
        Long assetBookId = finCard.getLong(Fa.id((String)"assetbook"));
        DynamicObject assetBook = bookCache.get(assetBookId);
        boolean started = "C".equals(assetBook.getString("status"));
        boolean isInitCard = realCard.getBoolean("initialcard");
        if (started && isInitCard) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u521d\u59cb\u5316\u5361\u7247\u3002", (String)"FinCardValidator_50", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private void checkPreUsingAmount(int index, FinCardValidatorParam param) {
        String depreMethodType;
        DynamicObject finCard = param.getFinCard();
        DynamicObject depreMethod = finCard.getDynamicObject("depremethod");
        if (depreMethod == null) {
            return;
        }
        if (!depreMethod.containsProperty("type")) {
            depreMethod = BusinessDataServiceHelper.loadSingleFromCache((Object)finCard.getLong(Fa.id((String)"depremethod")), (String)"fa_depremethod");
        }
        if (StringUtils.isEmpty((String)(depreMethodType = depreMethod.getString("type")))) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u672a\u8bbe\u7f6e\u7c7b\u578b\u3002", (String)"FinCardValidator_51", (String)"fi-fa-business", (Object[])new Object[0]));
            return;
        }
        BigDecimal preUsingAmount = finCard.getBigDecimal("preusingamount");
        if (preUsingAmount == null || preUsingAmount.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9884\u8ba1\u5bff\u547d\u3002", (String)"FinCardValidator_52", (String)"fi-fa-business", (Object[])new Object[0]));
        } else {
            BigDecimal depredAmount = finCard.getBigDecimal("depredamount");
            if (preUsingAmount.compareTo(depredAmount) < 0) {
                if ("5".equals(depreMethodType)) {
                    this.addErrMsg(index, ResManager.loadKDString((String)"\u9884\u8ba1\u603b\u5de5\u4f5c\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7d2f\u8ba1\u5de5\u4f5c\u603b\u91cf\u3002", (String)"FinCardValidator_53", (String)"fi-fa-business", (Object[])new Object[0]));
                } else {
                    this.addErrMsg(index, ResManager.loadKDString((String)"\u9884\u8ba1\u5bff\u547d\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u6298\u65e7\u5bff\u547d\u3002", (String)"FinCardValidator_54", (String)"fi-fa-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkDepreAmount(int index, DynamicObject finCard, DynamicObject realCard) {
        String sourceFlag;
        BigDecimal addupYearDepre;
        BigDecimal accum = finCard.getBigDecimal("accumdepre");
        if (accum.compareTo(addupYearDepre = finCard.getBigDecimal("addupyeardepre")) < 0) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7d2f\u8ba1\u6298\u65e7\u91d1\u989d\u3002", (String)"FinCardValidator_55", (String)"fi-fa-business", (Object[])new Object[0]));
        }
        if ((sourceFlag = realCard.getString("sourceflag")).equals(SourceFlagEnum.SPLIT.name()) || sourceFlag.equals(SourceFlagEnum.DISPATCH.name())) {
            return;
        }
        DynamicObject bizPeriod = finCard.getDynamicObject("bizperiod");
        if (bizPeriod != null) {
            Date finAccountDate = finCard.getDate("finaccountdate");
            if (!bizPeriod.containsProperty("periodtype")) {
                bizPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)bizPeriod.getPkValue(), (String)"bd_period");
            }
            long periodType = bizPeriod.getLong("periodtype_id");
            if (addupYearDepre.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObjectCollection periodColl = (DynamicObjectCollection)ThreadCache.get((Object)("checkDepreAmount" + periodType), () -> {
                    String selectField = Fa.comma((String[])new String[]{"begindate", "enddate"});
                    QFilter periodNumberQ = new QFilter("periodnumber", "=", (Object)1);
                    QFilter periodTypeQ = new QFilter("periodtype", "=", (Object)periodType);
                    QFilter adjustPeriodQ = new QFilter("isadjustperiod", "=", (Object)false);
                    return QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{periodNumberQ, periodTypeQ, adjustPeriodQ}, (String)"periodyear DESC");
                }, (boolean)true);
                boolean isFirstPeriodNumber = false;
                for (DynamicObject period : periodColl) {
                    Date beginDate = period.getDate("begindate");
                    Date endDate = period.getDate("enddate");
                    if (DateUtil.compareShortDate((Date)beginDate, (Date)finAccountDate) > 0 || DateUtil.compareShortDate((Date)endDate, (Date)finAccountDate) < 0) continue;
                    isFirstPeriodNumber = true;
                    break;
                }
                if (isFirstPeriodNumber) {
                    this.addErrMsg(index, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5165\u8d26\u65e5\u671f\u4e3a\u672c\u5e74\u7b2c\u4e00\u671f\uff0c\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u5fc5\u987b\u7b49\u4e8e0\u3002", (String)"FinCardValidator_56", (String)"fi-fa-business", (Object[])new Object[0]));
                }
            }
        }
    }

    private void checkDepreSumHasVoucher4UnAudit() {
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.params.size());
        HashMap<String, Boolean> orgIdDepreUseIdPeriodId2haVoucher = new HashMap<String, Boolean>(16);
        HashMap<Object, Long> finCardPeriodMap = new HashMap<Object, Long>(16);
        boolean isInitialCard = false;
        int i = 0;
        for (FinCardValidatorParam param : this.params) {
            DynamicObject initFinCard = param.getFinCard();
            Long finCardId = (Long)initFinCard.getPkValue();
            Long periodId = initFinCard.getLong(Fa.id((String)"period"));
            DynamicObject realCard = param.getRealCard();
            String sourceFlag = realCard.getString("sourceflag");
            if (SourceFlagEnum.INITIAL.name().equals(sourceFlag)) {
                isInitialCard = true;
            }
            if (SourceFlagEnum.SPLIT.name().equals(sourceFlag)) {
                periodId = initFinCard.getLong(Fa.id((String)"bizperiod"));
            }
            finCardPeriodMap.put(finCardId, periodId);
            StringBuilder sb = new StringBuilder();
            sb.append(initFinCard.getLong(Fa.id((String)"org"))).append("_").append(initFinCard.getLong(Fa.id((String)"depreuse"))).append("_").append(periodId);
            boolean isHasvoucher = false;
            if (orgIdDepreUseIdPeriodId2haVoucher.get(sb.toString()) != null) {
                isHasvoucher = (Boolean)orgIdDepreUseIdPeriodId2haVoucher.get(sb.toString());
            } else {
                isHasvoucher = FaDepreUtil.hasVoucher((Long)initFinCard.getLong(Fa.id((String)"org")), (Long)initFinCard.getLong(Fa.id((String)"depreuse")), (Long)periodId, (boolean)Boolean.TRUE);
                orgIdDepreUseIdPeriodId2haVoucher.put(sb.toString(), isHasvoucher);
            }
            boolean enableSumMutilVoucher = false;
            Long orgId = initFinCard.getLong(Fa.id((String)"org"));
            if (orgId2SumMutilVou.get(orgId) != null) {
                enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
            } else {
                enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
            }
            if (!enableSumMutilVoucher && isHasvoucher) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinCardValidator_3", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            ++i;
        }
        HashMap<Long, Boolean> orgId2GeneraSum = new HashMap<Long, Boolean>(16);
        HashMap<String, Boolean> orgIdDepreUseIdNextPeriodId2haVoucher = new HashMap<String, Boolean>(16);
        HashMap<Object, HashMap<Integer, DynamicObject>> orgIdDUseId2ExtDataDetal = new HashMap<Object, HashMap<Integer, DynamicObject>>(16);
        i = 0;
        for (FinCardValidatorParam param : this.params) {
            Boolean generaSum;
            DynamicObject fin = param.getFinCard();
            Long orgId = fin.getLong(Fa.id((String)"org"));
            Long finCardId = (Long)fin.getPkValue();
            Long periodId = (Long)finCardPeriodMap.get(finCardId);
            if (!isInitialCard) {
                StringBuilder sb = new StringBuilder();
                sb.append(orgId).append("_").append(fin.getLong(Fa.id((String)"depreuse"))).append("_").append(periodId);
                boolean isHasvoucherNextPeriod = false;
                if (orgIdDepreUseIdNextPeriodId2haVoucher.get(sb.toString()) != null) {
                    isHasvoucherNextPeriod = (Boolean)orgIdDepreUseIdNextPeriodId2haVoucher.get(sb.toString());
                } else {
                    boolean isEnable;
                    DynamicObject assetBook = fin.getDynamicObject("assetbook");
                    if (!assetBook.containsProperty("enable")) {
                        assetBook = BusinessDataServiceHelper.loadSingleFromCache((Object)assetBook.getLong("id"), (String)"fa_assetbook");
                    }
                    if (!(isEnable = assetBook.getBoolean("enable"))) {
                        periodId = assetBook.getLong(Fa.id((String)"curperiod"));
                    }
                    isHasvoucherNextPeriod = FaDepreUtil.hasVoucher((Long)fin.getLong(Fa.id((String)"org")), (Long)fin.getLong(Fa.id((String)"depreuse")), (Long)periodId, (boolean)Boolean.FALSE);
                    orgIdDepreUseIdNextPeriodId2haVoucher.put(sb.toString(), isHasvoucherNextPeriod);
                }
                if (isHasvoucherNextPeriod) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinCardValidator_2", (String)"fi-fa-business", (Object[])new Object[0]));
                }
            }
            if (orgId2GeneraSum.get(orgId) != null) {
                generaSum = (Boolean)orgId2GeneraSum.get(orgId);
            } else {
                generaSum = SystemParamHelper.getBooleanParam((String)"isuse_depredetail", (long)orgId, (boolean)false);
                orgId2GeneraSum.put(orgId, generaSum);
            }
            boolean enableSumMutilVoucher = false;
            if (orgId2SumMutilVou.get(orgId) != null) {
                enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
            } else {
                enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
            }
            if (!generaSum.booleanValue() && enableSumMutilVoucher) {
                String orgIdDepreUseIdKey = orgId + "_" + fin.getLong(Fa.id((String)"depreuse"));
                HashMap<Integer, DynamicObject> extDataEntity = (HashMap<Integer, DynamicObject>)orgIdDUseId2ExtDataDetal.get(orgIdDepreUseIdKey);
                if (extDataEntity == null) {
                    extDataEntity = new HashMap<Integer, DynamicObject>(16);
                    orgIdDUseId2ExtDataDetal.put(orgIdDepreUseIdKey, extDataEntity);
                }
                extDataEntity.put(i, fin);
            }
            ++i;
        }
        HashSet<String> hasVouNumberSet = new HashSet<String>(orgIdDUseId2ExtDataDetal.size(), 1.0f);
        for (Map.Entry entry : orgIdDUseId2ExtDataDetal.entrySet()) {
            Map extList = (Map)entry.getValue();
            Long orgId = null;
            Long depreuseId = null;
            Long periodId = null;
            ArrayList<String> numberList = new ArrayList<String>(extList.size());
            for (DynamicObject fin : extList.values()) {
                numberList.add(fin.getString("number"));
                Long finCardId = (Long)fin.getPkValue();
                if (orgId == null) {
                    orgId = fin.getLong(Fa.id((String)"org"));
                }
                if (depreuseId == null) {
                    depreuseId = fin.getLong(Fa.id((String)"depreuse"));
                }
                if (periodId != null) continue;
                periodId = (Long)finCardPeriodMap.get(finCardId);
            }
            SqlBuilder sbSql = new SqlBuilder();
            sbSql.append("SELECT fid id, fnumber number FROM T_FA_CARD_FIN WHERE ", new Object[0]).appendIn(" fnumber ", numberList.toArray()).append(" and forg = ? ", new Object[]{orgId}).append(" and fdepreuseid = ? ", new Object[]{depreuseId});
            HashMap<Long, String> finId2number = new HashMap<Long, String>(extList.size(), 1.0f);
            try (DataSet finDS = this.getDataSet("queryNumberByOrgDepreUseid", FaConstants.faDBRoute, sbSql);){
                for (Row row : finDS) {
                    finId2number.put(row.getLong("id"), row.getString("number"));
                }
            }
            Set voucherIds = FaDepreUtil.getVoucherIds((Long)orgId, (Long)depreuseId, (Long)(isInitialCard ? null : periodId));
            if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)voucherIds)) continue;
            SqlBuilder sbSqlDetail = new SqlBuilder();
            sbSqlDetail.append("SELECT ffincardid fincardid FROM t_fa_depredetailentry WHERE ", new Object[0]).appendIn(" fid ", voucherIds.toArray()).append(" and forgid = ? ", new Object[]{orgId}).append(" and fdepreuseid = ? ", new Object[]{depreuseId}).appendIn(" and ffincardid  ", finId2number.keySet().toArray());
            DataSet detailDS = this.getDataSet("queryFincardidInfa_depredetailentry", FaConstants.faDBRoute, sbSqlDetail);
            Throwable throwable = null;
            try {
                for (Row row : detailDS) {
                    Long fincardid = row.getLong("fincardid");
                    String number = (String)finId2number.get(fincardid);
                    hasVouNumberSet.add(number);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (detailDS == null) continue;
                if (throwable != null) {
                    try {
                        detailDS.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                detailDS.close();
            }
        }
        for (Map edeList : orgIdDUseId2ExtDataDetal.values()) {
            for (Map.Entry ede : edeList.entrySet()) {
                DynamicObject fin = (DynamicObject)ede.getValue();
                Integer index = (Integer)ede.getKey();
                String number = fin.getString("number");
                if (!hasVouNumberSet.contains(number)) continue;
                this.addErrMsg(index, String.format(ResManager.loadKDString((String)"(%1$s)\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25", (String)"FinCardValidator_57", (String)"fi-fa-business", (Object[])new Object[0]), number));
            }
        }
    }

    private void checkDepreSumHasVoucher() {
        long periodId;
        HashMap<Long, Long> depreSumMap = new HashMap<Long, Long>(this.params.size());
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.params.size());
        HashMap<Long, Long> bookIdToPeriodIdMap = new HashMap<Long, Long>(this.params.size());
        for (FinCardValidatorParam param : this.params) {
            DynamicObject realCard = param.getRealCard();
            if ("SPLIT".equalsIgnoreCase(realCard.getString("sourceflag"))) continue;
            DynamicObject finCard = param.getFinCard();
            boolean enableSumMutilVoucher = false;
            Long orgId = finCard.getLong(Fa.id((String)"org"));
            if (orgId2SumMutilVou.get(orgId) != null) {
                enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
            } else {
                enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
            }
            if (enableSumMutilVoucher) continue;
            long assetBookId = finCard.getLong(Fa.id((String)"assetbook"));
            periodId = finCard.getLong(Fa.id((String)"period"));
            Long minPeriodId = (Long)bookIdToPeriodIdMap.get(assetBookId);
            if (minPeriodId != null && periodId >= minPeriodId) continue;
            bookIdToPeriodIdMap.put(assetBookId, periodId);
        }
        if (bookIdToPeriodIdMap.isEmpty()) {
            return;
        }
        Long minPeriodId = bookIdToPeriodIdMap.values().stream().min(Comparator.comparing(v -> v)).orElse(0L);
        QFilter[] filters = new QFilter[]{new QFilter("assetbook", "in", bookIdToPeriodIdMap.keySet()), new QFilter("period", ">=", (Object)minPeriodId)};
        String selectFields = Fa.comma((String[])new String[]{"id", "assetbook", "period"});
        DynamicObjectCollection depreSumList = QueryServiceHelper.query((String)"fa_depre_sum", (String)selectFields, (QFilter[])filters);
        for (DynamicObject depreSum : depreSumList) {
            Long beginPeriodId;
            long bookId = depreSum.getLong("assetbook");
            periodId = depreSum.getLong("period");
            if (periodId < (beginPeriodId = (Long)bookIdToPeriodIdMap.get(bookId))) continue;
            depreSumMap.put(depreSum.getLong("id"), bookId);
        }
        List<Object> depreSumIds = Arrays.asList(depreSumMap.keySet().toArray());
        Set hasVoucher = FaDepreUtil.hasVoucher(depreSumIds, (String)"fa_depre_sum");
        Set hasVoucherBookSet = hasVoucher.stream().map(depreSumMap::get).collect(Collectors.toSet());
        for (int i = 0; i < this.params.size(); ++i) {
            FinCardValidatorParam param = this.params.get(i);
            DynamicObject finCard = param.getFinCard();
            long assetBookId = finCard.getLong(Fa.id((String)"assetbook"));
            if (!hasVoucherBookSet.contains(assetBookId)) continue;
            this.addErrMsg(i, ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinCardValidator_3", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private void checkIsOriginalData(boolean isUnAudit) {
        HashSet<Long> finCardIds = new HashSet<Long>(this.params.size());
        HashSet<Long> orgIds = new HashSet<Long>(this.params.size());
        for (FinCardValidatorParam param : this.params) {
            DynamicObject finCard = param.getFinCard();
            finCardIds.add(finCard.getLong("id"));
            orgIds.add(finCard.getLong(Fa.id((String)"org")));
        }
        if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty(finCardIds)) {
            return;
        }
        Map orgBillParamMap = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit(orgIds);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,foriginaldata from t_fa_card_fin where ", new Object[0]);
        sqlBuilder.appendIn("fid", finCardIds.toArray());
        HashMap<Long, Boolean> finOriginalMap = new HashMap<Long, Boolean>(this.params.size());
        if (!finCardIds.isEmpty()) {
            DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sqlBuilder);
            Object object = null;
            try {
                for (Row row : dataSet) {
                    finOriginalMap.put(row.getLong("fid"), row.getBoolean("foriginaldata"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
        }
        int i = 0;
        for (FinCardValidatorParam param : this.params) {
            Boolean curPeriodSplitEnable;
            DynamicObject finCard = param.getFinCard();
            DynamicObject realCard = param.getRealCard();
            if (isUnAudit && realCard.getBoolean("mergedcard")) continue;
            Long orgId = finCard.getLong(Fa.id((String)"org"));
            Boolean bl = curPeriodSplitEnable = orgBillParamMap.get(orgId) == null ? Boolean.FALSE : (Boolean)orgBillParamMap.get(orgId);
            Long finCardId = finCard.getLong("id");
            Boolean originalData = (Boolean)finOriginalMap.get(finCardId);
            if (originalData == null) continue;
            if (!originalData.booleanValue() && curPeriodSplitEnable.booleanValue()) {
                this.addErrMsg(i, ResManager.loadKDString((String)"[\u65b0\u589e\u5f53\u671f\u652f\u6301\u505a\u62c6\u5206]\u5f00\u5173\u6253\u5f00\uff0c\u53ea\u6709\u539f\u59cb\u8d22\u52a1\u5361\u7247\u624d\u80fd\u8fdb\u884c\u5ba1\u6838\u3001\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinCardValidator_76", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            if (originalData.booleanValue() && !curPeriodSplitEnable.booleanValue()) {
                this.addErrMsg(i, ResManager.loadKDString((String)"[\u65b0\u589e\u5f53\u671f\u652f\u6301\u505a\u62c6\u5206]\u5f00\u5173\u5173\u95ed\uff0c\u53ea\u6709\u975e\u539f\u59cb\u8d22\u52a1\u5361\u7247\u624d\u80fd\u8fdb\u884c\u5ba1\u6838\u3001\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinCardValidator_77", (String)"fi-fa-business", (Object[])new Object[0]));
            }
            ++i;
        }
    }

    private void checkFinCardHasVoucher() {
        ArrayList<Object> finCardIdList = new ArrayList<Object>(this.params.size());
        for (FinCardValidatorParam param : this.params) {
            DynamicObject finCard = param.getFinCard();
            long finCardId = finCard.getLong("id");
            finCardIdList.add(finCardId);
        }
        IFaFinCardDao dao = FaFinCardDaoFactory.getInstance();
        Map<Long, Long> finId2OriFinIdMap = dao.findOriIdsByFinIds(finCardIdList);
        if (finId2OriFinIdMap != null && !finId2OriFinIdMap.isEmpty()) {
            for (Long oriFinId : finId2OriFinIdMap.values()) {
                if (oriFinId == null || oriFinId == 0L || finCardIdList.contains(oriFinId)) continue;
                finCardIdList.add(oriFinId);
            }
        }
        Set hasVoucherFinCardIdSet = FaDepreUtil.hasVoucher(finCardIdList, (String)"fa_card_fin");
        for (int i = 0; i < this.params.size(); ++i) {
            FinCardValidatorParam param = this.params.get(i);
            DynamicObject finCard = param.getFinCard();
            long finCardId = finCard.getLong("id");
            Long oriFinId = finId2OriFinIdMap.get(finCardId);
            if (!hasVoucherFinCardIdSet.contains(finCardId) && (oriFinId == null || oriFinId == 0L || !hasVoucherFinCardIdSet.contains(oriFinId))) continue;
            this.addErrMsg(i, ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinCardValidator_58", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private Optional<String> checkFutureBiz(FinCardValidatorParam pram) {
        DynamicObject realCard = pram.getRealCard();
        DynamicObject finCard = pram.getFinCard();
        HashSet<Long> realCardPkSet = new HashSet<Long>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)FinCardValidator.class.getName(), (String)"fa_card_real", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)realCard.getLong("masterid"))}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            realCardPkSet.add(row.getLong("id"));
        }
        Object orgId = finCard.get("org.id");
        FutureBizChecker futureBizChecker = new FutureBizChecker(null, orgId, realCardPkSet, null, BusyTypeDetailEnum.REAL_FIN_CHG);
        futureBizChecker.setFromFin(true);
        return futureBizChecker.check();
    }

    private Map<String, String> checkFutureBiz(Long orgId, List<FinCardValidatorParam> params) {
        Set realCardPkSet = params.stream().map(v -> v.getRealCard().getLong("masterid")).collect(Collectors.toSet());
        HashMap<Long, String> realId2Number = new HashMap<Long, String>(params.size());
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)FinCardValidator.class.getName(), (String)"fa_card_real", (String)Fa.comma((String[])new String[]{"id", "number"}), (QFilter[])new QFilter[]{new QFilter("masterid", "in", realCardPkSet)}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            realId2Number.put(row.getLong("id"), row.getString("number"));
        }
        FutureBizChecker futureBizChecker = new FutureBizChecker(null, (Object)orgId, null, BusyTypeDetailEnum.REAL_FIN_CHG, realId2Number);
        futureBizChecker.setFromFin(true);
        return futureBizChecker.checkMap();
    }

    private Set<String> existLeaseChangeBill(List<FinCardValidatorParam> params) {
        HashMap<Long, String> number2SrcBillId = new HashMap<Long, String>(params.size());
        HashSet<Long> leaseContractIds = new HashSet<Long>(params.size());
        for (FinCardValidatorParam param : params) {
            DynamicObject realCard = param.getRealCard();
            String srcBillEntityName = realCard.getString("srcbillentityname");
            if (!"fa_lease_contract".equals(srcBillEntityName) && !"fa_lease_contract_init".equals(srcBillEntityName)) continue;
            long srcBillId = realCard.getLong("srcbillid");
            leaseContractIds.add(srcBillId);
            number2SrcBillId.put(srcBillId, realCard.getString("number"));
        }
        HashSet<String> numbers = new HashSet<String>(number2SrcBillId.size());
        if (leaseContractIds.isEmpty()) {
            return numbers;
        }
        Map result = LeaseFutureBizChecker.existFutureLeaseChangeBill(null, leaseContractIds, null, null);
        result.forEach((k, v) -> numbers.add((String)number2SrcBillId.get(k)));
        return numbers;
    }

    private void checkInitBizPeriod(int i, FinCardValidatorParam param) {
        DynamicObject finCard = param.getFinCard();
        long assetBookId = finCard.getLong(Fa.id((String)"assetbook"));
        Map<Object, DynamicObject> assetBookCache = this.getAssetBookCache();
        DynamicObject assetBook = assetBookCache.get(assetBookId);
        BigDecimal addUpYearDepre = finCard.getBigDecimal("addupyeardepre");
        DynamicObject enablePeriod = assetBook.getDynamicObject("startperiod");
        Long periodId = (Long)enablePeriod.getPkValue();
        int periodNumber = PeriodUtil.getPeriodNumberById((long)periodId);
        if (periodNumber == 1 && addUpYearDepre.compareTo(BigDecimal.ZERO) != 0) {
            this.addErrMsg(i, ResManager.loadKDString((String)"\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u4e3a1\u671f\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7", (String)"FinCardValidator_59", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private void checkRealFinDate(int i, FinCardValidatorParam pram) {
        DynamicObject initCard = pram.getFinCard();
        DynamicObject realCard = pram.getRealCard();
        long bookId = initCard.getLong(Fa.id((String)"assetbook"));
        Map<Object, DynamicObject> bookCache = this.getAssetBookCache();
        DynamicObject assetBook = bookCache.get(bookId);
        Date finRecordingPeriod = initCard.getDate("finaccountdate");
        Date realRecordingPeriod = realCard.getDate("realaccountdate");
        Date enableStartPeriod = this.getTypePeriodStartDate(initCard, assetBook);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        if (finRecordingPeriod != null) {
            if (DateUtil.compareShortDate((Date)finRecordingPeriod, (Date)realRecordingPeriod) < 0) {
                this.addErrMsg(i, String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u5e94\u665a\u4e8e\u5b9e\u7269\u5361\u7247\u542f\u7528\u65e5\u671f(%2$s)", (String)"FinCardValidator_60", (String)"fi-fa-business", (Object[])new Object[0]), dateFormat.format(finRecordingPeriod), dateFormat.format(realRecordingPeriod)));
            }
            if (DateUtil.compareShortDate((Date)enableStartPeriod, (Date)finRecordingPeriod) <= 0) {
                this.addErrMsg(i, String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u5e94\u65e9\u4e8e\u8d44\u4ea7\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65f6\u95f4(%2$s)\u3002", (String)"FinCardValidator_61", (String)"fi-fa-business", (Object[])new Object[0]), dateFormat.format(finRecordingPeriod), dateFormat.format(enableStartPeriod)));
            }
        }
    }

    private Set<Long> getHasOtherBookOrgIds() {
        HashSet<Long> hasOtherBookOrgIds = new HashSet<Long>(16);
        for (DynamicObject book : this.getAssetBookCache().values()) {
            boolean isMainBook = book.getBoolean("ismainbook");
            if (isMainBook) continue;
            hasOtherBookOrgIds.add(book.getLong(Fa.id((String)"org")));
        }
        return hasOtherBookOrgIds;
    }

    private Map<Object, DynamicObject> getAssetBookCache() {
        if (this.assetBookCache != null) {
            return this.assetBookCache;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(this.params.size());
        for (FinCardValidatorParam param : this.params) {
            DynamicObject finCard = param.getFinCard();
            long orgId = finCard.getLong(Fa.id((String)"org"));
            orgIdSet.add(orgId);
        }
        this.assetBookCache = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (QFilter[])new QFilter("org", "in", orgIdSet).toArray());
        return this.assetBookCache;
    }

    private Map<Object, List<Tuple<String, DynamicObject>>> getAssetPolicyCache() {
        if (this.assetPolicyCache != null) {
            return this.assetPolicyCache;
        }
        HashSet<Long> assetBookIdSet = new HashSet<Long>(this.params.size());
        for (FinCardValidatorParam param : this.params) {
            DynamicObject finCard = param.getFinCard();
            long bookId = finCard.getLong(Fa.id((String)"assetbook"));
            assetBookIdSet.add(bookId);
        }
        this.assetPolicyCache = AssetPolicyUtil.getAssetPolicyInfoByBookIds(new ArrayList(assetBookIdSet));
        return this.assetPolicyCache;
    }

    private DynamicObject getAssetPolicyCacheRow(int index, FinCardValidatorParam param) {
        DynamicObject finCard = param.getFinCard();
        Map<Object, DynamicObject> bookCache = this.getAssetBookCache();
        Long assetBookId = finCard.getLong(Fa.id((String)"assetbook"));
        DynamicObject assetBook = bookCache.get(assetBookId);
        DynamicObject assetCat = this.getAssetCatFromFinCard(param);
        if (assetBook == null || assetCat == null) {
            return null;
        }
        long depreSystemId = assetBook.getLong(Fa.id((String)"depresystem"));
        if (depreSystemId == 0L) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u672a\u5173\u8054\u8d44\u4ea7\u653f\u7b56\u3002", (String)"FinCardValidator_62", (String)"fi-fa-business", (Object[])new Object[0]));
            return null;
        }
        List<Tuple<String, DynamicObject>> assetPolicyEntry = this.getAssetPolicyCache().get(depreSystemId);
        if (assetPolicyEntry == null) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8d44\u4ea7\u8d26\u7c3f\u5bf9\u5e94\u7684\u8d44\u4ea7\u653f\u7b56\uff0c\u8d44\u4ea7\u8d26\u7c3f\u5173\u8054\u7684\u8d44\u4ea7\u653f\u7b56\u53ef\u80fd\u88ab\u5220\u9664\u4e86\u3002", (String)"FinCardValidator_63", (String)"fi-fa-business", (Object[])new Object[0]));
            return null;
        }
        String assetCatLongNumber = assetCat.getString("longnumber");
        return AssetPolicyUtil.getByAssetPolicyInfoAndCateLongNumber((String)assetCatLongNumber, assetPolicyEntry);
    }

    private DynamicObject getAssetCatFromFinCard(FinCardValidatorParam param) {
        DynamicObject realCard;
        DynamicObject finCard = param.getFinCard();
        DynamicObject assetCat = finCard.getDynamicObject("assetcat");
        if (assetCat == null && this.isAssetCard && (realCard = param.getRealCard()) != null) {
            assetCat = realCard.getDynamicObject("assetcat");
        }
        return assetCat;
    }

    private void addErrMsg(int index, String msg) {
        List msgList = this.errorInfo.computeIfAbsent(index, v -> new ArrayList());
        msgList.add(msg);
    }

    protected void checkUpdateFinCard4LeaseContract(int index, FinCardValidatorParam param) {
        String realCardSourceFlag;
        DynamicObject finCard = param.getFinCard();
        DynamicObject realCard = param.getRealCard();
        boolean isAdd = finCard.getDataEntityState().getFromDatabase();
        String string = realCardSourceFlag = realCard == null ? "" : realCard.get("sourceflag");
        if (isAdd) {
            if (SourceFlagEnum.INITLEASECONTRACT.name().equals(realCardSourceFlag) || SourceFlagEnum.LEASECONTRACT.name().equals(realCardSourceFlag)) {
                long finCardId = finCard.getLong("id");
                String queryField = String.join((CharSequence)",", "originalval", "preusingamount", "depredamount", "accumdepre", "addupyeardepre", Fa.dot((String[])new String[]{"depreuse", "id"}));
                DynamicObject finCardByData = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)queryField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finCardId)});
                if (SourceFlagEnum.INITLEASECONTRACT.name().equals(realCardSourceFlag)) {
                    if (finCardByData.getBigDecimal("originalval").compareTo(finCard.getBigDecimal("originalval")) != 0) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u8d44\u4ea7\u539f\u503c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_64", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                    if (finCardByData.getBigDecimal("preusingamount").compareTo(finCard.getBigDecimal("preusingamount")) != 0) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u9884\u8ba1\u4f7f\u7528\u671f\u95f4\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_65", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                    if (finCardByData.getBigDecimal("depredamount").compareTo(finCard.getBigDecimal("depredamount")) != 0) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u5df2\u6298\u65e7\u671f\u95f4\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_66", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                    if (finCardByData.getBigDecimal("accumdepre").compareTo(finCard.getBigDecimal("accumdepre")) != 0) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u7d2f\u8ba1\u6298\u65e7\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_67", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                    if (finCardByData.getBigDecimal("addupyeardepre").compareTo(finCard.getBigDecimal("addupyeardepre")) != 0) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_68", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                    if (finCardByData.getLong(Fa.dot((String[])new String[]{"depreuse", "id"})) != finCard.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}))) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\uff0c\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_69", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                } else {
                    if (finCardByData.getBigDecimal("originalval").compareTo(finCard.getBigDecimal("originalval")) != 0) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u8d22\u52a1\u5361\u7247\uff0c\u8d44\u4ea7\u539f\u503c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_70", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                    if (finCardByData.getBigDecimal("preusingamount").compareTo(finCard.getBigDecimal("preusingamount")) != 0) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u8d22\u52a1\u5361\u7247\uff0c\u9884\u8ba1\u4f7f\u7528\u671f\u95f4\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_71", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                    if (finCardByData.getLong(Fa.dot((String[])new String[]{"depreuse", "id"})) != finCard.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}))) {
                        this.addErrMsg(index, ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u8d22\u52a1\u5361\u7247\uff0c\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FinCardValidator_72", (String)"fi-fa-business", (Object[])new Object[0]));
                    }
                }
            }
        } else if (SourceFlagEnum.INITLEASECONTRACT.name().equals(realCardSourceFlag)) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u4e0d\u80fd\u901a\u8fc7\u65b0\u589e\u5f15\u5165\uff0c\u8bf7\u5728\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u4e2d\u4e0b\u63a8\u751f\u6210\u3002", (String)"FinCardValidator_73", (String)"fi-fa-business", (Object[])new Object[0]));
        } else if (SourceFlagEnum.LEASECONTRACT.name().equals(realCardSourceFlag)) {
            this.addErrMsg(index, ResManager.loadKDString((String)"\u79df\u8d41\u5408\u540c\u4e0b\u63a8\u7684\u8d22\u52a1\u5361\u7247\u4e0d\u80fd\u901a\u8fc7\u65b0\u589e\u5f15\u5165\u3002", (String)"FinCardValidator_74", (String)"fi-fa-business", (Object[])new Object[0]));
        }
    }

    private Date getTypePeriodStartDate(DynamicObject finCard, DynamicObject assetBook) {
        if (finCard == null) {
            return null;
        }
        DynamicObject enablePeriod = assetBook.getDynamicObject("startperiod");
        if (enablePeriod == null) {
            return null;
        }
        Object enablePeriodPk = enablePeriod.getPkValue();
        Date enableDate = this.enablePeriodMapCache.get(enablePeriodPk);
        if (enableDate != null) {
            return enableDate;
        }
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)enablePeriodPk, (String)"bd_period");
        if (period == null) {
            return null;
        }
        enableDate = period.getDate("begindate");
        this.enablePeriodMapCache.put(enablePeriodPk, enableDate);
        return enableDate;
    }

    private DataSet getDataSet(String algoKey, DBRoute DBroute, SqlBuilder sql) {
        return DB.queryDataSet((String)algoKey, (DBRoute)DBroute, (SqlBuilder)sql);
    }

    private void checkDepreMethod() {
        Set dayTypeDepreIds = FaChangeBillUtil.getAllTypeIsDayDepre();
        HashSet<Long> contractIds = new HashSet<Long>(16);
        for (FinCardValidatorParam validatorParam : this.params) {
            DynamicObject realCard = validatorParam.getRealCard();
            if (realCard == null) continue;
            String sourceFlag = realCard.getString("sourceflag");
            if (!SourceFlagEnum.LEASECONTRACT.name().equals(sourceFlag) && !SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag)) continue;
            contractIds.add(realCard.getLong("srcbillid"));
        }
        HashMap contractMap = new HashMap(contractIds.size());
        if (CollectionUtils.isNotEmpty(contractIds)) {
            DynamicObjectCollection contractObjs = QueryServiceHelper.query((String)"fa_lease_contract", (String)Fa.comma((String[])new String[]{"id", "number", "depretype"}), (QFilter[])new QFilter[]{new QFilter("id", "in", contractIds)});
            contractObjs.stream().forEach(t -> contractMap.put(t.getLong("id"), t));
        }
        int i = 0;
        for (FinCardValidatorParam validatorParam : this.params) {
            DynamicObject finCard = validatorParam.getFinCard();
            DynamicObject realCard = validatorParam.getRealCard();
            if (realCard == null) continue;
            String sourceFlag = realCard.getString("sourceflag");
            Long depreMethodId = finCard.getLong(Fa.id((String)"depremethod"));
            if (SourceFlagEnum.LEASECONTRACT.name().equals(sourceFlag) || SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag)) {
                LeaseContractDepreTypeEnum depreTypeEnum;
                Long contractId = realCard.getLong("srcbillid");
                DynamicObject contract = (DynamicObject)contractMap.get(contractId);
                if (contract != null && (LeaseContractDepreTypeEnum.DAY == (depreTypeEnum = LeaseContractDepreTypeEnum.getByValue((String)contract.getString("depretype"))) && !dayTypeDepreIds.contains(depreMethodId) || LeaseContractDepreTypeEnum.MONTH == depreTypeEnum && dayTypeDepreIds.contains(depreMethodId))) {
                    this.addErrMsg(i, ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u4e0e\u5173\u8054\u79df\u8d41\u5408\u540c\u7684\u6298\u65e7\u65b9\u5f0f\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"FaFinCardCommonValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            } else if (dayTypeDepreIds.contains(depreMethodId)) {
                this.addErrMsg(i, ResManager.loadKDString((String)"\u975e\u5408\u540c\u4e0b\u63a8\u7684\u5361\u7247\uff0c\u4e0d\u652f\u6301\u6309\u65e5\u6298\u65e7\u6cd5\u3002", (String)"FaFinCardCommonValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            ++i;
        }
    }
}

