/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.clear.ClearBillGenerateFacade;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeModeConfUtil;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.FaCurrencyUtil;
import kd.fi.fa.formplugin.FaBillBaseFormPlugin;
import kd.fi.fa.formplugin.importhandler.ClearBillImportHandler;
import kd.fi.fa.utils.FaFormCurPeriodBizUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaQFilter;

public class ClearBillFormPlugin
extends FaBillBaseFormPlugin {
    private static final String CARD_NUM = "number";
    private static final String CARD_NAME = "assetname";
    private static final String DELETE_PK_CACHENAME = "deletePKCacheName";
    private static final String FINCARD_F7_CALLBACK = "fincardF7CallBack";
    private static final String FINCARD_F7_CURINDEX_CACHE = "fincardF7CurIndexCache";
    private static final String FINCARD_F7_FLAG_CACHE = "fincardF7FlagCache";

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if ("shortCuts".equalsIgnoreCase(e.getEventName()) && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fetchdepreinfo"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("fetchdepreinfo".equals(itemKey)) {
            IDataModel model = this.getModel();
            DynamicObject clearBill = model.getDataEntity(true);
            ClearBillGenerateFacade facade = new ClearBillGenerateFacade();
            Map logMap = facade.resetBeforeSave(clearBill, true);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("fa_deprehelp");
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            parameter.setCustomParam("deprelog", (Object)logMap);
            this.getView().showForm(parameter);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        new ClearBillImportHandler().beforeImporChecktData(this.getView(), e);
        super.beforeImportData(e);
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.importCheckCodeRule("fa_clearbill", e, "org");
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        new ClearBillImportHandler().setSourceData2Model(model);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit realcardEdit = (BasedataEdit)this.getView().getControl("realcard");
        realcardEdit.addBeforeF7SelectListener(evt -> this.beforeF7RealCardSelect(evt));
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        if (orgF7 != null) {
            orgF7.setIsOnlyDisplayOrgLeaves(true);
            orgF7.addBeforeF7SelectListener(this::beforeOrgSelect);
        }
        this.addItemClickListeners(new String[]{"tbmain"});
        FaUtils.showDepreAnalyzeButton((AbstractFormPlugin)this, (String)"detail_entry");
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = (DynamicObjectCollection)model.getValue("detail_entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject card = (DynamicObject)entry.get("realcard");
            if (card == null) continue;
            entry.set(CARD_NAME, card.get(CARD_NAME));
            entry.set(CARD_NUM, card.get(CARD_NUM));
            entry.set("seq", (Object)(i + 1));
        }
        this.initEnable();
        model.setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        String type = ((AbstractOperate)args.getSource()).getType();
        String clearSource = (String)model.getValue("clearsource");
        List<String> doOperateType = Arrays.asList("unaudit", "unsubmit", "save");
        if ("audit".equals(type)) {
            this.getView().invokeOperation("refresh");
        }
        if (doOperateType.contains(type)) {
            DynamicObjectCollection entrys = (DynamicObjectCollection)model.getValue("detail_entry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject card = (DynamicObject)entry.get("realcard");
                if (card == null) {
                    return;
                }
                BigDecimal assetQty = card.getBigDecimal("assetamount");
                if (assetQty.compareTo(BigDecimal.ONE) == 0 && "APPLY".equals(clearSource)) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"clearqty"});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"assetvalue"});
                } else if (assetQty.compareTo(BigDecimal.ONE) != 0 && "APPLY".equals(clearSource)) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"clearqty"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"assetvalue"});
                } else if (assetQty.compareTo(BigDecimal.ONE) == 0 && !"APPLY".equals(clearSource)) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"clearqty"});
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"assetvalue"});
                } else {
                    this.getView().setEnable(Boolean.TRUE, i, new String[]{"clearqty"});
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"assetvalue"});
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"isclearall"});
            }
            model.setDataChanged(false);
        }
    }

    private void initEnable() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = (DynamicObjectCollection)model.getValue("detail_entry");
        String clearSource = (String)model.getValue("clearsource");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject card = (DynamicObject)entry.get("realcard");
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"isclearall"});
            if (card == null) continue;
            BigDecimal assetQty = card.getBigDecimal("assetamount");
            if (assetQty.compareTo(BigDecimal.ONE) == 0 && "APPLY".equals(clearSource)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"clearqty"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"assetvalue"});
                continue;
            }
            if (assetQty.compareTo(BigDecimal.ONE) != 0 && "APPLY".equals(clearSource)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"clearqty"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"assetvalue"});
                continue;
            }
            if (assetQty.compareTo(BigDecimal.ONE) == 0 && !"APPLY".equals(clearSource)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"clearqty"});
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"assetvalue"});
                continue;
            }
            this.getView().setEnable(Boolean.TRUE, i, new String[]{"clearqty"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"assetvalue"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDataRange();
        this.getModel().setDataChanged(false);
        this.getView().setVisible(Boolean.FALSE, new String[]{"fetchdepreinfo"});
        this.setShortCuts();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("show_upgradeguide".equals(messageBoxClosedEvent.getCallBackId())) {
            if ("Yes".equals(messageBoxClosedEvent.getResultValue())) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("fa_finori_upg_guide");
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setHasRight(true);
                this.getView().showForm(showParameter);
            }
        } else {
            super.confirmCallBack(messageBoxClosedEvent);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setInitValue();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        int entryCurrentRowIndex = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "realcard": {
                this.cardPropertyChanged(e);
                break;
            }
            case "assetvalue": {
                BigDecimal assetvalue = new BigDecimal(model.getValue("assetvalue", entryCurrentRowIndex).toString());
                Object fincardModel = model.getValue("fincard", entryCurrentRowIndex);
                if (null == fincardModel) {
                    return;
                }
                DynamicObject fincardObj = (DynamicObject)fincardModel;
                DynamicObject fincard = BusinessDataServiceHelper.loadSingle((Object)fincardObj.getPkValue(), (String)"fa_card_fin");
                BigDecimal originalval = fincard.getBigDecimal("originalval");
                BigDecimal rate = BigDecimal.ONE;
                rate = originalval.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : assetvalue.divide(originalval, 10, 4);
                this.setPartValue(rate, fincard, Boolean.TRUE, entryCurrentRowIndex, true);
                break;
            }
            case "clearqty": {
                BigDecimal assetQty = new BigDecimal(model.getValue("assetqty", entryCurrentRowIndex).toString());
                if (assetQty.compareTo(BigDecimal.ONE) == 0) {
                    return;
                }
                BigDecimal clearQty = new BigDecimal(model.getValue("clearqty", entryCurrentRowIndex).toString());
                Object fincardModel = model.getValue("fincard", entryCurrentRowIndex);
                if (null == fincardModel) {
                    return;
                }
                DynamicObject fincardObj = (DynamicObject)fincardModel;
                DynamicObject fincard = BusinessDataServiceHelper.loadSingle((Object)fincardObj.getPkValue(), (String)"fa_card_fin");
                BigDecimal rate = clearQty.divide(assetQty, 10, 4);
                this.setPartValue(rate, fincard, Boolean.FALSE, entryCurrentRowIndex, false);
            }
        }
    }

    void setPartValue(BigDecimal rate, DynamicObject fincard, Boolean assetVlue, int rowIndex, boolean isAssetValueChange) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("clearrate", (Object)rate, rowIndex);
        if (assetVlue.booleanValue()) {
            model.setValue("isclearall", (Object)(rate.compareTo(BigDecimal.ONE) == 0 ? "1" : "0"), rowIndex);
        } else {
            model.setValue("isclearall", (Object)(rate.compareTo(BigDecimal.ONE) == 0 ? "1" : "2"), rowIndex);
        }
        DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency", rowIndex);
        if (!isAssetValueChange) {
            BigDecimal clearAssetValue = fincard.getBigDecimal("originalval").multiply(rate);
            clearAssetValue = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearAssetValue);
            model.setValue("assetvalue", (Object)clearAssetValue, rowIndex);
        }
        BigDecimal clearAcuumDepre = fincard.getBigDecimal("accumdepre").multiply(rate);
        clearAcuumDepre = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearAcuumDepre);
        model.setValue("addupdepre", (Object)clearAcuumDepre, rowIndex);
        BigDecimal cleardecval = fincard.getBigDecimal("decval").multiply(rate);
        cleardecval = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)cleardecval);
        model.setValue("decval", (Object)cleardecval, rowIndex);
        BigDecimal clearnetamount = fincard.getBigDecimal("netamount").multiply(rate);
        clearnetamount = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearnetamount);
        model.setValue("netamount", (Object)clearnetamount, rowIndex);
        BigDecimal clearpreresidualval = fincard.getBigDecimal("preresidualval").multiply(rate);
        clearpreresidualval = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearpreresidualval);
        model.setValue("preresidualval", (Object)clearpreresidualval, rowIndex);
        model.endInit();
        this.getView().updateView("detail_entry");
        this.initEnable();
        model.setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        IDataModel model = this.getModel();
        if (returnData == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getActionId(), (CharSequence)FINCARD_F7_CALLBACK) && returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnDataList = (ListSelectedRowCollection)returnData;
            this.getPageCache().put(FINCARD_F7_FLAG_CACHE, "1");
            if (returnDataList.size() > 0) {
                int curIndex = Integer.parseInt(this.getPageCache().get(FINCARD_F7_CURINDEX_CACHE));
                this.getModel().beginInit();
                this.selectCardCallBack(returnDataList, curIndex);
                this.afterClosedCallBackRemoveRow(curIndex);
                model.clearNoDataRow();
                this.getModel().endInit();
                this.getView().updateView("detail_entry");
            }
            this.initEnable();
            this.getPageCache().remove(FINCARD_F7_FLAG_CACHE);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("detail_entry")) {
            this.SetBefDeleteCardPKsCache(e.getRowIndexs());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals("detail_entry")) {
            this.afterDeleteRelateCardRow();
        }
        this.getView().updateView("detail_entry");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FaFormCurPeriodBizUtils.showGuideConfirm4EditView((BeforeDoOperationEventArgs)args, (IFormView)this.getView(), (String)"fa_clearbill", (IFormPlugin)this);
    }

    private void setInitValue() {
        Long org;
        DynamicObject mainBook;
        Object orgObj;
        Object isChangingMainOrg = this.getModel().getContextVariable("isChangingMainOrg");
        List accountUnits = FaPermissionUtils.getAllBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_clearbill");
        Long orgId = FaPermissionUtils.getDefaultAcctOrg((List)accountUnits);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (isChangingMainOrg == null && parentView != null && parentView.toString().indexOf("FormView-fa_mainpage_grid") == 0) {
            this.getModel().setValue("org", (Object)orgId);
        }
        if ((orgObj = this.getModel().getValue("org")) != null && (mainBook = FaBizUtils.getAsstBookByOrg((Long)(org = Long.valueOf(((DynamicObject)orgObj).getLong("id"))))) != null) {
            this.getModel().setValue("clearperiod", (Object)mainBook.getLong("curperiod"));
        }
        IDataModel model = this.getModel();
        model.setValue("billstatus", (Object)BillStatus.A);
        model.setValue("changemode", (Object)FaChangeModeConfUtil.getChangeModeDefaultValue((Long)orgId, (String)"fa_clearbill"));
        model.setValue("clearsource", (Object)FaClearSourceEnum.ADDNEW);
        if (this.getView() == null || parentView == null) {
            return;
        }
        FaFormPermissionUtil.selectDefaultOrg((IDataModel)model, (IPageCache)((IPageCache)parentView.getService(IPageCache.class)), (String)"fa_clearbill");
    }

    private void setDataRange() {
        FaBizUtils.setDate((IFormView)this.getView(), (String)"cleardate", (DateEdit)((DateEdit)this.getControl("cleardate")), (boolean)false, (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW ? 1 : 0) != 0);
    }

    private void beforeF7RealCardSelect(BeforeF7SelectEvent evt) {
        evt.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, FINCARD_F7_CALLBACK));
        this.getPageCache().put(FINCARD_F7_CURINDEX_CACHE, String.valueOf(evt.getRow()));
        FaQFilter.realCardQFilter((IDataModel)this.getModel(), (BeforeF7SelectEvent)evt);
    }

    public void selectCardCallBack(ListSelectedRowCollection selectlist, int curIndex) {
        if (selectlist.size() == 0) {
            return;
        }
        Date clearDate = (Date)this.getModel().getValue("cleardate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String entryClearDate = this.getLastDayOfMonth(sdf.format(clearDate));
        Set<Object> realCardPKSet = this.getReturnCardPKSet(selectlist);
        Map<Long, List<DynamicObject>> finCardsMap = this.queryFinCardsMap(realCardPKSet);
        try {
            ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>();
            finCardsMap.forEach((key, value) -> finCards.addAll((Collection<DynamicObject>)value));
            Date date = sdf.parse(entryClearDate);
            this.clearEntryBatchSetValue(finCards, date);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void afterClosedCallBackRemoveRow(int curIndex) {
        IDataModel model = this.getModel();
        if (curIndex < 0) {
            return;
        }
        DynamicObject realCard = (DynamicObject)model.getValue("realcard", curIndex);
        if (realCard == null) {
            return;
        }
        HashSet<String> realCardIds = new HashSet<String>();
        realCardIds.add(realCard.getPkValue().toString());
        this.removeOldRows("detail_entry", "realcard", realCardIds, Boolean.TRUE);
    }

    private void beforeOrgSelect(BeforeF7SelectEvent evt) {
        List orgs = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_clearbill", (String)"47156aff000000ac");
        QFilter qFilter = new QFilter("id", "in", (Object)orgs);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(qFilter);
    }

    private Set<Object> getReturnCardPKSet(ListSelectedRowCollection selectlist) {
        HashSet<Object> realCardIds = new HashSet<Object>();
        for (ListSelectedRow row : selectlist) {
            realCardIds.add(row.getPrimaryKeyValue());
        }
        return realCardIds;
    }

    private void SetBefDeleteCardPKsCache(int[] rows) {
        if (rows == null || rows.length == 0) {
            return;
        }
        HashSet<Object> realCardIds = new HashSet<Object>();
        IDataModel model = this.getModel();
        for (int i : rows) {
            DynamicObject realCard = (DynamicObject)model.getValue("realcard", i);
            if (realCard == null) continue;
            realCardIds.add(realCard.getPkValue());
        }
        String pkStr = SerializationUtils.toJsonString(realCardIds);
        this.getPageCache().put(DELETE_PK_CACHENAME, pkStr);
    }

    private void afterDeleteRelateCardRow() {
        if (this.getPageCache().get(DELETE_PK_CACHENAME) == null) {
            return;
        }
        Set realCardIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(DELETE_PK_CACHENAME), Set.class);
        Set idStrs = realCardIds.stream().map(Object::toString).collect(Collectors.toSet());
        this.getPageCache().remove(DELETE_PK_CACHENAME);
        this.removeOldRows("detail_entry", "realcard", idStrs, Boolean.TRUE);
    }

    private void cardPropertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        if (changeData == null) {
            return;
        }
        String f7Flag = this.getPageCache().get(FINCARD_F7_FLAG_CACHE);
        if (f7Flag != null) {
            return;
        }
        DynamicObject card = (DynamicObject)changeData.getNewValue();
        DynamicObject oldCard = (DynamicObject)changeData.getOldValue();
        int curIndex = changeData.getRowIndex();
        if (card == null) {
            if (oldCard != null) {
                this.setEmptyRow(curIndex, oldCard.getPkValue());
                return;
            }
        } else {
            Date date = (Date)this.getModel().getValue("cleardate");
            long orgId = (Long)this.getModel().getValue("org_id");
            HashSet<Long> cardIds = new HashSet<Long>(1);
            cardIds.add(card.getLong("id"));
            String msg = FaUtils.checkRealCardBizStatus(cardIds);
            if (!msg.isEmpty()) {
                this.removeOldRow("detail_entry", "realcard", card.getPkValue().toString(), Boolean.TRUE);
                this.getView().showErrorNotification(msg);
                return;
            }
            Set existCards = FaUtils.getCurRealCard((Date)date, (Long)orgId, (Boolean)false, cardIds, (BusyTypeDetailEnum)BusyTypeDetailEnum.REAL_FIN_CHG, null);
            if (!existCards.containsAll(cardIds)) {
                this.removeOldRow("detail_entry", "realcard", card.getPkValue().toString(), Boolean.TRUE);
                FaUtils.showErrorRealCardMsg((int)1, null, (DynamicObject)card, (IFormView)this.getView());
                return;
            }
            this.changeCardRow(changeData);
        }
        this.getView().updateView("detail_entry");
        this.initEnable();
    }

    private int changeCardRow(ChangeData changeData) {
        int curIndex;
        int result = 0;
        IDataModel model = this.getModel();
        DynamicObject oldCard = (DynamicObject)changeData.getOldValue();
        DynamicObject newCard = (DynamicObject)changeData.getNewValue();
        HashSet<Object> realCardPKSet = new HashSet<Object>();
        realCardPKSet.add(newCard.getPkValue());
        List<DynamicObject> fincards = this.queryFinCards(realCardPKSet);
        int count = fincards.size();
        if (count == 0) {
            return result;
        }
        Boolean isfirstRow = Boolean.TRUE;
        int curRow = curIndex = changeData.getRowIndex();
        Date clearDate = (Date)model.getValue("cleardate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String entryClearDate = this.getLastDayOfMonth(sdf.format(clearDate));
        model.beginInit();
        for (DynamicObject fincard : fincards) {
            DynamicObject realCardDy = fincard.getDynamicObject("realcard");
            if (!isfirstRow.booleanValue()) {
                curRow = model.insertEntryRow("detail_entry", curRow);
                model.setValue("realcard", (Object)realCardDy, curRow);
                ++result;
            } else {
                isfirstRow = Boolean.FALSE;
            }
            this.setEntryRowByFinCard(model, fincard, curRow, Boolean.FALSE, entryClearDate);
            ++curRow;
        }
        model.endInit();
        if (oldCard != null) {
            this.removeOldRow("detail_entry", "realcard", oldCard.getPkValue().toString(), Boolean.TRUE);
        }
        return result;
    }

    private List<DynamicObject> queryFinCards(Set<Object> realCardPKSet) {
        ArrayList<DynamicObject> correctFinCards = new ArrayList<DynamicObject>(16);
        List finCards = FaUtils.queryFinCards(realCardPKSet);
        finCards.stream().forEach(t -> {
            Boolean originalData = t.getBoolean("originaldata");
            if (!originalData.booleanValue()) {
                correctFinCards.add((DynamicObject)t);
            }
        });
        return correctFinCards;
    }

    private void clearEntryBatchSetValue(List<DynamicObject> finCards, Date entryClearDate) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("realcard", new Object[0]);
        setter.addField("fincard", new Object[0]);
        setter.addField(CARD_NUM, new Object[0]);
        setter.addField(CARD_NAME, new Object[0]);
        setter.addField("depreuse", new Object[0]);
        setter.addField("measureunit", new Object[0]);
        setter.addField("assetqty", new Object[0]);
        setter.addField("clearqty", new Object[0]);
        setter.addField("basecurrency", new Object[0]);
        setter.addField("assetvalue", new Object[0]);
        setter.addField("addupdepre", new Object[0]);
        setter.addField("decval", new Object[0]);
        setter.addField("netamount", new Object[0]);
        setter.addField("preresidualval", new Object[0]);
        setter.addField("bizdate", new Object[0]);
        setter.addField("clearrate", new Object[0]);
        for (DynamicObject finCard : finCards) {
            DynamicObject realCard = finCard.getDynamicObject("realcard");
            setter.addRow(new Object[]{realCard.getPkValue(), finCard.getPkValue(), realCard.getString(CARD_NUM), realCard.getString(CARD_NAME), finCard.getDynamicObject("depreuse").getPkValue(), realCard.getDynamicObject("unit").getPkValue(), realCard.getBigDecimal("assetamount"), realCard.getBigDecimal("assetamount"), finCard.getDynamicObject(FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"})).getPkValue(), finCard.getBigDecimal("originalval"), finCard.getBigDecimal("accumdepre"), finCard.getBigDecimal("decval"), finCard.getBigDecimal("netamount"), finCard.getBigDecimal("preresidualval"), entryClearDate, BigDecimal.ONE});
        }
        model.batchCreateNewEntryRow("detail_entry", setter);
    }

    private void setEntryRowByFinCard(IDataModel model, DynamicObject fincard, int curRow, Boolean initCard, String entryClearDate) {
        DynamicObject realCardDy = fincard.getDynamicObject("realcard");
        if (initCard.booleanValue()) {
            model.setValue("realcard", (Object)realCardDy.getLong("id"), curRow);
        }
        model.setValue("fincard", fincard.getPkValue(), curRow);
        model.setValue(CARD_NUM, (Object)realCardDy.getString(CARD_NUM), curRow);
        model.setValue(CARD_NAME, (Object)realCardDy.getString(CARD_NAME), curRow);
        model.setValue("depreuse", fincard.getDynamicObject("depreuse").getPkValue(), curRow);
        model.setValue("measureunit", realCardDy.getDynamicObject("unit").getPkValue(), curRow);
        BigDecimal assetQty = realCardDy.getBigDecimal("assetamount");
        model.setValue("assetqty", (Object)assetQty, curRow);
        model.setValue("clearqty", (Object)assetQty, curRow);
        Object baseCurrencyPK = fincard.getDynamicObject(FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"})).getPkValue();
        model.setValue("basecurrency", baseCurrencyPK, curRow);
        model.setValue("assetvalue", (Object)fincard.getBigDecimal("originalval"), curRow);
        model.setValue("addupdepre", (Object)fincard.getBigDecimal("accumdepre"), curRow);
        model.setValue("decval", (Object)fincard.getBigDecimal("decval"), curRow);
        model.setValue("netamount", (Object)fincard.getBigDecimal("netamount"), curRow);
        model.setValue("preresidualval", (Object)fincard.getBigDecimal("preresidualval"), curRow);
        model.setValue("bizdate", (Object)entryClearDate, curRow);
        model.setValue("clearrate", (Object)BigDecimal.ONE, curRow);
    }

    private String getLastDayOfMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.split("-")[0]);
        int month = Integer.parseInt(yearMonth.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(cal.getTime());
    }

    private void setEmptyRow(int index, Object value) {
        IDataModel model = this.getModel();
        model.setValue("realcard", null, index);
        model.setValue(CARD_NUM, null, index);
        model.setValue(CARD_NAME, null, index);
        model.setValue("depreuse", null, index);
        model.setValue("measureunit", null, index);
        model.setValue("clearqty", null, index);
        model.setValue("basecurrency", null, index);
        model.setValue("clearfare", null, index);
        model.setValue("clearincome", null, index);
        model.setValue("assetvalue", null, index);
        model.setValue("addupdepre", null, index);
        model.setValue("decval", null, index);
        model.setValue("netamount", null, index);
        model.setValue("preresidualval", null, index);
        model.setValue("remark", null, index);
        model.setValue("fincard", null, index);
        this.removeOldRow("detail_entry", "realcard", value.toString(), Boolean.TRUE);
    }

    private int removeOldRow(String entryName, String fieldName, String value, Boolean initFalg) {
        if (value.isEmpty()) {
            return 0;
        }
        HashSet<String> realCardIds = new HashSet<String>();
        realCardIds.add(value);
        return this.removeOldRows(entryName, fieldName, realCardIds, initFalg);
    }

    private Map<Long, List<DynamicObject>> queryFinCardsMap(Set<Object> realCardPKSet) {
        List finCardLst = FaUtils.queryFinCards(realCardPKSet);
        Map<Long, List<DynamicObject>> result = this.finCardslist2Map(finCardLst);
        return result;
    }

    private Map<Long, List<DynamicObject>> finCardslist2Map(List<DynamicObject> finCards) {
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject finCard : finCards) {
            DynamicObject realCardDy = finCard.getDynamicObject("realcard");
            Long readCardId = Long.valueOf(realCardDy.getPkValue().toString());
            List readCardIdV = (List)result.get(readCardId);
            if (readCardIdV != null) {
                readCardIdV.add(finCard);
                continue;
            }
            ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>();
            dys.add(finCard);
            result.put(readCardId, dys);
        }
        return result;
    }
}

