/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.assetcard;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.New;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.cardgenerate.CardGenerateHelper;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBigDecimalUtil;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.cache.FaBusinessImportCardThreadCacheUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class FaAssetCardEditPlugin
extends AbstractBillPlugIn
implements TabSelectListener {
    private static final Log logger = LogFactory.getLog(FaAssetCardEditPlugin.class);
    public static final String PAGE_CACHE_DEPRE_USE_CARD = "depreUseCard";
    public static final String PAGE_CACHE_FIN_CARD_PAGE_ID = "finCardPageId";
    public static final String PAGE_CACHE_RELOAD_FIN_CARD = "reloadFinCard";
    private static final String PAGE_CACHE_RESTORE_VALUE = "restoreValue";
    private static final String RELOAD_FIN_TRUE = "1";
    private static final String RELOAD_FIN_FALSE = "0";
    private static final String RESTORE_VALUE = "1";
    public static final String KEY_DEFAULT_DEPREUSE_ID = "default_depreuse_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab assetInfoTab = (Tab)this.getView().getControl("assetinfotab");
        assetInfoTab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.parentFormIsSplitBill()) {
            return;
        }
        IBillModel iBillModel = (IBillModel)this.getModel();
        if (!iBillModel.isFromImport()) {
            this.initCard();
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.loadFinCard();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.insertFinCardLayout();
        this.setAssetInfoTabSelect();
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if ("fintab".equals(tabKey)) {
            String reloadFin = this.getPageCache().get(PAGE_CACHE_RELOAD_FIN_CARD);
            if (RELOAD_FIN_FALSE.equals(reloadFin)) {
                return;
            }
            this.reloadDefaultFinCard();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propKey = e.getProperty().getName();
        if ("assetcat".equals(propKey)) {
            this.processFieldChangedToFinCard(e, this::handleAssetCatChanged);
        } else if ("realaccountdate".equals(propKey)) {
            this.processFieldChangedToFinCard(e, this::handleRealAccountDateChanged);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate instanceof New) {
            this.getView().getFormShowParameter().setCustomParam("finCardId", null);
        }
        String depreUseCardStr = this.cacheCurrentFinCard();
        operate.getOption().setVariableValue("assetCardFinInfo", depreUseCardStr);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (result != null && result.isSuccess()) {
            Long orgId;
            boolean enableCurPeriodSplit;
            String operateKey = args.getOperateKey();
            if ("viewbillrelation".equals(operateKey)) {
                return;
            }
            if (("unaudit".equals(operateKey) || "audit".equals(operateKey)) && (enableCurPeriodSplit = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)(orgId = Long.valueOf(this.getModel().getDataEntity().getLong(Fa.id((String)"org"))))))) {
                this.updateEntryFinCard();
            }
            this.loadFinCard();
            this.updateCurrentFinCard();
        }
    }

    private void updateEntryFinCard() {
        DynamicObject assetCard = this.getModel().getDataEntity(true);
        DynamicObjectCollection finEntries = assetCard.getDynamicObjectCollection("finentry");
        HashSet entryIds = new HashSet();
        finEntries.stream().forEach(t -> entryIds.add(t.getLong("id")));
        HashMap<Long, Long> entryIdFinCardIdMap = new HashMap<Long, Long>(finEntries.size());
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fentryid,ffincardid from t_fa_asset_finentry where ", new Object[0]);
        querySql.appendIn(" fentryid ", (Object[])entryIds.toArray(new Long[0]));
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
            for (Row row : dataSet) {
                entryIdFinCardIdMap.put(row.getLong("fentryid"), row.getLong("ffincardid"));
            }
        }
        Map finCardRecords = BusinessDataServiceHelper.loadFromCache((String)"fa_card_fin_base", (QFilter[])new QFilter[]{new QFilter("id", "in", entryIdFinCardIdMap.values())});
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicObjectType itemPropertyType = ((EntryProp)entityType.getProperty("finentry")).getDynamicCollectionItemPropertyType();
        DynamicProperty property = itemPropertyType.getProperty("fincard");
        DynamicProperty cardIdProperty = itemPropertyType.getProperty(Fa.id((String)"fincard"));
        for (DynamicObject finEntry : finEntries) {
            Long entryId = finEntry.getLong("id");
            DataEntityState dataEntityState = finEntry.getDataEntityState();
            if (!entryIdFinCardIdMap.containsKey(entryId)) continue;
            Long finCardId = (Long)entryIdFinCardIdMap.get(entryId);
            finEntry.set(Fa.id((String)"fincard"), (Object)finCardId);
            finEntry.set("fincard", finCardRecords.get(finCardId));
            dataEntityState.setBizChanged(property.getOrdinal(), Boolean.FALSE.booleanValue());
            dataEntityState.setBizChanged(cardIdProperty.getOrdinal(), Boolean.FALSE.booleanValue());
        }
    }

    private void processFieldChangedToFinCard(PropertyChangedArgs e, BiConsumer<DynamicObject, Object> handler) {
        String restoreValue = this.getPageCache().get(PAGE_CACHE_RESTORE_VALUE);
        if ("1".equals(restoreValue)) {
            this.getPageCache().remove(PAGE_CACHE_RESTORE_VALUE);
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            logger.info("\u53d8\u66f4\u540e\u7684\u503c\u4e3anull\uff0c\u4e0d\u8054\u52a8\u66f4\u65b0\u5b57\u6bb5\u3002");
            return;
        }
        String cacheDepreUseCardStr = this.cacheCurrentFinCard();
        Map depreUseCardMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheDepreUseCardStr);
        try {
            for (DynamicObject finCard : depreUseCardMap.values()) {
                handler.accept(finCard, newValue);
            }
        }
        catch (KDBizException kdBizException) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            String propName = e.getProperty().getName();
            this.getPageCache().put(PAGE_CACHE_RESTORE_VALUE, "1");
            this.getModel().setValue(propName, oldValue);
            logger.error("\u8d44\u4ea7\u5361\u7247\u503c\u6539\u53d8\u4e8b\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)kdBizException);
            this.getView().showErrorNotification(kdBizException.getMessage());
        }
        cacheDepreUseCardStr = SerializationUtils.serializeToBase64((Object)depreUseCardMap);
        this.getPageCache().put(PAGE_CACHE_DEPRE_USE_CARD, cacheDepreUseCardStr);
        this.updateCurrentFinCard();
    }

    private void handleAssetCatChanged(DynamicObject finCard, Object newValue) {
        BigDecimal preResidualVal;
        DynamicObject workLoadUnitDynObj;
        if (newValue == null) {
            return;
        }
        DynamicObject newAssetCat = (DynamicObject)newValue;
        finCard.set("assetcat", (Object)newAssetCat);
        DynamicObject assetBook = finCard.getDynamicObject("assetbook");
        if (assetBook == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u6570\u636e\u5f02\u5e38\uff0c\u672a\u5173\u8054\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaAssetCardEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject policyEntry = AssetPolicyUtil.getByBookAndCat((Object)assetBook.getPkValue(), (Object)newAssetCat.getPkValue());
        DynamicObject depreMethod = finCard.getDynamicObject("depremethod");
        if (depreMethod == null) {
            depreMethod = policyEntry.getDynamicObject("depremethod");
            finCard.set("depremethod", (Object)depreMethod);
        }
        if (Objects.isNull(workLoadUnitDynObj = finCard.getDynamicObject("workloadunit"))) {
            workLoadUnitDynObj = policyEntry.getDynamicObject("workloadunit");
            finCard.set("workloadunit", (Object)workLoadUnitDynObj);
        }
        finCard.set("netresidualvalrate", policyEntry.get("netresidualvalrate"));
        BigDecimal preUsingAmount = finCard.getBigDecimal("preusingamount");
        if (BigDecimal.ZERO.compareTo(preUsingAmount) == 0) {
            String depreMethodType = depreMethod == null ? "" : depreMethod.getString("type");
            long periodTypeId = assetBook.getLong(Fa.id((String)"periodtype"));
            BigDecimal expectUse = policyEntry.getBigDecimal("expectuse");
            if (!"5".equals(depreMethodType)) {
                int yearPeriodType = FaBusinessImportCardThreadCacheUtil.getYearPeriodType((int)Calendar.getInstance().get(1), (long)periodTypeId);
                finCard.set("preusingamount", (Object)expectUse.multiply(new BigDecimal(yearPeriodType)));
            } else {
                finCard.set("preusingamount", (Object)expectUse);
            }
        }
        if (BigDecimal.ZERO.compareTo(preResidualVal = finCard.getBigDecimal("preresidualval")) == 0) {
            DynamicObject baseCurrency = finCard.getDynamicObject("basecurrency");
            int amtPrecision = baseCurrency.getInt("amtprecision");
            BigDecimal originalVal = finCard.getBigDecimal("originalval");
            BigDecimal netResidualValRate = policyEntry.getBigDecimal("netresidualvalrate");
            preResidualVal = originalVal.multiply(netResidualValRate).divide(FaBigDecimalUtil.HUNDRED, amtPrecision, 4);
            finCard.set("preresidualval", (Object)preResidualVal);
        }
    }

    private void handleRealAccountDateChanged(DynamicObject finCard, Object newValue) {
        if (newValue == null) {
            return;
        }
        Date newRealAccountDate = (Date)newValue;
        DynamicObject realcard = finCard.getDynamicObject("realcard");
        if (realcard != null) {
            realcard.set("realaccountdate", (Object)newRealAccountDate);
        }
        Date defaultFinAccountDate = this.getDefaultFinAccountDate(finCard);
        long periodId = finCard.getLong(Fa.id((String)"period"));
        Date finAccountDate = DateUtil.compareShortDate((Date)newRealAccountDate, (Date)defaultFinAccountDate) < 0 && periodId != 0L ? defaultFinAccountDate : newRealAccountDate;
        if (periodId != 0L) {
            DynamicObject assetBook = finCard.getDynamicObject("assetbook");
            long periodTypeId = assetBook.getLong(Fa.id((String)"periodtype"));
            DynamicObject accountPeriod = PeriodUtil.getPeriodFullObjByDate((Date)finAccountDate, (long)periodTypeId);
            if (accountPeriod == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d22\u52a1\u5165\u8d26\u65e5\u671f[%s]\u5bf9\u5e94\u7684\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"FaAssetCardEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), DateUtil.formatToString((Date)finAccountDate)));
            }
            finCard.set("period", (Object)accountPeriod);
            finCard.set("bizperiod", (Object)accountPeriod);
        }
        finCard.set("finaccountdate", (Object)finAccountDate);
    }

    private Date getDefaultFinAccountDate(DynamicObject finCard) {
        Date endDate;
        DynamicObject book = finCard.getDynamicObject("assetbook");
        if (book.getDynamicObject("curperiod") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u8d26\u7c3f\u5e76\u8bbe\u7f6e\u542f\u7528\u72b6\u6001\u3002", (String)"FaAssetCardEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject currentPeriod = book.getDynamicObject("curperiod");
        if (!currentPeriod.containsProperty("begindate")) {
            currentPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)currentPeriod.getPkValue(), (String)"bd_period");
        }
        Date beginDate = currentPeriod.getDate("begindate");
        Date defaultFinAccountDate = endDate = currentPeriod.getDate("enddate");
        Date now = Calendar.getInstance().getTime();
        if (DateUtil.compareShortDate((Date)beginDate, (Date)now) <= 0 && DateUtil.compareShortDate((Date)now, (Date)endDate) <= 0) {
            defaultFinAccountDate = now;
        }
        try {
            DateFormat format = Fa.getDF();
            defaultFinAccountDate = format.parse(format.format(defaultFinAccountDate));
        }
        catch (ParseException e) {
            logger.error(String.format("\u683c\u5f0f\u5316\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u9ed8\u8ba4\u503c\u53d1\u751f\u5f02\u5e38\u3002[%s]", defaultFinAccountDate), (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u683c\u5f0f\u5316\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u9ed8\u8ba4\u503c\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"FaAssetCardEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return defaultFinAccountDate;
    }

    private void setAssetInfoTabSelect() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object finCardId = parameter.getCustomParam("finCardId");
        Tab assetInfoTab = (Tab)this.getView().getControl("assetinfotab");
        if (finCardId != null) {
            assetInfoTab.activeTab("fintab");
        } else {
            assetInfoTab.activeTab("realtab");
        }
    }

    private void initCard() {
        this.initRealCard();
        this.initFinCard();
    }

    private void initRealCard() {
        this.getModel().setValue("mergedcard", (Object)Boolean.TRUE);
        if ("fa_asset_initcard".equals(this.getView().getRootControl().getKey())) {
            this.getModel().setValue("initialcard", (Object)Boolean.TRUE);
            this.getModel().setValue("sourceflag", (Object)"INITIAL");
        }
        long realCardId = DB.genLongId((String)"t_fa_card_real");
        this.getModel().setValue("id", (Object)realCardId);
    }

    private void initFinCard() {
        DynamicObject realCard = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        ArrayList<DynamicObject> realCardList = new ArrayList<DynamicObject>(1);
        MainEntityType realBaseDataType = EntityMetadataCache.getDataEntityType((String)"fa_card_real_base");
        realCardList.add(FaBizUtils.realCard2RealCardBaseData((DynamicObject)realCard, (DynamicObjectType)realBaseDataType));
        String entityName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        Map finCardMap = CardGenerateHelper.generateFinCardForAssetCard(realCardList, (String)entityName);
        Map depreUseCardMap = finCardMap.getOrDefault(realCard.getLong("id"), new HashMap(0));
        String depreUseCardStr = SerializationUtils.serializeToBase64((Object)depreUseCardMap);
        this.getPageCache().put(PAGE_CACHE_DEPRE_USE_CARD, depreUseCardStr);
    }

    private void loadFinCard() {
        Object[] finCardIds;
        long realCardId = (Long)this.getModel().getValue("id");
        String entryName = this.getModel().getDataEntityType().getName();
        DynamicObjectCollection finEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("finentry");
        HashSet<Long> finIds = new HashSet<Long>(2);
        for (DynamicObject entry : finEntry) {
            if ("fa_asset_initcard".equals(entryName)) {
                finIds.add(entry.getLong(Fa.id((String)"originalfincard")));
                continue;
            }
            finIds.add(entry.getLong(Fa.id((String)"fincard")));
        }
        if (!finIds.isEmpty()) {
            finCardIds = finIds.toArray();
        } else {
            QFilter[] filters;
            long masterId = (Long)this.getModel().getValue("masterid");
            if ("fa_asset_initcard".equals(entryName)) {
                filters = new QFilter[]{new QFilter("realcardmasterid", "=", (Object)masterId), new QFilter("period", "=", (Object)"bizperiod", true)};
            } else {
                String billStatus = (String)this.getModel().getValue("billstatus");
                Long orgId = (Long)this.getModel().getValue(Fa.id((String)"org"));
                boolean curPeriodSplitEnable = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)orgId);
                filters = curPeriodSplitEnable && !BillStatus.C.name().equals(billStatus) ? new QFilter[]{new QFilter("realcard", "=", (Object)realCardId), new QFilter("endperiod", "=", (Object)99999999999L).or(new QFilter("originaldata", "=", (Object)true))} : new QFilter[]{new QFilter("realcard", "=", (Object)realCardId), new QFilter("endperiod", "=", (Object)99999999999L)};
            }
            DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id", (QFilter[])filters);
            finCardIds = finCards.stream().map(v -> v.getLong("id")).toArray();
        }
        String finEntityName = "fa_card_fin";
        if ("fa_asset_initcard".equals(this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            finEntityName = "fa_initcard_fin";
        }
        DynamicObject[] finCardArr = BusinessDataServiceHelper.load((Object[])finCardIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)finEntityName));
        Map<Long, DynamicObject> depreUseCardMap = Arrays.stream(finCardArr).collect(Collectors.toMap(v -> v.getLong(Fa.id((String)"depreuse")), v -> v));
        String depreUseCardStr = SerializationUtils.serializeToBase64(depreUseCardMap);
        this.getPageCache().put(PAGE_CACHE_DEPRE_USE_CARD, depreUseCardStr);
    }

    private void insertFinCardLayout() {
        String billName = this.getModel().getDataEntity().getDynamicObjectType().getName();
        String layoutName = "fa_asset_card_fin";
        if (billName.equals("fa_asset_initcard")) {
            layoutName = "fa_asset_cardinit_fin";
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object finCardId = showParameter.getCustomParam("finCardId");
        BillShowParameter showFinCardParam = new BillShowParameter();
        showFinCardParam.setFormId(layoutName);
        showFinCardParam.getOpenStyle().setShowType(ShowType.InContainer);
        showFinCardParam.getOpenStyle().setTargetKey("fininfo");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        showFinCardParam.setStatus(status);
        if (this.parentFormIsSplitBill()) {
            Object splitBizType = showParameter.getCustomParam("biztype");
            showFinCardParam.setCustomParam("biztype", splitBizType);
            showFinCardParam.setCustomParam("fa_assetsplitbill_billstatus", showParameter.getCustomParam("fa_assetsplitbill_billstatus"));
            showFinCardParam.setCustomParam("split_page_id", showParameter.getCustomParam("split_page_id"));
        }
        if (finCardId == null) {
            this.getPageCache().put(PAGE_CACHE_RELOAD_FIN_CARD, "1");
        } else {
            showFinCardParam.setPkId(finCardId);
            this.getPageCache().put(PAGE_CACHE_RELOAD_FIN_CARD, RELOAD_FIN_FALSE);
        }
        this.getView().showForm((FormShowParameter)showFinCardParam);
        this.getPageCache().put(PAGE_CACHE_FIN_CARD_PAGE_ID, showFinCardParam.getPageId());
    }

    private void reloadDefaultFinCard() {
        String finCardPageId = this.getPageCache().get(PAGE_CACHE_FIN_CARD_PAGE_ID);
        IFormView finCardView = this.getView().getView(finCardPageId);
        IDataModel finCardModel = finCardView.getModel();
        DynamicObject defaultFinCard = this.getDefaultFinCard();
        if (defaultFinCard == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u7684\u8d22\u52a1\u4fe1\u606f\u3002", (String)"FaAssetCardEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"fininfo"});
            return;
        }
        finCardModel.createNewData((Object)defaultFinCard);
        finCardView.updateView();
        this.getView().sendFormAction(finCardView);
        this.getPageCache().put(PAGE_CACHE_RELOAD_FIN_CARD, RELOAD_FIN_FALSE);
    }

    private void updateCurrentFinCard() {
        String reloadFinCard = this.getPageCache().get(PAGE_CACHE_RELOAD_FIN_CARD);
        if ("1".equals(reloadFinCard)) {
            return;
        }
        String depreUseCardStr = this.getPageCache().get(PAGE_CACHE_DEPRE_USE_CARD);
        Map depreUseCardMap = (Map)SerializationUtils.deSerializeFromBase64((String)depreUseCardStr);
        String finCardPageId = this.getPageCache().get(PAGE_CACHE_FIN_CARD_PAGE_ID);
        IFormView finCardView = this.getView().getView(finCardPageId);
        IDataModel finCardModel = finCardView.getModel();
        DynamicObject depreUse = (DynamicObject)finCardModel.getValue("depreuse");
        DynamicObject finCard = (DynamicObject)depreUseCardMap.get(depreUse.getLong("id"));
        finCardModel.createNewData((Object)finCard);
        finCardView.updateView();
        this.getView().sendFormAction(finCardView);
    }

    private DynamicObject getDefaultFinCard() {
        String depreUseCardStr = this.getPageCache().get(PAGE_CACHE_DEPRE_USE_CARD);
        if (depreUseCardStr == null) {
            logger.info("pageCache\u4e2d\u672a\u627e\u5230\u8d22\u52a1\u5361\u7247\u4fe1\u606f");
            return null;
        }
        Map depreUseCardMap = (Map)SerializationUtils.deSerializeFromBase64((String)depreUseCardStr);
        long orgId = (Long)this.getModel().getValue(Fa.id((String)"org"));
        String fields = Fa.comma((String[])new String[]{"depreuse", "ismainbook"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)fields, (QFilter[])new QFilter("org", "=", (Object)orgId).toArray());
        if (books.isEmpty()) {
            logger.info(String.format("\u672a\u627e\u5230\u6838\u7b97\u7ec4\u7ec7\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\uff0c\u6838\u7b97\u7ec4\u7ec7id:%s", orgId));
            return null;
        }
        long defaultDepreUseId = 0L;
        if (this.parentFormIsSplitBill()) {
            defaultDepreUseId = (Long)this.getView().getFormShowParameter().getCustomParam(KEY_DEFAULT_DEPREUSE_ID);
        } else {
            for (DynamicObject book : books) {
                boolean isMainBook = book.getBoolean("ismainbook");
                if (!isMainBook) continue;
                defaultDepreUseId = book.getLong("depreuse");
                break;
            }
        }
        if (defaultDepreUseId == 0L) {
            defaultDepreUseId = ((DynamicObject)books.get(0)).getLong("depreuse");
        }
        return (DynamicObject)depreUseCardMap.get(defaultDepreUseId);
    }

    private String cacheCurrentFinCard() {
        String reloadFinCard = this.getPageCache().get(PAGE_CACHE_RELOAD_FIN_CARD);
        if ("1".equals(reloadFinCard)) {
            return this.getPageCache().get(PAGE_CACHE_DEPRE_USE_CARD);
        }
        String finCardPageId = this.getPageCache().get(PAGE_CACHE_FIN_CARD_PAGE_ID);
        IFormView finCardView = this.getView().getView(finCardPageId);
        DynamicObject finCard = finCardView.getModel().getDataEntity(true);
        DynamicObject realCard = BusinessDataServiceHelper.newDynamicObject((String)"fa_card_real_base");
        DynamicObject assetCard = this.getModel().getDataEntity();
        realCard.set("id", assetCard.getPkValue());
        realCard.set("sourceflag", (Object)assetCard.getString("sourceflag"));
        realCard.set("realaccountdate", (Object)assetCard.getDate("realaccountdate"));
        finCard.set("realcard", (Object)realCard);
        String depreUseCardStr = this.getPageCache().get(PAGE_CACHE_DEPRE_USE_CARD);
        Map depreUseCardMap = (Map)SerializationUtils.deSerializeFromBase64((String)depreUseCardStr);
        long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
        depreUseCardMap.put(depreUseId, finCard);
        depreUseCardStr = SerializationUtils.serializeToBase64((Object)depreUseCardMap);
        this.getPageCache().put(PAGE_CACHE_DEPRE_USE_CARD, depreUseCardStr);
        return depreUseCardStr;
    }

    private boolean parentFormIsSplitBill() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String parentFormId = showParameter.getParentFormId();
        return StringUtils.isNotEmpty((String)parentFormId) && "fa_assetsplitbill".equals(parentFormId);
    }
}

