/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.closeinit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.Row;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.gl.closeinit.BatchInitInfo;
import kd.fi.gl.closeinit.InitBalInfo;
import kd.fi.gl.closeinit.InitBalKey;

public class AcctSumBatchInitInfo
extends BatchInitInfo {
    public AcctSumBatchInitInfo() {
    }

    public AcctSumBatchInitInfo(int assistSize, Collection<LocalCurrencyConfigVO> localCurList) {
        super(assistSize, localCurList);
    }

    @Override
    public void add(Row initBal, long startPeriodId) {
        this.accounts.add(initBal.getLong("account"));
        this.assgrps.add(initBal.getLong("assgrp"));
        this.currencys.add(initBal.getLong("currency"));
        this.measureunits.add(initBal.getLong("measureunit"));
        InitBalKey key = this.getKey(initBal);
        if (this.initBals.containsKey(key)) {
            InitBalInfo balInfo = (InitBalInfo)this.initBals.get(key);
            balInfo.addInitBal(new InitBalInfo(initBal, startPeriodId, this.comsize, this.localCurList));
        } else {
            this.initBals.put(key, new InitBalInfo(initBal, startPeriodId, this.comsize, this.localCurList));
        }
        for (int i = 1; i <= this.comsize; ++i) {
            Set set = this.comassist.computeIfAbsent(i, x -> new HashSet());
            set.add(initBal.getLong("comassist" + i));
        }
    }

    private InitBalKey getKey(Row initBal) {
        ArrayList<Long> comassist = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comsize; ++i) {
            comassist.add(initBal.getLong("comassist" + i));
        }
        InitBalKey key = new InitBalKey(initBal.getLong("org").longValue(), initBal.getLong("booktype").longValue(), initBal.getLong("accounttable").longValue(), initBal.getLong("account").longValue(), 0L, initBal.getLong("currency").longValue(), initBal.getLong("measureunit").longValue(), comassist);
        return key;
    }
}

