/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.balcal.log.DataChangeLog;
import kd.fi.gl.closeinit.AcctSumBatchInitInfo;
import kd.fi.gl.closeinit.BatchInitInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.opplugin.CloseInitBalanceValidator;
import kd.fi.gl.opplugin.CloseInitOp;
import kd.fi.gl.opplugin.closeinit.AcctBalanceUpdate;
import kd.fi.gl.opplugin.closeinit.UpdateBalThread;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLUtil;
import kd.sdk.fi.gl.extpoint.bal.BalKey;

public class CloseInitBalanceOp
extends CloseInitOp {
    private static final Log logger = LogFactory.getLog(CloseInitBalanceOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bookstype");
        fieldKeys.add("basecurrency");
        fieldKeys.add("startperiod");
        fieldKeys.add("isendinit");
        fieldKeys.add("enable");
    }

    protected boolean setBalanceUpdParam(DynamicObject book, Row initBal, MainEntityType balType, List<DynamicObject> objList, List<Object> rmvList, List<BalKey> delDemension, Map<String, DataChangeLog> id2Log) {
        return false;
    }

    protected void saveInitFlag(DynamicObject book) {
        book.set("isendinit", (Object)"1");
        BusinessDataWriter.save((IDataEntityType)book.getDataEntityType(), (Object[])new Object[]{book});
        this.deleteInitBalance(book);
    }

    private void deleteInitBalance(DynamicObject book) {
        QFilter orgF = new QFilter("org", "=", (Object)book.getLong(GLField.id_((String)"org")));
        QFilter bookTypeF = new QFilter("booktype", "=", (Object)book.getLong(GLField.id_((String)"bookstype")));
        QFilter deleteF = new QFilter("isdeleted", "=", (Object)"1");
        DeleteServiceHelper.delete((String)"gl_initbalance", (QFilter[])new QFilter[]{orgF, bookTypeF, deleteF});
    }

    protected DynamicObject newBalance(Row initBalance, DynamicObject book, long endPeriodId) {
        return null;
    }

    protected AbstractValidator getCloseInitValidator() {
        return new CloseInitBalanceValidator();
    }

    protected DataSet getInitData(DynamicObject book) {
        QFilter orgF = new QFilter("org", "=", (Object)book.getLong(GLField.id_((String)"org")));
        QFilter bookTypeF = new QFilter("booktype", "=", (Object)book.getLong(GLField.id_((String)"bookstype")));
        String sel = String.join((CharSequence)",", "org", "booktype", "accounttable", "account.masterid account", "assgrp", "currency", "measureunit", "begindebitqty", "begindebitfor", "begindebitlocal", "begincreditqty", "begincreditfor", "begincreditlocal", "yeardebitqty", "yeardebitfor", "yeardebitlocal", "yearcreditqty", "yearcreditfor", "yearcreditlocal");
        sel = sel + this.getComfield() + this.getMulLocalField();
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_initbalance", (String)sel, (QFilter[])new QFilter[]{orgF, bookTypeF}, null);
        HashMap<Integer, Set> map = new HashMap<Integer, Set>();
        int assistSize = this.commonAssists.size();
        HashSet<Integer> hasMid = new HashSet<Integer>(2);
        for (int i = 1; i <= assistSize; ++i) {
            if (!CommonAssistUtil.hasMasteridProp((String)((CommonAssist)this.commonAssists.get((int)(i - 1))).valueSource)) continue;
            hasMid.add(i);
        }
        if (!hasMid.isEmpty()) {
            for (Row row : ds.copy()) {
                Iterator iterator = hasMid.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    Set ids = map.computeIfAbsent(i, x -> new HashSet());
                    ids.add(row.getLong("comassist" + i));
                }
            }
            Iterator iterator = hasMid.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String comField = "comassist" + i;
                DataSet comds = QueryServiceHelper.queryDataSet((String)"AbstractCalculator.reCalculate", (String)((CommonAssist)this.commonAssists.get((int)(i - 1))).valueSource, (String)("id " + comField + ",masterid"), (QFilter[])new QFilter[]{new QFilter("id", "in", map.get(i))}, null);
                List fields = GLUtil.getDataSetCols((DataSet)ds);
                int finalI = i;
                fields.removeIf(x -> x.equals("comassist" + finalI));
                ds = ds.join(comds, JoinType.LEFT).on(comField, comField).select(fields.toArray(new String[0]), new String[]{"masterid " + comField}).finish();
            }
        }
        return ds;
    }

    protected String getMulLocalField() {
        StringBuilder sb = new StringBuilder();
        this.localCurList.forEach(x -> sb.append(",").append(x.getOrmInitBalanceFields(new MCT[]{MCT.BEGIN_DEBIT, MCT.BEGIN_CREDIT, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT})));
        return sb.toString();
    }

    protected void doUpdate(DynamicObject book) {
        try (DataSet ds = this.getInitData(book);){
            long startPeriodId = book.getLong(GLField.id_((String)"startperiod"));
            ArrayList<Object> resultList = new ArrayList<Object>(10);
            int assistSize = this.commonAssists.size();
            BatchInitInfo batchInitInfo = new BatchInitInfo(assistSize, this.localCurList);
            RequestContext context = RequestContextCreator.createForThreadPool();
            context.setTraceId(RequestContext.get().getTraceId());
            AcctSumBatchInitInfo sumBal = new AcctSumBatchInitInfo(assistSize, this.localCurList);
            for (Row row : ds) {
                if (batchInitInfo.getInitBal().size() >= 10000) {
                    Future future = ThreadService.submit((Callable)new UpdateBalThread(batchInitInfo, book), (TaskType)TaskType.GL_CLOSE_INIT_UPDATE_BAL);
                    resultList.add(future);
                    batchInitInfo = new BatchInitInfo(assistSize, this.localCurList);
                }
                batchInitInfo.add(row, startPeriodId);
                sumBal.add(row, startPeriodId);
            }
            if (!batchInitInfo.getInitBal().isEmpty()) {
                Future future = ThreadService.submit((Callable)new UpdateBalThread(batchInitInfo, book), (TaskType)TaskType.GL_CLOSE_INIT_UPDATE_BAL);
                resultList.add(future);
            }
            for (Future future : resultList) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            AcctBalanceUpdate accBal = new AcctBalanceUpdate();
            accBal.update(sumBal, book);
        }
    }

    protected String getFormId() {
        return "gl_balance";
    }

    protected LockKey getLockKey() {
        return LockKey.BalanceCal;
    }
}

