/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin.closeinit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.closeinit.BatchInitInfo;
import kd.fi.gl.closeinit.InitBalInfo;
import kd.fi.gl.closeinit.InitBalKey;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.opplugin.closeinit.BalanceUpdate;
import kd.fi.gl.util.QFBuilder;

public class AcctBalanceUpdate
extends BalanceUpdate {
    @Override
    protected DataSet getBalData(BatchInitInfo batchInitInfo, DynamicObject book) {
        long org = book.getLong(GLField.id_((String)"org"));
        long bookType = book.getLong(GLField.id_((String)"bookstype"));
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("org", "=", (Object)org));
        qfBuilder.add(new QFilter("booktype", "=", (Object)bookType));
        qfBuilder.add(new QFilter("account", "in", batchInitInfo.getAccounts()));
        qfBuilder.add(new QFilter("currency", "in", batchInitInfo.getCurrencys()));
        qfBuilder.add(new QFilter("measureunit", "in", batchInitInfo.getMeasureunits()));
        Map<Integer, Set<Long>> comassist = batchInitInfo.getComassist();
        comassist.forEach((k, v) -> qfBuilder.add("comassist" + k, "in", v));
        StringBuilder orderBy = new StringBuilder("account,currency,measureunit");
        StringBuilder sel = new StringBuilder(this.getSelectField());
        for (int i = 1; i <= comassist.size(); ++i) {
            orderBy.append(",comassist").append(i);
            sel.append(",comassist").append(i);
        }
        this.localCur.forEach(x -> sel.append(",").append(x.getOrmBalanceFields(new MCT[]{MCT.BEGIN, MCT.DEBIT, MCT.CREDIT, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT, MCT.END})));
        orderBy.append(",endperiod");
        DataSet balSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.getEntityName(), (String)sel.toString(), (QFilter[])qfBuilder.toArray(), (String)orderBy.toString());
        return balSet;
    }

    String getSelectField() {
        return String.join((CharSequence)",", "id", "accounttable", "account", "currency", "measureunit", "period", "endperiod", "beginqty", "beginfor", "beginlocal", "debitqty", "debitfor", "debitlocal", "creditqty", "creditfor", "creditlocal", "yeardebitqty", "yeardebitfor", "yeardebitlocal", "yearcreditqty", "yearcreditfor", "yearcreditlocal", "endqty", "endfor", "endlocal", "count");
    }

    @Override
    protected DynamicObject newBalance(InitBalInfo initBalInfo, Long startPeriodId, Long endPeriodid) {
        BigDecimal beginQty = initBalInfo.getBeginqty();
        BigDecimal beginFor = initBalInfo.getBeginfor();
        BigDecimal beginLocal = initBalInfo.getBeginlocal();
        BigDecimal ydq = initBalInfo.getYeardebitqty();
        BigDecimal ydf = initBalInfo.getYeardebitfor();
        BigDecimal ydl = initBalInfo.getYeardebitlocal();
        BigDecimal ycq = initBalInfo.getYearcreditqty();
        BigDecimal ycf = initBalInfo.getYearcreditfor();
        BigDecimal ycl = initBalInfo.getYearcreditlocal();
        if (this.isZero(beginQty) && this.isZero(beginFor) && this.isZero(beginLocal) && this.isZero(ydq) && this.isZero(ydf) && this.isZero(ydl) && this.isZero(ycq) && this.isZero(ycf) && this.isZero(ycl)) {
            return null;
        }
        DynamicObject b = ORM.create().newDynamicObject("gl_acctbalance");
        b.set("period", (Object)startPeriodId);
        b.set("org", (Object)initBalInfo.getOrg());
        b.set("booktype", (Object)initBalInfo.getBookType());
        b.set("endperiod", (Object)endPeriodid);
        b.set("accounttable", (Object)initBalInfo.getAccounttable());
        b.set("account", (Object)initBalInfo.getAccount());
        b.set("measureunit", (Object)initBalInfo.getMeasureunit());
        b.set("currency", (Object)initBalInfo.getCurrency());
        b.set("beginqty", (Object)beginQty);
        b.set("beginfor", (Object)beginFor);
        b.set("beginlocal", (Object)beginLocal);
        b.set("endqty", (Object)beginQty);
        b.set("endfor", (Object)beginFor);
        b.set("endlocal", (Object)beginLocal);
        b.set("yeardebitqty", (Object)ydq);
        b.set("yeardebitfor", (Object)ydf);
        b.set("yeardebitlocal", (Object)ydl);
        b.set("yearcreditqty", (Object)ycq);
        b.set("yearcreditfor", (Object)ycf);
        b.set("yearcreditlocal", (Object)ycl);
        b.set("modifytime", (Object)new Date());
        List comassist = initBalInfo.getComassist();
        for (int i = 1; i <= comassist.size(); ++i) {
            b.set("comassist" + i, comassist.get(i - 1));
        }
        for (Map.Entry entry : initBalInfo.getMulCurBal().entrySet()) {
            b.set((String)entry.getKey(), entry.getValue());
        }
        return b;
    }

    @Override
    protected InitBalKey getKey(Row initBal, long orgId, long btId) {
        ArrayList<Long> comassist = new ArrayList<Long>(2);
        for (int i = 1; i <= this.comassistSize; ++i) {
            comassist.add(initBal.getLong("comassist" + i));
        }
        InitBalKey key = new InitBalKey(orgId, btId, initBal.getLong("accounttable").longValue(), initBal.getLong("account").longValue(), 0L, initBal.getLong("currency").longValue(), initBal.getLong("measureunit").longValue(), comassist);
        return key;
    }

    @Override
    protected String getTableName() {
        return "t_gl_acctbalance";
    }

    @Override
    protected String getEntityName() {
        return "gl_acctbalance";
    }
}

