/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.business.plugin.CodeRuleOp;
import kd.bos.business.plugin.UniqueBillno;
import kd.bos.cache.ThreadCache;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.BoolDataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.logger.ExtLogFactory;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.voucher.VoucherNumberUtils;
import kd.fi.gl.voucher.util.VoucherUtils;

public class VoucherCodeRuleOp
extends CodeRuleOp {
    private static final Log extLogger = ExtLogFactory.getLog(VoucherCodeRuleOp.class, (String)"VoucherCodeRuleOp:");
    private static final List<String> SKIP_DIRTY_KEYS = Collections.singletonList("billstatus");
    private Map<Long, Map<String, Object>> voucherStatusMap;
    private final Map<DynamicObject, Tuple<String, Boolean>> voucherDynOriBillNoChangedMap = new HashMap<DynamicObject, Tuple<String, Boolean>>(2);
    private boolean invokedById;

    public VoucherCodeRuleOp() {
        this.uniqueBillno = new VoucherUniqueBillNo();
        this.codeRuleService = new CodeRuleServiceImp(){

            public Function<DynamicObject, CodeRuleInfo> getCodeRuleInfoFun() {
                return VoucherCodeRuleOp.this::getCodeRuleInfo;
            }
        };
    }

    public void setContext(MainEntityType billEntityType, Map<String, Object> operateMeta, OperateOption option) {
        super.setContext(billEntityType, operateMeta, option);
        String operateKey = String.valueOf(operateMeta.get("key"));
        ((VoucherUniqueBillNo)this.uniqueBillno).setStatus("save".equalsIgnoreCase(operateKey) ? "A" : "B");
    }

    protected String getOperateKey() {
        return String.valueOf(this.operateMeta.get("key"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CodeRuleOpValidator(this));
        if (ArrayUtils.isEmpty((Object[])e.getDataEntities())) {
            this.invokedById = true;
            return;
        }
        DynamicProperty billNoProperty = e.getDataEntities()[0].getDynamicObjectType().getProperty("billno");
        for (DynamicObject voucherDyn : e.getDataEntities()) {
            boolean billNoChanged = ((BoolDataEntityState)voucherDyn.getDataEntityState()).getDirtyFlag().get(billNoProperty.getOrdinal());
            String oriBillNo = (String)billNoProperty.getValueFast((Object)voucherDyn);
            this.voucherDynOriBillNoChangedMap.put(voucherDyn, (Tuple<String, Boolean>)Tuple.create((Object)oriBillNo, (Object)billNoChanged));
        }
    }

    public void executeGenerate(DynamicObject[] voucherDynArray) {
        super.onAddValidators(new AddValidatorsEventArgs(voucherDynArray, new ArrayList(1)));
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        ThreadCache.remove((Object)"voucherLoopRepeatIds");
        ((VoucherUniqueBillNo)this.uniqueBillno).checker.usingCheckedNumbers = false;
        super.onReturnOperation(e);
        if (this.invokedById || e.getOperationResult().isSuccess()) {
            return;
        }
        List successPkIds = e.getOperationResult().getSuccessPkIds();
        DynamicProperty billNoProperty = this.voucherDynOriBillNoChangedMap.keySet().iterator().next().getDynamicObjectType().getProperty("billno");
        this.voucherDynOriBillNoChangedMap.forEach((voucherDyn, oriNumber) -> {
            if (!successPkIds.contains(voucherDyn.getPkValue())) {
                Tuple<String, Boolean> oriBillNoChangedTuple = this.voucherDynOriBillNoChangedMap.get(voucherDyn);
                billNoProperty.setValueFast(voucherDyn, oriBillNoChangedTuple.item1);
                voucherDyn.getDataEntityState().setBizChanged(billNoProperty.getOrdinal(), ((Boolean)oriBillNoChangedTuple.item2).booleanValue());
            }
        });
    }

    protected CodeRuleInfo getCodeRuleInfo(DynamicObject dynamicObject) {
        if ("save".equalsIgnoreCase(this.getOperateKey())) {
            return VoucherNumberUtils.getCodeRuleInfo((Long)dynamicObject.getLong("org.id"), (String)"A");
        }
        return VoucherNumberUtils.getCodeRuleInfoWithPriority((Long)dynamicObject.getLong("org.id"));
    }

    protected CodeRuleInfo checkCodeRule(String entityNum, List<CodeRuleInfo> codeRuleList, DynamicObject dynamicObject) {
        if ("save".equalsIgnoreCase(this.getOperateKey())) {
            return VoucherNumberUtils.getCodeRuleInfo((Long)dynamicObject.getLong("org.id"), (String)"A");
        }
        return VoucherNumberUtils.getCodeRuleInfoWithPriority((Long)dynamicObject.getLong("org.id"));
    }

    protected boolean validateRebuildNumberAtUpdate(DynamicObject voucherDyn, BillEntityType billEntityType, CodeRuleInfo codeRuleInfo) {
        String status;
        extLogger.info("validateRebuildNumberAtUpdate is called.");
        String string = status = this.getVoucherStatusMap().get(voucherDyn.getLong("id")) != null ? (String)this.getVoucherStatusMap().get(voucherDyn.getLong("id")).get("billstatus") : null;
        if ("A".equals(status) && VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)codeRuleInfo)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)voucherDyn.getString("billno"))) {
            extLogger.warn("Blank number, regenerate=true, voucherId = {}", voucherDyn.getPkValue());
            return true;
        }
        return super.validateRebuildNumberAtUpdate(voucherDyn, billEntityType, codeRuleInfo);
    }

    protected List<String> getSkipPropKeysForDirtyCheck() {
        return SKIP_DIRTY_KEYS;
    }

    protected boolean isOpenForOnlyNumber(String billNoFldKey, CodeRuleInfo codeRuleInfo, DynamicObject dynamicObject) {
        extLogger.info("isOpenForOnlyNumber is called.");
        return VoucherNumberUtils.isCheckUnique((CodeRuleInfo)codeRuleInfo);
    }

    protected boolean validateUniqueNumber(List<DynamicObject> generateNumberDy) {
        extLogger.info("validateUniqueNumber is called.");
        return true;
    }

    protected QFilter[] getQFilterExistsUniqueBillNo(String billNoFldKey, LinkedHashMap<String, DynamicObject> voucherDynMap) {
        extLogger.info("getQFilterExistsUniqueBillNo is called.");
        return null;
    }

    protected QFilter[] getQFilterExistUniqueBillNo(String billNoFldKey, String number, DynamicObject voucherDyn) {
        extLogger.info("getQFilterExistUniqueBillNo is called.");
        ((VoucherUniqueBillNo)this.uniqueBillno).currentCheckVoucherId = voucherDyn.getLong("id");
        ((VoucherUniqueBillNo)this.uniqueBillno).currentCheckNumber = number;
        CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo(voucherDyn);
        if (VoucherNumberUtils.isCheckUnique((CodeRuleInfo)codeRuleInfo)) {
            Set enhancedSortItems = VoucherNumberUtils.getEnhancedSortItems((CodeRuleInfo)codeRuleInfo);
            JSONObject groupByInfos = VoucherNumberUtils.getGroupByInfos((DynamicObject)voucherDyn, (Set)enhancedSortItems);
            ((VoucherUniqueBillNo)this.uniqueBillno).curremtCheckNumberBasis = groupByInfos;
            QFBuilder qfBuilder = VoucherNumberUtils.transJsonToQFBuilder((JSONObject)groupByInfos);
            qfBuilder.add("billno", "=", (Object)number);
            if (VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)codeRuleInfo)) {
                qfBuilder.add("billstatus", "in", (Object)new Object[]{"B", "C", "D"});
            }
            return qfBuilder.toArray();
        }
        return QFilterBuilder.getVoidFilter().toArray();
    }

    public void generateNumber(DynamicObject[] dynamicObjects) {
        extLogger.info("generateNumber is called");
        if (this.invokedById) {
            super.signResourceFromList();
        }
        super.generateNumber(dynamicObjects);
        VoucherUniqueBillNo voucherUniqueBillNo = (VoucherUniqueBillNo)this.uniqueBillno;
        if (voucherUniqueBillNo.isLastVoucherRepeat) {
            voucherUniqueBillNo.repeatVoucherIds.add(voucherUniqueBillNo.lastCheckVoucherId);
        }
        if (CollectionUtils.isNotEmpty((Collection)voucherUniqueBillNo.lastBatchRepeatVoucherIds)) {
            voucherUniqueBillNo.repeatVoucherIds.addAll(voucherUniqueBillNo.lastBatchRepeatVoucherIds);
        }
        ThreadCache.put((Object)"voucherLoopRepeatIds", voucherUniqueBillNo.repeatVoucherIds.stream().filter(x -> x >= 0L).collect(Collectors.toSet()));
    }

    protected boolean validateOperateKey() {
        extLogger.info("validateOperateKey is called");
        return true;
    }

    private Map<Long, Map<String, Object>> getVoucherStatusMap() {
        if (this.voucherStatusMap == null) {
            this.voucherStatusMap = (Map)ThreadCache.get((Object)"voucherInfoMap");
        }
        return this.voucherStatusMap;
    }

    static class UniquenessChecker {
        private final Map<JSONObject, Set<String>> checkedNumbers = new HashMap<JSONObject, Set<String>>(4);
        private boolean usingCheckedNumbers = true;

        private UniquenessChecker() {
        }

        private Set<Long> getRepeatedVoucherIds(Collection<DynamicObject> vouchers, String status) {
            return VoucherNumberUtils.groupByCodeRule(vouchers, (String)status).entrySet().stream().flatMap(entry -> VoucherNumberUtils.collectUsedNumbersAndCheckUnique((VoucherNumberUtils.CodeRuleGroupKey)((VoucherNumberUtils.CodeRuleGroupKey)entry.getKey()), (Collection)((Collection)entry.getValue()), this.getCheckedNumbersOnBasis(((VoucherNumberUtils.CodeRuleGroupKey)entry.getKey()).getGourpInfo())).stream()).map(v -> v.getLong("id")).collect(Collectors.toSet());
        }

        private boolean isRepeat(QFilter[] filters, JSONObject basis, String number) {
            if (StringUtils.isNotBlank((CharSequence)number) && basis != null) {
                Set<String> checkedNumbersOnBasis = this.getCheckedNumbersOnBasis(basis);
                if (checkedNumbersOnBasis.contains(number)) {
                    return true;
                }
                checkedNumbersOnBasis.add(number);
            }
            return VoucherQueryUtils.exists((QFilter[])filters);
        }

        private Set<String> getCheckedNumbersOnBasis(JSONObject basis) {
            if (this.usingCheckedNumbers) {
                return this.checkedNumbers.computeIfAbsent(basis, k -> new HashSet(8));
            }
            return new HashSet<String>(8);
        }
    }

    private static class CodeRuleOpValidator
    extends AbstractValidator {
        private final VoucherCodeRuleOp codeRuleOp;

        public CodeRuleOpValidator(VoucherCodeRuleOp codeRuleOp) {
            this.codeRuleOp = codeRuleOp;
        }

        public void validate() {
            ThreadCache.put((Object)"voucherInfoMap", (Object)VoucherUtils.getVchInfoFromDB((ExtendedDataEntity[])this.dataEntities));
            DynamicObject[] voucherDynArray = (DynamicObject[])Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
            this.codeRuleOp.executeGenerate(voucherDynArray);
        }

        public ValidatePriority getValidatePriority() {
            return ValidatePriority.First;
        }

        public int getSeq() {
            return Integer.MIN_VALUE;
        }
    }

    private static class VoucherUniqueBillNo
    extends UniqueBillno {
        private String status;
        private final UniquenessChecker checker = new UniquenessChecker();
        private final Set<Long> repeatVoucherIds = new HashSet<Long>(16);
        private Set<Long> lastBatchRepeatVoucherIds;
        private long currentCheckVoucherId = -1L;
        private long lastCheckVoucherId = -1L;
        private boolean isLastVoucherRepeat = true;
        private String currentCheckNumber = null;
        private JSONObject curremtCheckNumberBasis = null;

        private VoucherUniqueBillNo() {
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Map<String, DynamicObject> checkRepeatDateInDB(String entityNum, String billNoKey, Map<String, DynamicObject> voucherNoDynMap, QFilter[] qFilters) {
            Set repeatVoucherIds;
            extLogger.info("checkRepeatDateInDB is called.");
            Collection<DynamicObject> vouchers = voucherNoDynMap.values();
            this.lastBatchRepeatVoucherIds = repeatVoucherIds = this.checker.getRepeatedVoucherIds(vouchers, this.getStatus());
            return vouchers.stream().filter(v -> repeatVoucherIds.contains(v.getLong("id"))).collect(Collectors.toMap(v -> v.getString("billno"), v -> v));
        }

        public boolean checkReatedInDB(String entityNum, QFilter[] qFilters) {
            extLogger.info("checkReatedInDB is called.");
            if (this.lastCheckVoucherId != -1L && this.lastCheckVoucherId != this.currentCheckVoucherId && this.isLastVoucherRepeat) {
                this.repeatVoucherIds.add(this.lastCheckVoucherId);
            }
            boolean result = this.checker.isRepeat(qFilters, this.curremtCheckNumberBasis, this.currentCheckNumber);
            this.lastCheckVoucherId = this.currentCheckVoucherId;
            this.isLastVoucherRepeat = result;
            return result;
        }
    }
}

