/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.opplugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.ext.fi.ai.v2.fah.service.impl.DapDelUpdDataServiceImpl;
import kd.bos.ext.fi.lock.IShareLock;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.DtxErrorCodeConstants;
import kd.bos.kdtx.sdk.exception.BeginDtxException;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.indexing.constant.CDCRecOperationTypeEnum;
import kd.fi.bd.indexing.integrator.CDCServiceGLIntegrator;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.business.service.voucher.writeoff.WriteOffService;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.reciprocal.ReciprocalUtils;
import kd.fi.gl.util.ImrVoucherUtil;
import kd.fi.gl.voucher.IVoucherService;
import kd.fi.gl.voucher.VoucherEntryRedundantService;
import kd.fi.gl.voucher.carryover.utils.BalanceCarryOverUtils;
import kd.fi.gl.voucher.dtxservice.VoucherIdsParam;
import kd.fi.gl.voucher.opplugin.AbstractVoucherServicePlugIn;
import kd.fi.gl.voucher.opplugin.VoucherMarkErrorUtil;
import kd.fi.gl.voucher.util.VoucherFieldKeyListProxy;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.ReverseVoucherSubmitValidator;
import kd.fi.gl.voucher.validate.VoucherSubmitDeficitValidator;
import kd.fi.gl.voucher.validate.VoucherSubmitValidator;

public class VoucherSubmitOp
extends AbstractVoucherServicePlugIn {
    private static final Log logger = LogFactory.getLog(VoucherSubmitOp.class);
    private static final List<String> ALL_PREPARE_PROPERTYS = ImmutableList.of((Object)"createtime", (Object)"modifytime", (Object)"posttime", (Object)"bookeddate", (Object)"bizdate", (Object)"auditdate", (Object)"creator", (Object)"submitter", (Object)"auditor", (Object)"cashier", (Object)"poster", (Object)"modifier", (Object[])new String[]{"attachment", "book", "booktype", "localcur", "creditlocamount", "debitlocamount", "errorstatus", "ischeck", "ispost", "isreverse", "mainstatus", "period", "sourcetype", "suppstatus", "sourcebill", "sourcebilltype", "sendnotice", "vouchertype", "vdescription", "againsttype"});
    private static final String CLOUD_ID = "fi";
    private static final String APP_ID = "gl";
    private final Map<String, IShareLock> locks = new HashMap<String, IShareLock>(1);
    private List<ValidationErrorInfo> errorInfos = new ArrayList<ValidationErrorInfo>(1);
    private String[] logicActions;

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(ALL_PREPARE_PROPERTYS);
        e.setFieldKeys(VoucherFieldKeyListProxy.getProxyInstance((List)e.getFieldKeys(), (MainEntityType)this.billEntityType));
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (this.getOption().containsVariable("isCfAdjust") && "true".equals(this.getOption().getVariableValue("isCfAdjust"))) {
            return;
        }
        e.getValidators().add(new VoucherSubmitValidator(this.locks));
        e.getValidators().add(new ReverseVoucherSubmitValidator());
        e.getValidators().add(new VoucherSubmitDeficitValidator(this.errorInfos));
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        if (!this.getOption().containsVariable("sysvoucher") && !this.errorInfos.isEmpty()) {
            ArrayList<Object> successPkValues = new ArrayList<Object>(this.errorInfos.size());
            for (OperateErrorInfo operateErrorInfo : e.getOperationResult().getAllErrorInfo()) {
                successPkValues.add(operateErrorInfo.getPkValue());
            }
            this.errorInfos.forEach(errorInfo -> {
                e.getOperationResult().addErrorInfo((OperateErrorInfo)errorInfo);
                if (!"0".equals(errorInfo.getPkValue().toString()) && !successPkValues.contains(errorInfo.getPkValue())) {
                    e.getOperationResult().getSuccessPkIds().add(errorInfo.getPkValue());
                }
            });
        }
        super.onReturnOperation(e);
        for (Map.Entry<String, IShareLock> lock : this.locks.entrySet()) {
            lock.getValue().release();
        }
    }

    @Override
    public IVoucherService getService(DynamicObject o) {
        IVoucherService i = o.getBoolean("isreverse") ? this.getServiceImpl("submitReverse") : this.getServiceImpl("submitStandrad");
        return i;
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.autoPost(dataEntities);
        VoucherMarkErrorUtil.touchStatusWhenSubmit((DynamicObject[])dataEntities);
    }

    private void autoPost(DynamicObject[] dataEntitys) {
        if (this.getOption().containsVariable("vchstatus")) {
            String status = this.getOption().getVariableValue("vchstatus");
            this.logicActions = "C".equalsIgnoreCase(status) ? new String[]{"submit", "audit"} : ("P".equalsIgnoreCase(status) ? new String[]{"submit", "audit", "post"} : new String[]{"submit"});
            for (DynamicObject dyn : dataEntitys) {
                if ("C".equalsIgnoreCase(status)) {
                    this.setAuditInfo(dyn);
                    this.clearCashInfo(dyn);
                    this.clearPostInfo(dyn);
                    continue;
                }
                if ("P".equalsIgnoreCase(status)) {
                    this.setAuditInfo(dyn);
                    this.setCheckInfo(dyn);
                    this.setPostInfo(dyn);
                    continue;
                }
                this.clearAuditInfo(dyn);
                this.clearPostInfo(dyn);
            }
        } else {
            for (DynamicObject dyn : dataEntitys) {
                this.clearAuditInfo(dyn);
                this.clearPostInfo(dyn);
            }
        }
    }

    private void setAuditInfo(DynamicObject dyn) {
        dyn.set("billstatus", (Object)"C");
        if (dyn.getDynamicObject("auditor") == null) {
            dyn.set("auditor", (Object)RequestContext.get().getCurrUserId());
            dyn.set(GLField.id_((String)"auditor"), (Object)RequestContext.get().getCurrUserId());
            dyn.set("auditdate", (Object)new Date());
        }
    }

    private void setCheckInfo(DynamicObject dyn) {
        if (dyn.getString("ischeck").equals("b")) {
            dyn.set("ischeck", (Object)"c");
            if (dyn.getDynamicObject("cashier") == null) {
                dyn.set("cashier", (Object)RequestContext.get().getCurrUserId());
                dyn.set(GLField.id_((String)"cashier"), (Object)RequestContext.get().getCurrUserId());
            }
        } else {
            this.clearCashInfo(dyn);
        }
    }

    private void setPostInfo(DynamicObject dyn) {
        dyn.set("ispost", (Object)true);
        if (dyn.getDynamicObject("poster") == null) {
            dyn.set("poster", (Object)RequestContext.get().getCurrUserId());
            dyn.set(GLField.id_((String)"poster"), (Object)RequestContext.get().getCurrUserId());
            dyn.set("posttime", (Object)new Date());
        }
    }

    private void clearAuditInfo(DynamicObject dyn) {
        dyn.set("auditor", null);
        dyn.set(GLField.id_((String)"auditor"), (Object)0L);
        dyn.set("auditdate", null);
    }

    private void clearPostInfo(DynamicObject dyn) {
        dyn.set("poster", null);
        dyn.set(GLField.id_((String)"poster"), (Object)0L);
        dyn.set("posttime", null);
    }

    private void clearCashInfo(DynamicObject dyn) {
        dyn.set("cashier", null);
        dyn.set(GLField.id_((String)"cashier"), (Object)0L);
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block7: {
            List periodChangedVouchers;
            Set partLoadAndPeriodVouchers;
            super.endOperationTransaction(e);
            List reverseVouchers = Arrays.stream(e.getDataEntities()).filter(x -> x.getBoolean("isreverse")).collect(Collectors.toList());
            WriteOffService.submit(reverseVouchers);
            if (Arrays.stream(e.getDataEntities()).anyMatch(dyn -> "c".equals(dyn.getString("sourcetype"))) && e.getDataEntities()[0].getDynamicObjectType().getProperties().get((Object)"entries") != null) {
                BalanceCarryOverUtils.writeLog((DynamicObject[])e.getDataEntities(), (OperateOption)this.getOption());
            }
            if (!(partLoadAndPeriodVouchers = VoucherEntryRedundantService.filterPartlyLoadVouchers(periodChangedVouchers = Arrays.stream(e.getDataEntities()).filter(VoucherEntryRedundantService.isChangedPeriod).collect(Collectors.toList()))).isEmpty()) {
                logger.info("voucher_partly_load_with_period_change id: {}, reinit entry period field.", partLoadAndPeriodVouchers.stream().map(x -> x.getLong("id")).collect(Collectors.toList()));
                VoucherEntryRedundantService.checkAndUpdateVoucherRedundantInfo((DynamicObject[])partLoadAndPeriodVouchers.toArray(new DynamicObject[0]));
            }
            CDCServiceGLIntegrator.getInstance().registerCDCChangedRecord(CDCRecOperationTypeEnum.Update, e.getDataEntities());
            try {
                if (DebugTrace.enable()) {
                    logger.info("VoucherSubmitOp_beginDtx_start.");
                }
                ECGlobalSession.begin((String)"submit_voucher", (DBRoute)DBRoute.of((String)CLOUD_ID), (boolean)true);
                ECGlobalSession.setAsync((boolean)true);
                if (DebugTrace.enable()) {
                    logger.info("VoucherSubmitOp_beginDtx_start done.");
                }
            }
            catch (Exception bde) {
                logger.error("VoucherSubmitOp_beginDtx_error: " + bde.getMessage(), (Throwable)bde);
                if (bde instanceof BeginDtxException && DtxErrorCodeConstants.NEST_DTX_ERROR.getErrorCode().equals(((BeginDtxException)bde).getErrorCode().getCode())) break block7;
                throw bde;
            }
        }
        if (!this.getOption().containsVariable("isdap")) {
            Lists.partition(Arrays.stream(e.getDataEntities()).filter(x -> "4".equals(x.get("sourcetype").toString())).collect(Collectors.toList()), (int)100).forEach(voucherList -> {
                Map<Long, String> ids = voucherList.stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x.getString("billno")));
                VoucherIdsParam voucherIdsParam = new VoucherIdsParam();
                voucherIdsParam.setVchID2BillNo(ids);
                if (DebugTrace.enable()) {
                    logger.info("begin to execute DtxVoucherSubmitService on: " + ids);
                }
                ArrayList<Object[]> dapVoucherParams = new ArrayList<Object[]>(voucherList.size());
                for (DynamicObject dataEntitie : voucherList) {
                    dapVoucherParams.add(new Object[]{dataEntitie.getLong("period.id"), dataEntitie.getDate("bookeddate"), dataEntitie.getDate("bizdate"), dataEntitie.getLong("id")});
                }
                DapDelUpdDataServiceImpl dapDelUpdDataService = new DapDelUpdDataServiceImpl();
                dapDelUpdDataService.updateBizVchAndTrackerByVchId(dapVoucherParams);
                ECGlobalSession.register((String)CLOUD_ID, (String)APP_ID, (String)"DtxVoucherSubmitService", (Param)voucherIdsParam);
            });
        }
        ImrVoucherUtil.insertIsomerismRelation((OperateOption)this.getOption(), (DynamicObject[])e.getDataEntities());
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        boolean isreverse;
        super.afterExecuteOperationTransaction(e);
        if (e.getDataEntities().length > 0 && (isreverse = e.getDataEntities()[0].getBoolean("isreverse"))) {
            this.reverseVchAutoWriteOff(e.getDataEntities());
        }
        long startTime = System.currentTimeMillis();
        Set vchIdSet = Arrays.stream(e.getDataEntities()).map(x -> x.getLong("id")).collect(Collectors.toSet());
        VoucherUtils.doWriteOffByBizNum(vchIdSet);
        logger.info("VoucherSubmitOp_doWriteOffByBizNum:{}", (Object)(System.currentTimeMillis() - startTime));
        CDCServiceGLIntegrator.getInstance().raiseCDCEvent(CDCRecOperationTypeEnum.Update, e.getDataEntities());
    }

    private void reverseVchAutoWriteOff(DynamicObject[] dataEntities) {
        List vchIds = Arrays.stream(dataEntities).map(v -> v.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("targentity", "in", vchIds);
        try (DataSet reverDs = QueryServiceHelper.queryDataSet((String)ReciprocalUtils.class.getName(), (String)"gl_reverserelation", (String)"srcentity", (QFilter[])filter.toArray(), null);){
            while (reverDs.hasNext()) {
                vchIds.add(reverDs.next().getLong("srcentity"));
            }
        }
        HashSet<Long> accCurIds = new HashSet<Long>(vchIds.size());
        ArrayList<Long> acctIds = new ArrayList<Long>(vchIds.size());
        ArrayList<Long> acctMasterIds = new ArrayList<Long>(vchIds.size());
        Long orgId = 0L;
        Long bookTypeId = 0L;
        Long accountTableId = 0L;
        filter = new QFilter("voucherid", "in", vchIds);
        filter.and(new QFilter("status", "!=", (Object)"2"));
        try (DataSet reverDs = QueryServiceHelper.queryDataSet((String)ReciprocalUtils.class.getName(), (String)"gl_acccurrent", (String)"id,org,booktype,accounttable,account.id,account.masterid", (QFilter[])filter.toArray(), null);){
            while (reverDs.hasNext()) {
                Row next = reverDs.next();
                accCurIds.add(next.getLong("id"));
                acctIds.add(next.getLong("account.id"));
                acctMasterIds.add(next.getLong("account.masterid"));
                if (orgId != 0L) continue;
                orgId = next.getLong("org");
                bookTypeId = next.getLong("booktype");
                accountTableId = next.getLong("accounttable");
            }
        }
        if (orgId != 0L && bookTypeId != 0L) {
            ReciprocalUtils.preciseWriteOff((Long)orgId, (Long)bookTypeId, (Long)accountTableId, acctMasterIds, acctIds, accCurIds);
        }
    }

    @Override
    protected String[] getLogicVoucherActions() {
        return this.logicActions == null ? super.getLogicVoucherActions() : this.logicActions;
    }

    @Override
    protected String getVoucherAction() {
        return "submit";
    }
}

