/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.acccurrentfloat.matchdata;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.acccurrentfloat.constant.AcccurrentFormula;
import kd.fi.gl.acccurrentfloat.formater.AccountNumIDParam;
import kd.fi.gl.acccurrentfloat.formater.AccountNumberIDFormater;
import kd.fi.gl.acccurrentfloat.matchdata.AcctCurrencyKey;
import kd.fi.gl.acccurrentfloat.matchdata.AgeAmountVO;
import kd.fi.gl.acccurrentfloat.matchdata.AgeDimensionGroup;
import kd.fi.gl.acccurrentfloat.matchdata.FlexToValMatch;
import kd.fi.gl.acccurrentfloat.matchdata.IFlexToValMatch;
import kd.fi.gl.acccurrentfloat.matchdata.SmallMemoryFlexToValMatch;

public class AgeFormulaBuildMap {
    private static final Log log = LogFactory.getLog(AgeFormulaBuildMap.class);
    private AccountNumIDParam numIDParam;
    private static final String BASECURRENCY = "basecurrency";
    private Map<String, Long> currencyNumberToIdsMap;
    private List<AcccurrentFormula> formulas;
    private List<String> flexIndexs = new ArrayList<String>(8);
    private Set<String> floatFlexSet = new HashSet<String>(8);
    private Map<String, Map<Object, Set<String>>> floatFlexToValToNumbersMap = new HashMap<String, Map<Object, Set<String>>>(8);
    Map<AcctCurrencyKey, Set<AcccurrentFormula>> accountCurrencyMap = new HashMap<AcctCurrencyKey, Set<AcccurrentFormula>>(1024);
    private static final String ACCTAGELOG = "ACCTAGE AgeFormulaBuildMap WATCH LOG: ";

    public AgeFormulaBuildMap(Map<String, Long> currencyNumberToIdsMap, List<AcccurrentFormula> formulas, AccountNumIDParam numIDParam) {
        this.numIDParam = numIDParam;
        this.formulas = formulas;
        this.currencyNumberToIdsMap = currencyNumberToIdsMap;
        this.initFlexAccountCurrencyParam();
    }

    public Map<String, Map<String, Object>> getResultMap(DataSet records) {
        IFlexToValMatch flexToValMatch;
        PerformanceWatch watch_Parse = new PerformanceWatch(AgeFormulaBuildMap.class, "getResultMap", false);
        watch_Parse.start("ACCTAGE AgeFormulaBuildMap WATCH LOG: getResultMap start");
        List<String> orderList = this.getOrderByList();
        records = records.orderBy(orderList.toArray(new String[orderList.size()]));
        boolean isBaseCurrency = false;
        boolean isSingeCurrency = false;
        boolean isIncludeBizDateField = false;
        boolean isIncludeExpireDateField = false;
        for (AcccurrentFormula formula : this.formulas) {
            Object currencyNumber;
            boolean formulaIsBaseCurrency;
            if (!isIncludeExpireDateField && formula.isCaculatebyExpireDate()) {
                isIncludeExpireDateField = true;
            }
            if (!isIncludeBizDateField && !formula.isCaculatebyExpireDate()) {
                isIncludeBizDateField = true;
            }
            boolean bl = formulaIsBaseCurrency = StringUtils.isBlank((CharSequence)(currencyNumber = formula.getCurrencyNumber())) || BASECURRENCY.equals(currencyNumber);
            if (!isBaseCurrency && formulaIsBaseCurrency) {
                isBaseCurrency = true;
            }
            if (isSingeCurrency || formulaIsBaseCurrency) continue;
            isSingeCurrency = true;
        }
        watch_Parse.stop();
        watch_Parse.start("ACCTAGE AgeFormulaBuildMap WATCH LOG: FlexToValMatch");
        if (BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.acctage.float.small.memory", (boolean)false)) {
            flexToValMatch = new SmallMemoryFlexToValMatch(this.numIDParam.getFloatFlexValsMap(), this.formulas);
            log.info("ACCTAGE AgeFormulaBuildMap WATCH LOG: excuse SmallMemoryFlexToValMatch");
        } else {
            flexToValMatch = new FlexToValMatch(this.numIDParam.getFloatFlexValsMap(), this.formulas);
            log.info("ACCTAGE AgeFormulaBuildMap WATCH LOG: excuse FlexToValMatch");
        }
        watch_Parse.stop();
        watch_Parse.start("ACCTAGE AgeFormulaBuildMap WATCH LOG: records match formula");
        AgeDimensionGroup lastGroup = null;
        for (Row row : records) {
            long accountId = row.getLong("accountid");
            long currencyId = row.getLong("currencyfor");
            HashMap<String, Object> curRowFlexToValMap = new HashMap<String, Object>(8);
            for (String flex : this.flexIndexs) {
                curRowFlexToValMap.put(flex, row.get(flex));
            }
            AgeAmountVO amountVO = new AgeAmountVO(row.getBigDecimal("amountbal"), row.getBigDecimal("amountbalfor"));
            if (null != lastGroup && lastGroup.isDimensionEquals(accountId, currencyId, curRowFlexToValMap)) {
                if (isIncludeBizDateField) {
                    lastGroup.putBizDateAmount(row.getDate("bizDate"), amountVO);
                }
                if (!isIncludeExpireDateField) continue;
                lastGroup.putExpireDateAmount(row.getDate("expiredate"), amountVO);
                continue;
            }
            if (null != lastGroup) {
                this.dealRecordRow(isBaseCurrency, isSingeCurrency, flexToValMatch, lastGroup);
            }
            lastGroup = new AgeDimensionGroup(curRowFlexToValMap, accountId, currencyId);
            if (isIncludeBizDateField) {
                lastGroup.putBizDateAmount(row.getDate("bizDate"), amountVO);
            }
            if (!isIncludeExpireDateField) continue;
            lastGroup.putExpireDateAmount(row.getDate("expiredate"), amountVO);
        }
        if (lastGroup != null) {
            this.dealRecordRow(isBaseCurrency, isSingeCurrency, flexToValMatch, lastGroup);
        }
        watch_Parse.stop();
        watch_Parse.start("ACCTAGE AgeFormulaBuildMap WATCH LOG: getFormulaAmount");
        Map<String, Map<String, Object>> resultMap = this.getFormulaAmount();
        watch_Parse.stop();
        log.info(watch_Parse.show());
        return resultMap;
    }

    private void dealRecordRow(boolean isBaseCurrency, boolean isSingeCurrency, IFlexToValMatch flexToValMatch, AgeDimensionGroup group) {
        AcctCurrencyKey acctCurrencyKey;
        Set<AcccurrentFormula> acctCurrencyFormulas;
        AcctCurrencyKey acctBaseCurrencyKey;
        Set<AcccurrentFormula> acctBaseCurrencyFormulas;
        long lastAccountId = group.getAccountId();
        long lastCurrencyId = group.getCurrencyId();
        HashSet<AcccurrentFormula> acctCurrencyMatchFormulas = new HashSet<AcccurrentFormula>(8);
        if (isBaseCurrency && (acctBaseCurrencyFormulas = this.accountCurrencyMap.get(acctBaseCurrencyKey = new AcctCurrencyKey(lastAccountId, null))) != null) {
            acctCurrencyMatchFormulas.addAll(acctBaseCurrencyFormulas);
        }
        if (isSingeCurrency && (acctCurrencyFormulas = this.accountCurrencyMap.get(acctCurrencyKey = new AcctCurrencyKey(lastAccountId, Long.valueOf(lastCurrencyId)))) != null) {
            acctCurrencyMatchFormulas.addAll(acctCurrencyFormulas);
        }
        Set<AcccurrentFormula> flexValMatchFormulas = flexToValMatch.matchFlexValFormula(group.getFlexToValMap());
        acctCurrencyMatchFormulas.retainAll(flexValMatchFormulas);
        HashSet<AcccurrentFormula> matchFormulas = acctCurrencyMatchFormulas;
        if (matchFormulas.isEmpty()) {
            return;
        }
        HashMap<String, Set<String>> curRowFlexToNumberMap = new HashMap<String, Set<String>>(4);
        for (String floatFlex : this.floatFlexSet) {
            Object objVal = group.getFlexToValMap().get(floatFlex);
            Set<String> numbers = this.floatFlexToValToNumbersMap.get(floatFlex).get(objVal);
            curRowFlexToNumberMap.put(floatFlex, numbers);
        }
        for (AcccurrentFormula formula : matchFormulas) {
            Range ageRange = formula.getAgeRange();
            if (ageRange == null) continue;
            AgeAmountVO sumAmountVO = formula.isCaculatebyExpireDate() ? group.sumUpExpireDateRange((Date)ageRange.lowerEndpoint(), (Date)ageRange.upperEndpoint()) : group.sumUpBizDateRange((Date)ageRange.lowerEndpoint(), (Date)ageRange.upperEndpoint());
            formula.add(formula.isLocalCurrency() ? sumAmountVO.getAmountBal() : sumAmountVO.getAmountBalFor(), curRowFlexToNumberMap);
        }
    }

    private List<String> getOrderByList() {
        ArrayList<String> orderBy = new ArrayList<String>(8);
        orderBy.add("accountid");
        orderBy.add("currencyfor");
        orderBy.addAll(this.flexIndexs);
        return orderBy;
    }

    private Map<String, Map<String, Object>> getFormulaAmount() {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(1024);
        for (AcccurrentFormula formula : this.formulas) {
            HashMap<String, Object> acctValueMap = new HashMap<String, Object>(8);
            if (StringUtils.isBlank((CharSequence)formula.getErrorMsg())) {
                acctValueMap.put("v", formula.getFormulaAmount());
                acctValueMap.put("success", true);
                acctValueMap.put("failmsg", null);
            } else {
                acctValueMap.put("v", null);
                acctValueMap.put("success", false);
                acctValueMap.put("failmsg", formula.getErrorMsg());
            }
            resultMap.put(formula.getKey(), acctValueMap);
        }
        return resultMap;
    }

    private void initAccountCurrencyParam(AcccurrentFormula formula) {
        Long currencyId = this.initCurrency(formula);
        Set<Long> allLeafAcctIds = this.getAllLeafAccountIds(formula);
        for (long accountId : allLeafAcctIds) {
            AcctCurrencyKey acctCurrencyKey = new AcctCurrencyKey(accountId, currencyId);
            Set formulaSet = this.accountCurrencyMap.computeIfAbsent(acctCurrencyKey, x -> new HashSet(8));
            formulaSet.add(formula);
        }
    }

    private Set<Long> getAllLeafAccountIds(AcccurrentFormula formula) {
        HashSet<Long> allLeafAcctIds = new HashSet<Long>(64);
        Set accountIds = formula.getAccountIds();
        Iterator iterator = accountIds.iterator();
        while (iterator.hasNext()) {
            long accountId = (Long)iterator.next();
            allLeafAcctIds.addAll(this.numIDParam.getAllLeafAccounts(Long.valueOf(accountId)));
        }
        return allLeafAcctIds;
    }

    private Long initCurrency(AcccurrentFormula formula) {
        String currencyNum = formula.getCurrencyNumber();
        if (BASECURRENCY.equals(currencyNum) || StringUtils.isEmpty((CharSequence)currencyNum)) {
            return null;
        }
        Long currencyId = this.currencyNumberToIdsMap.get(currencyNum) == null ? Long.valueOf(0L) : this.currencyNumberToIdsMap.get(currencyNum);
        return currencyId;
    }

    private void initFlexAccountCurrencyParam() {
        HashSet formulaFlexs = new HashSet(8);
        for (AcccurrentFormula formula : this.formulas) {
            Tuple acctToAssistTuple = AccountNumberIDFormater.parseAcctAssistList((String)formula.getAcctAssistListStr(), (AccountNumIDParam)this.numIDParam, (String)formula.getKey());
            if (((Set)acctToAssistTuple.item1).isEmpty()) {
                formula.setErrorMsg(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u7684\u79d1\u76ee\u6ca1\u6709\u5206\u914d\u6743\u9650\u3002", (String)"BCMBalanceParamParseUtils_7", (String)"fi-gl-mservice", (Object[])new Object[0]), new Object[0]));
                continue;
            }
            formula.setAccountIds((Set)acctToAssistTuple.item1);
            ArrayList<String> floatFlexList = new ArrayList<String>(8);
            List floatAssistNumberList = formula.getFloatAssistNumbers();
            Map assistToFlexMap = this.numIDParam.getAssistToFlexMap();
            for (String floatAssistNumber : floatAssistNumberList) {
                String flex = (String)assistToFlexMap.get(floatAssistNumber);
                floatFlexList.add(flex);
            }
            formula.setFloatFlexList(floatFlexList);
            this.floatFlexSet.addAll(floatFlexList);
            ArrayList<String> nonFloatFlexList = new ArrayList<String>(8);
            List nonFloatAssistNumberList = formula.getNonFloatAssistNumbers();
            for (String nonFloatAssistNumber : nonFloatAssistNumberList) {
                String flex = (String)assistToFlexMap.get(nonFloatAssistNumber);
                nonFloatFlexList.add(flex);
            }
            Map<String, Set> nonFloatMap = ((Map)acctToAssistTuple.item2).entrySet().stream().filter(x -> nonFloatFlexList.contains(x.getKey())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (Set)x.getValue()));
            formula.setNonFloatAssgrpMap(nonFloatMap);
            this.initAccountCurrencyParam(formula);
            formulaFlexs.addAll(floatFlexList);
            formulaFlexs.addAll(nonFloatFlexList);
        }
        this.flexIndexs.addAll(formulaFlexs);
        this.initFloatFlexToValToNumbersMap();
    }

    private void initFloatFlexToValToNumbersMap() {
        Map floatFlexValsMap = this.numIDParam.getFloatFlexValsMap();
        for (String floatFlex : this.floatFlexSet) {
            Map numberToObjsMap = (Map)floatFlexValsMap.get(floatFlex);
            HashMap<Object, Set> objToNumbersMap = new HashMap<Object, Set>(1024);
            for (Map.Entry entry : numberToObjsMap.entrySet()) {
                Set objs = (Set)entry.getValue();
                String number = (String)entry.getKey();
                for (Object obj : objs) {
                    Set numbers = objToNumbersMap.computeIfAbsent(obj, x -> new HashSet(4));
                    numbers.add(number);
                }
            }
            this.floatFlexToValToNumbersMap.put(floatFlex, objToNumbersMap);
        }
    }
}

