/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.balcal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.business.vo.MetaField;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.balcal.AcctBalanceLog;
import kd.fi.gl.balcal.BalanceCalculator;
import kd.fi.gl.balcal.BalanceData;
import kd.fi.gl.balcal.BalanceKey;
import kd.fi.gl.balcal.BalanceLog;
import kd.fi.gl.balcal.Key;
import kd.fi.gl.balcal.Log;
import kd.fi.gl.balcal.LogList;
import kd.fi.gl.balcal.Params;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.GLUtil;

public class AcctBalanceCalculator
extends BalanceCalculator {
    private static final int SIZE = 200;

    public void reCalculateAcct(long orgId, long booktypeId, long periodId) {
        this.initComassist(orgId, booktypeId);
        this.initMulLocalCurrency(orgId, booktypeId);
        DataSet dataSet = this.queryDetailBalance(orgId, booktypeId, periodId);
        LogList logList = new LogList();
        QFilter forg = new QFilter("org", "=", (Object)orgId);
        QFilter fbt = new QFilter("bookstype", "=", (Object)booktypeId);
        DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"startperiod", (QFilter[])new QFilter[]{forg, fbt});
        long startPeriodId = book.getLong("startperiod");
        List sumBalPids = PeriodUtil.getAcctBalEndPeriodIds((String)">=", (Long)periodId, (Long[])new Long[]{orgId});
        for (Row row : dataSet) {
            BalanceKey key = this.getPK(row);
            if (logList.size() > 200) {
                this.updateBalance(orgId, booktypeId, periodId, (LogList<BalanceKey>)logList, sumBalPids, startPeriodId);
            }
            logList.add((Key)key, (Log)this.getLogData(row));
        }
        if (!logList.isEmpty()) {
            this.updateBalance(orgId, booktypeId, periodId, (LogList<BalanceKey>)logList, sumBalPids, startPeriodId);
        }
    }

    protected AcctBalanceLog getLogData(Row rs) {
        AcctBalanceLog log = new AcctBalanceLog();
        log.setBeginFor(rs.getBigDecimal("fbeginfor"));
        log.setBeginLocal(rs.getBigDecimal("fbeginlocal"));
        log.setBeginQty(rs.getBigDecimal("fbeginqty"));
        log.setDebitFor(rs.getBigDecimal("fdebitfor"));
        log.setCreditFor(rs.getBigDecimal("fcreditfor"));
        log.setDebitLocal(rs.getBigDecimal("fdebitlocal"));
        log.setCreditLocal(rs.getBigDecimal("fcreditlocal"));
        log.setDebitQty(rs.getBigDecimal("fdebitqty"));
        log.setCreditQty(rs.getBigDecimal("fcreditqty"));
        log.setYearDebitFor(rs.getBigDecimal("fyeardebitfor"));
        log.setYearDebitLocal(rs.getBigDecimal("fyeardebitlocal"));
        log.setYearDebitQty(rs.getBigDecimal("fyeardebitqty"));
        log.setYearCreditFor(rs.getBigDecimal("fyearcreditfor"));
        log.setYearCreditLocal(rs.getBigDecimal("fyearcreditlocal"));
        log.setYearCreditQty(rs.getBigDecimal("fyearcreditqty"));
        log.setEndFor(rs.getBigDecimal("fendfor"));
        log.setEndLocal(rs.getBigDecimal("fendlocal"));
        log.setEndQty(rs.getBigDecimal("fendqty"));
        log.setCount(rs.getInteger("fcount"));
        this.localCurList.forEach(x -> {
            Collection fields = x.getBalanceFields(new MCT[]{MCT.DEBIT, MCT.CREDIT, MCT.BEGIN, MCT.END, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT});
            fields.forEach(field -> log.putMulLocalAmt((MetaField)field, rs.getBigDecimal(field.getDbId())));
        });
        return log;
    }

    protected List<BigDecimal> getUpdateBalAmtParam(long periodId, BalanceLog logData, BalanceData bal, BalanceData preBal, boolean reCal, long startPeriodId) {
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        AcctBalanceLog acctBalanceLog = (AcctBalanceLog)logData;
        if (reCal) {
            param.add(preBal == null ? acctBalanceLog.getBeginFor() : preBal.getEndFor());
            param.add(preBal == null ? acctBalanceLog.getBeginLocal() : preBal.getEndLocal());
            param.add(preBal == null ? acctBalanceLog.getBeginQty() : preBal.getEndQty());
        }
        param.add(acctBalanceLog.getDebitFor());
        param.add(acctBalanceLog.getCreditFor());
        param.add(acctBalanceLog.getDebitLocal());
        param.add(acctBalanceLog.getCreditLocal());
        param.add(acctBalanceLog.getDebitQty());
        param.add(acctBalanceLog.getCreditQty());
        if (reCal && (preBal == null || periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L)) {
            if (preBal == null) {
                param.add(acctBalanceLog.getYearDebitFor());
                param.add(acctBalanceLog.getYearCreditFor());
                param.add(acctBalanceLog.getYearDebitLocal());
                param.add(acctBalanceLog.getYearCreditLocal());
                param.add(acctBalanceLog.getYearDebitQty());
                param.add(acctBalanceLog.getYearCreditQty());
            } else {
                param.add(preBal.getYearDebitFor().add(acctBalanceLog.getDebitFor()));
                param.add(preBal.getYearCreditFor().add(acctBalanceLog.getCreditFor()));
                param.add(preBal.getYearDebitLocal().add(acctBalanceLog.getDebitLocal()));
                param.add(preBal.getYearCreditLocal().add(acctBalanceLog.getCreditLocal()));
                param.add(preBal.getYearDebitQty().add(acctBalanceLog.getDebitQty()));
                param.add(preBal.getYearCreditQty().add(acctBalanceLog.getCreditQty()));
            }
        } else {
            param.add(acctBalanceLog.getDebitFor());
            param.add(acctBalanceLog.getCreditFor());
            param.add(acctBalanceLog.getDebitLocal());
            param.add(acctBalanceLog.getCreditLocal());
            param.add(acctBalanceLog.getDebitQty());
            param.add(acctBalanceLog.getCreditQty());
        }
        if (reCal) {
            param.add(((BigDecimal)param.get(0)).add(acctBalanceLog.getDebitFor()).subtract(acctBalanceLog.getCreditFor()));
            param.add(((BigDecimal)param.get(1)).add(acctBalanceLog.getDebitLocal()).subtract(acctBalanceLog.getCreditLocal()));
            param.add(((BigDecimal)param.get(2)).add(acctBalanceLog.getDebitQty()).subtract(acctBalanceLog.getCreditQty()));
        } else {
            param.add(acctBalanceLog.getDebitFor().subtract(acctBalanceLog.getCreditFor()));
            param.add(acctBalanceLog.getDebitLocal().subtract(acctBalanceLog.getCreditLocal()));
            param.add(acctBalanceLog.getDebitQty().subtract(acctBalanceLog.getCreditQty()));
        }
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            BigDecimal beginMulLocal = BigDecimal.ZERO;
            if (reCal) {
                beginMulLocal = preBal == null ? acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.BEGIN)) : preBal.getMulLoclAmt(localCur.getBalanceField(MCT.END));
                param.add(beginMulLocal);
            }
            param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.DEBIT)));
            param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.CREDIT)));
            if (reCal && (preBal == null || periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L)) {
                if (preBal == null) {
                    param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.DEBIT)));
                    param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.CREDIT)));
                } else {
                    param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_DEBIT)).add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.DEBIT))));
                    param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_CREDIT)).add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.CREDIT))));
                }
            } else {
                param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.DEBIT)));
                param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.CREDIT)));
            }
            if (reCal) {
                param.add(beginMulLocal.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.DEBIT))).subtract(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.CREDIT))));
                continue;
            }
            param.add(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.DEBIT)).subtract(acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.CREDIT))));
        }
        return param;
    }

    protected boolean isBalZero(BalanceData bal, BalanceLog logData) {
        AcctBalanceLog acctBal = (AcctBalanceLog)logData;
        BigDecimal[] fields = new BigDecimal[]{acctBal.getBeginFor(), acctBal.getBeginLocal(), acctBal.getBeginQty(), acctBal.getDebitFor(), acctBal.getDebitLocal(), acctBal.getDebitQty(), acctBal.getCreditFor(), acctBal.getCreditLocal(), acctBal.getCreditQty(), acctBal.getYearDebitFor(), acctBal.getYearDebitLocal(), acctBal.getYearDebitQty(), acctBal.getYearCreditFor(), acctBal.getYearCreditLocal(), acctBal.getYearCreditQty(), acctBal.getEndFor(), acctBal.getEndLocal(), acctBal.getEndQty()};
        boolean isZero = true;
        for (BigDecimal amt : fields) {
            if (BigDecimal.ZERO.compareTo(amt) == 0) continue;
            isZero = false;
            break;
        }
        if (isZero) {
            for (LocalCurrencyConfigVO locaCur : this.localCurList) {
                boolean mulLocalZero = acctBal.getMulLocalAmt(locaCur.getBalanceField(MCT.BEGIN)).compareTo(BigDecimal.ZERO) == 0 && acctBal.getMulLocalAmt(locaCur.getBalanceField(MCT.DEBIT)).compareTo(BigDecimal.ZERO) == 0 && acctBal.getMulLocalAmt(locaCur.getBalanceField(MCT.CREDIT)).compareTo(BigDecimal.ZERO) == 0 && acctBal.getMulLocalAmt(locaCur.getBalanceField(MCT.YEAR_DEBIT)).compareTo(BigDecimal.ZERO) == 0 && acctBal.getMulLocalAmt(locaCur.getBalanceField(MCT.YEAR_CREDIT)).compareTo(BigDecimal.ZERO) == 0 && acctBal.getMulLocalAmt(locaCur.getBalanceField(MCT.END)).compareTo(BigDecimal.ZERO) == 0;
                if (mulLocalZero) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void updateBalance(long orgId, long bookTypeId, long periodId, LogList<BalanceKey> logList, List<Long> periodIdList, long startPeriodId) {
        Map sumBalData = this.getBalanceData(orgId, bookTypeId, logList, periodIdList, true, this.getSumupTab());
        Params sumParams = new Params();
        this.buildBalParams(orgId, bookTypeId, periodId, logList, true, startPeriodId, sumBalData, sumParams, false);
        Map dataId2Log = this.getBalChangeLogger().getDataId2Log(this.getSumupTab(), sumBalData);
        try (TXHandle h = TX.requiresNew((String)(((Object)((Object)this)).getClass().getName() + "update"));){
            try {
                this.storeSumBalData(true, sumParams, dataId2Log);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                h.markRollback();
                throw e;
            }
        }
        logList.clear();
    }

    protected void recalDealNext(long periodId, BalanceLog logData, Iterator<BalanceData> balIt, Params params, BalanceData preBal, long curBalId, long preEndPeriodId) {
        if (!balIt.hasNext() && preEndPeriodId != GLUtil.MAX_PERIOD) {
            params.addUpdateEndPeriodParam(new Object[]{GLUtil.MAX_PERIOD, curBalId});
        }
        AcctBalanceLog acctBalanceLog = (AcctBalanceLog)logData;
        BigDecimal diffDebitfor = logData.getDebitFor().subtract(preBal.getDebitFor());
        BigDecimal diffDebitlocal = logData.getDebitLocal().subtract(preBal.getDebitLocal());
        BigDecimal diffDebitqty = logData.getDebitQty().subtract(preBal.getDebitQty());
        BigDecimal diffCreditfor = logData.getCreditFor().subtract(preBal.getCreditFor());
        BigDecimal diffCreditlocal = logData.getCreditLocal().subtract(preBal.getCreditLocal());
        BigDecimal diffCreditqty = logData.getCreditQty().subtract(preBal.getCreditQty());
        BigDecimal difffor = acctBalanceLog.getBeginFor().subtract(preBal.getBeginFor()).add(diffDebitfor).subtract(diffCreditfor);
        BigDecimal difflocal = acctBalanceLog.getBeginLocal().subtract(preBal.getBeginLocal()).add(diffDebitlocal).subtract(diffCreditlocal);
        BigDecimal diffqty = acctBalanceLog.getBeginQty().subtract(preBal.getBeginQty()).add(diffDebitqty).subtract(diffCreditqty);
        HashMap<String, BigDecimal> diff = new HashMap<String, BigDecimal>(this.localCurList.size());
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            BigDecimal difDebit = logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)).subtract(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.DEBIT)));
            BigDecimal difCredit = logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)).subtract(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.CREDIT)));
            diff.put(localCur.getBalanceField(MCT.BEGIN).getMetaId(), acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.BEGIN)).subtract(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.BEGIN))).add(difDebit).subtract(difCredit));
            diff.put(localCur.getBalanceField(MCT.DEBIT).getMetaId(), difDebit);
            diff.put(localCur.getBalanceField(MCT.CREDIT).getMetaId(), difCredit);
        }
        while (balIt.hasNext()) {
            BalanceData bal = balIt.next();
            long balId = bal.getId();
            ArrayList<Comparable<BigDecimal>> param = new ArrayList<Comparable<BigDecimal>>();
            param.add(difffor);
            param.add(difflocal);
            param.add(diffqty);
            param.add(difffor);
            param.add(difflocal);
            param.add(diffqty);
            if (periodId / GLUtil.YEAR_PERIOD_L == bal.getPeriodId() / GLUtil.YEAR_PERIOD_L) {
                param.add(diffDebitfor);
                param.add(diffCreditfor);
                param.add(diffDebitlocal);
                param.add(diffCreditlocal);
                param.add(diffDebitqty);
                param.add(diffCreditqty);
                this.localCurList.forEach(x -> {
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.DEBIT).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.CREDIT).getMetaId()));
                });
                param.add(DateUtils.now());
                param.add(Long.valueOf(balId));
                params.addUpdateCurrYBalParam(param.toArray());
            } else {
                this.localCurList.forEach(x -> {
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                    param.add((Comparable<BigDecimal>)diff.get(x.getBalanceField(MCT.BEGIN).getMetaId()));
                });
                param.add(DateUtils.now());
                param.add(Long.valueOf(balId));
                params.addUpdateLaterYBalParam(param.toArray());
            }
            if (bal.getPeriodId() != preEndPeriodId) {
                params.addUpdateEndPeriodParam(new Object[]{preEndPeriodId, curBalId});
            }
            curBalId = bal.getId();
            preEndPeriodId = bal.getEndPeriodId();
            if (balIt.hasNext() || bal.getEndPeriodId() == GLUtil.MAX_PERIOD.longValue()) continue;
            params.addUpdateEndPeriodParam(new Object[]{GLUtil.MAX_PERIOD, bal.getId()});
        }
    }

    protected List<BigDecimal> getNewBalAmtParam(BalanceKey pk, long periodId, BalanceLog logData, BalanceData preBal) {
        boolean hasPreAndSameYear;
        AcctBalanceLog acctBalanceLog = (AcctBalanceLog)logData;
        ArrayList<BigDecimal> param = new ArrayList<BigDecimal>(18);
        param.add(preBal == null ? acctBalanceLog.getBeginFor() : preBal.getEndFor());
        param.add(preBal == null ? acctBalanceLog.getBeginLocal() : preBal.getEndLocal());
        param.add(preBal == null ? acctBalanceLog.getBeginQty() : preBal.getEndQty());
        param.add(logData.getDebitFor());
        param.add(logData.getCreditFor());
        param.add(logData.getDebitLocal());
        param.add(logData.getCreditLocal());
        param.add(logData.getDebitQty());
        param.add(logData.getCreditQty());
        boolean bl = hasPreAndSameYear = preBal != null && periodId / GLUtil.YEAR_PERIOD_L == preBal.getPeriodId() / GLUtil.YEAR_PERIOD_L;
        if (hasPreAndSameYear) {
            param.add(preBal.getYearDebitFor().add(logData.getDebitFor()));
            param.add(preBal.getYearCreditFor().add(logData.getCreditFor()));
            param.add(preBal.getYearDebitLocal().add(logData.getDebitLocal()));
            param.add(preBal.getYearCreditLocal().add(logData.getCreditLocal()));
            param.add(preBal.getYearDebitQty().add(logData.getDebitQty()));
            param.add(preBal.getYearCreditQty().add(logData.getCreditQty()));
        } else {
            param.add(logData.getDebitFor());
            param.add(logData.getCreditFor());
            param.add(logData.getDebitLocal());
            param.add(logData.getCreditLocal());
            param.add(logData.getDebitQty());
            param.add(logData.getCreditQty());
        }
        BigDecimal endfor = acctBalanceLog.getBeginFor();
        BigDecimal endlocal = acctBalanceLog.getBeginLocal();
        BigDecimal endqty = acctBalanceLog.getBeginQty();
        if (preBal != null) {
            endfor = preBal.getEndFor();
            endlocal = preBal.getEndLocal();
            endqty = preBal.getEndQty();
        }
        param.add(endfor.add(logData.getDebitFor()).subtract(logData.getCreditFor()));
        param.add(endlocal.add(logData.getDebitLocal()).subtract(logData.getCreditLocal()));
        param.add(endqty.add(logData.getDebitQty()).subtract(logData.getCreditQty()));
        for (LocalCurrencyConfigVO localCur : this.localCurList) {
            param.add(preBal == null ? acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.BEGIN)) : preBal.getMulLoclAmt(localCur.getBalanceField(MCT.END)));
            param.add(logData.getMulLocalAmt(localCur.getBalanceField(MCT.DEBIT)));
            param.add(logData.getMulLocalAmt(localCur.getBalanceField(MCT.CREDIT)));
            if (hasPreAndSameYear) {
                param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_DEBIT)).add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))));
                param.add(preBal.getMulLoclAmt(localCur.getBalanceField(MCT.YEAR_CREDIT)).add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
            } else {
                param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT)));
                param.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT)));
            }
            BigDecimal endMulLocal = acctBalanceLog.getMulLocalAmt(localCur.getBalanceField(MCT.BEGIN));
            if (preBal != null) {
                endMulLocal = preBal.getMulLoclAmt(localCur.getBalanceField(MCT.END));
            }
            param.add(endMulLocal.add(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.DEBIT))).subtract(logData.getMulLocalAmt(localCur.getBalanceLogField(MCT.CREDIT))));
        }
        return param;
    }

    protected DataSet queryDetailBalance(long orgId, long booktypeId, long periodId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select forgid,fbooktypeid,faccountid,0 fassgrpid,faccounttableid,fcurrencyid,fmeasureunitid,fcomassist1id,fcomassist2id,", new Object[0]);
        sqlBuilder.append("sum(fbeginlocal) fbeginlocal,sum(fbeginfor) fbeginfor,sum(fbeginqty) fbeginqty,sum(fdebitlocal) fdebitlocal,sum(fdebitfor) fdebitfor,", new Object[0]);
        sqlBuilder.append("sum(fdebitqty) fdebitqty,sum(fcreditlocal) fcreditlocal,sum(fcreditfor) fcreditfor,sum(fcreditqty) fcreditqty,", new Object[0]);
        sqlBuilder.append("sum(fyeardebitlocal) fyeardebitlocal,sum(fyeardebitfor) fyeardebitfor,sum(fyeardebitqty) fyeardebitqty,sum(fyearcreditlocal) fyearcreditlocal,", new Object[0]);
        sqlBuilder.append("sum(fyearcreditfor) fyearcreditfor,sum(fyearcreditqty) fyearcreditqty,", new Object[0]);
        for (LocalCurrencyConfigVO configVO : this.localCurList) {
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.BEGIN).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.BEGIN).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.DEBIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.DEBIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.CREDIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.CREDIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_DEBIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.YEAR_CREDIT).getDbId(), new Object[0]).append(",", new Object[0]);
            sqlBuilder.append("sum(", new Object[0]).append(configVO.getBalanceField(MCT.END).getDbId(), new Object[0]).append(") ", new Object[0]).append(configVO.getBalanceField(MCT.END).getDbId(), new Object[0]).append(",", new Object[0]);
        }
        sqlBuilder.append("sum(fendlocal) fendlocal,sum(fendfor) fendfor,sum(fendqty) fendqty,sum(fcount) fcount from t_gl_balance ", new Object[0]);
        sqlBuilder.append(" where forgid=?", new Object[]{orgId});
        sqlBuilder.append(" and fbooktypeid=?", new Object[]{booktypeId});
        sqlBuilder.append(" and fperiodid=?", new Object[]{periodId});
        sqlBuilder.append(" group by forgid,fbooktypeid,faccountid,faccounttableid,fcurrencyid,fmeasureunitid,fcomassist1id,fcomassist2id", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);
        dataSet = dataSet.orderBy(new String[]{"faccountid", "fcurrencyid", "fmeasureunitid", "fcomassist1id", "fcomassist2id"});
        return dataSet;
    }
}

