/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.business.service.reciprocal;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.gl.business.service.GLServiceFactory;
import kd.fi.gl.business.service.common.BillParamService;
import kd.fi.gl.business.service.reciprocal.baldeduct.FifoSimulateServiceImpl;
import kd.fi.gl.business.vo.reciprocal.AccountGroup;
import kd.fi.gl.constant.GLConstants;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.interfaces.service.reciprocal.IFifoRealTimeWriteOffService;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import org.apache.commons.lang3.tuple.Pair;

public class UnAcccurrentUpdateUtil {
    private static final Log logger = LogFactory.getLog(UnAcccurrentUpdateUtil.class);
    private static IFifoRealTimeWriteOffService realTimeWriteOffService = (IFifoRealTimeWriteOffService)GLServiceFactory.getService(IFifoRealTimeWriteOffService.class);
    public static final String DELETE_SQL = "delete from t_gl_unacccurrent_status where forgid = ? and fbooktypeid = ? and facctableid = ? and faccountid = ?;";

    public static void calculateBalanceLog(long orgId, long bookTypeId) {
        UnAcccurrentUpdateUtil.doCalUnAcccurrent(orgId, bookTypeId, () -> realTimeWriteOffService.calculateBalanceLog(Long.valueOf(orgId), Long.valueOf(bookTypeId)));
    }

    public static void syncReCalUnAcccurrent(long orgId, long bookTypeId, long acctTableId, Long acctMasterId) {
        if (Objects.isNull(acctMasterId)) {
            logger.info("UnAcccurrentUpdateUtil.syncReCalUnAcccurrent_orgId:{} bookTypeId:{} acctTableId:{} acctMasterId:{}", new Object[]{orgId, bookTypeId, acctTableId, acctMasterId});
            return;
        }
        HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMa = new HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>>(1);
        acctGroupMa.put(AccountGroup.of((long)orgId, (long)bookTypeId, (long)acctTableId, (long)acctMasterId, (long)0L), Pair.of(new HashSet(0), new HashSet(0)));
        UnAcccurrentUpdateUtil.ongoingCalculateAccount(acctGroupMa);
        UnAcccurrentUpdateUtil.syncCalAndDeleteStatus(acctGroupMa);
    }

    protected static void syncCalAndDeleteStatus(Map<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMap) {
        acctGroupMap.forEach((k, v) -> UnAcccurrentUpdateUtil.doCalUnAcccurrent(k.getOrgId(), k.getBookTypeId(), () -> UnAcccurrentUpdateUtil.calculateUnAcccurrentStatus(k, (Pair<Set<Long>, Set<Long>>)v)));
    }

    public static void asyncReCalUnAcccurrent(long orgId, long bookTypeId, long acctTableId, Long acctMasterId) {
        HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMa = new HashMap<AccountGroup, Pair<Set<Long>, Set<Long>>>(1);
        acctGroupMa.put(AccountGroup.of((long)orgId, (long)bookTypeId, (long)acctTableId, (long)acctMasterId, (long)0L), Pair.of(new HashSet(0), new HashSet(0)));
        UnAcccurrentUpdateUtil.ongoingCalculateAccount(acctGroupMa);
        UnAcccurrentUpdateUtil.asyncCalAndDeleteStatus(acctGroupMa);
    }

    public static void asyncCalAndDeleteStatus(Map<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMap) {
        acctGroupMap.forEach((k, v) -> ThreadService.execute(() -> UnAcccurrentUpdateUtil.doCalUnAcccurrent(k.getOrgId(), k.getBookTypeId(), k.getAccountId(), () -> UnAcccurrentUpdateUtil.calculateUnAcccurrentStatus(k, (Pair<Set<Long>, Set<Long>>)v)), (TaskType)TaskType.GL_UNACCCURRENT_CALCULATED));
    }

    private static void calculateUnAcccurrentStatus(AccountGroup accountGroup, Pair<Set<Long>, Set<Long>> assgrpIdsToStatusIds) {
        PerformanceWatch watch = new PerformanceWatch(FifoSimulateServiceImpl.class, "balanceWriteOff", false);
        watch.start("UnAcccurrentUpdateUtil#calculateUnAcccurrentStatus");
        realTimeWriteOffService.calculateUnAcccurrentStatus(Long.valueOf(accountGroup.getOrgId()), Long.valueOf(accountGroup.getBookTypeId()), Long.valueOf(accountGroup.getAcctTableId()), Long.valueOf(accountGroup.getAccountId()), Long.valueOf(accountGroup.getCurrencyId()), (Set)assgrpIdsToStatusIds.getLeft());
        Set ids = (Set)assgrpIdsToStatusIds.getRight();
        if (ids.size() > 0) {
            QFilter filter = new QFilter("id", "in", (Object)ids);
            DeleteServiceHelper.delete((String)"gl_unacccurrent_status", (QFilter[])filter.toArray());
        } else {
            Object[] updateParam = new Object[]{accountGroup.getOrgId(), accountGroup.getBookTypeId(), accountGroup.getAcctTableId(), accountGroup.getAccountId()};
            DB.execute((DBRoute)GLConstants.GL_DBRoute, (String)DELETE_SQL, (Object[])updateParam);
        }
        watch.stop();
        logger.info("UnAcccurrentUpdateUtil#calculateUnAcccurrentStatus:{}", (Object)watch.show());
    }

    protected static void doCalUnAcccurrent(long orgId, long bookTypeId, Runnable runnable) {
        Lock.tryLock((long)orgId, (long)bookTypeId, (LockKey)LockKey.UnAcccurrentCal, () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
        });
    }

    protected static void doCalUnAcccurrent(long orgId, long bookTypeId, long accountId, Runnable runnable) {
        Lock.tryLock((long)orgId, (long)bookTypeId, (long)accountId, (LockKey)LockKey.UnAcccurrentCal, () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw e;
            }
        });
    }

    public static Map<Pair<Long, Long>, Map<String, Object>> buildCurrentAssgrp(List<Pair<Long, Long>> acctToAssgrpIdPair, Map<Long, List<String>> acctToFlexFields) {
        if (Objects.isNull(acctToAssgrpIdPair) || Objects.isNull(acctToFlexFields)) {
            return new HashMap<Pair<Long, Long>, Map<String, Object>>(0);
        }
        List assgrpIds = acctToAssgrpIdPair.stream().map(Pair::getValue).collect(Collectors.toList());
        QFilter filter = new QFilter("hg", "in", assgrpIds);
        int size = acctToAssgrpIdPair.size();
        HashMap<Pair<Long, Long>, Map<String, Object>> accassgrpMaps = new HashMap<Pair<Long, Long>, Map<String, Object>>(size);
        HashMap<Long, Map> hgToFlexFieldValues = new HashMap<Long, Map>(size);
        Throwable throwable = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)UnAcccurrentUpdateUtil.class.getName(), (String)"gl_assist_bd", (String)"hg,asstype,assval", (QFilter[])filter.toArray(), (String)"hg asc");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String asstype = row.getString("asstype");
                Object assval = row.get("assval");
                hgToFlexFieldValues.computeIfAbsent(row.getLong("hg"), x -> new HashMap(10)).computeIfAbsent(asstype, s -> assval);
            }
        }
        catch (Throwable row) {
            Throwable throwable2 = row;
            throw row;
        }
        for (Map.Entry entry : acctToAssgrpIdPair) {
            List<String> flexFields = acctToFlexFields.get(entry.getKey());
            Map flexFieldValues = (Map)hgToFlexFieldValues.get(entry.getValue());
            for (String flexField : flexFields) {
                Object value = flexFieldValues.get(flexField);
                if (!Objects.nonNull(value)) continue;
                accassgrpMaps.computeIfAbsent((Pair<Long, Long>)Pair.of(entry.getKey(), entry.getValue()), x -> new HashMap()).computeIfAbsent(flexField, x -> value);
            }
        }
        return accassgrpMaps;
    }

    public static void ongoingCalculateAccount(Map<AccountGroup, Pair<Set<Long>, Set<Long>>> acctGroupMap) {
        if (!BillParamService.isEnableRealTimeWriteOff()) {
            return;
        }
        if (Objects.isNull(acctGroupMap) || acctGroupMap.size() == 0) {
            return;
        }
        int size = acctGroupMap.values().stream().mapToInt(x -> ((Set)x.getLeft()).size()).sum() + acctGroupMap.size();
        long[] ids = DB.genLongIds((String)"t_gl_unacccurrent_status", (int)size);
        int index = 0;
        DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"gl_unacccurrent_status");
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> dynColl = new ArrayList<DynamicObject>(size);
        for (Map.Entry<AccountGroup, Pair<Set<Long>, Set<Long>>> entry : acctGroupMap.entrySet()) {
            AccountGroup acctGroup = entry.getKey();
            dynObj.set(GLField.id_((String)"org"), (Object)acctGroup.getOrgId());
            dynObj.set(GLField.id_((String)"booktype"), (Object)acctGroup.getBookTypeId());
            dynObj.set(GLField.id_((String)"accounttable"), (Object)acctGroup.getAcctTableId());
            dynObj.set(GLField.id_((String)"account"), (Object)acctGroup.getAccountId());
            dynObj.set(GLField.id_((String)"currency"), (Object)acctGroup.getCurrencyId());
            dynObj.set("createtime", (Object)now);
            if (((Set)entry.getValue().getLeft()).size() > 0) {
                for (Long assgrpId : (Set)entry.getValue().getLeft()) {
                    DynamicObject copy = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)dynObj);
                    long id = ids[index++];
                    ((Set)entry.getValue().getRight()).add(id);
                    copy.set("id", (Object)id);
                    copy.set(GLField.id_((String)"assgrp"), (Object)assgrpId);
                    dynColl.add(copy);
                    if (dynColl.size() <= 999) continue;
                    SaveServiceHelper.save((DynamicObject[])dynColl.toArray(new DynamicObject[0]));
                    dynColl.clear();
                }
                continue;
            }
            DynamicObject copy = (DynamicObject)new CloneUtils(true, true).clone((IDataEntityBase)dynObj);
            long id = ids[index++];
            ((Set)entry.getValue().getRight()).add(id);
            copy.set("id", (Object)id);
            copy.set(GLField.id_((String)"assgrp"), (Object)0L);
            dynColl.add(copy);
            if (dynColl.size() <= 999) continue;
            SaveServiceHelper.save((DynamicObject[])dynColl.toArray(new DynamicObject[0]));
            dynColl.clear();
        }
        if (dynColl.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynColl.toArray(new DynamicObject[0]));
            dynColl.clear();
        }
    }

    public static boolean isRuningRealTimeWriteOff(Long orgId, Long bookTypeId, Long actMasterId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and(new QFilter("booktype", "=", (Object)bookTypeId));
        filter.and(new QFilter("account", "=", (Object)actMasterId));
        return QueryServiceHelper.exists((String)"gl_unacccurrent_status", (QFilter[])filter.toArray());
    }
}

