/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.reciprocal.AbstractReciprocalLogicUnit;
import kd.fi.gl.reciprocal.AmtNoEqlWriteOffLogicUnit;
import kd.fi.gl.reciprocal.RcpWriteOffUtils;
import kd.fi.gl.reciprocal.ReciprocalContext;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.util.GLUtil;

public abstract class AbstractRcpWriteOffLoginUnit
extends AbstractReciprocalLogicUnit {
    protected static final int INIT_CAPACITY = 1024;
    private static final DBRoute GL = new DBRoute("gl");
    protected static final int BATCH_COUNT = 1000;
    private static final String RECIPROCAL_LOG = "gl_reciprocal_log";
    private static final String UPDATE_ACCCURRENT_SQL = "UPDATE T_GL_ACCCURRENT SET FAMOUNTBAL=?, FAMOUNTBALFOR=?, FSTATUS=?, FMODIFYTIME=?, FWRITEOFFPERSONID=? WHERE FMASTERID=?";
    private List<ReciprocalRecord> lstCurUnitRecords;
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.writeoff);
    private static final Log logger = LogFactory.getLog(AbstractRcpWriteOffLoginUnit.class);

    protected List<ReciprocalRecord> getAllRecords() {
        return this.lstCurUnitRecords;
    }

    protected ReciprocalRecord getRecordById(Long id) {
        return (ReciprocalRecord)this.context.getEntryAndRecordMap().get(id);
    }

    protected List<ReciprocalRecord> getRecordsByVchId(Long vchId) {
        Set lstIds = (Set)this.context.getVoucherAndEntryMap().get(vchId);
        Map entryAndMapRecord = this.context.getEntryAndRecordMap();
        ArrayList<ReciprocalRecord> lstRecords = new ArrayList<ReciprocalRecord>();
        if (lstIds != null) {
            for (Long id : lstIds) {
                ReciprocalRecord record = (ReciprocalRecord)entryAndMapRecord.get(id);
                if (record == null) continue;
                lstRecords.add(record);
            }
        }
        return lstRecords;
    }

    protected abstract String getQuerySourceType();

    protected abstract String getWriteOffSourceType();

    public abstract Boolean isNeedSplit();

    public Boolean reLoadRecords() {
        return Boolean.TRUE;
    }

    @Override
    protected void execute() {
        RcpWriteOffUtils.writeOff(this);
    }

    protected abstract void beforeWriteOffEvent();

    private void writeOffEvent() {
        if (this.context.IsSimulate().booleanValue()) {
            this.simulateWriteOffEvent();
        } else {
            this.autoWriteOffEvent();
        }
    }

    public void invokeWriteOff() {
        if (!this.initCurUnitVariables()) {
            return;
        }
        this.beforeWriteOffEvent();
        this.writeOffEvent();
    }

    private boolean initCurUnitVariables() {
        this.lstCurUnitRecords = this.context.getRecords(this.getWriteOffSourceType());
        if (DebugTrace.enable()) {
            ReciprocalScheme scheme = this.context.getScheme();
            String sourceType = this.getWriteOffSourceType();
            if (DebugTrace.enable()) {
                logger.info("=====reciprocalAging_taskId:{}_AbstractRcpWriteOffLoginUnit_initCurUnitVariables_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_sourceType:{}_unitRecordsSize:{}_unitRecords:{}=====", new Object[]{this.context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), this.getClass().getName(), sourceType, this.lstCurUnitRecords == null ? 0 : this.lstCurUnitRecords.size(), this.lstCurUnitRecords == null ? Integer.valueOf(0) : JSON.toJSON(this.lstCurUnitRecords)});
            }
        }
        boolean isSuccessInit = true;
        if (this.lstCurUnitRecords == null || this.lstCurUnitRecords.isEmpty()) {
            isSuccessInit = false;
            this.logInfo(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5355\u5143%s\uff0c\u83b7\u53d6\u5f80\u6765\u8d26\u8bb0\u5f55\u5931\u8d25\uff0c\u5373\u5c06\u8df3\u8fc7\u672c\u5355\u5143\u6267\u884c\u903b\u8f91\u3002", (String)"AbstractRcpWriteOffLoginUnit_0", (String)"fi-gl-common", (Object[])new Object[0]), this.getClass().getName()));
        } else {
            this.logInfo(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5355\u5143%1$s\uff0c\u83b7\u53d6\u5f80\u6765\u8d26\u8bb0\u5f55\u6570\u91cf%2$s\u3002", (String)"AbstractRcpWriteOffLoginUnit_1", (String)"fi-gl-common", (Object[])new Object[0]), this.getClass().getName(), this.lstCurUnitRecords.size()));
        }
        return isSuccessInit;
    }

    private void logInfo(String msg) {
        this.context.logInfo(msg);
    }

    public void autoWriteOffEvent() {
        List<Long> vchids = this.getBatchRecords();
        while (!vchids.isEmpty()) {
            try (TXHandle handler = TX.requiresNew();){
                try {
                    this.lockVoucher(vchids);
                    this.doEveryWriteOff();
                    RcpWriteOffUtils.saveReciprocalLog(this.context);
                    this.reWriteReciprocalRecord();
                    this.delBalZeroRecords();
                }
                catch (Exception e) {
                    handler.markRollback();
                    throw e;
                }
            }
            vchids = this.getBatchRecords();
        }
    }

    public void simulateWriteOffEvent() {
        List<Long> vchids = this.getBatchRecords();
        while (!vchids.isEmpty()) {
            try {
                this.doEveryWriteOff();
                this.delBalZeroRecords();
            }
            catch (Exception e) {
                this.logInfo(e.getMessage());
                throw e;
            }
            vchids = this.getBatchRecords();
        }
        if (DebugTrace.enable()) {
            ReciprocalContext context = this.context;
            ReciprocalScheme scheme = context.getScheme();
            List records = context.getRecords("-1");
            logger.info("=====reciprocalAging_taskId:{}_AbstractRcpWriteOffLoginUnit_simulateWriteOffEvent_\u5f53\u524d\u65b9\u6848:{}_\u7ec4\u7ec7:{}_\u6267\u884c\u5355\u5143:{}_\u6267\u884c\u8be5\u5355\u5143\u540e\u5185\u5b58\u6570\u636erecordsSize:{}_records:{}=====", new Object[]{this.context.getCurTask().getTaskId(), scheme.getNumber(), scheme.getOrg(), this.getClass().getName(), records == null ? 0 : records.size(), records == null ? Integer.valueOf(0) : JSON.toJSON((Object)records)});
        }
    }

    protected abstract List<Long> getBatchRecords();

    private void lockVoucher(List<Long> vchids) {
        GLUtil.lockVouchers(vchids);
    }

    protected abstract void doEveryWriteOff();

    protected void reWriteReciprocalRecord() {
        List lstSuccessRecords = this.context.getSuccessRecords();
        Date modifyDate = TimeServiceHelper.now();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(1024);
        Long zeroId = 0L;
        for (ReciprocalRecord record : lstSuccessRecords) {
            if (zeroId.equals(record.getMasterId())) continue;
            updateParams.add(new Object[]{record.getAmountBal(), record.getAmountBalFor(), record.getStatus(), modifyDate, this.context.getWriter(), record.getMasterId()});
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)GL, (String)UPDATE_ACCCURRENT_SQL, updateParams);
            lstSuccessRecords.clear();
        }
    }

    protected void delBalZeroRecords() {
        List balZeroRecords = this.context.getBalZeroRecords();
        if (this.context.getScheme().getWriteOffType() == 1) {
            String key = this.context.getScheme().getOrg() + "" + this.context.getScheme().getBookType() + "haswriteoffcount";
            String writeOffCount = this.cache.get(key);
            int num = StringUtils.isEmpty((String)writeOffCount) ? 0 : Integer.parseInt(writeOffCount);
            this.cache.put(key, num + this.context.getSuccessWriteOffSize().get() + "");
        }
        Set excludeIds = null;
        if (this.context.IsSimulate().booleanValue()) {
            excludeIds = balZeroRecords.stream().filter(x -> x.getAmountBal().compareTo(BigDecimal.ZERO) != 0).map(x -> x.getId()).collect(Collectors.toSet());
        }
        this.context.removeRecords(balZeroRecords, excludeIds);
        balZeroRecords.clear();
    }

    protected void generateWriteOffLog(ReciprocalRecord srcRecord, ReciprocalRecord targetRecord) {
        if (this instanceof AmtNoEqlWriteOffLogicUnit) {
            RcpWriteOffUtils.generateWriteOffLog(srcRecord, targetRecord, this.context, Boolean.TRUE);
        } else {
            RcpWriteOffUtils.generateWriteOffLog(srcRecord, targetRecord, this.context, Boolean.FALSE);
        }
    }
}

