/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.gl.reciprocal.AbstractRcpWriteOffLoginUnit;
import kd.fi.gl.reciprocal.ReciprocalRecord;
import kd.fi.gl.reciprocal.ReciprocalScheme;

public class AmtNoEqlWriteOffLogicUnit
extends AbstractRcpWriteOffLoginUnit {
    private Map<Long, Set<Long>> srcAndTgtEntryMap;
    private Map<Long, ReciprocalRecord> buyerRecords;
    private Map<Long, ReciprocalRecord> writeOffRecords;
    private List<ReciprocalRecord> lstAllRecords;

    @Override
    public Boolean reLoadRecords() {
        return Boolean.FALSE;
    }

    @Override
    protected void beforeWriteOffEvent() {
        this.srcAndTgtEntryMap = new LinkedHashMap<Long, Set<Long>>(1024);
        this.lstAllRecords = this.getAllRecords();
        this.buyerRecords = new LinkedHashMap<Long, ReciprocalRecord>(this.lstAllRecords.size());
        this.writeOffRecords = new LinkedHashMap<Long, ReciprocalRecord>(this.lstAllRecords.size());
        for (int i = 0; i < this.lstAllRecords.size(); ++i) {
            ReciprocalRecord p = this.lstAllRecords.get(i);
            if (p.getStatus().equals("2")) continue;
            if (p.getBuyerFor().booleanValue() && p.getBuyerLocal().booleanValue()) {
                this.buyerRecords.put(p.getId(), p);
                continue;
            }
            if (p.getBuyerFor().equals(p.getBuyerLocal() == false)) {
                if (p.getBuyerFor().booleanValue()) {
                    this.buyerRecords.put(p.getId(), p);
                } else {
                    this.writeOffRecords.put(p.getId(), p);
                }
                if (p.getBuyerLocal().booleanValue()) {
                    this.buyerRecords.put(p.getId(), p);
                    continue;
                }
                this.writeOffRecords.put(p.getId(), p);
                continue;
            }
            this.writeOffRecords.put(p.getId(), p);
        }
    }

    @Override
    protected List<Long> getBatchRecords() {
        HashSet<Long> vchIds = new HashSet<Long>();
        if (this.buyerRecords.size() == 0 || this.writeOffRecords.size() == 0) {
            return new ArrayList<Long>(vchIds);
        }
        HashMap<String, LinkedList<ReciprocalRecord>> writeOffRecordMap = new HashMap<String, LinkedList<ReciprocalRecord>>();
        for (Map.Entry<Long, ReciprocalRecord> entry : this.writeOffRecords.entrySet()) {
            ReciprocalRecord writeOffRecord = entry.getValue();
            String key = writeOffRecord.groupByKey(this.context, false);
            LinkedList<ReciprocalRecord> lstRecords = (LinkedList<ReciprocalRecord>)writeOffRecordMap.get(key);
            if (lstRecords == null) {
                lstRecords = new LinkedList<ReciprocalRecord>();
                writeOffRecordMap.put(key, lstRecords);
            }
            lstRecords.add(writeOffRecord);
        }
        ReciprocalScheme scheme = this.context.getScheme();
        int iCount = 0;
        HashMap<String, BigDecimal> remainAmountForMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> remainAmountMap = new HashMap<String, BigDecimal>(16);
        block1: for (Map.Entry<Long, ReciprocalRecord> entry : this.buyerRecords.entrySet()) {
            ReciprocalRecord buyerRecord = entry.getValue();
            String groupKey = buyerRecord.groupByKey(this.context, false);
            List lstWriteOffRecords = (List)writeOffRecordMap.get(groupKey);
            if (lstWriteOffRecords == null || lstWriteOffRecords.size() <= 0) continue;
            ArrayList<Object> writeOffRecords = new ArrayList<Object>(lstWriteOffRecords.size());
            if (scheme.isReverOrderSameDire()) {
                ArrayList<ReciprocalRecord> diffDcList = new ArrayList<ReciprocalRecord>(lstWriteOffRecords.size());
                for (ReciprocalRecord reciprocalRecord : lstWriteOffRecords) {
                    if (buyerRecord.getEntryDc().equals(reciprocalRecord.getEntryDc())) {
                        writeOffRecords.add(reciprocalRecord);
                        continue;
                    }
                    diffDcList.add(reciprocalRecord);
                }
                writeOffRecords.addAll(diffDcList);
                lstWriteOffRecords.clear();
                lstWriteOffRecords.addAll(writeOffRecords);
            }
            Iterator iterator = lstWriteOffRecords.iterator();
            BigDecimal amountBalFor = buyerRecord.getAmountBalFor();
            BigDecimal amountBal = buyerRecord.getAmountBal();
            BigDecimal writeOffSumBalFor = BigDecimal.ZERO;
            BigDecimal writeOffSumBal = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                ReciprocalRecord writeOffRecord = (ReciprocalRecord)iterator.next();
                if (!buyerRecord.compareTo(writeOffRecord, false, scheme).booleanValue() || buyerRecord.getId().equals(writeOffRecord.getId())) continue;
                this.srcAndTgtEntryMap.computeIfAbsent(buyerRecord.getId(), k -> new LinkedHashSet()).add(writeOffRecord.getId());
                vchIds.add(buyerRecord.getVoucherId());
                vchIds.add(writeOffRecord.getVoucherId());
                BigDecimal writeOffAmountBalFor = writeOffRecord.getAmountBalFor();
                writeOffSumBalFor = remainAmountForMap.containsKey(groupKey) ? writeOffSumBalFor.add((BigDecimal)remainAmountForMap.remove(groupKey)) : writeOffSumBalFor.add(writeOffAmountBalFor.abs());
                BigDecimal writeOffAmountBal = writeOffRecord.getAmountBal();
                writeOffSumBal = remainAmountMap.containsKey(groupKey) ? writeOffSumBal.add((BigDecimal)remainAmountMap.remove(groupKey)) : writeOffSumBal.add(writeOffAmountBal.abs());
                if (++iCount >= 1000) break block1;
                if (writeOffSumBalFor.compareTo(amountBalFor) <= 0 && writeOffSumBal.compareTo(amountBal) <= 0) {
                    iterator.remove();
                    continue;
                }
                remainAmountForMap.put(groupKey, writeOffSumBalFor.subtract(amountBalFor));
                remainAmountMap.put(groupKey, writeOffSumBal.subtract(amountBal));
            }
        }
        return new ArrayList<Long>(vchIds);
    }

    @Override
    protected void doEveryWriteOff() {
        block0: for (Map.Entry<Long, Set<Long>> entrySet : this.srcAndTgtEntryMap.entrySet()) {
            Long buyerEntryId = entrySet.getKey();
            for (Long writeOffEntryId : entrySet.getValue()) {
                ReciprocalRecord buyerRecord = this.buyerRecords.get(buyerEntryId);
                if (buyerRecord.getAmountBalFor().compareTo(BigDecimal.ZERO) == 0 && buyerRecord.getAmountBal().compareTo(BigDecimal.ZERO) == 0) {
                    this.buyerRecords.remove(buyerEntryId);
                    continue block0;
                }
                ReciprocalRecord writeOffRecord = this.writeOffRecords.get(writeOffEntryId);
                this.generateWriteOffLog(buyerRecord, writeOffRecord);
            }
        }
        this.context.getBalZeroRecords().forEach(p -> {
            this.buyerRecords.remove(p.getId());
            this.writeOffRecords.remove(p.getId());
        });
        this.srcAndTgtEntryMap.clear();
    }

    @Override
    public Boolean isNeedSplit() {
        return true;
    }

    @Override
    protected String getQuerySourceType() {
        return "0";
    }

    @Override
    protected String getWriteOffSourceType() {
        return "-1";
    }

    public Map<Long, ReciprocalRecord> getBuyerRecords() {
        return this.buyerRecords;
    }

    public Map<Long, ReciprocalRecord> getWriteOffRecords() {
        return this.writeOffRecords;
    }
}

