/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.enums.AssistBalBatchQueryType;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;
import kd.fi.gl.util.GLUtil;

public class ReportBalanceUtil {
    public static final String QUERY_PARAM_RPT = "queryParamRpt";
    public static final String ACCT_MID2ID_MAP = "acctMID2IDMap";
    public static final String ACCT_ID2MID_MAP = "acctID2MIDMap";
    public static final String ACCT_MAP = "acctMap";
    public static final String ASSTYPENAME_LIST = "assTypenameList";

    public static List<SubsidiaryRow> calculateWithPeriodBegin(ReportQueryParam param, List<SubsidiaryRow> beginList, List<SubsidiaryRow> voucherList) {
        LinkedList<SubsidiaryRow> resultList = new LinkedList<SubsidiaryRow>();
        HashBasedTable subsidiaryTable = HashBasedTable.create();
        HashBasedTable voucherTable = HashBasedTable.create();
        QueryParamRpt qpRpt = (QueryParamRpt)param.getCustomParam().get(QUERY_PARAM_RPT);
        Map periodMap = (Map)param.getCustomParam().get("periodMap");
        String periodVoucherDesc = (String)param.getCustomParam().get("periodVoucherDesc");
        String yearVoucherDesc = (String)param.getCustomParam().get("yearVoucherDesc");
        voucherList.stream().forEach(arg_0 -> ReportBalanceUtil.lambda$calculateWithPeriodBegin$0((Table)voucherTable, arg_0));
        beginList.forEach(arg_0 -> ReportBalanceUtil.lambda$calculateWithPeriodBegin$1((Table)subsidiaryTable, periodMap, (Table)voucherTable, qpRpt, periodVoucherDesc, yearVoucherDesc, arg_0));
        QFilter commonFilter = param.getFilter().getCommFilter("gl_voucher");
        if (qpRpt.isNoZeroAmount() || commonFilter != null) {
            ArrayList keyList = new ArrayList(subsidiaryTable.rowKeySet());
            int groupCount = keyList.size();
            for (int k = 0; k < groupCount; ++k) {
                Map rowMap = subsidiaryTable.row(keyList.get(k));
                ArrayList rowList = new ArrayList(64);
                rowMap.values().stream().forEach(x -> rowList.addAll(x));
                boolean hasVoucher = rowList.stream().anyMatch(x -> "2".equals(x.getRowtype()));
                if (hasVoucher) continue;
                rowMap.clear();
            }
        }
        subsidiaryTable.values().stream().forEach(x -> resultList.addAll((Collection<SubsidiaryRow>)x));
        resultList.stream().forEach(x -> ReportBalanceUtil.showByAccountDc(x, qpRpt));
        return resultList;
    }

    private static SubsidiaryRow getPeriodDataRow(SubsidiaryRow beginDataRow, SubsidiaryPeriod subsidiaryPeriod, String periodVoucherDesc) {
        SubsidiaryRow periodDataRow = (SubsidiaryRow)beginDataRow.clone();
        periodDataRow.setRowtype("4");
        periodDataRow.setPeriodId(subsidiaryPeriod.getPeriod());
        periodDataRow.setPeriodYear(subsidiaryPeriod.getPeriodyear());
        periodDataRow.setBookedDate(subsidiaryPeriod.getEnddate());
        periodDataRow.setBookedDateStr("z");
        periodDataRow.setVoucherDesc(periodVoucherDesc);
        periodDataRow.setDebitQty(BigDecimal.ZERO);
        periodDataRow.setCreditQty(BigDecimal.ZERO);
        periodDataRow.setEndQty(BigDecimal.ZERO);
        return periodDataRow;
    }

    private static SubsidiaryRow getYearDataRow(SubsidiaryRow beginDataRow, SubsidiaryPeriod subsidiaryPeriod, SubsidiaryRow preYearDataRow, String yearVoucherDesc) {
        SubsidiaryRow yearDataRow = (SubsidiaryRow)beginDataRow.clone();
        yearDataRow.setRowtype("5");
        yearDataRow.setPeriodId(subsidiaryPeriod.getPeriod());
        yearDataRow.setPeriodYear(subsidiaryPeriod.getPeriodyear());
        yearDataRow.setBookedDate(subsidiaryPeriod.getEnddate());
        yearDataRow.setBookedDateStr("z");
        yearDataRow.setVoucherDesc(yearVoucherDesc);
        yearDataRow.setDebitQty(BigDecimal.ZERO);
        yearDataRow.setCreditQty(BigDecimal.ZERO);
        yearDataRow.setEndQty(BigDecimal.ZERO);
        if (null != preYearDataRow) {
            if (Objects.equals(yearDataRow.getPeriodYear(), preYearDataRow.getPeriodYear())) {
                yearDataRow.setDebitLocal(yearDataRow.getDebitLocal().add(preYearDataRow.getDebitLocal()));
                yearDataRow.setDebitFor(yearDataRow.getDebitFor().add(preYearDataRow.getDebitFor()));
                yearDataRow.setCreditLocal(yearDataRow.getCreditLocal().add(preYearDataRow.getCreditLocal()));
                yearDataRow.setCreditFor(yearDataRow.getCreditFor().add(preYearDataRow.getCreditFor()));
            }
        } else {
            yearDataRow.setDebitLocal(yearDataRow.getDebitLocal().add(beginDataRow.getYearDebitLocal()));
            yearDataRow.setDebitFor(yearDataRow.getDebitFor().add(beginDataRow.getYearDebitFor()));
            yearDataRow.setCreditLocal(yearDataRow.getCreditLocal().add(beginDataRow.getYearCreditLocal()));
            yearDataRow.setCreditFor(yearDataRow.getCreditFor().add(beginDataRow.getYearCreditFor()));
        }
        return yearDataRow;
    }

    public static void showByAccountDc(SubsidiaryRow row, QueryParamRpt qpRpt) {
        BigDecimal endlocal = row.getEndLocal();
        if (endlocal == null || GLUtil.isZero((BigDecimal)endlocal)) {
            row.setEndDC(Integer.valueOf(0));
        } else {
            int accountDc = row.getAccountDc();
            BigDecimal amountDcVal = new BigDecimal(accountDc);
            BigDecimal endForVal = row.getEndFor().multiply(amountDcVal);
            BigDecimal endLocalVal = row.getEndLocal().multiply(amountDcVal);
            BigDecimal endQtyVal = row.getEndQty().multiply(amountDcVal);
            row.setEndDC(Integer.valueOf(accountDc));
            if (!qpRpt.isShowDataByDC()) {
                int dc = row.getEndLocal().compareTo(BigDecimal.ZERO);
                if (!Objects.equals(accountDc, dc)) {
                    endQtyVal = endQtyVal.negate();
                }
                endForVal = endForVal.abs();
                endLocalVal = endLocalVal.abs();
                row.setEndDC(Integer.valueOf(dc));
            }
            row.setEndQty(endQtyVal);
            row.setEndLocal(endLocalVal);
            row.setEndFor(endForVal);
        }
    }

    public static List<SubsidiaryRow> convertAndSumDataSetToList(ReportQueryParam param, DataSet dataSet, IDatasetRowTypeConverter<SubsidiaryRow> converter) {
        HashMap<String, SubsidiaryRow> dataMap = new HashMap<String, SubsidiaryRow>(1024);
        for (Row row : dataSet) {
            SubsidiaryRow subsidiaryRow = (SubsidiaryRow)converter.convertTo(param, row);
            if (dataMap.containsKey(subsidiaryRow.getGroupKey())) {
                SubsidiaryRow preRow = (SubsidiaryRow)dataMap.get(subsidiaryRow.getGroupKey());
                ReportBalanceUtil.mergeAmount(preRow, subsidiaryRow);
                continue;
            }
            dataMap.put(subsidiaryRow.getGroupKey(), subsidiaryRow);
        }
        List<SubsidiaryRow> dataList = dataMap.entrySet().parallelStream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        return dataList;
    }

    public static List<SubsidiaryRow> convertDataSetToList(ReportQueryParam param, DataSet dataSet, IDatasetRowTypeConverter<SubsidiaryRow> converter) {
        ArrayList<SubsidiaryRow> dataList = new ArrayList<SubsidiaryRow>(1024);
        for (Row row : dataSet) {
            SubsidiaryRow subsidiaryRow = (SubsidiaryRow)converter.convertTo(param, row);
            dataList.add(subsidiaryRow);
        }
        return dataList;
    }

    public static List<SubsidiaryRow> groupBalance(List<SubsidiaryRow> balanceList) {
        balanceList.sort(Comparator.comparing(SubsidiaryRow::getGroupKey));
        SubsidiaryRow preRow = null;
        Iterator<SubsidiaryRow> iterator = balanceList.iterator();
        while (iterator.hasNext()) {
            SubsidiaryRow row = iterator.next();
            if (preRow == null) {
                preRow = row;
                continue;
            }
            if (Objects.equals(row.getGroupKey(), preRow.getGroupKey())) {
                ReportBalanceUtil.mergeAmount(preRow, row);
                iterator.remove();
                continue;
            }
            preRow = row;
        }
        return balanceList;
    }

    private static void mergeAmount(SubsidiaryRow preRow, SubsidiaryRow row) {
        preRow.setDebitLocal(preRow.getDebitLocal().add(row.getDebitLocal()));
        preRow.setDebitFor(preRow.getDebitFor().add(row.getDebitFor()));
        preRow.setYearDebitLocal(preRow.getYearDebitLocal().add(row.getYearDebitLocal()));
        preRow.setYearDebitFor(preRow.getYearDebitFor().add(row.getYearDebitFor()));
        preRow.setCreditLocal(preRow.getCreditLocal().add(row.getCreditLocal()));
        preRow.setCreditFor(preRow.getCreditFor().add(row.getCreditFor()));
        preRow.setYearCreditLocal(preRow.getYearCreditLocal().add(row.getYearCreditLocal()));
        preRow.setYearCreditFor(preRow.getYearCreditFor().add(row.getYearCreditFor()));
        preRow.setEndLocal(preRow.getEndLocal().add(row.getEndLocal()));
        preRow.setEndFor(preRow.getEndFor().add(row.getEndFor()));
        preRow.setCount(Long.valueOf(preRow.getCount() + row.getCount()));
    }

    private static void mergeQty(SubsidiaryRow preRow, SubsidiaryRow row) {
        preRow.setDebitQty(preRow.getDebitQty().add(row.getDebitQty()));
        preRow.setYearDebitQty(preRow.getYearDebitQty().add(row.getYearDebitQty()));
        preRow.setCreditQty(preRow.getCreditQty().add(row.getCreditQty()));
        preRow.setYearCreditQty(preRow.getYearCreditQty().add(row.getYearCreditQty()));
        preRow.setEndQty(preRow.getEndQty().add(row.getEndQty()));
    }

    public static void clearCustomParam(ReportQueryParam reportQueryParam) {
        List batchRows = reportQueryParam.byBatchInfo().getCurrentBatchRows();
        if (batchRows.size() <= 0) {
            return;
        }
        String batchType = ((Row)batchRows.get(0)).getString(0);
        if (Objects.equals(batchType, AssistBalBatchQueryType.ORG.name())) {
            return;
        }
        Map cusParamMap = reportQueryParam.getCustomParam();
        String pageId = (String)cusParamMap.get("pageId");
        List flexFilterItems = reportQueryParam.getFilter().getFlexFilterItems();
        for (int i = 0; i < flexFilterItems.size(); ++i) {
            FilterItemInfo flexFilter = (FilterItemInfo)flexFilterItems.get(i);
            flexFilter.setValue(cusParamMap.get(flexFilter.getPropName()));
        }
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        reportCache.setReportQueryParam(pageId, reportQueryParam);
    }

    private static /* synthetic */ void lambda$calculateWithPeriodBegin$1(Table subsidiaryTable, Map periodMap, Table voucherTable, QueryParamRpt qpRpt, String periodVoucherDesc, String yearVoucherDesc, SubsidiaryRow row) {
        ArrayList<SubsidiaryRow> beginRows = new ArrayList<SubsidiaryRow>(1);
        beginRows.add(row);
        subsidiaryTable.put((Object)row.getGroupKey(), (Object)row.getPeriodId(), beginRows);
        SubsidiaryRow beginDataRow = (SubsidiaryRow)row.clone();
        SubsidiaryRow preYearDataRow = null;
        for (SubsidiaryPeriod subsidiaryPeriod : periodMap.values()) {
            LinkedList<SubsidiaryRow> voucherRows;
            beginDataRow.clearBalanceAmount();
            if (!Objects.equals(beginDataRow.getPeriodYear(), subsidiaryPeriod.getPeriodyear())) {
                beginDataRow.clearBalanceYearAmount();
            }
            if (CollectionUtils.isEmpty((Collection)(voucherRows = (LinkedList<SubsidiaryRow>)voucherTable.get((Object)row.getGroupKey(), (Object)subsidiaryPeriod.getPeriod())))) {
                if (qpRpt.isNoZeroSumAmount()) continue;
                voucherRows = new LinkedList<SubsidiaryRow>();
            }
            subsidiaryTable.put((Object)row.getGroupKey(), (Object)subsidiaryPeriod.getPeriod(), voucherRows);
            voucherRows.sort(Comparator.comparing(SubsidiaryRow::getVoucherKey));
            for (int i = 0; i < voucherRows.size(); ++i) {
                SubsidiaryRow voucherRow = (SubsidiaryRow)voucherRows.get(i);
                voucherRow.setAccountName(beginDataRow.getAccountName());
                beginDataRow.setDebitQty(beginDataRow.getDebitQty().add(voucherRow.getDebitQty()));
                beginDataRow.setCreditQty(beginDataRow.getCreditQty().add(voucherRow.getCreditQty()));
                beginDataRow.setDebitLocal(beginDataRow.getDebitLocal().add(voucherRow.getDebitLocal()));
                beginDataRow.setCreditLocal(beginDataRow.getCreditLocal().add(voucherRow.getCreditLocal()));
                beginDataRow.setEndLocal(beginDataRow.getEndLocal().add(voucherRow.getEndLocal()));
                voucherRow.setEndLocal(beginDataRow.getEndLocal());
                beginDataRow.setDebitFor(beginDataRow.getDebitFor().add(voucherRow.getDebitFor()));
                beginDataRow.setCreditFor(beginDataRow.getCreditFor().add(voucherRow.getCreditFor()));
                beginDataRow.setEndFor(beginDataRow.getEndFor().add(voucherRow.getEndFor()));
                voucherRow.setEndFor(beginDataRow.getEndFor());
                beginDataRow.setEndQty(beginDataRow.getEndQty().add(voucherRow.getEndQty()));
                voucherRow.setEndQty(beginDataRow.getEndQty());
            }
            SubsidiaryRow periodDataRow = ReportBalanceUtil.getPeriodDataRow(beginDataRow, subsidiaryPeriod, periodVoucherDesc);
            voucherRows.add(periodDataRow);
            SubsidiaryRow yearDataRow = ReportBalanceUtil.getYearDataRow(beginDataRow, subsidiaryPeriod, preYearDataRow, yearVoucherDesc);
            voucherRows.add(yearDataRow);
            preYearDataRow = yearDataRow;
        }
    }

    private static /* synthetic */ void lambda$calculateWithPeriodBegin$0(Table voucherTable, SubsidiaryRow x) {
        LinkedList<SubsidiaryRow> voucherRows = (LinkedList<SubsidiaryRow>)voucherTable.get((Object)x.getGroupKey(), (Object)x.getPeriodId());
        if (CollectionUtils.isNotEmpty((Collection)voucherRows)) {
            voucherRows.add(x);
        } else {
            voucherRows = new LinkedList<SubsidiaryRow>();
            voucherRows.add(x);
            voucherTable.put((Object)x.getGroupKey(), (Object)x.getPeriodId(), voucherRows);
        }
    }
}

