/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.export.convert;

import com.google.common.base.Joiner;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Row;
import kd.bos.entity.report.ReportQueryParam;
import kd.fi.bd.model.Context;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.export.convert.IDatasetRowTypeConverter;
import kd.fi.gl.report.subsidiary.SubsidiaryAccount;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryRow;
import kd.fi.gl.util.SubsiDiaryHelper;

public class AuxVoucherConverter
implements IDatasetRowTypeConverter<SubsidiaryRow> {
    public SubsidiaryRow convertTo(Context context, Row row) {
        return null;
    }

    public SubsidiaryRow convertTo(ReportQueryParam param, Row row) {
        Tuple vouchertypeMap = (Tuple)param.getCustomParam().get("vouchertypeMap");
        Map orgCurLocalMap = (Map)param.getCustomParam().get("orgCurLocalMap");
        Map acctID2MIDMap = (Map)param.getCustomParam().get("acctID2MIDMap");
        Map acctMID2IDMap = (Map)param.getCustomParam().get("acctMID2IDMap");
        QueryParamRpt qpRpt = (QueryParamRpt)param.getCustomParam().get("queryParamRpt");
        Map periodMap = (Map)param.getCustomParam().get("periodMap");
        List flexFieldNames = (List)param.getCustomParam().get("flexFieldNames");
        ArrayList<Object> groupKeys = new ArrayList<Object>(16);
        SubsidiaryRow subsidiaryRow = new SubsidiaryRow();
        subsidiaryRow.setRowtype("2");
        subsidiaryRow.setVoucherId(row.getLong("voucherid"));
        String voucherNo = row.getString("billno");
        subsidiaryRow.setVoucherNo(voucherNo);
        Long voucherTypeId = row.getLong("vouchertype");
        String voucherNumber = (String)((Map)vouchertypeMap.item1).get(voucherTypeId) + voucherNo;
        subsidiaryRow.setVoucherNum(voucherNumber);
        subsidiaryRow.setVtNum((String)((Map)vouchertypeMap.item2).get(voucherTypeId));
        subsidiaryRow.setSeq(row.getInteger("accountseq"));
        subsidiaryRow.setBizDate(row.getDate("bizdate"));
        Date bookDate = row.getDate("bookeddate");
        subsidiaryRow.setBookedDate(bookDate);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyy-MM-dd");
        subsidiaryRow.setBookedDateStr(dFormat.format(bookDate));
        Long orgId = row.getLong("org");
        subsidiaryRow.setOrgId(orgId);
        groupKeys.add(orgId);
        Tuple[] flexTuple = new Tuple[flexFieldNames.size()];
        for (int i = 0; i < flexFieldNames.size(); ++i) {
            flexTuple[i] = Tuple.create(flexFieldNames.get(i), (Object)row.get((String)flexFieldNames.get(i)));
            groupKeys.add(row.get((String)flexFieldNames.get(i)));
        }
        subsidiaryRow.setFlexTuple(flexTuple);
        subsidiaryRow.setVoucherEntryId(row.getLong("fentryid"));
        subsidiaryRow.setVoucherDesc(row.getString("desc"));
        Long accountId = row.getLong("account");
        SubsidiaryAccount lastAccount = (SubsidiaryAccount)acctID2MIDMap.get(accountId);
        if (Objects.isNull(lastAccount)) {
            SubsiDiaryHelper.queryLastVersionAccount(param, row, acctID2MIDMap, qpRpt);
        }
        Long masterid = ((SubsidiaryAccount)acctID2MIDMap.get(accountId)).getMasterid();
        SubsidiaryAccount account = (SubsidiaryAccount)acctMID2IDMap.get(masterid);
        subsidiaryRow.setAccountId(account.getId());
        groupKeys.add(account.getNumber());
        subsidiaryRow.setAccountMasterId(account.getMasterid());
        subsidiaryRow.setAccountName(account.getName());
        subsidiaryRow.setAccountNumber(account.getNumber());
        subsidiaryRow.setAccountDc(account.getDc());
        subsidiaryRow.setEndDC(row.getInteger("entrydc"));
        subsidiaryRow.setCreditLocal(row.getBigDecimal("creditlocal"));
        subsidiaryRow.setDebitLocal(row.getBigDecimal("debitlocal"));
        subsidiaryRow.setEndLocal(subsidiaryRow.getDebitLocal().subtract(subsidiaryRow.getCreditLocal()));
        subsidiaryRow.setBaseCurrency((Long)orgCurLocalMap.get(orgId));
        if (qpRpt.isQueryCurrency()) {
            Long currency = row.getLong("currency");
            subsidiaryRow.setCurrencyId(currency);
            groupKeys.add(currency);
            subsidiaryRow.setDebitFor(row.getBigDecimal("debitfor"));
            subsidiaryRow.setCreditFor(row.getBigDecimal("creditfor"));
            subsidiaryRow.setEndFor(subsidiaryRow.getDebitFor().subtract(subsidiaryRow.getCreditFor()));
        }
        if (qpRpt.isShowQty()) {
            subsidiaryRow.setMeasureUnitId(row.getLong("measureunit"));
            String voucherDc = row.getString("entrydc");
            if (Objects.equals(voucherDc, "1")) {
                subsidiaryRow.setDebitQty(row.getBigDecimal("debitqty"));
            } else {
                subsidiaryRow.setCreditQty(row.getBigDecimal("creditqty"));
            }
            subsidiaryRow.setEndQty(subsidiaryRow.getDebitQty().subtract(subsidiaryRow.getCreditQty()));
        }
        Long period = row.getLong("period");
        subsidiaryRow.setPeriodId(period);
        subsidiaryRow.setPeriodYear(((SubsidiaryPeriod)periodMap.get(period)).getPeriodyear());
        subsidiaryRow.setGroupKey(Joiner.on((String)"_").useForNull("_").join(groupKeys));
        ArrayList<Object> voucherKeys = new ArrayList<Object>(16);
        voucherKeys.add(subsidiaryRow.getPeriodId());
        voucherKeys.add(subsidiaryRow.getBookedDateStr());
        voucherKeys.add(subsidiaryRow.getVtNum());
        voucherKeys.add(subsidiaryRow.getVoucherNo());
        voucherKeys.add(subsidiaryRow.getSeq());
        subsidiaryRow.setVoucherKey(Joiner.on((String)"_").useForNull("_").join(voucherKeys));
        return subsidiaryRow;
    }
}

