/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util.voucher;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ConditionEntryInfo;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.coderule.opplugin.pagecache.BillNoChangeCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.bd.service.balance.VoucherQueryUtils;
import kd.fi.bd.util.BDUtil;
import kd.fi.gl.cache.ThreadCacheKey;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.QFBuilder;

public class VoucherNumberUtils {
    private static final String SELECT_FIELDS = String.join((CharSequence)",", "billno", "id");
    private static final BillNoChangeCache changeCache = new BillNoChangeCache("AbstractCodeRule");
    private static final Set<String> FIXED_SORT_ITEMS = ImmutableSet.of((Object)"org.id", (Object)"booktype.id", (Object)"period.id");

    @Deprecated
    public static Set<Long> checkRepeatNos(Collection<DynamicObject> vouchers) {
        return VoucherNumberUtils.groupByCodeRuleBasis(vouchers).entrySet().stream().flatMap(entry -> VoucherNumberUtils.getExistsNumberVouchers((JSONObject)entry.getKey(), (Collection<DynamicObject>)((Collection)entry.getValue())).stream()).map(v -> v.getLong("id")).collect(Collectors.toSet());
    }

    public static Set<Long> checkRepeatNos(Collection<DynamicObject> vouchers, String status) {
        return VoucherNumberUtils.groupByCodeRule(vouchers, status).entrySet().stream().flatMap(entry -> VoucherNumberUtils.getExistsNumberVouchers((CodeRuleGroupKey)entry.getKey(), (Collection<DynamicObject>)((Collection)entry.getValue())).stream()).map(v -> v.getLong("id")).collect(Collectors.toSet());
    }

    @Deprecated
    public static Map<JSONObject, List<DynamicObject>> groupByCodeRuleBasis(Collection<DynamicObject> vouchers) {
        return vouchers.stream().collect(Collectors.groupingBy(voucherDyn -> {
            CodeRuleInfo codeRuleInfo = VoucherNumberUtils.getCodeRuleInfoWithPriority(voucherDyn.getLong("org.id"));
            Set<String> enhancedSortItems = VoucherNumberUtils.getEnhancedSortItems(codeRuleInfo);
            return VoucherNumberUtils.getGroupByInfos(voucherDyn, enhancedSortItems);
        }));
    }

    public static Map<CodeRuleGroupKey, List<DynamicObject>> groupByCodeRule(Collection<DynamicObject> vouchers, String status) {
        return vouchers.stream().collect(Collectors.groupingBy(voucherDyn -> {
            CodeRuleInfo codeRuleInfo = "A".equalsIgnoreCase(status) ? VoucherNumberUtils.getCodeRuleInfo(voucherDyn.getLong("org.id"), status) : VoucherNumberUtils.getCodeRuleInfoWithPriority(voucherDyn.getLong("org.id"));
            Set<String> enhancedSortItems = VoucherNumberUtils.getEnhancedSortItems(codeRuleInfo);
            return new CodeRuleGroupKey(codeRuleInfo, VoucherNumberUtils.getGroupByInfos(voucherDyn, enhancedSortItems));
        }));
    }

    public static CodeRuleInfo getCodeRuleInfoWithPriority(Long orgId) {
        CodeRuleInfo resultBuf = VoucherNumberUtils.getCodeRuleInfo(orgId, "B");
        if (resultBuf != null) {
            return resultBuf;
        }
        resultBuf = VoucherNumberUtils.getCodeRuleInfo(orgId, "A");
        if (resultBuf != null) {
            return resultBuf;
        }
        return null;
    }

    public static Set<String> getEnhancedSortItems(CodeRuleInfo codeRuleInfo) {
        Set<String> sortItems = VoucherNumberUtils.extractSortItemsFromCodeRuleInfo(codeRuleInfo);
        return VoucherNumberUtils.enhanceSortItems(sortItems);
    }

    private static Set<String> extractSortItemsFromCodeRuleInfo(CodeRuleInfo codeRuleInfo) {
        if (codeRuleInfo == null) {
            return Collections.emptySet();
        }
        return codeRuleInfo.getRuleEntry().stream().filter(entry -> entry.getIsSortItem() != false && VoucherNumberUtils.isBizField(entry)).map(CodeRuleEntryInfo::getValueAtribute).collect(Collectors.toSet());
    }

    private static Set<String> enhanceSortItems(Set<String> originSortItems) {
        HashSet<String> result = new HashSet<String>(originSortItems);
        result.removeIf(attribute -> attribute.startsWith("org.") || attribute.startsWith("booktype.") || attribute.startsWith("peirod."));
        result.addAll(FIXED_SORT_ITEMS);
        return result;
    }

    public static boolean maybeRepeat(DynamicObject voucherDyn, OperateOption option) {
        CodeRuleInfo codeRuleInfo = VoucherNumberUtils.getCodeRuleInfoWithPriority(voucherDyn.getLong("org.id"));
        if (null == codeRuleInfo) {
            return false;
        }
        if (changeCache.isChange(option, voucherDyn.getPkValue())) {
            return true;
        }
        if ("B".equals(voucherDyn.getString("billstatus"))) {
            return false;
        }
        return StreamSupport.stream(voucherDyn.getDataEntityState().getBizChangedProperties().spliterator(), false).noneMatch(prop -> "billno".equals(prop.getName()));
    }

    public static JSONObject getGroupByInfos(DynamicObject voucher, Set<String> sortItems) {
        return sortItems.stream().collect(Collector.of(JSONObject::new, (jsonObj, item) -> {
            Object value = voucher.get(item);
            if (value instanceof OrmLocaleValue) {
                value = ((OrmLocaleValue)value).getLocaleValue();
            }
            jsonObj.put(item, value);
        }, (jsonObj1, jsonObj2) -> {
            jsonObj1.putAll((Map)jsonObj2);
            return jsonObj1;
        }, Collector.Characteristics.CONCURRENT));
    }

    private static boolean isBizField(CodeRuleEntryInfo info) {
        return CodeRuleEntryTypeEnum.getEnums((String)info.getAttributeType()) == CodeRuleEntryTypeEnum.TYPE_DATE_FIELD || CodeRuleEntryTypeEnum.getEnums((String)info.getAttributeType()) == CodeRuleEntryTypeEnum.TYPE_ITEM_FIELD;
    }

    @Deprecated
    public static List<DynamicObject> getExistsNumberVouchers(JSONObject groupByJson, Collection<DynamicObject> vouchers) {
        return VoucherNumberUtils.collectUsedNumbersAndCheckUnique(groupByJson, vouchers, new HashSet<String>(vouchers.size()));
    }

    public static List<DynamicObject> getExistsNumberVouchers(CodeRuleGroupKey groupKey, Collection<DynamicObject> vouchers) {
        return VoucherNumberUtils.collectUsedNumbersAndCheckUnique(groupKey, vouchers, new HashSet<String>(vouchers.size()));
    }

    @Deprecated
    public static List<DynamicObject> collectUsedNumbersAndCheckUnique(JSONObject groupByJson, Collection<DynamicObject> vouchers, Set<String> usedNumbers) {
        ArrayList<DynamicObject> repeatVouchers = new ArrayList<DynamicObject>(vouchers.size());
        ArrayList<DynamicObject> nonRepeatVouchers = new ArrayList<DynamicObject>(vouchers.size());
        for (DynamicObject voucher : vouchers) {
            String number = voucher.getString("billno");
            if (usedNumbers.contains(number)) {
                repeatVouchers.add(voucher);
                continue;
            }
            usedNumbers.add(number);
            nonRepeatVouchers.add(voucher);
        }
        if (!nonRepeatVouchers.isEmpty()) {
            repeatVouchers.addAll(VoucherNumberUtils.getRepeatInDBVouchers(groupByJson, nonRepeatVouchers));
        }
        return repeatVouchers;
    }

    public static List<DynamicObject> collectUsedNumbersAndCheckUnique(CodeRuleGroupKey groupKey, Collection<DynamicObject> vouchers, Set<String> usedNumbers) {
        ArrayList<DynamicObject> repeatVouchers = new ArrayList<DynamicObject>(vouchers.size());
        ArrayList<DynamicObject> nonRepeatVouchers = new ArrayList<DynamicObject>(vouchers.size());
        for (DynamicObject voucher : vouchers) {
            String number = voucher.getString("billno");
            if (usedNumbers.contains(number)) {
                repeatVouchers.add(voucher);
                continue;
            }
            usedNumbers.add(number);
            nonRepeatVouchers.add(voucher);
        }
        if (!nonRepeatVouchers.isEmpty()) {
            repeatVouchers.addAll(VoucherNumberUtils.getRepeatInDBVouchers(groupKey, nonRepeatVouchers));
        }
        return repeatVouchers;
    }

    @Deprecated
    private static List<DynamicObject> getRepeatInDBVouchers(JSONObject basis, Collection<DynamicObject> vouchers) {
        if (!vouchers.isEmpty()) {
            HashSet<String> repeatNos = new HashSet<String>(vouchers.size());
            QFBuilder qfBuilder = VoucherNumberUtils.transJsonToQFBuilder(basis);
            qfBuilder.add("billstatus", "in", (Object)new Object[]{"B", "C", "D"});
            qfBuilder.add("billno", "in", (Object)BDUtil.extractToSet(vouchers, v -> v.getString("billno")));
            Set curBatchIds = BDUtil.extractToSet(vouchers, v -> v.getLong("id"));
            try (DataSet dataSet = VoucherQueryUtils.queryDataSet((String)SELECT_FIELDS, (QFilter[])qfBuilder.toArray(), (String)"", (int)-1);){
                for (Row row : dataSet) {
                    if (curBatchIds.contains(row.getLong("id"))) continue;
                    repeatNos.add(row.getString("billno"));
                }
            }
            return vouchers.stream().filter(v -> repeatNos.contains(v.getString("billno"))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<DynamicObject> getRepeatInDBVouchers(CodeRuleGroupKey groupKey, Collection<DynamicObject> vouchers) {
        if (!vouchers.isEmpty()) {
            if (VoucherNumberUtils.isCheckUnique(groupKey.getCodeRuleInfo())) {
                HashSet<String> repeatNos = new HashSet<String>(vouchers.size());
                QFBuilder qfBuilder = VoucherNumberUtils.transJsonToQFBuilder(groupKey.getGourpInfo());
                if (VoucherNumberUtils.isOnlyForSubmit(groupKey.getCodeRuleInfo())) {
                    qfBuilder.add("billstatus", "in", (Object)new Object[]{"B", "C", "D"});
                }
                qfBuilder.add("billno", "in", (Object)BDUtil.extractToSet(vouchers, v -> v.getString("billno")));
                Set curBatchIds = BDUtil.extractToSet(vouchers, v -> v.getLong("id"));
                try (DataSet dataSet = VoucherQueryUtils.queryDataSet((String)SELECT_FIELDS, (QFilter[])qfBuilder.toArray(), (String)"", (int)-1);){
                    for (Row row : dataSet) {
                        if (curBatchIds.contains(row.getLong("id"))) continue;
                        repeatNos.add(row.getString("billno"));
                    }
                }
                return vouchers.stream().filter(v -> repeatNos.contains(v.getString("billno"))).collect(Collectors.toList());
            }
            return new ArrayList<DynamicObject>(1);
        }
        return Collections.emptyList();
    }

    public static QFBuilder transJsonToQFBuilder(JSONObject groupByJson) {
        return groupByJson.entrySet().stream().collect(Collector.of(QFBuilder::new, (qf, e) -> qf.add((String)e.getKey(), "=", e.getValue()), (qf1, qf2) -> {
            qf1.add(qf2.toList());
            return qf1;
        }, Collector.Characteristics.CONCURRENT));
    }

    public static CodeRuleInfo getCodeRuleInfo(Long orgId, String voucherStatus) {
        CodeRuleInfo result = (CodeRuleInfo)ThreadCache.get((Object)ThreadCacheKey.buildVoucherCodeRuleFindKey((Long)orgId, (String)voucherStatus), () -> CodeRuleServiceHelper.getCodeRule((String)"gl_voucher", (DynamicObject)VoucherNumberUtils.createInterimVoucherDyn(orgId, voucherStatus), (String)orgId.toString()));
        if (result != null) {
            VoucherNumberUtils.checkCodeRule(result);
        }
        return result;
    }

    private static DynamicObject createInterimVoucherDyn(Long orgId, String voucherStatus) {
        DynamicObject tempVchDyn = (DynamicObject)ThreadCache.get((Object)"TempVoucherDynForCodeRule", () -> BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher"));
        tempVchDyn.set("billstatus", (Object)voucherStatus);
        tempVchDyn.set("org", (Object)orgId);
        return tempVchDyn;
    }

    public static void checkCodeRule(CodeRuleInfo codeRuleInfo) {
        boolean legalRule = (Boolean)ThreadCache.get((Object)ThreadCacheKey.buildVoucherCodeRuleLegalityKey((String)codeRuleInfo.getId()), () -> {
            Optional<QFilter> filter = VoucherNumberUtils.parseQFilterFromCondition(codeRuleInfo.getId(), codeRuleInfo.getEnableCondition());
            QFilter qFilter = filter.orElse(null);
            return qFilter == null || Objects.equals(qFilter.getProperty(), "billstatus") && Objects.equals(qFilter.getCP(), "=") && (Objects.equals(qFilter.getValue(), "A") || Objects.equals(qFilter.getValue(), "B")) && qFilter.getNests(false).isEmpty();
        });
        if (!legalRule) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51ed\u8bc1\u7f16\u7801\u89c4\u5219\u7684\u542f\u52a8\u6761\u4ef6\u4ec5\u652f\u6301\u4e00\u884c\u7684\u72b6\u6001\u7b49\u4e8e\u6682\u5b58\u6216\u72b6\u6001\u7b49\u4e8e\u5df2\u63d0\u4ea4\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u7f16\u7801\u89c4\u5219\u540e\u518d\u8bd5\u3002", (String)"VoucherNumberUtils_0", (String)GLApp.instance.commonModule(), (Object[])new Object[0]));
        }
    }

    public static boolean isOnlyForSubmit(CodeRuleInfo codeRuleInfo) {
        if (codeRuleInfo == null) {
            return false;
        }
        return (Boolean)ThreadCache.get((Object)ThreadCacheKey.buildVoucherCodeRuleOnlyForSubmitKey((String)codeRuleInfo.getId()), () -> {
            String enableCondition = codeRuleInfo.getEnableCondition();
            List conditionEntry = codeRuleInfo.getConditionEntry();
            if (VoucherNumberUtils.isForAllStatus(codeRuleInfo)) {
                return false;
            }
            QFilter filter = VoucherNumberUtils.parseQFilterFromCondition(codeRuleInfo.getId(), enableCondition).orElse(null);
            if (filter != null) {
                return Objects.equals(filter.getProperty(), "billstatus") && Objects.equals(filter.getCP(), "=") && Objects.equals(filter.getValue(), "B");
            }
            return Objects.equals(((ConditionEntryInfo)conditionEntry.get(0)).getPropertyValue(), "B");
        });
    }

    public static boolean isForAllStatus(CodeRuleInfo codeRuleInfo) {
        Objects.requireNonNull(codeRuleInfo);
        return !VoucherNumberUtils.parseQFilterFromCondition(codeRuleInfo).isPresent() && codeRuleInfo.getConditionEntry().isEmpty();
    }

    public static boolean isCheckUnique(CodeRuleInfo codeRuleInfo) {
        return codeRuleInfo != null && (VoucherNumberUtils.isOnlyForSubmit(codeRuleInfo) || VoucherNumberUtils.isForAllStatus(codeRuleInfo));
    }

    private static Optional<QFilter> parseQFilterFromCondition(String codeRuleId, String enableCondition) {
        return Optional.ofNullable(ThreadCache.get((Object)ThreadCacheKey.buildVoucherCodeRuleConditionParseKey((String)codeRuleId), () -> {
            if (StringUtils.isBlank((CharSequence)enableCondition)) {
                return null;
            }
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)enableCondition, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"gl_voucher"), filterCondition);
            filterBuilder.buildFilter();
            return filterBuilder.getQFilter();
        }));
    }

    private static Optional<QFilter> parseQFilterFromCondition(CodeRuleInfo codeRuleInfo) {
        return codeRuleInfo == null ? Optional.empty() : VoucherNumberUtils.parseQFilterFromCondition(codeRuleInfo.getId(), codeRuleInfo.getEnableCondition());
    }

    public static class CodeRuleGroupKey {
        private final String codeRuleId;
        private final CodeRuleInfo codeRuleInfo;
        private final JSONObject gourpInfo;

        public CodeRuleGroupKey(CodeRuleInfo codeRuleInfo, JSONObject gourpInfo) {
            this.codeRuleId = codeRuleInfo == null ? null : codeRuleInfo.getId();
            this.codeRuleInfo = codeRuleInfo;
            this.gourpInfo = gourpInfo;
        }

        public CodeRuleInfo getCodeRuleInfo() {
            return this.codeRuleInfo;
        }

        public JSONObject getGourpInfo() {
            return this.gourpInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CodeRuleGroupKey that = (CodeRuleGroupKey)o;
            return Objects.equals(this.codeRuleId, that.codeRuleId) && Objects.equals(this.gourpInfo, that.gourpInfo);
        }

        public int hashCode() {
            return Objects.hash(this.codeRuleId, this.gourpInfo);
        }
    }
}

