/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.antipost;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.constant.voucher.RecordType;
import kd.fi.gl.util.voucher.UnSupportAntiPostUtil;

public class AntiPostInfo {
    private final boolean tenantNew;
    private final boolean strategyNew;

    private AntiPostInfo(boolean tenantNew, boolean strategyNew) {
        this.tenantNew = tenantNew;
        this.strategyNew = strategyNew;
    }

    public static AntiPostInfo getAntiPostInfo() {
        HashMap<String, String> infoMap = new HashMap<String, String>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)UnSupportAntiPostUtil.class.getName(), (String)"gl_antipost_info", (String)"key, value", null, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                infoMap.put(row.getString("key"), row.getString("value"));
            }
        }
        boolean tenantNew = "1".equals(infoMap.getOrDefault("fistenantnew", "0"));
        boolean strategyNew = "1".equals(infoMap.getOrDefault("fstrategymodel", "0"));
        return new AntiPostInfo(tenantNew, strategyNew);
    }

    public boolean isShowNoticeToUser(boolean isList) {
        return (!this.isSupportAntiPost() && this.tenantNew || !this.isSupportAntiPost() && !this.tenantNew && this.strategyNew) && (isList ? this.isNotExistsIgnoreRecord(RecordType.SHOW_LIST_NOTICE) : this.isNotExistsIgnoreRecord(RecordType.SHOW_NOTICE));
    }

    public boolean isSendNoticeToUser() {
        return !this.isSupportAntiPost() && !this.tenantNew && this.strategyNew && this.isNotExistsIgnoreRecord(RecordType.SEND_NOTICE);
    }

    public boolean isSupportAntiPost() {
        return BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.antipost.enable", (boolean)false) || !this.tenantNew && !this.strategyNew;
    }

    private boolean isNotExistsIgnoreRecord(RecordType recordType) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(8);
        filterList.add(new QFilter("user", "=", (Object)RequestContext.getOrCreate().getCurrUserId()));
        filterList.add(new QFilter("recordtype", "=", (Object)recordType.getValue()));
        filterList.add(new QFilter("isfinish", "=", (Object)true));
        return !QueryServiceHelper.exists((String)"gl_user_operation_record", (QFilter[])filterList.toArray(new QFilter[3]));
    }
}

