/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.flex.FlexService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.autotrans.AutoTransType;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistTableService;
import kd.fi.gl.constant.basedata.AssistantDataDetailConstant;
import kd.fi.gl.constant.basedata.AsstactTypeConstant;
import kd.fi.gl.constant.basedata.BaseDataConstant;
import kd.fi.gl.enums.AutoTransAmtTypeEnum;
import kd.fi.gl.enums.AutoTransQtyTypeEnum;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.finalprocess.constant.AutoTransConstant;
import kd.fi.gl.finalprocess.info.ExpressionInfo;
import kd.fi.gl.finalprocess.info.scheme.AutoTransScheme;
import kd.fi.gl.finalprocess.info.scheme.DynamicEntity;
import kd.fi.gl.finalprocess.info.scheme.PropertyKey;
import kd.fi.gl.finalprocess.service.impl.AutoTransService;
import kd.fi.gl.formplugin.FPFormUtil;
import kd.fi.gl.formplugin.finalprocess.AutoTransEditHelper;
import kd.fi.gl.formplugin.finalprocess.FPAssgrpDescLengthConfig;
import kd.fi.gl.formplugin.finalprocess.autotrans.AutoTransEditFilterService;
import kd.fi.gl.formplugin.finalprocess.autotrans.EditView;
import kd.fi.gl.util.AutoTransUtil;
import kd.fi.gl.util.BcmRptHelper;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.GLFabulousOperation;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.PeriodEndingSolveUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.ValidateUtils;

public class AutoTransEditPlugin
extends AbstractBillPlugIn
implements ClickListener {
    private static final String OPTION_KEY_ORG = "option-key-org";
    private static final String CACHE_KEY_DATADELROWIDS = "pagecahce-datadelrow-list";
    private static final String CACHE_KEY_ASSGRPDELROWIDS = "pagecahce-assgrpdelrow-list";
    private static final String CACHE_KEY_PERCENTDELROWIDS = "pagecahce-percentdelrow-list";
    private static final String CACHE_KEY_DATAEXP = "pagecahce-dataexp-map";
    private static final String CACHE_KEY_ASSGRPEXP = "pagecahce-assgrpexp-map";
    private static final String ASSGRPEXP_ROWID_KEY = "assgrprow";
    private static final String DATAEXP_ROWID_KEY = "autorowid";
    private static final String Key_DataExpDesc = "dataexedesc";
    private static final String QTY_FORMULA_SHOW = "qtyformulashow";
    private static final String formId = "gl_autotrans";
    private static final String ENTITY_ASSGRP = "gl_finalprocess_assgrp";
    private static final String ENTITY_DATAEXP = "gl_autotransexpression";
    private static final String Key_Entryentity = "autotransentry";
    private static final String orgKey = "org";
    private static final String assgrpType = "assisttranstype";
    private static final String dataType = "datasourcetype";
    private static final String assgrpKey = "assgrp";
    private static final String accountKey = "accountid";
    private static final String Key_Rowid = "autorowid";
    private static final String Key_PercentExpDesc = "percentdesc";
    private static final String Key_Orgid = "org_id";
    private static final String Key_Booktyepid = "bookstype_id";
    private static final String Key_PercentExp = "percentexp";
    private static final String Key_PercentType = "percenttype";
    private static final String Key_Percent = "percent";
    private static final String protransferout = "5";
    private static final String protransferin = "6";
    private static final String Key_BookType = "bookstype";
    private static final String Key_Confirm_ChangeBookType = "changeBookType";
    private static final String CacheKey_NewBookType = "newBookId";
    private static final String CacheKey_OldBookType = "oldBookId";
    private static final String Key_TranType = "transfertype";
    private static final String ENTRY_QTY = "qty";
    private static final String ENTRY_PRICE = "price";
    private Map<String, Long> orgMap = new HashMap<String, Long>();
    private Map<String, Long> bookTypeMap = new HashMap<String, Long>();
    private boolean isPropertyChanged = true;

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection coll = this.getModel().getEntryEntity(Key_Entryentity);
        for (DynamicObject row : coll) {
            String rowId = row.getString("autorowid");
            DynamicObject assgrpDyn = FPFormUtil.queryFinalProcessAssgrpDyn((String)rowId, (Long)((Long)this.getModel().getValue(Key_Orgid)));
            if (assgrpDyn != null) {
                String desc = FPFormUtil.getDesc((DynamicObjectCollection)assgrpDyn.getDynamicObjectCollection("entryentity"), (FPAssgrpDescLengthConfig)FPAssgrpDescLengthConfig.fromProperty((String)formId));
                row.set(assgrpKey, (Object)desc);
                continue;
            }
            row.set(assgrpKey, (Object)"");
        }
    }

    private Tuple2<Long, Map<Long, Long>> getBookTypesByOrg(long orgId) {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        long mainBookstype = 0L;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.accsys.AccSysUtil.getBookTypesByOrg", (String)"gl_accountbook", (String)"bookstype, defaultvouchertype, bookstype.accounttype", (QFilter[])new QFilter[]{new QFilter(orgKey, "=", (Object)orgId), new QFilter("isbizunit", "=", (Object)"1")}, (String)"bookstype.accounttype").groupBy(new String[]{Key_BookType, "defaultvouchertype", "bookstype.accounttype"}).finish();){
            for (Row row : ds) {
                long bookstype = row.getLong(Key_BookType);
                long vouchertype = row.getLong("defaultvouchertype");
                if ("1".equals(row.getString("bookstype.accounttype"))) {
                    mainBookstype = bookstype;
                }
                result.put(bookstype, vouchertype);
            }
        }
        return new Tuple2((Object)mainBookstype, result);
    }

    private void setDefaultValueByOrg(long orgId, boolean setDefaultBook) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Tuple2<Long, Map<Long, Long>> bookTypesByOrg = this.getBookTypesByOrg(orgId);
        if (!((Map)bookTypesByOrg.t2).isEmpty()) {
            String changeBook;
            Set bookTypes;
            Object customBookType = view.getFormShowParameter().getCustomParam(Key_BookType);
            long defaultBookTypeId = 0L;
            if (customBookType != null) {
                defaultBookTypeId = Long.parseLong(customBookType.toString());
            }
            boolean isMulBookType = (bookTypes = ((Map)bookTypesByOrg.t2).keySet()).size() > 1;
            view.setVisible(Boolean.valueOf(isMulBookType), new String[]{Key_BookType});
            if (!bookTypes.contains(defaultBookTypeId) && (defaultBookTypeId = ((Long)bookTypesByOrg.t1).longValue()) == 0L) {
                defaultBookTypeId = (Long)bookTypes.iterator().next();
            }
            if (setDefaultBook && StringUtils.isNotBlank((CharSequence)(changeBook = this.getPageCache().get(CacheKey_NewBookType)))) {
                defaultBookTypeId = Long.parseLong(changeBook);
            }
            model.setValue(Key_BookType, (Object)defaultBookTypeId);
            model.setValue("vouchertypeid", ((Map)bookTypesByOrg.t2).get(defaultBookTypeId));
        } else {
            view.setVisible(Boolean.TRUE, new String[]{Key_BookType});
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u8bbe\u7f6e\u8d26\u7c3f\u3002", (String)"AutoTransEditPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        String key;
        Object orgNumber;
        Map bookTypeMap;
        Map orgMap;
        super.initImportData(e);
        List data = e.getSourceDataList();
        HashMap searchMap = new HashMap();
        HashMap<String, AccountBookInfo> bookInfoMap = new HashMap<String, AccountBookInfo>();
        for (Map map : data) {
            List entryList = (List)map.get(Key_Entryentity);
            HashMap accountMap = new HashMap(entryList.size());
            for (Map entrymap : entryList) {
                Map accounts = (Map)entrymap.get(accountKey);
                accountMap.put("number-" + (String)accounts.get("number"), accounts.get("number"));
            }
            orgMap = (Map)map.get(orgKey);
            bookTypeMap = (Map)map.get(Key_BookType);
            if (accountMap == null || orgMap == null || bookTypeMap == null) continue;
            for (Map.Entry entry : accountMap.entrySet()) {
                orgNumber = (String)orgMap.get("number");
                String btNumber = (String)bookTypeMap.get("number");
                String acctNumber = (String)entry.getValue();
                key = (String)orgNumber + "-" + btNumber;
                if (searchMap.containsKey(key)) {
                    ((Set)searchMap.get(key)).add(acctNumber);
                    continue;
                }
                AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((String)orgNumber, (String)btNumber);
                if (bookInfo == null) continue;
                bookInfoMap.put(key, bookInfo);
                HashSet<String> acctSet = new HashSet<String>();
                acctSet.add(acctNumber);
                searchMap.put(key, acctSet);
            }
        }
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        for (Map.Entry entry : searchMap.entrySet()) {
            String key2 = (String)entry.getKey();
            AccountBookInfo bookInfo = (AccountBookInfo)bookInfoMap.get(key2);
            Set acctSet = (Set)entry.getValue();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            if (bookInfo != null) {
                long l = AccountRefUtils.getCurPeriodAccountTableId((long)bookInfo.getOrgId(), (long)bookInfo.getBookTypeId(), (long)bookInfo.getCurPeriodId());
                QFBuilder qfBuilder = new QFBuilder();
                DynamicObject periodDO = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)bookInfo.getCurPeriodId()).toArray());
                if (null == periodDO) {
                    qfBuilder.add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
                } else {
                    Date date = periodDO.getDate("enddate");
                    qfBuilder.add("startdate", "<=", (Object)date);
                    qfBuilder.add("enddate", ">", (Object)date);
                }
                qfBuilder.add("number", "in", (Object)acctSet);
                QFilter qids = AccountUtils.getAccountDataFilter((long)bookInfo.getOrgId(), (long)l, (List)qfBuilder.toList());
                filters.add(qids);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)(this.getPluginName() + "initImportData"), (String)"bd_accountview", (String)"id,number", (QFilter[])filters.toArray(new QFilter[0]), null);
            orgNumber = null;
            try {
                if (dataSet == null) continue;
                for (Row row : dataSet) {
                    Long id = row.getLong("id");
                    String number = row.getString("number");
                    resultMap.put(key2 + number, id);
                }
            }
            catch (Throwable qfBuilder) {
                orgNumber = qfBuilder;
                throw qfBuilder;
            }
            finally {
                if (dataSet == null) continue;
                if (orgNumber != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable qfBuilder) {
                        ((Throwable)orgNumber).addSuppressed(qfBuilder);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        for (Map map : data) {
            List entryList = (List)map.get(Key_Entryentity);
            orgMap = (Map)map.get(orgKey);
            bookTypeMap = (Map)map.get(Key_BookType);
            if (orgMap == null || bookTypeMap == null) continue;
            for (Map map2 : entryList) {
                Map accounts = (Map)map2.get(accountKey);
                String orgNumber2 = (String)orgMap.get("number");
                String btNumber = (String)bookTypeMap.get("number");
                key = orgNumber2 + "-" + btNumber + accounts.get("number");
                Long id = (Long)resultMap.get(key);
                if (id == null || id == 0L) continue;
                accounts.put("id", id);
                map2.put(accountKey, accounts);
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map data = e.getSourceData();
        Map org = (Map)data.get(orgKey);
        String orgnumber = (String)org.get("number");
        Long orgId = this.orgMap.computeIfAbsent(orgnumber, orgNumber -> ValidateUtils.checkLegalOrg((String)orgnumber));
        Map booktype = (Map)data.get(Key_BookType);
        String bookTypeNumber = (String)booktype.get("number");
        Long bookTypeId = this.bookTypeMap.get(bookTypeNumber);
        if (bookTypeId == null) {
            DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)bookTypeNumber).toArray());
            if (null == bookTypeDyn) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"AutoTransEditPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]), bookTypeNumber));
            }
            bookTypeId = bookTypeDyn.getLong("id");
            this.bookTypeMap.put(bookTypeNumber, bookTypeId);
        }
        QFilter orgFilter = new QFilter(orgKey, "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter(Key_BookType, "=", (Object)bookTypeId);
        boolean existBook = QueryServiceHelper.exists((String)"gl_accountbook", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter});
        if (!existBook) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"AutoTransEditPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]), orgnumber));
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel m = this.getModel();
        AutoTransScheme autoTransScheme = new AutoTransScheme(this.getModel().getDataEntity());
        Date curAcctDate = autoTransScheme.getCurPeriodEndDate();
        DynamicObjectCollection entrys = m.getEntryEntity(Key_Entryentity);
        int index = 0;
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> assistList = new ArrayList<DynamicObject>();
        BigDecimal hundred = new BigDecimal("100");
        Set notIncludeFlexField = AutoTransEditHelper.analyzeAccountAssgrp((DynamicObjectCollection)entrys);
        for (DynamicObject entry : entrys) {
            Object billno = m.getValue("billno");
            this.rebuildRptSetup(billno.toString(), ++index, entry, curAcctDate);
            String percent = entry.getString(Key_Percent);
            if (StringUtils.isEmpty((CharSequence)percent) || !percent.endsWith("%")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u7684\u8f6c\u8d26\u6bd4\u4f8b\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"AutoTransEditPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), billno, index));
            }
            try {
                String percentStr = percent.substring(0, percent.length() - 1);
                BigDecimal perentDecimalVal = new BigDecimal(percentStr);
                if (perentDecimalVal.compareTo(BigDecimal.ZERO) <= 0 || perentDecimalVal.compareTo(hundred) > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u7684\u8f6c\u8d26\u6bd4\u4f8b\u4e0d\u57280-100\u4e4b\u95f4", (String)"AutoTransEditPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]), billno, index));
                }
            }
            catch (Exception e2) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u7684\u8f6c\u8d26\u6bd4\u4f8b\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"AutoTransEditPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]), billno, index));
            }
            String datasourcetype = entry.getString(dataType);
            String expStr = entry.getString("autorowid");
            String autorowid = this.getRowId();
            Long accountId = entry.getLong("accountid.id");
            List<Long> assists = AutoTransEditPlugin.queryAccountAssist(accountId);
            if (AutoTransEditHelper.canSetAssgrp((DynamicObject)((DynamicObject)m.getValue(accountKey, index - 1)), (String)((String)m.getValue(assgrpType, index - 1)), (String)((String)m.getValue(dataType, index - 1)), (Set)notIncludeFlexField)) {
                Map<String, Object> result;
                Object value;
                String assgrp = entry.getString(assgrpKey);
                if (!StringUtils.isEmpty((CharSequence)assgrp) && (value = (result = this.newAmortassgrp(assgrp, assists, index, m, autorowid)).get("dyn")) != null) {
                    assistList.add((DynamicObject)value);
                    m.setValue(assgrpKey, result.get("msg"), index - 1);
                }
            } else {
                m.setValue(assgrpKey, null, index - 1);
            }
            m.setValue("autorowid", (Object)autorowid, index - 1);
            if (!protransferout.equals(datasourcetype) && !protransferin.equals(datasourcetype)) continue;
            if (!StringUtils.isEmpty((CharSequence)expStr)) {
                Map<String, Object> result = this.createExpressDynamic(m, expStr, index, autorowid);
                if (((Boolean)result.get("isright")).booleanValue()) {
                    list.add((DynamicObject)result.get("dyn"));
                    continue;
                }
                throw new KDBizException((String)result.get("errormsg"));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u4e0d\u5b58\u5728\u8868\u8fbe\u5f0f", (String)"AutoTransEditPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]), billno, index));
        }
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ENTITY_DATAEXP), (Object[])list.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)ENTITY_ASSGRP), (Object[])assistList.toArray(new DynamicObject[0]));
    }

    private void rebuildRptSetup(String billNo, int index, DynamicObject entryRow, Date curAcctDate) {
        String qtyfrom;
        AutoTransQtyTypeEnum qtyType;
        String datasourcetype = entryRow.getString(dataType);
        AutoTransAmtTypeEnum amtType = AutoTransAmtTypeEnum.valueOfHash((String)datasourcetype);
        if (AutoTransAmtTypeEnum.TRANS_OUT_RPT_VALUE == amtType || AutoTransAmtTypeEnum.TRANS_IN_RPT_VALUE == amtType) {
            entryRow.set("rptexp", (Object)this.rebuildRptStr(billNo, index, entryRow.getString("rptexp"), curAcctDate));
        }
        if (AutoTransQtyTypeEnum.report == (qtyType = AutoTransQtyTypeEnum.valueOfHash((String)(qtyfrom = entryRow.getString("qtyfrom"))))) {
            entryRow.set("qtyrptexp", (Object)this.rebuildRptStr(billNo, index, entryRow.getString("qtyrptexp"), curAcctDate));
        }
    }

    private String rebuildRptStr(String billNo, int index, String inputRptStr, Date curAcctDate) {
        String res = "";
        if (StringUtils.isNotBlank((CharSequence)inputRptStr)) {
            res = this.doRebuildRptStr(inputRptStr, curAcctDate);
            if (StringUtils.isBlank((CharSequence)res)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u7684\u62a5\u8868\u8bbe\u7f6e\u9519\u8bef", (String)"AutoTransEditPlugin_35", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\uff1a%1$s\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u7684\u62a5\u8868\u8bbe\u7f6e\u9519\u8bef", (String)"AutoTransEditPlugin_35", (String)"fi-gl-formplugin", (Object[])new Object[0]), billNo, index));
        }
        return res;
    }

    private String doRebuildRptStr(String inputRptStr, Date curAcctDate) {
        String res = "";
        Long modelID = 0L;
        Long sceneID = 0L;
        Long templateID = 0L;
        String position = "";
        for (String dimension : inputRptStr.split(";")) {
            String[] typeArr = dimension.split(":", 2);
            if (typeArr.length != 2 && !dimension.equals("position")) {
                return res;
            }
            if ("model".equals(typeArr[0])) {
                modelID = BcmRptHelper.findModelIDByNumber((String)typeArr[1]);
            }
            if ("scene".equals(typeArr[0])) {
                sceneID = BcmRptHelper.findScenarioIDByModelNumber((Long)modelID, (String)typeArr[1]);
            }
            if ("template".equals(typeArr[0])) {
                templateID = BcmRptHelper.findTemplateID((Long)modelID, (String)typeArr[1], (Date)curAcctDate);
            }
            if (!"position".equals(typeArr[0])) continue;
            position = typeArr[1];
        }
        if (modelID.equals(0L) || sceneID.equals(0L) || templateID.equals(0L)) {
            return res;
        }
        HashMap<String, String> rptSetup = new HashMap<String, String>(4);
        rptSetup.put("templateid", templateID.toString());
        rptSetup.put("modelid", modelID.toString());
        rptSetup.put("scenarioid", sceneID.toString());
        rptSetup.put("position", position);
        return SerializationUtils.serializeToBase64(rptSetup);
    }

    private Map<String, Object> newAmortassgrp(String assgrp, List<Long> assists, int index, IDataModel m, String autorowid) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String[] assgrpArray = assgrp.split(";");
        HashMap<String, String[]> map = new HashMap<String, String[]>(assgrpArray.length);
        ArrayList<String> assgrpName = new ArrayList<String>(assgrpArray.length);
        for (int i = 0; i < assgrpArray.length; ++i) {
            String[] keyValue = assgrpArray[i].split(":");
            if (keyValue.length != 2) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u6838\u7b97\u7ef4\u5ea6\u586b\u5199\u4e0d\u6b63\u786e", (String)"AutoTransEditPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
            }
            String[] values = keyValue[1].split(",");
            map.put(keyValue[0], values);
            assgrpName.add(keyValue[0]);
        }
        ArrayList<QFilter> list = new ArrayList<QFilter>(2);
        list.add(new QFilter("id", "in", assists));
        list.add(new QFilter("name", "in", assgrpName));
        List asstactTypeEntityList = new AsstactTypeConstant().loadEntity(list, new PropertyKey[]{AsstactTypeConstant.Entity_ID, AsstactTypeConstant.Entity_Name, AsstactTypeConstant.Entity_Number, AsstactTypeConstant.Entity_BaseDataType, AsstactTypeConstant.Entity_AssistantType, AsstactTypeConstant.Entity_ValueType});
        if (!asstactTypeEntityList.isEmpty()) {
            int count = 0;
            MainEntityType autoExpEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_ASSGRP);
            DynamicObject assgrpEntity = (DynamicObject)autoExpEntityType.createInstance();
            assgrpEntity.set(orgKey, m.getValue(orgKey));
            assgrpEntity.set(ASSGRPEXP_ROWID_KEY, (Object)autorowid);
            for (DynamicEntity asstactTypeEntity : asstactTypeEntityList) {
                String asstactTypeName = asstactTypeEntity.getLocalString(AsstactTypeConstant.Entity_Name);
                CharSequence[] asstactValueNumber = (String[])map.get(asstactTypeName);
                QFilter numberFilter = AssistantDataDetailConstant.Entity_Number.getFilter("in", (Object)asstactValueNumber);
                String valueSource = asstactTypeEntity.getInnerString(new PropertyKey[]{AsstactTypeConstant.Entity_BaseDataType, BaseDataConstant.Entity_Number});
                String valueType = asstactTypeEntity.getString(AsstactTypeConstant.Entity_ValueType);
                switch (AssistValueType.getTypeEnum((String)valueType)) {
                    case baseData: {
                        Optional<QFilter> baseDataF = Optional.ofNullable(BaseDataServiceHelper.getBaseDataFilter((String)valueSource, (Long)((Long)m.getValue(Key_Orgid))));
                        baseDataF.ifPresent(arg_0 -> ((QFilter)numberFilter).and(arg_0));
                        break;
                    }
                    case assistData: {
                        valueSource = "bos_assistantdata_detail";
                        numberFilter.and(AssistantDataDetailConstant.Entity_Group.getFilter("=", (Object)asstactTypeEntity.getLong(AsstactTypeConstant.Entity_AssistantType)));
                        break;
                    }
                    case manualTxt: {
                        break;
                    }
                    case none: {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6%1$s\u7684\u503c\u7c7b\u578b\u4e3a\u975e\u6807\u51c6\u7c7b\u578b\u3002", (String)"AutoTransEditPlugin_36", (String)"fi-gl-formplugin", (Object[])new Object[0]), asstactTypeName));
                    }
                }
                DynamicObjectCollection entrys = assgrpEntity.getDynamicObjectCollection("entryentity");
                DynamicObject row = entrys.addNew();
                row.set("fieldname", (Object)asstactTypeEntity.getLong(AsstactTypeConstant.Entity_ID));
                if (AssistValueType.isManualTxt((String)valueType)) {
                    row.set("txtval", (Object)String.join((CharSequence)"\n", asstactValueNumber));
                } else {
                    DynamicObjectCollection multiBaseDataValueEntry = row.getDynamicObjectCollection("value");
                    DynamicObjectCollection assistItemValueDOC = QueryServiceHelper.query((String)valueSource, (String)"id,name,number", (QFilter[])new QFilter[]{numberFilter});
                    for (DynamicObject assistItemValue : assistItemValueDOC) {
                        assgrp = assgrp.replace(assistItemValue.getString("number"), assistItemValue.getString("name"));
                        DynamicObject mulBaseRow = new DynamicObject(multiBaseDataValueEntry.getDynamicObjectType());
                        mulBaseRow.set("fbasedataid", assistItemValue.get("id"));
                        multiBaseDataValueEntry.add((Object)mulBaseRow);
                    }
                }
                ++count;
            }
            if (count > 0) {
                result.put("dyn", assgrpEntity);
                result.put("msg", assgrp);
            }
        }
        return result;
    }

    private void dealExpComAssist(DynamicObject autoExpEntity, String expStr, List<CommonAssist> commonAssists) {
        String[] items = expStr.split(",");
        for (int i = 0; i < commonAssists.size(); ++i) {
            String comAssistValue = items[i + 7];
            CommonAssist commonAssist = commonAssists.get(i);
            String comAssistKey = "comassist" + (i + 1);
            if ("null".equals(comAssistValue) || comAssistValue.split(":").length != 2) continue;
            String[] comAssist1Split = comAssistValue.split(":");
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("number", "in", (Object)comAssist1Split[1].split(";")));
            if (AssistValueType.isAssistData((String)commonAssist.valueSourceType)) {
                qfBuilder.add(new QFilter("group", "=", (Object)commonAssist.assistType));
            }
            if (AssistValueType.isManualTxt((String)commonAssist.valueSourceType)) {
                autoExpEntity.set(comAssistKey, (Object)comAssistValue);
            }
            DataSet comAssistDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.formplugin.AutoTransEditPlugin.dealComAssist", (String)commonAssist.valueSource, (String)"id", (QFilter[])qfBuilder.toArray(), null);
            ArrayList<Object> res = new ArrayList<Object>();
            for (Row row : comAssistDataSet) {
                res.add(row.getLong("id"));
            }
            this.comAssistToDyn(comAssistKey, autoExpEntity, res);
        }
    }

    private void comAssistToDyn(String comAssistKey, DynamicObject autoExpEntity, List<Object> values) {
        for (Object value : values) {
            DynamicObjectCollection comAssist = autoExpEntity.getDynamicObjectCollection(comAssistKey);
            DynamicObject mulBaseRow = new DynamicObject(comAssist.getDynamicObjectType());
            mulBaseRow.set("fbasedataid", value);
            comAssist.add((Object)mulBaseRow);
        }
    }

    private Map<String, Object> createExpressDynamic(IDataModel m, String expStr, int index, String autorowid) {
        String assist;
        String amounttype;
        int exceptLength;
        MainEntityType autoExpEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_DATAEXP);
        DynamicObject autoExpEntity = (DynamicObject)autoExpEntityType.createInstance();
        Long orgId = (Long)m.getValue(Key_Orgid);
        Long booksTypeId = (Long)m.getValue(Key_Booktyepid);
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)booksTypeId);
        long curPeriodAccountTableId = AccSysUtil.getCurPeriodAccountTableId((long)accountBookInfo.getOrgId(), (long)accountBookInfo.getBookTypeId(), (long)accountBookInfo.getCurPeriodId());
        List commonAssists = ComAssistTable.get((Long)curPeriodAccountTableId).getCommonAssists();
        ExpressionInfo expressionInfo = new ExpressionInfo(expStr, !commonAssists.isEmpty());
        int n = exceptLength = commonAssists.isEmpty() ? expressionInfo.getNormLength() : expressionInfo.getNormLength() + commonAssists.size();
        if (expStr.split(",").length != exceptLength) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u683c\u5f0f\u6709\u8bef\u3002", (String)"AutoTransEditPlugin_8", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
        }
        autoExpEntity.set(orgKey, (Object)orgId);
        autoExpEntity.set("autorowid", (Object)autorowid);
        expressionInfo.fillExpComAssist(autoExpEntity, commonAssists);
        AutoTransService autoTransService = new AutoTransService(new AutoTransScheme(this.getModel().getDataEntity(true)));
        QFBuilder qfBuilder = autoTransService.getAccountFilterInVersion(new QFilter("number", "=", (Object)expressionInfo.getAccountNum()), false);
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (String)"id,acctcurrency,measureunit,measureunitgroup,isqty,isassist,currencyentry,currencyentry.currency", (QFilter[])qfBuilder.toArray());
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        if (account == null) {
            map.put("errormsg", String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u79d1\u76ee\u7f16\u7801\u586b\u5199\u6709\u8bef\u3002", (String)"AutoTransEditPlugin_9", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
            map.put("isright", Boolean.FALSE);
            return map;
        }
        autoExpEntity.set("account", (Object)account.getLong("id"));
        String currencyNumber = expressionInfo.getCurrencyNum();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
        if (StringUtils.isEmpty((CharSequence)currencyNumber) || "null".equalsIgnoreCase(currencyNumber)) {
            String dsType;
            Object dsTypeObj = this.getModel().getValue(dataType, index - 1);
            String string = dsType = dsTypeObj == null ? "" : String.valueOf(dsTypeObj);
            if (AutoTransType.mustInputCurrency((String)dsType)) {
                map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u7684\u672a\u586b\u5199\u5e01\u79cd\u3002", (String)"AutoTransEditPlugin_10", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
                map.put("isright", Boolean.FALSE);
                return map;
            }
        } else {
            if ("descurrency".equals(account.getString("acctcurrency"))) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (Object dyn : account.getDynamicObjectCollection("currencyentry")) {
                    Long acctCur = dyn.getLong("currency_id");
                    ids.add(acctCur);
                }
                qfilters.add(new QFilter("id", "in", ids));
            } else {
                qfilters.add(new QFilter("number", "=", (Object)currencyNumber));
            }
            DynamicObjectCollection currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id,number", (QFilter[])qfilters.toArray(new QFilter[0]));
            if (currencys.isEmpty()) {
                map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u7684\u5e01\u79cd\u4e0d\u6b63\u786e\u3002", (String)"AutoTransEditPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
                map.put("isright", Boolean.FALSE);
                return map;
            }
            boolean flag = false;
            for (DynamicObject dyn : currencys) {
                if (!currencyNumber.equals(dyn.getString("number"))) continue;
                flag = true;
                autoExpEntity.set("currency", (Object)dyn.getLong("id"));
                break;
            }
            if (!flag) {
                map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u7684\u5e01\u79cd\u4e0d\u6b63\u786e\u3002", (String)"AutoTransEditPlugin_11", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
                map.put("isright", Boolean.FALSE);
                return map;
            }
        }
        if (account.getBoolean("isqty")) {
            String unit = expressionInfo.getUnitNum();
            if (StringUtils.isEmpty((CharSequence)unit)) {
                map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u672a\u586b\u5199\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"AutoTransEditPlugin_12", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
                map.put("isright", Boolean.FALSE);
                return map;
            }
            String qty = expressionInfo.getQty();
            if (StringUtils.isEmpty((CharSequence)qty)) {
                map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u7684\u672a\u586b\u5199\u6570\u91cf\u3002", (String)"AutoTransEditPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
                map.put("isright", Boolean.FALSE);
                return map;
            }
            try {
                Integer.parseInt(qty);
            }
            catch (Exception e) {
                map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u7684\u6570\u91cf\u4e0d\u6b63\u786e\u3002", (String)"AutoTransEditPlugin_14", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
                map.put("isright", Boolean.FALSE);
                return map;
            }
            long measureunitgroupid = account.getLong("measureunitgroup_id");
            qfilters.clear();
            qfilters.add(new QFilter("number", "=", (Object)unit));
            if (measureunitgroupid != 0L) {
                qfilters.add(new QFilter("group.id", "=", (Object)measureunitgroupid));
            }
            DynamicObjectCollection units = QueryServiceHelper.query((String)"bd_measureunits", (String)"id,number", (QFilter[])qfilters.toArray(new QFilter[0]));
            if (!"null".equals(unit) || StringUtils.isEmpty((CharSequence)unit)) {
                if (units.isEmpty()) {
                    map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u7684\u8ba1\u91cf\u5355\u4f4d\u4e0d\u6b63\u786e\u3002", (String)"AutoTransEditPlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
                    map.put("isright", Boolean.FALSE);
                    return map;
                }
                boolean flag = false;
                for (DynamicObject dyn : units) {
                    if (!unit.equals(dyn.getString("number"))) continue;
                    flag = true;
                    autoExpEntity.set("unit", (Object)dyn.getLong("id"));
                    break;
                }
                if (!flag) {
                    map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u7684\u8ba1\u91cf\u5355\u4f4d\u4e0d\u6b63\u786e\u3002", (String)"AutoTransEditPlugin_15", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
                    map.put("isright", Boolean.FALSE);
                    return map;
                }
            }
            autoExpEntity.set(ENTRY_QTY, (Object)qty);
        }
        if (StringUtils.isEmpty((CharSequence)(amounttype = expressionInfo.getAmountType()))) {
            map.put("errormsg", String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u672a\u586b\u5199\u91d1\u989d\u7c7b\u578b\u3002", (String)"AutoTransEditPlugin_16", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
            map.put("isright", Boolean.FALSE);
            return map;
        }
        if (!("1".equals(amounttype) || "2".equals(amounttype) || "3".equals(amounttype))) {
            map.put("errormsg", String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff08\u7f16\u7801\uff1a%1$s\uff09\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u7684\u91d1\u989d\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"AutoTransEditPlugin_17", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
            map.put("isright", Boolean.FALSE);
            return map;
        }
        autoExpEntity.set("amounttype", (Object)amounttype);
        boolean isassist = account.getBoolean("isassist");
        if (isassist && !StringUtils.isEmpty((CharSequence)(assist = expressionInfo.getAssgrp())) && assist.indexOf(58) != -1) {
            String[] assistArray = assist.split("\\|");
            Long assistId = this.buildAssistId(assistArray, index, m);
            autoExpEntity.set(assgrpKey, (Object)assistId);
        }
        String periodRange = expressionInfo.getPeriodRange();
        Optional<String> optionalPeriodRange = IntStream.range(0, 5).boxed().map(Object::toString).filter(range -> range.equals(periodRange)).findAny();
        if (!optionalPeriodRange.isPresent()) {
            map.put("errormsg", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u7684\u671f\u95f4\u8303\u56f4\u6709\u8bef\u3002", (String)"AutoTransEditPlugin_118", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
            map.put("isright", Boolean.FALSE);
            return map;
        }
        autoExpEntity.set("periodRange", (Object)periodRange);
        map.put("isright", Boolean.TRUE);
        map.put("dyn", autoExpEntity);
        return map;
    }

    private Long buildAssistId(String[] assistArray, int index, IDataModel m) {
        Long assistId = 0L;
        ArrayList<String> assist = new ArrayList<String>(assistArray.length);
        HashMap<String, String> itemNameMap = new HashMap<String, String>(assistArray.length);
        for (int i = 0; i < assistArray.length; ++i) {
            String[] items = assistArray[i].split(":");
            if (items == null || items.length != 2) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u6a21\u677f\u7b2c%2$s\u6761\u5206\u5f55\u8868\u8fbe\u5f0f\u586b\u5199\u6838\u7b97\u7ef4\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AutoTransEditPlugin_18", (String)"fi-gl-formplugin", (Object[])new Object[0]), m.getValue("billno"), index));
            }
            assist.add(items[0]);
            itemNameMap.put(items[0], items[1]);
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_asstacttype", (String)"valuesource,name,flexfield", (QFilter[])new QFilter("name", "in", assist).toArray(), (String)"index");
        LinkedHashMap<String, String> itemNumberMap = new LinkedHashMap<String, String>(collection.size());
        HashMap<String, String> flexfieldMap = new HashMap<String, String>(collection.size());
        for (DynamicObject dyn : collection) {
            itemNumberMap.put(dyn.getString("name"), dyn.getString("valuesource"));
            flexfieldMap.put(dyn.getString("name"), dyn.getString("flexfield"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>(itemNumberMap.size());
        for (Map.Entry entry : itemNumberMap.entrySet()) {
            String name = (String)entry.getKey();
            String number = (String)entry.getValue();
            if (!StringUtils.isEmpty((CharSequence)number)) {
                DynamicObject dyn = QueryServiceHelper.queryOne((String)number, (String)"id", (QFilter[])new QFilter("number", "=", itemNameMap.get(name)).toArray());
                if (dyn == null) continue;
                map.put((String)flexfieldMap.get(name), dyn.get("id"));
                continue;
            }
            map.put((String)flexfieldMap.get(name), itemNameMap.get(name));
        }
        assistId = AutoTransEditPlugin.rebuildAssgrpId(map);
        return assistId;
    }

    private static List<Long> queryAccountAssist(Long accountId) {
        ArrayList<Long> idList = new ArrayList<Long>();
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem asstactitem", (QFilter[])new QFilter("id", "=", (Object)accountId).toArray());
        for (DynamicObject dyn : dyns) {
            idList.add(dyn.getLong("asstactitem"));
        }
        idList.remove(0L);
        return idList;
    }

    private static Long rebuildAssgrpId(Map<String, Object> flexFieldValueMap) {
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
        FlexEntireData flexEntireData = new FlexEntireData();
        for (Map.Entry<String, Object> entry : flexFieldValueMap.entrySet()) {
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
            Object value = entry.getValue();
            if (value instanceof Long) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
            } else if (value instanceof String) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
            }
            flexData.setPropId(entry.getKey());
            flexData.setValue(value);
            if (value == null) continue;
            flexDatas.add(flexData);
        }
        flexEntireData.setFlexDatas(flexDatas);
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        return FlexService.saveFlexData((MainEntityType)mainEntity, (FlexEntireData)flexEntireData);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        IDataModel model = this.getModel();
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs.length > 0) {
            ArrayList<String> rowids = new ArrayList<String>(rowIndexs.length);
            ArrayList<Object> expPks = new ArrayList<Object>(rowIndexs.length);
            for (int i : rowIndexs) {
                String rowid = model.getValue("autorowid", i).toString();
                rowids.add(rowid);
                Object exp = model.getValue(Key_PercentExp);
                expPks.add(exp);
            }
            AutoTransUtil.cacheDelRowids((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATADELROWIDS, rowids);
            AutoTransUtil.cacheDelRowids((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPDELROWIDS, rowids);
            AutoTransUtil.cacheDelRowids((IPageCache)this.getPageCache(), (String)CACHE_KEY_PERCENTDELROWIDS, expPks);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(Key_Orgid);
        Map<Object, DynamicObject> originalRowID2Assgrp = this.getOriginalRowid2AssgrpAfterCopy(model);
        Map<String, String> old2NewRowID = this.genNewRowIDOnEntry((DynamicObjectCollection)model.getValue(Key_Entryentity));
        HashMap newRowID2AssgrpDesc = new HashMap(originalRowID2Assgrp.size());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_ASSGRP);
        CloneUtils cloneUtils = new CloneUtils(Boolean.FALSE.booleanValue(), Boolean.TRUE.booleanValue());
        Object[] newAssgrpDyos = originalRowID2Assgrp.values().stream().map(assgrp -> (DynamicObject)cloneUtils.clone((IDataEntityType)dataEntityType, assgrp)).filter(newAssgrpDyo -> {
            String newRowID = (String)old2NewRowID.get(newAssgrpDyo.getString(ASSGRPEXP_ROWID_KEY));
            newAssgrpDyo.set(ASSGRPEXP_ROWID_KEY, (Object)newRowID);
            String assgrpDesc = FPFormUtil.getDesc((DynamicObjectCollection)newAssgrpDyo.getDynamicObjectCollection("entryentity"), (FPAssgrpDescLengthConfig)FPAssgrpDescLengthConfig.fromProperty((String)formId));
            newRowID2AssgrpDesc.put(newRowID, assgrpDesc);
            return true;
        }).toArray();
        Object[] save = SaveServiceHelper.save((IDataEntityType)dataEntityType, (Object[])newAssgrpDyos);
        AccountBookInfo bookInfo = new AccountBookInfo(orgId, ((Long)model.getValue(Key_Booktyepid)).longValue());
        long curPeriodAccountTableId = AccSysUtil.getCurPeriodAccountTableId((long)bookInfo.getOrgId(), (long)bookInfo.getBookTypeId(), (long)bookInfo.getCurPeriodId());
        ComAssistTable comAssistTable = ComAssistTable.get((Long)curPeriodAccountTableId);
        MainEntityType dataExpEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_DATAEXP);
        dataExpEntityType = (MainEntityType)ComAssistTableService.modifyEntityType((ComAssistTable)comAssistTable, (EntityType)dataExpEntityType);
        int targetCount = model.getEntryRowCount(Key_Entryentity);
        for (int i = 0; i < targetCount; ++i) {
            String oldAccountRowId = (String)model.getValue("autorowid", i);
            String newAccountRowId = old2NewRowID.get(oldAccountRowId);
            String typeStr = (String)model.getValue(dataType, i);
            int typeInt = Integer.parseInt(typeStr);
            model.setValue(assgrpKey, newRowID2AssgrpDesc.get(newAccountRowId), i);
            if (6 == typeInt || 5 == typeInt) {
                Object valueFromCache = AutoTransUtil.getValueFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP, (String)oldAccountRowId, (String)ENTITY_DATAEXP, (QFilter[])this.getFilters(orgId, oldAccountRowId, "autorowid"), (String)"autorowid", (String)CACHE_KEY_DATADELROWIDS, (DynamicObjectType)dataExpEntityType);
                if (valueFromCache != null) {
                    DynamicObject valueDyn = GlFormUtil.fromDynamicString((String)((String)valueFromCache), (MainEntityType)dataExpEntityType);
                    for (int j = 1; j <= comAssistTable.getCommonAssists().size(); ++j) {
                        valueDyn.getDynamicObjectCollection("comassist" + j).forEach(value -> value.set("pkid", (Object)0));
                    }
                    valueDyn.set("id", (Object)0);
                    valueFromCache = GlFormUtil.toDynamicObjectJson((DynamicObject)valueDyn);
                    AutoTransUtil.updatePageCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP, (String)newAccountRowId, (Object)valueFromCache, (String)"autorowid", (String)ENTITY_DATAEXP);
                    model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), i);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u5f55\u4fe1\u606f\u7b2c%s\u884c\u516c\u5f0f\u6570\u636e\u6765\u6e90\u516c\u5f0f\u5df2\u6539\u4e3a\u672a\u8bbe\u7f6e\u3002", (String)"AutoTransEditPlugin_20", (String)"fi-gl-formplugin", (Object[])new Object[]{i + 1}));
                    model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"AutoTransEditPlugin_22", (String)"fi-gl-formplugin", (Object[])new Object[0]), i);
                }
            }
            model.setValue("autorowid", (Object)newAccountRowId, i);
            if (11 != typeInt && 10 != typeInt) continue;
            Map settings = BusinessDataServiceHelper.loadFromCache((String)"gl_autotransexcelseting", (QFilter[])new QFilter("autorowid", "=", (Object)oldAccountRowId).toArray());
            for (Map.Entry setEntry : settings.entrySet()) {
                DynamicObject dyo = (DynamicObject)setEntry.getValue();
                CloneUtils c = new CloneUtils(true, true);
                DynamicObject newAcct = (DynamicObject)c.clone((IDataEntityBase)dyo);
                newAcct.set("autorowid", (Object)newAccountRowId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAcct});
                model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), i);
            }
        }
        this.newPercentExp();
        this.initEnableAndVisible(false);
    }

    private Map<String, String> genNewRowIDOnEntry(DynamicObjectCollection entryCol) {
        HashMap<String, String> res = new HashMap<String, String>(entryCol.size());
        entryCol.stream().map(entryDyo -> entryDyo.getString("autorowid")).forEach(oldRowID -> res.put((String)oldRowID, this.getRowId()));
        return res;
    }

    private Map<Object, DynamicObject> getOriginalRowid2AssgrpAfterCopy(IDataModel model) {
        List rowIDList = ((DynamicObjectCollection)model.getValue(Key_Entryentity)).stream().map(entryDyo -> entryDyo.getString("autorowid")).collect(Collectors.toList());
        QFilter orgFilter = new QFilter(orgKey, "=", model.getValue(Key_Orgid));
        QFilter rowIDFilter = new QFilter(ASSGRPEXP_ROWID_KEY, "in", rowIDList);
        return BusinessDataServiceHelper.loadFromCache((String)ENTITY_ASSGRP, (QFilter[])new QFilter[]{orgFilter, rowIDFilter});
    }

    private void newPercentExp() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(Key_Entryentity);
        HashMap<Long, Integer> pkToIndex = new HashMap<Long, Integer>(entries.size());
        for (DynamicObject row : entries) {
            int index = row.getInt("seq") - 1;
            String ptype = row.getString(Key_PercentType);
            if (!"1".equals(ptype)) {
                model.setValue(Key_PercentExpDesc, (Object)"", index);
                model.setValue(Key_PercentExp, (Object)0L, index);
                continue;
            }
            long expPk = row.getLong(Key_PercentExp);
            pkToIndex.put(expPk, index);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"gl_autotrans_percent");
        Map exps = BusinessDataServiceHelper.loadFromCache((Object[])pkToIndex.keySet().toArray(), (String)"gl_autotrans_percent");
        for (Map.Entry entry : pkToIndex.entrySet()) {
            DynamicObject dyn = (DynamicObject)exps.get(entry.getKey());
            if (dyn == null) {
                model.setValue(Key_PercentExpDesc, (Object)"", ((Integer)entry.getValue()).intValue());
                model.setValue(Key_PercentExp, (Object)0L, ((Integer)entry.getValue()).intValue());
                model.setValue(Key_PercentType, (Object)"0");
                continue;
            }
            CloneUtils cloneUtils = new CloneUtils(Boolean.FALSE.booleanValue(), Boolean.TRUE.booleanValue());
            Object clone = cloneUtils.clone((IDataEntityType)dataEntityType, (Object)dyn);
            Object[] save = SaveServiceHelper.save((IDataEntityType)dataEntityType, (Object[])new Object[]{clone});
            if (save.length <= 0) continue;
            DynamicObject newObj = (DynamicObject)save[0];
            model.setValue(Key_PercentExp, (Object)newObj.getLong("id"), ((Integer)entry.getValue()).intValue());
        }
    }

    private Long getNewPercentExpOnLine(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(Key_Entryentity);
        Long pkToIndex = null;
        DynamicObject row = (DynamicObject)entries.get(rowIndex);
        int index = row.getInt("seq") - 1;
        String ptype = row.getString(Key_PercentType);
        if (!"1".equals(ptype)) {
            return 0L;
        }
        pkToIndex = row.getLong(Key_PercentExp);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"gl_autotrans_percent");
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)pkToIndex, (String)"gl_autotrans_percent");
        if (dyn == null) {
            return 0L;
        }
        CloneUtils cloneUtils = new CloneUtils(Boolean.FALSE.booleanValue(), Boolean.TRUE.booleanValue());
        Object clone = cloneUtils.clone((IDataEntityType)dataEntityType, (Object)dyn);
        Object[] save = SaveServiceHelper.save((IDataEntityType)dataEntityType, (Object[])new Object[]{clone});
        if (save.length > 0) {
            return ((DynamicObject)save[0]).getLong("id");
        }
        return 0L;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"imageap", assgrpType, assgrpKey, dataType, Key_DataExpDesc, Key_PercentExpDesc, AutoTransConstant.Entry_QTY_FormulaShow.key});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addOrgF7SelecFilter(e);
        AutoTransEditFilterService.registerFilterListener((EditView)new EditView(this.getView(), this.getModel(), this.getPageCache()), (PropertyKey)AutoTransConstant.Entry_Key_Account);
        this.addVchTypeF7SelectFilter(e);
        this.addCurrencyF7SelectFilter(e);
        this.addMeasureUnitF7SelectFilter(e);
        this.addBookTypeF7Filter(e);
    }

    private void addBookTypeF7Filter(EventObject e) {
        BasedataEdit book = (BasedataEdit)this.getControl(Key_BookType);
        book.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            long orgId = (Long)this.getModel().getValue(Key_Orgid);
            Tuple2<Long, Map<Long, Long>> bookTypesByOrg = this.getBookTypesByOrg(orgId);
            HashSet bookTypes = new HashSet();
            bookTypes.addAll(((Map)bookTypesByOrg.t2).keySet());
            showParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", bookTypes));
        });
    }

    private void addMeasureUnitF7SelectFilter(EventObject e) {
        BasedataEdit unitEdit = (BasedataEdit)this.getControl("measureunitid");
        unitEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject accoutDyn = (DynamicObject)this.getModel().getValue(accountKey, evt.getRow());
            if (accoutDyn != null) {
                Long groupId = accoutDyn.getLong("measureunitgroup_id");
                QFilter filter = null;
                if (groupId != 0L) {
                    filter = new QFilter("group.id", "=", (Object)groupId);
                    List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
                    filters.add(filter);
                }
            }
        });
    }

    private void addCurrencyF7SelectFilter(EventObject e) {
        BasedataEdit curEdit = (BasedataEdit)this.getControl("currencyid");
        curEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject accountDyn = (DynamicObject)this.getModel().getValue(accountKey, evt.getRow());
            List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            filters.addAll(AutoTransEditHelper.getCurFilterByAcc((DynamicObject)accountDyn, (AccountBookInfo)this.getAcctBook()).toList());
        });
    }

    private void addVchTypeF7SelectFilter(EventObject e) {
        BasedataEdit vouchertype = (BasedataEdit)this.getControl("vouchertypeid");
        vouchertype.addBeforeF7SelectListener(evt -> {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            long orgId = (Long)this.getModel().getValue("org_Id");
            qFilters.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgId));
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            List filters = filterParam.getQFilters();
            filters.addAll(qFilters);
        });
    }

    private void addOrgF7SelecFilter(EventObject e) {
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl(orgKey);
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener(evt -> {
                QFilter f = AccSysUtil.getAcctOrgFilter((String)this.getView().getEntityId(), (boolean)Boolean.FALSE, (PermissonType)PermissonType.VIEW);
                List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
                filters.add(f);
            });
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "copyline": {
                EntryGrid grid = (EntryGrid)this.getControl(Key_Entryentity);
                int[] rows = grid.getSelectRows();
                if (rows.length > 0) {
                    int curIndex = rows[0];
                    if (curIndex < 0) break;
                    this.copyLine(curIndex, grid);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u64cd\u4f5c\u3002", (String)"AutoTransEditPlugin_24", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void copyLine(int curIndex, EntryGrid grid) {
        Object assgrpFromCache;
        String comAssistKey;
        IDataModel m = this.getModel();
        int newIndex = m.insertEntryRow(Key_Entryentity, curIndex + 1);
        grid.selectRows(newIndex);
        m.setValue("autodescription", m.getValue("autodescription", curIndex), newIndex);
        m.setValue(accountKey, m.getValue(accountKey, curIndex), newIndex);
        m.setValue("currencyid", m.getValue("currencyid", curIndex), newIndex);
        this.getPageCache().put("copy", "copy");
        m.setValue(dataType, m.getValue(dataType, curIndex), newIndex);
        this.getPageCache().remove("copy");
        m.setValue("autopercent", m.getValue("autopercent", curIndex), newIndex);
        m.setValue(Key_Percent, m.getValue(Key_Percent, curIndex), newIndex);
        m.setValue(assgrpType, m.getValue(assgrpType, curIndex), newIndex);
        m.setValue(assgrpKey, m.getValue(assgrpKey, curIndex), newIndex);
        m.setValue("measureunitid", m.getValue("measureunitid", curIndex), newIndex);
        m.setValue(ENTRY_QTY, m.getValue(ENTRY_QTY, curIndex), newIndex);
        m.setValue("originalamount", m.getValue("originalamount", curIndex), newIndex);
        String oldAutorowid = (String)m.getValue("autorowid", curIndex);
        String newAutorowid = this.getRowId();
        m.setValue("autorowid", (Object)newAutorowid, newIndex);
        String rptexp = (String)m.getValue("rptexp", curIndex);
        this.getPageCache().put("copy", "copy");
        String datasourcetype = (String)m.getValue(dataType, curIndex);
        m.setValue(dataType, (Object)datasourcetype, newIndex);
        Object bcmFormula = m.getValue("bcmformulajson", curIndex);
        m.setValue("bcmformulajson", bcmFormula, newIndex);
        Object qtyFormula = m.getValue(AutoTransConstant.Entry_QTY_FORMULA.toString(), curIndex);
        m.setValue(AutoTransConstant.Entry_QTY_FORMULA.toString(), qtyFormula, newIndex);
        Object qtyFrom = m.getValue(AutoTransConstant.Entry_QTY_FROM.toString(), curIndex);
        m.setValue(AutoTransConstant.Entry_QTY_FROM.toString(), qtyFrom, newIndex);
        String percentType = (String)m.getValue(Key_PercentType, curIndex);
        m.setValue(Key_PercentType, (Object)percentType, newIndex);
        Long newPercentExp = this.getNewPercentExpOnLine(curIndex);
        m.setValue(Key_PercentExp, (Object)newPercentExp, newIndex);
        String percentdesc = (String)m.getValue(Key_PercentExpDesc, curIndex);
        m.setValue(Key_PercentExpDesc, (Object)percentdesc, newIndex);
        String percent = (String)m.getValue(Key_Percent, curIndex);
        m.setValue(Key_Percent, (Object)percent, newIndex);
        String dc = (String)m.getValue("dc", curIndex);
        m.setValue("dc", (Object)dc, newIndex);
        int index = 0;
        while (this.getControl(comAssistKey = CommonAssistUtil.getComassistField((int)(++index))) != null) {
            m.setValue(comAssistKey, m.getValue(comAssistKey, curIndex), newIndex);
        }
        this.getPageCache().remove("copy");
        this.setFormulaSetStatus(AutoTransConstant.Entry_QTY_FORMULA.toString());
        if (kd.bos.util.StringUtils.isNotEmpty((String)rptexp) || kd.bos.util.StringUtils.isNotEmpty((String)((String)bcmFormula))) {
            m.setValue("rptexp", (Object)rptexp, newIndex);
            m.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), newIndex);
        }
        if (11 == Integer.parseInt(datasourcetype) || 10 == Integer.parseInt(datasourcetype)) {
            Map settings = BusinessDataServiceHelper.loadFromCache((String)"gl_autotransexcelseting", (QFilter[])new QFilter("autorowid", "=", (Object)oldAutorowid).toArray());
            for (Map.Entry setEntry : settings.entrySet()) {
                DynamicObject dyo = (DynamicObject)setEntry.getValue();
                CloneUtils c = new CloneUtils(true, true);
                DynamicObject newAcct = (DynamicObject)c.clone((IDataEntityBase)dyo);
                newAcct.set("autorowid", (Object)newAutorowid);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAcct});
                m.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), newIndex);
            }
        }
        long orgId = (Long)m.getValue(Key_Orgid);
        Object valueFromCache = AutoTransUtil.getValueFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP, (String)oldAutorowid, (String)ENTITY_DATAEXP, (QFilter[])this.getFilters(orgId, oldAutorowid, "autorowid"), (String)"autorowid", (String)CACHE_KEY_DATADELROWIDS, null);
        if (valueFromCache != null) {
            AutoTransUtil.updatePageCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP, (String)newAutorowid, (Object)valueFromCache, (String)"autorowid", (String)ENTITY_DATAEXP);
            m.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), newIndex);
        }
        if ((assgrpFromCache = AutoTransUtil.getValueFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPEXP, (String)oldAutorowid, (String)ENTITY_ASSGRP, (QFilter[])this.getFilters(orgId, oldAutorowid, ASSGRPEXP_ROWID_KEY), (String)ASSGRPEXP_ROWID_KEY, (String)CACHE_KEY_ASSGRPDELROWIDS, null)) != null) {
            AutoTransUtil.updatePageCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPEXP, (String)newAutorowid, (Object)assgrpFromCache, (String)ASSGRPEXP_ROWID_KEY, (String)ENTITY_ASSGRP);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel dataModel = this.getModel();
        DynamicObject info = dataModel.getDataEntity();
        IPageCache cache = this.getPageCache();
        String exchangeBookCache = cache.get("PeriodEndingSolveUtil_exchangeBook");
        if (!"true".equals(exchangeBookCache)) {
            long orgId = (Long)dataModel.getValue(Key_Orgid);
            this.setDefaultValueByOrg(orgId, Boolean.FALSE);
            this.getModel().setValue("voucherdatetype", (Object)"1");
            info.set(Key_TranType, (Object)1);
            info.set("voucherentrysort", (Object)1);
            info.set("createtime", (Object)new Date());
            this.createNewEntryData(dataModel);
            this.setCreatorInfo();
            this.initEnableAndVisible(false);
        }
    }

    private void setCreatorInfo() {
        DynamicObject creator = (DynamicObject)this.getModel().getValue("creator");
        if (creator != null) {
            Long creatorId = creator.getLong("id");
            Map dpt = GlFormUtil.getDptNameByUserId((Long)creatorId);
            this.getModel().setValue("dptnames", dpt.get("dpt"));
        }
    }

    private void initEnableAndVisible(boolean isNeedClearQty) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObjectCollection coll = model.getEntryEntity(Key_Entryentity);
        boolean flag = false;
        boolean hasExp = false;
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            DynamicObject accountDyn = row.getDynamicObject(accountKey);
            this.enableMUT(accountDyn, i, isNeedClearQty);
            if (accountDyn != null && accountDyn.getBoolean("isassist")) {
                flag = true;
                view.setEnable(Boolean.TRUE, i, new String[]{assgrpKey});
            } else {
                view.setEnable(Boolean.FALSE, i, new String[]{assgrpKey});
            }
            String dtype = row.getString(dataType);
            if (!StringUtils.isNumeric((CharSequence)dtype)) continue;
            int type = Integer.parseInt(dtype);
            switch (type) {
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    hasExp = true;
                }
            }
        }
        view.setVisible(Boolean.valueOf(flag), new String[]{assgrpKey});
        this.setPercentVisible();
    }

    private Set<String> analyzeAccountAssgrp() {
        HashSet<Long> outAcctIds = new HashSet<Long>();
        HashSet<Long> inAcctIds = new HashSet<Long>();
        IDataModel model = this.getModel();
        DynamicObjectCollection coll = model.getEntryEntity(Key_Entryentity);
        for (DynamicObject row : coll) {
            long accountId = row.getLong("accountid_id");
            int rowDataType = row.getInt(dataType);
            if (5 == rowDataType || 4 == rowDataType || 3 == rowDataType || 2 == rowDataType) {
                outAcctIds.add(accountId);
                continue;
            }
            inAcctIds.add(accountId);
        }
        HashSet<String> transInFlexField = new HashSet<String>();
        HashSet<String> transOutFlexField = new HashSet<String>();
        QFilter fid = new QFilter("id", "in", outAcctIds).or(new QFilter("id", "in", inAcctIds));
        String sel = "checkitementry.asstactitem.flexfield flexfield, id";
        DataSet acctSet = QueryServiceHelper.queryDataSet((String)"getAccountAssist", (String)"bd_accountview", (String)sel, (QFilter[])new QFilter[]{fid}, null);
        Object object = null;
        try {
            for (Row row : acctSet) {
                String flexfield = row.getString("flexfield");
                if (flexfield == null) continue;
                long acctId = row.getLong("id");
                if (outAcctIds.contains(acctId)) {
                    transOutFlexField.add(flexfield);
                    continue;
                }
                transInFlexField.add(flexfield);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (acctSet != null) {
                if (object != null) {
                    try {
                        acctSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    acctSet.close();
                }
            }
        }
        HashSet<String> notIncludeFlexField = new HashSet<String>();
        for (String flexField : transInFlexField) {
            if (transOutFlexField.contains(flexField)) continue;
            notIncludeFlexField.add(flexField);
        }
        return notIncludeFlexField;
    }

    public void afterBindData(EventObject eventobject) {
        super.afterBindData(eventobject);
        this.enableEntryMUT(false);
        DynamicObject book = (DynamicObject)this.getModel().getValue(Key_BookType);
        if (book != null) {
            String bookId = book.getString("id");
            this.getPageCache().put(CacheKey_OldBookType, bookId);
        }
        this.initEnableAndVisible(false);
        this.customSelIn(-1);
        this.setCreatorInfo();
        this.setRowIdByAccountChanged();
        this.setExpDesc();
        DynamicObjectCollection autoTransEntry = this.getModel().getEntryEntity(Key_Entryentity);
        List<String> allComAssistKeys = this.getModel().getDataEntityType().getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toList());
        for (int index = 0; index < autoTransEntry.size(); ++index) {
            String dataSourceType = ((DynamicObject)autoTransEntry.get(index)).getString(dataType);
            if (!"8".equals(dataSourceType) && !"9".equals(dataSourceType)) continue;
            this.getView().setEnable(Boolean.FALSE, index, allComAssistKeys.toArray(new String[0]));
        }
    }

    private void setExpDesc() {
        IDataModel model = this.getModel();
        long orgid = (Long)model.getValue(Key_Orgid);
        if (orgid > 0L) {
            DynamicObjectCollection entries = model.getEntryEntity(Key_Entryentity);
            for (DynamicObject entry : entries) {
                this.qtyShowSet(entry);
                this.amountShowSet(entry, orgid);
            }
        }
    }

    private void qtyShowSet(DynamicObject entry) {
        IDataModel model = this.getModel();
        AutoTransQtyTypeEnum curQtyType = AutoTransQtyTypeEnum.valueOfHash((String)entry.getString(AutoTransConstant.Entry_QTY_FROM.toString()));
        if (curQtyType.haveSet(entry.getString(AutoTransConstant.Entry_QTY_FORMULA.key)) || curQtyType.haveSet(entry.getString(AutoTransConstant.Entry_QTY_PRT.key))) {
            model.setValue(AutoTransConstant.Entry_QTY_FormulaShow.toString(), (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), entry.getInt("seq") - 1);
        }
    }

    private void amountShowSet(DynamicObject entry, long orgid) {
        Object valueFromCache;
        String autoRowId;
        IDataModel model = this.getModel();
        String type = entry.getString(dataType);
        if ((protransferout.equals(type) || protransferin.equals(type)) && StringUtils.isNotBlank((CharSequence)(autoRowId = entry.getString("autorowid"))) && StringUtils.isNotBlank((Object)(valueFromCache = AutoTransUtil.getValueFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP, (String)autoRowId, (String)ENTITY_DATAEXP, (QFilter[])this.getFilters(orgid, autoRowId, "autorowid"), (String)"autorowid", (String)CACHE_KEY_DATADELROWIDS, null)))) {
            model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), entry.getInt("seq") - 1);
        }
        switch (type) {
            case "8": 
            case "9": {
                String exp = (String)model.getValue("rptexp", entry.getInt("seq") - 1);
                if (!kd.bos.util.StringUtils.isNotEmpty((String)exp)) break;
                model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), entry.getInt("seq") - 1);
                break;
            }
            case "10": 
            case "11": {
                String autorowid = (String)model.getValue("autorowid", entry.getInt("seq") - 1);
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"gl_autotransexcelseting", (QFilter[])new QFilter("autorowid", "=", (Object)autorowid).toArray(), null, (int)1);
                if (ids.isEmpty()) break;
                model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), entry.getInt("seq") - 1);
                break;
            }
            case "13": 
            case "12": {
                this.setBCMFormulaSetedStatus(entry.getInt("seq") - 1, AutoTransConstant.Entry_AMT_FORMULA);
            }
        }
        String ptype = entry.getString(Key_PercentType);
        if ("1".equalsIgnoreCase(ptype)) {
            long percentExp = entry.getLong(Key_PercentExp);
            if (percentExp > 0L) {
                model.setValue(Key_PercentExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), entry.getInt("seq") - 1);
            }
        } else {
            model.setValue(Key_PercentExp, (Object)0L, entry.getInt("seq") - 1);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() == null) {
            return;
        }
        IDataModel model = this.getModel();
        int curIndex = model.getEntryCurrentRowIndex(Key_Entryentity);
        if (ENTITY_DATAEXP.equals(actionId)) {
            Map resultMap = (Map)e.getReturnData();
            if (resultMap.get("value") != null) {
                String strObj = (String)resultMap.get("value");
                String autoRowId = (String)resultMap.get("autoRowId");
                long orgid = (Long)model.getValue(Key_Orgid);
                Object oldVal = AutoTransUtil.getValueFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP, (String)autoRowId, (String)ENTITY_DATAEXP, (QFilter[])this.getFilters(orgid, autoRowId, "autorowid"), (String)"autorowid", (String)CACHE_KEY_DATADELROWIDS, null);
                if (!strObj.equals(oldVal)) {
                    AutoTransUtil.updatePageCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP, (String)autoRowId, (Object)strObj, (String)"autorowid", (String)ENTITY_DATAEXP);
                }
                int index = model.getEntryCurrentRowIndex(Key_Entryentity);
                model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), index);
            }
        } else if (ENTITY_ASSGRP.equals(actionId)) {
            Map resultMap = (Map)e.getReturnData();
            if (resultMap.get("value") != null) {
                String expression = (String)resultMap.get("express");
                String strObj = (String)resultMap.get("value");
                String indexStr = (String)resultMap.get("index");
                int index = 0;
                if (StringUtils.isBlank((CharSequence)indexStr)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u8868\u8fbe\u5f0f\u3002", (String)"AutoTransEditPlugin_25", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                index = Integer.parseInt(indexStr);
                String columnKey = (String)resultMap.get(ASSGRPEXP_ROWID_KEY);
                if (expression.length() > 100) {
                    expression = expression.substring(0, 100) + "...";
                }
                model.setValue(assgrpKey, (Object)expression, index);
                this.getPageCache().remove(columnKey);
                long orgid = (Long)model.getValue(Key_Orgid);
                Object oldVal = AutoTransUtil.getValueFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPEXP, (String)columnKey, (String)ENTITY_ASSGRP, (QFilter[])this.getFilters(orgid, columnKey, ASSGRPEXP_ROWID_KEY), (String)ASSGRPEXP_ROWID_KEY, (String)CACHE_KEY_ASSGRPDELROWIDS, null);
                if (!strObj.equals(oldVal)) {
                    AutoTransUtil.updatePageCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPEXP, (String)columnKey, (Object)strObj, (String)ASSGRPEXP_ROWID_KEY, (String)ENTITY_ASSGRP);
                }
            }
        } else if ("reporttovoucher".equals(actionId)) {
            String jsonresult = (String)e.getReturnData();
            if (StringUtils.isNotBlank((CharSequence)jsonresult)) {
                model.setValue("rptexp", (Object)jsonresult, curIndex);
                model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), curIndex);
            }
        } else if ("reporttoqty".equals(actionId)) {
            String jsonresult = (String)e.getReturnData();
            if (StringUtils.isNotBlank((CharSequence)jsonresult)) {
                model.setValue("qtyrptexp", (Object)jsonresult, curIndex);
                model.setValue(QTY_FORMULA_SHOW, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), curIndex);
            }
        } else if ("gl_autotrans_percent".equals(actionId)) {
            Map data = (Map)e.getReturnData();
            if (data != null) {
                model.setValue(Key_PercentExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), curIndex);
                model.setValue(Key_PercentExp, data.get("data-pk"), curIndex);
            }
        } else if ("excelvoucher".equals(actionId)) {
            model.setValue(Key_DataExpDesc, (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]), curIndex);
        } else if (AutoTransConstant.Entry_BCM_FormulaPicker.key.equals(actionId)) {
            String formulaFieldKey = this.isAmountTypeChanged() ? AutoTransConstant.Entry_AMT_FORMULA.key : AutoTransConstant.Entry_QTY_FORMULA.key;
            this.getModel().setValue(formulaFieldKey, e.getReturnData());
            this.setFormulaSetStatus(formulaFieldKey);
        }
    }

    private void setFormulaSetStatus(String fieldKey) {
        int curIndex = this.getModel().getEntryCurrentRowIndex(Key_Entryentity);
        String formulaStr = (String)this.getModel().getValue(fieldKey, curIndex);
        String statusStr = StringUtils.isEmpty((CharSequence)formulaStr) ? "" : ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String showFieldKey = AutoTransConstant.Entry_QTY_FORMULA.toString().equals(fieldKey) ? AutoTransConstant.Entry_QTY_FormulaShow.toString() : AutoTransConstant.Entry_AMT_FormulaShow.toString();
        this.getModel().setValue(showFieldKey, (Object)statusStr);
    }

    private boolean isAmountTypeChanged() {
        String formOpenType = this.getPageCache().get("bcm-form-open-type");
        this.getPageCache().remove("bcm-form-open-type");
        return "amount".equals(formOpenType);
    }

    private void cacheFormOpenType(boolean isAmountChanged) {
        this.getPageCache().put("bcm-form-open-type", isAmountChanged ? "amount" : ENTRY_QTY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("save".equals(operate.getOperateKey())) {
            List perectexpids;
            List assgrprowids;
            List datarowids;
            Map allDataExpFromCache;
            OperateOption operateOption = OperateOption.create();
            Map allAssgrpExpFromCache = AutoTransUtil.getAllExpFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPEXP);
            if (!allAssgrpExpFromCache.isEmpty()) {
                operateOption.setVariableValue(CACHE_KEY_ASSGRPEXP, SerializationUtils.toJsonString((Object)allAssgrpExpFromCache));
            }
            if (!(allDataExpFromCache = AutoTransUtil.getAllExpFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP)).isEmpty()) {
                operateOption.setVariableValue(CACHE_KEY_DATAEXP, SerializationUtils.toJsonString((Object)allDataExpFromCache));
            }
            if ((datarowids = AutoTransUtil.getDelRowidsFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATADELROWIDS)) != null && !datarowids.isEmpty()) {
                operateOption.setVariableValue(CACHE_KEY_DATADELROWIDS, SerializationUtils.toJsonString((Object)datarowids));
                operateOption.setVariableValue(OPTION_KEY_ORG, this.getModel().getValue(Key_Orgid).toString());
            }
            if ((assgrprowids = AutoTransUtil.getDelRowidsFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPDELROWIDS)) != null && !assgrprowids.isEmpty()) {
                operateOption.setVariableValue(CACHE_KEY_ASSGRPDELROWIDS, SerializationUtils.toJsonString((Object)assgrprowids));
                operateOption.setVariableValue(OPTION_KEY_ORG, this.getModel().getValue(Key_Orgid).toString());
            }
            if ((perectexpids = AutoTransUtil.getDelRowidsFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_PERCENTDELROWIDS)) != null && !perectexpids.isEmpty()) {
                operateOption.setVariableValue(CACHE_KEY_PERCENTDELROWIDS, SerializationUtils.toJsonString((Object)perectexpids));
            }
            operate.setOption(operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            boolean success = args.getOperationResult().isSuccess();
            if (success) {
                String sql = "select fid from t_gl_autotransexcel where fautorowid not in (select fautorowid from t_gl_autotransentry)";
                List ids = (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)sql, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

                    public List<Object> handle(ResultSet rs) throws Exception {
                        ArrayList<Object> list = new ArrayList<Object>();
                        try {
                            while (rs.next()) {
                                list.add(rs.getLong("fid"));
                            }
                        }
                        catch (SQLException e) {
                            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                        }
                        return list;
                    }
                });
                if (!ids.isEmpty()) {
                    OperationServiceHelper.executeOperate((String)"delete", (String)"gl_autotransexcelseting", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
                }
                AutoTransUtil.clearCache((IPageCache)this.getPageCache(), (String[])new String[]{CACHE_KEY_ASSGRPEXP, CACHE_KEY_DATAEXP, CACHE_KEY_DATADELROWIDS, CACHE_KEY_ASSGRPDELROWIDS, CACHE_KEY_PERCENTDELROWIDS});
                this.getView().updateView();
            }
        } else if ("queryvoucher".equalsIgnoreCase(operateKey) && args.getOperationResult().isSuccess()) {
            FPFormUtil.queryVcouher((IFormView)this.getView());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "changeBookType": {
                String newBookTypeId = this.getPageCache().get(CacheKey_NewBookType);
                String oldBookTypeId = this.getPageCache().get(CacheKey_OldBookType);
                if (MessageBoxResult.Yes == result && !"0".equals(newBookTypeId)) {
                    IFormView formView = (IFormView)e.getSource();
                    PeriodEndingSolveUtil.exchangeBook((IFormView)formView, (Object)newBookTypeId, (String)Key_BookType);
                    break;
                }
                if (MessageBoxResult.Yes == result && "0".equals(newBookTypeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"AutoTransEditPlugin_26", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    this.rollBackValue(Key_BookType, oldBookTypeId);
                    break;
                }
                this.rollBackValue(Key_BookType, oldBookTypeId);
            }
        }
    }

    private void rollBackValue(String field, String odlValue) {
        this.isPropertyChanged = false;
        this.getModel().setValue(field, (Object)odlValue);
        this.isPropertyChanged = true;
    }

    private void enableEntryMUT(boolean isNeedClearQty) {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(Key_Entryentity);
        for (int i = 0; i < coll.size(); ++i) {
            DynamicObject row = (DynamicObject)coll.get(i);
            this.enableMUT(row.getDynamicObject(accountKey), i, isNeedClearQty);
        }
    }

    private void enableMUT(DynamicObject acct, int rowIndex, boolean isNeedClearQty) {
        String[] qtyRelatedKey = new String[]{AutoTransConstant.Entry_MeasureUnit.toString(), AutoTransConstant.Entry_PRICE.toString(), AutoTransConstant.Entry_QTY.toString(), AutoTransConstant.Entry_QTY_FROM.toString(), AutoTransConstant.Entry_QTY_FormulaShow.toString()};
        AutoTransScheme scheme = this.getScheme();
        boolean isFormulaKind = AutoTransAmtTypeEnum.checkIfFormulaKind((AutoTransAmtTypeEnum)scheme.getAmtFromType(rowIndex));
        if (acct != null) {
            boolean notTransOutByRate;
            String srcTypeStr = (String)this.getModel().getValue(dataType, rowIndex);
            int srcType = Integer.parseInt(srcTypeStr);
            boolean bl = notTransOutByRate = srcType < 2 || srcType > 4;
            if (acct.getBoolean("isqty") && notTransOutByRate) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"measureunitid"});
                if (acct.getBoolean("isleaf") && isFormulaKind) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, qtyRelatedKey);
                    String qtyTypeValue = (String)this.getModel().getValue(AutoTransConstant.Entry_QTY_FROM.key, rowIndex);
                    if (AutoTransQtyTypeEnum.formula == AutoTransQtyTypeEnum.valueOfHash((String)qtyTypeValue) || AutoTransQtyTypeEnum.report == AutoTransQtyTypeEnum.valueOfHash((String)qtyTypeValue)) {
                        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{AutoTransConstant.Entry_QTY.key, AutoTransConstant.Entry_PRICE.key});
                    }
                } else {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, qtyRelatedKey);
                    if (isNeedClearQty) {
                        this.clearQtyRelateFields(qtyRelatedKey, rowIndex);
                    }
                }
                return;
            }
        }
        this.getView().setEnable(Boolean.FALSE, rowIndex, qtyRelatedKey);
        if (isNeedClearQty) {
            this.clearQtyRelateFields(qtyRelatedKey, rowIndex);
        }
    }

    private AutoTransScheme getScheme() {
        return new AutoTransScheme(this.getModel().getDataEntity(true));
    }

    protected int createNewEntryData(IDataModel dataModel) {
        int rowindex = dataModel.createNewEntryRow(Key_Entryentity);
        this.initEntryDefaultData(rowindex);
        return rowindex;
    }

    protected void initEntryDefaultData(int rowIndex) {
        IDataModel dataModel = this.getModel();
        if (dataModel.getDataEntity(true).getDynamicObjectCollection(Key_Entryentity).size() < rowIndex + 1) {
            return;
        }
        if (rowIndex > -1) {
            dataModel.setValue(dataType, (Object)2, rowIndex);
            dataModel.setValue(assgrpType, (Object)2, rowIndex);
            dataModel.setValue(Key_Percent, (Object)"100%", rowIndex);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        for (RowDataEntity rowData : rowDataEntities = e.getRowDataEntities()) {
            int rowIndex = rowData.getRowIndex();
            this.initEntryDefaultData(rowIndex);
        }
        this.enableEntryMUT(false);
        this.setRowIdByAccountChanged();
    }

    private void setRowIdByAccountChanged() {
        IDataModel model = this.getModel();
        DynamicObjectCollection coll = model.getEntryEntity(Key_Entryentity);
        int i = 0;
        for (DynamicObject row : coll) {
            String rowId = row.getString("autorowid");
            if (StringUtils.isBlank((CharSequence)rowId)) {
                model.setValue("autorowid", (Object)this.getRowId(), i);
            }
            ++i;
        }
    }

    private String getRowId() {
        return UUID.randomUUID().toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.isPropertyChanged) {
            return;
        }
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        switch (propName) {
            case "org": {
                if (!(newValue instanceof DynamicObject)) return;
                DynamicObject newOrg = (DynamicObject)newValue;
                long orgId = newOrg.getLong("id");
                this.setDefaultValueByOrg(orgId, Boolean.TRUE);
                return;
            }
            case "assisttranstype": {
                if ("2".equals(newValue)) {
                    this.handleShowAssgrpValue(model, rowIndex);
                }
                this.changedAcctClearAssist(rowIndex);
                this.initEnableAndVisible(false);
                return;
            }
            case "assgrp": {
                if (!(newValue instanceof String) || !"".equals(String.valueOf(newValue))) return;
                this.changedAcctClearAssist(rowIndex);
                return;
            }
            case "datasourcetype": {
                String type = (String)newValue;
                this.preShowExeFrom(type, rowIndex, true);
                return;
            }
            case "accountid": {
                this.setRowIdByAccountChanged();
                this.initMUT(rowIndex);
                DynamicObject account = (DynamicObject)newValue;
                if (account == null) {
                    model.setValue("currencyid", null, rowIndex);
                    return;
                }
                this.initEnableAndVisible(true);
                this.setDefaultCurrency(rowIndex);
                DynamicObject oldaccount = (DynamicObject)oldValue;
                boolean isNeedClearAssist = this.isNeedClearAssist(account, oldaccount);
                if (!isNeedClearAssist) return;
                this.changedAcctClearAssist(rowIndex);
                String type = (String)model.getValue(dataType, rowIndex);
                if (11 != Integer.parseInt(type) && 10 != Integer.parseInt(type)) return;
                String autorowid = (String)model.getValue("autorowid", rowIndex);
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"gl_autotransexcelseting", (QFilter[])new QFilter("autorowid", "=", (Object)autorowid).toArray(), null, (int)1);
                if (!ids.isEmpty()) {
                    OperationServiceHelper.executeOperate((String)"delete", (String)"gl_autotransexcelseting", (Object[])ids.toArray(), (OperateOption)OperateOption.create());
                }
                this.showExcelExp(rowIndex);
                return;
            }
            case "percent": {
                int currentRowIndex = model.getEntryCurrentRowIndex(Key_Entryentity);
                if (currentRowIndex < 0) {
                    currentRowIndex = model.getEntryRowCount(Key_Entryentity) - 1;
                }
                String percent = (String)model.getValue(Key_Percent, currentRowIndex);
                BigDecimal hundred = new BigDecimal("100");
                if (percent.trim().isEmpty() || percent.equals("0%")) {
                    return;
                }
                try {
                    if (percent.indexOf(37) == -1) {
                        if (hundred.compareTo(new BigDecimal(percent)) < 0) {
                            model.setValue(Key_Percent, null, currentRowIndex);
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u8d26\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100%\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AutoTransEditPlugin_27", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        model.setValue(Key_Percent, (Object)(percent + "%"), currentRowIndex);
                        return;
                    }
                    String[] percetStr = percent.split("%");
                    if (percetStr.length <= 0) return;
                    if (hundred.compareTo(new BigDecimal(percetStr[0])) < 0) {
                        model.setValue(Key_Percent, (Object)BigDecimal.ZERO, currentRowIndex);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u8d26\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100%\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AutoTransEditPlugin_27", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (BigDecimal.ZERO.compareTo(new BigDecimal(percetStr[0])) <= 0) return;
                    model.setValue(Key_Percent, (Object)BigDecimal.ZERO, currentRowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"AutoTransEditPlugin_33", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return;
                }
                catch (Exception e2) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6570\u503c\u3002", (String)"AutoTransEditPlugin_28", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    model.setValue(Key_Percent, (Object)hundred, currentRowIndex);
                }
                return;
            }
            case "bookstype": {
                long newBookTypeId = 0L;
                long oldBookTypeId = 0L;
                if (newValue instanceof DynamicObject) {
                    newBookTypeId = ((DynamicObject)newValue).getLong("id");
                }
                if (oldValue instanceof DynamicObject) {
                    oldBookTypeId = ((DynamicObject)oldValue).getLong("id");
                }
                this.getPageCache().put(CacheKey_NewBookType, String.valueOf(newBookTypeId));
                this.getPageCache().put(CacheKey_OldBookType, String.valueOf(oldBookTypeId));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8d26\u7c3f\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"AutoTransEditPlugin_29", (String)"fi-gl-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(Key_Confirm_ChangeBookType, (IFormPlugin)this));
                return;
            }
            case "percenttype": {
                if (newValue == null || !"1".equalsIgnoreCase((String)newValue)) {
                    model.setValue(Key_PercentExpDesc, (Object)"", rowIndex);
                }
                this.setPercentVisible();
                return;
            }
            case "qty": {
                model.beginInit();
                model.setValue(ENTRY_PRICE, (Object)0, rowIndex);
                model.endInit();
                return;
            }
            case "price": {
                this.afterPriceChanged(rowIndex);
                return;
            }
            case "qtyfrom": {
                this.afterQtyFromChanged(e);
                return;
            }
            case "bcmformulajson": 
            case "qtyformula": {
                this.afterFormulaChanged(e);
            }
        }
    }

    private void afterPriceChanged(int rowIndex) {
        IDataModel model = this.getModel();
        AutoTransQtyTypeEnum qtyFrom = AutoTransQtyTypeEnum.valueOfHash((String)((String)this.getModel().getValue(AutoTransConstant.Entry_QTY_FROM.toString())));
        PropertyKey propToSetZero = qtyFrom == AutoTransQtyTypeEnum.fixValue ? AutoTransConstant.Entry_QTY : AutoTransConstant.Entry_PRICE;
        model.beginInit();
        model.setValue(propToSetZero.key, (Object)0, rowIndex);
        model.endInit();
        this.getView().updateView(Key_Entryentity);
    }

    private void afterFormulaChanged(PropertyChangedArgs e) {
        HashMap<String, PropertyKey> formula2ShowFieldMap = new HashMap<String, PropertyKey>(4);
        formula2ShowFieldMap.put(AutoTransConstant.Entry_AMT_FORMULA.key, AutoTransConstant.Entry_AMT_FormulaShow);
        formula2ShowFieldMap.put(AutoTransConstant.Entry_QTY_FORMULA.key, AutoTransConstant.Entry_QTY_FormulaShow);
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String changedProp = e.getProperty().getName();
        if (e.getChangeSet()[0].getNewValue() != null) {
            this.setFormulaSetStatus(rowIndex, (PropertyKey)formula2ShowFieldMap.get(changedProp));
        }
    }

    private void afterQtyFromChanged(PropertyChangedArgs e) {
        if (this.getPageCache().get("copy") != null) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        AutoTransQtyTypeEnum changedValue = AutoTransQtyTypeEnum.valueOfHash((String)((String)changeData.getNewValue()));
        switch (changedValue) {
            case formula: {
                this.dealEditChangeAfterQtyFromChanged(AutoTransQtyTypeEnum.formula, rowIndex);
                this.showBcmFormularEdit(changeData.getRowIndex(), false);
                break;
            }
            case fixValue: {
                this.dealEditChangeAfterQtyFromChanged(AutoTransQtyTypeEnum.fixValue, rowIndex);
                break;
            }
            case report: {
                this.dealEditChangeAfterQtyFromChanged(AutoTransQtyTypeEnum.report, rowIndex);
                this.showRptExp(rowIndex, true);
            }
        }
    }

    private void dealEditChangeAfterQtyFromChanged(AutoTransQtyTypeEnum qtyType, int rowIndex) {
        boolean changeToFixValue = AutoTransQtyTypeEnum.fixValue.valueEquals(qtyType);
        this.getView().setEnable(Boolean.valueOf(changeToFixValue), rowIndex, new String[]{AutoTransConstant.Entry_QTY.key});
        this.getView().setEnable(Boolean.valueOf(changeToFixValue), rowIndex, new String[]{AutoTransConstant.Entry_PRICE.key});
        this.getView().setEnable(Boolean.valueOf(!changeToFixValue), rowIndex, new String[]{AutoTransConstant.Entry_QTY_FormulaShow.key});
        this.getModel().setValue(AutoTransConstant.Entry_QTY.key, (Object)0);
        this.getModel().setValue("qtyrptexp", null);
        this.getModel().setValue(AutoTransConstant.Entry_QTY_FormulaShow.key, null);
    }

    private void setPercentVisible() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Key_Entryentity);
        Boolean visible = false;
        Boolean visibleExp = false;
        for (DynamicObject row : entryEntity) {
            String type = row.getString(Key_PercentType);
            if (!"0".equalsIgnoreCase(type)) {
                visibleExp = true;
            }
            if ("1".equalsIgnoreCase(type)) continue;
            visible = true;
        }
        this.getView().setVisible(visible, new String[]{Key_Percent});
        this.getView().setVisible(visibleExp, new String[]{Key_PercentExpDesc});
    }

    private boolean isNeedClearAssist(DynamicObject account, DynamicObject oldaccount) {
        boolean flag = true;
        if (oldaccount == null) {
            return flag;
        }
        ArrayList<Long> oldAssistId = new ArrayList<Long>();
        DynamicObjectCollection oldAssists = oldaccount.getDynamicObjectCollection("checkitementry");
        for (DynamicObject oldAssist : oldAssists) {
            oldAssistId.add(oldAssist.getDynamicObject("asstactitem").getLong("id"));
        }
        ArrayList<Long> newAssistId = new ArrayList<Long>();
        DynamicObjectCollection newAssists = account.getDynamicObjectCollection("checkitementry");
        for (DynamicObject newAssist : newAssists) {
            newAssistId.add(newAssist.getDynamicObject("asstactitem").getLong("id"));
        }
        if (!oldAssistId.isEmpty() && !newAssistId.isEmpty()) {
            Object[] newArray;
            Object[] oldArray = oldAssistId.toArray(new Long[0]);
            flag = !Arrays.equals(oldArray, newArray = newAssistId.toArray(new Long[0]));
        }
        return flag;
    }

    private void preShowExeFrom(String type, int rowIndex, boolean isNeedClearQty) {
        this.initEnableAndVisible(isNeedClearQty);
        IDataModel model = this.getModel();
        if (!StringUtils.isBlank((CharSequence)type)) {
            int typeInt = Integer.parseInt(type);
            switch (typeInt) {
                case 5: 
                case 6: {
                    if (this.getPageCache().get("copy") != null) break;
                    this.showAccountExp(rowIndex);
                    break;
                }
                case 8: 
                case 9: {
                    if (this.getPageCache().get("copy") != null) break;
                    this.showUnSupportComAssistTip();
                    this.showRptExp(rowIndex, false);
                    break;
                }
                case 10: 
                case 11: {
                    if (this.getPageCache().get("copy") != null) break;
                    this.showExcelExp(rowIndex);
                    break;
                }
                case 12: 
                case 13: {
                    if (this.getPageCache().get("copy") != null) break;
                    this.cacheFormOpenType(true);
                    this.showBcmFormularEdit(rowIndex, true);
                    this.setBCMFormulaSetedStatus(rowIndex, AutoTransConstant.Entry_AMT_FORMULA);
                    break;
                }
                default: {
                    model.setValue(Key_DataExpDesc, (Object)"", rowIndex);
                }
            }
            List<String> allComAssistKeys = this.getModel().getDataEntityType().getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toList());
            if (typeInt == 9 || typeInt == 8) {
                for (String comAssistKey : allComAssistKeys) {
                    this.getModel().setValue(comAssistKey, null, rowIndex);
                }
                this.getView().setEnable(Boolean.FALSE, rowIndex, allComAssistKeys.toArray(new String[0]));
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, allComAssistKeys.toArray(new String[0]));
            }
        }
        this.customSelIn(rowIndex);
    }

    private void setBCMFormulaSetedStatus(int rowIndex, PropertyKey prop) {
        String curFormulaJson = (String)this.getModel().getValue(prop.toString(), rowIndex);
        String statusStr = "";
        if (!StringUtils.isEmpty((CharSequence)curFormulaJson)) {
            statusStr = ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        }
        this.getModel().setValue(Key_DataExpDesc, (Object)statusStr, rowIndex);
    }

    private void setFormulaSetStatus(int rowIndex, PropertyKey prop) {
        String statusStr = ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"AutoTransEditPlugin_19", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        this.getModel().setValue(prop.toString(), (Object)statusStr, rowIndex);
    }

    private void showBcmFormularEdit(int rowIndex, boolean isAmountValue) {
        AutoTransQtyTypeEnum qtyFrom = AutoTransQtyTypeEnum.valueOfHash((String)((String)this.getModel().getValue(AutoTransConstant.Entry_QTY_FROM.key, rowIndex)));
        if (!isAmountValue && qtyFrom != AutoTransQtyTypeEnum.formula) {
            return;
        }
        String formulaFieldKey = isAmountValue ? AutoTransConstant.Entry_AMT_FORMULA.toString() : AutoTransConstant.Entry_QTY_FORMULA.toString();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(AutoTransConstant.Entry_BCM_FormulaPicker.toString());
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam("txtadvance", this.getModel().getValue(formulaFieldKey, rowIndex));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, AutoTransConstant.Entry_BCM_FormulaPicker.toString()));
        this.getView().showForm(formShowParameter);
    }

    private void customSelIn(int index) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (index == -1) {
            int count = model.getEntryRowCount(Key_Entryentity);
            for (int i = 0; i < count; ++i) {
                String type = (String)model.getValue(dataType, i);
                if (StringUtils.isBlank((CharSequence)type)) continue;
                int typeInt = Integer.parseInt(type);
                if (7 == typeInt || 13 == typeInt) {
                    model.setValue(assgrpType, (Object)"2", i);
                    view.setEnable(Boolean.FALSE, i, new String[]{assgrpType});
                } else {
                    view.setEnable(Boolean.TRUE, i, new String[]{assgrpType});
                }
                if (7 == typeInt) {
                    view.setEnable(Boolean.FALSE, i, new String[]{Key_Percent, Key_PercentType});
                    model.setValue(Key_Percent, (Object)"100%", i);
                    model.setValue(Key_PercentType, (Object)"0", i);
                    continue;
                }
                view.setEnable(Boolean.TRUE, i, new String[]{Key_Percent, Key_PercentType});
            }
        } else {
            String type = (String)model.getValue(dataType, index);
            if (!StringUtils.isBlank((CharSequence)type)) {
                int typeInt = Integer.parseInt(type);
                if (7 == typeInt || 13 == typeInt) {
                    model.setValue(assgrpType, (Object)"2", index);
                    view.setEnable(Boolean.FALSE, index, new String[]{assgrpType});
                } else {
                    view.setEnable(Boolean.TRUE, index, new String[]{assgrpType});
                }
                if (7 == typeInt) {
                    view.setEnable(Boolean.FALSE, index, new String[]{Key_Percent, Key_PercentType});
                    model.setValue(Key_Percent, (Object)"100%", index);
                    model.setValue(Key_PercentType, (Object)"0", index);
                } else {
                    view.setEnable(Boolean.TRUE, index, new String[]{Key_Percent, Key_PercentType});
                }
            }
        }
    }

    private void changedAcctClearAssist(int index) {
        IDataModel model = this.getModel();
        model.setValue(assgrpKey, (Object)"", index);
        String rowIdVal = (String)model.getValue("autorowid", index);
        AutoTransUtil.removePageCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPEXP, (String)rowIdVal);
        ArrayList<String> rowids = new ArrayList<String>();
        rowids.add(rowIdVal);
        AutoTransUtil.cacheDelRowids((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPDELROWIDS, rowids);
    }

    private void setDefaultCurrency(int currentRowIndex) {
        DynamicObjectCollection coll;
        long bookTypeId;
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(Key_Orgid);
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)orgId, (long)(bookTypeId = ((Long)model.getValue(Key_Booktyepid)).longValue()));
        long defaultCrrc = book == null ? 0L : book.getBaseCurrencyId();
        DynamicObject accoutDyn = (DynamicObject)this.getModel().getValue(accountKey, currentRowIndex);
        if (accoutDyn != null && "descurrency".equals(accoutDyn.get("acctcurrency")) && (coll = (DynamicObjectCollection)accoutDyn.get("currencyentry")).size() > 0) {
            defaultCrrc = ((DynamicObject)coll.get(0)).getLong("currency_id");
        }
        model.setValue("currencyid", (Object)defaultCrrc, currentRowIndex);
    }

    private AccountBookInfo getAcctBook() {
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(Key_Orgid);
        long bookTypeId = (Long)model.getValue(Key_Booktyepid);
        return AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
    }

    private void initMUT(int rowIndex) {
        DynamicObject acctDyo = (DynamicObject)this.getModel().getValue(AutoTransConstant.Entry_Key_Account.toString(), rowIndex);
        AutoTransScheme scheme = this.getScheme();
        boolean isFormulaKind = AutoTransAmtTypeEnum.checkIfFormulaKind((AutoTransAmtTypeEnum)scheme.getAmtFromType(rowIndex));
        Object measureUnitToSet = null;
        if (acctDyo != null && acctDyo.getBoolean("isqty") && isFormulaKind) {
            measureUnitToSet = acctDyo.get("measureunit");
        }
        this.getModel().setValue(AutoTransConstant.Entry_MeasureUnit.toString(), measureUnitToSet, rowIndex);
        this.getModel().setValue(AutoTransConstant.Entry_PRICE.toString(), null, rowIndex);
        this.getModel().setValue(AutoTransConstant.Entry_QTY_FROM.toString(), null, rowIndex);
        this.getModel().setValue(AutoTransConstant.Entry_QTY.toString(), null, rowIndex);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(Key_Entryentity);
        if ("imageap".equals(key)) {
            long creator = ((DynamicObject)this.getModel().getValue("creator")).getLong("id");
            if (GLFabulousOperation.isCanThumbUp((long)creator, (String)formId)) {
                GLFabulousOperation.createFabulous((long)creator, (String)formId);
                this.setDefaultHeart();
            }
        } else if (assgrpKey.equals(key)) {
            this.handleShowAssgrpValue(model, index);
        } else if (Key_DataExpDesc.equals(key)) {
            String type = (String)model.getValue(dataType, index);
            this.preShowExeFrom(type, index, false);
        } else if (Key_PercentExpDesc.equalsIgnoreCase(key)) {
            this.showPercentExp(index);
        } else if (AutoTransConstant.Entry_QTY_FormulaShow.toString().equals(key)) {
            AutoTransQtyTypeEnum qtyType = AutoTransQtyTypeEnum.valueOfHash((String)((String)model.getValue("qtyfrom")));
            if (AutoTransQtyTypeEnum.formula.valueEquals(qtyType)) {
                this.showBcmFormularEdit(index, false);
            } else if (AutoTransQtyTypeEnum.report.valueEquals(qtyType)) {
                this.showRptExp(index, true);
            }
        }
    }

    private void showPercentExp(int index) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("gl_autotrans_percent");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(Key_Orgid);
        long bookstypeId = (Long)model.getValue(Key_Booktyepid);
        if (orgId > 0L && bookstypeId > 0L) {
            long pk = (Long)model.getValue(Key_PercentExp, index);
            if (pk > 0L) {
                parameter.setPkId((Object)pk);
            }
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("param-org", orgId);
            map.put("param-book", bookstypeId);
            parameter.setCustomParams(map);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "gl_autotrans_percent"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void handleShowAssgrpValue(IDataModel model, int index) {
        boolean isAssist;
        DynamicObject accountDyn = (DynamicObject)model.getValue(accountKey, index);
        boolean bl = isAssist = accountDyn != null && accountDyn.getBoolean("isassist");
        if (isAssist) {
            this.getView().setVisible(Boolean.TRUE, new String[]{assgrpKey});
            new AutoTransEditHelper();
            if (AutoTransEditHelper.canSetAssgrp((DynamicObject)((DynamicObject)model.getValue(accountKey, index)), (String)((String)model.getValue(assgrpType, index)), (String)((String)model.getValue(dataType, index)), this.analyzeAccountAssgrp())) {
                this.showAssgrpValue(index, new HashSet<String>());
            }
        }
    }

    private void showExcelExp(int index) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject acct = (DynamicObject)model.getValue(accountKey, index);
        if (acct == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79d1\u76ee", (String)"AutoTransEditPlugin_30", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            model.setValue(dataType, (Object)1, index);
            return;
        }
        BillShowParameter param = new BillShowParameter();
        param.setCustomParam(accountKey, (Object)acct.getLong("id"));
        String autorowid = (String)model.getValue("autorowid", index);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"gl_autotransexcelseting", (QFilter[])new QFilter("autorowid", "=", (Object)autorowid).toArray(), null, (int)1);
        if (!ids.isEmpty()) {
            param.setPkId(ids.get(0));
        }
        param.setCustomParam("autorowid", (Object)autorowid);
        param.setFormId("gl_autotransexcelseting");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "excelvoucher"));
        this.getView().showForm((FormShowParameter)param);
    }

    private void showRptExp(int index, boolean isQty) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("bcm_reporttovoucher");
        param.getOpenStyle().setShowType(ShowType.Modal);
        String rptexp = (String)this.getModel().getValue("rptexp", index);
        String actionId = "reporttovoucher";
        if (isQty) {
            actionId = "reporttoqty";
            rptexp = (String)this.getModel().getValue("qtyrptexp", index);
        }
        if (rptexp != null) {
            param.setCustomParam("rptexp", (Object)rptexp);
        }
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(param);
    }

    private void showAccountExp(int index) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        long orgId = (Long)model.getValue(Key_Orgid);
        long bookTypeId = (Long)model.getValue(Key_Booktyepid);
        if (orgId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoTransEditPlugin_31", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        if (bookTypeId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoTransEditPlugin_32", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (bookInfo == null) {
            return;
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(ENTITY_DATAEXP);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String accountRowId = (String)model.getValue("autorowid", index);
        MainEntityType dataExpEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_DATAEXP);
        long accountTableId = bookInfo.getAccountTableId();
        dataExpEntityType = (MainEntityType)ComAssistTableService.modifyEntityType((ComAssistTable)ComAssistTable.get((Long)accountTableId), (EntityType)dataExpEntityType);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Object valueFromCache = AutoTransUtil.getValueFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_DATAEXP, (String)accountRowId, (String)ENTITY_DATAEXP, (QFilter[])this.getFilters(orgId, accountRowId, "autorowid"), (String)"autorowid", (String)CACHE_KEY_DATADELROWIDS, (DynamicObjectType)dataExpEntityType);
        map.put("value", valueFromCache);
        map.put(orgKey, orgId);
        map.put("accountTableId", accountTableId);
        map.put("baseCurrency", bookInfo.getBaseCurrencyId());
        map.put("index", index);
        map.put("autoRowId", accountRowId);
        Set comAssistFieldSet = dataExpEntityType.getAllFields().keySet().stream().filter(field -> field.startsWith("comassist")).collect(Collectors.toSet());
        for (String comAssistField : comAssistFieldSet) {
            DynamicObjectCollection values = (DynamicObjectCollection)model.getValue(comAssistField, index);
            ArrayList<Long> comAssistIdList = new ArrayList<Long>(8);
            if (CollectionUtils.isNotEmpty((Collection)values)) {
                for (DynamicObject value : values) {
                    comAssistIdList.add(value.getLong("fbasedataid_id"));
                }
            }
            map.put(comAssistField, comAssistIdList);
        }
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ENTITY_DATAEXP));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void showAssgrpValue(int index, Set<String> notIncludeFlexField) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(ENTITY_ASSGRP);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue(Key_Orgid);
        String accountRowId = (String)model.getValue("autorowid", index);
        long bookstypeId = (Long)model.getValue(Key_Booktyepid);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", Key_Entryentity);
        map.put("index", index + "");
        map.put("orgId", orgId);
        map.put("accountId", model.getValue("accountid_id") + "");
        map.put("accountRowId", accountRowId);
        map.put("bookstypeId", bookstypeId);
        Object valueFromCache = AutoTransUtil.getValueFromCache((IPageCache)this.getPageCache(), (String)CACHE_KEY_ASSGRPEXP, (String)accountRowId, (String)ENTITY_ASSGRP, (QFilter[])this.getFilters(orgId, accountRowId, ASSGRPEXP_ROWID_KEY), (String)ASSGRPEXP_ROWID_KEY, (String)CACHE_KEY_ASSGRPDELROWIDS, null);
        if (valueFromCache != null) {
            map.put("value", valueFromCache);
        } else {
            map.put("donotquery", true);
        }
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ENTITY_ASSGRP));
        this.getView().showForm(parameter);
    }

    private QFilter[] getFilters(long orgid, String rowId, String rowidKey) {
        return new QFilter[]{new QFilter("org.id", "=", (Object)orgid), new QFilter(rowidKey, "=", (Object)rowId)};
    }

    private void setDefaultHeart() {
        Label heart = (Label)this.getControl("heart");
        long creator = ((DynamicObject)this.getModel().getValue("creator")).getLong("id");
        if (creator != 0L) {
            int heartQu = GLFabulousOperation.getFabulousOne((Long)creator, null, (boolean)Boolean.FALSE, (boolean)Boolean.TRUE);
            heart.setText(String.valueOf(heartQu));
        } else {
            heart.setText(String.valueOf(0));
        }
        if (!GLFabulousOperation.isThumbUp((long)creator, (String)formId)) {
            ((Image)this.getControl("imageap")).setUrl("/icons/pc/state/praised.png");
        }
    }

    private void showUnSupportComAssistTip() {
        long orgId = (Long)this.getModel().getValue(Key_Orgid);
        long bookTypeId = (Long)this.getModel().getValue(Key_Booktyepid);
        ComAssistTable.get((Long)orgId, (Long)bookTypeId).ifPresent(commonAssistTable -> {
            if (CollectionUtils.isNotEmpty((Collection)commonAssistTable.getCommonAssists())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u8bbe\u7f6e\u4e0d\u652f\u6301\u516c\u5171\u7ef4\u5ea6\u529f\u80fd\u3002", (String)"AutoTransEditPlugin_34", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            }
        });
    }

    private void clearQtyRelateFields(String[] fields, int index) {
        IDataModel model = this.getModel();
        for (String field : fields) {
            model.setValue(field, null, index);
        }
    }
}

