/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatObject;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.cache.CacheHelper;
import kd.fi.gl.cache.CacheModule;
import kd.fi.gl.cache.DistributeCache;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.util.AnalysisRptUtils;
import kd.fi.gl.util.FormExportUtil;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.PermissonType;
import kd.fi.gl.util.TaxReportFormHelper;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class BalancesheetPlugin
extends AbstractFormPlugin
implements ClickListener,
ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(BalancesheetPlugin.class);
    private static final String refresh = "refresh";
    private static final String reportEdit = "reportedit";
    private static final String export = "export";
    private static final String formEdit = "gl_balancesheetedit";
    private static final String period = "period";
    private static final String orgView = "orgview";
    private static final String bookType = "booktype";
    private static final String accTable = "accounttable";
    private static final String periodType = "periodtype";
    private static final String assetEntryKey = "assetentryentity";
    private static final String equityEntryKey = "equityentryentity";
    private static final String assetRow = "assetrow";
    private static final String equityRow = "equityrow";
    private static final String asset = "asset";
    private static final String equity = "equity";
    private static final String balrowId = "balrowid";
    private static final String assetBegin = "assetbegin";
    private static final String assetClose = "assetclose";
    private static final String equityBegin = "equitybegin";
    private static final String equityClose = "equityclose";
    private static final String Default_BalSheet_Asset_Query_Fields = "assetentryentity.seq seq, assetentryentity.asset asset";
    private static final String Default_BalSheet_Equity_Query_Fields = "equityentryentity.seq seq, equityentryentity.equity equity";
    public static final String IS_FINISH = "isFinish";
    public static final String IS_SUCCESS = "isSuccess";
    public static final String QUERY_DATA = "queryData";
    public static final String PROGRESSBARAP = "progressbarap";
    private static int processTime = 1;
    DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.report);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{refresh, reportEdit, export, period});
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid control = (EntryGrid)this.getControl(assetEntryKey);
        control.addHyperClickListener(evt -> this.showAccountBalanceRpt(evt, asset));
        EntryGrid control1 = (EntryGrid)this.getControl(equityEntryKey);
        control1.addHyperClickListener(evt -> this.showAccountBalanceRpt(evt, equity));
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        bar.addProgressListener((ProgresssListener)this);
    }

    private void showAccountBalanceRpt(HyperLinkClickEvent evt, String type) {
        int rowIndex = evt.getRowIndex() + 1;
        int colIndex = 0;
        String field = "";
        String fieldName = evt.getFieldName();
        if (asset.equals(type)) {
            switch (fieldName) {
                case "assetbegin": {
                    colIndex = 1;
                    field = asset;
                    break;
                }
                case "assetclose": {
                    colIndex = 2;
                    field = asset;
                    break;
                }
            }
        } else {
            switch (fieldName) {
                case "equitybegin": {
                    colIndex = 3;
                    field = equity;
                    break;
                }
                case "equityclose": {
                    colIndex = 4;
                    field = equity;
                    break;
                }
            }
        }
        DynamicObject item = (DynamicObject)this.getModel().getValue(field, evt.getRowIndex());
        AnalysisRptUtils.showAccountBalanceRpt((AbstractFormPlugin)this, (DynamicObject)item, (int)rowIndex, (int)colIndex, (String)"balancesheet");
    }

    public void afterCreateNewData(EventObject e) {
        String childOrgSetStr = this.getPageCache().get("childOrgSet");
        if (childOrgSetStr == null) {
            return;
        }
        Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
        this.setValue(childOrgSet);
        this.setCellBackColor();
    }

    public void setCellBackColor() {
        EntryGrid assetGrid = (EntryGrid)this.getControl(assetEntryKey);
        EntryGrid equityGrid = (EntryGrid)this.getControl(equityEntryKey);
        int[] assetIndexes = new int[]{11, 29, 38};
        assetGrid.setCellBackcolor(asset, "#fff8e1", assetIndexes);
        assetGrid.setCellBackcolor(assetRow, "#fff8e1", assetIndexes);
        assetGrid.setCellBackcolor(assetBegin, "#fff8e1", assetIndexes);
        assetGrid.setCellBackcolor(assetClose, "#fff8e1", assetIndexes);
        int[] equityIndexes = new int[]{12, 25, 26, 37, 38};
        equityGrid.setCellBackcolor(equity, "#fff8e1", equityIndexes);
        equityGrid.setCellBackcolor(equityRow, "#fff8e1", equityIndexes);
        equityGrid.setCellBackcolor(equityBegin, "#fff8e1", equityIndexes);
        equityGrid.setCellBackcolor(equityClose, "#fff8e1", equityIndexes);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (reportEdit.equals(key)) {
            this.showBalancesheetEdit();
        } else if (refresh.equals(key)) {
            String childOrgSetStr = this.getPageCache().get("childOrgSet");
            if (childOrgSetStr == null) {
                return;
            }
            Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
            this.setValue(childOrgSet);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (op.getOperateKey().equals(export)) {
            this.export(op.getPermissionItemId());
        }
    }

    public void export(String permissionItemId) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormExportUtil export = new FormExportUtil();
        List headInfo = AnalysisRptUtils.buildReportHeadInfo((AbstractFormPlugin)this);
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("seq");
        fieldList.add(asset);
        fieldList.add(assetBegin);
        fieldList.add(assetClose);
        fieldList.add(equity);
        fieldList.add(equityBegin);
        fieldList.add(equityClose);
        DynamicObjectCollection assetColl = model.getEntryEntity(assetEntryKey);
        DynamicObjectCollection equityColl = model.getEntryEntity(equityEntryKey);
        DynamicObjectCollection maxColl = assetColl.size() > equityColl.size() ? assetColl : equityColl;
        DynamicObjectCollection minColl = assetColl.size() > equityColl.size() ? equityColl : assetColl;
        ArrayList<DynamicObject[]> list = new ArrayList<DynamicObject[]>(maxColl.size());
        for (int i = 0; i < maxColl.size(); ++i) {
            DynamicObject maxDyn = (DynamicObject)maxColl.get(i);
            DynamicObject minDyn = i > minColl.size() - 1 ? null : (DynamicObject)minColl.get(i);
            list.add(new DynamicObject[]{maxDyn, minDyn});
        }
        String url = this.export(headInfo, list, fieldList, view, (DynamicObject)model.getValue("basecurrency"), permissionItemId);
        export.openUrl(url, view);
    }

    private void showBalancesheetEdit() {
        Long orgId;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        List<Long> orgIds = this.getOrgValue();
        long orgViewId = (Long)model.getValue("orgview_id");
        long bookTypeId = (Long)model.getValue("booktype_id");
        long accTableId = (Long)model.getValue("accounttable_id");
        String infoTip = "";
        if (orgIds.isEmpty()) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BalancesheetPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (orgIds.size() > 1) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u6838\u7b97\u7ec4\u7ec7\u8fdb\u884c\u7f16\u8f91\u3002", (String)"BalancesheetPlugin_1", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (orgViewId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u89c6\u56fe\u3002", (String)"BalancesheetPlugin_2", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (bookTypeId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"BalancesheetPlugin_3", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else if (accTableId == 0L) {
            infoTip = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"BalancesheetPlugin_4", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        } else {
            List listId = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)true, (PermissonType)PermissonType.NEW);
            if (!listId.contains(orgId = orgIds.get(0))) {
                infoTip = ResManager.loadKDString((String)"\u65e0\u201c\u8d44\u4ea7\u8d1f\u503a\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BalancesheetPlugin_5", (String)"fi-gl-formplugin", (Object[])new Object[0]);
            }
        }
        if (!infoTip.isEmpty()) {
            view.showTipNotification(infoTip);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formEdit);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        orgId = orgIds.get(0);
        showParameter.setCustomParam("orgId", (Object)orgId);
        showParameter.setCustomParam("orgViewId", (Object)orgViewId);
        showParameter.setCustomParam("bookTypeId", (Object)bookTypeId);
        showParameter.setCustomParam("accTableId", (Object)accTableId);
        showParameter.setCustomParam("type", (Object)"balancesheet");
        String isLeafOrg = this.getPageCache().get("isLeafOrg");
        showParameter.setCustomParam("isLeafOrg", (Object)isLeafOrg);
        FormShowParameter parent = view.getFormShowParameter();
        showParameter.setParentPageId(parent.getParentPageId());
        view.showForm(showParameter);
    }

    private void setValue(Set<Long> childOrgSet) {
        IDataModel model = this.getModel();
        List<Long> orgIds = this.getOrgValue();
        if (orgIds.isEmpty()) {
            return;
        }
        model.deleteEntryData(assetEntryKey);
        model.deleteEntryData(equityEntryKey);
        long orgViewId = (Long)model.getValue("orgview_id");
        long bookTypeId = (Long)model.getValue("booktype_id");
        long accTableId = (Long)model.getValue("accounttable_id");
        long periodTypeId = (Long)model.getValue("periodtype_id");
        long periodId = (Long)model.getValue("period_id");
        int amtprecision = 2;
        if (orgIds.size() > 1 && !this.checkParent(orgIds, accTableId, bookTypeId)) {
            return;
        }
        ((ProgressBar)this.getControl(PROGRESSBARAP)).start();
        ThreadService.execute(() -> {
            try {
                List<String> entityTypes = Arrays.asList(assetEntryKey, equityEntryKey);
                HashMap<String, List> balancesheet = new HashMap<String, List>(entityTypes.size());
                for (String entityType : entityTypes) {
                    balancesheet.put(entityType, TaxReportFormHelper.collectBal((List)orgIds, (Set)childOrgSet, (long)orgViewId, (long)bookTypeId, (long)accTableId, (long)periodTypeId, (long)periodId, (String)"balancesheet", (String)entityType, (int)4, (boolean)true));
                }
                this.distributeCache.put(this.getPageCacheKey(QUERY_DATA), SerializationUtils.toJsonString(balancesheet));
                this.distributeCache.put(this.getPageCacheKey(IS_SUCCESS), "true");
            }
            catch (Exception e) {
                this.distributeCache.put(this.getPageCacheKey(IS_SUCCESS), "false");
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.distributeCache.put(this.getPageCacheKey(IS_FINISH), "true");
            }
        }, (TaskType)TaskType.GL_BALANCE_SHEET_COLLECT_BAL);
        processTime = 1;
        this.showLoading();
    }

    private boolean multOrgBatchSetValue(Set<Long> childOrgSet, List<Long> orgIds, long orgViewId, long bookTypeId, long accTableId, long periodTypeId, long periodId, int amtprecision, Map<String, List<List<BigDecimal>>> balancesheet) {
        long parentOrg = GLRptTemplatePlugin.getParentOrgByChildre(orgIds);
        boolean result = this.multOrgBatchSetValueByType(parentOrg, childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision, assetEntryKey, balancesheet.get(assetEntryKey));
        if (result) {
            result = this.multOrgBatchSetValueByType(parentOrg, childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision, equityEntryKey, balancesheet.get(equityEntryKey));
        }
        return result;
    }

    private boolean multOrgBatchSetValueByType(long parentOrg, Set<Long> childOrgSet, List<Long> orgIds, long orgViewId, long bookTypeId, long accTableId, long periodTypeId, long periodId, int amtprecision, String entityType, List<List<BigDecimal>> assetResultList) {
        String selectFiled = assetEntryKey.equals(entityType) ? Default_BalSheet_Asset_Query_Fields : Default_BalSheet_Equity_Query_Fields;
        String orderby = assetEntryKey.equals(entityType) ? "assetentryentity.seq asc" : "equityentryentity.seq asc";
        DynamicObjectCollection parentAssetBalSheet = TaxReportFormHelper.getBalSheetsByEntityType(Collections.singleton(parentOrg), (long)accTableId, (QFilter[])new QFilter(bookType, "=", (Object)bookTypeId).toArray(), (String)selectFiled, (String)orderby);
        if (parentAssetBalSheet == null || parentAssetBalSheet.isEmpty()) {
            DynamicObject pOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)parentOrg, (String)"bos_org");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u5171\u540c\u4e0a\u7ea7%s\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u62a5\u8868\u7f16\u8f91\u516c\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"BalancesheetPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), pOrg != null ? pOrg.getString("name") : ""));
            return false;
        }
        this.buildParentSheet(parentAssetBalSheet, assetResultList, entityType);
        return true;
    }

    private void buildParentSheet(DynamicObjectCollection parentBalSheet, List<List<BigDecimal>> resultList, String entityType) {
        if (parentBalSheet.size() != resultList.size()) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        if (assetEntryKey.equals(entityType)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("seq", new Object[0]);
            vs.addField(asset, new Object[0]);
            vs.addField(assetBegin, new Object[0]);
            vs.addField(assetClose, new Object[0]);
            for (int i = 0; i < resultList.size(); ++i) {
                DynamicObject row = (DynamicObject)parentBalSheet.get(i);
                List<BigDecimal> balVal = resultList.get(i);
                Long assetId = row.getLong(asset);
                vs.addRow(new Object[]{row.get("seq"), assetId, balVal.get(0), balVal.get(1)});
            }
            model.batchCreateNewEntryRow(assetEntryKey, vs);
        } else if (equityEntryKey.equals(entityType)) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("seq", new Object[0]);
            vs.addField(equity, new Object[0]);
            vs.addField(equityBegin, new Object[0]);
            vs.addField(equityClose, new Object[0]);
            for (int i = 0; i < resultList.size(); ++i) {
                DynamicObject row = (DynamicObject)parentBalSheet.get(i);
                List<BigDecimal> balVal = resultList.get(i);
                Long equityId = row.getLong(equity);
                vs.addRow(new Object[]{row.get("seq"), equityId, balVal.get(0), balVal.get(1)});
            }
            model.batchCreateNewEntryRow(equityEntryKey, vs);
        }
        model.endInit();
        this.getView().updateView(entityType);
    }

    private Set<Long> getEntityOrg(List<Long> filterOrg) {
        HashSet<Long> result = new HashSet<Long>();
        try (DataSet dataSet = BatchProcessUtil.batchQueryDataSet(filterOrg, batchData -> QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", batchData), new QFilter("isbizunit", "=", (Object)true)}, null));){
            for (Row row : dataSet) {
                result.add(row.getLong("org"));
            }
        }
        return result;
    }

    private void batchSetValue(List<Long> orgIds, long bookTypeId, long accTableId, Map<String, List<List<BigDecimal>>> balancesheet) {
        DynamicObjectCollection equityCollection;
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter assetVs = new TableValueSetter(new String[0]);
        TableValueSetter equityVs = new TableValueSetter(new String[0]);
        DynamicObjectCollection assetCollection = TaxReportFormHelper.getBalSheetsByEntityType(new HashSet<Long>(orgIds), (long)accTableId, (QFilter[])new QFilter(bookType, "=", (Object)bookTypeId).toArray(), (String)Default_BalSheet_Asset_Query_Fields, (String)"assetentryentity.seq asc");
        if (!assetCollection.isEmpty()) {
            assetVs.addField(asset, new Object[0]);
            for (DynamicObject row : assetCollection) {
                assetVs.addRow(new Object[]{row.get(asset)});
            }
        } else {
            ArrayList<Long> projects_asset = new ArrayList<Long>();
            for (long i = 100001L; i <= 100039L; ++i) {
                projects_asset.add(i);
            }
            for (Long id : projects_asset) {
                assetVs.addField(asset, new Object[]{id});
            }
        }
        if (!(equityCollection = TaxReportFormHelper.getBalSheetsByEntityType(new HashSet<Long>(orgIds), (long)accTableId, (QFilter[])new QFilter(bookType, "=", (Object)bookTypeId).toArray(), (String)Default_BalSheet_Equity_Query_Fields, (String)"equityentryentity.seq asc")).isEmpty()) {
            equityVs.addField(equity, new Object[0]);
            for (DynamicObject row : equityCollection) {
                equityVs.addRow(new Object[]{row.get(equity)});
            }
        } else {
            ArrayList<Long> projects_equity = new ArrayList<Long>();
            for (long i = 100040L; i <= 100078L; ++i) {
                projects_equity.add(i);
            }
            for (Long l : projects_equity) {
                equityVs.addField(equity, new Object[]{l});
            }
        }
        List<List<BigDecimal>> assetResultList = balancesheet.get(assetEntryKey);
        for (List list : assetResultList) {
            assetVs.addField(assetBegin, new Object[]{list.get(0)});
            assetVs.addField(assetClose, new Object[]{list.get(1)});
        }
        List<List<BigDecimal>> equityResultList = balancesheet.get(equityEntryKey);
        for (List<BigDecimal> row : equityResultList) {
            equityVs.addField(equityBegin, new Object[]{row.get(0)});
            equityVs.addField(equityClose, new Object[]{row.get(1)});
        }
        model.batchCreateNewEntryRow(assetEntryKey, assetVs);
        model.batchCreateNewEntryRow(equityEntryKey, equityVs);
        model.endInit();
        this.getView().updateView(assetEntryKey);
        this.getView().updateView(equityEntryKey);
    }

    private void setProgressBar(Set<Long> childOrgSet, List<Long> orgIds, Long orgViewId, Long bookTypeId, Long accTableId, Long periodTypeId, Long periodId, int amtprecision) {
        HashMap map = new HashMap();
        String tag = "balancesheet";
        FormShowParameter parameter = TaxReportFormHelper.FinMainIndexFormShow((String)tag, childOrgSet, orgIds, (Long)orgViewId, (Long)bookTypeId, (Long)accTableId, (Long)periodTypeId, (Long)periodId, map, (int)amtprecision);
        this.getView().showForm(parameter);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        Object newObj = args.getChangeSet()[0].getNewValue();
        if (newObj == null) {
            return;
        }
        switch (propertyName) {
            case "orgs": 
            case "orgview": 
            case "booktype": 
            case "accounttable": 
            case "periodtype": 
            case "period": {
                String childOrgSetStr = this.getPageCache().get("childOrgSet");
                if (childOrgSetStr == null) {
                    return;
                }
                Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
                this.setValue(childOrgSet);
            }
        }
    }

    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    private String export(List<String> headInfos, List<DynamicObject[]> list, List<String> fieldList, IFormView view, DynamicObject currency, String permissionItemId) {
        FormExportUtil export = new FormExportUtil();
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        this.initFormat(currency);
        this.setTable(wb, sheet, headInfos, list, fieldList);
        try {
            FormShowParameter showParameter = view.getFormShowParameter();
            String caption = showParameter.getCaption();
            String url = export.writeFile(wb, caption);
            DistributeSessionlessCache distributeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            HashMap<String, String> refEntiryMap = new HashMap<String, String>(2);
            String tempFileId = url.split("id=")[1];
            refEntiryMap.put("entityNum", showParameter.getFormId());
            refEntiryMap.put("appId", showParameter.getServiceAppId());
            refEntiryMap.put("permissionItemId", permissionItemId);
            distributeCache.put("ReportTempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntiryMap), 7200);
            return url;
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initFormat(DynamicObject currency) {
        int amt = 2;
        String sign = "";
        if (currency != null) {
            amt = currency.getInt("amtprecision");
            sign = currency.getString("sign");
        }
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        fobj.getCurrencyFormat().setCurrencySymbols(sign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(amt);
    }

    public void setTable(HSSFWorkbook wb, HSSFSheet sheet, List<String> headInfos, List<DynamicObject[]> list, List<String> fieldList) {
        ArrayList<Map<String, String>> typeList = new ArrayList<Map<String, String>>();
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        int rowIndex = 0;
        rowIndex = FormExportUtil.createTitleCell((HSSFSheet)sheet, headInfos, (int)fieldList.size(), (HSSFCellStyle)style, (int)rowIndex);
        if (CollectionUtils.isNotEmpty(list)) {
            rowIndex = this.createHeadCell(sheet, list, fieldList, typeList, style, rowIndex);
            this.createDetailRowCell(sheet, list, typeList, style, rowIndex);
        }
    }

    private int createHeadCell(HSSFSheet sheet, List<DynamicObject[]> list, List<String> fieldList, List<Map<String, String>> typeList, HSSFCellStyle style, int rowIndex) {
        HSSFRow row = sheet.createRow(rowIndex);
        DynamicObject[] dynamicObjects = list.get(0);
        DynamicObject maxDyn = dynamicObjects[0];
        DynamicObject minDyn = dynamicObjects[1];
        DataEntityPropertyCollection maxDynProperties = maxDyn.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection minDynProperties = minDyn.getDynamicObjectType().getProperties();
        for (int i = 0; i < fieldList.size(); ++i) {
            String number = fieldList.get(i);
            DynamicProperty property = (DynamicProperty)maxDynProperties.get((Object)number);
            if (property == null) {
                FormExportUtil.createSingleCell(typeList, (HSSFCellStyle)style, (HSSFRow)row, (DataEntityPropertyCollection)minDynProperties, (int)i, (String)number);
                continue;
            }
            FormExportUtil.createSingleCell(typeList, (HSSFCellStyle)style, (HSSFRow)row, (DataEntityPropertyCollection)maxDynProperties, (int)i, (String)number);
        }
        return ++rowIndex;
    }

    private void createDetailRowCell(HSSFSheet sheet, List<DynamicObject[]> list, List<Map<String, String>> typeList, HSSFCellStyle style, int rowIndex) {
        for (int h = 0; h < list.size(); ++h) {
            HSSFRow createRow = sheet.createRow(h + rowIndex);
            DynamicObject[] dynamicObjects = list.get(h);
            DynamicObject maxDyn = dynamicObjects[0];
            DynamicObject minDyn = dynamicObjects[1];
            for (int i = 0; i < typeList.size(); ++i) {
                String number = typeList.get(i).get("number");
                String type = typeList.get(i).get("type");
                String value = "";
                if (number.equals("assetseq") || number.equals("equityseq")) {
                    number = "seq";
                }
                HSSFCell cell = createRow.createCell(i);
                if (type.equals("FieldProp")) {
                    value = maxDyn.containsProperty(number) ? maxDyn.getString(number) : (minDyn != null ? minDyn.getString(number) : "");
                } else if (type.equals("BasedataProp")) {
                    DynamicObject dynamicObject = maxDyn.containsProperty(number) ? maxDyn.getDynamicObject(number) : (minDyn != null ? minDyn.getDynamicObject(number) : null);
                    value = dynamicObject == null ? "" : dynamicObject.getString("name");
                } else if (type.equals("AmountProp")) {
                    cell.setCellValue((maxDyn.containsProperty(number) ? maxDyn.getBigDecimal(number) : (minDyn != null ? minDyn.getBigDecimal(number) : BigDecimal.ZERO)).doubleValue());
                    cell.setCellStyle(style);
                    continue;
                }
                cell.setCellValue(value);
                cell.setCellStyle(style);
            }
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        boolean isFinish = Boolean.parseBoolean(this.distributeCache.get(this.getPageCacheKey(IS_FINISH)));
        boolean isSuccess = Boolean.parseBoolean(this.distributeCache.get(this.getPageCacheKey(IS_SUCCESS)));
        ProgressBar bar = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (isFinish) {
            bar.stop();
            processTime = 1;
            this.getView().hideLoading();
            if (isSuccess) {
                String queryData = this.distributeCache.get(this.getPageCacheKey(QUERY_DATA));
                this.distributeCache.remove(this.getPageCacheKey(IS_FINISH));
                this.distributeCache.remove(this.getPageCacheKey(IS_SUCCESS));
                this.distributeCache.remove(this.getPageCacheKey(QUERY_DATA));
                List<Long> orgIds = this.getOrgValue();
                IDataModel model = this.getModel();
                String childOrgSetStr = this.getPageCache().get("childOrgSet");
                Set childOrgSet = (Set)GLUtil.fromSerializedString((String)childOrgSetStr);
                long orgViewId = (Long)model.getValue("orgview_id");
                long bookTypeId = (Long)model.getValue("booktype_id");
                long accTableId = (Long)model.getValue("accounttable_id");
                long periodTypeId = (Long)model.getValue("periodtype_id");
                long periodId = (Long)model.getValue("period_id");
                int amtprecision = 2;
                DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency");
                if (basecurrency != null) {
                    basecurrency.getInt("amtprecision");
                }
                Map balancesheet = (Map)SerializationUtils.fromJsonString((String)queryData, Map.class);
                if (orgIds.size() == 1) {
                    this.batchSetValue(orgIds, bookTypeId, accTableId, balancesheet);
                } else if (StringUtils.isNotEmpty((String)childOrgSetStr) && !this.multOrgBatchSetValue(childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision, balancesheet)) {
                    return;
                }
                this.setProgressBar(childOrgSet, orgIds, orgViewId, bookTypeId, accTableId, periodTypeId, periodId, amtprecision);
            }
        } else {
            this.showLoading();
        }
    }

    private void showLoading() {
        int percent = processTime * 3 > 99 ? 99 : processTime * 3;
        this.getView().showLoading(new LocaleString(String.format(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u4e2d\uff0c\u8fdb\u5ea6\uff1a%1$s%%\u3002", (String)"BalancesheetPlugin_13", (String)"fi-gl-formplugin", (Object[])new Object[0]), percent)));
        ++processTime;
    }

    private boolean checkParent(List<Long> orgIds, long accTableId, long bookTypeId) {
        Set<Long> mulSelectedEntityOrg = this.getEntityOrg(orgIds);
        if (mulSelectedEntityOrg.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u9009\u7ec4\u7ec7\u5fc5\u987b\u5305\u542b\u4e00\u4e2a\u5b9e\u4f53\u7ec4\u7ec7", (String)"BalancesheetPlugin_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        long parentOrg = GLRptTemplatePlugin.getParentOrgByChildre(orgIds);
        DynamicObjectCollection parentAssetBalSheet = TaxReportFormHelper.getBalSheetsByEntityType(Collections.singleton(parentOrg), (long)accTableId, (QFilter[])new QFilter(bookType, "=", (Object)bookTypeId).toArray(), (String)"", null);
        if (parentAssetBalSheet == null || parentAssetBalSheet.isEmpty()) {
            DynamicObject pOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)parentOrg, (String)"bos_org");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u5171\u540c\u4e0a\u7ea7%s\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u62a5\u8868\u7f16\u8f91\u516c\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"BalancesheetPlugin_7", (String)"fi-gl-formplugin", (Object[])new Object[0]), pOrg != null ? pOrg.getString("name") : ""));
            return false;
        }
        return true;
    }

    private String getPageCacheKey(String key) {
        String pageId = this.getView().getPageId();
        return pageId + key;
    }
}

