/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.gl.assistitem.CashFLowItemFlexValueGetter;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.formplugin.comassist.AbstractComAssistBillPlugin;
import kd.fi.gl.util.GLUtil;

public class CashFlowItemEditPlugin
extends AbstractComAssistBillPlugin {
    private static final Log logger = LogFactory.getLog(CashFlowItemEditPlugin.class);
    private static final int COLLECTION_THRESHOLD = 800;
    private static final String CACHE_KEY = "entryContext";
    private static final String LOCAL_SET = "localSet";
    private static final Set<String> PROPERTY_CHANGED_LISTENER = Sets.newHashSet((Object[])new String[]{"maincfitem", "suppcfitem", "maincfamount"});

    public void initialize() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"notifyflexpanel"});
    }

    public void afterBindData(EventObject e) {
        DynamicObject voucher;
        super.afterBindData(e);
        DynamicObjectCollection entryCollection = this.getModel().getEntryEntity("entries");
        if (CollectionUtils.isEmpty((Collection)entryCollection)) {
            return;
        }
        if (entryCollection.size() > 800) {
            logger.warn(String.format("\u8bbe\u7f6e\u73b0\u91d1\u6d41\u91cf\u5206\u5f55\u884c\u6570\u8d85\u8fc7\u9650\u5236\u884c\u6570!actualSize=%s,collectionThreshold=%s", entryCollection.size(), 800));
        }
        if (CashflowLocalSetUtil.isLocalSet((long)(voucher = this.getModel().getDataEntity()).getLong("org_id"), (Date)voucher.getDate("bookeddate"))) {
            this.getPageCache().put(LOCAL_SET, "true");
        } else {
            this.getPageCache().put(LOCAL_SET, "false");
        }
        EntryContext entryContext = this.buildEntryContext(voucher, entryCollection);
        this.getPageCache().put(CACHE_KEY, SerializationUtils.toJsonString((Object)entryContext));
        this.setFieldsVisible(entryContext);
        this.setFieldsEditable(entryContext);
    }

    public void registerListener(EventObject e) {
        BasedataEdit suppcf;
        super.registerListener(e);
        BasedataEdit maincf = (BasedataEdit)this.getView().getControl("maincfitem");
        if (maincf != null) {
            maincf.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                List filters = param.getListFilterParameter().getQFilters();
                QFilter filter = new QFilter("isleaf", "=", (Object)"1").and(new QFilter("isprefit", "=", (Object)Boolean.FALSE)).and(new QFilter("direction", "!=", (Object)"b"));
                DynamicObject period = (DynamicObject)this.getModel().getValue("period");
                filters.add(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
                filters.add(new QFilter("startdate", "<=", (Object)period.getDate("enddate")));
                filters.add(filter);
            });
        }
        if ((suppcf = (BasedataEdit)this.getView().getControl("suppcfitem")) != null) {
            suppcf.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                List filters = param.getListFilterParameter().getQFilters();
                QFilter filter = new QFilter("isleaf", "=", (Object)"1").and(new QFilter("isprefit", "=", (Object)Boolean.FALSE));
                filters.add(filter);
            });
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!PROPERTY_CHANGED_LISTENER.contains(e.getProperty().getName())) {
            return;
        }
        String cacheContext = this.getPageCache().get(CACHE_KEY);
        if (StringUtils.isBlank((CharSequence)cacheContext)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9875\u9762\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"CashFlowItemEditPlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            logger.warn("load entryContext from page cache return null\uff01");
            return;
        }
        EntryContext entryContext = (EntryContext)SerializationUtils.fromJsonString((String)cacheContext, EntryContext.class);
        entryContext.setPropertyEdit(true);
        boolean localSet = Boolean.parseBoolean(this.getPageCache().get(LOCAL_SET));
        String changePropertyName = e.getProperty().getName();
        for (ChangeData changeData : e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            if (newValue == null) {
                this.invokeClearAction(changePropertyName, changeData);
            } else {
                this.invokeEditAction(changePropertyName, changeData, entryContext);
            }
            DynamicObject rowData = this.getModel().getEntryRowEntity("entries", rowIndex);
            DynamicObject account = rowData.getDynamicObject("account");
            DynamicObject mainCF = rowData.getDynamicObject("maincfitem");
            this.doSetFieldsEditable(rowIndex, account, mainCF, entryContext, localSet);
        }
    }

    private void invokeEditAction(String changePropertyName, ChangeData changeData, EntryContext entryContext) {
        IDataModel m;
        if ("maincfitem".equals(changePropertyName)) {
            this.doEditMainCF(changeData);
        } else if ("suppcfitem".equals(changePropertyName)) {
            this.doEditSuppCF(changeData, entryContext);
        } else if ("maincfamount".equals(changePropertyName) && (m = this.getModel()).getValue("suppcfitem") != null) {
            int rowIndex = changeData.getRowIndex();
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            DynamicObject acct = (DynamicObject)m.getValue("account", rowIndex);
            if (GLUtil.isPLAcct((DynamicObject)acct)) {
                BigDecimal amt = ((BigDecimal)m.getValue("debitlocal", rowIndex)).subtract((BigDecimal)m.getValue("creditlocal", rowIndex));
                m.setValue("suppcfamount", (Object)amt);
            } else {
                DynamicObject obj = (DynamicObject)m.getValue("maincfitem");
                if (obj != null) {
                    BigDecimal amt = "o".equals(obj.getString("direction")) ? newValue.negate() : newValue;
                    m.setValue("suppcfamount", (Object)amt);
                }
            }
        }
    }

    private void invokeClearAction(String changePropertyName, ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        if ("maincfitem".equals(changePropertyName)) {
            this.doClearMainCF(rowIndex);
        } else if ("suppcfitem".equals(changePropertyName)) {
            this.doClearSuppCF(rowIndex);
        }
    }

    private void doEditMainCF(ChangeData changeData) {
        boolean localSet = Boolean.parseBoolean(this.getPageCache().get(LOCAL_SET));
        int rowIndex = changeData.getRowIndex();
        DynamicObject mainCF = (DynamicObject)changeData.getNewValue();
        this.getModel().setValue("suppcfitem", null, rowIndex);
        this.getModel().setValue("suppcfamount", (Object)0, rowIndex);
        if (!mainCF.getBoolean("isassist")) {
            this.getModel().setValue("maincfassgrp", null, rowIndex);
        } else {
            this.autoSetAssgrp(mainCF, rowIndex);
        }
        DynamicObject rowData = this.getModel().getEntryRowEntity("entries", rowIndex);
        BigDecimal value = rowData.getBigDecimal("creditlocal").subtract(rowData.getBigDecimal("debitlocal"));
        BigDecimal bigDecimal = value = "o".equals(mainCF.getString("direction")) ? value.negate() : value;
        if (localSet) {
            value = value.negate();
        }
        this.getModel().setValue("maincfamount", (Object)value, rowIndex);
    }

    private void doEditSuppCF(ChangeData changeData, EntryContext entryContext) {
        BigDecimal value;
        boolean localSet = Boolean.parseBoolean(this.getPageCache().get(LOCAL_SET));
        int rowIndex = changeData.getRowIndex();
        DynamicObject rowData = this.getModel().getEntryRowEntity("entries", rowIndex);
        DynamicObject account = rowData.getDynamicObject("account");
        DynamicObject mainCF = rowData.getDynamicObject("maincfitem");
        boolean isProfitLossAccount = this.isProfitLossAccount(entryContext, account);
        boolean isDealActivity = this.isDealActivity(mainCF);
        boolean isNonDealActivity = this.isNonDealActivity(mainCF);
        if (mainCF == null) {
            value = rowData.getBigDecimal("creditlocal").subtract(rowData.getBigDecimal("debitlocal"));
            if (localSet) {
                value = value.negate();
            }
        } else if (isProfitLossAccount && isNonDealActivity) {
            value = rowData.getBigDecimal("debitlocal").subtract(rowData.getBigDecimal("creditlocal"));
        } else if (!isProfitLossAccount && isDealActivity) {
            BigDecimal mainCFAmount = rowData.getBigDecimal("maincfamount");
            value = "o".equals(mainCF.getString("direction")) ? mainCFAmount.negate() : mainCFAmount;
        } else {
            logger.warn(String.format("\u79d1\u76ee\u4e0e\u4e3b\u8868\u9879\u76ee\u5904\u4e8e\u672a\u77e5\u72b6\u6001:isProfitLossAccount=%s,isDealActivity=%s,isNonDealActivity=%s", isProfitLossAccount, isDealActivity, isNonDealActivity));
            return;
        }
        this.getModel().setValue("suppcfamount", (Object)value, rowIndex);
    }

    private void doClearMainCF(int rowIndex) {
        this.getModel().setValue("maincfassgrp", null, rowIndex);
        this.getModel().setValue("suppcfitem", null, rowIndex);
        this.getModel().setValue("maincfamount", (Object)0, rowIndex);
        this.getModel().setValue("suppcfamount", (Object)0, rowIndex);
    }

    private void doClearSuppCF(int rowIndex) {
        this.getModel().setValue("suppcfamount", (Object)0, rowIndex);
    }

    private EntryContext buildEntryContext(DynamicObject voucher, DynamicObjectCollection entryCollection) {
        EntryContext context = new EntryContext();
        boolean isAllCashAccount = true;
        boolean isAllNonCashAccount = true;
        boolean isExistCashAccount = false;
        boolean isExistProfitLossAccount = false;
        boolean isExistNotCashNotPLAccount = false;
        HashSet<Long> plAccounts = new HashSet<Long>(8);
        for (DynamicObject rowData : entryCollection) {
            DynamicObject account = rowData.getDynamicObject("account");
            if (account == null || AccountType.isBudgetType((long)account.getLong("accounttype_id"))) continue;
            boolean isCashAccount = this.isCashAccount(account);
            boolean isPLAccount = GLUtil.isPLAcct((DynamicObject)account);
            boolean isNotCashNotPLAccount = !isCashAccount && !isPLAccount;
            isAllCashAccount = isAllCashAccount && isCashAccount;
            isAllNonCashAccount = isAllNonCashAccount && !isCashAccount;
            isExistCashAccount = isExistCashAccount || isCashAccount;
            isExistProfitLossAccount = isExistProfitLossAccount || isPLAccount;
            boolean bl = isExistNotCashNotPLAccount = isExistNotCashNotPLAccount || isNotCashNotPLAccount;
            if (!isPLAccount) continue;
            plAccounts.add(account.getLong("id"));
        }
        context.setExistCashAccount(isExistCashAccount);
        context.setAllCashAccount(isAllCashAccount);
        context.setAllNonCashAccount(isAllNonCashAccount);
        context.setExistProfitLossAccount(isExistProfitLossAccount);
        context.setExistNotCashNotPLAccount(isExistNotCashNotPLAccount);
        context.setProfitLossAccountList(new ArrayList<Long>(plAccounts));
        return context;
    }

    private void setFieldsVisible(EntryContext entryContext) {
        if (entryContext.isAllCashAccount() || entryContext.isAllNonCashAccount()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"maincfitem"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"maincfassgrp"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"maincfamount"});
        }
    }

    private void setFieldsEditable(EntryContext entryContext) {
        DynamicObjectCollection entryCollection = this.getModel().getEntryEntity("entries");
        boolean localSet = Boolean.parseBoolean(this.getPageCache().get(LOCAL_SET));
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject rowData = (DynamicObject)entryCollection.get(i);
            DynamicObject account = rowData.getDynamicObject("account");
            DynamicObject mainCF = rowData.getDynamicObject("maincfitem");
            this.doSetFieldsEditable(i, account, mainCF, entryContext, localSet);
        }
    }

    private void doSetFieldsEditable(int rowIndex, DynamicObject account, DynamicObject mainCF, EntryContext entryContext, boolean localSet) {
        boolean suppCFEditable;
        boolean mainAssgrpEditable;
        Objects.requireNonNull(entryContext, "entryContext is null!");
        if (AccountType.isBudgetType((long)account.getLong("accounttype_id"))) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"maincfitem", "maincfassgrp", "maincfamount", "suppcfitem", "suppcfamount"});
            return;
        }
        boolean isCashAccount = this.isCashAccount(account);
        boolean isProfitLossAccount = this.isProfitLossAccount(entryContext, account);
        boolean isDealActivity = this.isDealActivity(mainCF);
        boolean isNonDealActivity = this.isNonDealActivity(mainCF);
        boolean mainCFEditable = !localSet && !isCashAccount && entryContext.isExistCashAccount() || localSet && isCashAccount && (entryContext.isExistNotCashNotPLAccount() || entryContext.isExistProfitLossAccount());
        boolean bl = mainAssgrpEditable = mainCF != null && mainCF.getBoolean("isassist");
        boolean bl2 = !localSet ? !isCashAccount && (!isProfitLossAccount && isDealActivity || isProfitLossAccount && isNonDealActivity) && entryContext.isExistCashAccount() || !isProfitLossAccount && !entryContext.isExistCashAccount() && entryContext.isExistProfitLossAccount() : (suppCFEditable = (entryContext.isExistNotCashNotPLAccount() || entryContext.isExistProfitLossAccount()) && isCashAccount && isDealActivity || (entryContext.isExistCashAccount() || entryContext.isExistNotCashNotPLAccount()) && isProfitLossAccount);
        if (!entryContext.isPropertyEdit()) {
            this.getView().setEnable(Boolean.valueOf(mainCFEditable), rowIndex, new String[]{"maincfitem"});
        }
        this.getView().setEnable(Boolean.valueOf(mainCFEditable && mainCF != null), rowIndex, new String[]{"maincfamount"});
        this.getView().setEnable(Boolean.valueOf(mainAssgrpEditable), rowIndex, new String[]{"maincfassgrp"});
        this.getView().setEnable(Boolean.valueOf(suppCFEditable), rowIndex, new String[]{"suppcfitem"});
        if (!entryContext.isExistCashAccount() && entryContext.isExistProfitLossAccount()) {
            this.getView().setEnable(Boolean.valueOf(suppCFEditable), rowIndex, new String[]{"suppcfamount"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"suppcfamount"});
        }
    }

    private boolean isCashAccount(DynamicObject account) {
        return account != null && (account.getBoolean("iscash") || account.getBoolean("isbank") || account.getBoolean("iscashequivalent"));
    }

    private boolean isDealActivity(DynamicObject mainCF) {
        return mainCF != null && mainCF.getBoolean("isdealactivity");
    }

    private boolean isNonDealActivity(DynamicObject mainCF) {
        return mainCF != null && !mainCF.getBoolean("isdealactivity");
    }

    private boolean isProfitLossAccount(EntryContext entryContext, DynamicObject account) {
        if (account == null) {
            return false;
        }
        if (entryContext.isPropertyEdit() && entryContext.isExistProfitLossAccount()) {
            QFilter accountTypeFilter = new QFilter("accounttype.accounttype", "=", (Object)"4");
            QFilter accountIdFilter = new QFilter("id", "=", account.getPkValue());
            return QueryServiceHelper.exists((String)"bd_accountview", (QFilter[])new QFilter[]{accountTypeFilter, accountIdFilter});
        }
        return entryContext.isExistProfitLossAccount() && entryContext.getProfitLossAccountList().contains(account.getLong("id"));
    }

    private void autoSetAssgrp(DynamicObject newMainCfItem, int index) {
        if (newMainCfItem == null || !newMainCfItem.getBoolean("isassist")) {
            return;
        }
        DynamicObject accountAssgrpDyn = (DynamicObject)this.getModel().getValue("assgrp", index);
        if (accountAssgrpDyn == null) {
            return;
        }
        String accountAssgrpValue = accountAssgrpDyn.getString("value");
        CashFLowItemFlexValueGetter flexValueGetter = new CashFLowItemFlexValueGetter();
        long mappingAssgrpId = flexValueGetter.getFromAccountFlexValueJson(new FlexValueJson(accountAssgrpValue), newMainCfItem.getLong("id"), this.getOrgId());
        this.getModel().setValue("maincfassgrp", (Object)mappingAssgrpId, index);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        MutexHelper.release((String)"gl_voucher", (String)"modify", (String)String.valueOf(this.getModel().getValue("id")));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if ("save".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)Boolean.TRUE);
        }
    }

    private static class EntryContext
    implements Serializable {
        private boolean existProfitLossAccount;
        private boolean existCashAccount;
        private boolean allCashAccount;
        private boolean allNonCashAccount;
        private transient List<Long> profitLossAccountList;
        private transient boolean propertyEdit;
        private boolean existNotCashNotPLAccount;

        public boolean isExistProfitLossAccount() {
            return this.existProfitLossAccount;
        }

        public void setExistProfitLossAccount(boolean existProfitLossAccount) {
            this.existProfitLossAccount = existProfitLossAccount;
        }

        public boolean isExistCashAccount() {
            return this.existCashAccount;
        }

        public void setExistCashAccount(boolean existCashAccount) {
            this.existCashAccount = existCashAccount;
        }

        public boolean isAllCashAccount() {
            return this.allCashAccount;
        }

        public void setAllCashAccount(boolean allCashAccount) {
            this.allCashAccount = allCashAccount;
        }

        public boolean isAllNonCashAccount() {
            return this.allNonCashAccount;
        }

        public void setAllNonCashAccount(boolean allNonCashAccount) {
            this.allNonCashAccount = allNonCashAccount;
        }

        public List<Long> getProfitLossAccountList() {
            return this.profitLossAccountList;
        }

        public void setProfitLossAccountList(List<Long> profitLossAccountList) {
            this.profitLossAccountList = profitLossAccountList;
        }

        public boolean isPropertyEdit() {
            return this.propertyEdit;
        }

        public void setPropertyEdit(boolean propertyEdit) {
            this.propertyEdit = propertyEdit;
        }

        public boolean isExistNotCashNotPLAccount() {
            return this.existNotCashNotPLAccount;
        }

        public void setExistNotCashNotPLAccount(boolean existNotCashNotPLAccount) {
            this.existNotCashNotPLAccount = existNotCashNotPLAccount;
        }
    }
}

