/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowCounter;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowPanelManager;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowStatusManager;
import kd.fi.gl.formplugin.voucher.VoucherEditValueGetter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.formplugin.voucher.cashflow.DataEntityCalculator;
import kd.fi.gl.formplugin.voucher.cashflow.DataSetRowCalculator;
import kd.fi.gl.formplugin.voucher.cashflow.Result;
import kd.fi.gl.util.GLUtil;

public class VoucherEditCashFlowCalculator {
    private final VoucherEditView voucherEditView;

    public VoucherEditCashFlowCalculator(VoucherEditView voucherEditView) {
        this.voucherEditView = voucherEditView;
    }

    public void ensureInitCashFlowTotal() {
        this.ensureInitCashFlowTotal(false);
    }

    public void ensureInitCashFlowTotal(boolean forceInit) {
        VoucherEditValueGetter valueGetter = this.voucherEditView.getValueGetter();
        VoucherEditCashFlowStatusManager statusManager = this.voucherEditView.getService(VoucherEditCashFlowStatusManager.class);
        VoucherEditCashFlowCounter cashFlowCounter = this.voucherEditView.getService(VoucherEditCashFlowCounter.class);
        boolean localSet = statusManager.isLocalSet();
        int cashCount = cashFlowCounter.getCashCount();
        if (cashCount < 0 || forceInit) {
            IDataModel m = this.voucherEditView.getVoucherEditModel();
            DynamicObjectCollection entries = valueGetter.getVoucherEntries();
            Object cfiml = null;
            cfiml = !this.voucherEditView.isFromTemplateVoucher() && m.getDataEntity().getDataEntityState().getFromDatabase() && entries.size() < valueGetter.getEntryCount() ? new DataSetRowCalculator() : new DataEntityCalculator();
            Result result = cfiml.calCfInfo(m.getDataEntity(true), localSet);
            cashFlowCounter.setCashCount(result.getCashCount());
            cashFlowCounter.setPLCount(result.getPlCount());
            cashFlowCounter.setNonCashNonPLCount(result.getNnCount());
            m.setValue("cashtotal", (Object)result.getCashtotalamt());
            m.setValue("cashunused", (Object)result.getCashtotalamt().subtract(result.getCashtotalused()));
            m.setValue("pltotal", (Object)result.getPltotalamt());
            m.setValue("plunused", (Object)result.getPltotalamt().subtract(result.getPltotalused()));
            if (result.getCashCount() == 0 && result.getPlCount() == 0 && result.isHasSupp()) {
                statusManager.setAdjustment(true);
            }
        }
    }

    public void calculateAndSetCashFlowAmount(int index) {
        IDataModel m = this.voucherEditView.getVoucherEditModel();
        boolean localSet = this.voucherEditView.getService(VoucherEditCashFlowStatusManager.class).isLocalSet();
        if (null != m.getValue("maincfitem", index)) {
            DynamicObject maincf = (DynamicObject)m.getValue("maincfitem", index);
            int dc = 1;
            if ("o".equals(maincf.getString("direction"))) {
                dc = -1;
            }
            BigDecimal creditlocal = (BigDecimal)m.getValue("creditlocal", index);
            BigDecimal debitlocal = (BigDecimal)m.getValue("debitlocal", index);
            BigDecimal cfamt = creditlocal.subtract(debitlocal);
            if (dc == -1) {
                cfamt = cfamt.negate();
            }
            if (localSet) {
                cfamt = cfamt.negate();
            }
            if (this.voucherEditView.isCurrentRowIndex(index)) {
                m.setValue("maincfamt", (Object)cfamt);
            } else {
                m.setValue("maincfamount", (Object)cfamt, index);
                if (m.getValue("suppcfitem", index) != null) {
                    this.updateSuppFromMain(cfamt, index);
                }
            }
        } else if (null != m.getValue("suppcfitem", index)) {
            BigDecimal creditlocal = (BigDecimal)m.getValue("creditlocal", index);
            BigDecimal debitlocal = (BigDecimal)m.getValue("debitlocal", index);
            BigDecimal suppamt = creditlocal.subtract(debitlocal);
            if (localSet) {
                suppamt = suppamt.negate();
            }
            if (this.voucherEditView.isCurrentRowIndex(index)) {
                m.setValue("suppcfamt", (Object)suppamt);
            } else {
                m.setValue("suppcfamount", (Object)suppamt, index);
            }
        }
    }

    public void updateSuppFromMain(BigDecimal newValue, int index) {
        IDataModel m = this.voucherEditView.getVoucherEditModel();
        BigDecimal resultAcmount = BigDecimal.ZERO;
        DynamicObject acct = (DynamicObject)m.getValue("account", index);
        if (GLUtil.isPLAcct((DynamicObject)acct)) {
            resultAcmount = ((BigDecimal)m.getValue("debitlocal", index)).subtract((BigDecimal)m.getValue("creditlocal", index));
        } else {
            DynamicObject obj;
            DynamicObject dynamicObject = obj = this.voucherEditView.isCurrentRowIndex(index) ? (DynamicObject)m.getValue("maincf") : this.voucherEditView.getValueGetter().getMainCfItem(index);
            if (obj != null) {
                resultAcmount = "o".equals(obj.getString("direction")) ? newValue.negate() : newValue;
            }
        }
        if (index == this.voucherEditView.getValueGetter().getEntriesCurrentRowIndex()) {
            m.setValue("suppcfamt", (Object)resultAcmount);
        } else {
            m.setValue("suppcfamount", (Object)resultAcmount, index);
        }
    }

    public void calculateAndSetSuppAmount(int index) {
        IDataModel m = this.voucherEditView.getVoucherEditModel();
        IPageCache cache = this.voucherEditView.getPageCache();
        if (null != cache.get("adjustment")) {
            BigDecimal amt = ((BigDecimal)m.getValue("creditlocal", index)).subtract((BigDecimal)m.getValue("debitlocal", index));
            int cashAcctCount = this.voucherEditView.getService(VoucherEditCashFlowCounter.class).getCashCount();
            if (cashAcctCount <= 0 && GLUtil.isPLAcct((DynamicObject)((DynamicObject)m.getValue("account", index)))) {
                amt = BigDecimal.ZERO;
            }
            m.setValue("suppcfamount", (Object)amt, index);
            m.setValue("suppcfamt", (Object)amt);
        }
    }

    public void handleDeleteRow(int index) {
        VoucherEditValueGetter valueGetter = this.voucherEditView.getValueGetter();
        boolean localSet = this.voucherEditView.getService(VoucherEditCashFlowStatusManager.class).isLocalSet();
        IDataModel model = this.voucherEditView.getVoucherEditModel();
        DynamicObject accountDyn = valueGetter.getAccount(index);
        if (accountDyn == null) {
            return;
        }
        VoucherEditCashFlowCounter cashFlowCounter = this.voucherEditView.getService(VoucherEditCashFlowCounter.class);
        int cashCount = cashFlowCounter.getCashCount();
        int plCount = cashFlowCounter.getPLCount();
        int nCAshNPLCount = cashFlowCounter.getNonCashNonPLCount();
        if (!AccountType.isBudgetType((long)accountDyn.getLong("accounttype_id")) && (!localSet && GLUtil.isCashAcct((DynamicObject)accountDyn) && cashCount == 1 || nCAshNPLCount == 1 && !GLUtil.isCashAcct((DynamicObject)accountDyn) && !GLUtil.isPLAcct((DynamicObject)accountDyn) && (plCount == 0 || cashCount == 0) || cashCount == 1 && GLUtil.isCashAcct((DynamicObject)accountDyn) && (plCount == 0 || nCAshNPLCount == 0) || plCount == 1 && GLUtil.isPLAcct((DynamicObject)accountDyn) && (cashCount == 0 || nCAshNPLCount == 0))) {
            this.voucherEditView.getService(VoucherEditCashFlowPanelManager.class).hideCashFlow(true, true, index);
            int curIndex = valueGetter.getEntriesCurrentRowIndex();
            for (int j = 0; j < valueGetter.getEntryCount(); ++j) {
                if (null == model.getValue("account", j)) continue;
                model.setEntryCurrentRowIndex(this.getEntryKey(), j);
                this.resetRowCashInfo(j);
            }
            model.setEntryCurrentRowIndex(this.getEntryKey(), curIndex);
        }
        this.handleAccountChanged(accountDyn, null, index);
    }

    public void handleAccountChanged(DynamicObject oldAccount, DynamicObject newAccount, int index) {
        boolean voucherSignChange;
        boolean localSet = this.voucherEditView.getService(VoucherEditCashFlowStatusManager.class).isLocalSet();
        VoucherEditCashFlowPanelManager cashFlowPanelManager = this.voucherEditView.getService(VoucherEditCashFlowPanelManager.class);
        IDataModel model = this.voucherEditView.getVoucherEditModel();
        boolean oldIsCash = GLUtil.isCashAcct((DynamicObject)oldAccount);
        boolean newIsCash = GLUtil.isCashAcct((DynamicObject)newAccount);
        boolean oldIsPL = GLUtil.isPLAcct((DynamicObject)oldAccount);
        boolean newIsPl = GLUtil.isPLAcct((DynamicObject)newAccount);
        boolean oldIsNCashNPl = GLUtil.isNCashNPLAcct((DynamicObject)oldAccount);
        boolean newIsNCashNPl = GLUtil.isNCashNPLAcct((DynamicObject)newAccount);
        VoucherEditCashFlowCounter cashFlowCounter = this.voucherEditView.getService(VoucherEditCashFlowCounter.class);
        int cashCount = cashFlowCounter.getCashCount();
        int nonCashNonPLCount = cashFlowCounter.getNonCashNonPLCount();
        int plCount = cashFlowCounter.getPLCount();
        boolean bl = voucherSignChange = cashCount < 0 && plCount < 0;
        if (oldIsCash && !newIsCash && cashCount >= 0) {
            if (cashCount == 0) {
                this.voucherEditView.getVchFormView().showErrorNotification(ResManager.loadKDString((String)"\u73b0\u91d1\u79d1\u76ee\u6570\u5408\u8ba1\u5f02\u5e38\u3002", (String)"VoucherEdit_41", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!localSet && cashCount == 0 || localSet && cashCount == 0 && newIsPl && nonCashNonPLCount == 0 || localSet && --cashCount == 0 && newIsNCashNPl && plCount == 0) {
                voucherSignChange = true;
            }
            this.acctChange(false, true, false, index);
            if (localSet) {
                cashFlowPanelManager.hideCashFlow(true, true, index);
            }
            cashFlowCounter.setCashCount(cashCount);
        } else if (!oldIsCash && newIsCash && cashCount >= 0) {
            if (!localSet && cashCount == 0) {
                voucherSignChange = true;
            }
            this.acctChange(true, true, false, index);
            if (!localSet) {
                cashFlowPanelManager.hideCashFlow(true, true, index);
            }
            cashFlowCounter.setCashCount(++cashCount);
        }
        if (oldIsPL && !newIsPl) {
            if (plCount == 0) {
                this.voucherEditView.getVchFormView().showErrorNotification(ResManager.loadKDString((String)"\u635f\u76ca\u79d1\u76ee\u6570\u5408\u8ba1\u5f02\u5e38\u3002", (String)"VoucherEdit_42", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!localSet && this.isOnlySupp() && --plCount == 0 || localSet && newIsCash && plCount == 0 && nonCashNonPLCount == 0) {
                voucherSignChange = true;
            }
            if (localSet && newIsCash && plCount == 0) {
                voucherSignChange = true;
            }
            this.acctChange(false, false, true, index);
            if (localSet) {
                cashFlowPanelManager.hideCashFlow(false, true, index);
            }
            cashFlowCounter.setPLCount(plCount);
        } else if (!oldIsPL && newIsPl) {
            cashFlowCounter.setPLCount(++plCount);
            this.acctChange(true, false, true, index);
            if (this.isOnlySupp() && !localSet) {
                cashFlowPanelManager.hideCashFlow(true, true, index);
            }
        }
        if (oldIsNCashNPl && !newIsNCashNPl) {
            if (nonCashNonPLCount == 0) {
                this.voucherEditView.getVchFormView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u73b0\u975e\u635f\u79d1\u76ee\u6570\u5408\u8ba1\u5f02\u5e38\u3002", (String)"VoucherEdit_45", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            if (localSet && --nonCashNonPLCount == 0 && (cashCount == 0 || plCount == 0)) {
                voucherSignChange = true;
            }
            cashFlowCounter.setNonCashNonPLCount(nonCashNonPLCount);
        } else if (!oldIsNCashNPl && newIsNCashNPl) {
            cashFlowCounter.setNonCashNonPLCount(++nonCashNonPLCount);
        }
        if (voucherSignChange && this.voucherEditView.getPageCache().get("isAgainst") == null) {
            int count = this.voucherEditView.getValueGetter().getEntryCount();
            for (int i = 0; i < count; ++i) {
                this.resetRowCashInfo(i);
            }
            model.setEntryCurrentRowIndex(this.getEntryKey(), index);
        } else if (oldAccount == null || newAccount == null || !Objects.equals(oldAccount.getLong("masterid"), newAccount.getLong("masterid"))) {
            this.resetRowCashInfo(index);
        }
    }

    private void acctChange(boolean isAdd, boolean isCash, boolean isPL, int rowIndex) {
        BigDecimal crAmt;
        BigDecimal drAmt;
        IDataModel m;
        if (isCash) {
            m = this.voucherEditView.getVoucherEditModel();
            BigDecimal cashTotal = (BigDecimal)m.getValue("cashtotal");
            drAmt = (BigDecimal)m.getValue("debitlocal", rowIndex);
            crAmt = (BigDecimal)m.getValue("creditlocal", rowIndex);
            cashTotal = isAdd ? cashTotal.add(drAmt).subtract(crAmt) : cashTotal.add(crAmt).subtract(drAmt);
            m.setValue("cashtotal", (Object)cashTotal);
            BigDecimal cashUnused = (BigDecimal)m.getValue("cashunused");
            cashUnused = isAdd ? cashUnused.add(drAmt).subtract(crAmt) : cashUnused.add(crAmt).subtract(drAmt);
            m.setValue("cashunused", (Object)cashUnused);
        }
        if (isPL) {
            m = this.voucherEditView.getVoucherEditModel();
            BigDecimal plTotal = (BigDecimal)m.getValue("pltotal");
            drAmt = (BigDecimal)m.getValue("debitlocal", rowIndex);
            crAmt = (BigDecimal)m.getValue("creditlocal", rowIndex);
            plTotal = isAdd ? plTotal.add(drAmt).subtract(crAmt) : plTotal.add(crAmt).subtract(drAmt);
            m.setValue("pltotal", (Object)plTotal);
            BigDecimal plUnused = (BigDecimal)m.getValue("plunused");
            plUnused = isAdd ? plUnused.add(drAmt).subtract(crAmt) : plUnused.add(crAmt).subtract(drAmt);
            m.setValue("plunused", (Object)plUnused);
        }
    }

    private boolean isOnlySupp() {
        VoucherEditCashFlowCounter cashFlowCounter = this.voucherEditView.getService(VoucherEditCashFlowCounter.class);
        int cashAcctCount = cashFlowCounter.getCashCount();
        int plAcctCount = cashFlowCounter.getPLCount();
        return cashAcctCount <= 0 && plAcctCount > 0;
    }

    private void resetRowCashInfo(int index) {
        IDataModel model = this.voucherEditView.getVoucherEditModel();
        if (model.getEntryRowEntity(this.getEntryKey(), index) == null) {
            return;
        }
        int entryCurrentRowIndex = model.getEntryCurrentRowIndex(this.getEntryKey());
        if (entryCurrentRowIndex == index) {
            model.setValue("maincf", null);
            model.setValue("suppcf", null);
        }
        model.setValue("maincfamount", (Object)0, index);
        model.setValue("maincfitem", null, index);
        model.setValue("maincfassgrp", null, index);
        model.setValue("suppcfamount", (Object)0, index);
        model.setValue("suppcfitem", null, index);
    }

    private String getEntryKey() {
        return this.voucherEditView.isFromTemplateVoucher() ? "voucherentity" : "entries";
    }
}

