/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.formplugin.voucher;

import java.util.Date;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.formplugin.voucher.VoucherEditCashFlowCounter;
import kd.fi.gl.formplugin.voucher.VoucherEditView;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.GLUtil;

public class VoucherEditCashFlowStatusManager {
    private final VoucherEditView voucherEditView;
    private static final String IS_ADJUSTMENT = "adjustment";

    protected VoucherEditCashFlowStatusManager(VoucherEditView voucherEditView) {
        this.voucherEditView = voucherEditView;
    }

    public boolean isLocalSet() {
        if (this.voucherEditView.isFromTemplateVoucher()) {
            return false;
        }
        return this.isLocalSet(this.voucherEditView.getValueGetter().getBookDate());
    }

    protected boolean isLocalSet(Date date) {
        DynamicObject bookDyn = this.voucherEditView.getValueGetter().getBook();
        return bookDyn != null && bookDyn.getBoolean("localset") && bookDyn.getDate("localsetdate").compareTo(date) <= 0;
    }

    protected boolean isAdjustment() {
        return Boolean.parseBoolean(this.voucherEditView.getCacheManager().get(IS_ADJUSTMENT));
    }

    protected void setAdjustment(boolean adjustment) {
        this.voucherEditView.getCacheManager().set(IS_ADJUSTMENT, String.valueOf(adjustment));
    }

    protected CashFlowPresetOption calcCashFlowPresetOption(int index) {
        if (this.voucherEditView.getService(VoucherEditCashFlowStatusManager.class).isLocalSet() || !CashFlowItemHelper.permitDesignCashflow((IDataModel)this.voucherEditView.getVoucherEditModel()) || this.voucherEditView.isCopyingLine()) {
            return CashFlowPresetOption.NONE;
        }
        IDataModel model = this.voucherEditView.getVoucherEditModel();
        DynamicObject acct = (DynamicObject)model.getValue("account", index);
        if (acct == null || !this.voucherEditView.isFromTemplateVoucher() && "1".equals(this.voucherEditView.getValueGetter().getSourceType())) {
            return CashFlowPresetOption.NONE;
        }
        if (AccountType.isBudgetType((long)acct.getLong(GLField.id_((String)"accounttype")))) {
            return CashFlowPresetOption.NONE;
        }
        VoucherEditCashFlowCounter cashFlowCounter = this.voucherEditView.getService(VoucherEditCashFlowCounter.class);
        int cashAcctCount = cashFlowCounter.getCashCount();
        int plAcctCount = cashFlowCounter.getPLCount();
        if (cashAcctCount <= 0) {
            if (plAcctCount <= 0) {
                return CashFlowPresetOption.NONE;
            }
            return new CashFlowPresetOption(false, r -> GLUtil.isNCashNPLAcct((DynamicObject)acct));
        }
        if (GLUtil.isCashAcct((DynamicObject)acct)) {
            return CashFlowPresetOption.NONE;
        }
        if (GLUtil.isPLAcct((DynamicObject)acct)) {
            return new CashFlowPresetOption(true, mainCfItem -> mainCfItem != null && !mainCfItem.getBoolean("isdealactivity"));
        }
        return new CashFlowPresetOption(true, mainCfItem -> mainCfItem != null && mainCfItem.getBoolean("isdealactivity"));
    }

    protected static class CashFlowPresetOption {
        public static CashFlowPresetOption NONE = new CashFlowPresetOption(false, item -> false);
        private final boolean canPresetMainCfItem;
        private final Predicate<DynamicObject> canPreSetSuppCfItem;

        public boolean getCanPresetMainCfItem() {
            return this.canPresetMainCfItem;
        }

        public Predicate<DynamicObject> getCanPreSetSuppCfItem() {
            return this.canPreSetSuppCfItem;
        }

        public CashFlowPresetOption(boolean canPresetMainCfItem, Predicate<DynamicObject> canPreSetSuppCfItem) {
            this.canPresetMainCfItem = canPresetMainCfItem;
            this.canPreSetSuppCfItem = canPreSetSuppCfItem;
        }
    }
}

