/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.FlexUtils;

public class AssistActBalanceReport
extends AbstractReportFormPlugin {
    private static final String FIELD_NAME = "fieldname";
    private static final String[] Qty_List = new String[]{"measureunit", "yearbeginqty", "periodbeginqty", "debitqty", "creditqty", "yeardebitqty", "yearcreditqty", "endqty"};

    public void initialize() {
        super.initialize();
        this.addGridClickListners();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (FIELD_NAME.equals(propName)) {
            this.setVisibleAssistEntry();
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        String nameFieldCache;
        Map assistMap;
        HashMap<String, Map> flexfields = new HashMap<String, Map>(16);
        HashMap<Long, Date> periodMap = new HashMap<Long, Date>(16);
        HashMap<Object, String> flexFieldToValueSource = new HashMap<Object, String>(16);
        for (DynamicObject dyn : rowData) {
            DynamicObject period;
            long assid = dyn.getLong("assid");
            if (assid == 0L || (period = dyn.getDynamicObject("period")) == null) continue;
            boolean isBaseData = false;
            String flexfield = dyn.getString("flexfield");
            if (flexfield == null) continue;
            if (flexFieldToValueSource.containsKey(flexfield)) {
                isBaseData = true;
            } else if (FlexUtils.isBaseDataAndMasteridProperty((String)flexfield)) {
                isBaseData = true;
                flexFieldToValueSource.put(flexfield, FlexUtils.getFlexProperty((String)flexfield).getValueSource());
            }
            if (!isBaseData) continue;
            Date date = period.getDate("enddate");
            flexfields.computeIfAbsent(flexfield, k -> new HashMap(16)).computeIfAbsent(dyn.getLong("period_id"), k -> new HashMap(16)).put(assid, null);
            periodMap.put(dyn.getLong("period_id"), date);
        }
        if (flexfields.isEmpty()) {
            return;
        }
        long orgid = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        for (Map.Entry entry : flexfields.entrySet()) {
            String flexfield = (String)entry.getKey();
            Map periodEntryMap = (Map)flexfields.get(flexfield);
            for (Map.Entry entry2 : periodEntryMap.entrySet()) {
                Long periodId = (Long)entry2.getKey();
                Date enddate = (Date)periodMap.get(periodId);
                assistMap = (Map)entry2.getValue();
                QFilter qFilter = new QFilter("masterid", "in", assistMap.keySet());
                String valueSource = (String)flexFieldToValueSource.get(flexfield);
                String nameNumberField = "number,name";
                nameFieldCache = this.getPageCache().get(valueSource);
                if (StringUtils.isNotEmpty((String)nameFieldCache)) {
                    nameNumberField = nameFieldCache;
                    String[] fieldArr = nameFieldCache.split(",");
                    if (Objects.equals(fieldArr[0], fieldArr[1])) {
                        nameNumberField = fieldArr[0];
                    }
                }
                DynamicObjectCollection assistObjs = BaseDataServiceHelper.queryBaseDataByDate((String)valueSource, (Long)orgid, (QFilter)qFilter, (String)("id,masterid," + nameNumberField), (Date)enddate);
                for (DynamicObject assistObj : assistObjs) {
                    long masterid = assistObj.getLong("masterid");
                    if (!assistMap.containsKey(masterid)) continue;
                    assistMap.put(masterid, assistObj);
                }
            }
        }
        for (DynamicObject dyn : rowData) {
            DynamicObject dynamicObject;
            Map periodidAssidAssistObj;
            String flexfield;
            long periodId;
            long assid = dyn.getLong("assid");
            if (assid == 0L || (periodId = dyn.getLong("period_id")) == 0L || !flexfields.containsKey(flexfield = dyn.getString("flexfield")) || (assistMap = (Map)(periodidAssidAssistObj = (Map)flexfields.get(dyn.getString("flexfield"))).get(periodId)) == null || assistMap.isEmpty() || (dynamicObject = (DynamicObject)assistMap.get(assid)) == null) continue;
            String nameField = "name";
            String numberField = "number";
            nameFieldCache = this.getPageCache().get(flexfield);
            if (StringUtils.isNotEmpty((String)nameFieldCache)) {
                String[] fields = nameFieldCache.split(",");
                nameField = fields[0];
                numberField = fields[1];
            }
            dyn.set("assid", (Object)dynamicObject.getString("id"));
            dyn.set("assvalnumber", (Object)dynamicObject.getString(numberField));
            dyn.set("assvalname", (Object)dynamicObject.getString(nameField));
        }
    }

    private void addGridClickListners() {
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(e -> {
            String number;
            String name = e.getFieldName();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            DynamicObject rowDyn = control.getReportModel().getRowData(rowIndex);
            if ("accountnumber".equals(name) && (number = rowDyn.getString("accountnumber")) != null && !"".equals(number.trim())) {
                this.showSubsiDiaryRpt(rowDyn);
            }
        });
    }

    private void showSubsiDiaryRpt(DynamicObject rowDyn) {
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("gl_rpt_subsidiaryledger");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = this.getSubsiDiaryQueryParam(rowDyn);
        if (queryParam != null) {
            parameter.setQueryParam(queryParam);
            parameter.setCustomParam("accounttable", (Object)((DynamicObject)this.getModel().getValue("accounttable")).getString("id"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private ReportQueryParam getSubsiDiaryQueryParam(DynamicObject rowDyn) {
        FilterInfo filter = new FilterInfo();
        List items = this.getQueryParam().getFilter().getFilterItems();
        for (FilterItemInfo item : items) {
            filter.addFilterItem(item.getPropName(), item.getValue(), item.getCompareType());
        }
        List flexFilter = filter.getFlexFilterItems();
        if (rowDyn.get("assvalname") != null) {
            HashSet<Object> vals;
            String flexField = rowDyn.getString("flexfield");
            DynamicObject fieldDyn = this.getDynByFlex(flexField);
            if (fieldDyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u884c\u7ef4\u5ea6\u4e0e\u8fc7\u6ee4\u6761\u4ef6\u7ef4\u5ea6\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u8fdb\u884c\u8054\u67e5\u3002", (String)"AssistActBalanceReport_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return null;
            }
            if ("3".equals(fieldDyn.getString("valuetype"))) {
                String ass = (String)rowDyn.get("assvalname");
                vals = new HashSet<Object>();
                vals.add(ass);
                flexFilter.add(new FilterItemInfo(flexField, vals, "in"));
            } else {
                String ass = (String)rowDyn.get("assid");
                vals = new HashSet();
                if (ass != null && !ass.isEmpty()) {
                    vals.add(Long.parseLong(ass));
                } else {
                    vals = null;
                }
                flexFilter.add(new FilterItemInfo(flexField, vals, "in"));
            }
        }
        filter.setFlexFilterItems(flexFilter);
        if (rowDyn.get("accountid") != null) {
            QFilter faccountNumber = new QFilter("number", "=", (Object)rowDyn.getString("accountnumber"));
            long orgId = (Long)this.getModel().getValue("org_id");
            DynamicObject accountTableDyn = (DynamicObject)filter.getValue("accounttable");
            if (accountTableDyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssistActBalanceReport_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return null;
            }
            ArrayList<QFilter> otherFilters = new ArrayList<QFilter>(10);
            otherFilters.add(faccountNumber);
            Set id = AccountUtils.queryAccountIds((long)orgId, (long)accountTableDyn.getLong("id"), otherFilters);
            filter.addFilterItem("account", id.iterator().next());
        }
        if (rowDyn.get("currencyid") != null) {
            DynamicObject currencyDyn = (DynamicObject)rowDyn.get("currencyid");
            filter.addFilterItem("currency", (Object)currencyDyn.getLong("id"));
        }
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        CommonAssistUtil.addComassitHyperParam((ReportQueryParam)this.getQueryParam(), (DynamicObject)rowDyn, (FilterInfo)filter);
        return queryParam;
    }

    private DynamicObject getDynByFlex(String flexField) {
        DynamicObjectCollection coll = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : coll) {
            String rowFlex;
            DynamicObject fieldDyn = row.getDynamicObject(FIELD_NAME);
            if (Objects.isNull(fieldDyn) || !flexField.equals(rowFlex = fieldDyn.getString("flexfield"))) continue;
            return fieldDyn;
        }
        return null;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        FilterInfo filter = event.getQueryParam().getFilter();
        String currency = filter.getString("currency");
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)filter.getLong("org"), (long)filter.getLong("booktype"));
        Long baseCurrency = book.getBaseCurrencyId();
        boolean isBaseCurrency = false;
        if (currency != null) {
            isBaseCurrency = "basecurrency".equals(currency) || currency.equals(baseCurrency.toString());
        }
        this.setColumnVisible(event.getColumns(), isBaseCurrency, isBaseCurrency, filter.getBoolean("showqty"));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setVisibleAssistEntry();
    }

    private void setVisibleAssistEntry() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        int size = model.getEntryRowCount("entryentity");
        boolean isManualAssist = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject fieldNameDyn = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (fieldNameDyn == null || !"3".equals(fieldNameDyn.getString("valuetype"))) continue;
            isManualAssist = true;
            view.setEnable(Boolean.valueOf(true), i, new String[]{"textinput"});
        }
        view.setVisible(Boolean.valueOf(isManualAssist), new String[]{"textinput"});
    }

    private void setColumnVisible(List<AbstractReportColumn> columns, boolean showCurrencyColumn, boolean isBaseCurrency, boolean showQty) {
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (key.equals("currencyid")) {
                    col.setHide(showCurrencyColumn);
                    continue;
                }
                if (isBaseCurrency && key.endsWith("for")) {
                    col.setHide(isBaseCurrency);
                    continue;
                }
                if (showQty || !key.endsWith("qty") && !key.equals("measureunit") || !Arrays.asList(Qty_List).contains(key)) continue;
                col.setHide(!showQty);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup colGroup = (ReportColumnGroup)column;
            this.setColumnVisible(colGroup.getChildren(), showCurrencyColumn, isBaseCurrency, showQty);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        for (int idx = 0; idx < selectRows.length; ++idx) {
            String valueType;
            int i = selectRows[idx];
            DynamicObject assisType = (DynamicObject)this.getModel().getValue(FIELD_NAME, i);
            if (Objects.isNull(assisType) || AssistValueType.isManualTxt((String)(valueType = assisType.getString("valuetype")))) continue;
            String valueSource = assisType.getString("valuesource_id");
            String flexField = assisType.getString("flexfield");
            BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)valueSource);
            this.getPageCache().put(valueSource, String.join((CharSequence)",", entityType.getNameProperty(), entityType.getNumberProperty()));
            this.getPageCache().put(flexField, String.join((CharSequence)",", entityType.getNameProperty(), entityType.getNumberProperty()));
        }
    }
}

