/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.GLRptTemplatePlugin;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.ShowByAccountDCParam;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GlFormUtil;

public class AssistBalFormRpt
extends GLRptTemplatePlugin {
    private static final String YEAR_BEGIN_DEBIT = "yearbegindebit";
    private static final String YEAR_BEGIN_CREDIT = "yearbegincredit";
    private static final String BEGIN_DEBIT = "begindebit";
    private static final String BEGIN_CREIT = "begincredit";
    private static final String END_DEBIT = "enddebit";
    private static final String END_CREIT = "endcredit";
    public static final String PC_ASSIST_VALUE = "assvals";
    private static final int INITIALSIZE = 10;
    public static final String PRE_GROUP_MAP = "preGroupMap";
    public static final String PRE_ASSISTVALUE_LIST = "preAssistList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit acc = (BasedataEdit)this.getControl("account");
        acc.addBeforeF7SelectListener(evt -> {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            QFilter f2 = new QFilter("isassist", "=", (Object)"1");
            qFilters.add(f2);
            ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            qFilters.addAll(filterParam.getQFilters());
            filterParam.setQFilters(qFilters);
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(evt -> {
            String name = evt.getFieldName();
            if ("number".equals(name) || "orgid".equals(name) || "currencyid".equals(name)) {
                List assvals;
                int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
                DynamicObject rowData = control.getReportModel().getRowData(rowIndex);
                if (rowData == null) {
                    return;
                }
                String number = rowData.getString("account");
                Long orgId = null;
                Long measureunit = null;
                Long currencyId = null;
                boolean isLinkMulSub = false;
                FilterInfo filterInfo = this.getQueryParam().getFilter();
                if ("number".equals(name) && !OrgType.ENTITY.getValue().equals(filterInfo.getString("orgtype"))) {
                    isLinkMulSub = true;
                }
                if ("orgid".equals(name)) {
                    orgId = rowData.getLong("orgid_id");
                }
                if ("currencyid".equals(name)) {
                    currencyId = rowData.getDynamicObject("currencyid").getLong("id");
                }
                if (this.getQueryParam().getFilter().getBoolean("showqty")) {
                    measureunit = rowData.getLong("measureunit_id");
                }
                if (!"".equals(number.trim()) && (assvals = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(PC_ASSIST_VALUE), List.class)).size() > 0) {
                    List assvalist = (List)assvals.get(0);
                    this.showSubsiDiaryRpt(rowData, rowData.getLong("acct_id"), assvalist, orgId, measureunit, currencyId, isLinkMulSub);
                }
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (Objects.equals(key, "syncexportall")) {
            this.unlimitedSyncexportall(false);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.getPageCache().put(PRE_GROUP_MAP, "");
        this.getPageCache().put(PRE_ASSISTVALUE_LIST, "");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        for (int idx = 0; idx < selectRows.length; ++idx) {
            String valuetype;
            int i = selectRows[idx];
            DynamicObject assisType = (DynamicObject)this.getModel().getValue("fieldname", i);
            if (Objects.isNull(assisType) || AssistValueType.isManualTxt((String)(valuetype = assisType.getString("valuetype")))) continue;
            String valuesource = assisType.getString("valuesource_id");
            BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)valuesource);
            this.getPageCache().put(valuesource, String.join((CharSequence)",", entityType.getNameProperty(), entityType.getNumberProperty()));
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        Object orgObj;
        boolean isExportExcel = this.isExportExcel();
        if (rowData.isEmpty()) {
            return;
        }
        ArrayList<String> assistValCols = new ArrayList<String>();
        List flexFilterItems = queryParam.getFilter().getFlexFilterItems();
        List<Tuple2<String, String>> tupleList = this.getAssistCols(flexFilterItems);
        int no = 0;
        ArrayList<String> assistBaseCols = new ArrayList<String>(10);
        for (Tuple2<String, String> tuple2 : tupleList) {
            String name;
            String string = name = no == 0 ? "assval" : "assval" + no;
            if ("txt".equals(tuple2.t1)) {
                assistValCols.add(name);
            } else {
                assistValCols.add(name + "_id");
                assistBaseCols.add(name);
            }
            ++no;
        }
        Map customParam = queryParam.getCustomParam();
        String paramStr = (String)customParam.get("AssistRptTxtFilterPlugin_param");
        boolean treeUp = StringUtils.isNotEmpty((String)paramStr);
        if (treeUp) {
            assistValCols.add("treenumber");
            assistValCols.add("treename");
        }
        ArrayList assvalList = new ArrayList();
        int size = assistValCols.size();
        HashMap<Integer, Object> map = new HashMap<Integer, Object>(size);
        for (int i = 0; i < size; ++i) {
            map.put(i, null);
        }
        HashMap<String, String> accMap = new HashMap<String, String>(10);
        accMap.put("acct_id", "");
        if (queryParam.getFilter().getFilterItem("currency").getString().equalsIgnoreCase("allcurrency")) {
            accMap.put("currencyid_id", "");
        }
        accMap.put("orgid_id", "");
        Long defaultOrg = this.getParentOrg();
        List amountTypes = GLRptTemplatePlugin.getAmountTypes((DataEntityPropertyCollection)rowData.getDynamicObjectType().getProperties());
        ShowByAccountDCParam param = new ShowByAccountDCParam(defaultOrg, Long.valueOf(queryParam.getFilter().getLong("accounttable")));
        param.setAccountField("acct");
        param.setAmountTypes(amountTypes);
        param.addBalField(BEGIN_DEBIT, BEGIN_CREIT);
        param.addBalField(END_DEBIT, END_CREIT);
        param.addBalField(YEAR_BEGIN_DEBIT, YEAR_BEGIN_CREDIT);
        ReportUtils.showRowDataByActDC((ShowByAccountDCParam)param, (DynamicObjectCollection)rowData);
        boolean baseCurrency = this.isBaseCurrency(queryParam.getFilter());
        boolean isShowPrice = super.isShowPrice();
        for (DynamicObject dyn : rowData) {
            ArrayList<Object> vaList = new ArrayList<Object>(assistValCols.size());
            for (String key : assistValCols) {
                vaList.add(dyn.get(key));
            }
            assvalList.add(vaList);
            if (!isExportExcel) {
                boolean flag = true;
                for (int i = 0; i < size; ++i) {
                    Object ass = dyn.get((String)assistValCols.get(i));
                    if (ass != null && !ass.equals(map.get(i))) {
                        flag = false;
                    }
                    map.put(i, ass);
                }
                if (treeUp) {
                    this.setStyle(dyn);
                }
                for (Map.Entry key2Val : accMap.entrySet()) {
                    String key = (String)key2Val.getKey();
                    String newValue = String.valueOf(dyn.get(key));
                    if (((String)key2Val.getValue()).equals(newValue)) {
                        if (key.endsWith("_id")) {
                            dyn.set(key.replace("_id", ""), null);
                            if (key.equals("acct_id") && flag) {
                                dyn.set("name", (Object)"");
                                dyn.set("number", (Object)"");
                            }
                        } else {
                            dyn.set(key, (Object)"");
                        }
                    }
                    accMap.put(key, newValue);
                }
            } else if (treeUp) {
                // empty if block
            }
            if (!isShowPrice) continue;
            String field = "begindebit#,begincredit#,debit#,credit#,enddebit#,endcredit#,yeardebit#,yearcredit#,yearbegindebit#,yearbegincredit#";
            this.setPrice(baseCurrency, dyn, field);
        }
        HashMap<Long, Map> assistDataMasterIdToId = new HashMap<Long, Map>(10);
        Date endDate = queryParam.getFilter().getDynamicObject("endperiod").getDate("enddate");
        boolean isShowOrg = queryParam.getFilter().getBoolean("showorg");
        long orgid = 0L;
        for (DynamicObject dyn : rowData) {
            if (isShowOrg) {
                orgObj = dyn.getDynamicObject("orgid");
                if (orgObj == null) continue;
                orgid = orgObj.getLong("id");
            } else {
                orgid = defaultOrg;
            }
            for (String assistBaseCol : assistBaseCols) {
                DynamicObject assistObj = dyn.getDynamicObject(assistBaseCol);
                if (assistObj == null || !assistObj.containsProperty("masterid")) continue;
                long masterid = assistObj.getLong("masterid");
                long id = assistObj.getLong("id");
                String assistTypeName = assistObj.getDynamicObjectType().getName();
                assistDataMasterIdToId.computeIfAbsent(orgid, k -> new HashMap()).computeIfAbsent(assistTypeName, k -> new HashMap(10)).put(masterid, id);
            }
        }
        for (Map.Entry assistDataEntry : assistDataMasterIdToId.entrySet()) {
            orgid = (Long)assistDataEntry.getKey();
            Map assistMasteridAndIds = (Map)assistDataEntry.getValue();
            for (Map.Entry assistMasteridAndIdsEntry : assistMasteridAndIds.entrySet()) {
                String assistTypeName = (String)assistMasteridAndIdsEntry.getKey();
                if (StringUtils.isEmpty((String)assistTypeName)) continue;
                String nameNumberField = "number,name";
                String nameFieldCache = this.getPageCache().get(assistTypeName);
                if (StringUtils.isNotEmpty((String)nameFieldCache)) {
                    nameNumberField = nameFieldCache;
                    String[] fieldArr = nameFieldCache.split(",");
                    if (Objects.equals(fieldArr[0], fieldArr[1])) {
                        nameNumberField = fieldArr[0];
                    }
                }
                Map masterIdToId = (Map)assistMasteridAndIdsEntry.getValue();
                Set masterids = masterIdToId.keySet();
                QFilter qFilter = new QFilter("masterid", "in", masterids);
                DynamicObjectCollection assistObjs = BaseDataServiceHelper.queryBaseDataByDate((String)assistTypeName, (Long)orgid, (QFilter)qFilter, (String)("id,masterid," + nameNumberField), (Date)endDate);
                for (DynamicObject assistObj : assistObjs) {
                    masterIdToId.computeIfPresent(assistObj.getLong("masterid"), (k, v) -> assistObj.getLong("id"));
                }
            }
        }
        for (DynamicObject dyn : rowData) {
            Map assistNumberValues;
            if (isShowOrg) {
                orgObj = dyn.getDynamicObject("orgid");
                if (orgObj == null) continue;
                orgid = orgObj.getLong("id");
            } else {
                orgid = defaultOrg;
            }
            if ((assistNumberValues = (Map)assistDataMasterIdToId.get(orgid)) == null || assistNumberValues.isEmpty()) continue;
            for (String assistBaseCol : assistBaseCols) {
                String assistTypeName;
                DynamicObject assistObj = dyn.getDynamicObject(assistBaseCol);
                if (assistObj == null || !assistNumberValues.containsKey(assistTypeName = assistObj.getDynamicObjectType().getName())) continue;
                Map masterIdToId = (Map)assistNumberValues.get(assistTypeName);
                Long id = (Long)masterIdToId.get(assistObj.getLong("masterid"));
                dyn.set(assistBaseCol, (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)assistTypeName));
                dyn.set(assistBaseCol + "_id", (Object)id);
            }
        }
        this.getPageCache().put(PC_ASSIST_VALUE, SerializationUtils.toJsonString(assvalList));
    }

    private void setStyle(DynamicObject obj) {
        String accountname = obj.getString("name");
        if (ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AssistBalFormRpt_0", (String)"fi-gl-formplugin", (Object[])new Object[0]).equals(accountname)) {
            return;
        }
        int level = obj.getInt("treelevel");
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < level; ++i) {
            sb.append("\t");
        }
        int leaf = obj.getInt("treeleaf");
        if (leaf == 1) {
            sb.append("-\t");
        } else {
            sb.append("+\t");
        }
        sb.append(obj.getString("treenumber"));
        obj.set("treenumber", (Object)sb.toString());
    }

    private List<Tuple2<String, String>> getAssistCols(List<FilterItemInfo> flexFilterItems) {
        List flexList = flexFilterItems.stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
        QFilter qFilter = new QFilter("flexfield", "in", flexList);
        DynamicObjectCollection queryOne = QueryServiceHelper.query((String)"bd_asstacttype", (String)"flexfield,valuetype", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject dyn : queryOne) {
            String valType = dyn.getString("valuetype");
            String flexField = dyn.getString("flexfield");
            if ("3".equals(valType)) {
                map.put(flexField, "txt");
                continue;
            }
            map.put(flexField, "base");
        }
        ArrayList<Tuple2<String, String>> result = new ArrayList<Tuple2<String, String>>(flexList.size());
        for (String s : flexList) {
            String type = (String)map.get(s);
            result.add((Tuple2<String, String>)new Tuple2((Object)type, (Object)s));
        }
        return result;
    }

    private boolean isExportExcel() {
        StackTraceElement[] stackTrace;
        boolean isExportExcel = false;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String methodName = element.getMethodName();
            if (!methodName.equals("exportExcel") && !methodName.equals("exportAssistBal")) continue;
            isExportExcel = true;
            break;
        }
        return isExportExcel;
    }

    private void showSubsiDiaryRpt(DynamicObject rowData, Long account, List<Object> assvals, Long orgId, Long measureunit, Long currencyId, boolean isLinkMulSub) {
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = this.getSubsiDiaryQueryParam(account, assvals, orgId, measureunit, currencyId, isLinkMulSub);
        List flexFilterItems = queryParam.getFilter().getFlexFilterItems();
        if (flexFilterItems.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u65e0\u5f53\u524d\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\uff0c\u65e0\u6cd5\u8054\u67e5\u3002", (String)"AssistBalFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        String formId = "gl_rpt_subsidiaryledger";
        if (isLinkMulSub) {
            String mulcur = filterInfo.getString("mulcur");
            if (!Objects.isNull(mulcur) && !Objects.equals(mulcur, "LocalCurrency")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u591a\u672c\u4f4d\u5e01\u8054\u67e5\u591a\u7ec4\u7ec7\u8f85\u52a9\u660e\u7ec6\u8d26\u3002", (String)"AssistBalFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            formId = "t_rpt_aux_subledger";
            queryParam.getFilter().addFilterItem("orgs", filterInfo.getValue("orgs"));
            queryParam.getFilter().addFilterItem("orgview", filterInfo.getValue("orgview"));
            parameter.setCustomParam("openType", (Object)"HyperClick");
        } else {
            CommonAssistUtil.addComassitHyperParam((ReportQueryParam)this.getQueryParam(), (FilterInfo)queryParam.getFilter());
        }
        parameter.setFormId(formId);
        parameter.setQueryParam(queryParam);
        parameter.setCustomParam("accounttable", (Object)queryParam.getFilter().getString("accounttable"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private ReportQueryParam getSubsiDiaryQueryParam(Long accountId, List<Object> assvals, Long orgId, Long measureunit, Long currencyId, boolean isLinkMulSub) {
        AccountBookInfo book;
        long startPeriodOnBook;
        ReportQueryParam param = this.getQueryParam();
        FilterInfo info = param.getFilter();
        if (orgId == null) {
            orgId = this.getParentOrg();
        }
        Long bookType = this.getQueryParam().getFilter().getLong("booktype");
        List flexItem = info.getFlexFilterItems();
        for (int i = 0; i < flexItem.size(); ++i) {
            FilterItemInfo filterItemInfo = (FilterItemInfo)flexItem.get(i);
            HashSet<Object> vals = new HashSet<Object>();
            vals.add(assvals.get(i));
            filterItemInfo.setValue(vals);
        }
        long startPeriod = info.getLong("startperiod");
        long endPeriod = info.getLong("endperiod");
        if (!isLinkMulSub && (startPeriodOnBook = (book = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookType)).getStartPeriodId()) > startPeriod && (startPeriod = startPeriodOnBook) > endPeriod) {
            endPeriod = startPeriod;
        }
        ArrayList<QFilter> accountFilterList = new ArrayList<QFilter>(8);
        DynamicObject period = info.getDynamicObject("endperiod");
        Date endDate = period.getDate("enddate");
        accountFilterList.add(new QFilter("startdate", "<=", (Object)endDate));
        accountFilterList.add(new QFilter("enddate", ">=", (Object)endDate));
        accountFilterList.add(new QFilter("isassist", "=", (Object)"1"));
        Set<Long> detailAccountIdSet = new HashSet<Long>(8);
        detailAccountIdSet.add(accountId);
        Map leafAcctIdMap = AccountUtils.getLeafAcctIdById((long)orgId, (long)info.getLong("accounttable"), Collections.singleton(accountId), accountFilterList);
        if (!CollectionUtils.isEmpty((Map)leafAcctIdMap)) {
            detailAccountIdSet = (Set)leafAcctIdMap.entrySet().iterator().next().getValue();
            HashMap<Long, Set> asstActItemMap = new HashMap<Long, Set>(leafAcctIdMap.size());
            try (DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryFlexField"), (String)"bd_accountview", (String)"id,checkitementry.asstactitem.flexfield flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", detailAccountIdSet)}, null);){
                for (Row row : accountDataSet) {
                    Set flexFieldSet = asstActItemMap.computeIfAbsent(row.getLong("id"), k -> new HashSet(8));
                    flexFieldSet.add(row.getString("flexfield"));
                }
            }
            ArrayList asstItemList = new ArrayList(asstActItemMap.keySet());
            Set flexfields = (Set)asstActItemMap.get(asstItemList.get(0));
            if (asstActItemMap.size() > 1) {
                for (int i = 1; i < asstItemList.size(); ++i) {
                    flexfields.retainAll((Collection)asstActItemMap.get(asstItemList.get(i)));
                }
            }
            Iterator iterator = flexItem.iterator();
            while (iterator.hasNext()) {
                if (flexfields.contains(((FilterItemInfo)iterator.next()).getPropName())) continue;
                iterator.remove();
            }
        }
        FlexUtils.preInitFlexItem((FilterInfo)info, (boolean)true);
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("org", (Object)orgId);
        filter.addFilterItem("booktype", (Object)info.getLong("booktype"));
        filter.addFilterItem("periodtype", (Object)info.getLong("periodtype"));
        filter.addFilterItem("startperiod", (Object)startPeriod);
        filter.addFilterItem("endperiod", (Object)endPeriod);
        filter.addFilterItem("accounttable", (Object)info.getLong("accounttable"));
        filter.addFilterItem("accountlevel", (Object)info.getString("accountlevel"));
        filter.addFilterItem("account", detailAccountIdSet);
        if (currencyId != null) {
            filter.addFilterItem("currency", (Object)currencyId);
        } else {
            filter.addFilterItem("currency", (Object)info.getString("currency"));
        }
        if (info.containProp("issubstractpl")) {
            filter.addFilterItem("issubstractpl", (Object)info.getBoolean("issubstractpl"));
        }
        filter.addFilterItem("showqty", (Object)info.getBoolean("showqty"));
        filter.addFilterItem("nodisplayforzero", (Object)info.getBoolean("nodisplayforzero"));
        filter.addFilterItem("balancezero", (Object)info.getBoolean("balancezero"));
        filter.addFilterItem("measureunits", (Object)measureunit);
        filter.addFilterItem("mulcur", (Object)info.getString("mulcur"));
        filter.setFlexFilterItems(flexItem);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.setFilter(filter);
        return queryParam;
    }

    protected BasedataEdit getOrgEdit() {
        return (BasedataEdit)this.getControl("orgs");
    }

    protected List<Long> getOrgValue() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        return orgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    protected void setDefaultOrg(Long orgId) {
        if (orgId == null || orgId == 0L) {
            this.getModel().setValue("orgs", null);
        } else {
            this.getModel().setValue("orgs", (Object)new Long[]{orgId});
        }
    }

    protected List<Long> getFilterOrg(FilterInfo filterInfo) {
        List value;
        ArrayList<Long> result = new ArrayList<Long>();
        FilterItemInfo itemInfo = filterInfo.getFilterItem("orgs");
        if (itemInfo != null && (value = (List)itemInfo.getValue()) != null) {
            for (DynamicObject dyn : value) {
                result.add(dyn.getLong("id"));
            }
        }
        return result;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        boolean isSingleOrgManageMode;
        String formatedFilterString = evt.getFormatedFilterString();
        FilterInfo filter = evt.getFilter();
        if (Objects.equals(this.getPageCache().get("enableMulCur"), "true")) {
            formatedFilterString = GlFormUtil.getMulCurFormatedFilterString((String)filter.getString("mulcur"), (String)formatedFilterString);
            evt.setFormatedFilterString(formatedFilterString);
        }
        if (isSingleOrgManageMode = SingleOrgContextHelper.isSingleOrgManageMode()) {
            return;
        }
        Long parentOrg = this.getParentOrg();
        String name = "";
        if (parentOrg != null && parentOrg != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)parentOrg, (String)"bos_org");
            name = org.getString("name");
        }
        String result = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\uff1a%s", (String)"AssistBalFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]), name + "; " + formatedFilterString);
        evt.setFormatedFilterString(result);
    }
}

