/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.report.plugin.ReportViewPluginProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.model.JsonObjectAdapter;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.DebugTraceHelper;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.common.ShowBosPrintingProgress;
import kd.fi.gl.enums.SubsiDiarySortFieldEnum;
import kd.fi.gl.report.FlexHandler;
import kd.fi.gl.report.QueryParamFactory;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportPrintHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.subsidiary.SubsidiaryLeftQuery;
import kd.fi.gl.report.subsidiary.v2.SelectObjectUtil;
import kd.fi.gl.report.subsidiary.v2.display.SubsidiaryProcessRowDataHelper;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.GlFormUtil;
import kd.fi.gl.util.LeftTreeUtil;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.util.ReportFieldSettingUtil;
import kd.fi.gl.util.SubsiDiaryHelper;
import kd.fi.gl.util.VoucherUtil;
import kd.fi.gl.vo.ReportFieldSettingVo;

public class SubsiDiaryTreeFormRpt
extends AbstractReportFormPlugin
implements RowClickEventListener,
CellClickListener,
ItemClickListener {
    private static final Log log = LogFactory.getLog(SubsiDiaryTreeFormRpt.class);
    private static final String SORTCOMBO = "sortcombo";
    private static final String FIELDCOMBO = "fieldcombo";
    private static final String CUSTOMSORTENTRY = "customsortentry";
    private static final String[] list = new String[]{"measureunit", "debitqty", "creditqty", "endqty", "debitprice", "creditprice", "endprice"};
    private static final String[] listShow = new String[]{"debitprice", "creditprice", "endprice"};
    private static final String treeEntryKey = "treeentryentity";
    private static final String entryKey = "entryentity";
    private static final String flexField = "flexfield";
    private static final String SHOW_TYPE = "showtype";
    private static final String groupStandard = "groupstandard";
    private static final String groupValue = "groupstandard_id";
    private static final String FIELD_NAME = "fieldname";
    private static final String treeName = "treename";
    private static final String PREFIX_TXT = "textfield";
    private static final String PREFIX_BD = "basedata";
    private static final String PREFIX_AD = "assistantdata";
    private final TimerFactory.Timer timer = TimerFactory.getTimer(((Object)((Object)this)).getClass());
    private static final String PRINT_FLAG_KEY = "print";

    private static LocaleString getTxtAmount() {
        return ResManager.getLocaleString((String)"\u91d1\u989d", (String)"SubsiDiaryTreeFormRpt_0", (String)"fi-gl-formplugin");
    }

    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getControl("voucherfiltergridap");
        filterGrid.setEntityNumber("gl_voucher");
        this.setVoucherFilterFields(filterGrid);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener(arg0 -> {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("reportlistap");
            IReportListModel reportModel = list.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String voucherId = rowData.getString("voucherid");
            if (StringUtils.isNotBlank((CharSequence)voucherId) && !voucherId.equals("0")) {
                this.viewVoucher(voucherId, VoucherUtil.getVoucherIdList((IReportListModel)reportModel, (String)"voucherid", (int)rowIndex));
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public boolean isContainGroupAssist(DynamicObject fieldNameDyn) {
        String valuetype;
        if (fieldNameDyn != null && "1".equals(valuetype = fieldNameDyn.getString("valuetype"))) {
            DynamicObject valueSource = fieldNameDyn.getDynamicObject("valuesource");
            return this.getGroupAssistKey().contains(valueSource.get("id"));
        }
        return false;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        if (ReportUtils.checkIfDetailOutOfLimit((ReportQueryParam)queryParam).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u7684\u51ed\u8bc1\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236\uff0c\u8d85\u51fa\u9650\u5236\u7684\u51ed\u8bc1\u4e0d\u8ba1\u5165\u5c0f\u8ba1\uff0c\u4ec5\u8ba1\u5165\u603b\u5408\u8ba1\uff0c\u5982\u9700\u663e\u793a\u5168\u90e8\u6570\u636e\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u529f\u80fd\u3002", (String)"SubsiDiaryTreeFormRpt_100", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid treeEntryGrid = (EntryGrid)this.getControl(treeEntryKey);
        treeEntryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        entryGrid.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{FIELD_NAME, groupStandard});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        List filterFileds = ReportFieldSettingUtil.getFilterFieldConfigs((String)"gl_rpt_subsidiaryledger");
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    public void viewVoucher(String id, List<Object> pkIds) {
        long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        VoucherUtil.hyperVoucher((long)orgId, (long)Long.parseLong(id), (IFormView)this.getView(), pkIds);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        FilterInfo filter = event.getQueryParam().getFilter();
        String currency = filter.getString("currency");
        AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)filter.getLong("org"), (long)filter.getLong("booktype"));
        long baseCurrency = MulCurReportUtil.getMulCurrency((String)filter.getString("mulcur"), (long)filter.getLong("org"), (long)filter.getLong("booktype"), (long)book.getBaseCurrencyId());
        boolean isBaseCurrency = false;
        if (currency != null && baseCurrency != 0L) {
            isBaseCurrency = "basecurrency".equals(currency) || currency.equals(String.valueOf(baseCurrency));
        }
        this.setColumnVisible(event.getColumns(), isBaseCurrency, isBaseCurrency, filter.getBoolean("showqty"));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("syncexportall".equals(itemKey)) {
            this.syncExportAll("all");
        } else if ("exportexcel".equals(itemKey)) {
            this.syncExportAll("single");
        } else if ("printview".equals(itemKey)) {
            this.printOperationNew("single");
        } else if ("barprint".equals(itemKey)) {
            this.printOperationNew("all");
        } else if ("refresh".equals(itemKey)) {
            if (this.getModel().getEntryRowCount(treeEntryKey) > 0) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(treeEntryKey);
                int[] rows = entryGrid.getSelectRows();
                int row = rows.length > 0 ? rows[0] : 0;
                entryGrid.entryRowClick(Integer.valueOf(row));
                entryGrid.selectRows(row);
            }
        } else if ("removebtn".equals(itemKey)) {
            this.setVisibleAssistEntry();
        } else if ("multipleorgexportall".equals(itemKey)) {
            String formId = this.getView().getFormShowParameter().getFormId();
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("gl_exportorg_setting");
            param.setCustomParam("formid", (Object)formId);
            param.setCustomParam("orgParam", (Object)SerializationUtils.serializeToBase64(Collections.singletonList(this.getView().getModel().getValue("org_id"))));
            this.getView().showForm(param);
        } else if ("setfield".equals(itemKey)) {
            if (!AccSysUtil.isPerm((String)this.getView().getEntityId(), (String)"3+T3DWZJF6/L")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8bbe\u7f6e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SubLedgerFormRpt_14", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("gl_report_field_seting");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("form_id", (Object)"gl_rpt_subsidiaryledger");
            this.getView().showForm(parameter);
        }
    }

    private void refreshEntryValue(Map<String, String> keyMap, Map<String, Object> paramMap) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String key : keyMap.keySet()) {
            vs.addField(key, new Object[0]);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        String hyperFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("gl_rpt_accountbalance".equals(hyperFormId) && this.getPageCache().get("firstHyperFormId") == null) {
            paramMap.put("hyperFormId", hyperFormId);
            this.getPageCache().put("firstHyperFormId", "false");
            this.getQueryParam().getFilter().addFilterItem("firstHyperFormId", (Object)true);
        } else if ("gl_rpt_assistbalance".equals(hyperFormId) && this.getPageCache().get("firstHyperFormId") == null) {
            paramMap.put("hyperFormId", hyperFormId);
            this.getPageCache().put("firstHyperFormId", "false");
            this.getQueryParam().getFilter().addFilterItem("firstHyperFormId", (Object)true);
            List flexFilterItems = this.getQueryParam().getFilter().getFlexFilterItems();
            List flexfields = flexFilterItems.stream().map(x -> x.getPropName()).collect(Collectors.toList());
            HashMap<String, String> flexFieldAndValueType = new HashMap<String, String>(16);
            QFilter fflexs = new QFilter(flexField, "in", flexfields);
            DataSet assistSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_asstacttype", (String)"flexfield,number,valuesource,valuetype", (QFilter[])fflexs.toArray(), null);
            for (Row row : assistSet) {
                flexFieldAndValueType.put(row.getString(flexField), row.getString("valuetype"));
            }
            for (FilterItemInfo flexFilterItem : flexFilterItems) {
                String valueType;
                Set flexFilterItemValue;
                Object value = flexFilterItem.getValue();
                if (!(value instanceof Set) || !(flexFilterItemValue = (Set)value).isEmpty() || (valueType = (String)flexFieldAndValueType.get(flexFilterItem.getPropName())) == null || "3".equals(valueType)) continue;
                flexFilterItemValue.add(0L);
            }
        } else {
            this.getQueryParam().getFilter().addFilterItem("firstHyperFormId", (Object)false);
        }
        SubsidiaryLeftQuery leftQueryHelper = new SubsidiaryLeftQuery();
        try (DataSet ds = leftQueryHelper.query(this.getQueryParam(), paramMap);){
            this.timer.time("queryLeftHg");
            if (ds == null) {
                model.deleteEntryData(treeEntryKey);
                this.getView().updateView(treeEntryKey);
                return;
            }
            List dsList = GLUtil.getDataSetCols((DataSet)ds);
            if (paramMap.get("standardId") != null && (keyMap.get(treeName) != null || paramMap.get(treeName) != null)) {
                dsList.removeIf(x -> x.equals(treeName));
                String treeName = (String)paramMap.get(treeName);
                String showType = (String)paramMap.get(treeName);
                if ("name".equals(showType) || "".equals(showType)) {
                    dsList.add(treeName);
                } else if ("number".equals(showType)) {
                    dsList.add("treenumber  " + treeName);
                } else {
                    dsList.add("treename + ',' + treenumber  " + treeName);
                }
            }
            dsList.removeIf(x -> x.equals("treenumber"));
            DataSet result = ds.select(dsList.toArray(new String[0]));
            if (keyMap.get(treeName) != null || paramMap.get(treeName) != null) {
                int level = 0;
                if (paramMap.get("asstlevel") != null) {
                    level = (Integer)paramMap.get("asstlevel");
                }
                leftQueryHelper.createMulTreeValue(result, vs, model, keyMap, (IFormView)this.getView());
                this.collapseEntry(level);
                this.timer.time("create left entry");
            } else {
                this.createValue(result, vs, model, keyMap);
                this.timer.time("create left entry2");
            }
        }
        catch (Exception e) {
            log.error("SubsiDiaryTreeFormRpt_refreshEntryValue_query_error", (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5de6\u8868\u67e5\u8be2\u62a5\u9519\uff01  \u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"SubsiDiaryTreeFormRpt_18", (String)"fi-gl-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private Map<Long, String> nullFlexsByAcct(Set<Long> linkFlexs) {
        long accountId = 0L;
        if (this.getQueryParam().getFilter().getDynamicObjectCollection("account") != null) {
            accountId = ((DynamicObject)this.getQueryParam().getFilter().getDynamicObjectCollection("account").get(0)).getLong("id");
        }
        QFilter filter = new QFilter("id", "=", (Object)accountId);
        HashMap<Long, String> idToFlexMap = new HashMap<Long, String>(8);
        DataSet flexsSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"checkitementry.asstactitem id, checkitementry.asstactitem.flexfield flex", (QFilter[])new QFilter[]{filter}, null);
        for (Row row : flexsSet) {
            long id = row.getLong("id");
            if (linkFlexs.contains(id)) continue;
            idToFlexMap.put(id, row.getString("flex"));
        }
        return idToFlexMap;
    }

    private void collapseEntry(int level) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.getControl(treeEntryKey);
        entryGrid.setCollapse(false);
        if (level > 0) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(treeEntryKey);
            HashSet<Integer> rows = new HashSet<Integer>();
            for (int i = 0; i < count; ++i) {
                int elevel;
                Object levelObj = model.getValue("level", i);
                if (StringUtils.isBlank((Object)levelObj) || (elevel = Integer.parseInt(levelObj + "")) < level || !((Boolean)model.getValue("isGroupNode", i)).booleanValue()) continue;
                rows.add(i);
            }
            if (!rows.isEmpty()) {
                int[] row = new int[rows.size()];
                int index = 0;
                Iterator iterator = rows.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    row[index++] = i;
                }
                entryGrid.collapse(row);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createValue(DataSet ds, TableValueSetter vs, AbstractFormDataModel model, Map<String, String> keyMap) {
        int i;
        ArrayList<Object[]> tempList = new ArrayList<Object[]>(10);
        Object[] allZeroRow = null;
        boolean firstRow = true;
        for (Row row : ds) {
            i = 0;
            Object[] obj = new Object[vs.getFields().size()];
            boolean allZero = true;
            for (String string : vs.getFields()) {
                obj[i] = string.equals(treeName) ? row.get(treeName) : row.get(keyMap.get(string));
                if (firstRow && allZero) {
                    allZero = obj[i] == null || obj[i] instanceof Long && obj[i].equals(0L) || obj[i] instanceof String && StringUtils.isEmpty((CharSequence)((String)obj[i]));
                }
                ++i;
            }
            if (firstRow && allZero) {
                allZeroRow = obj;
            } else {
                tempList.add(obj);
            }
            firstRow = false;
        }
        if (allZeroRow != null) {
            tempList.add(allZeroRow);
        }
        HashMap<String, Map> flexfieldToMasteridAndId = new HashMap<String, Map>(16);
        List fields = vs.getFields();
        for (i = 0; i < fields.size(); ++i) {
            String field = (String)fields.get(i);
            String fieldName = keyMap.get(field);
            if (!FlexUtils.isBaseDataAndMasteridProperty((String)fieldName)) continue;
            for (Object[] objectArray : tempList) {
                flexfieldToMasteridAndId.computeIfAbsent(fieldName, k -> new HashMap()).put((Long)objectArray[i], null);
            }
        }
        if (DebugTrace.enable()) {
            log.info("{}_flexfieldToMasteridAndId_1:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)DebugTraceHelper.toString(flexfieldToMasteridAndId));
        }
        Date enddate = ((DynamicObject)model.getValue("endperiod")).getDate("enddate");
        long orgid = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        for (Map.Entry entry : flexfieldToMasteridAndId.entrySet()) {
            String flexfield = (String)entry.getKey();
            String valuesource = FlexUtils.getFlexProperty((String)flexfield).getValueSource();
            Map value = (Map)entry.getValue();
            Set ids = value.keySet();
            ids.removeIf(x -> x == null || x == 0L);
            if (ids.size() <= 0) continue;
            for (List batchIds : Lists.partition(new ArrayList(ids), (int)1000)) {
                QFilter qFilter = new QFilter("masterid", "in", (Object)batchIds);
                String nameField = "name";
                String nameFieldCache = this.getPageCache().get(valuesource);
                if (StringUtils.isNotEmpty((CharSequence)nameFieldCache)) {
                    nameField = nameFieldCache.split(",")[0];
                }
                DynamicObjectCollection assistObjs = BaseDataServiceHelper.queryBaseDataByDate((String)valuesource, (Long)orgid, (QFilter)qFilter, (String)("id,masterid," + nameField), (Date)enddate);
                List assistIds = assistObjs.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                QFilter idFilter = new QFilter("id", "in", assistIds);
                DynamicObjectType dataEntityType = EntityMetadataCache.getSubDataEntityType((String)valuesource, (Collection)Sets.newHashSet((Object[])new String[]{"name"}));
                Map assistObjMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)dataEntityType, (QFilter[])idFilter.toArray());
                for (DynamicObject assistObj : assistObjs) {
                    DynamicObject assistObjTarget = (DynamicObject)assistObjMap.get(assistObj.getLong("id"));
                    assistObjTarget.set(nameField, (Object)new LocaleString(assistObj.getString(nameField)));
                    value.put(assistObj.getLong("masterid"), assistObjTarget);
                }
            }
        }
        if (DebugTrace.enable()) {
            log.info("{}_flexfieldToMasteridAndId_2:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)DebugTraceHelper.toString(flexfieldToMasteridAndId));
        }
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            Map masteridAndIds;
            String string = (String)fields.get(i2);
            String fieldName = keyMap.get(string);
            if (!FlexUtils.isBaseDataAndMasteridProperty((String)fieldName) || (masteridAndIds = (Map)flexfieldToMasteridAndId.get(fieldName)) == null || masteridAndIds.isEmpty()) continue;
            for (Object[] objects : tempList) {
                if (masteridAndIds.get(objects[i2]) == null) continue;
                objects[i2] = masteridAndIds.get(objects[i2]);
            }
        }
        model.deleteEntryData(treeEntryKey);
        if (tempList.size() > 0) {
            void var14_29;
            model.beginInit();
            int[] idxes = model.batchCreateNewEntryRow(treeEntryKey, tempList.size());
            boolean bl = false;
            while (var14_29 < idxes.length) {
                for (int j = 0; j < fields.size(); ++j) {
                    model.setValue((String)fields.get(j), ((Object[])tempList.get((int)var14_29))[j], idxes[var14_29]);
                }
                ++var14_29;
            }
            model.endInit();
        }
        this.getView().updateView(treeEntryKey);
        int count = tempList.size();
        if (1 == count) {
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.setCollapse("grouppanelap", true);
        } else {
            SplitContainer splitContainer = (SplitContainer)this.getView().getControl("splitcontainerap");
            splitContainer.setCollapse("grouppanelap", false);
        }
    }

    private void syncExportAll(String flagKey) {
        long orgId = (Long)this.getModel().getValue("org_id");
        if (!GLUtil.hasPermission((String)"0YH1MN9OTQ4J", (Long)orgId, (String)this.getView().getEntityId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u5bfc\u51fa\u6743\u9650\u3002", (String)"SubsiDiaryTreeFormRpt_1", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ReportQueryParam queryParam = this.getQueryParam();
        queryParam.getFilter().addFilterItem("exportexcel", (Object)flagKey);
        List filterItems = queryParam.getFilter().getFilterItems("exportexcel");
        if (Objects.isNull(filterItems)) {
            queryParam.getFilter().addFilterItem("exportexcel", (Object)flagKey, "=");
        } else {
            queryParam.getFilter().getFilterItems().removeIf(filterItemInfo -> "exportexcel".equals(filterItemInfo.getPropName()));
            filterItems.clear();
            queryParam.getFilter().addFilterItem("exportexcel", (Object)flagKey, "=");
        }
        TreeEntryGrid leftList = (TreeEntryGrid)this.getControl(treeEntryKey);
        int leftIndex = leftList.getEntryState().getFocusRow();
        int count = model.getEntryRowCount(treeEntryKey);
        if (leftIndex == -1 && count > 0) {
            leftIndex = 0;
        }
        DynamicObject obj = null;
        if (leftIndex > -1) {
            obj = model.getEntryRowEntity(treeEntryKey, leftIndex);
        }
        if (obj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"SubsiDiaryTreeFormRpt_2", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Set<Object>> param = this.getRowEntityMap(obj);
        SelectObjectUtil.saveAssistValues((ReportQueryParam)queryParam, param);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("gl_reportexportall");
        if (Objects.equals("single", flagKey)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u51fa", (String)"SubsiDiaryTreeFormRpt_17", (String)"fi-gl-formplugin", (Object[])new Object[0]));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("entitynumber", this.getView().getEntityId());
        showParameter.getCustomParams().put("entityname", this.getView().getFormShowParameter().getFormConfig().getCaption().toString());
        showParameter.getCustomParams().put("selectobj", SerializationUtils.serializeToBase64(param));
        showParameter.getCustomParams().put("queryparam", SerializationUtils.serializeToBase64((Object)queryParam));
        this.getView().showForm(showParameter);
    }

    private void printOperationNew(String allFlag) {
        if (!AccSysUtil.isPerm((String)this.getView().getEntityId(), (String)"4730fc9e000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u914d\u6253\u5370\u6743\u9650\u3002", (String)"SubsiDiaryTreeFormRpt_3", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportView rptFormView = (ReportView)this.getPrintView(allFlag);
        if (rptFormView == null) {
            return;
        }
        this.getPageCache().put(PRINT_FLAG_KEY, allFlag);
        String formId = "gl_rpt_subsidiaryledger";
        Object defaultTemplateId = ReportPrintHelper.getDefaultTemplateId((String)formId);
        if (ObjectUtils.isEmpty((Object)defaultTemplateId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\u3002", (String)"SubsiDiaryTreeFormRpt_4", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportListModel listModel = (ReportListModel)rptFormView.getReportList().getReportModel();
        int rowCount = listModel.getRowCount();
        if (rowCount == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"SubsiDiaryTreeFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return;
        }
        String pageId = rptFormView.getPageId();
        JSONObject extParam = JsonObjectAdapter.getEmpty().registerContext("pageID", (Object)listModel.getPageId()).getSource();
        ShowBosPrintingProgress.showProgressFormV2((int)rowCount, (String)formId, (String)pageId, (Object)defaultTemplateId, (String)"", (IFormView)this.getView(), (Object)extParam, (IFormPlugin)this);
    }

    public IFormView getPrintView(String flag) {
        ReportQueryParam queryParam = this.getQueryParam();
        IDataModel model = this.getModel();
        TreeEntryGrid leftList = (TreeEntryGrid)this.getControl(treeEntryKey);
        int leftIndex = leftList.getEntryState().getFocusRow();
        int count = model.getEntryRowCount(treeEntryKey);
        if (leftIndex == -1 && count > 0) {
            leftIndex = 0;
        }
        DynamicObject obj = null;
        if (leftIndex <= -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u6253\u5370\u7684\u6570\u636e\u3002", (String)"SubsiDiaryTreeFormRpt_6", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return null;
        }
        obj = model.getEntryRowEntity(treeEntryKey, leftIndex);
        Map<String, Set<Object>> param = this.getRowEntityMap(obj);
        Map customParam = queryParam.getCustomParam();
        customParam.put("exportFlag", flag);
        customParam.remove("printPageId");
        SelectObjectUtil.saveAssistValues((ReportQueryParam)queryParam, param);
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        reportCache.setReportQueryParam(this.getView().getPageId(), queryParam);
        return this.getView();
    }

    private void setColumnVisible(List<AbstractReportColumn> columns, boolean showCurrencyColumn, boolean isBaseCurrency, boolean showQty) {
        long orgId = (Long)this.getModel().getValue("org_id");
        Boolean showPrice = (Boolean)GLUtil.getSystemParam((String)"p_showprice", (Long)orgId);
        if (showPrice == null) {
            showPrice = false;
        }
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if ("currencycolumn".equals(key) || "localrate".equals(key)) {
                    col.setHide(showCurrencyColumn);
                    continue;
                }
                if (isBaseCurrency && key.endsWith("for")) {
                    col.setHide(isBaseCurrency);
                    continue;
                }
                if (isBaseCurrency && key.equals("endfor")) {
                    col.setCaption(SubsiDiaryTreeFormRpt.getTxtAmount());
                    continue;
                }
                if ("endlocal".equals(key) && showCurrencyColumn) {
                    column.setCaption(ResManager.getLocaleString((String)"\u91d1\u989d", (String)"SubsiDiaryTreeFormRpt_0", (String)"fi-gl-formplugin"));
                    continue;
                }
                if (!showQty) {
                    if (!Arrays.asList(list).contains(key)) continue;
                    col.setHide(!showQty);
                    continue;
                }
                if (!showQty || showPrice.booleanValue() || !Arrays.asList(listShow).contains(key)) continue;
                col.setHide(showPrice == false);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup colGroup = (ReportColumnGroup)column;
            this.setColumnVisible(colGroup.getChildren(), showCurrencyColumn, isBaseCurrency, showQty);
        }
    }

    private void createTreeEntryField() {
        MainEntityType type = this.getModel().getDataEntityType();
        EntryProp entry = (EntryProp)type.getProperty(treeEntryKey);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(treeEntryKey);
        LeftTreeUtil.hideTreeEntryColumns((TreeEntryGrid)grid);
        IDataModel model = this.getModel();
        int baseDataIndex = 0;
        int textDataIndex = 0;
        int assistantDataIndex = 0;
        this.setNullFlex();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        JSONArray treeFlexFields = new JSONArray();
        HashMap<String, String> keyMap = new HashMap<String, String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (int idx = 0; idx < selectRows.length; ++idx) {
            BasedataProp prop;
            int i = selectRows[idx];
            if (LeftTreeUtil.isOutOfIndex((IFormView)this.getView(), (int)(baseDataIndex + assistantDataIndex), (int)textDataIndex)) break;
            DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (assisType == null) continue;
            DynamicObject valuesource = null;
            String entityId = null;
            String valuetype = assisType.getString("valuetype");
            String displayProperty = "name";
            FlexProperty flexProp = FlexEntityMetaUtils.getFlexProperty((String)assisType.getString(flexField));
            if (flexProp != null) {
                displayProperty = flexProp.getDisplayStyle().getDisplayProperty().toString();
            }
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            if ("1".equals(valuetype)) {
                valuesource = assisType.getDynamicObject("valuesource");
                if (valuesource == null) continue;
                entityId = valuesource.getString("id");
            } else if ("2".equals(valuetype)) {
                valuesource = assisType.getDynamicObject("assistanttype");
                entityId = "bos_assistantdata_detail";
            }
            if ("3".equals(model.getValue(SHOW_TYPE, i))) {
                paramMap.put("asstlevel", model.getValue("asstlevel", i));
            }
            if (!"1".equals(model.getValue(SHOW_TYPE, i)) && this.getGroupAssistKey().contains(entityId)) {
                String ff = assisType.getString(flexField);
                treeFlexFields.add((Object)ff);
                LeftTreeUtil.gridSetHVL((TreeEntryGrid)grid, (String)treeName, (String)assisType.getString("name"), (boolean)true);
                keyMap.put(treeName, ff);
                paramMap.put("showType", model.getValue(SHOW_TYPE, i));
                paramMap.put("entityId", entityId);
                paramMap.put("treeAlias", ff);
                paramMap.put("standardId", model.getValue(groupValue, i));
                paramMap.put(treeName, ff);
                paramMap.put(ff, displayProperty);
                continue;
            }
            if (!"1".equals(model.getValue(SHOW_TYPE, i))) {
                this.getPageCache().put(treeName, assisType.getString(flexField));
                paramMap.put("showType", model.getValue(SHOW_TYPE, i));
                paramMap.put("entityId", entityId);
                paramMap.put("treeAlias", assisType.getString(flexField));
                paramMap.put(treeName, assisType.getString(flexField));
            }
            if ("3".equals(valuetype)) {
                LeftTreeUtil.gridSetHVL((TreeEntryGrid)grid, (String)(PREFIX_TXT + textDataIndex), (String)assisType.getString("name"), (boolean)true);
                keyMap.put(PREFIX_TXT + textDataIndex, assisType.getString(flexField));
                ++textDataIndex;
            } else if ("1".equals(valuetype)) {
                service.invokeControlMethod(treeEntryKey, "setColEditorProp", new Object[]{PREFIX_BD + baseDataIndex, "dsp", displayProperty});
                prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(PREFIX_BD + baseDataIndex);
                prop.setBaseEntityId(entityId);
                DynamicObjectType dataEntityType = EntityMetadataCache.getSubDataEntityType((String)entityId, (Collection)Sets.newHashSet((Object[])new String[]{"name"}));
                prop.setComplexType((IDataEntityType)dataEntityType);
                LeftTreeUtil.gridSetHVL((TreeEntryGrid)grid, (String)(PREFIX_BD + baseDataIndex), (String)assisType.getString("name"), (boolean)true);
                keyMap.put(PREFIX_BD + baseDataIndex, assisType.getString(flexField));
                ++baseDataIndex;
            } else if ("2".equals(valuetype)) {
                service.invokeControlMethod(treeEntryKey, "setColEditorProp", new Object[]{PREFIX_AD + assistantDataIndex, "dsp", displayProperty});
                prop = (AssistantProp)entry.getDynamicCollectionItemPropertyType().getProperty(PREFIX_AD + assistantDataIndex);
                if (prop == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u7c7b\u578b\u6838\u7b97\u7ef4\u5ea6\u9ed8\u8ba4\u4e0d\u80fd\u8d85\u8fc75\u4e2a\uff0c\u53ef\u80fd\u51fa\u73b0\u6570\u636e\u663e\u793a\u95ee\u9898\uff0c\u5efa\u8bae\u6269\u5c55\u589e\u52a0\u9884\u7f6e\u8f85\u52a9\u8d44\u6599\u5217\u4e2a\u6570\u3002", (String)"SubsiDiaryTreeFormRpt_14", (String)"fi-gl-formplugin", (Object[])new Object[0]), Integer.valueOf(4000));
                    continue;
                }
                if (valuesource == null) continue;
                prop.setAsstTypeId(String.valueOf(valuesource.getPkValue()));
                prop.setBaseEntityId(entityId);
                LeftTreeUtil.gridSetHVL((TreeEntryGrid)grid, (String)(PREFIX_AD + assistantDataIndex), (String)assisType.getString("name"), (boolean)true);
                keyMap.put(PREFIX_AD + assistantDataIndex, assisType.getString(flexField));
                ++assistantDataIndex;
            }
            if (!Objects.nonNull(entityId)) continue;
            BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityId);
            this.getPageCache().put(entityId, String.join((CharSequence)",", entityType.getNameProperty(), entityType.getNumberProperty()));
        }
        this.getQueryParam().getCustomParam().put("treeflexfields", treeFlexFields.toJSONString());
        this.createData(keyMap, paramMap);
    }

    private void createData(Map<String, String> keyMap, Map<String, Object> paramMap) {
        if (keyMap.get(treeName) != null || this.getPageCache().get(treeName) != null) {
            keyMap.put("id", "id");
            keyMap.put("pid", "pid");
            keyMap.put("isGroupNode", "isgroupnode");
            keyMap.put("level", "level");
        }
        this.getPageCache().put("paramMap", SerializationUtils.toJsonString(paramMap));
        this.getPageCache().put("keyMap", SerializationUtils.toJsonString(keyMap));
        this.refreshEntryValue(keyMap, paramMap);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (queryParam == null || queryParam.getFilter() == null) {
            return false;
        }
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getFlexFilterItems() == null && filterInfo.getFlexFilterItems().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SubsiDiaryTreeFormRpt_10", (String)"fi-gl-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set voucherFields = SubsiDiarySortFieldEnum.getAllSortFieldNumbers();
        voucherFields.addAll(MetadataServiceHelper.getDataEntityType((String)"gl_voucher").getAllFields().keySet());
        DynamicObjectCollection sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY);
        HashSet<String> fieldSet = new HashSet<String>();
        if (Objects.nonNull(sortEntry)) {
            for (DynamicObject sortRow : sortEntry) {
                String fieldName = sortRow.getString(FIELDCOMBO);
                if (!fieldSet.add(fieldName)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u4e0d\u80fd\u91cd\u590d\u3002", (String)"SubsiDiaryTreeFormRpt_11", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (fieldSet.add(fieldName)) continue;
                if (fieldName.startsWith("entries")) {
                    fieldName = fieldName.substring(8);
                }
                if (voucherFields.contains(fieldName)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u65e0\u6b64\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5\u3002", (String)"SubsiDiaryTreeFormRpt_15", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        for (DynamicObject sortRow : sortEntry) {
            filterInfo.addFilterItem("sort" + sortRow.getString(FIELDCOMBO), (Object)sortRow.getString(SORTCOMBO));
        }
        this.getPageCache().remove(treeName);
        this.getPageCache().remove("paramMap");
        this.getPageCache().remove("keyMap");
        if (filterInfo.getOtherEntryFilter().containsKey(CUSTOMSORTENTRY)) {
            return true;
        }
        this.createTreeEntryField();
        this.getFlexHandler().cacheShowType();
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(treeEntryKey);
        if (count > 0) {
            DynamicObject dyo = model.getEntryRowEntity(treeEntryKey, 0);
            if (dyo != null) {
                Map<String, Set<Object>> rowEntityMap = this.getRowEntityMap(dyo);
                SelectObjectUtil.saveAssistValues((ReportQueryParam)queryParam, rowEntityMap);
                if (!rowEntityMap.isEmpty()) {
                    IReportCache reportCache = ReportCacheManager.getInstance().getCache();
                    reportCache.setReportQueryParam(this.getView().getPageId(), this.getQueryParam());
                    ReportList list = (ReportList)this.getControl("reportlistap");
                    ReportViewPluginProxy viewProxy = (ReportViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
                    viewProxy.fireBeforeQuery(queryParam);
                    list.submitTask(queryParam, rowEntityMap);
                    viewProxy.fireAfterQuery(queryParam);
                    ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
                    filter.setCollapse(true);
                    IReportView view = this.getView();
                    view.setVisible(Boolean.valueOf(true), new String[]{"splitcontainerap", "toolbarap"});
                    this.setVisibleAssistEntry();
                    return false;
                }
            }
        } else {
            SelectObjectUtil.removeAssistValues((ReportQueryParam)queryParam);
        }
        return true;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        String formatedFilterString = evt.getFormatedFilterString();
        FilterInfo filter = evt.getFilter();
        if (Objects.equals(this.getPageCache().get("enableMulCur"), "true")) {
            formatedFilterString = GlFormUtil.getMulCurFormatedFilterString((String)filter.getString("mulcur"), (String)formatedFilterString);
            evt.setFormatedFilterString(formatedFilterString);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType type;
        super.getEntityType(e);
        try {
            type = e.getNewEntityType() == null ? (MainEntityType)e.getOriginalEntityType().clone() : e.getNewEntityType();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, BosErrorCode.systemError, new Object[0]);
        }
        this.getFlexHandler().setRefreshTag();
        String firstQuery = this.getPageCache().get("firstQuery");
        if ("false".equals(firstQuery)) {
            this.bindBaseData(type);
        } else {
            firstQuery = "false";
            this.getPageCache().put("firstQuery", firstQuery);
        }
        e.setNewEntityType(type);
    }

    private void bindBaseData(MainEntityType type) {
        if (this.getFlexHandler().isRefresh()) {
            return;
        }
        FilterInfo filter = this.getQueryParam().getFilter();
        EntryProp entry = (EntryProp)type.getProperty(treeEntryKey);
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl(treeEntryKey);
        int baseDataIndex = 0;
        int textDataIndex = 0;
        int assistantDataIndex = 0;
        FlexHandler flexHandler = this.getFlexHandler();
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        for (int idx = 0; idx < selectRows.length; ++idx) {
            int i = selectRows[idx];
            if (LeftTreeUtil.isOutOfIndex((IFormView)this.getView(), (int)(baseDataIndex + assistantDataIndex), (int)textDataIndex)) break;
            FlexProperty flexProp = flexHandler.getFlexProperty(i);
            if (flexProp == null) continue;
            String entityId = null;
            String valuetype = flexProp.getValueType();
            String displayProperty = flexProp.getDisplayStyle().getDisplayProperty().toString();
            IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            String showType = flexHandler.getShowType(i);
            if ("1".equals(valuetype)) {
                entityId = flexProp.getValueSource();
            } else if ("2".equals(valuetype)) {
                entityId = "bos_assistantdata_detail";
            }
            if (!"1".equals(showType) && this.getGroupAssistKey().contains(entityId)) {
                LeftTreeUtil.gridSetHVL((TreeEntryGrid)grid, (String)treeName, (String)flexProp.getName().toString(), (boolean)true);
                continue;
            }
            if (!"1".equals(showType)) {
                this.getPageCache().put(treeName, flexProp.getFlexField());
            }
            if ("3".equals(valuetype)) {
                LeftTreeUtil.gridSetHVL((TreeEntryGrid)grid, (String)(PREFIX_TXT + textDataIndex), (String)flexProp.getName().toString(), (boolean)true);
                ++textDataIndex;
                continue;
            }
            if ("1".equals(valuetype)) {
                BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(PREFIX_BD + baseDataIndex);
                prop.setBaseEntityId(entityId);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityId));
                service.invokeControlMethod(treeEntryKey, "setColEditorProp", new Object[]{PREFIX_BD + baseDataIndex, "dsp", displayProperty});
                LeftTreeUtil.gridSetHVL((TreeEntryGrid)grid, (String)(PREFIX_BD + baseDataIndex), (String)flexProp.getName().toString(), (boolean)true);
                ++baseDataIndex;
                continue;
            }
            if (!"2".equals(valuetype)) continue;
            service.invokeControlMethod(treeEntryKey, "setColEditorProp", new Object[]{PREFIX_AD + assistantDataIndex, "dsp", displayProperty});
            LeftTreeUtil.gridSetHVL((TreeEntryGrid)grid, (String)(PREFIX_AD + assistantDataIndex), (String)flexProp.getName().toString(), (boolean)true);
            ++assistantDataIndex;
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if (queryParam.getFilter().containProp("enablev2")) {
            QueryParamRpt queryParamRpt = QueryParamFactory.createOrGetWithThreadCache((FilterInfo)queryParam.getFilter(), (String)"gl_rpt_subsidiaryledger");
            SubsidiaryProcessRowDataHelper.processRowData((DynamicObjectCollection)rowData, (IReportView)this.getView(), (QueryParamRpt)queryParamRpt);
            return;
        }
        long orgId = (Long)this.getModel().getValue("org_id");
        Boolean isShowByAccountDC = (Boolean)GLUtil.getSystemParam((String)"showbyaccountdc", (Long)orgId);
        if (isShowByAccountDC == null) {
            isShowByAccountDC = false;
        }
        boolean isExport = SubsiDiaryHelper.isExport((FilterInfo)queryParam.getFilter());
        boolean isBaseCurrency = SubsiDiaryHelper.isBaseCurrencyByQuery((FilterInfo)queryParam.getFilter());
        List displayFields = ReportFieldSettingUtil.getDisplayFieldConfigList((String)this.getView().getEntityId());
        Map vchMap = ReportUtils.getVoucherInfo((List)displayFields, (DynamicObjectCollection)rowData);
        for (DynamicObject row : rowData) {
            DynamicObject voucherObj;
            Long fentryid;
            String number = row.getString("accountnumber");
            if (StringUtils.isNotBlank((CharSequence)number)) {
                BigDecimal endlocal = row.getBigDecimal("endlocal");
                if (endlocal == null || GLUtil.isZero((BigDecimal)endlocal)) {
                    row.set("dc", (Object)"0");
                } else if (StringUtils.isNotBlank((CharSequence)row.getString("accountdc"))) {
                    String dc = row.getString("accountdc");
                    BigDecimal dcVal = new BigDecimal(dc);
                    BigDecimal endForVal = row.getBigDecimal("endfor").multiply(dcVal);
                    BigDecimal endLocalVal = row.getBigDecimal("endlocal").multiply(dcVal);
                    BigDecimal endQtyVal = row.getBigDecimal("endqty").multiply(dcVal);
                    if (!isShowByAccountDC.booleanValue() && (!isBaseCurrency && endForVal.compareTo(BigDecimal.ZERO) < 0 || isBaseCurrency && endLocalVal.compareTo(BigDecimal.ZERO) < 0)) {
                        dcVal = dcVal.multiply(new BigDecimal("-1"));
                        endForVal = endForVal.negate();
                        endLocalVal = endLocalVal.negate();
                        endQtyVal = endQtyVal.negate();
                    }
                    row.set("dc", (Object)dcVal.toString());
                    row.set("endfor", (Object)endForVal);
                    row.set("endlocal", (Object)endLocalVal);
                    row.set("endqty", (Object)endQtyVal);
                }
            }
            if (!isExport && row.getInt("rowtype") != 1) {
                row.set("accountnumber", (Object)"");
                row.set("accountname", (Object)"");
            }
            if ((fentryid = Long.valueOf(row.getLong("fentryid"))) == 0L || displayFields == null || displayFields.isEmpty() || Objects.isNull(voucherObj = (DynamicObject)vchMap.get(fentryid))) continue;
            for (ReportFieldSettingVo vo : displayFields) {
                row.set(vo.getField(), voucherObj.get(vo.getFieldMark()));
            }
        }
        this.setSummaryRowDesc(rowData);
    }

    private void setSummaryRowDesc(DynamicObjectCollection rowData) {
        String s1 = ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"SubsiDiaryTreeFormRpt_101", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s2 = ResManager.loadKDString((String)"\u672c\u671f\u5408\u8ba1", (String)"SubsiDiaryTreeFormRpt_103", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s3 = ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1", (String)"SubsiDiaryTreeFormRpt_104", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        String s4 = ResManager.loadKDString((String)"\u672c\u671f\u603b\u5408\u8ba1", (String)"SubsiDiaryTreeFormRpt_105", (String)"fi-gl-formplugin", (Object[])new Object[0]);
        for (DynamicObject row : rowData) {
            int rowType = row.getInt("rowtype");
            if (rowType == 1) {
                row.set("desc", (Object)s1);
                continue;
            }
            if (rowType == 3) {
                row.set("desc", (Object)s2);
                continue;
            }
            if (rowType == 4) {
                row.set("desc", (Object)s3);
                continue;
            }
            if (rowType != 5) continue;
            row.set("desc", (Object)s4);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setVisibleAssistEntry();
    }

    private void setNullFlex() {
        String hyperFormId = this.getView().getFormShowParameter().getParentFormId();
        if ("gl_rpt_accountbalance".equals(hyperFormId) && this.getPageCache().get("firstHyperFormId") == null) {
            IDataModel model = this.getModel();
            DynamicObjectCollection coll = model.getEntryEntity(entryKey);
            HashSet<Long> linkFlexs = new HashSet<Long>(8);
            for (DynamicObject row : coll) {
                DynamicObject fieldDyn = row.getDynamicObject(FIELD_NAME);
                linkFlexs.add(fieldDyn.getLong("id"));
            }
            Map<Long, String> nullFlexMap = this.nullFlexsByAcct(linkFlexs);
            if (nullFlexMap.isEmpty()) {
                return;
            }
            int[] newRows = model.batchCreateNewEntryRow(entryKey, nullFlexMap.size());
            int index = 0;
            List listFlexs = this.getQueryParam().getFilter().getFlexFilterItems();
            for (Map.Entry<Long, String> entry : nullFlexMap.entrySet()) {
                long id = entry.getKey();
                String flex = entry.getValue();
                model.setValue(FIELD_NAME, (Object)id, newRows[index]);
                listFlexs.add(new FilterItemInfo(flex, new HashSet(8), "in"));
                ++index;
            }
            int count = model.getEntryRowCount(entryKey);
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
            int[] rows = IntStream.range(0, count).toArray();
            entryGrid.selectRows(rows, 0);
            this.getPageCache().put("firstHyperFormId", "false");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData data = e.getChangeSet()[0];
        Object newVal = data.getNewValue();
        if (SHOW_TYPE.equals(propName)) {
            if ("2".equals(newVal) || "3".equals(newVal)) {
                int seq = data.getRowIndex();
                if (this.checkShowType(seq).booleanValue()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u6838\u7b97\u7ef4\u5ea6\u4e3a\u9010\u7ea7\u6216\u8005\u6307\u5b9a\u663e\u793a\u65b9\u5f0f\u3002", (String)"SubsiDiaryTreeFormRpt_12", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    model.setValue(SHOW_TYPE, data.getOldValue(), seq);
                    return;
                }
                if (this.checkGroupStandard(seq)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7c7b\u6807\u51c6\u3002", (String)"SubsiDiaryTreeFormRpt_13", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                    model.setValue(SHOW_TYPE, (Object)"1", seq);
                    return;
                }
                if (this.checkIsParentOrGroup(seq)) {
                    model.setValue(SHOW_TYPE, (Object)"1", seq);
                    this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{SHOW_TYPE});
                    return;
                }
            }
            this.setVisibleAssistEntry();
        } else if (FIELD_NAME.equals(propName)) {
            int seq = data.getRowIndex();
            model.setValue(groupStandard, null, seq);
            this.setComboVal(seq);
            if (this.checkIsParentOrGroup(seq)) {
                model.setValue(SHOW_TYPE, (Object)"1", seq);
                this.getView().setEnable(Boolean.valueOf(false), seq, new String[]{SHOW_TYPE});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), seq, new String[]{SHOW_TYPE});
            }
            this.setVisibleAssistEntry();
        }
    }

    private void setVisibleAssistEntry() {
        IDataModel model = this.getModel();
        IReportView view = this.getView();
        int size = model.getEntryRowCount(entryKey);
        boolean isManualAssist = false;
        boolean isMulTree = false;
        boolean isLevel = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject fieldNameDyn = (DynamicObject)model.getValue(FIELD_NAME, i);
            if (fieldNameDyn == null) continue;
            if ("3".equals(fieldNameDyn.getString("valuetype"))) {
                isManualAssist = true;
                view.setEnable(Boolean.valueOf(true), i, new String[]{"textinput"});
            } else {
                String sourceNumber = fieldNameDyn.getString("valuesource.number");
                if (null != sourceNumber && "bd_customer,bd_supplier,bd_material".contains(sourceNumber)) {
                    isMulTree = true;
                }
            }
            if (!"3".equals(model.getValue(SHOW_TYPE, i))) continue;
            isLevel = true;
        }
        view.setVisible(Boolean.valueOf(isManualAssist), new String[]{"textinput"});
        view.setVisible(Boolean.valueOf(isMulTree), new String[]{groupStandard});
        view.setVisible(Boolean.valueOf(isLevel), new String[]{"asstlevel"});
    }

    private boolean checkGroupStandard(int i) {
        IDataModel model = this.getModel();
        DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
        if (assisType == null) {
            return false;
        }
        DynamicObject valuesource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valuesource = assisType.getDynamicObject("valuesource");
            if (valuesource == null) {
                return false;
            }
            entityId = valuesource.getString("id");
            if (this.getGroupAssistKey().contains(entityId) && (Long)model.getValue(groupValue, i) <= 0L) {
                return true;
            }
        }
        return false;
    }

    private boolean checkIsParentOrGroup(int i) {
        IDataModel model = this.getModel();
        DynamicObject assisType = (DynamicObject)model.getValue(FIELD_NAME, i);
        if (assisType == null) {
            return false;
        }
        DynamicObject valuesource = null;
        String entityId = null;
        String valuetype = assisType.getString("valuetype");
        if ("1".equals(valuetype)) {
            valuesource = assisType.getDynamicObject("valuesource");
            if (valuesource == null) {
                return true;
            }
            entityId = valuesource.getString("id");
            if (this.getGroupAssistKey().contains(entityId)) {
                return false;
            }
            if (this.specialGroupTree().contains(entityId)) {
                return false;
            }
            if (this.hasParent(entityId)) {
                return false;
            }
        } else if ("2".equals(valuetype)) {
            return false;
        }
        return true;
    }

    private boolean hasParent(String entityId) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        DynamicProperty parent = mainEntityType.getProperty("parent");
        DynamicProperty isleaf = mainEntityType.getProperty("isleaf");
        DynamicProperty level = mainEntityType.getProperty("level");
        return parent != null && !StringUtils.isBlank((CharSequence)parent.getAlias()) && isleaf != null && !StringUtils.isBlank((CharSequence)isleaf.getAlias()) && level != null && !StringUtils.isBlank((CharSequence)level.getAlias());
    }

    private Boolean checkShowType(int seq) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount(entryKey);
        for (int i = 0; i < count; ++i) {
            String showtype;
            if (i == seq || !"2".equals(showtype = (String)model.getValue(SHOW_TYPE, i)) && !"3".equals(showtype)) continue;
            return true;
        }
        return false;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
    }

    private List<String> getGroupAssistKey() {
        return Arrays.asList("bd_customer", "bd_supplier", "bd_material");
    }

    private List<String> specialGroupTree() {
        return Arrays.asList("bos_adminorg", "bos_org");
    }

    public void entryRowClick(RowClickEvent evt) {
        Control ce = (Control)evt.getSource();
        String entryname = ce.getKey();
        if (treeEntryKey.equals(entryname)) {
            int index = evt.getRow();
            if (index < 0) {
                index = 0;
            }
            DynamicObject dyo = this.getModel().getEntryRowEntity(treeEntryKey, index);
            Map<String, Set<Object>> param = this.getRowEntityMap(dyo);
            ReportList list = (ReportList)this.getControl("reportlistap");
            ReportQueryParam queryParam = this.getQueryParam();
            queryParam.getFilter().addFilterItem("exportexcel", null);
            SelectObjectUtil.saveAssistValues((ReportQueryParam)queryParam, param);
            ReportViewPluginProxy viewProxy = (ReportViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            viewProxy.fireBeforeQuery(queryParam);
            list.submitTask(this.getQueryParam(), param);
            viewProxy.fireAfterQuery(queryParam);
        }
    }

    private Map<String, Set<Object>> getRowEntityMap(DynamicObject dyo) {
        BusinessDataServiceHelper.loadRefence((Object[])new Object[]{dyo}, (IDataEntityType)dyo.getDataEntityType());
        Map<String, String> keyMap = this.getKeyMapFromCache();
        HashMap<String, Set<Object>> param = new HashMap<String, Set<Object>>(keyMap.size());
        String treefield = this.getPageCache().get(treeName);
        DynamicObjectCollection treeEntryEntities = (DynamicObjectCollection)this.getModel().getEntryEntity(treeEntryKey).clone();
        for (Map.Entry<String, String> keyentry : keyMap.entrySet()) {
            DataSet valuesourceObjs;
            FlexProperty flexProperty;
            QFilter idFilter;
            String key = keyentry.getValue();
            HashSet<Object> value = new HashSet<Object>(2);
            if (keyentry.getKey().equals(treeName)) {
                if (dyo.getBoolean("isGroupNode")) {
                    ArrayList<Long> pids = new ArrayList<Long>();
                    pids.add(dyo.getLong("id"));
                    if (FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        List<Long> sons = this.getAllSons(treeEntryEntities, pids, "id");
                        idFilter = new QFilter("id", "in", sons);
                        flexProperty = FlexUtils.getFlexProperty((String)key);
                        valuesourceObjs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)flexProperty.getValueSource(), (String)"masterid", (QFilter[])idFilter.toArray(), null);
                        sons.clear();
                        for (Row row : valuesourceObjs) {
                            sons.add(row.getLong("masterid"));
                        }
                        value.addAll(sons);
                    } else {
                        value.addAll(this.getAllSons(treeEntryEntities, pids, "id"));
                    }
                } else {
                    Long masterid = dyo.getLong("id");
                    if (masterid > 0L && FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        FlexProperty flexProperty2 = FlexUtils.getFlexProperty((String)key);
                        DynamicObject assitObj = BusinessDataServiceHelper.loadSingle((Object)masterid, (String)flexProperty2.getValueSource(), (String)"masterid");
                        masterid = assitObj.getLong("masterid");
                    }
                    value.add(masterid);
                }
            } else if (treefield != null && key.equals(treefield)) {
                if (dyo.getBoolean("isGroupNode")) {
                    ArrayList<Long> pids = new ArrayList<Long>();
                    pids.add(dyo.getLong("id"));
                    if (FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        List<Long> sons = this.getAllSons(treeEntryEntities, pids, keyentry.getKey() + "_id");
                        idFilter = new QFilter("id", "in", sons);
                        flexProperty = FlexUtils.getFlexProperty((String)key);
                        valuesourceObjs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)flexProperty.getValueSource(), (String)"masterid", (QFilter[])idFilter.toArray(), null);
                        sons.clear();
                        for (Row row : valuesourceObjs) {
                            sons.add(row.getLong("masterid"));
                        }
                        value.addAll(sons);
                    } else {
                        value.addAll(this.getAllSons(treeEntryEntities, pids, keyentry.getKey() + "_id"));
                    }
                } else {
                    long masterid = dyo.getLong(keyentry.getKey() + "_id");
                    if (masterid > 0L && FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        FlexProperty flexProperty3 = FlexUtils.getFlexProperty((String)key);
                        DynamicObject assitObj = BusinessDataServiceHelper.loadSingle((Object)masterid, (String)flexProperty3.getValueSource(), (String)"masterid");
                        masterid = assitObj.getLong("masterid");
                    }
                    value.add(masterid);
                }
            } else if (keyentry.getKey().startsWith(PREFIX_BD)) {
                DynamicObject badataObj = dyo.getDynamicObject(keyentry.getKey());
                if (badataObj == null || !badataObj.containsProperty("masterid")) {
                    long baseDataId = dyo.getLong(keyentry.getKey() + "_id");
                    if (baseDataId > 0L && FlexUtils.isBaseDataAndMasteridProperty((String)key)) {
                        flexProperty = FlexUtils.getFlexProperty((String)key);
                        DynamicObject assitObj = BusinessDataServiceHelper.loadSingleFromCache((Object)baseDataId, (String)flexProperty.getValueSource(), (String)"masterid");
                        baseDataId = assitObj.getLong("masterid");
                    }
                    value.add(baseDataId);
                } else {
                    value.add(badataObj.getLong("masterid"));
                }
            } else if (keyentry.getKey().startsWith(PREFIX_TXT)) {
                value.add(dyo.getString(keyentry.getKey()));
            } else {
                if (!keyentry.getKey().startsWith(PREFIX_AD)) continue;
                value.add(dyo.getLong(keyentry.getKey() + "_id"));
            }
            param.put(key, value);
        }
        return param;
    }

    private Map<String, String> getKeyMapFromCache() {
        String keyMapStr = this.getPageCache().get("keyMap");
        if (keyMapStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u7ed3\u679c\u7684\u7f13\u5b58\u5df2\u5931\u6548\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"SubsiDiaryTreeFormRpt_19", (String)GLApp.instance.formpluginModule(), (Object[])new Object[0]));
        }
        return (Map)SerializationUtils.fromJsonString((String)keyMapStr, Map.class);
    }

    private List<Long> getAllSons(DynamicObjectCollection entries, List<Long> pids, String idKey) {
        ArrayList<Long> sons = new ArrayList<Long>();
        ArrayList<Long> parents = new ArrayList<Long>();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyo = (DynamicObject)iterator.next();
            if (!pids.contains(dyo.getLong("pid"))) continue;
            if (dyo.getBoolean("isGroupNode")) {
                parents.add(dyo.getLong("id"));
                continue;
            }
            sons.add(dyo.getLong(idKey));
            iterator.remove();
        }
        if (!parents.isEmpty()) {
            sons.addAll(this.getAllSons(entries, parents, idKey));
            return sons;
        }
        return sons;
    }

    public void cellClick(CellClickEvent e) {
        int selIndex = e.getRow();
        if (groupStandard.equals(e.getFieldKey())) {
            this.setComboVal(selIndex);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String key = ((Control)e.getSource()).getKey();
        if (groupStandard.equals(key)) {
            AbstractGrid entryGrid = (AbstractGrid)this.getView().getControl(entryKey);
            int selIndex = entryGrid.getEntryState().getFocusRow();
            this.setComboVal(selIndex);
        }
    }

    public void cellDoubleClick(CellClickEvent e) {
    }

    private void setComboVal(int selIndex) {
        MainEntityType type = this.getModel().getDataEntityType();
        EntryProp entry = (EntryProp)type.getProperty(entryKey);
        IDataModel model = this.getModel();
        DynamicObject fieldNameDyn = (DynamicObject)model.getValue(FIELD_NAME, selIndex);
        if (fieldNameDyn == null) {
            return;
        }
        String valuetype = fieldNameDyn.getString("valuetype");
        String entityNumber = "";
        if ("1".equals(valuetype)) {
            DynamicObject valuesource = fieldNameDyn.getDynamicObject("valuesource");
            entityNumber = valuesource.getString("id");
            if (this.getGroupAssistKey().contains(entityNumber)) {
                String formId = entityNumber + groupStandard;
                BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(groupStandard);
                prop.setBaseEntityId(formId);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId));
                QFilter fispreset = new QFilter("ispreset", "=", (Object)Character.valueOf('1'));
                QFilter fstatus = new QFilter("status", "=", (Object)Character.valueOf('C'));
                DataSet defaultSet = this.queryDataSet(formId, "id", new QFilter[]{fispreset, fstatus});
                long defaultId = 0L;
                if (null != defaultSet && defaultSet.hasNext()) {
                    Row row = defaultSet.next();
                    defaultId = row.getLong("id");
                }
                model.setValue(groupStandard, (Object)defaultId, selIndex);
            }
        }
    }

    public DataSet queryDataSet(String formId, String sel, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)formId, (String)sel, (QFilter[])filters, null);
    }

    public void setOtherEntryFilter(FilterInfo filterInfo) {
        super.setOtherEntryFilter(filterInfo);
        HashMap otherEntryFilter = new HashMap();
        DynamicObjectCollection sortEntry = this.getModel().getEntryEntity(CUSTOMSORTENTRY);
        ArrayList<DynamicObject> saveEntrys = new ArrayList<DynamicObject>();
        for (DynamicObject sortRow : sortEntry) {
            saveEntrys.add(sortRow);
        }
        otherEntryFilter.put(CUSTOMSORTENTRY, saveEntrys);
        filterInfo.setOtherEntryFilter(otherEntryFilter);
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        DynamicObjectCollection sortEntry = scheme.getDynamicObjectCollection(CUSTOMSORTENTRY);
        if (sortEntry != null && !sortEntry.isEmpty()) {
            IDataModel model = this.getModel();
            model.beginInit();
            model.deleteEntryData(CUSTOMSORTENTRY);
            model.batchCreateNewEntryRow(CUSTOMSORTENTRY, sortEntry.size());
            for (int i = 0; i < sortEntry.size(); ++i) {
                DynamicObject sortRow = (DynamicObject)sortEntry.get(i);
                model.setValue(FIELDCOMBO, (Object)sortRow.getString(FIELDCOMBO), i);
                model.setValue(SORTCOMBO, (Object)sortRow.getString(SORTCOMBO), i);
            }
            model.endInit();
            this.getView().updateView(CUSTOMSORTENTRY);
        }
    }

    FlexHandler getFlexHandler() {
        return new FlexHandler((ReportView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("printFormClose".equals(closedCallBackEvent.getActionId())) {
            this.getPageCache().remove(PRINT_FLAG_KEY);
        }
    }
}

