/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.OrgType;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.SubsiDiaryHelper;

public class ReportHelper {
    private static final String CUR_FOR = "curfor";
    private static final String CUR_LOCAL = "currencylocalid";
    private static final String CUR_RPT = "currencyrptid";
    private static final String MEASURE_UNIT = "measureunit";
    private static final String DEBIT = "debit";
    private static final String CREDIT = "credit";
    private static final String FOR = "for";
    private static final String LOCAL = "local";
    private static final String RPT = "rpt";
    private static final String QTY = "qty";
    private static final String PRICE = "price";
    private static final String FLEXORGID = "flexorgid";
    private boolean showFor;
    private boolean showRpt;
    private boolean showQty;
    private boolean showPrice;
    protected MulOrgQPRpt qParam;

    private static String getN_AMT() {
        return ResManager.loadKDString((String)"\u91d1\u989d", (String)"ReportHelper_0", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private static String getN_DEBIT() {
        return ResManager.loadKDString((String)"\u501f\u65b9", (String)"ReportHelper_1", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private static String getN_CREDIT() {
        return ResManager.loadKDString((String)"\u8d37\u65b9", (String)"ReportHelper_2", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private static String getN_FOR() {
        return ResManager.loadKDString((String)"\u539f\u5e01", (String)"ReportHelper_3", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private static String getN_LOCAL() {
        return ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"ReportHelper_4", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private static String getN_RPT() {
        return ResManager.loadKDString((String)"\u62a5\u544a\u5e01", (String)"ReportHelper_5", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private static String getN_QTY() {
        return ResManager.loadKDString((String)"\u6570\u91cf", (String)"ReportHelper_6", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    private static String getN_PRICE() {
        return ResManager.loadKDString((String)"\u5355\u4ef7", (String)"ReportHelper_7", (String)"fi-gl-report", (Object[])new Object[0]);
    }

    public ReportHelper(MulOrgQPRpt param) {
        this.qParam = param;
        this.init(param);
    }

    private void init(MulOrgQPRpt param) {
        this.showFor = param.isQueryCurrency();
        this.showRpt = param.isShowRpt();
        this.showQty = param.isShowQty();
        this.showPrice = this.showQty && param.isShowPrice();
    }

    public List<AbstractReportColumn> getReportColumn(List<AbstractReportColumn> columns) {
        Map<String, ReportColumn> columnMap = columns.stream().map(ReportColumn.class::cast).collect(Collectors.toMap(ReportColumn::getFieldKey, column -> column, (original, current) -> original));
        if (this.qParam.getOrgType() == OrgType.ENTITY && columnMap.containsKey("number")) {
            ReportColumn accountNumber = columnMap.get("number");
            accountNumber.setHyperlink(true);
        }
        if (columnMap.containsKey("currencyid")) {
            this.setCurrencyField(columnMap, "currencyid");
        }
        if (columnMap.containsKey("currency")) {
            this.setCurrencyField(columnMap, "currency");
        }
        if (columnMap.containsKey("orgid")) {
            this.setOrgField(columnMap, "orgid");
        }
        if (columnMap.containsKey("org")) {
            this.setOrgField(columnMap, "org");
        }
        if (columnMap.containsKey("assgrp")) {
            ReportColumn assgrpField = columnMap.get("assgrp");
            if (this.qParam.isShowAssist()) {
                assgrpField.setHyperlink(true);
                assgrpField.setFreeze(true);
                assgrpField.setHide(false);
            } else {
                assgrpField.setHide(true);
            }
        }
        if (columnMap.containsKey(MEASURE_UNIT)) {
            ReportColumn measureField = columnMap.get(MEASURE_UNIT);
            if (this.qParam.isShowQty()) {
                measureField.setFreeze(true);
                measureField.setHide(false);
            } else {
                measureField.setHide(true);
            }
        }
        return columns;
    }

    private void setCurrencyField(Map<String, ReportColumn> columnMap, String filedKey) {
        ReportColumn curField = columnMap.get(filedKey);
        if (this.qParam.isAllCurrency()) {
            if (this.qParam.getOrgType() == OrgType.ENTITY) {
                curField.setHyperlink(true);
            }
            curField.setFreeze(true);
            curField.setHide(false);
        } else {
            curField.setHide(true);
        }
    }

    private void setOrgField(Map<String, ReportColumn> columnMap, String filedKey) {
        ReportColumn orgField = columnMap.get(filedKey);
        if (this.qParam.getOrgType() != OrgType.ENTITY && this.qParam.isShowOrg()) {
            orgField.setHyperlink(true);
            orgField.setFreeze(true);
            orgField.setHide(false);
        } else {
            orgField.setHide(true);
        }
    }

    protected ReportColumnGroup getColumnGroup(ReportColumnGroup group, String prefix) {
        this.helper(prefix, group, DEBIT);
        this.helper(prefix, group, CREDIT);
        return group;
    }

    private void helper(String prefix, ReportColumnGroup group, String infix) {
        String localName = infix.equals(DEBIT) ? ReportHelper.getN_DEBIT() : ReportHelper.getN_CREDIT();
        if (this.showQty) {
            ReportColumn qty = ReportHelper.createColumn(new LocaleString(localName + ReportHelper.getN_QTY()), prefix + infix + QTY, QTY);
            group.getChildren().add(qty);
        }
        if (this.showPrice) {
            ReportColumn price = ReportHelper.createColumn(new LocaleString(localName + ReportHelper.getN_PRICE()), prefix + infix + PRICE, PRICE, this.showFor);
            group.getChildren().add(price);
        }
        if (this.showFor) {
            ReportColumn debitFor = ReportHelper.createColumn(new LocaleString(localName + ReportHelper.getN_FOR()), prefix + infix + FOR, "amount");
            group.getChildren().add(debitFor);
        }
        ReportColumn debitLocal = ReportHelper.createColumn(this.showFor ? new LocaleString(localName + ReportHelper.getN_LOCAL()) : new LocaleString(localName + ReportHelper.getN_AMT()), prefix + infix + LOCAL, "amount");
        group.getChildren().add(debitLocal);
        if (this.showRpt) {
            ReportColumn debitRpt = ReportHelper.createColumn(new LocaleString(localName + ReportHelper.getN_RPT()), prefix + infix + RPT, "amount");
            group.getChildren().add(debitRpt);
        }
    }

    public static ReportColumn createColumn(LocaleString caption, String fieldKey, String fieldType, boolean showFor) {
        ReportColumn column = new ReportColumn();
        column.setCaption(caption);
        column.setFieldKey(fieldKey);
        column.setFieldType(fieldType);
        if ("amount".equals(fieldType)) {
            if (fieldKey.endsWith(LOCAL)) {
                column.setCurrencyField(CUR_LOCAL);
            } else if (fieldKey.endsWith(RPT)) {
                column.setCurrencyField(CUR_RPT);
            } else if (fieldKey.endsWith(FOR)) {
                column.setCurrencyField(CUR_FOR);
            }
        } else if (QTY.equals(fieldType)) {
            column.setMeasureUnitField(MEASURE_UNIT);
        } else if (PRICE.equals(fieldType)) {
            if (showFor) {
                column.setCurrencyField(CUR_FOR);
            } else {
                column.setCurrencyField(CUR_LOCAL);
            }
        }
        return column;
    }

    public static ReportColumn createColumn(LocaleString caption, String fieldKey, String fieldType) {
        return ReportHelper.createColumn(caption, fieldKey, fieldType, true);
    }

    public static List<Tuple<String, String>> buildAssTypenameList(ReportQueryParam reportQueryParam) {
        List assistFilterEntries = FlexUtils.buildAssistFilterInfo((ReportQueryParam)reportQueryParam);
        List<Tuple<String, String>> assTypenameList = assistFilterEntries.stream().map(entry -> {
            String assistEntityId = "";
            FlexProperty flexProperty = entry.getFlexProperty();
            switch (AssistValueType.getTypeEnum((String)flexProperty.getValueType())) {
                case baseData: {
                    assistEntityId = flexProperty.getValueSource();
                    break;
                }
                case assistData: {
                    assistEntityId = "bos_assistantdata_detail";
                    break;
                }
            }
            String name = flexProperty.getName().getLocaleValue();
            if (StringUtils.isNotEmpty((String)flexProperty.getDisplayProp())) {
                String dispProp;
                switch (dispProp = JSONObject.parseObject((String)flexProperty.getDisplayProp()).getJSONObject("disp").getString("dispprop")) {
                    case "1": {
                        return new Tuple((Object)name, (Object)(assistEntityId + ",number"));
                    }
                    case "3": {
                        return new Tuple((Object)name, (Object)(assistEntityId + ",name,number"));
                    }
                    case "4": {
                        return new Tuple((Object)name, (Object)(assistEntityId + ",longnumber"));
                    }
                    case "5": {
                        return new Tuple((Object)name, (Object)(assistEntityId + ",fullname"));
                    }
                }
                return new Tuple((Object)name, (Object)(assistEntityId + ",name"));
            }
            return new Tuple((Object)name, (Object)(assistEntityId + ",name"));
        }).collect(Collectors.toList());
        return assTypenameList;
    }

    public static List<AbstractReportColumn> buildAssColumn(List<Tuple<String, String>> assTypeNames, String treeAlias) {
        ArrayList<AbstractReportColumn> list = new ArrayList<AbstractReportColumn>(16);
        for (int i = 0; i < assTypeNames.size(); ++i) {
            ReportColumn column;
            String assVal = i == 0 ? "assval" : "assval" + i;
            String assValName = i == 0 ? "assvalname" : "assvalname" + i;
            String entityId = (String)assTypeNames.get((int)i).item2;
            String columnCaption = (String)assTypeNames.get((int)i).item1;
            String[] splitArray = entityId.split(",");
            if (StringUtils.isNotEmpty((String)splitArray[0])) {
                String columnType = "bos_assistantdata_detail".equals(splitArray[0]) ? "assistant" : "basedata";
                switch (splitArray.length) {
                    case 2: {
                        column = ReportHelper.createColumn(new LocaleString(columnCaption), assVal, columnType);
                        column.setEntityId(splitArray[0]);
                        column.setDisplayProp(splitArray[1]);
                        SubsiDiaryHelper.initFieldProperty((ReportColumn)column);
                        break;
                    }
                    case 3: {
                        column = ReportHelper.createColumn(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"AssistBalHelper_11", (String)"fi-gl-report", (Object[])new Object[0]), columnCaption)), assVal, columnType);
                        column.setEntityId(splitArray[0]);
                        column.setDisplayProp("number");
                        column.setFreeze(true);
                        if (assVal.equals(treeAlias) && treeAlias != null) {
                            column.setHide(true);
                        }
                        SubsiDiaryHelper.initFieldProperty((ReportColumn)column);
                        list.add((AbstractReportColumn)column);
                        column = ReportColumn.createBaseDataPropColumn((String)assValName, (String)assVal, (String)"name");
                        column.setCaption(new LocaleString((String)assTypeNames.get((int)i).item1));
                        break;
                    }
                    default: {
                        column = ReportHelper.createColumn(new LocaleString(columnCaption), assVal, columnType);
                        column.setEntityId(splitArray[0]);
                        column.setDisplayProp("name");
                        SubsiDiaryHelper.initFieldProperty((ReportColumn)column);
                    }
                }
                column.setFreeze(true);
                if (assVal.equals(treeAlias)) {
                    column.setHide(true);
                }
                list.add((AbstractReportColumn)column);
                continue;
            }
            column = ReportHelper.createColumn(new LocaleString(columnCaption), assVal, "text");
            column.setFreeze(true);
            list.add((AbstractReportColumn)column);
        }
        return list;
    }

    public static ReportColumn createFlexOrgidColumn() {
        ReportColumn flexorgidColumn = new ReportColumn();
        flexorgidColumn.setHide(true);
        flexorgidColumn.setFieldKey(FLEXORGID);
        flexorgidColumn.setEntityId("bos_org");
        flexorgidColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ReportHelper_8", (String)"fi-gl-report", (Object[])new Object[0])));
        flexorgidColumn.setFieldType("basedata");
        return flexorgidColumn;
    }

    public static boolean getLevelFilter() {
        return BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.report.account.level.filter", (boolean)true);
    }

    public static DataSet filterLevel(DataSet balanceDataSet, FilterInfo filterInfo, Tuple<String, String> joinField, Long orgId) {
        List value;
        boolean showLeafAccount = filterInfo.getBoolean("showleafaccount");
        FilterItemInfo itemInfo = filterInfo.getFilterItem("account");
        if (itemInfo != null && itemInfo.getValue() != null && ReportHelper.getLevelFilter() && !showLeafAccount && (value = (List)itemInfo.getValue()) != null) {
            HashSet<String> numberSet = new HashSet<String>(value.size());
            for (DynamicObject dyn : value) {
                numberSet.add(dyn.getString("number"));
            }
            DataSet accountDataSet = AccountUtils.getAllLeafAcct(numberSet, (Long)filterInfo.getLong("endperiod"), (Long)orgId, (Long)filterInfo.getLong("accounttable"));
            accountDataSet = accountDataSet.filter("level <=" + Integer.valueOf(filterInfo.getString("accountlevel")));
            balanceDataSet = balanceDataSet.join(accountDataSet, JoinType.INNER).on((String)joinField.item1, (String)joinField.item2).select(ReportUtils.getDataSetCols((DataSet)balanceDataSet).toArray(new String[0]), null).finish();
        }
        return balanceDataSet;
    }

    public static BigDecimal adapterNonBigDecimal(Object value) {
        if (null == value) {
            return BigDecimal.ZERO;
        }
        return value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
    }

    public DataSet addPersonalizeFields(DataSet rawDs) {
        Map periodMap = SubsidiaryReportDatasetBuilder.initPeriodMap((Long)this.qParam.getEndPeriod(), (Long)this.qParam.getEndPeriod());
        Date nameCtrlDate = ((SubsidiaryPeriod)periodMap.get(this.qParam.getEndPeriod())).getEnddate();
        Field[] fields = (rawDs = rawDs.addField(DateUtils.getYearMonthDayFuncStr((Date)nameCtrlDate), "namectrldate")).getRowMeta().getFields();
        boolean isShowOrgField = Arrays.stream(fields).anyMatch(x -> x.getAlias().equals("org"));
        rawDs = isShowOrgField && this.qParam.isShowOrg() ? rawDs.addField("org", FLEXORGID) : rawDs.addField(String.valueOf(this.qParam.getOrgs().get(0)), FLEXORGID);
        return rawDs;
    }

    public DataSet addOtherFields(DataSet balanceDataSet) {
        balanceDataSet = this.qParam.addCurLocal("org", balanceDataSet);
        if (this.qParam.isShowRpt()) {
            balanceDataSet = balanceDataSet.addField("" + this.qParam.getCurRpt(), CUR_RPT);
        }
        balanceDataSet = balanceDataSet.addField("account", "accountnumber");
        balanceDataSet = this.addPersonalizeFields(balanceDataSet);
        return balanceDataSet;
    }

    public static Object[] gainEmptyRow(RowMeta rowMeta, Map<String, Object> defaultValue) {
        Object[] value = new Object[rowMeta.getFieldCount()];
        for (int i = 0; i < rowMeta.getFields().length; ++i) {
            Field field = rowMeta.getFields()[i];
            String name = field.getName().toLowerCase();
            if (defaultValue.containsKey(name)) {
                value[i] = defaultValue.get(name);
                continue;
            }
            DataType dataType = field.getDataType();
            if (dataType instanceof LongType) {
                value[i] = 0L;
                continue;
            }
            if (dataType instanceof IntegerType) {
                value[i] = 0;
                continue;
            }
            if (dataType instanceof BigDecimalType) {
                value[i] = BigDecimal.ZERO;
                continue;
            }
            if (dataType instanceof StringType) {
                value[i] = "";
                continue;
            }
            if (!(dataType instanceof BooleanType)) continue;
            value[i] = false;
        }
        return value;
    }
}

