/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.configuration.ReportConfiguration;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.common.RptUtil;
import kd.fi.gl.report.service.RptAccountServiceHelper;
import kd.fi.gl.report.subledger.SLTreeBalanceZeroService;
import kd.fi.gl.util.GLUtil;

public class SubLedgerTreeRpt
extends AbstractReportTreeDataPlugin {
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private MulOrgQPRpt mulOrgQPRpt;
    private Long parentOrg;
    private List<Long> entityOrgs;

    public List<TreeNode> query(ReportQueryParam param, String selectedObj) {
        this.setParentAndEntityOrgs(param.getFilter());
        DynamicObjectCollection acctCol = this.getAccountCollection(param);
        return this.createAccountTree(acctCol);
    }

    private void setParentAndEntityOrgs(FilterInfo filterInfo) {
        this.mulOrgQPRpt = new MulOrgQPRpt(filterInfo, "gl_rpt_subledger");
        this.entityOrgs = this.mulOrgQPRpt.getAllEntityOrgs();
        this.parentOrg = AccSysUtil.getParentOrgByChildre((List)this.mulOrgQPRpt.getOrgs());
    }

    private DynamicObjectCollection getAccountCollection(ReportQueryParam param) {
        QFilter acctF;
        DataSet dt;
        FilterInfo filter = param.getFilter();
        Long accountTableId = filter.getLong("accounttable");
        List comAssistFiltersForBill = this.mulOrgQPRpt.getComAssistFiltersForBill(key -> key);
        String currencyId = filter.getString("currency");
        boolean nodisplayforzero = filter.getBoolean("nodisplayforzero");
        boolean isSubPL = filter.getBoolean("issubstractpl");
        DataSet initBal = null;
        QFilter qacct = this.getAccountFilter(filter);
        if (isSubPL) {
            ArrayList<QFilter> list = new ArrayList<QFilter>(4);
            list.addAll(comAssistFiltersForBill);
            list.add(new QFilter("org", "in", this.entityOrgs));
            list.add(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
            list.add(new QFilter("accounttable", "=", (Object)accountTableId));
            if (qacct != null) {
                list.add(qacct);
            }
            list.add(new QFilter("account.pltype", "!=", (Object)"0"));
            if (!("allcurrency".equals(currencyId) || "basecurrency".equals(currencyId) || "reportcurrency".equals(currencyId))) {
                list.add(new QFilter("currency", "=", (Object)Long.valueOf(currencyId)));
            }
            initBal = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_initbalance", (String)"account", (QFilter[])list.toArray(new QFilter[0]), null);
        }
        if (nodisplayforzero && "2".equals(filter.getString("searchtype"))) {
            DynamicObjectCollection accountColl = filter.getDynamicObjectCollection("account");
            HashSet<String> accountNumSet = new HashSet<String>(32);
            if (accountColl != null && !accountColl.isEmpty()) {
                for (DynamicObject account : accountColl) {
                    accountNumSet.add(account.getString("number"));
                }
            }
            Collection<Long> midSet = RptUtil.getAllLeafAccountByNums(accountNumSet, (Long)accountTableId, (QFilter)this.getDateFilter(filter)).values();
            String acctSqlStr = "";
            if (!midSet.isEmpty()) {
                acctSqlStr = this.getAcctIdsSqlStr(midSet);
            }
            Map vchFields = MetadataServiceHelper.getDataEntityType((String)"gl_voucher").getAllFields();
            String comAssistFilterStr = comAssistFiltersForBill.stream().map(qFilter -> {
                String dbKey = ((IDataEntityProperty)vchFields.get(qFilter.getProperty())).getAlias();
                return new QFilter(dbKey, qFilter.getCP(), qFilter.getValue());
            }).map(QFilter::toString).map(filterStr -> " and t1." + filterStr + " ").collect(Collectors.joining());
            long beginPeriod = filter.getLong("startperiod");
            long endPeriod = filter.getLong("endperiod");
            Date startDate = filter.getDate("datebegin");
            String startDateStr = this.format.format(startDate);
            Date endDate = filter.getDate("dateend");
            String endDateStr = this.format.format(endDate);
            StringBuilder sqlsb = new StringBuilder("select t3.fmasterid account from t_bd_account t3 where t3.faccounttableid=");
            sqlsb.append(accountTableId);
            if (!midSet.isEmpty()) {
                sqlsb.append(" and t3.fmasterid in (").append(acctSqlStr).append(")");
            }
            sqlsb.append(" and EXISTS (select 1 from t_gl_voucherentry t1 left join t_gl_voucher t2 on t1.fid=t2.fid where t2.forgid in (").append(this.entityOrgs.stream().map(l -> l + "").collect(Collectors.joining(","))).append(") and t2.fbooktypeid=").append(filter.getLong("booktype")).append(" and t2.fperiodid>=").append(beginPeriod).append("  and t2.fperiodid<=").append(endPeriod).append(" and t2.fbillstatus<>'A'");
            if (!("allcurrency".equals(currencyId) || "basecurrency".equals(currencyId) || "reportcurrency".equals(currencyId))) {
                sqlsb.append(" and t1.fcurrencyid=").append(currencyId);
            }
            sqlsb.append(comAssistFilterStr);
            sqlsb.append(" and to_date(to_char(t2.fbookeddate,'yyyy-MM-dd'))>= to_date('").append(startDateStr).append("') and to_date(to_char(t2.fbookeddate,'yyyy-MM-dd'))<= to_date('").append(endDateStr).append("')  and t3.fid=t1.faccountid)");
            dt = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)sqlsb.toString());
        } else {
            QFilter balFilter = new QFilter("org", "in", this.entityOrgs);
            this.mulOrgQPRpt.getComAssistFiltersForBal().forEach(arg_0 -> ((QFilter)balFilter).and(arg_0));
            balFilter.and(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
            balFilter.and(new QFilter("accounttable", "=", (Object)accountTableId));
            this.setPeriodFilter(filter, balFilter);
            if (!("allcurrency".equals(currencyId) || "basecurrency".equals(currencyId) || "reportcurrency".equals(currencyId))) {
                balFilter.and(new QFilter("currency", "=", (Object)Long.valueOf(currencyId)));
            }
            if (qacct != null) {
                balFilter.and(qacct);
            }
            String entityName = ReportConfiguration.ENABLE_ACC_BAL_QUERY.getBoolean() ? "gl_acctbalance" : "gl_balance";
            dt = ORM.create().queryDataSet("subledger tree", entityName, "account", balFilter.toArray(), null, -1, (Distinctable)WithDistinctable.get());
        }
        DataSet balLog = null;
        QFilter balFilter = new QFilter("org", "in", this.entityOrgs);
        comAssistFiltersForBill.forEach(arg_0 -> ((QFilter)balFilter).and(arg_0));
        balFilter.and(new QFilter("booktype", "=", (Object)filter.getLong("booktype")));
        balFilter.and(new QFilter("accounttable", "=", (Object)accountTableId));
        balFilter.and(new QFilter("calculated", "=", (Object)Character.valueOf('0')));
        long endPeriod = filter.getLong("endperiod");
        balFilter.and(new QFilter("period", "<=", (Object)endPeriod));
        balFilter.and(new QFilter("period", ">=", (Object)(endPeriod / GLUtil.TYPE_PERIOD_L * GLUtil.TYPE_PERIOD_L)));
        if (!("allcurrency".equals(currencyId) || "basecurrency".equals(currencyId) || "reportcurrency".equals(currencyId))) {
            balFilter.and(new QFilter("currency", "=", (Object)Long.valueOf(currencyId)));
        }
        if (qacct != null) {
            balFilter.and(qacct);
        }
        balLog = QueryServiceHelper.queryDataSet((String)"subledger tree", (String)"gl_balance_log", (String)"account", (QFilter[])balFilter.toArray(), null);
        try (DataSet accds = initBal == null ? dt.union(balLog) : dt.union(balLog).union(initBal);){
            int accountlevel;
            Set<Long> acctMids = new HashSet<Long>(32);
            for (Row row : accds) {
                acctMids.add(row.getLong("account"));
            }
            if (this.mulOrgQPRpt.isNoZeroBalance()) {
                acctMids = SLTreeBalanceZeroService.filter((MulOrgQPRpt)this.mulOrgQPRpt, acctMids);
            }
            DataSet accIdSet = this.getAccountSetByMasterId(acctMids, filter, accountTableId);
            Set<Long> accountIdSet = this.getAccountIdSet(filter, accIdSet);
            acctF = new QFilter("id", "in", accountIdSet);
            if (!filter.getBoolean("showleafaccount") && (accountlevel = filter.getInt("accountlevel")) > 0) {
                acctF.and(new QFilter("level", "<=", (Object)filter.getInt("accountlevel")));
            }
        }
        String selectFields = String.format("id, %s name,number,accounttype,accounttype.parent parent,accounttype.name typename,accounttype.level level, parent.number", GLUtil.getAcctNameBySysParam((Long)this.parentOrg));
        return QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".getAccount"), (String)"bd_accountview", (String)selectFields, (QFilter[])acctF.toArray(), (String)"number");
    }

    private DataSet getAccountSetByMasterId(Set<Long> acctMids, FilterInfo filter, Long accountTableId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(this.getDateFilter(filter));
        filters.add(new QFilter("masterid", "in", acctMids));
        return AccountUtils.queryAccountDataSet(new HashSet<Long>(this.entityOrgs), (long)accountTableId, (String)"id account", filters, null);
    }

    private void setPeriodFilter(FilterInfo filter, QFilter balFilter) {
        long beginPeriod = filter.getLong("startperiod");
        long endPeriod = filter.getLong("endperiod");
        if (filter.getBoolean("nodisplayforzero")) {
            balFilter.and(new QFilter("endperiod", "in", (Object)PeriodUtil.getAvailableEndPeriodIds((String)">", (Long)beginPeriod, (Long[])this.entityOrgs.toArray(new Long[0]))));
            List periodIds = GLUtil.getPeriodIds((Long)beginPeriod, (Long)endPeriod);
            balFilter.and(new QFilter("period", "in", (Object)periodIds));
            balFilter.and(new QFilter("count", ">", (Object)0));
        } else {
            balFilter.and(new QFilter("endperiod", "=", (Object)GLUtil.MAX_PERIOD));
        }
    }

    private QFilter getAccountFilter(FilterInfo filter) {
        DynamicObjectCollection accountDyos = filter.getDynamicObjectCollection("account");
        if (ReportConfiguration.SL_NO_FILTER_SELECT_NONE_ACC.getBoolean() && CollectionUtils.isEmpty((Collection)accountDyos)) {
            return null;
        }
        Set<Long> midSet = RptAccountServiceHelper.queryAccountMIdsByEOrg((QueryParamRpt)this.mulOrgQPRpt, null);
        if (!midSet.isEmpty() || CollectionUtils.isNotEmpty((Collection)accountDyos)) {
            return new QFilter("account", "in", midSet);
        }
        return null;
    }

    private String getAcctIdsSqlStr(Collection<Long> ids) {
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(id);
        }
        return sb.toString();
    }

    private Set<Long> getAccountIdSet(FilterInfo filter, DataSet accds) {
        HashSet<Long> accPkSet = new HashSet<Long>(64);
        while (accds.hasNext()) {
            Row row = accds.next();
            accPkSet.add(row.getLong("account"));
        }
        this.getAllParentIds(accPkSet);
        HashSet<Long> result = new HashSet<Long>(accPkSet.size());
        HashSet<String> numSet = new HashSet<String>(accPkSet.size());
        QFilter atF = new QFilter("accounttable", "=", (Object)filter.getLong("accounttable"));
        QFilter fdate = this.getDateFilter(filter);
        HashMap<String, Long> acct_num = new HashMap<String, Long>(100);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(fdate);
        if (filter.getBoolean("showleafaccount")) {
            filters.add(new QFilter("isleaf", "=", (Object)"1"));
        }
        try (DataSet dt = AccountUtils.queryAccountDataSet((long)this.parentOrg, (long)filter.getLong("accounttable"), (String)"id,number", filters, null);){
            for (Row row : dt) {
                acct_num.put(row.getString("number"), row.getLong("id"));
            }
        }
        var11_11 = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"subledger tree", (String)"bd_accountview", (String)"id,number,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", accPkSet), atF}, null);){
            DataSet dt = ReportHelper.filterLevel(dataSet, filter, (Tuple<String, String>)Tuple.create((Object)"masterid", (Object)"masterid"), this.parentOrg);
            while (dt.hasNext()) {
                Row row;
                row = dt.next();
                String num = row.getString("number");
                if (!numSet.add(num)) continue;
                result.add((Long)acct_num.get(num));
            }
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        return result;
    }

    private QFilter getDateFilter(FilterInfo filter) {
        Date endDate = null;
        if ("2".equals(filter.getString("searchtype"))) {
            endDate = filter.getDate("dateend");
            DynamicObject periodDyo = PeriodUtil.getPeriodByDate((Date)endDate, (long)filter.getLong("periodtype"));
            if (periodDyo != null) {
                endDate = periodDyo.getDate("enddate");
            }
        } else {
            long endPeriod = filter.getLong("endperiod");
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriod, (String)"bd_period");
            endDate = period.getDate("enddate");
        }
        QFilter fstartDate = new QFilter("startdate", "<=", (Object)endDate);
        QFilter fendDate = new QFilter("enddate", ">=", (Object)endDate);
        return fendDate.and(fstartDate);
    }

    private Set<Long> getAllParentIds(Set<Long> accountIdSet) {
        HashSet<Long> accPkSet = new HashSet<Long>(8);
        QFilter balFilter = new QFilter("id", "in", accountIdSet);
        balFilter.and(QFilter.isNotNull((String)"parent").and(new QFilter("parent", "!=", (Object)0)));
        try (DataSet accds = QueryServiceHelper.queryDataSet((String)"subledger tree", (String)"bd_accountview", (String)"parent.masterid account", (QFilter[])balFilter.toArray(), null);){
            while (accds.hasNext()) {
                Row row = accds.next();
                if (row.getLong("account") == null) continue;
                accPkSet.add(row.getLong("account"));
            }
        }
        if (!accPkSet.isEmpty()) {
            accountIdSet.addAll(this.getAllParentIds(accPkSet));
        }
        return accountIdSet;
    }

    List<TreeNode> createAccountTree(DynamicObjectCollection account) {
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>(16);
        HashMap number2AcctNode = new HashMap();
        String rootNode = "0";
        account.stream().map(acct -> {
            String number = acct.getString("number");
            String acctName = acct.getString("name");
            TreeNode acctNode = new TreeNode(null, acct.getString("id"), number + " " + acctName);
            number2AcctNode.put(number, acctNode);
            return acctNode;
        }).forEach(treeList::add);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < account.size(); ++i) {
            TreeNode acctNode = (TreeNode)treeList.get(i);
            DynamicObject acct2 = (DynamicObject)account.get(i);
            String parentNumber = acct2.getString("parent.number");
            String parentNode = this.dealAcctTypeNode(map, acct2, treeList, rootNode, i == 0);
            if (StringUtils.isNotBlank((CharSequence)parentNumber) && number2AcctNode.containsKey(parentNumber)) {
                parentNode = ((TreeNode)number2AcctNode.get(parentNumber)).getId();
            }
            acctNode.setParentid(parentNode);
        }
        TreeNode node = this.createTreeNode(null, rootNode, ResManager.loadKDString((String)"\u79d1\u76ee", (String)"SubLedgerTreeRpt_0", (String)"fi-gl-report", (Object[])new Object[0]), true);
        treeList.add(0, node);
        return treeList;
    }

    private String dealAcctTypeNode(Map<String, String> map, DynamicObject acct, List<TreeNode> treeList, String rootNodeId, boolean isOpen) {
        TreeNode node;
        String acctTypeName = acct.getString("typename");
        if (map.containsKey(acctTypeName)) {
            return map.get(acctTypeName);
        }
        long typeParent = -acct.getLong("parent");
        long typeId = -acct.getLong("accounttype");
        String strTypeId = String.valueOf(typeId);
        String strParent = String.valueOf(typeParent);
        String nodeId = String.valueOf(typeId);
        for (int level = acct.getInt("level"); level > 1; --level) {
            if (map.containsKey(acctTypeName)) continue;
            node = this.createTreeNode(strParent, strTypeId, acctTypeName, isOpen);
            treeList.add(node);
            map.put(acctTypeName, strTypeId);
            DynamicObject obj = this.getAccountTypeById(typeParent);
            typeParent = -obj.getLong("parent");
            typeId = -obj.getLong("id");
            acctTypeName = obj.getString("name");
            strTypeId = String.valueOf(typeId);
            strParent = String.valueOf(typeParent);
        }
        if (!map.containsKey(acctTypeName)) {
            node = this.createTreeNode(rootNodeId, strTypeId, acctTypeName, isOpen);
            treeList.add(node);
            map.put(acctTypeName, strTypeId);
        }
        return nodeId;
    }

    private DynamicObject getAccountTypeById(Long id) {
        if (id < 0L) {
            id = -id.longValue();
        }
        QFilter fid = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection col = QueryServiceHelper.query((String)(SubLedgerTreeRpt.class.getName() + "getAccountTypeById"), (String)"bd_accounttype", (String)"id,name,level,parent", (QFilter[])fid.toArray(), null);
        return (DynamicObject)col.get(0);
    }

    private TreeNode createTreeNode(String parentId, String id, String text, boolean isOpen) {
        TreeNode node = new TreeNode(parentId, id, text);
        node.setIsOpened(isOpen);
        return node;
    }
}

