/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.assistbalance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.bd.model.Context;
import kd.fi.bd.service.balance.account.IAccountTreeModel;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PerformanceWatch;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.enums.AssistShowType;
import kd.fi.gl.enums.basedata.AssistValueType;
import kd.fi.gl.report.MulOrgQPRpt;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.ReportHelper;
import kd.fi.gl.report.ReportUtils;
import kd.fi.gl.report.assistbalance.AccIDSumUpTree;
import kd.fi.gl.report.assistbalance.AccountIndex;
import kd.fi.gl.report.assistbalance.AssistBalHelper;
import kd.fi.gl.report.assistbalance.AssistBalanceContext;
import kd.fi.gl.report.assistbalance.AssistBalanceDSMeta;
import kd.fi.gl.report.assistbalance.AssistBalanceProcessor;
import kd.fi.gl.report.assistbalance.BalancePureQueryService;
import kd.fi.gl.report.assistbalance.BalanceSubtotalSorter;
import kd.fi.gl.report.assistbalance.model.AssistBalanceKey;
import kd.fi.gl.report.assistbalance.model.AssistBalanceSubtotal;
import kd.fi.gl.report.assistbalance.model.AssistSubtotalKey;
import kd.fi.gl.report.assistbalance.model.BalanceAggregateKey;
import kd.fi.gl.report.assistbalance.model.BalanceUnitVO;
import kd.fi.gl.report.assistbalance.model.RawBalanceRow;
import kd.fi.gl.report.assistbalance.model.RawPLVoucherRow;
import kd.fi.gl.report.assistbalance.model.SubtotalType;
import kd.fi.gl.report.assistbalance.model.TreeGroupKey;
import kd.fi.gl.report.subsidiary.SubsidiaryPeriod;
import kd.fi.gl.report.subsidiary.SubsidiaryReportDatasetBuilder;
import kd.fi.gl.util.BaseDataUtil;
import kd.fi.gl.util.DataSetHelper;
import kd.fi.gl.util.DateUtils;
import kd.fi.gl.util.FastKey;
import kd.fi.gl.util.FlexUtils;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.MulCurReportUtil;
import kd.fi.gl.vo.AssistTreeStyleVO;
import kd.fi.gl.vo.NameHistoryVO;
import org.apache.commons.lang3.tuple.Triple;

public class AssistBalQueryRpt
extends AbstractReportListDataPlugin {
    private static final Log LOG = LogFactory.getLog(AssistBalQueryRpt.class);
    private static final String CACHE_KEY = "AssistRptTxtFilterPlugin_param";
    private static final String ASSIST_FIELD_PREFIX = "assval";
    private List<String> COMASSIST_BAL_LIST = new ArrayList<String>(8);
    private List<String> COMASSIST_VOUCHER_LIST = new ArrayList<String>(8);
    private ReportQueryParam reportQueryParam;
    private MulOrgQPRpt qParam;
    private Date nameCtrlDate;
    private AssistBalanceSubtotal totalSubtotal = null;
    private boolean exportAll = false;
    private boolean finalDataSetBatch = false;
    private boolean queryBalanceOnly = false;
    private List<Row> balanceList = null;
    private RowMeta balanceRowMeta = null;
    private DataSet exportBalanceLogDs = null;
    private DataSet exportPlVoucherDs = null;
    int realMaxRowLimit;
    private List<String> flexFieldNames = new ArrayList<String>(8);
    private static final String VOUCHER_SEL_FIELDS = "org,booktype,period,period.periodyear periodyear,entries.assgrp assgrp,entries.account account,entries.currency currency,entries.measureunit measureunit,entries.quantity quantity,entries.debitori vdebitfor,entries.creditori vcreditfor";
    private static final String[] ASSIST_FLEX_NAMES = new String[]{"treeid", "assvalname", "namectrldate"};
    private static String[] PL_VOUCHER_AMOUNT_FIELDS = new String[]{"vdebitfor", "vdebitlocal", "vcreditfor", "vcreditlocal", "vdebitqty", "vcreditqty", "vcount", "vbeginfor", "vbeginlocal", "vbeginqty"};

    public DataSet queryExportBalance(ReportQueryParam reportQueryParam, Context context) throws Throwable {
        this.queryBalanceOnly = true;
        DataSet dataSet = this.query(reportQueryParam, null);
        this.balanceRowMeta = dataSet.getRowMeta();
        context.registerContext("qParam", (Object)this.qParam);
        context.registerContext("nameCtrlDate", (Object)this.nameCtrlDate);
        context.registerContext("flexFieldNames", this.flexFieldNames);
        context.registerContext("comAssistCount", (Object)this.COMASSIST_BAL_LIST.size());
        List assistFilterEntries = FlexUtils.buildAssistFilterInfo((ReportQueryParam)reportQueryParam);
        context.registerContext("assistFilterEntries", (Object)assistFilterEntries);
        return dataSet;
    }

    public DataSet batchCalExportBalance(ReportQueryParam reportQueryParam, Context context, List<Row> batchList) throws Throwable {
        this.exportAll = true;
        this.finalDataSetBatch = (Boolean)context.query("finalDataSetBatch");
        this.queryBalanceOnly = false;
        this.balanceList = batchList;
        DataSet dataSet = this.query(reportQueryParam, null);
        context.registerContext("totalSubtotal", (Object)this.totalSubtotal);
        return dataSet;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FlexUtils.preInitFlexItem((FilterInfo)reportQueryParam.getFilter(), (boolean)false);
        this.reportQueryParam = reportQueryParam;
        int maxRowLimit = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assistbalance.showsize", (int)100000);
        double subtotalTolerance = Double.parseDouble(BillParamUtil.getStringValue((String)"83bfebc8000017ac", (String)"fi.gl.report.assistbalance.subtotaltolerance", (String)"1"));
        Optional<AssistTreeStyleVO> treeStyle = Optional.empty();
        Map customParam = reportQueryParam.getCustomParam();
        String paramStr = (String)customParam.get(CACHE_KEY);
        if (StringUtils.isNotEmpty((String)paramStr)) {
            boolean isSpecificLevelButWithZero;
            treeStyle = Optional.of(SerializationUtils.fromJsonString((String)paramStr, AssistTreeStyleVO.class));
            boolean bl = isSpecificLevelButWithZero = AssistShowType.SpecificLevel.getValue() == ((AssistTreeStyleVO)treeStyle.get()).getShowType() && ((AssistTreeStyleVO)treeStyle.get()).getSpecificLevel() == 0;
            if (isSpecificLevelButWithZero) {
                treeStyle = Optional.empty();
            }
        }
        this.qParam = new MulOrgQPRpt(reportQueryParam.getFilter(), "gl_rpt_assistbalance");
        if (CollectionUtils.isEmpty((Collection)this.qParam.getChildOrg())) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass());
        }
        this.setComassist();
        Map periodMap = SubsidiaryReportDatasetBuilder.initPeriodMap((Long)this.qParam.getEndPeriod(), (Long)this.qParam.getEndPeriod());
        this.nameCtrlDate = ((SubsidiaryPeriod)periodMap.get(this.qParam.getEndPeriod())).getEnddate();
        this.realMaxRowLimit = (int)((double)maxRowLimit * subtotalTolerance);
        LOG.info("real limit max rows:" + this.realMaxRowLimit);
        DataSet assistBalanceDs = this.queryAssistBalanceSet(reportQueryParam, this.qParam, this.exportAll ? Integer.MAX_VALUE : this.realMaxRowLimit, treeStyle);
        if (assistBalanceDs.isEmpty()) {
            return assistBalanceDs;
        }
        if (this.queryBalanceOnly) {
            return assistBalanceDs;
        }
        if (treeStyle.isPresent()) {
            DataSet assistDataSet = this.buildTreeAssistDataSet(assistBalanceDs, treeStyle.get());
            assistBalanceDs = this.joinTreeAssistDataSet(assistBalanceDs, assistDataSet);
        }
        assistBalanceDs = assistBalanceDs.addField(DateUtils.getYearMonthDayFuncStr((Date)this.nameCtrlDate), "namectrldate");
        return assistBalanceDs;
    }

    private DataSet joinTreeAssistDataSet(DataSet result, DataSet assistDataSet) {
        List<String> finalCols = this.getLeftJoinAssistDataSetCols(result);
        List cols = GLUtil.getDataSetCols((DataSet)result);
        result = result.join(assistDataSet, JoinType.LEFT).on("treeid", "treeid").select(cols.toArray(new String[0]), new String[]{"assvalname", "namectrldate"}).finish().select(finalCols.toArray(new String[0]));
        return result;
    }

    private DataSet buildTreeAssistDataSet(DataSet ds, AssistTreeStyleVO assistTreeStyleVO) {
        BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)assistTreeStyleVO.getEntityId());
        String nameProp = entity.getNameProperty();
        NameHistoryVO nameHistoryVO = new NameHistoryVO(assistTreeStyleVO.getEntityId(), Long.valueOf(this.qParam.getPorg()), String.format("id,%s name", nameProp), this.nameCtrlDate);
        String treeAssistAlias = (String)ThreadCache.get((Object)"_tree_assist_field");
        for (Row row : ds.copy()) {
            if (row.get("_rowtype").equals("Total")) continue;
            nameHistoryVO.addAssId(row.getLong(treeAssistAlias));
        }
        List<NameHistoryVO> nameHistoryVOS = Collections.singletonList(nameHistoryVO);
        BaseDataUtil.queryBaseDataByDate(nameHistoryVOS);
        DataType[] dataTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.DateType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])ASSIST_FLEX_NAMES, (DataType[])dataTypes);
        DataSetBuilder builder = Algo.create((String)(((Object)((Object)this)).getClass().getName() + "buildTreeAssistDataSet")).createDataSetBuilder(rowMeta);
        for (NameHistoryVO vo : nameHistoryVOS) {
            vo.getAssIdNameMap().entrySet().stream().forEach(entry -> builder.append(new Object[]{entry.getKey(), StringUtils.isEmpty((String)((String)entry.getValue())) ? null : entry.getValue(), vo.getNameCtrlDate()}));
        }
        return builder.build();
    }

    private List<String> getLeftJoinAssistDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if ("treename".equals(field.getName())) {
                list.add("case when assvalname is null then treename else assvalname end as treename");
                continue;
            }
            list.add(field.getName());
        }
        return list;
    }

    private void setComassist() {
        this.COMASSIST_BAL_LIST.clear();
        this.COMASSIST_VOUCHER_LIST.clear();
        FilterInfo filterInfo = this.reportQueryParam.getFilter();
        if (!filterInfo.getBoolean("showcomassist")) {
            return;
        }
        DynamicObject acctTableDyn = filterInfo.getDynamicObject("accounttable");
        if (acctTableDyn == null) {
            return;
        }
        DynamicObjectCollection accTableColl = acctTableDyn.getDynamicObjectCollection("comassistentry");
        for (int i = 1; i <= accTableColl.size(); ++i) {
            String fieldKey = "comassist" + i;
            if (!filterInfo.containProp(fieldKey)) continue;
            String fieldKeyId = this.comAssist_Suffix(fieldKey);
            this.COMASSIST_BAL_LIST.add(fieldKey + " " + fieldKeyId);
            this.COMASSIST_VOUCHER_LIST.add("entries." + fieldKey + " " + fieldKeyId);
        }
    }

    private String comAssist_Suffix(String comAssist) {
        return comAssist + "id";
    }

    private DataSet queryAssistBalanceSet(ReportQueryParam reportQueryParam, MulOrgQPRpt qParam, int maxRowLimit, Optional<AssistTreeStyleVO> treeStyle) {
        List sortedSubtotals;
        RowMeta balRowMeta;
        DataSet rowIterator;
        AssistSubtotalKey.INIT_COUNT = 0;
        AssistBalanceKey.INIT_COUNT = 0;
        TreeGroupKey.INIT_COUNT = 0;
        AccIDSumUpTree.INIT_COUNT = 0;
        FastKey.INIT_COUNT = 0;
        BalanceUnitVO.INIT_COUNT = 0;
        PerformanceWatch watch = new PerformanceWatch(AssistBalQueryRpt.class, "assist_balance_query", false);
        Boolean isShowByDC = ReportUtils.getShowByActDCSysParam((Long)qParam.getPorg());
        AssistBalanceContext.get().setIsEnableCurrencyGroup(qParam.getCurType());
        watch.start("buildAccTreeModel");
        Tuple<List<QFilter>, IAccountTreeModel> qFiltersAndAccModel = this.parseBalanceFilters();
        watch.stop();
        IAccountTreeModel accTreeModel = (IAccountTreeModel)qFiltersAndAccModel.item2;
        if (accTreeModel.getFilterAccountIds().isEmpty()) {
            return GLUtil.getEmptyDS(((Object)((Object)this)).getClass());
        }
        List assistFilterEntries = FlexUtils.buildAssistFilterInfo((ReportQueryParam)reportQueryParam);
        List orderAssistProps = assistFilterEntries.stream().map(FlexUtils.AssistFilterEntry::getProperty).collect(Collectors.toList());
        LinkedList<Tuple> assistFieldAndProps = new LinkedList<Tuple>();
        for (int i = 0; i < orderAssistProps.size(); ++i) {
            String assistProp = (String)orderAssistProps.get(i);
            String flexFieldName = ASSIST_FIELD_PREFIX + (i == 0 ? "" : Integer.valueOf(i));
            assistFieldAndProps.add(Tuple.create((Object)flexFieldName, (Object)assistProp));
            if (this.flexFieldNames.contains(flexFieldName)) continue;
            this.flexFieldNames.add(flexFieldName);
        }
        boolean isShowOrigin = qParam.isQueryCurrency();
        boolean isZeroAmtNoDisplay = qParam.isNoZeroAmount();
        LOG.info("query params as: isShowOrigin : {}, isZeroAmtNoDisplay: {}, ! isSynCurrency - {}", new Object[]{isShowOrigin, isZeroAmtNoDisplay, !qParam.isSynCurrency()});
        AssistBalanceProcessor processor = new AssistBalanceProcessor(maxRowLimit, qParam, isShowByDC.booleanValue(), isShowOrigin, assistFieldAndProps, accTreeModel);
        processor.setExportAll(this.exportAll);
        processor.setFinalDataSetBatch(this.finalDataSetBatch);
        HashMap<Long, Set<Long>> availableOrgAccMidsMap = new HashMap<Long, Set<Long>>(8);
        for (Object[] orgAccMid : accTreeModel.getAccountTreeData()) {
            long orgId = (Long)orgAccMid[3];
            long accMid = (Long)orgAccMid[1];
            availableOrgAccMidsMap.putIfAbsent(orgId, new HashSet(8));
            ((Set)availableOrgAccMidsMap.get(orgId)).add(accMid);
        }
        watch.start("getBalanceDataset, include sort on dataset");
        if (this.queryBalanceOnly) {
            DataSet balanceDs = this.getBalanceDataset((List)qFiltersAndAccModel.item1, isShowOrigin, isZeroAmtNoDisplay);
            if (DebugTrace.enable()) {
                DataSetHelper.logDataSet((String)"balancedataset_result", (DataSet)balanceDs);
            }
            this.exportBalanceLogDs = this.getBalanceLogDataset(isZeroAmtNoDisplay);
            if (DebugTrace.enable()) {
                DataSetHelper.logDataSet((String)"balancelogdataset_result", (DataSet)this.exportBalanceLogDs);
            }
            if (qParam.isSubstractPL()) {
                this.exportPlVoucherDs = this.getPLVoucherDataset(accTreeModel);
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet((String)"PLVoucherDataset_result", (DataSet)this.exportPlVoucherDs);
                }
            }
            return balanceDs;
        }
        if (this.exportAll) {
            rowIterator = this.balanceList.iterator();
            balRowMeta = this.balanceRowMeta;
        } else {
            DataSet dataSet = this.getBalanceDataset((List)qFiltersAndAccModel.item1, isShowOrigin, isZeroAmtNoDisplay);
            if (DebugTrace.enable()) {
                DataSetHelper.logDataSet((String)"balancedataset_result", (DataSet)dataSet);
            }
            balRowMeta = dataSet.getRowMeta();
            rowIterator = dataSet;
        }
        this.processBalance(qParam, watch, processor, availableOrgAccMidsMap, (Iterator<Row>)rowIterator, balRowMeta);
        watch.start("compute aggregate cache");
        processor.computeAggregateCache();
        watch.stop();
        watch.start("getBalanceLogDataset");
        DataSet balanceLogDs = this.exportAll ? this.exportBalanceLogDs.copy() : this.getBalanceLogDataset(isZeroAmtNoDisplay);
        watch.stop();
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)"balancelogdataset_result", (DataSet)balanceLogDs);
        }
        List balanceLogFieldIndexes = DataSetHelper.getIndexFieldName((RowMeta)balanceLogDs.getRowMeta());
        List<Tuple<String, Integer>> logAssistFields = AssistBalQueryRpt.getAssistFieldIndex(balanceLogFieldIndexes);
        List<Tuple<String, Integer>> logComAssistFields = AssistBalQueryRpt.getComAssistFieldIndex(balanceLogFieldIndexes);
        watch.start("loop balance log dataset");
        int i = 0;
        Long sTick = System.currentTimeMillis();
        while (balanceLogDs.hasNext()) {
            ++i;
            RawBalanceRow rawBalanceLogRow = new RawBalanceRow(balanceLogDs.next(), balanceLogFieldIndexes, logAssistFields, logComAssistFields);
            processor.processBalanceLog(rawBalanceLogRow, isShowOrigin);
        }
        LOG.info("database records statistic: balance log count: {}, cost: {}", (Object)i, (Object)(System.currentTimeMillis() - sTick));
        watch.stop();
        if (qParam.isSubstractPL()) {
            DataSet plVoucherSet;
            if (this.exportAll) {
                plVoucherSet = this.exportPlVoucherDs.copy();
            } else {
                watch.start("getPLVoucherDataset");
                plVoucherSet = this.getPLVoucherDataset(accTreeModel);
                watch.stop();
                if (DebugTrace.enable()) {
                    DataSetHelper.logDataSet((String)"PLVoucherDataset_result", (DataSet)plVoucherSet);
                }
            }
            List plVoucherFieldIndexes = DataSetHelper.getIndexFieldName((RowMeta)plVoucherSet.getRowMeta());
            List<Tuple<String, Integer>> plVoucherAssistFields = AssistBalQueryRpt.getAssistFieldIndex(plVoucherFieldIndexes);
            List<Tuple<String, Integer>> plVoucherComAssistFields = AssistBalQueryRpt.getComAssistFieldIndex(plVoucherFieldIndexes);
            watch.start("loop PLVoucher dataset");
            i = 0;
            sTick = System.currentTimeMillis();
            while (plVoucherSet.hasNext()) {
                RawPLVoucherRow rawPLVoucherRow = new RawPLVoucherRow(plVoucherSet.next(), plVoucherFieldIndexes, plVoucherAssistFields, plVoucherComAssistFields);
                ++i;
                processor.subtractPLVoucher(rawPLVoucherRow);
            }
            LOG.info("database records statistic: PL voucher count: {}, cost: {}", (Object)i, (Object)(System.currentTimeMillis() - sTick));
            watch.stop();
        }
        watch.start("sort and compute");
        Tuple _subtotals = processor.computeSubTotalAndTotal(isZeroAmtNoDisplay);
        List showSubtotals = (List)_subtotals.item1;
        ArrayList totals = (ArrayList)_subtotals.item2;
        if (qParam.isShowLeafAccount()) {
            AccountIndex accountIndex = AssistBalanceContext.get().getAccountIndex();
            showSubtotals = showSubtotals.stream().filter(x -> accountIndex.getAccountVO(x.getSampleBalanceKey().getAccountId()).isLeaf()).collect(Collectors.toList());
        }
        if (showSubtotals.isEmpty()) {
            totals.clear();
        }
        watch.stop();
        watch.start("sort with assist code");
        int estimateRows = 0;
        ArrayList<AssistBalanceSubtotal> limitShowSubtotals = new ArrayList<AssistBalanceSubtotal>(this.realMaxRowLimit);
        for (AssistBalanceSubtotal subtotal : showSubtotals) {
            limitShowSubtotals.add(subtotal);
            if (estimateRows > maxRowLimit) break;
            estimateRows += subtotal.estimateTargetRowCount();
        }
        LOG.info("limitShowSubtotals size: {} / total: {}, estimate rows:{}, maxRowLimit: {}", new Object[]{limitShowSubtotals.size(), showSubtotals.size(), estimateRows, maxRowLimit});
        List<Map<Long, String>> entityNumbers = AssistBalQueryRpt.getAssistNumbers(assistFilterEntries, limitShowSubtotals);
        BalanceSubtotalSorter sorter = new BalanceSubtotalSorter(entityNumbers);
        if (this.exportAll) {
            if (CollectionUtils.isNotEmpty((Collection)totals)) {
                if (Objects.nonNull(this.totalSubtotal)) {
                    this.totalSubtotal.getAmount().merge(((AssistBalanceSubtotal)totals.get(0)).getAmount(), true);
                } else {
                    this.totalSubtotal = (AssistBalanceSubtotal)totals.get(0);
                }
                totals = new ArrayList(1);
            }
            sortedSubtotals = sorter.executeForAssist(limitShowSubtotals, !qParam.isSynCurrency());
        } else {
            sortedSubtotals = sorter.executeForFlat(limitShowSubtotals, !qParam.isSynCurrency());
        }
        watch.stop();
        watch.start("show by assist tree");
        List finalSubtotals = processor.calculateByAssist(sortedSubtotals, totals, treeStyle, sorter);
        LOG.info("finalSubtotals.size(): " + finalSubtotals.size());
        watch.stop();
        watch.start("build output dataset");
        DataSet result = DataSetHelper.buildDataSet((Collection)finalSubtotals, new AssistBalanceDSMeta(assistFilterEntries, qParam, this.COMASSIST_BAL_LIST.size()).build(), (int)maxRowLimit, x -> SubtotalType.Total != x.getType());
        watch.stop();
        LOG.info("AssistKey constructor instance times: " + AssistSubtotalKey.INIT_COUNT);
        LOG.info("AssistBalanceKey constructor instance times: " + AssistBalanceKey.INIT_COUNT);
        LOG.info("TreeGroupKey constructor instance times: " + TreeGroupKey.INIT_COUNT);
        LOG.info("BalanceAggregateKey constructor instance times: " + BalanceAggregateKey.INIT_COUNT);
        LOG.info("AccIDSumUpTree constructor instance times: " + AccIDSumUpTree.INIT_COUNT);
        LOG.info("FastKey constructor instance times: " + FastKey.INIT_COUNT);
        LOG.info("BalanceUnitVO constructor instance times: " + BalanceUnitVO.INIT_COUNT);
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)(AssistBalQueryRpt.class.getSimpleName() + "/assistbalance_result_dataset"), (DataSet)result);
        }
        LOG.info(watch.show());
        return result;
    }

    private void processBalance(MulOrgQPRpt qParam, PerformanceWatch watch, AssistBalanceProcessor processor, Map<Long, Set<Long>> availableOrgAccMidsMap, Iterator<Row> rowIterator, RowMeta balRowMeta) {
        Long cycleTick = 0L;
        int skippedSize = 0;
        Long sTick = 0L;
        int i = 0;
        boolean isShowOrigin = qParam.isQueryCurrency();
        List balanceFieldIndexes = DataSetHelper.getIndexFieldName((RowMeta)balRowMeta);
        List<Tuple<String, Integer>> assistFields = AssistBalQueryRpt.getAssistFieldIndex(balanceFieldIndexes);
        List<Tuple<String, Integer>> comAssistFields = AssistBalQueryRpt.getComAssistFieldIndex(balanceFieldIndexes);
        while (rowIterator.hasNext()) {
            Set<Long> availableMids;
            if (i++ == 0) {
                watch.stop();
                cycleTick = sTick = Long.valueOf(System.currentTimeMillis());
                watch.start("loop balance dataset");
            }
            Row row = rowIterator.next();
            RawBalanceRow rawBalanceRow = new RawBalanceRow(row, balanceFieldIndexes, assistFields, comAssistFields);
            rawBalanceRow.preprocess(qParam.getStartPeriod(), qParam.getEndPeriod(), isShowOrigin, qParam.isShowQty());
            if (DebugTrace.enable()) {
                LOG.info("rawbalancerow: {}", (Object)rawBalanceRow);
            }
            if (null == (availableMids = availableOrgAccMidsMap.get(rawBalanceRow.orgId)) || !availableMids.contains(rawBalanceRow.accMid)) {
                ++skippedSize;
                continue;
            }
            processor.processBalance(rawBalanceRow);
            if (i % 100000 != 0) continue;
            LOG.info("assist_balance_query balance one cycle (100000 rows) count: {}, cost: {}", (Object)i, (Object)(System.currentTimeMillis() - cycleTick));
            cycleTick = System.currentTimeMillis();
        }
        watch.stop();
        LOG.info("database records statistic: balance count {}, skipped rows: {}, cost: {}", new Object[]{i, skippedSize, System.currentTimeMillis() - sTick});
    }

    private static List<Map<Long, String>> getAssistNumbers(Collection<FlexUtils.AssistFilterEntry> assistFilterEntries, List<AssistBalanceSubtotal> showSubtotals) {
        List orderAssistFlexProps = assistFilterEntries.stream().map(FlexUtils.AssistFilterEntry::getFlexProperty).collect(Collectors.toList());
        ArrayList assistIds = new ArrayList(orderAssistFlexProps.size());
        orderAssistFlexProps.stream().forEach(x -> assistIds.add(new HashSet(orderAssistFlexProps.size())));
        showSubtotals.stream().forEach(x -> {
            List assistValues = x.getSampleBalanceKey().getAssistValues();
            for (int i = 0; i < assistValues.size(); ++i) {
                Set idSet = (Set)assistIds.get(i);
                if (!(assistValues.get(i) instanceof Long)) continue;
                idSet.add((Long)assistValues.get(i));
            }
        });
        ArrayList<Map<Long, String>> assistNumbers = new ArrayList<Map<Long, String>>(2);
        for (int j = 0; j < assistIds.size(); ++j) {
            if (AssistValueType.isManualTxt((String)((FlexProperty)orderAssistFlexProps.get(j)).getValueType())) {
                assistNumbers.add(Collections.EMPTY_MAP);
                continue;
            }
            String numberProp = "number";
            if (AssistValueType.isBaseData((String)((FlexProperty)orderAssistFlexProps.get(j)).getValueType())) {
                BasedataEntityType entity = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)((FlexProperty)orderAssistFlexProps.get(j)).getValueSource());
                numberProp = entity.getNumberProperty();
            }
            long tick = System.currentTimeMillis();
            DataSet idNumberDS = QueryServiceHelper.queryDataSet((String)(AssistBalQueryRpt.class.getName() + "/assistquerynumber"), (String)((FlexProperty)orderAssistFlexProps.get(j)).getValueSource(), (String)String.format("id,%s number", numberProp), (QFilter[])new QFilter("id", "in", assistIds.get(j)).toArray(), null);
            LOG.info("query assist number by id cost: {}, total ids: {}", (Object)(System.currentTimeMillis() - tick), (Object)((Set)assistIds.get(j)).size());
            HashMap<Long, String> pkNumbers = new HashMap<Long, String>(16);
            while (idNumberDS.hasNext()) {
                Row row = idNumberDS.next();
                pkNumbers.put(row.getLong("id"), row.getString("number"));
            }
            assistNumbers.add(pkNumbers);
        }
        return assistNumbers;
    }

    private DataSet getBalanceDataset(List<QFilter> balanceQfilters, boolean isShowOrigin, boolean isZeroAmtNoDisplay) {
        HashSet<String> amountFields = new HashSet<String>(8);
        if (isShowOrigin) {
            amountFields.add("beginfor");
            amountFields.add("debitfor");
            amountFields.add("creditfor");
            amountFields.add("yeardebitfor");
            amountFields.add("yearcreditfor");
            amountFields.add("endfor");
        }
        String mulcur = this.qParam.getFilterInfo().getString("mulcur");
        MulCurReportUtil.addBalanceAmountFields(amountFields, (String)mulcur);
        if (this.qParam.isShowQty()) {
            amountFields.add("beginqty");
            amountFields.add("debitqty");
            amountFields.add("creditqty");
            amountFields.add("yeardebitqty");
            amountFields.add("yearcreditqty");
            amountFields.add("endqty");
        }
        ArrayList<String> allSelectFields = new ArrayList<String>(8);
        allSelectFields.addAll(amountFields);
        allSelectFields.addAll(this.COMASSIST_BAL_LIST);
        allSelectFields.add("account,org orgid,period,endperiod");
        if (isZeroAmtNoDisplay) {
            allSelectFields.add("count");
        }
        if (this.qParam.isShowQty()) {
            allSelectFields.add("measureunit");
        }
        if (!this.qParam.isSynCurrency()) {
            allSelectFields.add("currency currencyid");
        }
        Triple balanceOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance((ReportQueryParam)this.reportQueryParam, (String)"gl_balance", (boolean)false);
        MainEntityType mainEntityType = (MainEntityType)balanceOrmInfo.getLeft();
        String orderBy = "";
        if (this.queryBalanceOnly) {
            List flexFields = (List)balanceOrmInfo.getRight();
            ArrayList<String> orderFields = new ArrayList<String>(flexFields.size());
            for (int i = 0; i < flexFields.size(); ++i) {
                String flexOrderField = ((String)flexFields.get(i)).split(" ")[0];
                orderFields.add(flexOrderField + " desc");
            }
            orderBy = String.join((CharSequence)",", orderFields);
        }
        balanceQfilters.addAll((Collection)balanceOrmInfo.getMiddle());
        allSelectFields.addAll((Collection)balanceOrmInfo.getRight());
        if (DebugTrace.enable()) {
            balanceQfilters.stream().forEach(x -> LOG.info("BalancePureQueryService.queryBalanceByAssist, Qfilter: {}", (Object)x.toString()));
        }
        DataSet balanceDs = BalancePureQueryService.queryBalanceByAssist((MainEntityType)mainEntityType, (String)String.join((CharSequence)",", allSelectFields), (QFilter[])balanceQfilters.toArray(new QFilter[0]), (String)orderBy, (int)-1, (String)"gl_balance");
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)(AssistBalQueryRpt.class + "/balance"), (DataSet)balanceDs);
        }
        return balanceDs;
    }

    public DataSet getBalanceLogDataset(boolean isZeroAmtNoDisplay) {
        Triple balanceLogOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance((ReportQueryParam)this.reportQueryParam, (String)"gl_balance_log", (boolean)false);
        MainEntityType balanceLogEntity = (MainEntityType)balanceLogOrmInfo.getLeft();
        List balanceLogFilters = BalancePureQueryService.buildBalanceLogQFilters((Long)this.qParam.getEndPeriod());
        balanceLogFilters.addAll((Collection)balanceLogOrmInfo.getMiddle());
        ArrayList<String> selectLogFields = new ArrayList<String>(8);
        String mulcur = this.qParam.getFilterInfo().getString("mulcur");
        String localAmountField = MulCurReportUtil.getBalanceLogAmountFields((String)mulcur);
        selectLogFields.add("org orgid,account,period,creditqty,debitqty,debitfor,creditfor," + localAmountField);
        if (!this.COMASSIST_BAL_LIST.isEmpty()) {
            selectLogFields.addAll(this.COMASSIST_BAL_LIST);
        }
        if (this.qParam.isShowQty()) {
            selectLogFields.add("measureunit");
        }
        if (!this.qParam.isSynCurrency()) {
            selectLogFields.add("currency currencyid");
        }
        if (isZeroAmtNoDisplay) {
            selectLogFields.add("count");
        }
        selectLogFields.addAll((Collection)balanceLogOrmInfo.getRight());
        DataSet balanceLogDs = BalancePureQueryService.queryBalanceLog((MainEntityType)balanceLogEntity, (String)String.join((CharSequence)",", selectLogFields), (QFilter[])balanceLogFilters.toArray(new QFilter[0]), (String)"", (int)-1);
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)(AssistBalQueryRpt.class + "/balanceLog"), (DataSet)balanceLogDs);
        }
        return balanceLogDs;
    }

    public DataSet getPLVoucherDataset(IAccountTreeModel accTreeModel) {
        long yearMinPeriodId = PeriodUtil.getCurYearMinPeriod((Object)this.qParam.getStartPeriod()).getLong("id");
        Set accMasterIds = accTreeModel.getFilterAccountIds();
        Set availableAccIds = AccountVersionUtil.batchGetAvailableAccIds((Set)accMasterIds, (Set)this.qParam.getFilteredChildOrg(), (long)yearMinPeriodId, (long)this.qParam.getEndPeriod(), (boolean)true);
        if (DebugTrace.enable()) {
            LOG.info("PL voucher query avaliable AccIds: masterIds: {}, orgs: {}, startPeriod: {}, endPeriod:{}, result: {}", new Object[]{accMasterIds, this.qParam.getFilteredChildOrg(), yearMinPeriodId, this.qParam.getEndPeriod(), availableAccIds});
        }
        Long[] childOrgs = this.qParam.getFilteredChildOrg().toArray(new Long[0]);
        List plFilters = BalancePureQueryService.buildPLVoucherQfilters((Long[])childOrgs, (long)this.qParam.getBookType(), (long)yearMinPeriodId, (long)this.qParam.getEndPeriod(), this.parseCurrencyIds(), this.parseMeasureUnits(), (Set)availableAccIds, (QueryParamRpt)this.qParam);
        Triple voucherOrmInfo = FlexUtils.buildDynamicORMAssistOnVoucher((ReportQueryParam)this.reportQueryParam, (boolean)false);
        MainEntityType plVoucherEntity = (MainEntityType)voucherOrmInfo.getLeft();
        plFilters.addAll((Collection)voucherOrmInfo.getMiddle());
        List<String> plVoucherGroups = AssistBalQueryRpt.buildGroupList((List)voucherOrmInfo.getRight(), this.qParam.getComAssistList(), this.qParam.isShowQty(), false);
        ArrayList<String> voucherSelFields = new ArrayList<String>(8);
        voucherSelFields.add(VOUCHER_SEL_FIELDS);
        String mulcur = this.qParam.getFilterInfo().getString("mulcur");
        String localAmountField = MulCurReportUtil.getVoucherLocalAmountFields((String)mulcur);
        voucherSelFields.add(localAmountField);
        voucherSelFields.addAll((Collection)voucherOrmInfo.getRight());
        voucherSelFields.addAll(this.COMASSIST_VOUCHER_LIST);
        DataSet plVoucherSet = BalancePureQueryService.queryVoucher((MainEntityType)plVoucherEntity, (String)String.join((CharSequence)",", voucherSelFields), (QFilter[])plFilters.toArray(new QFilter[0]), null, (int)-1);
        ArrayList<String> selectedFields = new ArrayList<String>(Arrays.asList(PL_VOUCHER_AMOUNT_FIELDS));
        selectedFields.addAll(plVoucherGroups);
        if (!selectedFields.contains("period")) {
            selectedFields.add("period");
        }
        selectedFields.add("quantity");
        selectedFields.remove("vdebitqty");
        selectedFields.remove("vcreditqty");
        selectedFields.remove("vcount");
        selectedFields.add("case when vdebitlocal!=0 then quantity else 0 end as vdebitqty");
        selectedFields.add("case when vcreditlocal!=0 then quantity else 0 end as vcreditqty");
        plVoucherSet = plVoucherSet.addField("0", "vbeginfor").addField("0", "vbeginlocal").addField("0", "vbeginqty").select(selectedFields.toArray(new String[0])).removeFields(new String[]{"quantity"});
        plVoucherSet = plVoucherSet.addField("1", "vcount");
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)"plvoucherDebug", (DataSet)plVoucherSet);
        }
        List initBalanceFilters = BalancePureQueryService.buildInitBalanceQfilters((Long[])childOrgs, (long)this.qParam.getBookType(), this.parseCurrencyIds(), this.parseMeasureUnits(), (Set)availableAccIds, (QueryParamRpt)this.qParam);
        Triple initBalanceOrmInfo = FlexUtils.buildDynamicORMAssistOnBalance((ReportQueryParam)this.reportQueryParam, (String)"gl_initbalance", (boolean)false);
        initBalanceFilters.addAll((Collection)initBalanceOrmInfo.getMiddle());
        List<String> initBalanceGroups = AssistBalQueryRpt.buildGroupList((List)initBalanceOrmInfo.getRight(), this.qParam.getComAssistList(), this.qParam.isShowQty(), false);
        List<String> initBalanceSelectors = AssistBalQueryRpt.buildGroupList((List)initBalanceOrmInfo.getRight(), this.COMASSIST_BAL_LIST, this.qParam.isShowQty(), true);
        DataSet initBalance = BalancePureQueryService.queryInitBalance((MainEntityType)((MainEntityType)initBalanceOrmInfo.getLeft()), Arrays.asList(childOrgs), (MulOrgQPRpt)this.qParam, (long)yearMinPeriodId, (List)initBalanceFilters, initBalanceGroups, initBalanceSelectors);
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)"initBalancelog", (DataSet)initBalance);
        }
        if (!(initBalance = initBalance.addBalanceField("vdebitfor-vcreditfor", "vbeginfor").addBalanceField("vdebitlocal-vcreditlocal", "vbeginlocal").addBalanceField("vdebitqty-vcreditqty", "vbeginqty")).isEmpty()) {
            List voucherList = DataSetHelper.getDataSetCols((DataSet)plVoucherSet);
            initBalance = initBalance.select(voucherList.toArray(new String[0]));
            plVoucherSet = plVoucherSet.union(initBalance);
        }
        plVoucherSet = AssistBalQueryRpt.actIdToMasterId(plVoucherSet);
        if (!plVoucherGroups.contains("period")) {
            plVoucherGroups.add("period");
        }
        GroupbyDataSet gVoucherSet = plVoucherSet.groupBy(plVoucherGroups.toArray(new String[0]));
        for (String amount : PL_VOUCHER_AMOUNT_FIELDS) {
            gVoucherSet = gVoucherSet.sum(amount);
        }
        plVoucherSet = gVoucherSet.finish();
        plVoucherSet = plVoucherSet.orderBy(plVoucherGroups.toArray(new String[0]));
        String[] vamountList = PL_VOUCHER_AMOUNT_FIELDS;
        ArrayList<String> yearInitList = new ArrayList<String>(vamountList.length);
        for (String field : vamountList) {
            yearInitList.add(field + " year" + field);
        }
        yearInitList.addAll(plVoucherGroups);
        yearInitList.addAll(Arrays.asList(vamountList));
        plVoucherSet = plVoucherSet.select(yearInitList.toArray(new String[0]));
        List<String> refinedGroupFields = plVoucherGroups.stream().filter(x -> !x.equals("period") && !x.equals("periodyear")).collect(Collectors.toList());
        GroupbyDataSet byVoucherSet = plVoucherSet.groupBy(refinedGroupFields.toArray(new String[0]));
        long beginPeriodId = this.qParam.getStartPeriod();
        int endPeriodYear = QueryServiceHelper.queryOne((String)"bd_period", (String)"periodyear", (QFilter[])new QFilter("id", "=", (Object)this.qParam.getEndPeriod()).toArray()).getInt("periodyear");
        for (String gfield : vamountList) {
            if (gfield.startsWith("vbegin")) {
                String suffix = gfield.replace("vbegin", "");
                byVoucherSet.sum("case when period< " + beginPeriodId + " then vdebit" + suffix + "-vcredit" + suffix + " else 0 end", gfield);
                continue;
            }
            byVoucherSet.sum("case when period>=" + beginPeriodId + " then " + gfield + " else 0 end", gfield);
            byVoucherSet.sum("case when periodyear=" + endPeriodYear + " then year" + gfield + " else 0 end", "year" + gfield);
        }
        plVoucherSet = byVoucherSet.finish();
        if (DebugTrace.enable()) {
            DataSetHelper.logDataSet((String)(AssistBalQueryRpt.class + "/plVoucherSet"), (DataSet)plVoucherSet);
        }
        return plVoucherSet;
    }

    private static DataSet actIdToMasterId(DataSet voucherSet) {
        List voucherList = DataSetHelper.getDataSetCols((DataSet)voucherSet);
        if (voucherList.contains("account")) {
            HashSet<Long> acctIds = new HashSet<Long>(100);
            for (Row row : voucherSet.copy()) {
                long acctId = row.getLong("account");
                acctIds.add(acctId);
            }
            DataSet acctSet = QueryServiceHelper.queryDataSet((String)(AssistBalQueryRpt.class.getName() + ".account"), (String)"bd_accountview", (String)"id, masterid account", (QFilter[])new QFilter("id", "in", acctIds).toArray(), null);
            voucherList.remove("account");
            voucherSet = voucherSet.join(acctSet, JoinType.INNER).on("account", "id").select(voucherList.toArray(new String[0]), new String[]{"account"}).finish();
        }
        return voucherSet;
    }

    private static List<String> buildGroupList(List<String> assistFieldAndAlias, List<String> comAssistListAlias, boolean isShowQty, boolean isForQueryDB) {
        ArrayList<String> groupList = new ArrayList<String>(8);
        groupList.add("org");
        groupList.add("booktype");
        groupList.add("account");
        groupList.add("currency");
        if (isForQueryDB) {
            groupList.addAll(assistFieldAndAlias);
        } else {
            groupList.addAll(assistFieldAndAlias.stream().map(x -> x.split(" ")[1]).collect(Collectors.toList()));
        }
        groupList.addAll(comAssistListAlias);
        if (isShowQty) {
            groupList.add("measureunit");
        }
        groupList.add("periodyear");
        return groupList;
    }

    private Tuple<List<QFilter>, IAccountTreeModel> parseBalanceFilters() {
        Set accIds = ReportUtils.getAccIdSetByFlexFields((MulOrgQPRpt)this.qParam, (ReportQueryParam)this.reportQueryParam);
        Set<Long> measureunitList = this.parseMeasureUnits();
        Set<Long> currencyIds = this.parseCurrencyIds();
        Set childOrg = this.qParam.getFilteredChildOrg();
        if (childOrg.isEmpty()) {
            LOG.info("failed to get child orgs, fall back to use the selected org: {}", (Object)this.qParam.getOrgs());
            childOrg.addAll(this.qParam.getOrgs());
        }
        return BalancePureQueryService.buildBalanceQFilters((Long[])childOrg.toArray(new Long[0]), (long)this.qParam.getBookType(), (long)this.qParam.getAccountTable(), (Long)this.qParam.getStartPeriod(), (Long)this.qParam.getEndPeriod(), (boolean)false, currencyIds, measureunitList, (Set)accIds, (boolean)this.qParam.isShowLeafAccount(), (QueryParamRpt)this.qParam);
    }

    private Set<Long> parseMeasureUnits() {
        List value;
        HashSet<Long> measureunitList = new HashSet<Long>(8);
        FilterItemInfo unitInfo = this.reportQueryParam.getFilter().getFilterItem("measureunits");
        if (unitInfo != null && (value = (List)unitInfo.getValue()) != null) {
            for (DynamicObject dyn : value) {
                measureunitList.add(dyn.getLong("id"));
            }
        }
        return measureunitList;
    }

    private Set<Long> parseCurrencyIds() {
        HashSet<Long> currencyIds = new HashSet<Long>(1);
        if (!this.qParam.isSynCurrency() && !this.qParam.isAllCurrency()) {
            currencyIds.add(this.qParam.getCurrency());
        }
        return currencyIds;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        List<kd.fi.gl.common.Tuple<String, String>> assTypenameList = ReportHelper.buildAssTypenameList(this.reportQueryParam);
        String treeAssistAlias = (String)ThreadCache.get((Object)"_tree_assist_field");
        List allColumns = new AssistBalHelper(this.qParam).getReportColumn(columns, assTypenameList, treeAssistAlias);
        return allColumns;
    }

    private static List<Tuple<String, Integer>> getAssistFieldIndex(List<String> balanceFieldIndexes) {
        ArrayList<Tuple<String, Integer>> assistFields = new ArrayList<Tuple<String, Integer>>(2);
        for (int index = 0; index < balanceFieldIndexes.size(); ++index) {
            if (!balanceFieldIndexes.get(index).startsWith(ASSIST_FIELD_PREFIX)) continue;
            assistFields.add((Tuple<String, Integer>)Tuple.create((Object)balanceFieldIndexes.get(index), (Object)index));
        }
        return assistFields;
    }

    private static List<Tuple<String, Integer>> getComAssistFieldIndex(List<String> balanceFieldIndexes) {
        ArrayList<Tuple<String, Integer>> assistFields = new ArrayList<Tuple<String, Integer>>(2);
        for (int index = 0; index < balanceFieldIndexes.size(); ++index) {
            if (!balanceFieldIndexes.get(index).startsWith("comassist")) continue;
            assistFields.add((Tuple<String, Integer>)Tuple.create((Object)balanceFieldIndexes.get(index), (Object)index));
        }
        return assistFields;
    }
}

