/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.report.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.report.QueryParamRpt;
import kd.fi.gl.report.service.IReportAccountService;
import kd.fi.gl.report.service.ReportAccountServiceImpl;

public class RptAccountServiceHelper {
    private static final IReportAccountService svc = new ReportAccountServiceImpl();
    public static final QFilter LEAF_FILTER = new QFilter("isleaf", "=", (Object)true);

    public static DataSet queryAccountData(List<Long> org, long acctTable, long endPeriod, String selectFields, Set<String> acctLongNumRange, QFilter extFilter) {
        return svc.queryAccountData(org, acctTable, endPeriod, selectFields, acctLongNumRange, extFilter);
    }

    public static DataSet queryAccountDataByEOrg(QueryParamRpt param, String selectFields, QFilter extFilter) {
        HashSet<String> longNums = new HashSet<String>(16);
        DynamicObjectCollection acctDyos = param.getFilterInfo().getDynamicObjectCollection("account");
        if (CollectionUtils.isNotEmpty((Collection)acctDyos)) {
            acctDyos.forEach(acctDyo -> longNums.add(acctDyo.getString("longnumber")));
        }
        return svc.queryAccountData(param.getAllEntityOrgs(), param.getAccountTable(), param.getEndPeriod(), selectFields, longNums, extFilter);
    }

    public static DataSet queryAccountByEOrgAndAssistItems(QueryParamRpt param, String selectFields, QFilter extFilter) {
        List<String> flexFields = param.getFilterInfo().getFlexFilterItems().stream().map(FilterItemInfo::getPropName).collect(Collectors.toList());
        HashSet<String> longNums = new HashSet<String>(16);
        DynamicObjectCollection acctDyos = param.getFilterInfo().getDynamicObjectCollection("account");
        if (CollectionUtils.isNotEmpty((Collection)acctDyos)) {
            acctDyos.forEach(acctDyo -> longNums.add(acctDyo.getString("longnumber")));
        }
        return svc.queryAccountByAssistItems(param.getAllEntityOrgs(), param.getAccountTable(), param.getEndPeriod(), selectFields, longNums, flexFields, extFilter);
    }

    public static Set<Long> queryAccountIds(List<Long> org, long acctTable, long endPeriod, Set<String> acctLongNumRange, QFilter extFilter) {
        DataSet acctDs = RptAccountServiceHelper.queryAccountData(org, acctTable, endPeriod, "id", acctLongNumRange, extFilter);
        return ReportAccountServiceImpl.getLongs(acctDs, "id");
    }

    public static Set<Long> queryAccountIdsByEOrg(QueryParamRpt param, QFilter extFilter) {
        DataSet acctDs = RptAccountServiceHelper.queryAccountDataByEOrg(param, "id", extFilter);
        return ReportAccountServiceImpl.getLongs(acctDs, "id");
    }

    public static Set<Long> queryAccountMIdsByEOrg(QueryParamRpt param, QFilter extFilter) {
        DataSet acctDs = RptAccountServiceHelper.queryAccountDataByEOrg(param, "masterid", extFilter);
        return ReportAccountServiceImpl.getLongs(acctDs, "masterid");
    }

    public static Set<Long> queryAcctMIdsByEOrgAndAssistItems(QueryParamRpt param, QFilter extFilter) {
        return ReportAccountServiceImpl.getLongs(RptAccountServiceHelper.queryAccountByEOrgAndAssistItems(param, "masterid", extFilter), "masterid");
    }

    public static Set<Long> queryAcctIdsByEOrgAndAssistItems(QueryParamRpt param, QFilter extFilter) {
        return ReportAccountServiceImpl.getLongs(RptAccountServiceHelper.queryAccountByEOrgAndAssistItems(param, "id", extFilter), "id");
    }
}

