/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hlcm.formplugin.template;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.econtract.HRWordUtils;
import kd.hr.hbp.common.model.econtract.CheckVariableResp;
import kd.hr.hbp.common.model.econtract.KeyWordMappingEntryParam;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hlcm.business.common.HLCMCommonRepository;
import kd.hr.hlcm.business.domian.service.hrcs.IHRCSKeywordMappingService;
import kd.hr.hlcm.business.service.ContractTplService;
import kd.hr.hlcm.business.utils.SignListPermissionUtils;
import kd.hr.hlcm.business.utils.TemplateUtils;
import kd.hr.hlcm.formplugin.template.TemplatePluginHelper;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class TemplateFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(TemplateFormPlugin.class);
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String DOWNLOAD_TEMP = "downloadtemp";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String HRCS_KEYWORDMAPPING = "hrcs_keywordmapping";
    private static final String CHANGE = "change";
    private static final String VIEW_DETAIL = "viewdetail";
    private static final String EDIT_SAVE = "editsave";
    public static final String TEMP_UPLOAD = "tempUpload";
    public static final String TEMP_REMOVE = "tempRemove";
    private static final String CALL_BACK_ERR_WORD = "callback_errorWords";
    private String CACHE_VAR_MAP_ENTRY_ENTITY_JSON = "varmap_entryentity_json";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        attachmentPanel.addUploadListener((UploadListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("deflang", (Object)Lang.get().name());
        this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
        this.getView().setVisible(Boolean.valueOf(TemplatePluginHelper.existAttachment((IFormView)this.getView())), new String[]{"varmap_entryentity"});
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        long pkId = this.getModel().getDataEntity().getLong("id");
        if (ContractTplService.checkTplIsPreData((long)pkId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete"});
            this.getView().setVisible(Boolean.FALSE, new String[]{CHANGE});
        }
        IFormView view = this.getView();
        List<Map<String, Object>> attachmentData = this.getAttachmentData();
        IDataModel model = this.getModel();
        if (view.getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW) || this.isTempChangePage()) {
            long newVid = DBServiceHelper.genLongIds((String)"hlcm_contracttemplatehis", (int)1)[0];
            model.setValue("futurevid", (Object)newVid);
        }
        TemplatePluginHelper.setEcontemplateView((IFormView)view, (IDataModel)model);
        model.setDataChanged(false);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            TemplatePluginHelper.renderEntryEntity((IFormView)this.getView(), (boolean)false);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName();
        if ("signway".equals(propertyName)) {
            TemplatePluginHelper.setEcontemplateView((IFormView)this.getView(), (IDataModel)this.getModel());
        }
        if (Lists.newArrayList((Object[])new String[]{"varflag", "varvalue", "mulang"}).contains(propertyName)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("varmap_entryentity");
            List keyWordMappingEntryParams = TemplateUtils.entryEntity2KeyWordMappingEntryParams((DynamicObjectCollection)entryEntity);
            this.getView().getPageCache().put(this.CACHE_VAR_MAP_ENTRY_ENTITY_JSON, JSON.toJSONString((Object)keyWordMappingEntryParams));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey) || EDIT_SAVE.equals(operateKey)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            Optional<String> checkOptional = this.checkAttachmentName();
            if (checkOptional.isPresent()) {
                args.setCancel(true);
                this.getView().showTipNotification(checkOptional.get());
                return;
            }
            if (status.equals((Object)OperationStatus.ADDNEW)) {
                this.beforeSaveValidate(args);
            } else if (this.isTempChangePage()) {
                this.beforeEditSaveValidate(args);
            } else {
                LOGGER.warn("OperationStatus|{}", (Object)status);
            }
        }
    }

    private Optional<String> checkAttachmentName() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENTPANELAP);
        List attachmentData = attachmentPanel.getAttachmentData();
        if (CollectionUtils.isEmpty((Collection)attachmentData)) {
            return Optional.empty();
        }
        Object fileNameObj = ((Map)attachmentData.get(0)).get("name");
        if (null == fileNameObj) {
            return Optional.empty();
        }
        String fileName = fileNameObj.toString();
        if (fileName.contains("&") || fileName.contains("#")) {
            return Optional.of(ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u4e0d\u5141\u8bb8\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c#\u3001&\u201d\u3002", (String)"TemplateFormPlugin_11", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String operateKey;
            switch (operateKey = args.getOperateKey()) {
                case "change": {
                    this.clickChange();
                    break;
                }
                case "viewdetail": {
                    this.showForm();
                    break;
                }
                case "submit": {
                    TemplatePluginHelper.renderEntryEntity((IFormView)this.getView(), (boolean)false);
                    break;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (DOWNLOAD_TEMP.equals(itemKey)) {
            this.downloadTemplate();
        }
    }

    private void clickChange() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId("hlcm_contracttemplatech");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId(pkValue);
        this.getView().showForm((FormShowParameter)formShowParameter);
        String pkId = this.getModel().getDataEntity().getString("id");
        HRBaseServiceHelper attachmentService = new HRBaseServiceHelper("bos_attachment");
        QFilter idFilter = new QFilter("finterid", "=", (Object)pkId);
        QFilter typeFilter1 = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplate");
        QFilter typeFilter2 = new QFilter("fbilltype", "=", (Object)"hlcm_contracttemplatech");
        attachmentService.deleteByFilter(new QFilter[]{idFilter, typeFilter2});
        DynamicObject[] queryAtt = attachmentService.loadDynamicObjectArray(new QFilter[]{idFilter, typeFilter1});
        ArrayList<DynamicObject> attachments = new ArrayList<DynamicObject>();
        for (DynamicObject att : queryAtt) {
            DynamicObject dynamicObject = attachmentService.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)att, (DynamicObject)dynamicObject);
            dynamicObject.set("fbilltype", (Object)"hlcm_contracttemplatech");
            String number = String.join((CharSequence)"-", "rc-upload", "templatech", dynamicObject.getString("finterid"));
            dynamicObject.set("FNUMBER", (Object)number);
            attachments.add(dynamicObject);
        }
        if (attachments.size() > 0) {
            attachmentService.save(attachments.toArray(new DynamicObject[0]));
        }
    }

    private void showForm() {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex(KEY_ENTRYENTITY);
        DynamicObject entryRowEntity = model.getEntryRowEntity(KEY_ENTRYENTITY, index);
        Object id = entryRowEntity.get("hisid");
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("hlcm_contracttemplatehis");
        formShowParameter.setStatus(OperationStatus.VIEW);
        String caption = ResManager.loadKDString((String)"\u5408\u540c\u6a21\u677f\u8be6\u60c5", (String)"TemplateFormPlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
        formShowParameter.setCaption(caption);
        formShowParameter.setPkId(id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void afterRemove(UploadEvent evt) {
        PageCache cache = (PageCache)this.getView().getService(IPageCache.class);
        cache.put(TEMP_REMOVE, "1");
        this.getModel().deleteEntryData("varmap_entryentity");
        this.getView().setVisible(Boolean.FALSE, new String[]{"varmap_entryentity"});
    }

    public void upload(UploadEvent evt) {
        PageCache cache = (PageCache)this.getView().getService(IPageCache.class);
        cache.put(TEMP_UPLOAD, "1");
        Map map = (Map)evt.getUrls()[0];
        String name = (String)map.get("name");
        if (name.contains("&") || name.contains("#")) {
            String msg = ResManager.loadKDString((String)"\u9644\u4ef6\u540d\u4e0d\u5141\u8bb8\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c#\u3001&\u201d\u3002", (String)"TemplateFormPlugin_11", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            evt.setCancel(true);
            evt.setCancelMsg(msg);
        }
    }

    public void afterUpload(UploadEvent evt) {
        Map map = (Map)evt.getUrls()[0];
        String url = (String)map.get("url");
        CheckVariableResp checkVariableResp = IHRCSKeywordMappingService.getInstance().getVariable(url);
        if (!checkVariableResp.getCheckResult()) {
            List errorWords = checkVariableResp.getErrorWords();
            evt.setCancel(true);
            String preMsgModel = ResManager.loadKDString((String)"\u53d8\u91cf\u503c\u7684\u683c\u5f0f\u5982\uff1a${\u5458\u5de5\u59d3\u540d}\u3002", (String)"TemplateFormPlugin_12", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            String preMsgTip = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u4ee5\u4e0b\u5b57\u6bb5\u6a21\u677f\u53d8\u91cf\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"TemplateFormPlugin_13", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
            String errorWordList = String.join((CharSequence)"\r\n", errorWords);
            String msg = preMsgModel + "\r\n\r\n" + preMsgTip + "\r\n" + errorWordList;
            this.getView().showMessage(msg, MessageTypes.Default, new ConfirmCallBackListener(CALL_BACK_ERR_WORD, (IFormPlugin)this));
            return;
        }
        List successWords = checkVariableResp.getSuccessWords();
        String cacheValue = this.getView().getPageCache().get(this.CACHE_VAR_MAP_ENTRY_ENTITY_JSON);
        ArrayList keyWordMappingParams = Lists.newArrayListWithCapacity((int)successWords.size());
        if (HRStringUtils.isNotEmpty((String)cacheValue)) {
            List cacheKeyWordMappingParams = JSON.parseArray((String)cacheValue, KeyWordMappingEntryParam.class);
            cacheKeyWordMappingParams.removeIf(keyWordMappingEntryParam -> !successWords.contains(keyWordMappingEntryParam.getWordField()));
            keyWordMappingParams.addAll(cacheKeyWordMappingParams);
            List cacheWordFields = cacheKeyWordMappingParams.stream().map(KeyWordMappingEntryParam::getWordField).collect(Collectors.toList());
            successWords.removeIf(cacheWordFields::contains);
        }
        List matchKeyWordMappingParams = IHRCSKeywordMappingService.getInstance().matchingVariable(successWords);
        keyWordMappingParams.addAll(matchKeyWordMappingParams);
        TemplatePluginHelper.createEntryEntity((IFormView)this.getView(), (List)keyWordMappingParams);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)CALL_BACK_ERR_WORD) && messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
            List attachmentData = attachmentPanel.getAttachmentData();
            attachmentData.forEach(arg_0 -> ((AttachmentPanel)attachmentPanel).remove(arg_0));
        }
    }

    private boolean isTempChangePage() {
        return HRStringUtils.equals((String)this.getView().getEntityId(), (String)"hlcm_contracttemplatech");
    }

    private void beforeSaveValidate(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        String signWays = this.getModel().getDataEntity().getString("signway");
        if (HRStringUtils.isNotEmpty((String)signWays) && signWays.contains("1")) {
            if (this.AttachmentNullValidate()) {
                LOGGER.info("==beforeSaveValidate Attachment is null==");
                this.showAttNullNotify(view);
                args.setCancel(true);
                return;
            }
            Long futureVid = this.getModel().getDataEntity().getLong("futurevid");
            if (TemplatePluginHelper.hasUnConfigKeyMap((Long)futureVid)) {
                LOGGER.info("==beforeSaveValidate getKeyMap is null==");
                return;
            }
            if (this.keyWordValidate()) {
                LOGGER.info("==beforeSaveValidate keyWordValidate warn ==");
                args.setCancel(true);
            }
        } else if (HRStringUtils.isNotEmpty((String)signWays) && signWays.contains("2") && !this.AttachmentNullValidate() && TemplatePluginHelper.checkPcontemplate((IFormView)view)) {
            LOGGER.info("==Psignway beforeSaveValidate checkPcontemplate warn==");
            args.setCancel(true);
        }
    }

    private void beforeEditSaveValidate(BeforeDoOperationEventArgs args) {
        boolean oldKeyMap;
        boolean dataChanged;
        IFormView view = this.getView();
        if (!SignListPermissionUtils.checkChangePermission((String)"hlcm_contracttemplate")) {
            LOGGER.info("==checkChangePermission warn==");
            args.setCancel(true);
            view.showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u5408\u540c\u6a21\u677f\u201d\u53d8\u66f4\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"TemplateFormPlugin_8", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
            return;
        }
        PageCache cache = (PageCache)this.getView().getService(IPageCache.class);
        String upload = cache.get(TEMP_UPLOAD);
        String remove = cache.get(TEMP_REMOVE);
        boolean tempUploadBoolean = HRStringUtils.equals((String)"1", (String)upload);
        boolean tempRemoveBoolean = HRStringUtils.equals((String)"1", (String)remove);
        boolean isRename = TemplatePluginHelper.checkAttachmentIsRename(this.getAttachmentData(), (DynamicObject)this.getModel().getDataEntity());
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String signWays = dataEntity.getString("signway");
        Long futureVid = dataEntity.getLong("futurevid");
        boolean keyMapBoolean = TemplatePluginHelper.hasUnConfigKeyMap((Long)futureVid);
        DynamicObject oldDy = HLCMCommonRepository.queryDynamicObjectByPk((String)"hlcm_contracttemplate", (String)"name,contracttype,region,signway,econtemplate", (Object)dataEntity.getPkValue());
        boolean isCopy = false;
        if (this.DataChangedValidate(dataEntity, oldDy) && (dataChanged = !TemplatePluginHelper.hasSetTemplate((Long)futureVid) ? !tempUploadBoolean && !tempRemoveBoolean && !isRename && !this.isEntryDataChange() : false)) {
            LOGGER.info("==not dataChanged==");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u5408\u540c\u6a21\u677f\u4fe1\u606f\u65e0\u53d8\u5316\u3002", (String)"TemplateFormChangePlugin_0", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.isNotEmpty((String)signWays) && signWays.contains("1")) {
            if (this.AttachmentNullValidate()) {
                LOGGER.info("==Esignway attachment is null==");
                this.showAttNullNotify(view);
                args.setCancel(true);
                return;
            }
            if (this.keyWordValidate()) {
                LOGGER.info("==Esignway keyWordValidate warn==");
                args.setCancel(true);
                return;
            }
            if (tempUploadBoolean) {
                if (keyMapBoolean) {
                    LOGGER.info("==Esignway tempUploadBoolean warn==");
                    this.showSetTempNotify(view);
                    args.setCancel(true);
                    return;
                }
            } else if (TemplatePluginHelper.hasSetTemplate((Long)futureVid)) {
                if (keyMapBoolean) {
                    LOGGER.info("==Esignway oldKeyMap warn==");
                    this.showSetTempNotify(view);
                    args.setCancel(true);
                    return;
                }
            } else {
                oldKeyMap = TemplatePluginHelper.hasUnConfigKeyMap((Long)dataEntity.getLong("vid"));
                if (oldKeyMap) {
                    LOGGER.info("==Esignway oldKeyMap warn==");
                    this.showSetTempNotify(view);
                    args.setCancel(true);
                    return;
                }
                isCopy = true;
            }
        } else if (HRStringUtils.isNotEmpty((String)signWays) && signWays.contains("2") && !this.AttachmentNullValidate()) {
            if (!tempUploadBoolean) {
                oldKeyMap = TemplatePluginHelper.hasUnConfigKeyMap((Long)dataEntity.getLong("vid"));
                if (!oldKeyMap) {
                    isCopy = true;
                } else if (TemplatePluginHelper.checkPcontemplate((IFormView)view)) {
                    LOGGER.info("==Psignway checkPcontemplate warn==");
                    args.setCancel(true);
                    return;
                }
            } else if (keyMapBoolean && TemplatePluginHelper.checkPcontemplate((IFormView)view)) {
                LOGGER.info("==Psignway attachment is not null checkPcontemplate warn==");
                args.setCancel(true);
                return;
            }
        }
        this.getModel().setValue("copy", (Object)isCopy);
    }

    private boolean AttachmentNullValidate() {
        List<Map<String, Object>> attachmentData = this.getAttachmentData();
        return attachmentData.size() < 1;
    }

    private List<Map<String, Object>> getAttachmentData() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENTPANELAP);
        return attachmentPanel.getAttachmentData();
    }

    private void showSetTempNotify(IFormView view) {
        view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u6a21\u677f\u5c06\u5e94\u7528\u4e8e\u7535\u5b50\u7b7e\u7f72\uff0c\u8bf7\u5148\u914d\u7f6e\u6a21\u677f\u5b57\u6bb5\u3002", (String)"TemplateFormPlugin_5", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
    }

    private void showAttNullNotify(IFormView view) {
        view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5408\u540c\u6a21\u677f\u5c06\u5e94\u7528\u4e8e\u7535\u5b50\u7b7e\u7f72\uff0c\u8bf7\u5148\u4e0a\u4f20\u5408\u540c\u6a21\u677f\u9644\u4ef6\u3002", (String)"TemplateFormPlugin_7", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
    }

    private boolean DataChangedValidate(DynamicObject dataEntity, DynamicObject oldDy) {
        boolean nameBoolean = HRStringUtils.equals((String)dataEntity.getString("name"), (String)oldDy.getString("name"));
        DynamicObject contractTypeDy = dataEntity.getDynamicObject("contracttype");
        DynamicObject oldContractTypeDy = oldDy.getDynamicObject("contracttype");
        boolean contractTypeBoolean = contractTypeDy != null && oldContractTypeDy != null && contractTypeDy.getLong("id") == oldContractTypeDy.getLong("id");
        DynamicObject region = dataEntity.getDynamicObject("region");
        DynamicObject oldRegion = oldDy.getDynamicObject("region");
        boolean regionBoolean = region != null && oldRegion != null && region.getLong("id") == oldRegion.getLong("id");
        String signWay = dataEntity.getString("signway");
        boolean signWayBoolean = HRStringUtils.equals((String)signWay, (String)oldDy.getString("signway"));
        boolean econTemplateBoolean = true;
        if (signWayBoolean && HRStringUtils.isNotEmpty((String)signWay) && signWay.contains("1")) {
            DynamicObject econtemplate = dataEntity.getDynamicObject("econtemplate");
            DynamicObject oldEcontemplate = oldDy.getDynamicObject("econtemplate");
            econTemplateBoolean = econtemplate != null && oldEcontemplate != null && econtemplate.getLong("id") == oldEcontemplate.getLong("id");
        }
        return nameBoolean && contractTypeBoolean && regionBoolean && signWayBoolean && econTemplateBoolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadTemplate() {
        IPageCache pageCache = this.getView().getPageCache();
        String tempurl = pageCache.get("tempurl");
        if (HRStringUtils.isNotEmpty((String)tempurl)) {
            this.getView().download(tempurl);
        } else {
            InputStream resourceAsStream = null;
            try {
                resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/standardtemplate.docx");
                String fileName = ResManager.loadKDString((String)"\u7535\u5b50\u52b3\u52a8\u5408\u540c\u6a21\u677f\u8303\u672c.docx", (String)"TemplateFormPlugin_6", (String)"hr-hlcm-formplugin", (Object[])new Object[0]);
                if (resourceAsStream != null) {
                    TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    String url = tempFileCache.saveAsUrl(fileName, resourceAsStream, 10000);
                    pageCache.put("tempurl", url);
                    this.getView().download(url);
                }
            }
            finally {
                try {
                    if (resourceAsStream != null) {
                        resourceAsStream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private boolean keyWordValidate() {
        XWPFDocument document;
        List<Map<String, Object>> attachmentData = this.getAttachmentData();
        if (attachmentData.isEmpty()) {
            return true;
        }
        String url = (String)attachmentData.get(0).get("url");
        boolean isTempFIle = url.contains("tempfile/download.do");
        if (!isTempFIle) {
            List list = AttachmentServiceHelper.getAttachments((String)"hlcm_contracttemplate", (Object)this.getModel().getDataEntity().getPkValue(), (String)ATTACHMENTPANELAP);
            url = (String)((Map)list.get(0)).get("url");
        }
        try {
            document = HRWordUtils.getXWPFDocumentFromUrl((String)url, (boolean)isTempFIle);
        }
        catch (IOException evt) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e3\u6790\u9644\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8005\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TemplateFormPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            LOGGER.error((Throwable)evt);
            return true;
        }
        StringBuffer strFormWord = HRWordUtils.getStringFormWord((XWPFDocument)document);
        if (strFormWord == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89e3\u6790\u9644\u4ef6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8005\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TemplateFormPlugin_2", (String)"hr-hlcm-formplugin", (Object[])new Object[0]));
            return true;
        }
        String wordData = strFormWord.toString();
        DynamicObject econtemplate = this.getModel().getDataEntity().getDynamicObject("econtemplate");
        if (econtemplate != null) {
            String signType = econtemplate.getString("signtype");
            String keyWordDouble = econtemplate.getString("keyworddouble");
            String keyword = econtemplate.getString("keyword");
            switch (signType) {
                case "1": {
                    if (wordData.contains(keyword)) break;
                    this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9644\u4ef6\u5408\u540c\u6a21\u677f\u4e2d\u672a\u5305\u542b\u7535\u5b50\u7b7e\u7f72\u914d\u7f6e\u4e2d\u7684\u7b7e\u7f72\u5173\u952e\u5b57\uff1a%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"TemplateFormPlugin_9", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), keyword));
                    return true;
                }
                case "2": {
                    if (wordData.contains(keyWordDouble)) break;
                    this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9644\u4ef6\u5408\u540c\u6a21\u677f\u4e2d\u672a\u5305\u542b\u7535\u5b50\u7b7e\u7f72\u914d\u7f6e\u4e2d\u7684\u7b7e\u7f72\u5173\u952e\u5b57\uff1a%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"TemplateFormPlugin_9", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), keyWordDouble));
                    return true;
                }
                case "3": {
                    if (wordData.contains(keyword) && wordData.contains(keyWordDouble)) break;
                    this.getView().showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9644\u4ef6\u5408\u540c\u6a21\u677f\u4e2d\u672a\u5305\u542b\u7535\u5b50\u7b7e\u7f72\u914d\u7f6e\u4e2d\u7684\u7b7e\u7f72\u5173\u952e\u5b57\uff1a%1$s\u3001%2$s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"TemplateFormPlugin_10", (String)"hr-hlcm-formplugin", (Object[])new Object[0]), keyword, keyWordDouble));
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isEntryDataChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long id = dataEntity.getLong("id");
        long vid = dataEntity.getLong("vid");
        List initEntryParam = IHRCSKeywordMappingService.getInstance().getKeyWordMapping(Long.valueOf(id), Long.valueOf(vid));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("varmap_entryentity");
        List keyWordMappingEntryParams = TemplateUtils.entryEntity2KeyWordMappingEntryParams((DynamicObjectCollection)entryEntity);
        return !HRStringUtils.equals((String)JSON.toJSONString((Object)initEntryParam), (String)JSON.toJSONString((Object)keyWordMappingEntryParams));
    }
}

