/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hom.business.domain.service.impl.onbrd;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hom.business.application.hrpi.IHomToHrpiAppService;
import kd.hr.hom.business.application.onbrd.IOnbrdCommonAppService;
import kd.hr.hom.business.domain.repository.common.HomConfigRepository;
import kd.hr.hom.business.domain.service.common.IBaseDataDomainService;
import kd.hr.hom.business.domain.service.hbpm.IHbpmDataDomainService;
import kd.hr.hom.business.domain.service.hcf.IHcfDataDomainService;
import kd.hr.hom.business.domain.service.onbrd.IOnbrdInfoInitService;
import kd.hr.hom.common.constant.BaseDataIdConstants;
import kd.hr.hom.common.constant.HcfCanCreConstants;
import kd.hr.hom.common.entity.HomCommonWrapper;
import kd.hr.hom.common.entity.IDCardInfo;
import kd.hr.hom.common.enums.BillStatusEnum;
import kd.hr.hom.common.enums.InitTypeEnum;
import kd.hr.hom.common.enums.OnbrdDataSourceEnum;
import kd.hr.hom.common.enums.OnbrdStatusEnum;
import kd.hr.hom.common.enums.PositionTypeEnum;
import kd.hr.hom.common.enums.ProcessStatusEnum;
import kd.hr.hom.common.enums.SynchStatusEnum;
import kd.hr.hom.common.enums.ViewTypeEnum;
import kd.hr.hom.common.util.HOMObjectUtils;
import kd.hr.hom.common.util.HbpmResultUtils;
import kd.hr.hom.common.util.IDCardUtils;
import kd.sdk.hr.hom.business.onbrd.IOnbrdService;

public class OnbrdInfoInitService
implements IOnbrdInfoInitService {
    private static final Log LOGGER = LogFactory.getLog(OnbrdInfoInitService.class);

    public void initFieldValue(DynamicObject[] onbrdBillInfos, String initType) {
        List<HomCommonWrapper> onbrdBillWrapperList = Stream.of(onbrdBillInfos).map(HomCommonWrapper::new).collect(Collectors.toList());
        this.initFieldValue(onbrdBillWrapperList, initType);
    }

    public void initFieldValue(List<HomCommonWrapper> onbrdBillWrapperList, String initType) {
        LOGGER.info("Start initializing OnbrdBillInfos, initType:" + initType);
        this.autoFormatFieldValue(onbrdBillWrapperList);
        this.initBaseInfo(onbrdBillWrapperList, initType);
        this.initBillInfo(onbrdBillWrapperList, initType);
        this.initWorkInfo(onbrdBillWrapperList, initType);
        this.initRelationshipManagement(onbrdBillWrapperList, initType);
        this.initJobInfos(onbrdBillWrapperList, initType);
        this.extInitInfo(onbrdBillWrapperList, initType);
        LOGGER.info("End initializing OnbrdBillInfos, length:" + onbrdBillWrapperList.size());
    }

    private void extInitInfo(List<HomCommonWrapper> onbrdBillWrapperList, String initType) {
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IOnbrdService.class, (String)"kd.sdk.hr.hom.business.onbrd.IOnbrdService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hom_onbrdbilltpl");
            onbrdBillWrapperList.forEach(onbrdBillWrapper -> {
                DynamicObject bizData = onbrdBillWrapper.getBizData();
                DynamicObject temp = hrBaseServiceHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)bizData, (DynamicObject)temp);
                String employeeNo = hrPlugin.setEmployeeNo(temp, initType);
                if (HRStringUtils.isNotEmpty((String)employeeNo)) {
                    bizData.set("employeeno", (Object)employeeNo);
                }
            });
            return null;
        });
    }

    private void autoFormatFieldValue(List<HomCommonWrapper> onbrdBillWrapperList) {
        for (HomCommonWrapper onbrdBillWrapper : onbrdBillWrapperList) {
            String employeeno;
            DynamicObject onbrdBill = onbrdBillWrapper.getBizData();
            ILocaleString name = onbrdBill.getLocaleString("name");
            if (name != null && !name.isEmpty() && name.getLocaleValue() != null) {
                name.setLocaleValue(name.getLocaleValue().trim());
                onbrdBill.set("name", (Object)name);
            }
            if ((employeeno = onbrdBill.getString("employeeno")) == null) continue;
            onbrdBill.set("employeeno", (Object)employeeno.trim());
        }
    }

    private void initBaseInfo(List<HomCommonWrapper> onbrdBillWrapperList, String initType) {
        long userId = RequestContext.get().getCurrUserId();
        Date sysDate = new Date();
        for (HomCommonWrapper onbrdBillWrapper : onbrdBillWrapperList) {
            DynamicObject onbrdBill = onbrdBillWrapper.getBizData();
            if (HRStringUtils.equals((String)InitTypeEnum.ONBRD_NEW_IMPORT.getValue(), (String)initType)) {
                onbrdBill.set("billstatus", (Object)BillStatusEnum.SAVE.getCode());
                onbrdBill.set("creator", (Object)userId);
                onbrdBill.set("createtime", (Object)sysDate);
            }
            onbrdBill.set("modifier", (Object)userId);
            onbrdBill.set("modifytime", (Object)sysDate);
            onbrdBill.set("candidatenumber", (Object)onbrdBill.getString("candidate.number"));
            if (HRStringUtils.equals((String)InitTypeEnum.ONBRD_NEW_ADDONE.getValue(), (String)initType) || HRStringUtils.equals((String)InitTypeEnum.ONBRD_NEW_IMPORT.getValue(), (String)initType)) {
                onbrdBill.set("datasource", (Object)OnbrdDataSourceEnum.HOM.getValue());
            } else if (HRStringUtils.equals((String)InitTypeEnum.ONBRD_NEW_INTEGERATE_TSC.getValue(), (String)initType)) {
                onbrdBill.set("datasource", (Object)OnbrdDataSourceEnum.TSC.getValue());
            } else if (HRStringUtils.equals((String)InitTypeEnum.ONBRD_NEW_INTEGERATE_THIRDSYS.getValue(), (String)initType)) {
                onbrdBill.set("datasource", (Object)OnbrdDataSourceEnum.THIRD_SYS.getValue());
            }
            if (HRStringUtils.isEmpty((String)onbrdBill.getString("leadertype"))) {
                onbrdBill.set("leadertype", (Object)"0");
            }
            if (!Boolean.FALSE.equals(onbrdBill.getBoolean("iscadre"))) continue;
            onbrdBill.set("appremoverel", null);
            onbrdBill.set("cadretype", null);
            onbrdBill.set("appdispatchnum", (Object)"");
        }
    }

    public void initBillInfo(List<HomCommonWrapper> onbrdBillWrapperList, String initType) {
        boolean isNewBackground;
        boolean bl = isNewBackground = HRStringUtils.equals((String)InitTypeEnum.ONBRD_NEW_IMPORT.getValue(), (String)initType) || HRStringUtils.equals((String)InitTypeEnum.ONBRD_NEW_INTEGERATE_TSC.getValue(), (String)initType) || HRStringUtils.equals((String)InitTypeEnum.ONBRD_NEW_INTEGERATE_THIRDSYS.getValue(), (String)initType);
        if (!isNewBackground) {
            return;
        }
        this.setValueByJudgeFormerEmployee(onbrdBillWrapperList);
        Map<String, List<HomCommonWrapper>> wrapperGroupMap = onbrdBillWrapperList.stream().collect(Collectors.groupingBy(onbrdBillWrapper -> onbrdBillWrapper.getBizData().getString("viewtype")));
        for (Map.Entry<String, List<HomCommonWrapper>> entry : wrapperGroupMap.entrySet()) {
            List<HomCommonWrapper> wrapperGroupList = entry.getValue();
            DynamicObject[] onbrdBills = (DynamicObject[])wrapperGroupList.stream().map(HomCommonWrapper::getBizData).toArray(DynamicObject[]::new);
            String[] billNos = this.getBatchNumberByCodeRule("hom_onbrdbillbase", "", wrapperGroupList.size(), onbrdBills);
            int index = billNos.length;
            if (index < wrapperGroupList.size()) {
                LOGGER.info("Fail to getBatchNumber for onbrdbill, onbrdBillInfos:{}, billNos:{}", (Object)onbrdBillWrapperList.size(), (Object)index);
            }
            for (HomCommonWrapper onbrdBillWrapper2 : wrapperGroupList) {
                DynamicObject onbrdBill = onbrdBillWrapper2.getBizData();
                if (--index < 0) continue;
                onbrdBill.set("billno", (Object)billNos[index]);
            }
        }
        LOGGER.info("End getBatchNumberByCodeRule");
        for (HomCommonWrapper onbrdBillWrapper3 : onbrdBillWrapperList) {
            DynamicObject onbrdBill = onbrdBillWrapper3.getBizData();
            onbrdBill.set("enrollstatus", (Object)OnbrdStatusEnum.WAIT_START.getValue());
            onbrdBill.set("synchstatus", (Object)SynchStatusEnum.SYNCH_WAIT.getValue());
            if (HRStringUtils.isBlank((CharSequence)onbrdBill.getString("processstatus"))) {
                onbrdBill.set("processstatus", (Object)ProcessStatusEnum.WAIT_PROCESS.getValue());
            }
            onbrdBill.set("isinvalid", (Object)"0");
        }
    }

    private void initWorkInfo(List<HomCommonWrapper> onbrdBillWrapperList, String initType) {
        DynamicObject[] onbrdBillInfos = (DynamicObject[])onbrdBillWrapperList.stream().map(HomCommonWrapper::getBizData).toArray(DynamicObject[]::new);
        Map<Long, DynamicObject> orgCompanyDyMap = this.getOrgAcompanyDyMap(onbrdBillInfos);
        for (HomCommonWrapper onbrdBillWrapper : onbrdBillWrapperList) {
            DynamicObject onbrdBill = onbrdBillWrapper.getBizData();
            Long onbrdBillId = onbrdBill.getLong("id");
            onbrdBill.set("acompany", (Object)orgCompanyDyMap.get(onbrdBillId));
        }
    }

    private void initRelationshipManagement(List<HomCommonWrapper> onbrdBillWrapperList, String initType) {
        DynamicObject[] onbrdBillInfos = (DynamicObject[])onbrdBillWrapperList.stream().map(HomCommonWrapper::getBizData).toArray(DynamicObject[]::new);
        long orgId = RequestContext.get().getOrgId();
        Map<Long, Long> hrBuOrgMap = this.getHRBuOrgMap(onbrdBillInfos);
        for (HomCommonWrapper onbrdBillWrapper : onbrdBillWrapperList) {
            DynamicObject onbrdBill = onbrdBillWrapper.getBizData();
            if (HRObjectUtils.isEmpty((Object)onbrdBill.get("org"))) {
                onbrdBill.set("org", (Object)orgId);
            }
            if (HRObjectUtils.isEmpty((Object)onbrdBill.get("ajobscmorg"))) {
                onbrdBill.set("ajobscmorg", (Object)orgId);
            }
            Long onbrdBillId = onbrdBill.getLong("id");
            onbrdBill.set("hrbu", (Object)hrBuOrgMap.get(onbrdBillId));
            onbrdBill.set("affiliateadminorg", onbrdBill.get("aadminorg"));
        }
    }

    public void initJobInfos(List<HomCommonWrapper> onbrdBillWrapperList, String initType) {
        ArrayList<Long> jobIds = new ArrayList<Long>(onbrdBillWrapperList.size());
        ArrayList<Long> positionIds = new ArrayList<Long>(onbrdBillWrapperList.size());
        ArrayList<Long> stdPositionIds = new ArrayList<Long>(onbrdBillWrapperList.size());
        for (HomCommonWrapper commonWrapper : onbrdBillWrapperList) {
            long jobId;
            DynamicObject onbrdBill = commonWrapper.getBizData();
            String apositiontype = onbrdBill.getString("apositiontype");
            if (PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue().equals(apositiontype)) {
                stdPositionIds.add(onbrdBill.getLong("stdposition.id"));
            }
            if (PositionTypeEnum.POSITIONTYPE_POSITION.getValue().equals(apositiontype)) {
                positionIds.add(onbrdBill.getLong("aposition.id"));
            }
            if (!HOMObjectUtils.isEmptyWithDynamicObjectField((Object)(jobId = HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)commonWrapper.getBizData(), (String)"ajob")))) {
                jobIds.add(jobId);
            }
            if (!Arrays.asList(InitTypeEnum.ONBRD_NEW_IMPORT.getValue(), InitTypeEnum.ONBRD_UPDATE_IMPORT.getValue()).contains(initType)) continue;
            onbrdBill.set("ajobscm", null);
            onbrdBill.set("ajobscmorg", null);
            onbrdBill.set("jobfamily", null);
            onbrdBill.set("jobclass", null);
            onbrdBill.set("jobseq", null);
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajoblevel", null);
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajobgrade", null);
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"joblevelscm", null);
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobgradescm", null);
        }
        Map jobRelationInfoMap = new HashMap(jobIds.size());
        Map positionHrBuScmJob = new HashMap(positionIds.size());
        Map stdPositionHrBuScmJob = new HashMap(stdPositionIds.size());
        Map positionLeveGradeMap = new HashMap(positionIds.size());
        Map stdPositionLeveGradeMap = new HashMap(stdPositionIds.size());
        if (!HRCollUtil.isEmpty(jobIds)) {
            jobRelationInfoMap = IBaseDataDomainService.getInstance().getJobLevelGradeRangeInfoByJobIds(jobIds);
        }
        if (!HRCollUtil.isEmpty(positionIds)) {
            positionHrBuScmJob = IHbpmDataDomainService.getInstance().getBatchHrBuScmJob(positionIds);
            positionLeveGradeMap = IHbpmDataDomainService.getInstance().queryJobLevelAndJobGradeByPositionIds(positionIds);
        }
        if (!HRCollUtil.isEmpty(stdPositionIds)) {
            stdPositionHrBuScmJob = IHbpmDataDomainService.getInstance().getBatchStandardBuScmJob(stdPositionIds);
            stdPositionLeveGradeMap = IHbpmDataDomainService.getInstance().queryJobLevelAndJobGradeByStdPositionIds(stdPositionIds);
        }
        for (HomCommonWrapper onbrdBillWrapper : onbrdBillWrapperList) {
            Map jobRelationInfo;
            DynamicObject onbrdBill = onbrdBillWrapper.getBizData();
            String apositiontype = onbrdBill.getString("apositiontype");
            long jobId = HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdBill, (String)"ajob");
            long positionId = onbrdBill.getLong("aposition.id");
            long stdPositionId = onbrdBill.getLong("stdposition.id");
            if (!HRMapUtils.isEmpty((Map)((Map)jobRelationInfoMap.get(jobId)))) {
                Map jobRelationInfo2 = (Map)jobRelationInfoMap.get(jobId);
                HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobseq", jobRelationInfo2.get("jobseq"));
                HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobfamily", jobRelationInfo2.get("jobfamily"));
                HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobclass", jobRelationInfo2.get("jobclass"));
                if (PositionTypeEnum.POSITIONTYPE_JOB.getValue().equals(apositiontype)) {
                    this.setJobInfoByJobInfoMap(onbrdBill, jobRelationInfo2);
                }
            }
            if (PositionTypeEnum.POSITIONTYPE_POSITION.getValue().equals(apositiontype) && !HRMapUtils.isEmpty((Map)((Map)positionHrBuScmJob.get(positionId)))) {
                this.setJobInfoByPositionInfoMap(onbrdBill, (Map)positionHrBuScmJob.get(positionId));
                this.setJobGradeAndJobLevel(onbrdBill, (Map)positionLeveGradeMap.get(positionId));
            }
            if (PositionTypeEnum.POSITIONTYPE_STDPOSITION.getValue().equals(apositiontype) && !HRMapUtils.isEmpty((Map)((Map)stdPositionHrBuScmJob.get(stdPositionId)))) {
                this.setJobInfoByStdPositionInfoMap(onbrdBill, (Map)stdPositionHrBuScmJob.get(stdPositionId));
                this.setJobGradeAndJobLevel(onbrdBill, (Map)stdPositionLeveGradeMap.get(stdPositionId));
            }
            long joblevelscmId = HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdBill, (String)"joblevelscm_id");
            long jobgradescmId = HOMObjectUtils.getDynamicObjectFieldId((DynamicObject)onbrdBill, (String)"jobgradescm_id");
            if (joblevelscmId != 0L || jobgradescmId != 0L || HOMObjectUtils.isEmptyWithDynamicObjectField((Object)jobId) || HRMapUtils.isEmpty((Map)(jobRelationInfo = (Map)jobRelationInfoMap.get(jobId)))) continue;
            joblevelscmId = HOMObjectUtils.getLongValOfCustomParam(jobRelationInfo.get("joblevelScmid"));
            jobgradescmId = HOMObjectUtils.getLongValOfCustomParam(jobRelationInfo.get("jobgradeScmid"));
            onbrdBill.set("joblevelscm_id", (Object)joblevelscmId);
            onbrdBill.set("jobgradescm_id", (Object)jobgradescmId);
            List jobLevelInfos = (List)jobRelationInfo.get("joblevelRanges");
            List jobGradeInfos = (List)jobRelationInfo.get("jobgradeRanges");
            if (jobLevelInfos != null && jobLevelInfos.size() == 1) {
                HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajoblevel", jobLevelInfos.get(0));
            }
            if (jobGradeInfos == null || jobGradeInfos.size() != 1) continue;
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajobgrade", jobGradeInfos.get(0));
        }
    }

    public Map<Long, Long> getHRBuOrgMap(DynamicObject[] onbrdBillInfos) {
        HashMap hrBuOrgMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.length);
        HashMap onbrdAdminOrgMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.length);
        HashSet adminorgIdSet = Sets.newHashSetWithExpectedSize((int)onbrdBillInfos.length);
        for (DynamicObject onbrdBillInfo : onbrdBillInfos) {
            Long onbrdBillId = onbrdBillInfo.getLong("id");
            DynamicObject aadminOrg = onbrdBillInfo.getDynamicObject("aadminorg");
            if (HRObjectUtils.isEmpty((Object)aadminOrg)) continue;
            Long orgID = aadminOrg.getLong("id");
            adminorgIdSet.add(orgID);
            onbrdAdminOrgMap.put(onbrdBillId, orgID);
        }
        DynamicObject bussinessType = IBaseDataDomainService.getInstance().getBaseDataInfoById("hrcs_bussinesstype", BaseDataIdConstants.HRCS_BUSSINESSTYPE_1010, "bussinesstype");
        ImmutableSet bussinessTypeIds = ImmutableSet.of((Object)(bussinessType == null ? 0L : bussinessType.getLong("bussinesstype.id")));
        Map<Long, Set> orgId2BusinessType = adminorgIdSet.stream().collect(Collectors.toMap(adminorgId -> adminorgId, arg_0 -> OnbrdInfoInitService.lambda$getHRBuOrgMap$7((Set)bussinessTypeIds, arg_0), (oldValue, newValue) -> newValue));
        List queryHrBuResultList = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, 1010L});
        LOGGER.info(JSONObject.toJSONString((Object)queryHrBuResultList));
        Map<Long, Long> adminHRBuOrgMap = queryHrBuResultList.stream().collect(Collectors.toMap(hrBuInfoMap -> (Long)hrBuInfoMap.get("adminOrgId"), hrBuInfoMap -> (Long)hrBuInfoMap.get("hrBuId"), (oldValue, newValue) -> newValue));
        for (Map.Entry entry : onbrdAdminOrgMap.entrySet()) {
            Long orgID = (Long)entry.getValue();
            Long hrBuOrg = adminHRBuOrgMap.getOrDefault(orgID, null);
            hrBuOrgMap.put(entry.getKey(), hrBuOrg);
        }
        return hrBuOrgMap;
    }

    public Map<String, Long> getHRBuOrgMapNew(List<DynamicObject> onbrdBillInfos) {
        HashMap hrBuOrgMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.size());
        HashMap onbrdAdminOrgMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.size());
        HashSet adminorgIdSet = Sets.newHashSetWithExpectedSize((int)onbrdBillInfos.size());
        for (DynamicObject onbrdBillInfo : onbrdBillInfos) {
            DynamicObject aadminOrg = onbrdBillInfo.getDynamicObject("aadminorg");
            if (HRObjectUtils.isEmpty((Object)aadminOrg)) continue;
            Long orgID = aadminOrg.getLong("id");
            adminorgIdSet.add(orgID);
            onbrdAdminOrgMap.put(aadminOrg.getString("number"), orgID);
        }
        DynamicObject bussinessType = IBaseDataDomainService.getInstance().getBaseDataInfoById("hrcs_bussinesstype", BaseDataIdConstants.HRCS_BUSSINESSTYPE_1010, "bussinesstype");
        ImmutableSet bussinessTypeIds = ImmutableSet.of((Object)(bussinessType == null ? 0L : bussinessType.getLong("bussinesstype.id")));
        Map<Long, Set> orgId2BusinessType = adminorgIdSet.stream().collect(Collectors.toMap(adminorgId -> adminorgId, arg_0 -> OnbrdInfoInitService.lambda$getHRBuOrgMapNew$13((Set)bussinessTypeIds, arg_0), (oldValue, newValue) -> newValue));
        List queryHrBuResultList = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{orgId2BusinessType, 1010L});
        LOGGER.info(JSONObject.toJSONString((Object)queryHrBuResultList));
        Map<Long, Long> adminHRBuOrgMap = queryHrBuResultList.stream().collect(Collectors.toMap(hrBuInfoMap -> (Long)hrBuInfoMap.get("adminOrgId"), hrBuInfoMap -> (Long)hrBuInfoMap.get("hrBuId"), (oldValue, newValue) -> newValue));
        for (Map.Entry entry : onbrdAdminOrgMap.entrySet()) {
            Long orgID = (Long)entry.getValue();
            Long hrBuOrg = adminHRBuOrgMap.getOrDefault(orgID, null);
            hrBuOrgMap.put(entry.getKey(), hrBuOrg);
        }
        return hrBuOrgMap;
    }

    public Map<Long, Long> getOrgAcompanyMap(DynamicObject[] onbrdBillInfos) {
        HashMap adminorgIdMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.length);
        List adminOrgIds = Stream.of(onbrdBillInfos).map(onbrdBill -> onbrdBill.getLong("aadminorg.id")).collect(Collectors.toList());
        Map orgCompanyMap = IBaseDataDomainService.getInstance().getCompanyMapWithAdminorgByRPC(adminOrgIds);
        for (DynamicObject onbrdBill2 : onbrdBillInfos) {
            Long aadminOrgId = onbrdBill2.getLong("aadminorg.id");
            adminorgIdMap.put(onbrdBill2.getLong("id"), orgCompanyMap.get(aadminOrgId));
        }
        return adminorgIdMap;
    }

    private Map<Long, DynamicObject> getOrgAcompanyDyMap(DynamicObject[] onbrdBillInfos) {
        HashMap adminorgIdMap = Maps.newHashMapWithExpectedSize((int)onbrdBillInfos.length);
        List adminOrgIds = Stream.of(onbrdBillInfos).map(onbrdBill -> onbrdBill.getLong("aadminorg.id")).collect(Collectors.toList());
        Map orgCompanyMap = IBaseDataDomainService.getInstance().getCompanyMapWithAdminorgByRPC(adminOrgIds);
        Set companyIds = orgCompanyMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        Map companyDyMaps = new HashMap(companyIds.size());
        if (HRCollUtil.isNotEmpty(companyIds)) {
            companyDyMaps = IBaseDataDomainService.getInstance().getBaseDataInfoByIds("haos_adminorghr", companyIds, "");
        }
        for (DynamicObject onbrdBill2 : onbrdBillInfos) {
            Long aadminOrgId = onbrdBill2.getLong("aadminorg.id");
            Long companyId = (Long)orgCompanyMap.get(aadminOrgId);
            DynamicObject companyDy = (DynamicObject)companyDyMaps.get(companyId);
            adminorgIdMap.put(onbrdBill2.getLong("id"), companyDy);
        }
        return adminorgIdMap;
    }

    private void setValueByJudgeFormerEmployee(List<HomCommonWrapper> onbrdBillWrapperList) {
        IHomToHrpiAppService homToHrpiAppService = IHomToHrpiAppService.getInstance();
        LOGGER.info("start isFormerEmployeeByCreNumberAndCreType");
        Map<Long, List<HomCommonWrapper>> wrapperGroupMap = onbrdBillWrapperList.stream().collect(Collectors.groupingBy(onbrdBillWrapper -> onbrdBillWrapper.getBizData().getLong("certificatetype.id")));
        for (Map.Entry<Long, List<HomCommonWrapper>> entry : wrapperGroupMap.entrySet()) {
            List<HomCommonWrapper> billWrapperList = entry.getValue();
            List certificateNumbers = billWrapperList.stream().filter(onbrdBillWrapper -> HRStringUtils.isNotEmpty((String)onbrdBillWrapper.getBizData().getString("certificatenumber"))).map(onbrdBillWrapper -> onbrdBillWrapper.getBizData().getString("certificatenumber")).collect(Collectors.toList());
            Map resultMap = homToHrpiAppService.isFormerEmployeeByCreNumberAndCreType(certificateNumbers, entry.getKey());
            for (HomCommonWrapper onbrdBillWrapper2 : billWrapperList) {
                DynamicObject onbrdBill = onbrdBillWrapper2.getBizData();
                Map formerEmployeeMap = (Map)resultMap.get(onbrdBill.getString("certificatenumber"));
                if (CollectionUtils.isEmpty((Map)formerEmployeeMap)) continue;
                String personfield = formerEmployeeMap.get("personfield") == null ? "" : formerEmployeeMap.get("personfield").toString();
                String candidateNumStr = IOnbrdCommonAppService.getInstance().validPhoneAndNum(onbrdBill, "personfield", personfield);
                if (HRStringUtils.isNotEmpty((String)candidateNumStr)) {
                    String msg = String.format(ResManager.loadKDString((String)"\u201c\u59d3\u540d\u201d\u4e0e\u5df2\u6709\u5019\u9009\u4eba\uff08\u5019\u9009\u4eba\u7f16\u53f7\u4e3a%s\uff09\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OnbrdInfoEdit_18", (String)"hr-hom-business", (Object[])new Object[0]), candidateNumStr);
                    onbrdBillWrapper2.addErrMsg(msg);
                }
                Boolean enableSihc = this.enableSihc();
                if (onbrdBill.containsProperty("appdispatchnum")) {
                    DynamicObject[] appointRemovErels;
                    String appdispatchnum = onbrdBill.getString("appdispatchnum");
                    if (enableSihc.booleanValue() && HRStringUtils.isNotEmpty((String)appdispatchnum) && HRStringUtils.isNotEmpty((String)personfield) && (appointRemovErels = IHomToHrpiAppService.getInstance().queryAppointRemovErels(Long.valueOf(Long.parseLong(personfield)), appdispatchnum)).length == 1) {
                        onbrdBill.set("appremoverel", (Object)appointRemovErels[0].getLong("id"));
                    }
                }
                onbrdBill.set("viewtype", (Object)ViewTypeEnum.AGAIN.getCode());
                onbrdBill.set("personfield", formerEmployeeMap.get("personfield"));
                LOGGER.info("setValueByJudgeFormerEmployee number {},name {}, formerEmployeeMap name {}", new Object[]{onbrdBill.getString("certificatenumber"), onbrdBill.getLocaleString("name").getLocaleValue(), formerEmployeeMap.get("name")});
                if (HRStringUtils.equals((String)onbrdBill.getLocaleString("name").getLocaleValue(), (String)formerEmployeeMap.get("name").toString())) continue;
                onbrdBillWrapper2.addErrMsg(ResManager.loadKDString((String)"\u901a\u8fc7\u8be5\u4eba\u5458\u7684\u8bc1\u4ef6\u53f7\uff0c\u7cfb\u7edf\u8bc6\u522b\u4e3a\u524d\u5458\u5de5\uff0c\u4f46\u59d3\u540d\u4e0e\u7cfb\u7edf\u9002\u914d\u7ed3\u679c\u4e0d\u5339\u914d\uff0c\u8bf7\u6838\u5bf9\u5176\u4fe1\u606f\uff1b", (String)"OnbrdInfoInitService_6", (String)"hr-hom-business", (Object[])new Object[0]));
            }
        }
        LOGGER.info("start getPersonInfoFuzzyDedupByPhoneAndName");
        for (HomCommonWrapper onbrdBillWrapper3 : onbrdBillWrapperList) {
            DynamicObject onbrdBill = onbrdBillWrapper3.getBizData();
            if (!HRStringUtils.isEmpty((String)onbrdBill.getString("viewtype"))) continue;
            onbrdBill.set("viewtype", (Object)ViewTypeEnum.ROUTINE.getCode());
        }
        LOGGER.info("end getPersonInfoFuzzyDedupByPhoneAndName");
    }

    public Boolean enableSihc() {
        Boolean enableSihc = (Boolean)HRMServiceHelper.invokeHRMPService((String)"soecs", (String)"SystemConfigMService", (String)"enableSihc", (Object[])new Object[0]);
        return enableSihc;
    }

    public String[] getBatchNumberByCodeRule(String entityNumber, String orgID, int count, DynamicObject[] dataInfos) {
        if (dataInfos == null || dataInfos.length == 0 || dataInfos[0] == null) {
            dataInfos = new DynamicObject[]{new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber))};
        }
        DynamicObject dataInfo = dataInfos[0];
        return CodeRuleServiceHelper.getBatchNumber((String)entityNumber, (DynamicObject)dataInfo, (String)orgID, (int)count);
    }

    public String getNumberByCodeRule(String entityNumber, String orgID, DynamicObject dataInfo) {
        Object[] numbers = this.getBatchNumberByCodeRule(entityNumber, orgID, 1, new DynamicObject[]{dataInfo});
        if (HRArrayUtils.isEmpty((Object[])numbers)) {
            LOGGER.info("getNumberByCodeRule is empty!entityNumber:{},orgID:{}", (Object)entityNumber, (Object)orgID);
            return "";
        }
        return numbers[0];
    }

    public String[] getNumberByCodeRules(DynamicObject dynamicObject, String orgID, int count) {
        return CodeRuleServiceHelper.getBatchNumber((String)dynamicObject.getDataEntityType().getName(), (DynamicObject)dynamicObject, (String)orgID, (int)count);
    }

    public Long getChgactionIdByOnbrdType(DynamicObject onbrdType) {
        String relationInfo = HomConfigRepository.queryValueByBusinessKey((String)"onbrdtype_relation_chgactionconfigid");
        if (HRObjectUtils.isEmpty((Object)onbrdType) || HRStringUtils.isEmpty((String)relationInfo)) {
            return 0L;
        }
        Map relationInfoMap = (Map)JSONObject.parseObject((String)relationInfo, Map.class);
        String onBrdTypeId = onbrdType.getString("id");
        String chgActionId = (String)relationInfoMap.get(onBrdTypeId);
        IBaseDataDomainService baseDataDomainService = IBaseDataDomainService.getInstance();
        DynamicObject chgaction = null;
        if (HRStringUtils.isNotEmpty((String)chgActionId)) {
            chgaction = baseDataDomainService.getHpfsChgActionById(Long.valueOf(Long.parseLong(chgActionId)), "number");
        }
        return chgaction == null ? 0L : chgaction.getLong("id");
    }

    private Map<String, DynamicObject> getBaseDataInfoMapWithOnbrdType(String entityNum, String relationKey) {
        HashMap relationResultMap = Maps.newHashMapWithExpectedSize((int)4);
        String relationInfo = HomConfigRepository.queryValueByBusinessKey((String)relationKey);
        Map relationInfoMap = (Map)JSONObject.parseObject((String)relationInfo, Map.class);
        ArrayList numberSet = new ArrayList(relationInfoMap.values());
        IBaseDataDomainService baseDataDomainService = IBaseDataDomainService.getInstance();
        Map queryResult = baseDataDomainService.getBaseDataInfoByNumber(entityNum, numberSet, "number");
        for (Map.Entry entry : relationInfoMap.entrySet()) {
            String onbrdTypeNumber = (String)entry.getKey();
            String number = (String)entry.getValue();
            relationResultMap.put(onbrdTypeNumber, queryResult.get(number));
        }
        return relationResultMap;
    }

    private void setDynFieldValueWithDefault(DynamicObject onbrdBill, String fieldName, DynamicObject value) {
        DynamicObject fieldValue = onbrdBill.getDynamicObject(fieldName);
        if (!HRObjectUtils.isEmpty((Object)fieldValue)) {
            return;
        }
        onbrdBill.set(fieldName, (Object)(HRObjectUtils.isEmpty((Object)value) ? Long.valueOf(0L) : value));
    }

    public void syncInfoToHcf(List<HomCommonWrapper> rowDataWrapperList) {
        if (CollectionUtils.isEmpty(rowDataWrapperList)) {
            return;
        }
        IHcfDataDomainService hcfDataDomainService = IHcfDataDomainService.getInstance();
        List candidateIds = rowDataWrapperList.stream().map(rowDataWrapper -> rowDataWrapper.getBizData().getLong("candidate.id")).collect(Collectors.toList());
        HashMap entityFieldsMap = Maps.newHashMapWithExpectedSize((int)2);
        entityFieldsMap.put("hcf_canbaseinfo", "");
        entityFieldsMap.put("hcf_cancre", "");
        Map candidateInfoMaps = hcfDataDomainService.queryOrLoadHcfAttachedData(candidateIds, (Map)entityFieldsMap);
        Map<Long, DynamicObject> canBaseInfoMap = this.getCanBaseInfoMap(candidateInfoMaps);
        Map<Long, DynamicObject> canMainCreInfoMap = this.getCanMainCreInfoMap(candidateInfoMaps);
        DynamicObject nationalityChina = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_nationality", BaseDataIdConstants.HBSS_NATIONALITY_1010, "number");
        DynamicObject sexMan = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_sex", BaseDataIdConstants.HBSS_SEX_1010, "number");
        DynamicObject sexWoman = IBaseDataDomainService.getInstance().getBaseDataInfoById("hbss_sex", BaseDataIdConstants.HBSS_SEX_1020, "number");
        DynamicObjectCollection baseInfoCollection = new DynamicObjectCollection();
        DynamicObjectCollection creInfoCollection = new DynamicObjectCollection();
        for (HomCommonWrapper rowDataWrapper2 : rowDataWrapperList) {
            DynamicObject onbrdBill = rowDataWrapper2.getBizData();
            Long candidateId = onbrdBill.getLong("candidate.id");
            DynamicObject canBaseInfo = canBaseInfoMap.get(candidateId);
            DynamicObject mainCreInfo = canMainCreInfoMap.get(candidateId);
            DynamicObject certificateType = onbrdBill.getDynamicObject("certificatetype");
            IDCardInfo idCardInfo = null;
            if (!HRObjectUtils.isEmpty((Object)certificateType)) {
                long cerTypeNum = certificateType.getLong("id");
                if (HcfCanCreConstants.CREDENTIALSTYPE_ID_IDCARD == cerTypeNum) {
                    idCardInfo = IDCardUtils.parse((String)onbrdBill.getString("certificatenumber"));
                }
            }
            if (idCardInfo != null) {
                DynamicObject newCanBaseInfo = canBaseInfo == null ? HOMObjectUtils.newHcfHisDynamicObject((String)"hcf_canbaseinfo", (Long)candidateId) : HOMObjectUtils.copyHcfHisDynamicObject((String)"hcf_canbaseinfo", (DynamicObject)canBaseInfo);
                HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)newCanBaseInfo, (String)"nationality", (Object)nationalityChina);
                onbrdBill.set("nationality", newCanBaseInfo.get("nationality"));
                HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)newCanBaseInfo, (String)"gender", (Object)(idCardInfo.getGender() ? sexMan : sexWoman));
                onbrdBill.set("gender", newCanBaseInfo.get("gender"));
                LOGGER.info("newCanBaseInfo-birthday:" + newCanBaseInfo.get("birthday"));
                HOMObjectUtils.setFieldValueIfEmpty((DynamicObject)newCanBaseInfo, (String)"birthday", (Object)idCardInfo.getBirthDay());
                baseInfoCollection.add((Object)newCanBaseInfo);
            }
            if (mainCreInfo == null) continue;
            DynamicObject newMainCreInfo = HOMObjectUtils.copyHcfHisDynamicObject((String)"hcf_cancre", (DynamicObject)mainCreInfo);
            newMainCreInfo.set("number", onbrdBill.get("certificatenumber"));
            creInfoCollection.add((Object)newMainCreInfo);
        }
        HashMap hcfEntityInfosMap = Maps.newHashMapWithExpectedSize((int)2);
        hcfEntityInfosMap.put("hcf_canbaseinfo", baseInfoCollection);
        hcfEntityInfosMap.put("hcf_cancre", creInfoCollection);
        LOGGER.info("baseInfoCollection.size():" + baseInfoCollection.size());
        hcfDataDomainService.saveHcfAttachedData((Map)hcfEntityInfosMap);
    }

    private Map<Long, DynamicObject> getCanBaseInfoMap(Map<Long, Map<String, DynamicObjectCollection>> candidateInfoMaps) {
        return candidateInfoMaps.entrySet().stream().filter(entry -> {
            Map entityMap = (Map)entry.getValue();
            boolean isNoData = CollectionUtils.isEmpty((Map)entityMap) || CollectionUtils.isEmpty((Collection)((Collection)entityMap.get("hcf_canbaseinfo")));
            return !isNoData;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> (DynamicObject)((DynamicObjectCollection)((Map)entry.getValue()).get("hcf_canbaseinfo")).get(0), (oldValue, newValue) -> newValue));
    }

    private Map<Long, DynamicObject> getCanMainCreInfoMap(Map<Long, Map<String, DynamicObjectCollection>> candidateInfoMaps) {
        return candidateInfoMaps.entrySet().stream().filter(entry -> {
            Map entityMap = (Map)entry.getValue();
            boolean isNoData = CollectionUtils.isEmpty((Map)entityMap) || CollectionUtils.isEmpty((Collection)((Collection)entityMap.get("hcf_cancre")));
            return !isNoData;
        }).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            DynamicObjectCollection creDyCollection = (DynamicObjectCollection)((Map)entry.getValue()).get("hcf_cancre");
            DynamicObject mainCreDy = (DynamicObject)creDyCollection.get(0);
            for (DynamicObject dynamicObject : creDyCollection) {
                if (!dynamicObject.getBoolean("ismajor")) continue;
                mainCreDy = dynamicObject;
                break;
            }
            return mainCreDy;
        }, (oldValue, newValue) -> newValue));
    }

    private void setJobInfoByStdPositionInfoMap(DynamicObject onbrdBill, Map<String, Object> stdPositionInfoMap) {
        onbrdBill.set("ajobscmorg_id", stdPositionInfoMap.get("orgdesignbu.id"));
        onbrdBill.set("ajobscm_id", stdPositionInfoMap.get("jobscm.id"));
        onbrdBill.set("ajob_id", stdPositionInfoMap.get("job.id"));
        onbrdBill.set("joblevelscm_id", stdPositionInfoMap.get("joblevelscm.id"));
        onbrdBill.set("jobgradescm_id", stdPositionInfoMap.get("jobgradescm.id"));
    }

    private void setJobInfoByPositionInfoMap(DynamicObject onbrdBill, Map<String, Object> positionInfoMap) {
        onbrdBill.set("ajobscmorg_id", positionInfoMap.get("orgdesignbu"));
        onbrdBill.set("ajobscm_id", positionInfoMap.get("jobscm"));
        onbrdBill.set("ajob_id", positionInfoMap.get("job"));
        onbrdBill.set("joblevelscm_id", positionInfoMap.get("highjoblevel.joblevelscm"));
        onbrdBill.set("jobgradescm_id", positionInfoMap.get("highjobgrade.jobgradescm"));
    }

    private void setJobGradeAndJobLevel(DynamicObject onbrdBill, Map<String, Object> levelGradeMap) {
        List jobleves;
        List jobGrades = HbpmResultUtils.getJobGrade(levelGradeMap);
        if (!HRCollUtil.isEmpty((Collection)jobGrades) && jobGrades.size() == 1) {
            onbrdBill.set("ajobgrade_id", ((DynamicObject)jobGrades.get(0)).get("id"));
        }
        if (!CollectionUtils.isEmpty((Collection)(jobleves = HbpmResultUtils.getJobLevel(levelGradeMap))) && jobleves.size() == 1) {
            onbrdBill.set("ajoblevel_id", ((DynamicObject)jobleves.get(0)).get("id"));
        }
    }

    private void setJobInfoByJobInfoMap(DynamicObject onbrdBill, Map<String, Object> jobInfoMap) {
        HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajobscm", (Object)jobInfoMap.get("jobscm"));
        HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajobscmorg", (Object)jobInfoMap.get("createOrg"));
        HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"joblevelscm_id", (Object)jobInfoMap.get("joblevelScmid"));
        HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"jobgradescm_id", (Object)jobInfoMap.get("jobgradeScmid"));
        List jobLevelInfos = (List)jobInfoMap.get("joblevelRanges");
        List jobGradeInfos = (List)jobInfoMap.get("jobgradeRanges");
        if (jobLevelInfos != null && jobLevelInfos.size() == 1) {
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajoblevel", jobLevelInfos.get(0));
        }
        if (jobGradeInfos != null && jobGradeInfos.size() == 1) {
            HOMObjectUtils.setDesDyValueIfNotEmpty((DynamicObject)onbrdBill, (String)"ajobgrade", jobGradeInfos.get(0));
        }
    }

    private static /* synthetic */ Set lambda$getHRBuOrgMapNew$13(Set bussinessTypeIds, Long adminorgId) {
        return bussinessTypeIds;
    }

    private static /* synthetic */ Set lambda$getHRBuOrgMap$7(Set bussinessTypeIds, Long adminorgId) {
        return bussinessTypeIds;
    }
}

