/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.executor.chgtype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.service.personflow.IPersonFlowService;
import kd.hr.hpfs.common.model.EmployeeModel;
import kd.hr.hpfs.common.model.PreEmployeeModel;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import kd.hr.hpfs.common.utils.ObjectUtils;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;
import kd.sdk.hr.hpfs.common.constants.PerModelConstants;
import kd.sdk.hr.hpfs.common.perchg.PerChgConstants;
import org.apache.commons.collections4.CollectionUtils;

public class ChgTypeIndividuation
implements ChgConstants,
PerChgConstants,
PerModelConstants {
    public static final ThreadLocal<PreEmployeeModel> THREAD_LOCAL_PREEMPLOYEEMODEL = new ThreadLocal();
    public static final ThreadLocal<EmployeeModel> THREAD_LOCAL_EMPLOYEEMODEL = new ThreadLocal();
    private static final ChgTypeIndividuation CHGTYPEINDIVIDUATION = new ChgTypeIndividuation();
    private static final Log LOGGER = LogFactory.getLog(ChgTypeIndividuation.class);
    private static final String CHGMODEL_ADD = "0";
    private static final String CHGMODEL_FAILURE = "2";
    private static final List<String> CHGMODEL_LIST = Arrays.asList("0", "2");
    private static final Long CHANGESOURCE_EMPPOSORGRELCHG = 1030L;
    private static final Map<String, String> PROCESSOR = new HashMap<String, String>();

    public static ChgTypeIndividuation getInstance() {
        return CHGTYPEINDIVIDUATION;
    }

    public void execute(PerChgBizResult bizResult, PerChgBizInfo bizInfo, PerChgBizOperateType operateType, DynamicObject chgActionInfo, List<ParserResult> parserResults) {
        if (bizResult == null || !bizResult.getSuccess().booleanValue()) {
            return;
        }
        this.generatePersonFlow(bizInfo, bizResult);
        this.synLeader(bizInfo, parserResults);
        try {
            this.synPerson(bizInfo, chgActionInfo, parserResults);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR syncPerson error:", (Throwable)e);
        }
        this.saveAttachment(parserResults);
    }

    private void generatePersonFlow(PerChgBizInfo bizInfo, PerChgBizResult bizResult) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            params.put("flowTime", bizInfo.getBsed());
            params.put("chgAction", bizInfo.getActionId());
            params.put("chgCategory", bizInfo.getChgRule().getDynamicObject("chgaction").get("chgcategory"));
            params.put("chgRecord", bizResult.getRecordId());
            IPersonFlowService.getInstance().generatePersonFlow(params);
        }
        catch (Exception e) {
            String errorInfo = String.format("CHG_HPFS_ERROR generatePersonFlow chgActionId : %s, chgRecordId: %s", bizInfo.getActionId(), bizResult.getRecordId());
            bizResult.setErrMsg(errorInfo);
            LOGGER.error(errorInfo, (Throwable)e);
        }
    }

    public void synLeader(PerChgBizInfo bizInfo, List<ParserResult> parserResults) {
        try {
            Long chgEventId = bizInfo.getChgEventId();
            LOGGER.info("synLeader chgEventId is {}", (Object)chgEventId);
            List<Map<String, Object>> chargePersonParamList = chgEventId == 1070L ? this.buildChargePersonInfoWhenQuit(bizInfo, parserResults) : this.buildChargePersonInfo(bizInfo, parserResults);
            if (CollectionUtils.isNotEmpty(chargePersonParamList)) {
                chargePersonParamList.stream().forEach(param -> param.put("isSynChargeToUser", false));
                LOGGER.info("synLeader request , the chargePersonparamList size is {}", (Object)chargePersonParamList.size());
                HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"setChargePerson", (Object[])new Object[]{chargePersonParamList});
            }
        }
        catch (Exception ex) {
            LOGGER.error("synLeader error, the error message is :", (Throwable)ex);
        }
    }

    private List<Map<String, Object>> buildChargePersonInfo(PerChgBizInfo bizInfo, List<ParserResult> parserResults) {
        ArrayList<Map<String, Object>> chargePersonParamList = new ArrayList<Map<String, Object>>();
        Map idsRecord = bizInfo.getIdsRecord();
        List empposorgrelRecord = (List)idsRecord.get("hrpi_empposorgrel");
        Set chgRecordList = CollectionUtils.emptyIfNull((Collection)empposorgrelRecord).stream().filter(record -> CHGMODEL_LIST.contains(record.getChgMode())).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(chgRecordList)) {
            LOGGER.info("synLeader ==> synLeader end, the chgRecordList is empty");
            return chargePersonParamList;
        }
        List<DynamicObject> empposorgrelList = this.getDynamicObjectListFromParseResult("hrpi_empposorgrel", parserResults);
        List<DynamicObject> personrolerelList = this.getDynamicObjectListFromParseResult("hrpi_personrolerel", parserResults);
        for (ChgRecordEntryDto chgRecordEntryDto : chgRecordList) {
            String chgModel = chgRecordEntryDto.getChgMode();
            Long empposorgrelId = HRStringUtils.equals((String)chgModel, (String)CHGMODEL_ADD) ? chgRecordEntryDto.getIdAfter() : chgRecordEntryDto.getVidAfter();
            if (null == empposorgrelId || empposorgrelId <= 0L || !CollectionUtils.isNotEmpty(empposorgrelList)) continue;
            Optional<DynamicObject> emppoOptional = empposorgrelList.stream().filter(empposorgrel -> empposorgrel.getLong("id") == empposorgrelId.longValue()).findFirst();
            if (!emppoOptional.isPresent()) {
                LOGGER.info("synLeader ==> emppoOptional is empty, the empposorgrelId is{}", (Object)empposorgrelId);
                continue;
            }
            DynamicObject targetEmpposorgrel = emppoOptional.get();
            if (HRStringUtils.equals((String)chgModel, (String)CHGMODEL_ADD)) {
                long depemp_id = targetEmpposorgrel.getLong("depemp_id");
                if (depemp_id == 0L) {
                    LOGGER.warn("synLeader ==> depempis is empty, the empposorgrelId is{}", (Object)empposorgrelId);
                    continue;
                }
                Optional<DynamicObject> roleOptional = CollectionUtils.emptyIfNull(personrolerelList).stream().filter(personrolerel -> personrolerel.getLong("depemp_id") == depemp_id).findFirst();
                if (!roleOptional.isPresent()) {
                    LOGGER.warn("synLeader ==> roleOptional is empty, the empposorgrelId is{}", (Object)empposorgrelId);
                    continue;
                }
                DynamicObject role = roleOptional.get().getDynamicObject("role");
                if (Objects.isNull(role) || !role.getBoolean("mainpeoincharge")) continue;
            }
            chargePersonParamList.add(this.buildChargePersonParam(chgModel, targetEmpposorgrel));
        }
        return chargePersonParamList;
    }

    private List<Map<String, Object>> buildChargePersonInfoWhenQuit(PerChgBizInfo bizInfo, List<ParserResult> parserResults) {
        LOGGER.info("ChgTypeIndividuation#buildChargePersonInfoWhenQuit begin");
        Long oldPersonId = bizInfo.getOldPersonId();
        Date bsed = bizInfo.getBsed();
        List<DynamicObject> empposorgrelList = this.getDynamicObjectListFromParseResult("hrpi_empposorgrel", parserResults);
        if (null == empposorgrelList || empposorgrelList.size() == 0) {
            LOGGER.info("ChgTypeIndividuation#buildChargePersonInfoWhenQuit empposorgrelList is empty");
            return Collections.emptyList();
        }
        Map chargePersonInfo = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"queryChargeByPersonId", (Object[])new Object[]{Collections.singletonList(oldPersonId), bsed});
        if (null == chargePersonInfo || null == chargePersonInfo.get(oldPersonId)) {
            LOGGER.info("ChgTypeIndividuation#buildChargePersonInfoWhenQuit chargePersonInfo is empty");
            return Collections.emptyList();
        }
        Date endDate = empposorgrelList.get(0).getDate("enddate");
        List chargePersons = (List)chargePersonInfo.get(oldPersonId);
        return chargePersons.stream().map(chargePerson -> this.buildUpdateChargePersonParamByCharPersnInfo((Map<String, Object>)chargePerson, endDate)).collect(Collectors.toList());
    }

    private List<DynamicObject> getDynamicObjectListFromParseResult(String entityNumber, List<ParserResult> parserResults) {
        if (Objects.isNull(entityNumber) || CollectionUtils.isEmpty(parserResults)) {
            return Collections.emptyList();
        }
        return parserResults.stream().filter(parserResult -> HRStringUtils.equals((String)((String)parserResult.getParserParam().get("entityName")), (String)entityNumber)).map(parserResult -> (DynamicObject)parserResult.getParserParam().get("hisDy")).collect(Collectors.toList());
    }

    private Map<String, Object> buildUpdateChargePersonParamByCharPersnInfo(Map<String, Object> chargePersonInfo, Date endDate) {
        String operatetype = "1";
        HashMap<String, Object> chargePersonParam = new HashMap<String, Object>();
        chargePersonParam.put("operatetype", operatetype);
        chargePersonParam.put("depemp", chargePersonInfo.get("chargeperson"));
        chargePersonParam.put("adminorg", chargePersonInfo.get("adminorg"));
        chargePersonParam.put("effdt", endDate);
        chargePersonParam.put("changesource", CHANGESOURCE_EMPPOSORGRELCHG);
        return chargePersonParam;
    }

    private Map<String, Object> buildChargePersonParam(String chgModel, DynamicObject empposorgrelDy) {
        String operatetype = HRStringUtils.equals((String)CHGMODEL_ADD, (String)chgModel) ? CHGMODEL_ADD : "1";
        Date effdt = HRStringUtils.equals((String)CHGMODEL_ADD, (String)chgModel) ? empposorgrelDy.getDate("startDate") : empposorgrelDy.getDate("enddate");
        HashMap<String, Object> chargePersonParam = new HashMap<String, Object>();
        chargePersonParam.put("operatetype", operatetype);
        chargePersonParam.put("person", empposorgrelDy.getLong("person_id"));
        chargePersonParam.put("depemp", empposorgrelDy.getLong("depemp_id"));
        chargePersonParam.put("adminorg", empposorgrelDy.getLong("adminorg_id"));
        chargePersonParam.put("effdt", effdt);
        chargePersonParam.put("changesource", CHANGESOURCE_EMPPOSORGRELCHG);
        return chargePersonParam;
    }

    private void synPerson(PerChgBizInfo bizInfo, DynamicObject chgActionInfo, List<ParserResult> parserResults) {
        Optional<DynamicObject> ermanfileOp;
        Optional<DynamicObject> preErmanfileOp;
        EmployeeModel employeeModel;
        Long chgActionId = chgActionInfo.getLong("id");
        String chgTypeProcessor = PROCESSOR.get(chgActionId + "");
        List<DynamicObject> ermanfileDys = this.groupByErmanfileByPersonId(parserResults);
        if (Objects.isNull(ermanfileDys) || ermanfileDys.size() == 0) {
            LOGGER.info("ermanfileDy is empty, synPerson end");
            return;
        }
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>();
        PreEmployeeModel preEmployeeModel = THREAD_LOCAL_PREEMPLOYEEMODEL.get();
        EmployeeModel employeeModel2 = employeeModel = Objects.isNull(THREAD_LOCAL_EMPLOYEEMODEL.get()) && PerChgUtils.skipCreateNewPerson((PerChgBizInfo)bizInfo) ? this.buildNotCreateHRpersonSync2BosUser(bizInfo) : THREAD_LOCAL_EMPLOYEEMODEL.get();
        if (!Objects.isNull(preEmployeeModel) && (preErmanfileOp = ermanfileDys.stream().filter(ermanfileDy -> ermanfileDy.getLong("person_id") == preEmployeeModel.getOldPersonId().longValue()).findFirst()).isPresent()) {
            DynamicObject preErmanfile = preErmanfileOp.get();
            ermanfileDys.remove(preErmanfile);
            userList.add(this.buildSynPersonParam(preErmanfile, "disableupdate"));
        }
        if (!Objects.isNull(employeeModel) && (ermanfileOp = ermanfileDys.stream().filter(ermanfileDy -> ermanfileDy.getLong("person_id") == employeeModel.getNewPersonId().longValue()).findFirst()).isPresent()) {
            DynamicObject ermanfile = ermanfileOp.get();
            ermanfileDys.remove(ermanfile);
            if (Objects.nonNull(employeeModel.getOldPersonId()) && employeeModel.getOldPersonId() > 0L) {
                Map<String, Object> synOldPersonParam = this.buildSynPersonParam(ermanfile, employeeModel.getOldSyncType());
                synOldPersonParam.put("personid", employeeModel.getOldPersonId());
                userList.add(synOldPersonParam);
            }
            Map<String, Object> synNewPersonParam = this.buildSynPersonParam(ermanfile, employeeModel.getSyncType());
            synNewPersonParam.put("oldpersonid", employeeModel.getOldPersonId());
            userList.add(synNewPersonParam);
        }
        if (ObjectUtils.isEmpty((Object)chgTypeProcessor) && userList.size() == 0) {
            return;
        }
        if (HRStringUtils.isNotEmpty((String)chgTypeProcessor)) {
            ermanfileDys.forEach(ermanfileDy -> userList.add(this.buildSynPersonParam((DynamicObject)ermanfileDy, chgTypeProcessor)));
        }
        if (userList.size() > 0) {
            Map res = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"syncPersonToSysUer", (Object[])new Object[]{userList});
            if (((Boolean)res.get("success")).booleanValue()) {
                LOGGER.info("CHG_HPFS syncPersonToSysUer success");
            } else if (res.get("message") != null) {
                LOGGER.error("CHG_HPFS syncPersonToSysUer fail, the error message is{}", (Object)res.get("message").toString());
            }
        } else {
            LOGGER.error("CHG_HPFS syncPersonToSysUer error, userList is empty");
        }
    }

    private List<DynamicObject> groupByErmanfileByPersonId(List<ParserResult> parserResults) {
        return parserResults.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hspm_ermanfile")).map(row -> (DynamicObject)row.getParserParam().get("hisDy")).collect(Collectors.groupingBy(dy -> dy.getLong("person_id"))).values().stream().flatMap(dys -> dys.stream().limit(1L)).collect(Collectors.toList());
    }

    private EmployeeModel buildNotCreateHRpersonSync2BosUser(PerChgBizInfo bizInfo) {
        EmployeeModel employeeModel = new EmployeeModel();
        if (PerChgUtils.useOldBosUser()) {
            employeeModel.setNewPersonId(bizInfo.getOldPersonId());
            employeeModel.setSyncType("userupdate");
        } else {
            employeeModel.setOldPersonId(bizInfo.getOldPersonId());
            employeeModel.setOldSyncType("userdisable");
            employeeModel.setNewPersonId(bizInfo.getOldPersonId());
            employeeModel.setSyncType("useraddnew");
        }
        return employeeModel;
    }

    private Map<String, Object> buildSynPersonParam(DynamicObject ermanfileDy, String synType) {
        HashMap<String, Object> synPersonParam = new HashMap<String, Object>(16);
        String number = ermanfileDy.getString("number");
        String name = ermanfileDy.getString("name");
        Long personid = ermanfileDy.getLong("person_id");
        synPersonParam.put("personid", personid);
        synPersonParam.put("number", number);
        synPersonParam.put("name", name);
        synPersonParam.put("synctype", synType);
        return synPersonParam;
    }

    private void saveAttachment(List<ParserResult> parserResults) {
        try {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_attachment");
            DynamicObject[] datas = (DynamicObject[])parserResults.stream().filter(row -> row.getParserParam().get("entityName").equals("bos_attachment")).map(row -> (DynamicObject)row.getParserParam().get("hisDy")).toArray(DynamicObject[]::new);
            hrBaseServiceHelper.save(datas);
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR save attachment fail", (Throwable)e);
        }
    }

    static {
        PROCESSOR.put("1010", "join");
        PROCESSOR.put("1030", "join");
        PROCESSOR.put("1290", "join");
        PROCESSOR.put("1020", "quit");
        PROCESSOR.put("1180", "quit");
        PROCESSOR.put("1050", "transfer");
        PROCESSOR.put("1060", "transfer");
        PROCESSOR.put("1070", "parttime");
        PROCESSOR.put("1100", "parttimeend");
    }
}

