/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.service.impl.staff.SyncPersonStaffServiceImpl;
import kd.hr.haos.business.domain.service.staff.ISyncPersonStaffService;
import kd.hr.haos.business.service.ext.StaffExtDimFilterExtend;
import kd.hr.haos.business.service.staff.bean.DutyOrgEntryParamBO;
import kd.hr.haos.business.service.staff.bean.StaffProjectBo;
import kd.hr.haos.business.service.staff.service.StaffEntryHelper;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.service.staff.service.StaffSyncSevrice;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.haos.formplugin.web.staff.service.StaffFormService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrgStaffFormOperationHelper
implements OrgStaffConstants {
    private IFormView formView;
    private IDataModel dataModel;
    private IPageCache pageCache;
    private HRDataBaseEdit curEditClass;
    private ISyncPersonStaffService syncPersonStaffService = new SyncPersonStaffServiceImpl();
    private StaffExtEntryHelper staffExtEntryHelper;
    public static final String TASKCLOSEBACK = "taskcloseback";
    private Map<String, String> tabNameVsPrefixMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, BiConsumer<BeforeDoOperationEventArgs, CloseCallBack>> beforeOpConsumerMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, BiConsumer<AfterDoOperationEventArgs, ConfirmCallBackListener>> afterOpConsumerMap = Maps.newHashMapWithExpectedSize((int)16);

    public OrgStaffFormOperationHelper(IFormView formView, IDataModel dataModel, IPageCache pageCache) {
        this.formView = formView;
        this.dataModel = dataModel;
        this.pageCache = pageCache;
        this.initOpFunctionMap();
    }

    public OrgStaffFormOperationHelper(HRDataBaseEdit orgStaffMainEdit, IFormView view, IDataModel model, IPageCache pageCache) {
        this(view, model, pageCache);
        this.curEditClass = orgStaffMainEdit;
    }

    public OrgStaffFormOperationHelper(IFormView formView, IDataModel dataModel, IPageCache pageCache, StaffExtEntryHelper staffExtEntryHelper) {
        this.formView = formView;
        this.dataModel = dataModel;
        this.pageCache = pageCache;
        this.staffExtEntryHelper = staffExtEntryHelper;
        this.initOpFunctionMap();
    }

    public OrgStaffFormOperationHelper(HRDataBaseEdit orgStaffMainEdit, IFormView view, IDataModel model, IPageCache pageCache, StaffExtEntryHelper staffExtEntryHelper) {
        this(view, model, pageCache, staffExtEntryHelper);
        this.curEditClass = orgStaffMainEdit;
    }

    private void initOpFunctionMap() {
        this.tabNameVsPrefixMap.put("tabpage_position", "c");
        this.tabNameVsPrefixMap.put("tabpage_job", "d");
        this.tabNameVsPrefixMap.put("tabpage_laborreltype", "e");
        for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
            String dimension = extDim.getString("staffdimension");
            this.tabNameVsPrefixMap.put("tabpage_" + dimension, this.staffExtEntryHelper.getExtDimPrefix(dimension));
            String afterOp = String.format("donothing_delete%s", dimension);
            this.afterOpConsumerMap.put(afterOp, this::deleteJobOrLaborRelType);
            String beforeOp = String.format("donothing_new%s", dimension);
            this.beforeOpConsumerMap.put(beforeOp, this::addExtDim);
        }
        this.beforeOpConsumerMap.put("save", this::createDutyInfo);
        this.beforeOpConsumerMap.put("importuseorgdetail", this::importUseOrgAndDimension);
        this.beforeOpConsumerMap.put("importmuldimendetail", this::importUseOrgAndDimension);
        this.beforeOpConsumerMap.put("donothing_newjob", this::addJob);
        this.beforeOpConsumerMap.put("donothing_newlaborreltype", this::addLaborType);
        this.afterOpConsumerMap.put("copy_useorgdetail", this::copyUseOrgDetail);
        this.afterOpConsumerMap.put("copy_muldimendetail", this::copyMultiDiDetail);
        this.afterOpConsumerMap.put("donothing_sum", this::staffNumSum);
        this.afterOpConsumerMap.put("save", this::afterStaffSave);
        this.afterOpConsumerMap.put("enable", this::enableAndDisable);
        this.afterOpConsumerMap.put("disable", this::enableAndDisable);
        this.afterOpConsumerMap.put("donothing_deletejob", this::deleteJobOrLaborRelType);
        this.afterOpConsumerMap.put("donothing_deletelaborreltype", this::deleteJobOrLaborRelType);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs, CloseCallBack closeCallBack) {
        FormOperate formOperate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        BiConsumer<BeforeDoOperationEventArgs, CloseCallBack> consumer = this.beforeOpConsumerMap.get(operateKey);
        if (consumer != null) {
            consumer.accept(beforeDoOperationEventArgs, closeCallBack);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs, ConfirmCallBackListener callBack) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        BiConsumer<AfterDoOperationEventArgs, ConfirmCallBackListener> consumer = this.afterOpConsumerMap.get(operateKey);
        if (consumer != null) {
            consumer.accept(afterDoOperationEventArgs, callBack);
        }
    }

    private void createDutyInfo(BeforeDoOperationEventArgs beforeDoOperationEventArgs, CloseCallBack closeCallBack) {
        this.dataModel.deleteEntryData("aentryentity");
        DynamicObjectCollection useOrgInfos = this.dataModel.getEntryEntity("bentryentity");
        ArrayList dutyOrgParamBOs = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject useOrg : useOrgInfos) {
            Object yearStaffNumWithSubObject = useOrg.get("byearstaffnumwithsub");
            if (Objects.isNull(yearStaffNumWithSubObject)) continue;
            StaffProjectBo staffProjectBo = new StaffProjectBo(useOrg.get("bcontrolstrategy"), useOrg.get("belasticcontrol"), useOrg.get("belasticcount"), useOrg.getDynamicObjectCollection("bstaffdimension"));
            DutyOrgEntryParamBO dutyEntryParamBO = new DutyOrgEntryParamBO("aentryentity", "adutyorg", useOrg.getLong("buseorg.id"));
            dutyEntryParamBO.setStaffProjectBo(staffProjectBo);
            dutyEntryParamBO.setStaffCount(useOrg.getInt("byearstaffnumwithsub"));
            dutyEntryParamBO.setDistributable(useOrg.getInt("byearstaffnumwithsub"));
            dutyEntryParamBO.setStructLongNumber(useOrg.getString("bstructlongnumber"));
            dutyOrgParamBOs.add(dutyEntryParamBO);
        }
        StaffEntryHelper.batchCreateNewEntryRow((AbstractFormDataModel)((AbstractFormDataModel)this.dataModel), (IFormView)this.formView, (List)dutyOrgParamBOs);
    }

    private void importUseOrgAndDimension(BeforeDoOperationEventArgs beforeDoOperationEventArgs, CloseCallBack closeCallBack) {
        StringBuilder errorField = new StringBuilder();
        DynamicObjectCollection useOrgEntryCol = this.formView.getModel().getEntryEntity("bentryentity");
        DynamicObject orgDyn = this.formView.getModel().getDataEntity().getDynamicObject("org");
        Date yearDyn = this.formView.getModel().getDataEntity().getDate("year");
        DynamicObject staffCycleDyn = this.formView.getModel().getDataEntity().getDynamicObject("staffcycle");
        DynamicObject staffProjectDyn = this.formView.getModel().getDataEntity().getDynamicObject("staffproject");
        if (Objects.isNull(orgDyn)) {
            errorField.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u3001", (String)"OrgStaffMainEdit_10", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(yearDyn)) {
            errorField.append(ResManager.loadKDString((String)"\u7f16\u5236\u5e74\u4efd\u3001", (String)"OrgStaffMainEdit_11", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(staffCycleDyn)) {
            errorField.append(ResManager.loadKDString((String)"\u586b\u62a5\u671f\u95f4\u3001", (String)"OrgStaffMainEdit_12", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        }
        if (Objects.isNull(staffProjectDyn)) {
            errorField.append(ResManager.loadKDString((String)"\u63a7\u7f16\u89c4\u5219\u3001", (String)"OrgStaffMainEdit_13", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)errorField.toString())) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u6709\u5185\u5bb9\u672a\u6309\u8981\u6c42\u586b\u5199\uff1a%s;", (String)"OrgStaffMainEdit_14", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), errorField.toString().substring(0, errorField.length() - 1)));
            beforeDoOperationEventArgs.setCancel(true);
        } else if (CollectionUtils.isEmpty((Collection)useOrgEntryCol) && Objects.nonNull(orgDyn)) {
            this.formView.showTipNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201c%s\u201d\u4e0b\uff0c\u65e0\u542f\u7528\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"OrgStaffMainEdit_20", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), orgDyn.getString("name")));
            beforeDoOperationEventArgs.setCancel(true);
        } else {
            this.pageCache.put("clickImport", "true");
        }
    }

    private void addJob(BeforeDoOperationEventArgs beforeDoOperationEventArgs, CloseCallBack closeCallBack) {
        DynamicObjectCollection jobInfos = this.dataModel.getEntryEntity("dentryentity");
        Set jobIds = jobInfos.stream().map(job -> job.getLong("djob.id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "not in", jobIds);
        DynamicObject org = (DynamicObject)this.dataModel.getValue("org");
        filter.and(BaseDataHelper.getBaseDataFilter((String)"hbjm_jobhr", (long)org.getLong("id")));
        closeCallBack.setActionId("newJobCloseActionId");
        StaffFormService.create((IFormView)this.formView).showBaseDataForm("hbjm_jobhr", "hbjm_jobtreelistf7", filter, closeCallBack);
    }

    private void addLaborType(BeforeDoOperationEventArgs args, CloseCallBack closeCallBack) {
        DynamicObjectCollection laborRelTypeInfos = this.dataModel.getEntryEntity("eentryentity");
        Set laborRelTypeIds = laborRelTypeInfos.stream().map(job -> job.getLong("elaborreltype.id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "not in", laborRelTypeIds);
        filter.and("enable", "=", (Object)"1");
        closeCallBack.setActionId("newLaborCloseActionId");
        StaffFormService.create((IFormView)this.formView).showBaseDataForm("hbss_laborreltype", "bos_listf7", filter, closeCallBack);
    }

    private void addExtDim(BeforeDoOperationEventArgs args, CloseCallBack closeCallBack) {
        String oprateKey = ((FormOperate)args.getSource()).getOperateKey();
        for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
            String dimension = extDim.getString("staffdimension");
            if (!oprateKey.contains(dimension)) continue;
            String prefix = this.staffExtEntryHelper.getExtDimPrefix(dimension);
            DynamicObject basedata = extDim.getDynamicObject("basedata");
            String entity = basedata.getString("number");
            DynamicObjectCollection extInfos = this.dataModel.getEntryEntity(prefix + "entryentity");
            Set extDimIds = extInfos.stream().map(ext -> ext.getLong(prefix + dimension + ".id")).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "not in", extDimIds);
            QFilter customExtDimQfilter = StaffExtDimFilterExtend.getInstance().getCustomExtDimQfilter(entity, this.dataModel);
            if (customExtDimQfilter != null) {
                filter = filter.and(customExtDimQfilter);
            } else {
                this.andSpecialBasedataFilter(filter, entity);
            }
            closeCallBack.setActionId("new" + dimension + "CloseActionId");
            StaffFormService.create((IFormView)this.formView).showBaseDataForm(entity, FormMetadataCache.getListFormConfig((String)entity).getF7ListFormId(), filter, closeCallBack);
        }
    }

    private void andSpecialBasedataFilter(QFilter filter, String entity) {
        if (HRStringUtils.equals((String)"hbjm_joblevelhr", (String)entity)) {
            QFilter sfilter = new QFilter("joblevelscm.iscurrentversion", "=", (Object)"1");
            filter.and(sfilter);
        } else if (HRStringUtils.equals((String)"hbjm_jobgradehr", (String)entity)) {
            QFilter sfilter = new QFilter("jobgradescm.iscurrentversion", "=", (Object)"1");
            filter.and(sfilter);
        }
    }

    private void deleteJobOrLaborRelType(AfterDoOperationEventArgs afterDoOperationEventArgs, ConfirmCallBackListener callBack) {
        EntryGrid entryGrid;
        int[] selectedRows;
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        String entityName = "";
        for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
            String dimension = extDim.getString("staffdimension");
            String extOperateKey = "donothing_delete" + extDim.getString("staffdimension");
            if (!HRStringUtils.equals((String)extOperateKey, (String)operateKey)) continue;
            entityName = this.staffExtEntryHelper.getExtDimPrefix(dimension) + "entryentity";
        }
        if (HRStringUtils.isEmpty((String)entityName)) {
            String string = entityName = "donothing_deletejob".equals(operateKey) ? "dentryentity" : "eentryentity";
        }
        if ((selectedRows = (entryGrid = (EntryGrid)this.formView.getControl(entityName)).getEntryState().getSelectedRows()).length == 0) {
            if ("donothing_deletejob".equals(operateKey)) {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u5220\u9664\u7684\u804c\u4f4d\u6570\u636e\u3002", (String)"OrgStaffMainEdit_15", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            } else if ("donothing_deletelaborreltype".equals(operateKey)) {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u5220\u9664\u7684\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u6570\u636e\u3002", (String)"OrgStaffMainEdit_16", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            } else {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"OrgStaffMainEdit_21", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            }
        } else {
            String callBackId = (String)this.staffExtEntryHelper.getExtAfterOpToCallBackIdMap().get(operateKey);
            if (HRStringUtils.isEmpty((String)callBackId)) {
                callBackId = "donothing_deletejob".equals(operateKey) ? "deleteJobConfirmActionId" : "deleteLaborConfirmActionId";
            }
            callBack.setCallBackId(callBackId);
            this.formView.showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u591a\u7ef4\u7ec6\u5206\u7f16\u5236\u540e\u9009\u4e2d\u7684\u7ef4\u5ea6\u4e0d\u518d\u63a7\u7f16\u4e14\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417?", (String)"OrgStaffMainEdit_19", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, callBack);
        }
    }

    private void copyUseOrgDetail(AfterDoOperationEventArgs afterDoOperationEventArgs, ConfirmCallBackListener callBack) {
        EntryGrid entryGrid = (EntryGrid)this.formView.getControl("bentryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u590d\u5236\u7684\u7ec4\u7ec7\u7f16\u5236\u660e\u7ec6\u6570\u636e\u3002", (String)"OrgStaffMainEdit_8", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("haos_useorgcyclecopy");
        showParameter.setHasRight(true);
        this.formView.showForm(showParameter);
    }

    private void copyMultiDiDetail(AfterDoOperationEventArgs afterDoOperationEventArgs, ConfirmCallBackListener callBack) {
        String tabApName = ((Tab)this.formView.getControl("tabap")).getCurrentTab();
        String prefix = this.tabNameVsPrefixMap.get(tabApName);
        EntryGrid entryGridForMul = (EntryGrid)this.formView.getControl(prefix + "entryentity");
        int[] selectedRowsForMul = entryGridForMul.getEntryState().getSelectedRows();
        if (selectedRowsForMul.length == 0) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u590d\u5236\u7684\u7ef4\u5ea6\u7f16\u5236\u660e\u7ec6\u6570\u636e\u3002", (String)"OrgStaffMainEdit_9", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("haos_multicyclecopy");
        showParameter.setHasRight(true);
        this.formView.showForm(showParameter);
    }

    private void staffNumSum(AfterDoOperationEventArgs afterDoOperationEventArgs, ConfirmCallBackListener callBack) {
        DynamicObject staffCycle = (DynamicObject)this.dataModel.getValue("staffcycle");
        if (staffCycle == null) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u586b\u62a5\u671f\u95f4\u540e\u518d\u6c47\u603b\u8ba1\u7b97\u3002", (String)"OrgStaffMainEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.formView.getControl("bentryentity");
        int[] selectedRows = entryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length == 0) {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6c47\u603b\u8ba1\u7b97\u7684\u7ec4\u7ec7\u7f16\u5236\u660e\u7ec6\u6570\u636e\u3002", (String)"OrgStaffMainEdit_5", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return;
        }
        callBack.setCallBackId("sumCalcCallBack");
        this.formView.showConfirm(ResManager.loadKDString((String)"\u5c06\u591a\u7ef4\u7ec6\u5206\u7f16\u5236\u4e2d\u7684\u7f16\u5236\u6570\u636e\u6c47\u603b\uff0c\u5199\u5165\u7ec4\u7ec7\u7f16\u5236\u660e\u7ec6\u5bf9\u5e94\u7f16\u5236\u5468\u671f\u3002\u5c06\u8986\u76d6\u7ec4\u7ec7\u7f16\u5236\u8868\u4e2d\u5df2\u6709\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"OrgStaffMainEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBack);
    }

    private void afterStaffSave(AfterDoOperationEventArgs afterDoOperationEventArgs, ConfirmCallBackListener callBack) {
        long orgId = this.formView.getModel().getDataEntity().getLong("org.id");
        if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            if (this.formView.getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
                this.formView.updateView();
            }
            this.formView.setStatus(OperationStatus.VIEW);
            this.formView.cacheFormShowParameter();
            this.formView.setVisible(Boolean.TRUE, new String[]{"flexpanelap9"});
            String enable = this.formView.getModel().getDataEntity().getString("enable");
            if ("10".equals(enable)) {
                this.formView.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_enable"});
                this.formView.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_disable"});
            } else if ("1".equals(enable)) {
                this.formView.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_disable"});
                this.formView.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_enable"});
            } else if ("0".equals(enable)) {
                this.formView.setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_enable"});
                this.formView.setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_disable"});
            }
            this.formView.setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u7f16\u5236\u4fe1\u606f-", (String)"OrgStaffMainEdit_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]).concat(this.dataModel.getDataEntity().getString("name"))));
            this.pageCache.remove("jobLaborTypeIdPageCacheKey");
            DynamicObjectCollection useOrgEntryCol = this.formView.getModel().getDataEntity().getDynamicObjectCollection("bentryentity");
            List useOrgBoIdList = useOrgEntryCol.stream().map(useOrgEntry -> useOrgEntry.getLong("buseorg.boid")).collect(Collectors.toList());
            ArrayList<Long> dimensionIdList = new ArrayList<Long>(8);
            dimensionIdList.addAll(Arrays.asList(1010L, 1020L, 1050L));
            dimensionIdList.addAll(this.staffExtEntryHelper.getExtDimIds());
            for (Long useOrgBoId : useOrgBoIdList) {
                for (Long dimensionId : dimensionIdList) {
                    this.pageCache.remove("" + useOrgBoId + dimensionId);
                }
            }
            if (!HRStringUtils.equals((String)this.dataModel.getDataEntity().getString("enable"), (String)"10") && (HRStringUtils.equals((String)this.formView.getPageCache().get("need_sync"), (String)"1") || new StaffSyncSevrice().isNeedSync(this.dataModel.getDataEntity(true)))) {
                this.synStaffInfo(orgId);
            }
            this.formView.getPageCache().remove("need_sync");
        }
    }

    private void synStaffInfo(long orgId) {
        Date year = this.dataModel.getDataEntity().getDate("year");
        Date firstDateOfYear = OrgDateTimeUtil.getFirstDateOfYear((Date)year);
        Long staffId = this.dataModel.getDataEntity().getLong("id");
        if (!this.syncPersonStaffService.isOrgSyncIng(Long.valueOf(orgId)) && !this.syncPersonStaffService.isStaffSyncIng(staffId)) {
            String taskName = ResManager.loadKDString((String)"[\u6279\u91cf\u540c\u6b65]-\u5458\u5de5\u5360\u7f16\u4fe1\u606f", (String)"OrgStaffListPlugin_8", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            this.syncPersonStaffService.batchDispatchSyncSpecialRuleStaffTaskStaffScope(Collections.singletonList(staffId), taskName, new CloseCallBack((IFormPlugin)this.curEditClass, TASKCLOSEBACK), this.formView, firstDateOfYear);
        }
    }

    private void enableAndDisable(AfterDoOperationEventArgs afterDoOperationEventArgs, ConfirmCallBackListener callBack) {
        this.formView.setStatus(OperationStatus.VIEW);
        this.formView.updateView();
        this.formView.invokeOperation("refresh");
        if (afterDoOperationEventArgs.getOperateKey().equals("enable") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            long orgId = this.formView.getModel().getDataEntity().getLong("org.id");
            this.synStaffInfo(orgId);
        }
    }
}

