/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.repository.adorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import kd.hr.haos.business.domain.repository.IRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class AdminOrgStructRepository
extends HAOSBaseRepository
implements IRepository {
    private AdminOrgStructRepository() {
        super(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
    }

    public static AdminOrgStructRepository getInstance() {
        return Instance.INSTANCE;
    }

    public DynamicObject[] queryPerformanceUpdateFields(Collection<Long> adminOrgIds) {
        QFilter orgFilter = new QFilter("adminorg", "in", adminOrgIds);
        return this.serviceHelper.queryOriginalArray("adminorg as adminorg.id, level, structlongnumber", new QFilter[]{orgFilter, QFilterHelper.createValidHisCurrentDataFilter(), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
    }

    public DynamicObject[] load(Set<Long> idSet) {
        QFilter idFilter = new QFilter("id", "in", idSet);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public DynamicObject[] loadByAdminOrg(Set<Long> set) {
        QFilter filter = new QFilter("adminorg", "in", set);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{filter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), QFilterHelper.createValidHisVersionFilter(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObjectCollection queryHisColByBoId(String selectFields, Set<Long> set) {
        QFilter filter = new QFilter("adminorg", "in", set);
        return this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{filter, QFilterHelper.createValidHisVersionFilter(), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), QFilterHelper.createInitFinishedFilter()});
    }

    public DynamicObjectCollection queryHisColByBoDate(Set<Long> boSet, Date startDate, Date endDate) {
        return this.queryHisColByBoDate(boSet, startDate, endDate, AdminOrgConstants.ADMINORG_STRUCT);
    }

    public DynamicObjectCollection queryHisColByBoDate(Set<Long> boSet, Date startDate, Date endDate, Long structProjectId) {
        QFilter qFilter = new QFilter("adminorg", "in", boSet);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter()).and(QFilterHelper.createOverlapsFilter((Date)startDate, (Date)endDate));
        qFilter.and("structproject", "=", (Object)structProjectId);
        return this.serviceHelper.queryOriginalCollection("adminorg.id,structlongnumber", qFilter.toArray());
    }

    public DynamicObjectCollection queryHisColBySLN(Set<String> likeStructLongNumberSet, Set<String> equalsStructLongNumberSet, Date startDate, Date endDate) {
        return this.queryHisColBySLN(likeStructLongNumberSet, equalsStructLongNumberSet, startDate, endDate, AdminOrgConstants.ADMINORG_STRUCT);
    }

    public DynamicObjectCollection queryHisColBySLN(Set<String> likeStructLongNumberSet, Set<String> equalsStructLongNumberSet, Date startDate, Date endDate, Long structProjectId) {
        QFilter qFilter = new QFilter("structlongnumber", "in", equalsStructLongNumberSet);
        if (!CollectionUtils.isEmpty(likeStructLongNumberSet)) {
            likeStructLongNumberSet.forEach(sln -> qFilter.or("structlongnumber", "like", (Object)(sln + "%")));
        }
        QFilter dateQFilter = QFilterHelper.createValidHisVersionFilter().and(QFilterHelper.createInitFinishedFilter()).and(QFilterHelper.createOverlapsFilter((Date)startDate, (Date)endDate));
        dateQFilter.and("structproject", "=", (Object)structProjectId);
        return this.serviceHelper.queryOriginalCollection("id,adminorg.id,parentorg.id,bsed,bsled,structlongnumber", new QFilter[]{qFilter, dateQFilter});
    }

    public DynamicObject[] loadByOrgDateStructId(Set<Long> set, Date startDate, Date endDate, Long structProjectId) {
        QFilter orgFilter = new QFilter("adminorg", "in", set);
        orgFilter.and(QFilterHelper.createValidHisVersionFilter());
        orgFilter.and(QFilterHelper.createInitFinishedFilter());
        orgFilter.and(QFilterHelper.createOverlapsFilter((Date)startDate, (Date)endDate));
        orgFilter.and("structproject", "=", (Object)structProjectId);
        return this.serviceHelper.loadDynamicObjectArray(orgFilter.toArray());
    }

    public DynamicObject loadByAdminOrgAndDate(Long orgId, Date date) {
        QFilter qFilter = new QFilter("adminorg", "=", (Object)orgId);
        qFilter.and("bsed", "<=", (Object)date).and("bsled", ">=", (Object)date);
        qFilter.and(QFilterHelper.createValidHisVersionFilter()).and(QFilterHelper.createInitFinishedFilter());
        qFilter.and("structproject", "=", (Object)AdminOrgConstants.ADMINORG_STRUCT);
        return this.serviceHelper.loadDynamicObject(qFilter);
    }

    public DynamicObject[] queryArray(String fields, QFilter[] qFilters) {
        return this.serviceHelper.query(fields, qFilters);
    }

    public DynamicObject[] queryOriVirtualOrgByStructProId(String fields, Long structProjectId) {
        QFilter filter = new QFilter("adminorg.isvirtualorg", "=", (Object)"1");
        filter.and(new QFilter("structproject.id", "=", (Object)structProjectId));
        return this.serviceHelper.queryOriginalArray(fields, new QFilter[]{filter});
    }

    public DynamicObject[] queryStructInfoByStruct(String fields, Long structId, String orderBy) {
        QFilter structQf = new QFilter("structproject", "=", (Object)structId);
        QFilter currentQf = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.query(fields, new QFilter[]{structQf, currentQf, enableQf}, orderBy);
    }

    public DynamicObject[] queryEffStructInfo(String fields) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        return this.serviceHelper.query(fields, new QFilter[]{filter}, "structlongnumber");
    }

    public DynamicObject[] queryEffStructInfoByOrgId(String fields, Collection<Long> orgIds) {
        QFilter filter = new QFilter("adminorg", "in", orgIds);
        filter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        return this.serviceHelper.query(fields, new QFilter[]{filter});
    }

    public DynamicObject[] queryEffAndTempStructInfoByOrgId(String fields, Collection<Long> orgIds) {
        QFilter filter = new QFilter("adminorg", "in", orgIds);
        filter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        filter.and("iscurrentversion", "=", (Object)"1");
        return this.serviceHelper.query(fields, new QFilter[]{filter});
    }

    public DynamicObject[] queryEffStructInfoByOrgId(String fields, List<Long> orgIds, String orderby) {
        QFilter filter = new QFilter("adminorg", "in", orgIds);
        filter.and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get());
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        return this.serviceHelper.query(fields, new QFilter[]{filter}, orderby);
    }

    public DynamicObject[] queryOriginStructInfoLikeStructLongNum(String fields, List<String> structLongNumberList) {
        if (CollectionUtil.isEmpty(structLongNumberList)) {
            return new DynamicObject[0];
        }
        String sql = "select fid as id ,fstructlongnumber as structlongnumber from T_HAOS_ADMINSTRUCT  where fiscurrentversion = '1' AND fdatastatus = '1' AND fstructprojectid = 1010 AND finitstatus = '2'";
        ArrayList list = new ArrayList();
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"haos_useStaffSearch", (DBRoute)new DBRoute("hr"), (String)sql, (Object[])new Object[0]);){
            for (Row row : dataSet) {
                long id = row.getLong("id");
                String structLongNumber = row.getString("structlongnumber");
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("id", id);
                map2.put("structLongNumber", structLongNumber);
                list.add(map2);
            }
        }
        PatriciaTrie patriciaTrie = list.stream().collect(Collectors.toMap(map -> (String)map.get("structLongNumber"), dyn -> dyn, (value, value2) -> value, PatriciaTrie::new));
        HashSet idList = new HashSet();
        for (String structNumber : structLongNumberList) {
            SortedMap sortedMap = patriciaTrie.prefixMap((Object)structNumber);
            sortedMap.forEach((key, map) -> idList.add((Long)map.get("id")));
        }
        QFilter idFilter = new QFilter("id", "in", idList);
        return this.serviceHelper.queryOriginalArray(fields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryOriginStructInfoLikeStructNum(String fields, List<String> structNumberList) {
        if (CollectionUtil.isEmpty(structNumberList)) {
            return new DynamicObject[0];
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey());
        QFilter structNumberFilter = new QFilter("structnumber", "in", structNumberList);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] adminorgs = helper.queryOriginalArray("structlongnumber", new QFilter[]{structNumberFilter, versionFilter, dataStatusFilter});
        List<String> structLongNumberList = Arrays.stream(adminorgs).map(dyn -> dyn.getString("structlongnumber")).collect(Collectors.toList());
        return this.queryOriginStructInfoLikeStructLongNum(fields, structLongNumberList);
    }

    public DynamicObject[] queryOriginStructInfoLikeStructNumOrOrgIds(String fields, List<String> structNumberList, List<Long> orgIds, Long structId, String orderby) {
        QFilter structNumberFilter = null;
        if (!CollectionUtils.isEmpty(structNumberList)) {
            for (String structNumber : structNumberList) {
                if (structNumberFilter == null) {
                    structNumberFilter = new QFilter("structlongnumber", "like", (Object)("%" + structNumber + "%"));
                    continue;
                }
                structNumberFilter.or(new QFilter("structlongnumber", "like", (Object)("%" + structNumber + "%")));
            }
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            if (structNumberFilter == null) {
                structNumberFilter = new QFilter("adminorg", "in", orgIds);
            } else {
                structNumberFilter.or(new QFilter("adminorg", "in", orgIds));
            }
        }
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter enableFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter structFilter = new QFilter("structproject", "=", (Object)structId);
        if (structNumberFilter == null) {
            return this.serviceHelper.queryOriginalArray(fields, new QFilter[]{versionFilter, dataStatusFilter, enableFilter, structFilter}, orderby);
        }
        return this.serviceHelper.queryOriginalArray(fields, new QFilter[]{structNumberFilter, versionFilter, dataStatusFilter, enableFilter, structFilter}, orderby);
    }

    @Deprecated
    public DynamicObject[] queryOriginal(String selectFields, QFilter[] filters) {
        return this.serviceHelper.queryOriginalArray(selectFields, filters);
    }

    public DynamicObject[] queryOriginalByLevelAndDate(String selectFields, int level, Date date) {
        QFilter levelFilter = new QFilter("level", "<=", (Object)level);
        QFilter dateFilter = QFilterHelper.createValidHisVersionFilterByOnePoint((Date)date);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{dateFilter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), QFilterHelper.createInitFinishedFilter(), levelFilter});
    }

    public DynamicObject[] queryOriginalByLevel(String selectFields, int level) {
        QFilter levelFilter = new QFilter("level", "<=", (Object)level);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{QFilterHelper.createValidHisCurrentDataFilter(), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get(), QFilterHelper.createInitFinishedFilter(), levelFilter});
    }

    public DynamicObject[] queryStructHisByIdAndProjId(String selectField, List<Long> orgIds, Date queryDate, Long structProjectId) {
        QFilter filter = new QFilter("adminorg.id", "in", orgIds);
        filter.and(this.hisVersionFilter()).and(this.dataStatusFilter()).and(this.bsedFilter(queryDate)).and(this.blsedFilter(queryDate));
        filter.and("structproject", "=", (Object)structProjectId);
        if (1010L != structProjectId) {
            filter.and(this.enabledFilter());
        }
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObject queryStructHisByIdAndProjId(String selectField, Long orgId, Date queryDate, Long structProjectId) {
        QFilter filter = new QFilter("adminorg.id", "=", (Object)orgId);
        filter.and(this.hisVersionFilter()).and(this.dataStatusFilter()).and(this.bsedFilter(queryDate)).and(this.blsedFilter(queryDate));
        filter.and("structproject", "=", (Object)structProjectId);
        return this.serviceHelper.queryOne(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] queryHisByStructLongNumberAndProjId(String selectField, List<String> structLongNumbers, Date queryDate, Long structProjectId) {
        if (CollectionUtils.isEmpty(structLongNumbers)) {
            return null;
        }
        QFilter structLongNumberFilter = new QFilter("structlongnumber", "like", (Object)(structLongNumbers.get(0) + "%"));
        if (structLongNumbers.size() > 1) {
            for (int i = 1; i < structLongNumbers.size(); ++i) {
                structLongNumberFilter.or("structlongnumber", "like", (Object)(structLongNumbers.get(i) + "%"));
            }
        }
        return this.queryHisByProjIdAndFilter(selectField, queryDate, structProjectId, structLongNumberFilter);
    }

    public DynamicObject[] queryHisByProjIdAndFilter(String selectField, Date queryDate, Long structProjectId, QFilter otherFilter) {
        QFilter filter = new QFilter("structproject", "=", (Object)structProjectId);
        filter.and(this.hisVersionFilter()).and(this.dataStatusFilter()).and(this.bsedFilter(queryDate)).and(this.blsedFilter(queryDate));
        if (1010L != structProjectId) {
            filter.and(this.enabledFilter());
        }
        return this.serviceHelper.query(selectField, new QFilter[]{filter, otherFilter});
    }

    public void deleteByStructProjectNotOrg(Set<Long> structProjectSet, Long orgId) {
        QFilter qFilter = new QFilter("structproject", "in", structProjectSet);
        if (orgId != null) {
            qFilter.and("adminorg", "!=", (Object)orgId);
        }
        this.serviceHelper.deleteByFilter(qFilter.toArray());
    }

    public DynamicObject[] queryByStructProjectAndOrg(String selectFields, Set<Long> structProjectSet, Set<Long> orgSet) {
        QFilter qFilter = new QFilter("structproject", "in", structProjectSet);
        if (!CollectionUtils.isEmpty(orgSet)) {
            qFilter.and(new QFilter("adminorg", "in", orgSet));
        }
        return this.serviceHelper.query(selectFields, qFilter.toArray());
    }

    public DynamicObjectCollection queryColByOrgAndStructProject(String selectFields, Set<Long> set, Long structProjectId) {
        QFilter filter = new QFilter("adminorg", "in", set);
        filter.and("structproject", "=", (Object)structProjectId);
        return this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{filter, QFilterHelper.createInitFinishedFilter(), QFilterHelper.createValidHisCurrentDataFilter()});
    }

    public DynamicObjectCollection queryEnabledColByOrgAndStructProject(String selectFields, Set<Long> set, Long structProjectId) {
        QFilter filter = new QFilter("adminorg", "in", set);
        filter.and("structproject", "=", (Object)structProjectId);
        filter.and(QFilterHelper.createEnabledFilter());
        return this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{filter, QFilterHelper.createInitFinishedFilter(), QFilterHelper.createValidHisCurrentDataFilter()});
    }

    public DynamicObjectCollection queryValidColByStructProject(String selectFields, Long structProjectId, QFilter permQFilter, QFilter otherQFilter, String orderBys) {
        QFilter filter = new QFilter("structproject", "=", (Object)structProjectId);
        filter.and(QFilterHelper.createInitFinishedFilter());
        filter.and(QFilterHelper.createValidHisCurrentDataFilter());
        filter.and("adminorg.iscurrentversion", "=", (Object)Character.valueOf('1'));
        if (otherQFilter == null) {
            filter.and("enable", "in", Arrays.asList("10", "1"));
        } else {
            filter.and(otherQFilter);
        }
        QFilter[] qFilters = permQFilter == null ? filter.toArray() : new QFilter[]{filter, permQFilter};
        return HRStringUtils.isEmpty((String)orderBys) ? this.serviceHelper.queryOriginalCollection(selectFields, qFilters) : this.serviceHelper.queryOriginalCollection(selectFields, qFilters, orderBys);
    }

    public DynamicObject querySubDyBySLN(Set<String> likeStructLongNumberSet, Set<Long> orgSet, Long structProjectId) {
        QFilter qFilter = new QFilter("1", "!=", (Object)1);
        likeStructLongNumberSet.forEach(sln -> qFilter.or("structlongnumber", "like", (Object)(sln + "!%")));
        QFilter notOrgFilter = new QFilter("adminorg", "not in", orgSet);
        QFilter dateQFilter = QFilterHelper.createInitFinishedFilter().and(QFilterHelper.createValidHisCurrentDataFilter()).and("structproject", "=", (Object)structProjectId).and(QFilterHelper.createEnabledFilter());
        return this.serviceHelper.queryOriginalOne("adminorg.id,structlongnumber", new QFilter[]{qFilter, notOrgFilter, dateQFilter});
    }

    public DynamicObject[] queryOriginalHisStructByOrgIdAndLevel(String selectField, Collection<Long> orgIds, Integer level, Date queryDate, Long structProjectId) {
        QFilter filter = new QFilter("adminorg.id", "in", orgIds);
        filter.and("level", ">=", (Object)level).and(QFilterHelper.createValidHisVersionFilterByOnePoint((Date)queryDate));
        filter.and(new QFilter("structproject", "=", (Object)structProjectId));
        return this.serviceHelper.queryOriginalArray(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] queryOriginalHisStructByOrgNumberAndLevel(String selectField, Collection<String> orgNumbers, Integer level, Date queryDate, Long structProjectId) {
        QFilter filter = new QFilter("adminorg.number", "in", orgNumbers);
        filter.and("level", ">=", (Object)level).and(QFilterHelper.createValidHisVersionFilterByOnePoint((Date)queryDate));
        filter.and(new QFilter("structproject", "=", (Object)structProjectId));
        return this.serviceHelper.queryOriginalArray(selectField, new QFilter[]{filter});
    }

    public Boolean isRootOrgMaintain(Long structProjectId) {
        QFilter filter = new QFilter("structproject", "=", (Object)structProjectId);
        filter.and(QFilterHelper.createInitFinishedFilter());
        filter.and(QFilterHelper.createValidHisCurrentDataFilter());
        filter.and("parentorg", "not in", (Object)0L);
        return this.serviceHelper.isExists(filter);
    }

    public DynamicObject queryCurrOneByOrgId(String selectField, Long orgId, Long structProjectId) {
        QFilter filter = new QFilter("adminorg", "=", (Object)orgId);
        filter.and(this.currentVersionFilter()).and(this.effDataStatusFilter()).and(new QFilter("structproject", "=", (Object)structProjectId));
        return this.serviceHelper.queryOriginalOne(selectField, new QFilter[]{filter});
    }

    public DynamicObject[] queryHisByOrgId(String selectField, Set<Long> orgIdSet, Long structProjectId, Date date) {
        QFilter filter = new QFilter("adminorg", "in", orgIdSet);
        filter.and(QFilterHelper.createValidHisVersionFilterByOnePoint((Date)date)).and(new QFilter("structproject", "=", (Object)structProjectId));
        return this.serviceHelper.query(selectField, new QFilter[]{filter});
    }

    public DynamicObjectCollection queryOrgByStructProjectNotOrg(String selectField, Set<Long> structProjectSet, Set<Long> orgIdSet) {
        QFilter qFilter = new QFilter("structproject", "in", structProjectSet);
        qFilter.and("adminorg.isvirtualorg", "=", (Object)Boolean.TRUE);
        if (!CollectionUtils.isEmpty(orgIdSet)) {
            qFilter.and("adminorg", "not in", orgIdSet);
        }
        return this.serviceHelper.queryOriginalCollection(selectField, qFilter.toArray());
    }

    public void deleteByStructProjectOrg(Long structProjectId, Set<Long> orgSet) {
        QFilter qFilter = new QFilter("structproject", "=", (Object)structProjectId);
        qFilter.and("adminorg", "in", orgSet);
        this.serviceHelper.deleteByFilter(qFilter.toArray());
    }

    public DynamicObjectCollection queryColByStructAndQFilter(String selectFields, Long structProjectId, QFilter qFilter) {
        QFilter commonQFilter = new QFilter("structproject", "=", (Object)structProjectId);
        commonQFilter.and(QFilterHelper.createInitFinishedFilter());
        commonQFilter.and(QFilterHelper.createValidHisCurrentDataFilter());
        commonQFilter.and("enable", "in", Arrays.asList("10", "1"));
        return this.serviceHelper.queryOriginalCollection(selectFields, new QFilter[]{commonQFilter, qFilter});
    }

    public DynamicObject queryRootByStructId(String selectFields, Long structProjectId, Date queryDate) {
        QFilter commonQFilter = new QFilter("structproject", "=", (Object)structProjectId);
        commonQFilter.and(new QFilter("isroot", "=", (Object)"1"));
        commonQFilter.and(QFilterHelper.createInitFinishedFilter());
        commonQFilter.and(QFilterHelper.createValidHisVersionFilter((Date)queryDate));
        commonQFilter.and("enable", "in", Arrays.asList("10", "1"));
        return this.serviceHelper.queryOriginalOne(selectFields, new QFilter[]{commonQFilter});
    }

    public DynamicObject[] queryEffStructInfoByOrgId(String fields, Long orgId) {
        QFilter filter = new QFilter("adminorg", "=", (Object)orgId);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        return this.serviceHelper.query(fields, new QFilter[]{filter});
    }

    public DynamicObject[] queryHisEffStructInfoByOrgId(String fields, Long orgId, Date queryDate) {
        QFilter filter = new QFilter("adminorg", "=", (Object)orgId);
        filter.and(QFilterHelper.createValidHisVersionFilterByOnePoint((Date)queryDate));
        filter.and("enable", "=", (Object)"1");
        return this.serviceHelper.query(fields, new QFilter[]{filter});
    }

    public DynamicObject[] queryEffStructInfoByOrgIds(String fields, List<Long> orgIds) {
        QFilter filter = new QFilter("adminorg", "in", orgIds);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        return this.serviceHelper.query(fields, new QFilter[]{filter});
    }

    public DynamicObject[] queryOriginalEnableOtherStruct(String selectFields, Collection<Long> structProjectIdSet, Collection<Long> orgIds) {
        QFilter adminFilter = new QFilter("adminorg", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "in", (Object)"1");
        QFilter structProjectQFilter = new QFilter("structproject", "in", structProjectIdSet).and("structproject", "!=", (Object)1010L);
        return this.serviceHelper.queryOriginalArray(selectFields, new QFilter[]{adminFilter, enableFilter, structProjectQFilter, QFilterHelper.createHisCurrentDataFilter()});
    }

    public DynamicObject[] queryHISEffStructInfoByOrgId(String fields, Long orgId, Date queryDate) {
        QFilter filter = new QFilter("adminorg", "=", (Object)orgId);
        filter.and(QFilterHelper.createValidHisVersionFilterByOnePoint((Date)queryDate));
        filter.and(QFilterHelper.createInitFinishedFilter());
        return this.serviceHelper.query(fields, new QFilter[]{filter});
    }

    private static class Instance {
        private static AdminOrgStructRepository INSTANCE = new AdminOrgStructRepository();

        private Instance() {
        }
    }
}

