/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.domain.service.impl.staff.AbstractOrgStaffSaveService;
import kd.hr.haos.business.service.staff.bean.StaffHisParamBO;
import kd.hr.haos.business.service.staff.helper.StaffEntryTempHelperEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractMultiSaveService
extends AbstractOrgStaffSaveService {
    private static final Log LOGGER = LogFactory.getLog(AbstractMultiSaveService.class);
    protected AbstractMultiSaveService nextMultiSaveService;
    protected Map<String, Long> boEntryIdMap = Maps.newHashMapWithExpectedSize((int)16);

    public AbstractMultiSaveService(DynamicObject[] staffDynArr, String entryName) {
        super(staffDynArr, "haos_muldimendetail", entryName);
    }

    public void setNextMultiSaveService(AbstractMultiSaveService nextMultiSaveService) {
        this.nextMultiSaveService = nextMultiSaveService;
    }

    protected abstract void initDimensionInfoByStaffId(List<Long> var1);

    @Override
    protected void afterInvokeStaff(List<StaffHisParamBO> staffHisParamBOs) {
        List boList = staffHisParamBOs.stream().filter(bo -> HRStringUtils.equals((String)bo.getEntityName(), (String)this.entityName)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(boList)) {
            return;
        }
        List curEntityDynList = ((StaffHisParamBO)boList.get(0)).getDyns();
        Map<Long, Map<String, Long>> orgBoIdVsKeyFieldBoMap = this.getOrgBoIdVsKeyFieldBoMap();
        long[] ids = ORM.create().genLongIds(this.entityName, curEntityDynList.size());
        AtomicInteger idIndex = new AtomicInteger(0);
        List multiKeyFieldList = StaffEntryTempHelperEnum.getMultiKeyFieldList();
        curEntityDynList.forEach(dyn -> {
            Long bo;
            long orgBoId = dyn.getLong("useorg.boid");
            Map keyFieldVsBoIdMap = (Map)orgBoIdVsKeyFieldBoMap.get(orgBoId);
            if (CollectionUtils.isEmpty((Map)keyFieldVsBoIdMap)) {
                dyn.set("bo", (Object)ids[idIndex.getAndIncrement()]);
                return;
            }
            long keyFieldId = 0L;
            String keyField = "";
            for (String multiKeyField : multiKeyFieldList) {
                if (!Objects.nonNull(dyn.getDynamicObject(multiKeyField)) && dyn.getLong(multiKeyField + "_id") == 0L) continue;
                keyFieldId = dyn.getLong(multiKeyField + "_id");
                keyField = String.valueOf(dyn.getLong(multiKeyField + "_id")) + StaffEntryTempHelperEnum.getPrefixByFieldKey((String)multiKeyField);
                break;
            }
            if (Objects.nonNull(bo = (Long)keyFieldVsBoIdMap.get(keyField)) && bo != 0L) {
                dyn.set("bo", (Object)bo);
            } else {
                dyn.set("bo", (Object)ids[idIndex.getAndIncrement()]);
            }
        });
    }

    private Map<Long, Map<String, Long>> getOrgBoIdVsKeyFieldBoMap() {
        HRBaseServiceHelper multiHelper = new HRBaseServiceHelper(this.entityName);
        QFilter useOrgBoIdFilter = new QFilter("useorg.boid", "in", (Object)this.useOrgBoIdList);
        DynamicObject[] multiDyns = multiHelper.queryOriginalArray(this.getSelectFields(), new QFilter[]{useOrgBoIdFilter});
        List multiKeyFieldList = StaffEntryTempHelperEnum.getMultiKeyFieldList();
        Map<Long, Map<String, Long>> orgBoIdVsKeyFieldBoMap = Arrays.stream(multiDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("useorg.boid"), Collectors.toMap(dyn -> {
            for (String multiKey : multiKeyFieldList) {
                if (this.isEmptyOfLong(dyn.getLong(multiKey))) continue;
                return String.valueOf(dyn.getLong(multiKey)) + StaffEntryTempHelperEnum.getPrefixByFieldKey((String)multiKey);
            }
            return "";
        }, dyn -> dyn.getLong("bo"), (v1, v2) -> v1)));
        LOGGER.info("afterInvokeStaff orgBoIdVsKeyFieldBoMap : {} ", (Object)orgBoIdVsKeyFieldBoMap.toString());
        return orgBoIdVsKeyFieldBoMap;
    }

    private boolean isEmptyOfLong(Long value) {
        return value == null || value == 0L;
    }

    protected abstract void setEntryId(Long var1, DynamicObject var2);

    @Override
    protected void beforeInvokeStaff(DynamicObject[] staffDynArr) {
        for (DynamicObject staffDyn : staffDynArr) {
            long staffId = staffDyn.getLong("id");
            DynamicObjectCollection useOrgEntryCol = staffDyn.getDynamicObjectCollection("bentryentity");
            for (DynamicObject useOrgEntry : useOrgEntryCol) {
                this.setEntryId(staffId, useOrgEntry);
                AbstractMultiSaveService curNextMultiSaveService = this.nextMultiSaveService;
                while (curNextMultiSaveService != null) {
                    curNextMultiSaveService.setEntryId(staffId, useOrgEntry);
                    curNextMultiSaveService = curNextMultiSaveService.nextMultiSaveService;
                }
            }
        }
    }

    @Override
    protected void saveStaffInfo(DynamicObject[] staffDynArr, List<StaffHisParamBO> staffHisParamBOs) {
        for (DynamicObject staffDyn : staffDynArr) {
            this.initstaffOrgMap(staffDyn);
            DynamicObjectCollection useOrgInfos = staffDyn.getDynamicObjectCollection("bentryentity");
            long staffId = staffDyn.getLong("id");
            int size = useOrgInfos.size();
            ArrayList dimensionHisInfoList = Lists.newArrayListWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                dimensionHisInfoList.addAll(this.updateEntryEntityValue(staffDyn, i));
                AbstractMultiSaveService curNextMultiSaveService = this.nextMultiSaveService;
                while (curNextMultiSaveService != null) {
                    curNextMultiSaveService.staffDutyOrgMap = this.staffDutyOrgMap;
                    curNextMultiSaveService.staffUseOrgMap = this.staffUseOrgMap;
                    curNextMultiSaveService.staffUseOrgDutyOrgMap = this.staffUseOrgDutyOrgMap;
                    dimensionHisInfoList.addAll(curNextMultiSaveService.updateEntryEntityValue(staffDyn, i));
                    this.getNoChangeIdList().addAll(curNextMultiSaveService.getNoChangeIdList());
                    this.getOnlyOrgVersionChangeList().addAll(curNextMultiSaveService.getOnlyOrgVersionChangeList());
                    curNextMultiSaveService.getNoChangeIdList().clear();
                    curNextMultiSaveService.getOnlyOrgVersionChangeList().clear();
                    curNextMultiSaveService = curNextMultiSaveService.nextMultiSaveService;
                }
            }
            if (CollectionUtils.isEmpty((Collection)dimensionHisInfoList)) {
                staffHisParamBOs.add(new StaffHisParamBO(this.entityName, (List)Lists.newArrayListWithExpectedSize((int)1), new ArrayList(this.noChangeIdList), new ArrayList(this.onlyOrgVersionChangeList), staffId));
                continue;
            }
            staffHisParamBOs.add(new StaffHisParamBO(this.entityName, (List)dimensionHisInfoList, new ArrayList(this.noChangeIdList), new ArrayList(this.onlyOrgVersionChangeList), staffId));
        }
    }

    @Override
    protected void setSpecialField(Map<String, Object> param) {
        DynamicObject newDyn = (DynamicObject)param.get("newDyn");
        DynamicObject useOrgInfo = (DynamicObject)param.get("useOrgInfo");
        DynamicObject dynamicObject = (DynamicObject)param.get("dynamicObject");
        newDyn.set("staff", (Object)dynamicObject);
        newDyn.set("useorg", (Object)useOrgInfo.getDynamicObject("buseorg"));
        newDyn.set("orgteam", (Object)useOrgInfo.getDynamicObject("buseorg"));
    }

    @Override
    protected void saveTempStaffInfo(DynamicObject[] staffDynArr, List<StaffHisParamBO> staffHisParamBOs) {
        ArrayList dimensionHisInfoList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList toDeleteStaffIdList = Lists.newArrayListWithExpectedSize((int)16);
        List multiPrefixList = StaffEntryTempHelperEnum.getMultiPrefixList();
        for (DynamicObject staffDyn : staffDynArr) {
            long id = staffDyn.getLong("id");
            ArrayList staffDimensionHisInfoList = new ArrayList();
            DynamicObjectCollection useOrgInfos = staffDyn.getDynamicObjectCollection("bentryentity");
            if (CollectionUtils.isEmpty((Collection)useOrgInfos)) {
                toDeleteStaffIdList.add(staffDyn.getLong("id"));
            }
            for (DynamicObject useOrgInfo : useOrgInfos) {
                for (String prefix : multiPrefixList) {
                    DynamicObjectCollection multiCol = useOrgInfo.getDynamicObjectCollection(prefix + "entryentity");
                    DynamicObjectCollection newMultiCol = StaffCommonService.removePrefix(multiCol, this.entityName);
                    newMultiCol.forEach(dyn -> {
                        dyn.set("staff", (Object)staffDyn);
                        dyn.set("useorg", useOrgInfo.get("buseorg"));
                        dyn.set("orgteam", useOrgInfo.get("buseorg"));
                    });
                    staffDimensionHisInfoList.addAll(newMultiCol);
                }
            }
            if (CollectionUtils.isEmpty(staffDimensionHisInfoList)) {
                toDeleteStaffIdList.add(id);
                continue;
            }
            dimensionHisInfoList.addAll(staffDimensionHisInfoList);
        }
        if (!CollectionUtils.isEmpty((Collection)dimensionHisInfoList)) {
            staffHisParamBOs.add(new StaffHisParamBO(this.entityName, (List)dimensionHisInfoList));
        }
        if (!CollectionUtils.isEmpty((Collection)toDeleteStaffIdList)) {
            QFilter staffIdFilter = new QFilter("staff", "in", (Object)toDeleteStaffIdList);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_muldimendetail");
            DynamicObject[] curDynArr = helper.query("vid", new QFilter[]{staffIdFilter});
            List vidList = Arrays.stream(curDynArr).map(dyn -> dyn.getLong("vid.id")).collect(Collectors.toList());
            helper.deleteByFilter(new QFilter[]{staffIdFilter});
            HRBaseServiceHelper hisHelper = new HRBaseServiceHelper("haos_muldimendetailhis");
            QFilter vidFilter = new QFilter("id", "in", vidList);
            hisHelper.deleteByFilter(new QFilter[]{vidFilter});
        }
    }

    private String getSelectFields() {
        String defaultFields = "id, useorg.boid, bo, dutyworkrole, job, laborreltype";
        return defaultFields + this.listStaffDimensionInfo();
    }

    private String listStaffDimensionInfo() {
        HRBaseServiceHelper hrBaseServiceHelper;
        DynamicObject mulitStaffdimension;
        DataEntityPropertyCollection properties;
        Set propertyName;
        DynamicObject[] dynamicObjects = StaffDimensionRepository.getInstance().listAllDimension();
        Set staffimension = Arrays.stream(dynamicObjects).map(temp -> temp.getString("staffdimension")).collect(Collectors.toSet());
        HashSet needAppendInSqlStrs = (HashSet)Sets.intersection(staffimension, propertyName = (properties = (mulitStaffdimension = (hrBaseServiceHelper = new HRBaseServiceHelper("haos_muldimendetail")).generateEmptyDynamicObject()).getDataEntityType().getProperties()).stream().map(temp -> temp.getName()).collect(Collectors.toSet())).copyInto(new HashSet(16));
        String join = String.join((CharSequence)",", needAppendInSqlStrs);
        if (HRStringUtils.isEmpty((String)join)) {
            return join;
        }
        return "," + join;
    }
}

