/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.service.impl.staff.AbstractMultiSaveService;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;

public class PositionInfoSaveChain
extends AbstractMultiSaveService {
    public PositionInfoSaveChain(DynamicObject[] staffDynArr) {
        super(staffDynArr, "centryentity");
        List<Long> staffIdList = Arrays.stream(staffDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        this.initDimensionInfoByStaffId(staffIdList);
        for (DynamicObject staffDyn : staffDynArr) {
            String enable = staffDyn.getString("enable");
            long staffId = staffDyn.getLong("id");
            List entryDataFromDBList = (List)this.staffIdVsEntryDataFromDBMap.get(staffId);
            logger.info("PositionInfoSaveChain.init.entryDataFromDB.length:{}", CollectionUtils.isEmpty((Collection)entryDataFromDBList) ? "null" : Integer.valueOf(entryDataFromDBList.size()));
            if (!"1".equals(enable) || CollectionUtils.isEmpty((Collection)entryDataFromDBList)) continue;
            for (DynamicObject entryData : entryDataFromDBList) {
                long dutyWorkRoleId = entryData.getLong("dutyworkrole.id");
                if (dutyWorkRoleId == 0L) continue;
                long useOrgBoId = entryData.getLong("useorg.boid");
                String key = useOrgBoId + "-" + dutyWorkRoleId;
                String dataStatus = entryData.getString("datastatus");
                if (EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue().equals(dataStatus)) {
                    this.invalidIdList.add(key);
                }
                this.boEntryIdMap.put(key, entryData.getLong("id"));
            }
        }
    }

    @Override
    protected final void initDimensionInfoByStaffId(List<Long> staffIdList) {
        QFilter dutyWorkRoleFilter = new QFilter("dutyworkrole", "!=", (Object)0L);
        QFilter permFilter = StaffCommonService.getOrgPermQFilterForMultiEntry();
        dutyWorkRoleFilter.and(permFilter);
        this.staffIdVsEntryDataFromDBMap = this.getStaffInfoByStaffIdList(dutyWorkRoleFilter);
    }

    @Override
    protected void setEntryId(Long staffId, DynamicObject useOrgEntry) {
        List entryDataFromDBList = (List)this.staffIdVsEntryDataFromDBMap.get(staffId);
        if (!CollectionUtils.isEmpty((Collection)entryDataFromDBList)) {
            DynamicObjectCollection positionInfos = useOrgEntry.getDynamicObjectCollection("centryentity");
            long useOrgBoId = useOrgEntry.getLong("buseorg.boid");
            this.setEntryField("cdutyworkrole.id", useOrgBoId, positionInfos, this.boEntryIdMap);
        }
    }
}

