/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.staff.OrgPersonStaffInfoRepository;
import kd.hr.haos.business.domain.service.impl.staff.SyncPersonStaffServiceImpl;
import kd.hr.haos.business.domain.service.staff.IStaffProjectService;
import kd.hr.haos.business.domain.service.staff.ISyncPersonStaffService;
import kd.hr.haos.business.service.staff.bean.StaffCallRuleEngineParamBo;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffProjectServiceImpl
implements IStaffProjectService,
OrgStaffConstants {
    private static Log LOG = LogFactory.getLog(StaffProjectServiceImpl.class);
    private OrgPersonStaffInfoRepository orgPersonStaffInfoRepository = OrgPersonStaffInfoRepository.getInstance();
    private ISyncPersonStaffService syncPersonStaffService = new SyncPersonStaffServiceImpl();

    public void delPolicy(Long policyId) {
        if (policyId == null || policyId == 0L) {
            return;
        }
        try {
            HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"deletePolicy", (Object[])new Object[]{Collections.singletonList(policyId)});
        }
        catch (Exception e) {
            LOG.error("del_policy_error");
        }
    }

    public Long addPolicy(Map<String, Object> ruleMap) {
        long id = ORM.create().genLongId("homs_staffinner");
        String number = "STAFFRULE" + id;
        String name = "staff_special_rule" + id;
        long org = Long.parseLong(ruleMap.get("org").toString());
        String results = "{\"resultList\":[{\"index\":0,\"displayParam\":\" \",\"param\":\"ismatch\",\"paramType\":\"boolean\",\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\" \",\"value\":\"false\",\"dateFormat\":\"\"}]}";
        HashMap rule = Maps.newHashMapWithExpectedSize((int)8);
        rule.put("rulename", name);
        rule.put("rulenumber", number);
        rule.put("ruleorder", 1);
        rule.put("filtercondition", ruleMap.getOrDefault("rule", "").toString());
        String filterresult = "{\"resultList\":[{\"index\":0,\"displayParam\":\" \",\"param\":\"ismatch\",\"paramType\":\"boolean\",\"operators\":\"==\",\"valueType\":\"2\",\"displayValue\":\" \",\"value\":\"true\",\"dateFormat\":\"\"}]}";
        rule.put("filterresult", filterresult);
        List<HashMap> entryrulelist = Collections.singletonList(rule);
        HashMap entrybu = Maps.newHashMapWithExpectedSize((int)8);
        entrybu.put("entitybu", org);
        entrybu.put("containssub", false);
        List<HashMap> entrybulist = Collections.singletonList(entrybu);
        HashMap policyMap = Maps.newHashMapWithExpectedSize((int)16);
        policyMap.put("name", name);
        policyMap.put("number", number);
        policyMap.put("createbu", RequestContext.get().getOrgId());
        policyMap.put("bizappid", "217WYC/L9U7E");
        policyMap.put("scene", RULE_SCENE);
        policyMap.put("results", results);
        policyMap.put("entryrulelist", entryrulelist);
        policyMap.put("entrybulist", entrybulist);
        LOG.info("add_policy_start");
        Map responseMap = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"addPolicy", (Object[])new Object[]{policyMap});
        LOG.info("add_policy_end, responseMap{}", (Object)responseMap);
        if (responseMap != null && HRStringUtils.equals((String)responseMap.get("resultCode").toString(), (String)"200")) {
            return Long.valueOf(responseMap.get("policyId").toString());
        }
        LOG.info("add_policy_over");
        return 0L;
    }

    public Map<String, List<DynamicObject>> batchCallRuleEngineFromSync(List<DynamicObject> staffPersonInfos) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        if (CollectionUtils.isEmpty(staffPersonInfos)) {
            return result;
        }
        List adminOrgIdList = staffPersonInfos.stream().map(dyn -> dyn.getLong("orgteam")).collect(Collectors.toList());
        DynamicObject[] adminorgArr = AdOrgRepository.getInstance().loadByBoIdList("id, org", adminOrgIdList);
        HashMap adminOrgToOrgNumberMap = Maps.newHashMapWithExpectedSize((int)adminorgArr.length);
        HashMap adminOrgToOrgIdMap = Maps.newHashMapWithExpectedSize((int)adminorgArr.length);
        HashMap orgIdToPolicyIdMap = Maps.newHashMapWithExpectedSize((int)adminorgArr.length);
        for (DynamicObject adminorg : adminorgArr) {
            long id = adminorg.getLong("id");
            if (adminOrgToOrgNumberMap.get(id) != null) continue;
            String orgNumber = adminorg.getString("org.number");
            long orgId = adminorg.getLong("org.id");
            Map<String, Object> specialRuleFormSys = this.syncPersonStaffService.getSystemParameterRule(orgId);
            Long policyId = Long.valueOf(specialRuleFormSys.getOrDefault("policyid", 0L).toString());
            adminOrgToOrgNumberMap.put(id, orgNumber);
            adminOrgToOrgIdMap.put(id, orgId);
            orgIdToPolicyIdMap.put(orgId, policyId);
        }
        Map<Long, List<DynamicObject>> adminStaffPersonInfoMap = staffPersonInfos.stream().collect(Collectors.groupingBy(dy -> (Long)adminOrgToOrgIdMap.get(dy.getLong("orgteam"))));
        StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
        adminStaffPersonInfoMap.forEach((buId, staffPersonInfoListInSameAdminorg) -> {
            List staffPersonInfoListList = Lists.partition((List)staffPersonInfoListInSameAdminorg, (int)500);
            ArrayList matchData = Lists.newArrayListWithExpectedSize((int)staffPersonInfoListInSameAdminorg.size());
            HashMap serialNumberToDynMap = Maps.newHashMapWithExpectedSize((int)500);
            for (List staffPersonInfoList : staffPersonInfoListList) {
                ArrayList paramList = Lists.newArrayListWithExpectedSize((int)staffPersonInfoList.size());
                for (DynamicObject info : staffPersonInfoList) {
                    Long adminorgId = info.getLong("orgteam");
                    Long policyId = (Long)orgIdToPolicyIdMap.get(buId);
                    String orgNumber = (String)adminOrgToOrgNumberMap.get(adminorgId);
                    if (policyId == null || policyId == 0L || HRStringUtils.isEmpty((String)orgNumber)) continue;
                    StaffCallRuleEngineParamBo paramBo = new StaffCallRuleEngineParamBo(Long.valueOf(info.getLong("dutyworkrole")), Long.valueOf(info.getLong("job")), Long.valueOf(info.getLong("laborreltype")), Long.valueOf(info.getLong("orgteam")), policyId, orgNumber, info.getString("id"));
                    paramList.add(paramBo.toParamMap());
                    serialNumberToDynMap.put(info.getString("id"), info);
                }
                if (!CollectionUtils.isEmpty((Collection)paramList)) {
                    List sceneResult = (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngineForOriginal", (Object[])new Object[]{paramList});
                    matchData.addAll(this.getMatchRuleResult(sceneResult, serialNumberToDynMap));
                }
                serialNumberToDynMap.clear();
            }
            staffPersonInfoListInSameAdminorg.removeAll(matchData);
            List nomatchList = (List)result.get("notmatch");
            if (nomatchList == null) {
                nomatchList = Lists.newArrayListWithExpectedSize((int)staffPersonInfos.size());
            }
            nomatchList.addAll(staffPersonInfoListInSameAdminorg);
            result.put("notmatch", nomatchList);
            List matchList = (List)result.get("match");
            if (matchList == null) {
                matchList = Lists.newArrayListWithExpectedSize((int)staffPersonInfos.size());
            }
            matchList.addAll(matchData);
            result.put("match", matchList);
        });
        return result;
    }

    private <T> List getMatchRuleResult(List<Map<String, Object>> sceneResultList, Map<String, T> serialNumberToSmMap) {
        LOG.info("batchCallRuleEngineForOriginal_result ={}", sceneResultList);
        if (CollectionUtils.isEmpty(sceneResultList)) {
            this.throwCallRuleException();
        }
        ArrayList matchData = Lists.newArrayListWithExpectedSize((int)sceneResultList.size());
        for (Map<String, Object> sceneResult : sceneResultList) {
            if (!this.sceneResultIsMatch(sceneResult)) continue;
            String serialNumber = sceneResult.get("serialNumber").toString();
            matchData.add(serialNumberToSmMap.get(serialNumber));
        }
        return matchData;
    }

    private boolean sceneResultIsMatch(Map<String, Object> sceneResult) {
        List policyResultList;
        if (sceneResult == null || !HRStringUtils.equals((String)sceneResult.get("responseCode").toString(), (String)"200")) {
            this.throwCallRuleException();
        }
        if (CollectionUtils.isEmpty((Collection)(policyResultList = (List)sceneResult.get("policyResults")))) {
            return false;
        }
        Map policyResultMap = (Map)policyResultList.get(0);
        return policyResultMap.containsKey("ruleResults");
    }

    private void throwCallRuleException() {
        throw new KDException(new ErrorCode("kd.hr.haos.business.domain.service.impl.staff.StaffProjectServiceImpl", ResManager.loadKDString((String)"\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u5931\u8d25\u3002", (String)"StaffProjectServiceImpl_0", (String)"hrmp-haos-business", (Object[])new Object[0])), new Object[0]);
    }

    public List<String> batchCallRuleEngine(List<StaffCallRuleEngineParamBo> paramBoList) {
        List orgIdList = paramBoList.stream().map(StaffCallRuleEngineParamBo::getOrgId).collect(Collectors.toList());
        Map orgIdToNumberMap = this.orgPersonStaffInfoRepository.getOrgNumberById(orgIdList);
        HashMap orgIdToPolicyIdMap = Maps.newHashMapWithExpectedSize((int)paramBoList.size());
        for (Long orgId : orgIdList) {
            if (orgIdToPolicyIdMap.get(orgId) != null) continue;
            Map<String, Object> specialRuleFormSys = this.syncPersonStaffService.getSystemParameterRule(orgId);
            Long policyId = Long.valueOf(((Object)specialRuleFormSys.getOrDefault("policyid", 0L)).toString());
            orgIdToPolicyIdMap.put(orgId, policyId);
        }
        HashMap buToParamListMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)paramBoList.size());
        for (StaffCallRuleEngineParamBo paramBo : paramBoList) {
            long orgId = paramBo.getOrgId();
            Long policyId = (Long)orgIdToPolicyIdMap.get(orgId);
            if (policyId == null || policyId == 0L) continue;
            List paramListInSameBu2 = (List)buToParamListMap.get(orgId);
            if (paramListInSameBu2 == null) {
                paramListInSameBu2 = Lists.newArrayListWithExpectedSize((int)paramBoList.size());
            }
            paramBo.setBuNumber((String)orgIdToNumberMap.get(paramBo.getOrgId()));
            paramBo.setExecutePolicyIds(Collections.singletonList(policyId));
            paramListInSameBu2.add(paramBo.toParamMap());
            buToParamListMap.put(orgId, paramListInSameBu2);
            resultMap.put(paramBo.getSerialNumber(), paramBo.getSerialNumber());
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)paramBoList.size());
        buToParamListMap.forEach((bu, paramListInSameBu) -> {
            List paramListList = Lists.partition((List)paramListInSameBu, (int)500);
            for (List param : paramListList) {
                List sceneResult = (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngineForOriginal", (Object[])new Object[]{param});
                result.addAll(this.getMatchRuleResult(sceneResult, resultMap));
            }
        });
        return result;
    }
}

