/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.haos.business.domain.repository.staff.OrgPersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.domain.service.staff.ISyncPersonStaffService;
import kd.hr.haos.business.service.staff.bean.EmpposorgrelSplitBO;
import kd.hr.haos.business.service.staff.bean.PageHelperVO;
import kd.hr.haos.business.service.staff.bean.StaffSyncPersonInfoHelperBo;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.task.SyncSpecialRuleStaffTask;
import kd.hr.haos.business.task.SyncSpecialRuleStaffTaskClick;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class SyncPersonStaffServiceImpl
implements ISyncPersonStaffService,
OrgStaffConstants {
    private StaffRepository staffRepository = StaffRepository.getInstance();
    private UseOrgDetailRepository useOrgDetailRepository = UseOrgDetailRepository.getInstance();
    private OrgPersonStaffInfoRepository orgPersonStaffInfoRepository = OrgPersonStaffInfoRepository.getInstance();

    @Override
    public List<Long> queryUseOrgIdListByOrgId(Long orgId) {
        List staffIdList = this.staffRepository.queryStaffIdList(orgId);
        return this.useOrgDetailRepository.queryUseOrgIdList(staffIdList);
    }

    @Override
    public PageHelperVO getOrgPerson(StaffSyncPersonInfoHelperBo syncHelperBo, List<Long> useOrgIdList) {
        EmpposorgrelSplitBO empposorgrelSplitBO = new EmpposorgrelSplitBO(syncHelperBo, useOrgIdList, null);
        List dynamicObjects = empposorgrelSplitBO.genStaffDimensionDy();
        PageHelperVO pageHelperVO = new PageHelperVO(dynamicObjects, empposorgrelSplitBO.getPageCount());
        return pageHelperVO;
    }

    @Override
    public List<Long> saveToPersonStaffInfo(DynamicObject[] dys) {
        if (!HRArrayUtils.isEmpty((Object[])dys)) {
            this.orgPersonStaffInfoRepository.save(dys);
            return Stream.of(dys).map(it -> it.getLong("orgperson")).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    @Override
    public void cacheSyncIngTag(Long orgId, boolean syncIng) {
        String cacheKey = this.getSyncIngCacheKey(orgId);
        HRAppCache.get((String)"haos").put(cacheKey, (Object)syncIng);
    }

    @Override
    public void cacheStaffSyncIngTag(Long staffId, boolean syncIng) {
        String cacheKey = this.getStaffSyncIngCacheKey(staffId);
        HRAppCache.get((String)"haos").put(cacheKey, (Object)syncIng);
    }

    @Override
    public boolean isOrgSyncIng(Long orgId) {
        String cacheKey = this.getSyncIngCacheKey(orgId);
        Boolean sync = (Boolean)HRAppCache.get((String)"haos").get(cacheKey, Boolean.class);
        if (sync == null) {
            return false;
        }
        return sync;
    }

    @Override
    public boolean isStaffSyncIng(Long staffId) {
        String cacheKey = this.getStaffSyncIngCacheKey(staffId);
        Boolean sync = (Boolean)HRAppCache.get((String)"haos").get(cacheKey, Boolean.class);
        if (sync == null) {
            return false;
        }
        return sync;
    }

    private String getSyncIngCacheKey(Long orgId) {
        return "syncing" + orgId;
    }

    private String getStaffSyncIngCacheKey(Long staffId) {
        return "syncingstaff" + staffId;
    }

    @Override
    public Map<String, Object> getSystemParameterRule(Long orgId) {
        String ruleOrg;
        String staffspecialruleStr = (String)StaffCommonService.getSystemParam(orgId, "staffspecialrule");
        Map specialRule = (Map)JSONObject.parseObject((String)staffspecialruleStr, Map.class);
        if (specialRule == null) {
            specialRule = Maps.newHashMapWithExpectedSize((int)8);
        }
        if (!HRStringUtils.equals((String)(ruleOrg = String.valueOf(specialRule.getOrDefault("org", 0L))), (String)String.valueOf(orgId))) {
            specialRule.clear();
        }
        return specialRule;
    }

    @Override
    public void dispatchSyncSpecialRuleStaffTask(Long orgId, String taskName, CloseCallBack closeCallBack, IFormView view, Date startDate) {
        List<Long> orgIdList = Collections.singletonList(orgId);
        this.dispatchSyncSpecialRuleStaff(orgIdList, taskName, closeCallBack, view, startDate, new ArrayList<Long>());
    }

    @Override
    public void batchDispatchSyncSpecialRuleStaffTask(List<Long> orgIdList, String taskName, CloseCallBack closeCallBack, IFormView view, Date startDate) {
        this.dispatchSyncSpecialRuleStaff(orgIdList, taskName, closeCallBack, view, startDate, new ArrayList<Long>());
    }

    @Override
    public void batchDispatchSyncSpecialRuleStaffTaskStaffScope(List<Long> staffIdList, String taskName, CloseCallBack closeCallBack, IFormView view, Date startDate) {
        this.dispatchSyncSpecialRuleStaff(new ArrayList<Long>(), taskName, closeCallBack, view, startDate, staffIdList);
    }

    private void dispatchSyncSpecialRuleStaff(List<Long> orgIdList, String taskName, CloseCallBack closeCallBack, IFormView view, Date startDate, List<Long> staffIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        QFilter filter = new QFilter("number", "=", (Object)"no_staffpersonsync");
        DynamicObject config = serviceHelper.queryOne("value", filter.toArray());
        if (!HRObjectUtils.isEmpty((Object)config) && HRStringUtils.equals((String)config.getString("value"), (String)"1")) {
            if (!CollectionUtils.isEmpty(orgIdList)) {
                orgIdList.forEach(orgId -> this.cacheSyncIngTag((Long)orgId, false));
            }
            if (!CollectionUtils.isEmpty(staffIdList)) {
                staffIdList.forEach(staffId -> this.cacheStaffSyncIngTag((Long)staffId, false));
            }
            return;
        }
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("haos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setName(taskName);
        jobInfo.setRunByLang(Lang.get());
        String jobNumber = "JOB" + new SecureRandom().nextDouble() * 10000.0;
        jobInfo.setNumber(jobNumber);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(SyncSpecialRuleStaffTask.class.getName());
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        params.put("orgId", orgIdList);
        params.put("jobNumber", jobNumber);
        params.put("staffIdList", staffIdList);
        params.put("startDate", HRDateTimeUtils.format((Date)startDate));
        String formId = view.getFormShowParameter().getFormId();
        if (HRStringUtils.equals((String)"homs_parameterconsole", (String)formId)) {
            params.put("sourceType", "1");
        }
        jobInfo.setParams((Map)params);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setClickClassName(SyncSpecialRuleStaffTaskClick.class.getName());
        jobFormInfo.setTimeout(1800);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)view);
    }

    @Override
    public List<DynamicObject> getPerson(StaffSyncPersonInfoHelperBo syncHelperBo, List<Long> person) {
        EmpposorgrelSplitBO empposorgrelSplitBO = new EmpposorgrelSplitBO(syncHelperBo, null, person);
        List staffDimensionDys = empposorgrelSplitBO.genStaffDimensionDy();
        return staffDimensionDys;
    }
}

