/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.service.impl.staff.AbstractOrgStaffSaveService;
import kd.hr.haos.business.domain.service.impl.staff.DutyOrgInfoSaveChain;
import kd.hr.haos.business.service.staff.bean.StaffHisParamBO;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRStringUtils;

public class UseOrgInfoSaveChain
extends AbstractOrgStaffSaveService {
    private Map<String, DynamicObject> dutyStructLongNumberMap = null;

    public UseOrgInfoSaveChain(DynamicObject[] staffDynArr) {
        super(staffDynArr, "haos_useorgdetail", "bentryentity");
        QFilter orgPermQFilter = StaffCommonService.getOrgPermQFilterForUseOrgEntry();
        this.staffIdVsEntryDataFromDBMap = this.getStaffInfoByStaffIdList(orgPermQFilter);
    }

    @Override
    protected void beforeInvokeStaff(DynamicObject[] staffDynArr) {
        for (DynamicObject staffDyn : staffDynArr) {
            long staffId = staffDyn.getLong("id");
            List entryDataList = (List)this.staffIdVsEntryDataFromDBMap.get(staffId);
            HashMap boIdVsEntryIdMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty((Collection)entryDataList)) {
                for (DynamicObject entryData : entryDataList) {
                    String dataStatus = entryData.getString("datastatus");
                    String useOrgBoId = entryData.getString("useorg.boid");
                    if (EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue().equals(dataStatus)) {
                        this.invalidIdList.add(useOrgBoId);
                    }
                    boIdVsEntryIdMap.put(useOrgBoId, entryData.getLong("id"));
                }
            }
            DynamicObjectCollection useOrgEntryCol = staffDyn.getDynamicObjectCollection(this.entryName);
            this.setEntryField("buseorg.boid", 0L, useOrgEntryCol, boIdVsEntryIdMap);
        }
    }

    @Override
    protected void afterInvokeStaff(List<StaffHisParamBO> staffHisParamBOs) {
        List boList = staffHisParamBOs.stream().filter(bo -> HRStringUtils.equals((String)bo.getEntityName(), (String)this.entityName)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(boList)) {
            return;
        }
        List curEntityDynList = ((StaffHisParamBO)boList.get(0)).getDyns();
        Map<Long, Long> orgBoIdVsBoMap = this.getBoIdVsBoMap();
        long[] ids = ORM.create().genLongIds("haos_useorgdetail", curEntityDynList.size());
        AtomicInteger idIndex = new AtomicInteger(0);
        curEntityDynList.forEach(dyn -> {
            long orgBoId = dyn.getLong("useorg.boid");
            Long bo = (Long)orgBoIdVsBoMap.get(orgBoId);
            if (Objects.nonNull(bo) && bo != 0L) {
                dyn.set("bo", (Object)bo);
            } else {
                dyn.set("bo", (Object)ids[idIndex.getAndIncrement()]);
            }
        });
    }

    @Override
    protected void saveTempStaffInfo(DynamicObject[] staffDynArr, List<StaffHisParamBO> staffHisParamBOs) {
        ArrayList useOrgInfoList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList toDeleteStaffIdList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject staffDyn : staffDynArr) {
            DynamicObjectCollection useOrgInfos = staffDyn.getDynamicObjectCollection(this.entryName);
            if (CollectionUtils.isEmpty((Collection)useOrgInfos)) {
                toDeleteStaffIdList.add(staffDyn.getLong("id"));
            }
            DynamicObjectCollection useOrgInfoNew = StaffCommonService.removePrefix(useOrgInfos, this.entityName);
            useOrgInfoNew.forEach(dyn -> {
                dyn.set("staff", (Object)staffDyn);
                dyn.set("useorgbo", dyn.get("useorg.boid"));
            });
            useOrgInfoList.addAll(useOrgInfoNew);
        }
        if (!CollectionUtils.isEmpty((Collection)useOrgInfoList)) {
            staffHisParamBOs.add(new StaffHisParamBO(this.entityName, (List)useOrgInfoList));
        }
        if (!CollectionUtils.isEmpty((Collection)toDeleteStaffIdList)) {
            QFilter staffIdFilter = new QFilter("staff", "in", (Object)toDeleteStaffIdList);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_useorgdetail");
            DynamicObject[] curDynArr = helper.query("vid", new QFilter[]{staffIdFilter});
            List vidList = Arrays.stream(curDynArr).map(dyn -> dyn.getLong("vid.id")).collect(Collectors.toList());
            helper.deleteByFilter(new QFilter[]{staffIdFilter});
            HRBaseServiceHelper hisHelper = new HRBaseServiceHelper("haos_useorgdetailhis");
            QFilter vidFilter = new QFilter("id", "in", vidList);
            hisHelper.deleteByFilter(new QFilter[]{vidFilter});
        }
    }

    private Map<Long, Long> getBoIdVsBoMap() {
        HRBaseServiceHelper useOrgHelper = new HRBaseServiceHelper(this.entityName);
        QFilter useOrgBoIdFilter = new QFilter("useorgbo", "in", (Object)this.useOrgBoIdList);
        DynamicObject[] useOrgDynArr = useOrgHelper.queryOriginalArray("id, useorgbo, bo", new QFilter[]{useOrgBoIdFilter});
        return Arrays.stream(useOrgDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("useorgbo"), dyn -> dyn.getLong("bo"), (v1, v2) -> v1));
    }

    @Override
    protected void setSpecialField(Map<String, Object> param) {
        super.setSpecialField(param);
        DynamicObject newDyn = (DynamicObject)param.get("newDyn");
        DynamicObject entry = (DynamicObject)param.get("entry");
        newDyn.set("useorgbo", entry.get("buseorg.boid"));
    }

    @Override
    protected void setDutyOrg(DynamicObject entry) {
        super.setDutyOrg(entry);
        Map<String, DynamicObject> dutyStructLongNumberMap = this.getDutyStructLongNumberMap();
        if (dutyStructLongNumberMap != null && dutyStructLongNumberMap.size() > 0) {
            String structLongNumber = entry.getString("bstructlongnumber");
            String[] parentStructLongNumbers = StaffCommonService.buildStructLongNumberArr(structLongNumber);
            for (int i = parentStructLongNumbers.length - 1; i >= 0; --i) {
                DynamicObject dutyOrgInfo = dutyStructLongNumberMap.get(parentStructLongNumbers[i]);
                if (dutyOrgInfo == null) continue;
                entry.set("bdutyorg", dutyOrgInfo.get("adutyorg"));
                break;
            }
        }
    }

    private Map<String, DynamicObject> getDutyStructLongNumberMap() {
        if (this.dutyStructLongNumberMap == null && this.preStaffSaveService != null && this.preStaffSaveService instanceof DutyOrgInfoSaveChain) {
            this.dutyStructLongNumberMap = ((DutyOrgInfoSaveChain)this.preStaffSaveService).getDutyStructLongNumberMap();
        }
        return this.dutyStructLongNumberMap;
    }
}

