/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.application.impl.staff.SyncPersonStaffApplicationImpl;
import kd.hr.haos.business.application.staff.ISyncPersonStaffApplication;
import kd.hr.haos.business.domain.service.impl.staff.SyncPersonStaffServiceImpl;
import kd.hr.haos.business.domain.service.staff.ISyncPersonStaffService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class SyncSpecialRuleStaffTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SyncSpecialRuleStaffTask.class);
    private ISyncPersonStaffApplication iSyncPersonStaffApplication = new SyncPersonStaffApplicationImpl();
    private ISyncPersonStaffService syncPersonStaffService = new SyncPersonStaffServiceImpl();
    private List<Long> orgIdList = new ArrayList<Long>();
    private List<Long> staffIdList = new ArrayList<Long>();
    private boolean stop;
    private boolean exception;
    private String sourceType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int i;
        Object staffIdListObj;
        logger.info("start_syncspeicialrulestaff_task, map {}", map);
        if (map == null) {
            return;
        }
        String jobNumber = map.getOrDefault("jobNumber", "").toString();
        Date startDate = null;
        try {
            startDate = HRDateTimeUtils.parseDate((String)((String)map.get("startDate")));
        }
        catch (ParseException e) {
            logger.error("SyncSpecialRuleStaffTask errorinfo ", (Throwable)e);
        }
        Object orgIdListObj = map.get("orgId");
        if (orgIdListObj != null) {
            this.orgIdList = (List)orgIdListObj;
        }
        if ((staffIdListObj = map.get("staffIdList")) != null) {
            this.staffIdList = (List)staffIdListObj;
        }
        for (i = 0; i < this.orgIdList.size(); ++i) {
            this.orgIdList.set(i, Long.parseLong(this.orgIdList.get(i) + ""));
        }
        for (i = 0; i < this.staffIdList.size(); ++i) {
            this.staffIdList.set(i, Long.parseLong(this.staffIdList.get(i) + ""));
        }
        this.sourceType = map.getOrDefault("sourceType", "").toString();
        String desc = HRStringUtils.equals((String)this.sourceType, (String)"1") ? ResManager.loadKDString((String)"\u4e0d\u5360\u7f16\u89c4\u5219\u53d1\u751f\u53d8\u5316\uff0c\u6b63\u5728\u540c\u6b65\u5360\u7f16\u4fe1\u606f", (String)"SyncSpecialRuleStaffTask_1", (String)"hrmp-haos-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65\u5360\u7f16\u4fe1\u606f\u3002", (String)"SyncSpecialRuleStaffTask_3", (String)"hrmp-haos-business", (Object[])new Object[0]);
        this.feedbackProgress(0, desc, null);
        TXHandle txHandle = TX.requiresNew();
        this.exception = false;
        long start = System.currentTimeMillis();
        try {
            BackGroundTaskSubcriber subscriber = new BackGroundTaskSubcriber(RequestContext.get());
            ThreadPools.executeOnce((String)"task-BackGroundTaskSubcriber", (Runnable)subscriber);
            Date finalStartDate = startDate;
            this.orgIdList.forEach(orgId -> {
                this.iSyncPersonStaffApplication.doSyncBuAllPerson((Long)orgId, finalStartDate);
                this.syncPersonStaffService.cacheSyncIngTag((Long)orgId, false);
            });
            this.staffIdList.forEach(staffId -> {
                this.iSyncPersonStaffApplication.doSyncStaffAllPerson((Long)staffId, finalStartDate);
                this.syncPersonStaffService.cacheStaffSyncIngTag((Long)staffId, false);
            });
        }
        catch (Exception e) {
            this.exception = true;
            logger.error("iSyncPersonStaffApplication failed, orgId {}, staffId {}", this.orgIdList, this.staffIdList);
            logger.error("iSyncPersonStaffApplication Exception", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            this.stop = true;
            this.orgIdList.forEach(orgId -> this.syncPersonStaffService.cacheSyncIngTag((Long)orgId, false));
            this.staffIdList.forEach(staffId -> this.syncPersonStaffService.cacheStaffSyncIngTag((Long)staffId, false));
            txHandle.close();
            long time = System.currentTimeMillis() - start;
            logger.info("iSyncPersonStaffApplication is end. cast {}", (Object)time);
        }
        if (this.exception) {
            throw new KDException(new ErrorCode("kd.hr.haos.business.task.SyncSpecialRuleStaffTask", String.format(ResManager.loadKDString((String)"[\u6279\u91cf\u540c\u6b65]-\u5458\u5de5\u5360\u7f16\u4fe1\u606f\u4efb\u52a1\u5f02\u5e38\u3002\u67e5\u770b\u4efb\u52a1\u5f02\u5e38\u53ca\u91cd\u65b0\u6267\u884c\u8def\u5f84\uff1a\u3010\u7cfb\u7edf\u670d\u52a1\u4e91-\u7cfb\u7edf\u7ba1\u7406-\u8c03\u5ea6\u7ba1\u7406-\u5f02\u5e38\u65e5\u5fd7\u3011\uff0c\u4f5c\u4e1a\u7f16\u7801\uff1a%s", (String)"SyncSpecialRuleStaffTask_0", (String)"hrmp-haos-business", (Object[])new Object[0]), jobNumber)), new Object[0]);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("success", true);
        this.feedbackCustomdata(result);
    }

    class BackGroundTaskSubcriber
    implements Runnable {
        RequestContext rc;

        BackGroundTaskSubcriber(RequestContext rc) {
            this.rc = rc;
        }

        @Override
        public void run() {
            RequestContext.copyAndSet((RequestContext)this.rc);
            int i = 1;
            long halfHour = 1800000L;
            while (true) {
                if (SyncSpecialRuleStaffTask.this.stop) {
                    SyncSpecialRuleStaffTask.this.orgIdList.forEach(orgId -> SyncSpecialRuleStaffTask.this.syncPersonStaffService.cacheSyncIngTag((Long)orgId, false));
                    SyncSpecialRuleStaffTask.this.staffIdList.forEach(staffId -> SyncSpecialRuleStaffTask.this.syncPersonStaffService.cacheStaffSyncIngTag((Long)staffId, false));
                    break;
                }
                int progress = SyncSpecialRuleStaffTask.this.iSyncPersonStaffApplication.getProgress();
                String desc = HRStringUtils.equals((String)SyncSpecialRuleStaffTask.this.sourceType, (String)"1") ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u5360\u7f16\u89c4\u5219\u53d1\u751f\u53d8\u5316\uff0c\u6b63\u5728\u540c\u6b65\u5360\u7f16\u4fe1\u606f\uff0c\u540c\u6b65\u8fdb\u5ea6\u201c%1$s\u201d/\u201c%2$s\u201d\u3002", (String)"SyncSpecialRuleStaffTask_2", (String)"hrmp-haos-business", (Object[])new Object[0]), progress, 100) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u5360\u7f16\u89c4\u5219\u53d1\u751f\u53d8\u5316\uff0c\u6b63\u5728\u540c\u6b65\u5360\u7f16\u4fe1\u606f\uff0c\u540c\u6b65\u8fdb\u5ea6\u201c%1$s\u201d/\u201c%2$s\u201d\u3002", (String)"SyncSpecialRuleStaffTask_4", (String)"hrmp-haos-business", (Object[])new Object[0]), progress, 100);
                SyncSpecialRuleStaffTask.this.feedbackProgress(progress, desc, null);
                if (i == 1 || (long)i % halfHour == 0L) {
                    SyncSpecialRuleStaffTask.this.orgIdList.forEach(orgId -> SyncSpecialRuleStaffTask.this.syncPersonStaffService.cacheSyncIngTag((Long)orgId, true));
                    SyncSpecialRuleStaffTask.this.staffIdList.forEach(staffId -> SyncSpecialRuleStaffTask.this.syncPersonStaffService.cacheStaffSyncIngTag((Long)staffId, true));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {
                    break;
                }
                ++i;
            }
        }
    }
}

